/*
 Navicat Premium Data Transfer

 Source Server         : ceshi
 Source Server Type    : MySQL
 Source Server Version : 50726
 Source Host           : localhost:3306
 Source Schema         : xiaoerhu

 Target Server Type    : MySQL
 Target Server Version : 50726
 File Encoding         : 65001

 Date: 05/04/2022 21:46:54
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for system_auth
-- ----------------------------
DROP TABLE IF EXISTS `system_auth`;
CREATE TABLE `system_auth`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `title` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '权限名称',
  `status` tinyint(3) UNSIGNED NULL DEFAULT 1 COMMENT '权限状态',
  `sort` bigint(20) UNSIGNED NULL DEFAULT 0 COMMENT '排序权重',
  `desc` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '备注说明',
  `create_at` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `index_system_auth_status`(`status`) USING BTREE,
  INDEX `index_system_auth_title`(`title`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 3 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '系统-权限' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of system_auth
-- ----------------------------
INSERT INTO `system_auth` VALUES (1, '测试账号', 1, 0, '拥有全部权限', '2019-10-17 06:04:15');
INSERT INTO `system_auth` VALUES (2, '代理', 1, 0, '代理', '2020-02-06 09:09:03');

-- ----------------------------
-- Table structure for system_auth_node
-- ----------------------------
DROP TABLE IF EXISTS `system_auth_node`;
CREATE TABLE `system_auth_node`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `auth` bigint(20) UNSIGNED NULL DEFAULT NULL COMMENT '角色',
  `node` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '节点',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `index_system_auth_auth`(`auth`) USING BTREE,
  INDEX `index_system_auth_node`(`node`(191)) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 2116 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '系统-权限-授权' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of system_auth_node
-- ----------------------------
INSERT INTO `system_auth_node` VALUES (1918, 2, 'admin');
INSERT INTO `system_auth_node` VALUES (1919, 2, 'admin/agent');
INSERT INTO `system_auth_node` VALUES (1920, 2, 'admin/agent/index');
INSERT INTO `system_auth_node` VALUES (1921, 2, 'admin/agent/add');
INSERT INTO `system_auth_node` VALUES (1922, 2, 'admin/agent/edit');
INSERT INTO `system_auth_node` VALUES (1923, 2, 'admin/agent/pass');
INSERT INTO `system_auth_node` VALUES (1924, 2, 'admin/agent/forbid');
INSERT INTO `system_auth_node` VALUES (1925, 2, 'admin/agent/resume');
INSERT INTO `system_auth_node` VALUES (1926, 2, 'admin/deal');
INSERT INTO `system_auth_node` VALUES (1927, 2, 'admin/deal/order_list');
INSERT INTO `system_auth_node` VALUES (1928, 2, 'admin/deal/user_recharge');
INSERT INTO `system_auth_node` VALUES (1929, 2, 'admin/deal/deposit_list');
INSERT INTO `system_auth_node` VALUES (1930, 2, 'admin/deal/do_deposit');
INSERT INTO `system_auth_node` VALUES (1931, 2, 'admin/group');
INSERT INTO `system_auth_node` VALUES (1932, 2, 'admin/group/index');
INSERT INTO `system_auth_node` VALUES (1933, 2, 'admin/group/add');
INSERT INTO `system_auth_node` VALUES (1934, 2, 'admin/group/edit');
INSERT INTO `system_auth_node` VALUES (1935, 2, 'admin/group/remove');
INSERT INTO `system_auth_node` VALUES (1936, 2, 'admin/group/rule');
INSERT INTO `system_auth_node` VALUES (1937, 2, 'admin/group/rule_add');
INSERT INTO `system_auth_node` VALUES (1938, 2, 'admin/group/rule_edit');
INSERT INTO `system_auth_node` VALUES (1939, 2, 'admin/group/rule_remove');
INSERT INTO `system_auth_node` VALUES (1940, 2, 'admin/index/main');
INSERT INTO `system_auth_node` VALUES (1941, 2, 'admin/index/order_info');
INSERT INTO `system_auth_node` VALUES (1942, 2, 'admin/inyectar');
INSERT INTO `system_auth_node` VALUES (1943, 2, 'admin/inyectar/index');
INSERT INTO `system_auth_node` VALUES (1944, 2, 'admin/inyectar/add');
INSERT INTO `system_auth_node` VALUES (1945, 2, 'admin/inyectar/edit');
INSERT INTO `system_auth_node` VALUES (1946, 2, 'admin/inyectar/remove');
INSERT INTO `system_auth_node` VALUES (1947, 2, 'admin/inyectar/batch_inyectar');
INSERT INTO `system_auth_node` VALUES (1948, 2, 'admin/users');
INSERT INTO `system_auth_node` VALUES (1949, 2, 'admin/users/index');
INSERT INTO `system_auth_node` VALUES (1950, 2, 'admin/users/level');
INSERT INTO `system_auth_node` VALUES (1951, 2, 'admin/users/caiwu');
INSERT INTO `system_auth_node` VALUES (1952, 2, 'admin/users/add_users');
INSERT INTO `system_auth_node` VALUES (1953, 2, 'admin/users/edit_users');
INSERT INTO `system_auth_node` VALUES (1954, 2, 'admin/users/edit_level');
INSERT INTO `system_auth_node` VALUES (1955, 2, 'admin/users/edit_users_ewm');
INSERT INTO `system_auth_node` VALUES (1956, 2, 'admin/users/tuandui');
INSERT INTO `system_auth_node` VALUES (1957, 1, 'admin');
INSERT INTO `system_auth_node` VALUES (1958, 1, 'admin/agent');
INSERT INTO `system_auth_node` VALUES (1959, 1, 'admin/agent/index');
INSERT INTO `system_auth_node` VALUES (1960, 1, 'admin/agent/add');
INSERT INTO `system_auth_node` VALUES (1961, 1, 'admin/agent/edit');
INSERT INTO `system_auth_node` VALUES (1962, 1, 'admin/agent/pass');
INSERT INTO `system_auth_node` VALUES (1963, 1, 'admin/agent/forbid');
INSERT INTO `system_auth_node` VALUES (1964, 1, 'admin/agent/resume');
INSERT INTO `system_auth_node` VALUES (1965, 1, 'admin/auth');
INSERT INTO `system_auth_node` VALUES (1966, 1, 'admin/auth/index');
INSERT INTO `system_auth_node` VALUES (1967, 1, 'admin/auth/apply');
INSERT INTO `system_auth_node` VALUES (1968, 1, 'admin/auth/add');
INSERT INTO `system_auth_node` VALUES (1969, 1, 'admin/auth/edit');
INSERT INTO `system_auth_node` VALUES (1970, 1, 'admin/auth/refresh');
INSERT INTO `system_auth_node` VALUES (1971, 1, 'admin/auth/forbid');
INSERT INTO `system_auth_node` VALUES (1972, 1, 'admin/auth/resume');
INSERT INTO `system_auth_node` VALUES (1973, 1, 'admin/auth/remove');
INSERT INTO `system_auth_node` VALUES (1974, 1, 'admin/config');
INSERT INTO `system_auth_node` VALUES (1975, 1, 'admin/config/info');
INSERT INTO `system_auth_node` VALUES (1976, 1, 'admin/config/clear');
INSERT INTO `system_auth_node` VALUES (1977, 1, 'admin/config/config');
INSERT INTO `system_auth_node` VALUES (1978, 1, 'admin/config/file');
INSERT INTO `system_auth_node` VALUES (1979, 1, 'admin/deal');
INSERT INTO `system_auth_node` VALUES (1980, 1, 'admin/deal/order_list');
INSERT INTO `system_auth_node` VALUES (1981, 1, 'admin/deal/order_status');
INSERT INTO `system_auth_node` VALUES (1982, 1, 'admin/deal/do_user_order');
INSERT INTO `system_auth_node` VALUES (1983, 1, 'admin/deal/deal_console');
INSERT INTO `system_auth_node` VALUES (1984, 1, 'admin/deal/goods_list');
INSERT INTO `system_auth_node` VALUES (1985, 1, 'admin/deal/goods_cate');
INSERT INTO `system_auth_node` VALUES (1986, 1, 'admin/deal/add_goods');
INSERT INTO `system_auth_node` VALUES (1987, 1, 'admin/deal/add_cate');
INSERT INTO `system_auth_node` VALUES (1988, 1, 'admin/deal/edit_goods');
INSERT INTO `system_auth_node` VALUES (1989, 1, 'admin/deal/edit_cate');
INSERT INTO `system_auth_node` VALUES (1990, 1, 'admin/deal/edit_goods_status');
INSERT INTO `system_auth_node` VALUES (1991, 1, 'admin/deal/del_goods');
INSERT INTO `system_auth_node` VALUES (1992, 1, 'admin/deal/del_cate');
INSERT INTO `system_auth_node` VALUES (1993, 1, 'admin/deal/user_recharge');
INSERT INTO `system_auth_node` VALUES (1994, 1, 'admin/deal/edit_recharge');
INSERT INTO `system_auth_node` VALUES (1995, 1, 'admin/deal/deposit_list');
INSERT INTO `system_auth_node` VALUES (1996, 1, 'admin/deal/do_deposit');
INSERT INTO `system_auth_node` VALUES (1997, 1, 'admin/deal/lixibao_log');
INSERT INTO `system_auth_node` VALUES (1998, 1, 'admin/deal/add_lixibao');
INSERT INTO `system_auth_node` VALUES (1999, 1, 'admin/deal/edit_lixibao');
INSERT INTO `system_auth_node` VALUES (2000, 1, 'admin/deal/del_lixibao');
INSERT INTO `system_auth_node` VALUES (2001, 1, 'admin/deal/lixibao_list');
INSERT INTO `system_auth_node` VALUES (2002, 1, 'admin/deal/lxb_forbid');
INSERT INTO `system_auth_node` VALUES (2003, 1, 'admin/deal/lxb_resume');
INSERT INTO `system_auth_node` VALUES (2004, 1, 'admin/deal/do_deposit2');
INSERT INTO `system_auth_node` VALUES (2005, 1, 'admin/deal/daochu');
INSERT INTO `system_auth_node` VALUES (2006, 1, 'admin/deal/do_deposit3');
INSERT INTO `system_auth_node` VALUES (2007, 1, 'admin/deal/do_commission');
INSERT INTO `system_auth_node` VALUES (2008, 1, 'admin/deal/order_commission_list');
INSERT INTO `system_auth_node` VALUES (2009, 1, 'admin/deal/team_reward');
INSERT INTO `system_auth_node` VALUES (2010, 1, 'admin/group');
INSERT INTO `system_auth_node` VALUES (2011, 1, 'admin/group/index');
INSERT INTO `system_auth_node` VALUES (2012, 1, 'admin/group/add');
INSERT INTO `system_auth_node` VALUES (2013, 1, 'admin/group/edit');
INSERT INTO `system_auth_node` VALUES (2014, 1, 'admin/group/remove');
INSERT INTO `system_auth_node` VALUES (2015, 1, 'admin/group/rule');
INSERT INTO `system_auth_node` VALUES (2016, 1, 'admin/group/rule_add');
INSERT INTO `system_auth_node` VALUES (2017, 1, 'admin/group/rule_edit');
INSERT INTO `system_auth_node` VALUES (2018, 1, 'admin/group/rule_remove');
INSERT INTO `system_auth_node` VALUES (2019, 1, 'admin/help');
INSERT INTO `system_auth_node` VALUES (2020, 1, 'admin/help/message_ctrl');
INSERT INTO `system_auth_node` VALUES (2021, 1, 'admin/help/add_message');
INSERT INTO `system_auth_node` VALUES (2022, 1, 'admin/help/edit_message');
INSERT INTO `system_auth_node` VALUES (2023, 1, 'admin/help/del_message');
INSERT INTO `system_auth_node` VALUES (2024, 1, 'admin/help/home_msg');
INSERT INTO `system_auth_node` VALUES (2025, 1, 'admin/help/edit_home_msg');
INSERT INTO `system_auth_node` VALUES (2026, 1, 'admin/help/banner');
INSERT INTO `system_auth_node` VALUES (2027, 1, 'admin/help/edit_banner');
INSERT INTO `system_auth_node` VALUES (2028, 1, 'admin/help/add_banner');
INSERT INTO `system_auth_node` VALUES (2029, 1, 'admin/index');
INSERT INTO `system_auth_node` VALUES (2030, 1, 'admin/index/main');
INSERT INTO `system_auth_node` VALUES (2031, 1, 'admin/index/clearruntime');
INSERT INTO `system_auth_node` VALUES (2032, 1, 'admin/index/buildoptimize');
INSERT INTO `system_auth_node` VALUES (2033, 1, 'admin/index/update');
INSERT INTO `system_auth_node` VALUES (2034, 1, 'admin/index/order_info');
INSERT INTO `system_auth_node` VALUES (2035, 1, 'admin/inyectar');
INSERT INTO `system_auth_node` VALUES (2036, 1, 'admin/inyectar/index');
INSERT INTO `system_auth_node` VALUES (2037, 1, 'admin/inyectar/add');
INSERT INTO `system_auth_node` VALUES (2038, 1, 'admin/inyectar/edit');
INSERT INTO `system_auth_node` VALUES (2039, 1, 'admin/inyectar/remove');
INSERT INTO `system_auth_node` VALUES (2040, 1, 'admin/inyectar/batch_inyectar');
INSERT INTO `system_auth_node` VALUES (2041, 1, 'admin/menu');
INSERT INTO `system_auth_node` VALUES (2042, 1, 'admin/menu/index');
INSERT INTO `system_auth_node` VALUES (2043, 1, 'admin/menu/add');
INSERT INTO `system_auth_node` VALUES (2044, 1, 'admin/menu/edit');
INSERT INTO `system_auth_node` VALUES (2045, 1, 'admin/menu/resume');
INSERT INTO `system_auth_node` VALUES (2046, 1, 'admin/menu/forbid');
INSERT INTO `system_auth_node` VALUES (2047, 1, 'admin/menu/remove');
INSERT INTO `system_auth_node` VALUES (2048, 1, 'admin/oplog');
INSERT INTO `system_auth_node` VALUES (2049, 1, 'admin/oplog/index');
INSERT INTO `system_auth_node` VALUES (2050, 1, 'admin/oplog/clear');
INSERT INTO `system_auth_node` VALUES (2051, 1, 'admin/oplog/remove');
INSERT INTO `system_auth_node` VALUES (2052, 1, 'admin/pay');
INSERT INTO `system_auth_node` VALUES (2053, 1, 'admin/pay/index');
INSERT INTO `system_auth_node` VALUES (2054, 1, 'admin/pay/edit');
INSERT INTO `system_auth_node` VALUES (2055, 1, 'admin/pay/forbid');
INSERT INTO `system_auth_node` VALUES (2056, 1, 'admin/pay/resume');
INSERT INTO `system_auth_node` VALUES (2057, 1, 'admin/pay/set_payout');
INSERT INTO `system_auth_node` VALUES (2058, 1, 'admin/queue');
INSERT INTO `system_auth_node` VALUES (2059, 1, 'admin/queue/index');
INSERT INTO `system_auth_node` VALUES (2060, 1, 'admin/queue/redo');
INSERT INTO `system_auth_node` VALUES (2061, 1, 'admin/queue/processstart');
INSERT INTO `system_auth_node` VALUES (2062, 1, 'admin/queue/processstop');
INSERT INTO `system_auth_node` VALUES (2063, 1, 'admin/queue/remove');
INSERT INTO `system_auth_node` VALUES (2064, 1, 'admin/shop');
INSERT INTO `system_auth_node` VALUES (2065, 1, 'admin/shop/order_list');
INSERT INTO `system_auth_node` VALUES (2066, 1, 'admin/shop/goods_list');
INSERT INTO `system_auth_node` VALUES (2067, 1, 'admin/shop/fahuo');
INSERT INTO `system_auth_node` VALUES (2068, 1, 'admin/shop/goods_cate');
INSERT INTO `system_auth_node` VALUES (2069, 1, 'admin/shop/add_goods');
INSERT INTO `system_auth_node` VALUES (2070, 1, 'admin/shop/add_cate');
INSERT INTO `system_auth_node` VALUES (2071, 1, 'admin/shop/edit_goods');
INSERT INTO `system_auth_node` VALUES (2072, 1, 'admin/shop/edit_cate');
INSERT INTO `system_auth_node` VALUES (2073, 1, 'admin/shop/edit_goods_status');
INSERT INTO `system_auth_node` VALUES (2074, 1, 'admin/shop/del_goods');
INSERT INTO `system_auth_node` VALUES (2075, 1, 'admin/shop/del_cate');
INSERT INTO `system_auth_node` VALUES (2076, 1, 'admin/shop/forbid');
INSERT INTO `system_auth_node` VALUES (2077, 1, 'admin/shop/resume');
INSERT INTO `system_auth_node` VALUES (2078, 1, 'admin/shop/daochu');
INSERT INTO `system_auth_node` VALUES (2079, 1, 'admin/shop/do_deposit3');
INSERT INTO `system_auth_node` VALUES (2080, 1, 'admin/user');
INSERT INTO `system_auth_node` VALUES (2081, 1, 'admin/user/index');
INSERT INTO `system_auth_node` VALUES (2082, 1, 'admin/user/add');
INSERT INTO `system_auth_node` VALUES (2083, 1, 'admin/user/edit');
INSERT INTO `system_auth_node` VALUES (2084, 1, 'admin/user/pass');
INSERT INTO `system_auth_node` VALUES (2085, 1, 'admin/user/forbid');
INSERT INTO `system_auth_node` VALUES (2086, 1, 'admin/user/resume');
INSERT INTO `system_auth_node` VALUES (2087, 1, 'admin/user/remove');
INSERT INTO `system_auth_node` VALUES (2088, 1, 'admin/users');
INSERT INTO `system_auth_node` VALUES (2089, 1, 'admin/users/index');
INSERT INTO `system_auth_node` VALUES (2090, 1, 'admin/users/level');
INSERT INTO `system_auth_node` VALUES (2091, 1, 'admin/users/caiwu');
INSERT INTO `system_auth_node` VALUES (2092, 1, 'admin/users/add_users');
INSERT INTO `system_auth_node` VALUES (2093, 1, 'admin/users/edit_users');
INSERT INTO `system_auth_node` VALUES (2094, 1, 'admin/users/edit_level');
INSERT INTO `system_auth_node` VALUES (2095, 1, 'admin/users/edit_money');
INSERT INTO `system_auth_node` VALUES (2096, 1, 'admin/users/delete_user');
INSERT INTO `system_auth_node` VALUES (2097, 1, 'admin/users/edit_users_ankou');
INSERT INTO `system_auth_node` VALUES (2098, 1, 'admin/users/edit_users_status');
INSERT INTO `system_auth_node` VALUES (2099, 1, 'admin/users/edit_users_address');
INSERT INTO `system_auth_node` VALUES (2100, 1, 'admin/users/edit_users_status2');
INSERT INTO `system_auth_node` VALUES (2101, 1, 'admin/users/edit_users_ewm');
INSERT INTO `system_auth_node` VALUES (2102, 1, 'admin/users/tuandui');
INSERT INTO `system_auth_node` VALUES (2103, 1, 'admin/users/open');
INSERT INTO `system_auth_node` VALUES (2104, 1, 'admin/users/cs_list');
INSERT INTO `system_auth_node` VALUES (2105, 1, 'admin/users/add_cs');
INSERT INTO `system_auth_node` VALUES (2106, 1, 'admin/users/edit_cs_status');
INSERT INTO `system_auth_node` VALUES (2107, 1, 'admin/users/edit_cs');
INSERT INTO `system_auth_node` VALUES (2108, 1, 'admin/users/cs_code');
INSERT INTO `system_auth_node` VALUES (2109, 1, 'admin/users/edit_users_bk');
INSERT INTO `system_auth_node` VALUES (2110, 1, 'admin/users/edit_users_level');
INSERT INTO `system_auth_node` VALUES (2111, 1, 'admin/users/daochu');
INSERT INTO `system_auth_node` VALUES (2112, 1, 'admin/usetting');
INSERT INTO `system_auth_node` VALUES (2113, 1, 'admin/usetting/index');
INSERT INTO `system_auth_node` VALUES (2114, 1, 'admin/usetting/add');
INSERT INTO `system_auth_node` VALUES (2115, 1, 'admin/usetting/edit');

-- ----------------------------
-- Table structure for system_config
-- ----------------------------
DROP TABLE IF EXISTS `system_config`;
CREATE TABLE `system_config`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '配置名',
  `value` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '配置值',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `index_system_config_name`(`name`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 83 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '系统-配置' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of system_config
-- ----------------------------
INSERT INTO `system_config` VALUES (1, 'app_name', 'SHOPF');
INSERT INTO `system_config` VALUES (2, 'site_name', 'SHOPF');
INSERT INTO `system_config` VALUES (3, 'app_version', 'V10');
INSERT INTO `system_config` VALUES (4, 'site_copy', '©版权所有');
INSERT INTO `system_config` VALUES (5, 'site_icon', '/logo.jpg');
INSERT INTO `system_config` VALUES (7, 'miitbeian', '暂无');
INSERT INTO `system_config` VALUES (8, 'storage_type', 'local');
INSERT INTO `system_config` VALUES (9, 'storage_local_exts', '\nphp,doc,gif,icon,jpg,mp3,mp4,p12,pem,phpp,png,rar');
INSERT INTO `system_config` VALUES (10, 'storage_qiniu_bucket', 'https');
INSERT INTO `system_config` VALUES (11, 'storage_qiniu_domain', '用你自己的吧');
INSERT INTO `system_config` VALUES (12, 'storage_qiniu_access_key', '用你自己的吧');
INSERT INTO `system_config` VALUES (13, 'storage_qiniu_secret_key', '用你自己的吧');
INSERT INTO `system_config` VALUES (14, 'storage_oss_bucket', 'cuci-mytest');
INSERT INTO `system_config` VALUES (15, 'storage_oss_endpoint', 'oss-cn-hangzhou.aliyuncs.com');
INSERT INTO `system_config` VALUES (16, 'storage_oss_domain', '用你自己的吧');
INSERT INTO `system_config` VALUES (17, 'storage_oss_keyid', '用你自己的吧');
INSERT INTO `system_config` VALUES (18, 'storage_oss_secret', '用你自己的吧');
INSERT INTO `system_config` VALUES (36, 'storage_oss_is_https', 'http');
INSERT INTO `system_config` VALUES (43, 'storage_qiniu_region', '华东');
INSERT INTO `system_config` VALUES (44, 'storage_qiniu_is_https', 'https');
INSERT INTO `system_config` VALUES (45, 'wechat_mch_id', '1332187001');
INSERT INTO `system_config` VALUES (46, 'wechat_mch_key', 'A82DC5BD1F3359081049C568D8502BC5');
INSERT INTO `system_config` VALUES (47, 'wechat_mch_ssl_type', 'p12');
INSERT INTO `system_config` VALUES (48, 'wechat_mch_ssl_p12', '65b8e4f56718182d/1bc857ee646aa15d.p12');
INSERT INTO `system_config` VALUES (49, 'wechat_mch_ssl_key', 'cc2e3e1345123930/c407d033294f283d.pem');
INSERT INTO `system_config` VALUES (50, 'wechat_mch_ssl_cer', '966eaf89299e9c95/7014872cc109b29a.pem');
INSERT INTO `system_config` VALUES (51, 'wechat_token', 'mytoken');
INSERT INTO `system_config` VALUES (52, 'wechat_appid', 'wx60a43dd8161666d4');
INSERT INTO `system_config` VALUES (53, 'wechat_appsecret', '9978422e0e431643d4b42868d183d60b');
INSERT INTO `system_config` VALUES (54, 'wechat_encodingaeskey', '');
INSERT INTO `system_config` VALUES (55, 'wechat_push_url', '消息推送地址：http://127.0.0.1:8000/wechat/api.push');
INSERT INTO `system_config` VALUES (56, 'wechat_type', 'thr');
INSERT INTO `system_config` VALUES (57, 'wechat_thr_appid', 'wx60a43dd8161666d4');
INSERT INTO `system_config` VALUES (58, 'wechat_thr_appkey', '5caf4b0727f6e46a7e6ccbe773cc955d');
INSERT INTO `system_config` VALUES (60, 'wechat_thr_appurl', '消息推送地址：http://127.0.0.1:2314/wechat/api.push');
INSERT INTO `system_config` VALUES (61, 'component_appid', 'wx28b58798480874f9');
INSERT INTO `system_config` VALUES (62, 'component_appsecret', '8d0e1ec14ea0adc5027dd0ad82c64bc9');
INSERT INTO `system_config` VALUES (63, 'component_token', 'P8QHTIxpBEq88IrxatqhgpBm2OAQROkI');
INSERT INTO `system_config` VALUES (64, 'component_encodingaeskey', 'L5uFIa0U6KLalPyXckyqoVIJYLhsfrg8k9YzybZIHsx');
INSERT INTO `system_config` VALUES (65, 'system_message_state', '0');
INSERT INTO `system_config` VALUES (66, 'sms_zt_username', '可以找CUCI申请');
INSERT INTO `system_config` VALUES (67, 'sms_zt_password', '可以找CUCI申请');
INSERT INTO `system_config` VALUES (68, 'sms_reg_template', '您的验证码为{code}，请在十分钟内完成操作！');
INSERT INTO `system_config` VALUES (69, 'sms_secure', '可以找CUCI申请');
INSERT INTO `system_config` VALUES (70, 'store_title', '测试商城');
INSERT INTO `system_config` VALUES (71, 'store_order_wait_time', '0.50');
INSERT INTO `system_config` VALUES (72, 'store_order_clear_time', '24.00');
INSERT INTO `system_config` VALUES (73, 'store_order_confirm_time', '60.00');
INSERT INTO `system_config` VALUES (74, 'sms_zt_username2', '可以找CUCI申请2');
INSERT INTO `system_config` VALUES (75, 'sms_zt_password2', '可以找CUCI申请2');
INSERT INTO `system_config` VALUES (76, 'sms_secure2', '可以找CUCI申请2');
INSERT INTO `system_config` VALUES (77, 'sms_reg_template2', '您的验证码为{code}，请在十分钟内完成操作！2');
INSERT INTO `system_config` VALUES (78, 'michat_appid', '2882303761518074614');
INSERT INTO `system_config` VALUES (79, 'michat_appkey', '5861807470614');
INSERT INTO `system_config` VALUES (80, 'michat_appsecert', 'CP/WUTUgDuyOxgLQ5ztesg==');
INSERT INTO `system_config` VALUES (81, 'chats_link', 'https://wa.me/553588236216?text=Hello');
INSERT INTO `system_config` VALUES (82, '_token_', 'csrf624020d99cf6b');

-- ----------------------------
-- Table structure for system_data
-- ----------------------------
DROP TABLE IF EXISTS `system_data`;
CREATE TABLE `system_data`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '配置名',
  `value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '配置值',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `index_system_data_name`(`name`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '系统-数据' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of system_data
-- ----------------------------
INSERT INTO `system_data` VALUES (1, 'menudata', '[{\"name\":\"请输入名称\",\"type\":\"scancode_push\",\"key\":\"scancode_push\"}]');

-- ----------------------------
-- Table structure for system_log
-- ----------------------------
DROP TABLE IF EXISTS `system_log`;
CREATE TABLE `system_log`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `node` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '当前操作节点',
  `geoip` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '操作者IP地址',
  `action` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '操作行为名称',
  `content` varchar(4096) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '操作内容描述',
  `username` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '操作人用户名',
  `create_at` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 799 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '系统-日志' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of system_log
-- ----------------------------
INSERT INTO `system_log` VALUES (792, 'admin/oplog/clear', '218.102.123.180', '清理系统日志', '', 'admin', '2022-03-27 16:36:41');
INSERT INTO `system_log` VALUES (793, 'admin/login/index', '127.0.0.1', '系统管理', '用户登录系统成功', 'admin', '2022-04-04 00:42:51');
INSERT INTO `system_log` VALUES (794, 'admin/users/edit_users', '127.0.0.1', '编辑用户', '{\"agent_id\":\"0\",\"agent_service_id\":\"0\",\"user_name\":\"857857\",\"tel\":\"13808570857\",\"balance\":\"36.00\",\"freeze_balance\":\"0.00\",\"level\":\"0\",\"group_id\":\"0\",\"deal_status\":\"1\",\"pwd\":\"123456\",\"pwd2\":\"123456\",\"converNumber\":\"0\",\"parent_id\":\"0\",\"id\":\"202\"}', 'admin', '2022-04-04 00:43:18');
INSERT INTO `system_log` VALUES (795, 'admin/login/index', '127.0.0.1', '系统管理', '用户登录系统成功', 'admin', '2022-04-04 01:23:17');
INSERT INTO `system_log` VALUES (796, 'admin/login/index', '127.0.0.1', '系统管理', '用户登录系统成功', 'admin', '2022-04-05 21:37:55');
INSERT INTO `system_log` VALUES (797, 'admin/users/edit_users', '127.0.0.1', '编辑用户', '{\"agent_id\":\"0\",\"agent_service_id\":\"0\",\"user_name\":\"857857\",\"tel\":\"13808570857\",\"balance\":\"36.00\",\"freeze_balance\":\"0.00\",\"level\":\"0\",\"group_id\":\"0\",\"deal_status\":\"1\",\"pwd\":\"123456\",\"pwd2\":\"123456\",\"converNumber\":\"0\",\"parent_id\":\"0\",\"id\":\"202\"}', 'admin', '2022-04-05 21:38:56');
INSERT INTO `system_log` VALUES (798, 'admin/login/index', '127.0.0.1', '系统管理', '用户登录系统成功', 'admin', '2022-04-05 21:46:36');

-- ----------------------------
-- Table structure for system_menu
-- ----------------------------
DROP TABLE IF EXISTS `system_menu`;
CREATE TABLE `system_menu`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `pid` bigint(20) UNSIGNED NULL DEFAULT 0 COMMENT '父ID',
  `title` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '名称',
  `node` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '节点代码',
  `icon` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '菜单图标',
  `url` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '链接',
  `params` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '链接参数',
  `target` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '_self' COMMENT '打开方式',
  `sort` int(10) UNSIGNED NULL DEFAULT 0 COMMENT '菜单排序',
  `status` tinyint(3) UNSIGNED NULL DEFAULT 1 COMMENT '状态(0:禁用,1:启用)',
  `create_at` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `index_system_menu_node`(`node`(191)) USING BTREE,
  INDEX `index_system_menu_status`(`status`) USING BTREE,
  INDEX `pid`(`pid`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 101 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '系统-菜单' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of system_menu
-- ----------------------------
INSERT INTO `system_menu` VALUES (1, 0, '后台首页', '', '', 'admin/index/main', '', '_self', 500, 1, '2018-09-05 09:59:38');
INSERT INTO `system_menu` VALUES (2, 0, '系统管理', '', '', '#', '', '_self', 0, 1, '2018-09-05 10:04:52');
INSERT INTO `system_menu` VALUES (3, 4, '系统菜单管理', '', 'layui-icon layui-icon-layouts', 'admin/menu/index', '', '_self', 1, 1, '2018-09-05 10:05:26');
INSERT INTO `system_menu` VALUES (4, 2, '系统配置', '', '', '#', '', '_self', 20, 1, '2018-09-05 10:07:17');
INSERT INTO `system_menu` VALUES (5, 12, '系统用户管理', '', 'layui-icon layui-icon-username', 'admin/user/index', '', '_self', 1, 1, '2018-09-06 03:10:42');
INSERT INTO `system_menu` VALUES (7, 12, '访问权限管理', '', 'layui-icon layui-icon-vercode', 'admin/auth/index', '', '_self', 2, 1, '2018-09-06 07:17:14');
INSERT INTO `system_menu` VALUES (11, 4, '系统参数配置', '', 'layui-icon layui-icon-set', 'admin/config/info', '', '_self', 4, 1, '2018-09-06 08:43:47');
INSERT INTO `system_menu` VALUES (12, 2, '权限管理', '', '', '#', '', '_self', 10, 1, '2018-09-06 10:01:31');
INSERT INTO `system_menu` VALUES (62, 0, '角色', '', 'layui-icon layui-icon-username', '#', '', '_self', 19, 1, '2019-10-17 05:43:53');
INSERT INTO `system_menu` VALUES (63, 62, '会员管理', '', '', '#', '', '_self', 99, 1, '2019-10-17 05:44:17');
INSERT INTO `system_menu` VALUES (64, 63, '会员列表', '', 'layui-icon layui-icon-username', 'admin/users/index', '', '_self', 0, 1, '2019-10-17 05:44:45');
INSERT INTO `system_menu` VALUES (65, 0, '帮助中心', '', 'fa fa-flag-o', '#', '', '_self', 2, 1, '2019-10-18 02:42:54');
INSERT INTO `system_menu` VALUES (66, 67, '公告管理', '', 'layui-icon layui-icon-speaker', 'admin/help/message_ctrl', '', '_self', 0, 1, '2019-10-18 02:45:12');
INSERT INTO `system_menu` VALUES (67, 65, '首页文本', '', '', '#', '', '_self', 0, 1, '2019-10-18 06:50:42');
INSERT INTO `system_menu` VALUES (69, 0, '交易', '', 'fa fa-balance-scale', '#', '', '_self', 18, 1, '2019-10-19 06:38:16');
INSERT INTO `system_menu` VALUES (70, 69, '商品管理', '', '', '#', '', '_self', 1, 1, '2019-10-19 06:39:55');
INSERT INTO `system_menu` VALUES (71, 70, '商品列表', '', 'fa fa-shopping-cart', 'admin/deal/goods_list', '', '_self', 0, 1, '2019-10-19 06:40:50');
INSERT INTO `system_menu` VALUES (72, 69, '交易管理', '', '', '#', '', '_self', 2, 1, '2019-10-19 07:31:16');
INSERT INTO `system_menu` VALUES (73, 72, '交易控制', '', 'layui-icon layui-icon-console', 'admin/deal/deal_console', '', '_self', 1, 1, '2019-10-19 07:32:25');
INSERT INTO `system_menu` VALUES (74, 72, '充值管理', '', 'layui-icon layui-icon-chart-screen', 'admin/deal/user_recharge', '', '_self', 3, 1, '2019-10-22 06:15:27');
INSERT INTO `system_menu` VALUES (75, 72, '订单列表', '', 'layui-icon layui-icon-cart-simple', 'admin/deal/order_list', '', '_self', 4, 1, '2019-10-24 08:10:29');
INSERT INTO `system_menu` VALUES (76, 72, '提现管理', '', 'fa fa-legal', 'admin/deal/deposit_list', '', '_self', 2, 1, '2019-10-24 08:44:52');
INSERT INTO `system_menu` VALUES (77, 62, '客服管理', '', '', '#', '', '_self', 0, 1, '2019-10-25 02:01:53');
INSERT INTO `system_menu` VALUES (78, 77, '客服列表', '', 'layui-icon layui-icon-group', 'admin/users/cs_list', '', '_self', 0, 1, '2019-10-25 02:07:17');
INSERT INTO `system_menu` VALUES (79, 77, '客服代码', '', 'layui-icon layui-icon-fonts-code', 'admin/users/cs_code', '', '_self', 0, 1, '2019-10-29 05:53:55');
INSERT INTO `system_menu` VALUES (82, 67, '首页轮播图', '', 'layui-icon layui-icon-carousel', 'admin/help/banner', '', '_self', 0, 1, '2019-12-11 03:21:29');
INSERT INTO `system_menu` VALUES (83, 70, '商品分类', '', '', 'admin/deal/goods_cate', '', '_self', 0, 1, '2020-01-05 03:16:29');
INSERT INTO `system_menu` VALUES (84, 4, '支付方式管理', '', '', 'admin/pay/index', '', '_self', 0, 1, '2020-01-14 12:50:29');
INSERT INTO `system_menu` VALUES (85, 63, '会员等级', '', '', 'admin/users/level', '', '_self', 0, 1, '2020-02-05 08:55:18');
INSERT INTO `system_menu` VALUES (88, 69, '利息宝', '', '', '#', '', '_self', 0, 1, '2020-02-24 18:33:56');
INSERT INTO `system_menu` VALUES (89, 88, '利息宝选项', '', '', '/admin/deal/lixibao_list', '', '_self', 0, 1, '2020-02-24 18:34:53');
INSERT INTO `system_menu` VALUES (90, 88, '利息宝记录', '', '', 'admin/deal/lixibao_log', '', '_self', 0, 1, '2020-02-24 18:35:19');
INSERT INTO `system_menu` VALUES (91, 0, '商城', '', '', '#', '', '_self', 0, 1, '2020-03-05 03:42:10');
INSERT INTO `system_menu` VALUES (92, 91, '商城管理', '', '', '#', '', '_self', 0, 1, '2020-03-05 03:42:29');
INSERT INTO `system_menu` VALUES (93, 92, '商品分类', '', '', 'admin/shop/goods_cate', '', '_self', 0, 1, '2020-03-05 03:42:54');
INSERT INTO `system_menu` VALUES (94, 92, '商品列表', '', '', 'admin/shop/goods_list', '', '_self', 0, 1, '2020-03-05 03:43:06');
INSERT INTO `system_menu` VALUES (95, 92, '订单列表', '', '', 'admin/shop/order_list', '', '_self', 0, 1, '2020-03-05 03:43:16');
INSERT INTO `system_menu` VALUES (96, 67, '首页文本', '', 'fa fa-file-text-o', 'admin/help/home_msg', '', '_self', 0, 1, '2021-04-04 14:53:15');
INSERT INTO `system_menu` VALUES (97, 63, '叠加组', '', 'layui-icon layui-icon-spread-left', 'admin/group/index', '', '_self', 0, 1, '2021-07-26 11:04:15');
INSERT INTO `system_menu` VALUES (98, 62, '代理管理', '', 'layui-icon layui-icon-user', '#', '', '_self', 8, 1, '2021-11-21 06:37:34');
INSERT INTO `system_menu` VALUES (99, 98, '代理列表', '', '', 'agent/index', '', '_self', 0, 1, '2021-11-21 06:38:12');
INSERT INTO `system_menu` VALUES (100, 4, '系统日志管理', '', 'layui-icon layui-icon-form', 'oplog/index', '', '_self', 0, 1, '2021-11-29 07:22:44');

-- ----------------------------
-- Table structure for system_queue
-- ----------------------------
DROP TABLE IF EXISTS `system_queue`;
CREATE TABLE `system_queue`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `title` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '任务名称',
  `data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '执行参数',
  `status` tinyint(3) UNSIGNED NULL DEFAULT 1 COMMENT '任务状态(1新任务,2处理中,3成功,4失败)',
  `preload` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '执行内容',
  `time` bigint(20) UNSIGNED NOT NULL DEFAULT 0 COMMENT '执行时间',
  `double` tinyint(1) NULL DEFAULT 1 COMMENT '单例模式',
  `desc` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '状态描述',
  `start_at` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '开始时间',
  `end_at` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '结束时间',
  `create_at` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `index_system_queue_double`(`double`) USING BTREE,
  INDEX `index_system_queue_time`(`time`) USING BTREE,
  INDEX `index_system_queue_title`(`title`) USING BTREE,
  INDEX `index_system_queue_create_at`(`create_at`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '系统-任务' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for system_user
-- ----------------------------
DROP TABLE IF EXISTS `system_user`;
CREATE TABLE `system_user`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `parent_id` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '上级编号',
  `username` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '用户账号',
  `password` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '用户密码',
  `qq` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '联系QQ',
  `mail` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '联系邮箱',
  `phone` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '联系手机',
  `login_at` datetime(0) NULL DEFAULT NULL COMMENT '登录时间',
  `login_ip` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '登录IP',
  `login_num` bigint(20) UNSIGNED NULL DEFAULT 0 COMMENT '登录次数',
  `authorize` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '权限授权',
  `tags` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '用户标签',
  `desc` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '备注说明',
  `status` tinyint(3) UNSIGNED NULL DEFAULT 1 COMMENT '状态(0禁用,1启用)',
  `is_deleted` tinyint(3) UNSIGNED NULL DEFAULT 0 COMMENT '删除(1删除,0未删)',
  `create_at` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `user_id` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '客服的id',
  `chats` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '客服链接',
  `google_secret` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '谷歌',
  `google_url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '谷歌url',
  `google_is_bind` tinyint(3) UNSIGNED NOT NULL DEFAULT 0 COMMENT '是否绑定',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `index_system_user_username`(`username`) USING BTREE,
  INDEX `index_system_user_status`(`status`) USING BTREE,
  INDEX `index_system_user_deleted`(`is_deleted`) USING BTREE,
  INDEX `user_id`(`user_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 10033 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '系统-用户' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of system_user
-- ----------------------------
INSERT INTO `system_user` VALUES (10000, 0, 'admin', 'fd3a981dbee7d0358600e013ca9144f2', '22222222', '', '', '2022-04-05 21:46:36', '127.0.0.1', 1226, '', '', '', 1, 0, '2015-11-13 07:14:22', 0, '', 'VGMTX2BW2FCYGQF5', 'https://api.qrserver.com/v1/create-qr-code/?data=otpauth%3A%2F%2Ftotp%2FHZW%40qiangdan.cn%3Fsecret%3DVGMTX2BW2FCYGQF5&size=200x200&ecc=M', 1);
INSERT INTO `system_user` VALUES (10020, 0, 'ceshidaili', 'dc483e80a7a0bd9ef71d8cf973673924', '', '', '', '2022-02-20 17:34:07', '58.152.81.110', 11, '2', '', '', 1, 0, '2021-08-07 21:29:00', 0, '#', NULL, NULL, 0);
INSERT INTO `system_user` VALUES (10021, 10020, 'ceshidaili-kefu', '', '', '', '', NULL, '', 0, '2', '', '', 1, 0, '2021-08-08 12:25:14', 172, '', NULL, NULL, 0);
INSERT INTO `system_user` VALUES (10022, 0, 'ceshidalili2', '58cf703f664397ec4f0ac359b84b565c', '', '', '', '2022-03-16 19:55:36', '149.129.190.154', 5, '2', '', '', 1, 0, '2021-11-21 07:38:33', 0, '#', NULL, NULL, 0);
INSERT INTO `system_user` VALUES (10027, 10020, 'a10020', '', '', '', '13800138004', NULL, '', 0, '2', '', '', 1, 0, '2021-11-21 08:05:36', 177, '#', NULL, NULL, 0);
INSERT INTO `system_user` VALUES (10028, 0, 'dddd', '', '', '', '15555555555', NULL, '', 0, '2', '', '', 0, 0, '2022-02-20 17:46:14', 0, '%', NULL, NULL, 0);
INSERT INTO `system_user` VALUES (10029, 0, 'axin2228', 'fffb389c914b492ebe99247b34be93b8', '', '', '13800138002', NULL, '', 0, '', '', '', 1, 1, '2022-03-17 08:54:07', 0, '', NULL, NULL, 0);
INSERT INTO `system_user` VALUES (10030, 0, 'axin22228', '3a300c48b47b714d9821dc473304aa84', '', '', '13800138001', NULL, '', 0, '2', '', '', 1, 0, '2022-03-17 20:26:12', 0, 'www.baidu.com', NULL, NULL, 0);
INSERT INTO `system_user` VALUES (10031, 0, 'jkghdgl', 'fffb389c914b492ebe99247b34be93b8', '', '', '13800138003', NULL, '', 0, '', '', '', 1, 1, '2022-03-18 09:09:47', 0, '&', NULL, NULL, 0);
INSERT INTO `system_user` VALUES (10032, 0, 'axin6456494', 'fffb389c914b492ebe99247b34be93b8', '', '', '13800138004', NULL, '', 0, '', '', '', 1, 1, '2022-03-18 09:16:29', 0, '', NULL, NULL, 0);

-- ----------------------------
-- Table structure for xy_balance_log
-- ----------------------------
DROP TABLE IF EXISTS `xy_balance_log`;
CREATE TABLE `xy_balance_log`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL COMMENT '会员ID',
  `sid` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '交易对象id',
  `oid` char(18) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '交易单号',
  `num` decimal(15, 2) NOT NULL COMMENT '交易金额',
  `type` int(11) NOT NULL COMMENT '交易类型 0系统 1充值 2交易 3返佣 4强制交易 5推广返佣 6下级交易返佣  7提现',
  `status` int(11) NULL DEFAULT 1 COMMENT '收入1 支出2',
  `addtime` int(11) NOT NULL COMMENT '添加时间',
  `f_lv` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `oid`(`oid`) USING BTREE,
  INDEX `uid`(`uid`) USING BTREE,
  INDEX `addtime`(`addtime`) USING BTREE,
  INDEX `type`(`type`) USING BTREE,
  INDEX `sid`(`sid`) USING BTREE,
  INDEX `status`(`status`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 4340 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '会员-收支明细表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of xy_balance_log
-- ----------------------------
INSERT INTO `xy_balance_log` VALUES (2366, 0, 0, 'SY2108010703284721', 5.00, 5, 1, 1627812227, NULL);
INSERT INTO `xy_balance_log` VALUES (2377, 0, 0, 'SY2108010717538843', 25.00, 5, 1, 1627813077, NULL);
INSERT INTO `xy_balance_log` VALUES (2431, 0, 0, 'SY2108010741345993', 25.00, 5, 1, 1627814496, NULL);
INSERT INTO `xy_balance_log` VALUES (2478, 0, 0, 'SY2108010813133328', 15.00, 5, 1, 1627816401, NULL);
INSERT INTO `xy_balance_log` VALUES (2504, 0, 0, 'SY2108010820517167', 15.50, 5, 1, 1627816859, NULL);
INSERT INTO `xy_balance_log` VALUES (2533, 0, 0, 'SY2108010844135191', 15.00, 5, 1, 1627818261, NULL);
INSERT INTO `xy_balance_log` VALUES (2557, 0, 0, 'SY2108010852593753', 15.25, 5, 1, 1627818783, NULL);
INSERT INTO `xy_balance_log` VALUES (2604, 0, 0, 'SY2108010911508363', 250.00, 5, 1, 1627819939, NULL);
INSERT INTO `xy_balance_log` VALUES (2732, 0, 0, 'SY2109261206544782', 10.00, 5, 1, 1637858896, NULL);
INSERT INTO `xy_balance_log` VALUES (2752, 179, 179, 'UB2201020141434706', 15.00, 2, 2, 1641058911, NULL);
INSERT INTO `xy_balance_log` VALUES (2753, 179, 179, 'UB2201020141434706', 0.08, 3, 1, 1641058911, NULL);
INSERT INTO `xy_balance_log` VALUES (2754, 179, 179, 'UB2201020141434706', 15.00, 2, 1, 1641058911, NULL);
INSERT INTO `xy_balance_log` VALUES (2755, 171, 179, 'UB2201020141434706', 0.00, 6, 1, 1641058911, NULL);
INSERT INTO `xy_balance_log` VALUES (2756, 179, 179, 'UB2201020143457930', 130.00, 2, 2, 1641059032, NULL);
INSERT INTO `xy_balance_log` VALUES (2757, 179, 179, 'UB2201020143457930', 0.68, 3, 1, 1641059032, NULL);
INSERT INTO `xy_balance_log` VALUES (2758, 179, 179, 'UB2201020143457930', 130.00, 2, 1, 1641059032, NULL);
INSERT INTO `xy_balance_log` VALUES (2759, 171, 179, 'UB2201020143457930', 0.03, 6, 1, 1641059032, NULL);
INSERT INTO `xy_balance_log` VALUES (2760, 171, 0, 'CO2201180044176200', 300.00, 7, 2, 1642437857, NULL);
INSERT INTO `xy_balance_log` VALUES (2761, 171, 0, 'CO2201180044176200', 300.00, 8, 1, 1644324739, NULL);
INSERT INTO `xy_balance_log` VALUES (2762, 180, 0, 'SY2202082121243522', 5000.00, 1, 1, 1644326504, NULL);
INSERT INTO `xy_balance_log` VALUES (2763, 0, 0, 'SY2202082121243522', 250.00, 5, 1, 1644326504, NULL);
INSERT INTO `xy_balance_log` VALUES (2764, 180, 0, 'SY2202082122399637', 95000.00, 1, 1, 1644326580, NULL);
INSERT INTO `xy_balance_log` VALUES (2765, 180, 180, 'UB2202082139142509', 44721.00, 2, 2, 1644327589, NULL);
INSERT INTO `xy_balance_log` VALUES (2766, 180, 180, 'UB2202082139142509', 348.82, 3, 1, 1644327589, NULL);
INSERT INTO `xy_balance_log` VALUES (2767, 180, 180, 'UB2202082139142509', 44721.00, 2, 1, 1644327589, NULL);
INSERT INTO `xy_balance_log` VALUES (2768, 180, 180, 'UB2202082141235964', 100349.00, 2, 2, 1644327736, NULL);
INSERT INTO `xy_balance_log` VALUES (2769, 180, 180, 'UB2202082141235964', 782.72, 3, 1, 1644327736, NULL);
INSERT INTO `xy_balance_log` VALUES (2770, 180, 180, 'UB2202082141235964', 100349.00, 2, 1, 1644327736, NULL);
INSERT INTO `xy_balance_log` VALUES (2771, 171, 171, 'UB2202082153331806', 54237.00, 2, 2, 1644328424, NULL);
INSERT INTO `xy_balance_log` VALUES (2772, 171, 171, 'UB2202082153331806', 412.20, 3, 1, 1644328424, NULL);
INSERT INTO `xy_balance_log` VALUES (2773, 171, 171, 'UB2202082153331806', 54237.00, 2, 1, 1644328424, NULL);
INSERT INTO `xy_balance_log` VALUES (2774, 171, 171, 'UB2202082157226077', 38350.00, 2, 2, 1644328651, NULL);
INSERT INTO `xy_balance_log` VALUES (2775, 171, 171, 'UB2202082157226077', 291.46, 3, 1, 1644328651, NULL);
INSERT INTO `xy_balance_log` VALUES (2776, 171, 171, 'UB2202082157226077', 38350.00, 2, 1, 1644328651, NULL);
INSERT INTO `xy_balance_log` VALUES (2777, 171, 171, 'UB2202082207309240', 69407.00, 2, 2, 1644329260, NULL);
INSERT INTO `xy_balance_log` VALUES (2778, 171, 171, 'UB2202082207309240', 527.49, 3, 1, 1644329260, NULL);
INSERT INTO `xy_balance_log` VALUES (2779, 171, 171, 'UB2202082207309240', 69407.00, 2, 1, 1644329260, NULL);
INSERT INTO `xy_balance_log` VALUES (2780, 171, 171, 'UB2202082207464651', 71927.00, 2, 2, 1644329277, NULL);
INSERT INTO `xy_balance_log` VALUES (2781, 171, 171, 'UB2202082207464651', 546.65, 3, 1, 1644329277, NULL);
INSERT INTO `xy_balance_log` VALUES (2782, 171, 171, 'UB2202082207464651', 71927.00, 2, 1, 1644329277, NULL);
INSERT INTO `xy_balance_log` VALUES (2783, 171, 171, 'UB2202082208065853', 57957.00, 2, 2, 1644329295, NULL);
INSERT INTO `xy_balance_log` VALUES (2784, 171, 171, 'UB2202082208065853', 440.47, 3, 1, 1644329295, NULL);
INSERT INTO `xy_balance_log` VALUES (2785, 171, 171, 'UB2202082208065853', 57957.00, 2, 1, 1644329295, NULL);
INSERT INTO `xy_balance_log` VALUES (2786, 171, 171, 'UB2202082209425203', 57656.00, 2, 2, 1644329389, NULL);
INSERT INTO `xy_balance_log` VALUES (2787, 171, 171, 'UB2202082209425203', 8648.40, 3, 1, 1644329389, NULL);
INSERT INTO `xy_balance_log` VALUES (2788, 171, 171, 'UB2202082209425203', 57656.00, 2, 1, 1644329389, NULL);
INSERT INTO `xy_balance_log` VALUES (2789, 171, 171, 'UB2202082210008738', 88595.00, 2, 2, 1644329409, NULL);
INSERT INTO `xy_balance_log` VALUES (2790, 171, 171, 'UB2202082210008738', 13289.25, 3, 1, 1644329409, NULL);
INSERT INTO `xy_balance_log` VALUES (2791, 171, 171, 'UB2202082210008738', 88595.00, 2, 1, 1644329409, NULL);
INSERT INTO `xy_balance_log` VALUES (2792, 171, 181, '', 0.50, 5, 1, 1644331912, NULL);
INSERT INTO `xy_balance_log` VALUES (2793, 181, 0, 'SY2202082258574540', 1000.00, 1, 1, 1644332385, NULL);
INSERT INTO `xy_balance_log` VALUES (2794, 171, 0, 'SY2202082258574540', 50.00, 5, 1, 1644332385, NULL);
INSERT INTO `xy_balance_log` VALUES (2795, 181, 0, 'SY2202082258574540', 1000.00, 1, 1, 1644332386, NULL);
INSERT INTO `xy_balance_log` VALUES (2796, 181, 181, 'UB2202082302371213', 1139.00, 2, 2, 1644332574, NULL);
INSERT INTO `xy_balance_log` VALUES (2797, 181, 181, 'UB2202082302371213', 6.61, 3, 1, 1644332574, NULL);
INSERT INTO `xy_balance_log` VALUES (2798, 181, 181, 'UB2202082302371213', 1139.00, 2, 1, 1644332574, NULL);
INSERT INTO `xy_balance_log` VALUES (2799, 171, 181, 'UB2202082302371213', 1.06, 6, 1, 1644332574, NULL);
INSERT INTO `xy_balance_log` VALUES (2800, 181, 181, 'UB2202082303016634', 683.00, 2, 2, 1644332594, NULL);
INSERT INTO `xy_balance_log` VALUES (2801, 181, 181, 'UB2202082303016634', 3.96, 3, 1, 1644332594, NULL);
INSERT INTO `xy_balance_log` VALUES (2802, 181, 181, 'UB2202082303016634', 683.00, 2, 1, 1644332594, NULL);
INSERT INTO `xy_balance_log` VALUES (2803, 171, 181, 'UB2202082303016634', 0.63, 6, 1, 1644332594, NULL);
INSERT INTO `xy_balance_log` VALUES (2804, 181, 181, 'UB2202082303215832', 1043.00, 2, 2, 1644332608, NULL);
INSERT INTO `xy_balance_log` VALUES (2805, 181, 181, 'UB2202082303215832', 6.05, 3, 1, 1644332608, NULL);
INSERT INTO `xy_balance_log` VALUES (2806, 181, 181, 'UB2202082303215832', 1043.00, 2, 1, 1644332608, NULL);
INSERT INTO `xy_balance_log` VALUES (2807, 171, 181, 'UB2202082303215832', 0.97, 6, 1, 1644332608, NULL);
INSERT INTO `xy_balance_log` VALUES (2808, 181, 181, 'UB2202082303367119', 1694.00, 2, 2, 1644332623, NULL);
INSERT INTO `xy_balance_log` VALUES (2809, 181, 181, 'UB2202082303367119', 9.83, 3, 1, 1644332623, NULL);
INSERT INTO `xy_balance_log` VALUES (2810, 181, 181, 'UB2202082303367119', 1694.00, 2, 1, 1644332623, NULL);
INSERT INTO `xy_balance_log` VALUES (2811, 171, 181, 'UB2202082303367119', 1.57, 6, 1, 1644332623, NULL);
INSERT INTO `xy_balance_log` VALUES (2812, 181, 181, 'UB2202082303498297', 1233.00, 2, 2, 1644332636, NULL);
INSERT INTO `xy_balance_log` VALUES (2813, 181, 181, 'UB2202082303498297', 7.15, 3, 1, 1644332636, NULL);
INSERT INTO `xy_balance_log` VALUES (2814, 181, 181, 'UB2202082303498297', 1233.00, 2, 1, 1644332636, NULL);
INSERT INTO `xy_balance_log` VALUES (2815, 171, 181, 'UB2202082303498297', 1.14, 6, 1, 1644332636, NULL);
INSERT INTO `xy_balance_log` VALUES (2816, 181, 181, 'UB2202082304037361', 1922.00, 2, 2, 1644332650, NULL);
INSERT INTO `xy_balance_log` VALUES (2817, 181, 181, 'UB2202082304037361', 11.15, 3, 1, 1644332650, NULL);
INSERT INTO `xy_balance_log` VALUES (2818, 181, 181, 'UB2202082304037361', 1922.00, 2, 1, 1644332650, NULL);
INSERT INTO `xy_balance_log` VALUES (2819, 171, 181, 'UB2202082304037361', 1.78, 6, 1, 1644332650, NULL);
INSERT INTO `xy_balance_log` VALUES (2820, 181, 181, 'UB2202082304177331', 1234.00, 2, 2, 1644332664, NULL);
INSERT INTO `xy_balance_log` VALUES (2821, 181, 181, 'UB2202082304177331', 7.16, 3, 1, 1644332664, NULL);
INSERT INTO `xy_balance_log` VALUES (2822, 181, 181, 'UB2202082304177331', 1234.00, 2, 1, 1644332664, NULL);
INSERT INTO `xy_balance_log` VALUES (2823, 171, 181, 'UB2202082304177331', 1.15, 6, 1, 1644332664, NULL);
INSERT INTO `xy_balance_log` VALUES (2824, 181, 181, 'UB2202082304312518', 2348.00, 2, 2, 1644332678, NULL);
INSERT INTO `xy_balance_log` VALUES (2825, 181, 181, 'UB2202082304312518', 13.62, 3, 1, 1644332678, NULL);
INSERT INTO `xy_balance_log` VALUES (2826, 181, 181, 'UB2202082304312518', 2348.00, 2, 1, 1644332678, NULL);
INSERT INTO `xy_balance_log` VALUES (2827, 171, 181, 'UB2202082304312518', 2.18, 6, 1, 1644332678, NULL);
INSERT INTO `xy_balance_log` VALUES (2828, 181, 181, 'UB2202082304488626', 1787.00, 2, 2, 1644332695, NULL);
INSERT INTO `xy_balance_log` VALUES (2829, 181, 181, 'UB2202082304488626', 10.36, 3, 1, 1644332695, NULL);
INSERT INTO `xy_balance_log` VALUES (2830, 181, 181, 'UB2202082304488626', 1787.00, 2, 1, 1644332695, NULL);
INSERT INTO `xy_balance_log` VALUES (2831, 171, 181, 'UB2202082304488626', 1.66, 6, 1, 1644332695, NULL);
INSERT INTO `xy_balance_log` VALUES (2832, 181, 181, 'UB2202082305135238', 2221.00, 2, 2, 1644332720, NULL);
INSERT INTO `xy_balance_log` VALUES (2833, 181, 181, 'UB2202082305135238', 12.88, 3, 1, 1644332720, NULL);
INSERT INTO `xy_balance_log` VALUES (2834, 181, 181, 'UB2202082305135238', 2221.00, 2, 1, 1644332720, NULL);
INSERT INTO `xy_balance_log` VALUES (2835, 171, 181, 'UB2202082305135238', 2.06, 6, 1, 1644332720, NULL);
INSERT INTO `xy_balance_log` VALUES (2836, 181, 181, 'UB2202082305474826', 2129.00, 2, 2, 1644332755, NULL);
INSERT INTO `xy_balance_log` VALUES (2837, 181, 181, 'UB2202082305474826', 12.35, 3, 1, 1644332755, NULL);
INSERT INTO `xy_balance_log` VALUES (2838, 181, 181, 'UB2202082305474826', 2129.00, 2, 1, 1644332755, NULL);
INSERT INTO `xy_balance_log` VALUES (2839, 171, 181, 'UB2202082305474826', 1.98, 6, 1, 1644332755, NULL);
INSERT INTO `xy_balance_log` VALUES (2840, 181, 181, 'UB2202082306022217', 2399.00, 2, 2, 1644332769, NULL);
INSERT INTO `xy_balance_log` VALUES (2841, 181, 181, 'UB2202082306022217', 13.91, 3, 1, 1644332769, NULL);
INSERT INTO `xy_balance_log` VALUES (2842, 181, 181, 'UB2202082306022217', 2399.00, 2, 1, 1644332769, NULL);
INSERT INTO `xy_balance_log` VALUES (2843, 171, 181, 'UB2202082306022217', 2.23, 6, 1, 1644332769, NULL);
INSERT INTO `xy_balance_log` VALUES (2844, 181, 181, 'UB2202082306156506', 1566.00, 2, 2, 1644332783, NULL);
INSERT INTO `xy_balance_log` VALUES (2845, 181, 181, 'UB2202082306156506', 9.08, 3, 1, 1644332783, NULL);
INSERT INTO `xy_balance_log` VALUES (2846, 181, 181, 'UB2202082306156506', 1566.00, 2, 1, 1644332783, NULL);
INSERT INTO `xy_balance_log` VALUES (2847, 171, 181, 'UB2202082306156506', 1.45, 6, 1, 1644332783, NULL);
INSERT INTO `xy_balance_log` VALUES (2848, 181, 181, 'UB2202082306297619', 2193.00, 2, 2, 1644332796, NULL);
INSERT INTO `xy_balance_log` VALUES (2849, 181, 181, 'UB2202082306297619', 12.72, 3, 1, 1644332796, NULL);
INSERT INTO `xy_balance_log` VALUES (2850, 181, 181, 'UB2202082306297619', 2193.00, 2, 1, 1644332796, NULL);
INSERT INTO `xy_balance_log` VALUES (2851, 171, 181, 'UB2202082306297619', 2.04, 6, 1, 1644332796, NULL);
INSERT INTO `xy_balance_log` VALUES (2852, 181, 181, 'UB2202082307113064', 1371.00, 2, 2, 1644332843, NULL);
INSERT INTO `xy_balance_log` VALUES (2853, 181, 181, 'UB2202082307113064', 7.95, 3, 1, 1644332843, NULL);
INSERT INTO `xy_balance_log` VALUES (2854, 181, 181, 'UB2202082307113064', 1371.00, 2, 1, 1644332843, NULL);
INSERT INTO `xy_balance_log` VALUES (2855, 171, 181, 'UB2202082307113064', 1.27, 6, 1, 1644332843, NULL);
INSERT INTO `xy_balance_log` VALUES (2856, 181, 181, 'UB2202082307303087', 1231.00, 2, 2, 1644332857, NULL);
INSERT INTO `xy_balance_log` VALUES (2857, 181, 181, 'UB2202082307303087', 7.14, 3, 1, 1644332857, NULL);
INSERT INTO `xy_balance_log` VALUES (2858, 181, 181, 'UB2202082307303087', 1231.00, 2, 1, 1644332857, NULL);
INSERT INTO `xy_balance_log` VALUES (2859, 171, 181, 'UB2202082307303087', 1.14, 6, 1, 1644332857, NULL);
INSERT INTO `xy_balance_log` VALUES (2860, 181, 181, 'UB2202082312423578', 997.00, 2, 2, 1644333170, NULL);
INSERT INTO `xy_balance_log` VALUES (2861, 181, 181, 'UB2202082312423578', 5.78, 3, 1, 1644333170, NULL);
INSERT INTO `xy_balance_log` VALUES (2862, 181, 181, 'UB2202082312423578', 997.00, 2, 1, 1644333170, NULL);
INSERT INTO `xy_balance_log` VALUES (2863, 171, 181, 'UB2202082312423578', 0.92, 6, 1, 1644333170, NULL);
INSERT INTO `xy_balance_log` VALUES (2864, 181, 181, 'UB2202082315485544', 2364.00, 2, 2, 1644333356, NULL);
INSERT INTO `xy_balance_log` VALUES (2865, 181, 181, 'UB2202082315485544', 6099.12, 3, 1, 1644333356, NULL);
INSERT INTO `xy_balance_log` VALUES (2866, 181, 181, 'UB2202082315485544', 2364.00, 2, 1, 1644333356, NULL);
INSERT INTO `xy_balance_log` VALUES (2867, 171, 181, 'UB2202082315485544', 975.86, 6, 1, 1644333356, NULL);
INSERT INTO `xy_balance_log` VALUES (2868, 181, 182, '', 0.50, 5, 1, 1644387195, NULL);
INSERT INTO `xy_balance_log` VALUES (2869, 181, 183, '', 0.50, 5, 1, 1644387243, NULL);
INSERT INTO `xy_balance_log` VALUES (2870, 181, 184, '', 0.50, 5, 1, 1644387245, NULL);
INSERT INTO `xy_balance_log` VALUES (2871, 181, 185, '', 0.50, 5, 1, 1644387310, NULL);
INSERT INTO `xy_balance_log` VALUES (2872, 184, 0, 'SY2202091416039005', 500.00, 1, 1, 1644387374, NULL);
INSERT INTO `xy_balance_log` VALUES (2873, 181, 0, 'SY2202091416039005', 25.00, 5, 1, 1644387374, NULL);
INSERT INTO `xy_balance_log` VALUES (2874, 184, 184, 'UB2202091418182663', 171.00, 2, 2, 1644387506, NULL);
INSERT INTO `xy_balance_log` VALUES (2875, 184, 184, 'UB2202091418182663', 0.89, 3, 1, 1644387506, NULL);
INSERT INTO `xy_balance_log` VALUES (2876, 184, 184, 'UB2202091418182663', 171.00, 2, 1, 1644387506, NULL);
INSERT INTO `xy_balance_log` VALUES (2877, 171, 184, 'UB2202091418182663', 0.08, 6, 1, 1644387506, NULL);
INSERT INTO `xy_balance_log` VALUES (2878, 181, 184, 'UB2202091418182663', 0.12, 6, 1, 1644387506, NULL);
INSERT INTO `xy_balance_log` VALUES (2879, 184, 184, 'UB2202091418384200', 207.00, 2, 2, 1644387525, NULL);
INSERT INTO `xy_balance_log` VALUES (2880, 184, 184, 'UB2202091418384200', 1.08, 3, 1, 1644387525, NULL);
INSERT INTO `xy_balance_log` VALUES (2881, 184, 184, 'UB2202091418384200', 207.00, 2, 1, 1644387525, NULL);
INSERT INTO `xy_balance_log` VALUES (2882, 171, 184, 'UB2202091418384200', 0.10, 6, 1, 1644387525, NULL);
INSERT INTO `xy_balance_log` VALUES (2883, 181, 184, 'UB2202091418384200', 0.14, 6, 1, 1644387525, NULL);
INSERT INTO `xy_balance_log` VALUES (2884, 184, 184, 'UB2202091419037900', 155.00, 2, 2, 1644387550, NULL);
INSERT INTO `xy_balance_log` VALUES (2885, 184, 184, 'UB2202091419037900', 0.81, 3, 1, 1644387550, NULL);
INSERT INTO `xy_balance_log` VALUES (2886, 184, 184, 'UB2202091419037900', 155.00, 2, 1, 1644387550, NULL);
INSERT INTO `xy_balance_log` VALUES (2887, 171, 184, 'UB2202091419037900', 0.07, 6, 1, 1644387550, NULL);
INSERT INTO `xy_balance_log` VALUES (2888, 181, 184, 'UB2202091419037900', 0.11, 6, 1, 1644387550, NULL);
INSERT INTO `xy_balance_log` VALUES (2889, 184, 184, 'UB2202091419173994', 280.00, 2, 2, 1644387565, NULL);
INSERT INTO `xy_balance_log` VALUES (2890, 184, 184, 'UB2202091419173994', 1.46, 3, 1, 1644387565, NULL);
INSERT INTO `xy_balance_log` VALUES (2891, 184, 184, 'UB2202091419173994', 280.00, 2, 1, 1644387565, NULL);
INSERT INTO `xy_balance_log` VALUES (2892, 171, 184, 'UB2202091419173994', 0.13, 6, 1, 1644387565, NULL);
INSERT INTO `xy_balance_log` VALUES (2893, 181, 184, 'UB2202091419173994', 0.19, 6, 1, 1644387565, NULL);
INSERT INTO `xy_balance_log` VALUES (2894, 184, 184, 'UB2202091419319447', 101.00, 2, 2, 1644387578, NULL);
INSERT INTO `xy_balance_log` VALUES (2895, 184, 184, 'UB2202091419319447', 0.53, 3, 1, 1644387578, NULL);
INSERT INTO `xy_balance_log` VALUES (2896, 184, 184, 'UB2202091419319447', 101.00, 2, 1, 1644387578, NULL);
INSERT INTO `xy_balance_log` VALUES (2897, 171, 184, 'UB2202091419319447', 0.05, 6, 1, 1644387578, NULL);
INSERT INTO `xy_balance_log` VALUES (2898, 181, 184, 'UB2202091419319447', 0.07, 6, 1, 1644387578, NULL);
INSERT INTO `xy_balance_log` VALUES (2899, 181, 186, '', 0.50, 5, 1, 1644387715, NULL);
INSERT INTO `xy_balance_log` VALUES (2900, 183, 0, 'SY2202091422044806', 500.00, 1, 1, 1644387864, NULL);
INSERT INTO `xy_balance_log` VALUES (2901, 181, 0, 'SY2202091422044806', 25.00, 5, 1, 1644387864, NULL);
INSERT INTO `xy_balance_log` VALUES (2902, 183, 183, 'UB2202091426288603', 110.00, 2, 2, 1644387996, NULL);
INSERT INTO `xy_balance_log` VALUES (2903, 183, 183, 'UB2202091426288603', 0.57, 3, 1, 1644387996, NULL);
INSERT INTO `xy_balance_log` VALUES (2904, 183, 183, 'UB2202091426288603', 110.00, 2, 1, 1644387996, NULL);
INSERT INTO `xy_balance_log` VALUES (2905, 171, 183, 'UB2202091426288603', 0.05, 6, 1, 1644387996, NULL);
INSERT INTO `xy_balance_log` VALUES (2906, 181, 183, 'UB2202091426288603', 0.07, 6, 1, 1644387996, NULL);
INSERT INTO `xy_balance_log` VALUES (2907, 183, 183, 'UB2202091426474247', 257.00, 2, 2, 1644388019, NULL);
INSERT INTO `xy_balance_log` VALUES (2908, 183, 183, 'UB2202091426474247', 1.34, 3, 1, 1644388019, NULL);
INSERT INTO `xy_balance_log` VALUES (2909, 183, 183, 'UB2202091426474247', 257.00, 2, 1, 1644388019, NULL);
INSERT INTO `xy_balance_log` VALUES (2910, 171, 183, 'UB2202091426474247', 0.12, 6, 1, 1644388019, NULL);
INSERT INTO `xy_balance_log` VALUES (2911, 181, 183, 'UB2202091426474247', 0.17, 6, 1, 1644388019, NULL);
INSERT INTO `xy_balance_log` VALUES (2912, 183, 183, 'UB2202091427078095', 364.00, 2, 2, 1644388036, NULL);
INSERT INTO `xy_balance_log` VALUES (2913, 183, 183, 'UB2202091427078095', 1.89, 3, 1, 1644388036, NULL);
INSERT INTO `xy_balance_log` VALUES (2914, 183, 183, 'UB2202091427078095', 364.00, 2, 1, 1644388036, NULL);
INSERT INTO `xy_balance_log` VALUES (2915, 171, 183, 'UB2202091427078095', 0.17, 6, 1, 1644388036, NULL);
INSERT INTO `xy_balance_log` VALUES (2916, 181, 183, 'UB2202091427078095', 0.25, 6, 1, 1644388036, NULL);
INSERT INTO `xy_balance_log` VALUES (2917, 186, 0, 'SY2202091425298790', 300.00, 1, 1, 1644388040, NULL);
INSERT INTO `xy_balance_log` VALUES (2918, 181, 0, 'SY2202091425298790', 15.00, 5, 1, 1644388040, NULL);
INSERT INTO `xy_balance_log` VALUES (2919, 182, 0, 'SY2202091426283136', 500.00, 1, 1, 1644388044, NULL);
INSERT INTO `xy_balance_log` VALUES (2920, 181, 0, 'SY2202091426283136', 25.00, 5, 1, 1644388044, NULL);
INSERT INTO `xy_balance_log` VALUES (2921, 183, 183, 'UB2202091427252722', 181.00, 2, 2, 1644388052, NULL);
INSERT INTO `xy_balance_log` VALUES (2922, 183, 183, 'UB2202091427252722', 0.94, 3, 1, 1644388052, NULL);
INSERT INTO `xy_balance_log` VALUES (2923, 183, 183, 'UB2202091427252722', 181.00, 2, 1, 1644388052, NULL);
INSERT INTO `xy_balance_log` VALUES (2924, 171, 183, 'UB2202091427252722', 0.08, 6, 1, 1644388052, NULL);
INSERT INTO `xy_balance_log` VALUES (2925, 181, 183, 'UB2202091427252722', 0.12, 6, 1, 1644388052, NULL);
INSERT INTO `xy_balance_log` VALUES (2926, 183, 183, 'UB2202091427425768', 316.00, 2, 2, 1644388069, NULL);
INSERT INTO `xy_balance_log` VALUES (2927, 183, 183, 'UB2202091427425768', 1.64, 3, 1, 1644388069, NULL);
INSERT INTO `xy_balance_log` VALUES (2928, 183, 183, 'UB2202091427425768', 316.00, 2, 1, 1644388069, NULL);
INSERT INTO `xy_balance_log` VALUES (2929, 171, 183, 'UB2202091427425768', 0.15, 6, 1, 1644388069, NULL);
INSERT INTO `xy_balance_log` VALUES (2930, 181, 183, 'UB2202091427425768', 0.21, 6, 1, 1644388069, NULL);
INSERT INTO `xy_balance_log` VALUES (2931, 184, 0, 'CO2202091433372065', 455.00, 7, 2, 1644388417, NULL);
INSERT INTO `xy_balance_log` VALUES (2932, 183, 0, 'CO2202091434309439', 450.00, 7, 2, 1644388470, NULL);
INSERT INTO `xy_balance_log` VALUES (2933, 181, 0, '1', 1000.00, 21, 2, 1644389050, NULL);
INSERT INTO `xy_balance_log` VALUES (2934, 182, 182, 'UB2202091452008426', 388.00, 2, 2, 1644389536, NULL);
INSERT INTO `xy_balance_log` VALUES (2935, 182, 182, 'UB2202091452008426', 2.02, 3, 1, 1644389536, NULL);
INSERT INTO `xy_balance_log` VALUES (2936, 182, 182, 'UB2202091452008426', 388.00, 2, 1, 1644389536, NULL);
INSERT INTO `xy_balance_log` VALUES (2937, 171, 182, 'UB2202091452008426', 0.18, 6, 1, 1644389536, NULL);
INSERT INTO `xy_balance_log` VALUES (2938, 181, 182, 'UB2202091452008426', 0.26, 6, 1, 1644389536, NULL);
INSERT INTO `xy_balance_log` VALUES (2939, 182, 182, 'UB2202091452293910', 383.00, 2, 2, 1644389556, NULL);
INSERT INTO `xy_balance_log` VALUES (2940, 182, 182, 'UB2202091452293910', 1.99, 3, 1, 1644389556, NULL);
INSERT INTO `xy_balance_log` VALUES (2941, 182, 182, 'UB2202091452293910', 383.00, 2, 1, 1644389556, NULL);
INSERT INTO `xy_balance_log` VALUES (2942, 171, 182, 'UB2202091452293910', 0.18, 6, 1, 1644389556, NULL);
INSERT INTO `xy_balance_log` VALUES (2943, 181, 182, 'UB2202091452293910', 0.26, 6, 1, 1644389556, NULL);
INSERT INTO `xy_balance_log` VALUES (2944, 182, 182, 'UB2202091452422290', 157.00, 2, 2, 1644389572, NULL);
INSERT INTO `xy_balance_log` VALUES (2945, 182, 182, 'UB2202091452422290', 0.82, 3, 1, 1644389572, NULL);
INSERT INTO `xy_balance_log` VALUES (2946, 182, 182, 'UB2202091452422290', 157.00, 2, 1, 1644389572, NULL);
INSERT INTO `xy_balance_log` VALUES (2947, 171, 182, 'UB2202091452422290', 0.07, 6, 1, 1644389572, NULL);
INSERT INTO `xy_balance_log` VALUES (2948, 181, 182, 'UB2202091452422290', 0.11, 6, 1, 1644389572, NULL);
INSERT INTO `xy_balance_log` VALUES (2949, 182, 182, 'UB2202091452588166', 352.00, 2, 2, 1644389586, NULL);
INSERT INTO `xy_balance_log` VALUES (2950, 182, 182, 'UB2202091452588166', 1.83, 3, 1, 1644389586, NULL);
INSERT INTO `xy_balance_log` VALUES (2951, 182, 182, 'UB2202091452588166', 352.00, 2, 1, 1644389586, NULL);
INSERT INTO `xy_balance_log` VALUES (2952, 171, 182, 'UB2202091452588166', 0.16, 6, 1, 1644389586, NULL);
INSERT INTO `xy_balance_log` VALUES (2953, 181, 182, 'UB2202091452588166', 0.24, 6, 1, 1644389586, NULL);
INSERT INTO `xy_balance_log` VALUES (2954, 182, 182, 'UB2202091453139504', 231.00, 2, 2, 1644389600, NULL);
INSERT INTO `xy_balance_log` VALUES (2955, 182, 182, 'UB2202091453139504', 1.20, 3, 1, 1644389600, NULL);
INSERT INTO `xy_balance_log` VALUES (2956, 182, 182, 'UB2202091453139504', 231.00, 2, 1, 1644389600, NULL);
INSERT INTO `xy_balance_log` VALUES (2957, 171, 182, 'UB2202091453139504', 0.11, 6, 1, 1644389600, NULL);
INSERT INTO `xy_balance_log` VALUES (2958, 181, 182, 'UB2202091453139504', 0.16, 6, 1, 1644389600, NULL);
INSERT INTO `xy_balance_log` VALUES (2959, 182, 0, 'CO2202091453573279', 450.00, 7, 2, 1644389637, NULL);
INSERT INTO `xy_balance_log` VALUES (2960, 186, 186, 'UB2202091506465747', 79.00, 2, 2, 1644390415, NULL);
INSERT INTO `xy_balance_log` VALUES (2961, 186, 186, 'UB2202091506465747', 0.47, 3, 1, 1644390415, NULL);
INSERT INTO `xy_balance_log` VALUES (2962, 186, 186, 'UB2202091506465747', 79.00, 2, 1, 1644390415, NULL);
INSERT INTO `xy_balance_log` VALUES (2963, 186, 186, 'UB2202091507039214', 129.00, 2, 2, 1644390434, NULL);
INSERT INTO `xy_balance_log` VALUES (2964, 186, 186, 'UB2202091507039214', 0.76, 3, 1, 1644390434, NULL);
INSERT INTO `xy_balance_log` VALUES (2965, 186, 186, 'UB2202091507039214', 129.00, 2, 1, 1644390434, NULL);
INSERT INTO `xy_balance_log` VALUES (2966, 186, 186, 'UB2202091507248890', 95.00, 2, 2, 1644390459, NULL);
INSERT INTO `xy_balance_log` VALUES (2967, 186, 186, 'UB2202091507248890', 0.56, 3, 1, 1644390459, NULL);
INSERT INTO `xy_balance_log` VALUES (2968, 186, 186, 'UB2202091507248890', 95.00, 2, 1, 1644390459, NULL);
INSERT INTO `xy_balance_log` VALUES (2969, 186, 0, 'CO2202091508531418', 245.00, 7, 2, 1644390533, NULL);
INSERT INTO `xy_balance_log` VALUES (2970, 186, 0, 'CO2202091508531418', 245.00, 8, 1, 1644390600, NULL);
INSERT INTO `xy_balance_log` VALUES (2971, 186, 0, 'CO2202091510599662', 292.00, 7, 2, 1644390659, NULL);
INSERT INTO `xy_balance_log` VALUES (2972, 186, 0, 'CO2202091510599662', 292.00, 8, 1, 1644390690, NULL);
INSERT INTO `xy_balance_log` VALUES (2973, 181, 0, 'SY2202091512167141', 1000.00, 1, 1, 1644390748, NULL);
INSERT INTO `xy_balance_log` VALUES (2974, 181, 0, 'SY2202091514498695', 1000.00, 1, 1, 1644390911, NULL);
INSERT INTO `xy_balance_log` VALUES (2975, 181, 181, 'UB2202091515344139', 2147.00, 2, 2, 1644390942, NULL);
INSERT INTO `xy_balance_log` VALUES (2976, 181, 181, 'UB2202091515344139', 12.88, 3, 1, 1644390942, NULL);
INSERT INTO `xy_balance_log` VALUES (2977, 181, 181, 'UB2202091515344139', 2147.00, 2, 1, 1644390942, NULL);
INSERT INTO `xy_balance_log` VALUES (2978, 171, 181, 'UB2202091515344139', 2.06, 6, 1, 1644390942, NULL);
INSERT INTO `xy_balance_log` VALUES (2979, 181, 181, 'UB2202091515491447', 2554.00, 2, 2, 1644390983, NULL);
INSERT INTO `xy_balance_log` VALUES (2980, 181, 181, 'UB2202091515491447', 15.32, 3, 1, 1644390983, NULL);
INSERT INTO `xy_balance_log` VALUES (2981, 181, 181, 'UB2202091515491447', 2554.00, 2, 1, 1644390983, NULL);
INSERT INTO `xy_balance_log` VALUES (2982, 171, 181, 'UB2202091515491447', 2.45, 6, 1, 1644390983, NULL);
INSERT INTO `xy_balance_log` VALUES (2983, 181, 181, 'UB2202091516292078', 6767.00, 2, 2, 1644390997, NULL);
INSERT INTO `xy_balance_log` VALUES (2984, 181, 181, 'UB2202091516292078', 40.60, 3, 1, 1644390997, NULL);
INSERT INTO `xy_balance_log` VALUES (2985, 181, 181, 'UB2202091516292078', 6767.00, 2, 1, 1644390997, NULL);
INSERT INTO `xy_balance_log` VALUES (2986, 171, 181, 'UB2202091516292078', 6.50, 6, 1, 1644390997, NULL);
INSERT INTO `xy_balance_log` VALUES (2987, 181, 181, 'UB2202091516445898', 5733.00, 2, 2, 1644391011, NULL);
INSERT INTO `xy_balance_log` VALUES (2988, 181, 181, 'UB2202091516445898', 34.40, 3, 1, 1644391011, NULL);
INSERT INTO `xy_balance_log` VALUES (2989, 181, 181, 'UB2202091516445898', 5733.00, 2, 1, 1644391011, NULL);
INSERT INTO `xy_balance_log` VALUES (2990, 171, 181, 'UB2202091516445898', 5.50, 6, 1, 1644391011, NULL);
INSERT INTO `xy_balance_log` VALUES (2991, 181, 181, 'UB2202091516583540', 3624.00, 2, 2, 1644391025, NULL);
INSERT INTO `xy_balance_log` VALUES (2992, 181, 181, 'UB2202091516583540', 21.74, 3, 1, 1644391025, NULL);
INSERT INTO `xy_balance_log` VALUES (2993, 181, 181, 'UB2202091516583540', 3624.00, 2, 1, 1644391025, NULL);
INSERT INTO `xy_balance_log` VALUES (2994, 171, 181, 'UB2202091516583540', 3.48, 6, 1, 1644391025, NULL);
INSERT INTO `xy_balance_log` VALUES (2995, 181, 181, 'UB2202091517124959', 3328.00, 2, 2, 1644391039, NULL);
INSERT INTO `xy_balance_log` VALUES (2996, 181, 181, 'UB2202091517124959', 19.97, 3, 1, 1644391039, NULL);
INSERT INTO `xy_balance_log` VALUES (2997, 181, 181, 'UB2202091517124959', 3328.00, 2, 1, 1644391039, NULL);
INSERT INTO `xy_balance_log` VALUES (2998, 171, 181, 'UB2202091517124959', 3.20, 6, 1, 1644391039, NULL);
INSERT INTO `xy_balance_log` VALUES (2999, 181, 181, 'UB2202091517262954', 7311.00, 2, 2, 1644391053, NULL);
INSERT INTO `xy_balance_log` VALUES (3000, 181, 181, 'UB2202091517262954', 43.87, 3, 1, 1644391053, NULL);
INSERT INTO `xy_balance_log` VALUES (3001, 181, 181, 'UB2202091517262954', 7311.00, 2, 1, 1644391053, NULL);
INSERT INTO `xy_balance_log` VALUES (3002, 171, 181, 'UB2202091517262954', 7.02, 6, 1, 1644391053, NULL);
INSERT INTO `xy_balance_log` VALUES (3003, 181, 181, 'UB2202091517426571', 7089.00, 2, 2, 1644391070, NULL);
INSERT INTO `xy_balance_log` VALUES (3004, 181, 181, 'UB2202091517426571', 42.53, 3, 1, 1644391070, NULL);
INSERT INTO `xy_balance_log` VALUES (3005, 181, 181, 'UB2202091517426571', 7089.00, 2, 1, 1644391070, NULL);
INSERT INTO `xy_balance_log` VALUES (3006, 171, 181, 'UB2202091517426571', 6.80, 6, 1, 1644391070, NULL);
INSERT INTO `xy_balance_log` VALUES (3007, 181, 181, 'UB2202091517562582', 3777.00, 2, 2, 1644391084, NULL);
INSERT INTO `xy_balance_log` VALUES (3008, 181, 181, 'UB2202091517562582', 22.66, 3, 1, 1644391084, NULL);
INSERT INTO `xy_balance_log` VALUES (3009, 181, 181, 'UB2202091517562582', 3777.00, 2, 1, 1644391084, NULL);
INSERT INTO `xy_balance_log` VALUES (3010, 171, 181, 'UB2202091517562582', 3.63, 6, 1, 1644391084, NULL);
INSERT INTO `xy_balance_log` VALUES (3011, 181, 181, 'UB2202091518118795', 7818.00, 2, 2, 1644391100, NULL);
INSERT INTO `xy_balance_log` VALUES (3012, 181, 181, 'UB2202091518118795', 46.91, 3, 1, 1644391101, NULL);
INSERT INTO `xy_balance_log` VALUES (3013, 181, 181, 'UB2202091518118795', 7818.00, 2, 1, 1644391101, NULL);
INSERT INTO `xy_balance_log` VALUES (3014, 171, 181, 'UB2202091518118795', 7.51, 6, 1, 1644391101, NULL);
INSERT INTO `xy_balance_log` VALUES (3015, 181, 181, 'UB2202091518272023', 2746.00, 2, 2, 1644391115, NULL);
INSERT INTO `xy_balance_log` VALUES (3016, 181, 181, 'UB2202091518272023', 16.48, 3, 1, 1644391115, NULL);
INSERT INTO `xy_balance_log` VALUES (3017, 181, 181, 'UB2202091518272023', 2746.00, 2, 1, 1644391115, NULL);
INSERT INTO `xy_balance_log` VALUES (3018, 171, 181, 'UB2202091518272023', 2.64, 6, 1, 1644391115, NULL);
INSERT INTO `xy_balance_log` VALUES (3019, 181, 181, 'UB2202091518422814', 3438.00, 2, 2, 1644391129, NULL);
INSERT INTO `xy_balance_log` VALUES (3020, 181, 181, 'UB2202091518422814', 20.63, 3, 1, 1644391129, NULL);
INSERT INTO `xy_balance_log` VALUES (3021, 181, 181, 'UB2202091518422814', 3438.00, 2, 1, 1644391129, NULL);
INSERT INTO `xy_balance_log` VALUES (3022, 171, 181, 'UB2202091518422814', 3.30, 6, 1, 1644391129, NULL);
INSERT INTO `xy_balance_log` VALUES (3023, 181, 181, 'UB2202091518556902', 2545.00, 2, 2, 1644391148, NULL);
INSERT INTO `xy_balance_log` VALUES (3024, 181, 181, 'UB2202091518556902', 15.27, 3, 1, 1644391148, NULL);
INSERT INTO `xy_balance_log` VALUES (3025, 181, 181, 'UB2202091518556902', 2545.00, 2, 1, 1644391148, NULL);
INSERT INTO `xy_balance_log` VALUES (3026, 171, 181, 'UB2202091518556902', 2.44, 6, 1, 1644391148, NULL);
INSERT INTO `xy_balance_log` VALUES (3027, 181, 181, 'UB2202091519145203', 7253.00, 2, 2, 1644391163, NULL);
INSERT INTO `xy_balance_log` VALUES (3028, 181, 181, 'UB2202091519145203', 43.52, 3, 1, 1644391163, NULL);
INSERT INTO `xy_balance_log` VALUES (3029, 181, 181, 'UB2202091519145203', 7253.00, 2, 1, 1644391163, NULL);
INSERT INTO `xy_balance_log` VALUES (3030, 171, 181, 'UB2202091519145203', 6.96, 6, 1, 1644391163, NULL);
INSERT INTO `xy_balance_log` VALUES (3031, 181, 181, 'UB2202091519303922', 3299.00, 2, 2, 1644391177, NULL);
INSERT INTO `xy_balance_log` VALUES (3032, 181, 181, 'UB2202091519303922', 19.79, 3, 1, 1644391177, NULL);
INSERT INTO `xy_balance_log` VALUES (3033, 181, 181, 'UB2202091519303922', 3299.00, 2, 1, 1644391177, NULL);
INSERT INTO `xy_balance_log` VALUES (3034, 171, 181, 'UB2202091519303922', 3.17, 6, 1, 1644391177, NULL);
INSERT INTO `xy_balance_log` VALUES (3035, 181, 181, 'UB2202091519439881', 4368.00, 2, 2, 1644391190, NULL);
INSERT INTO `xy_balance_log` VALUES (3036, 181, 181, 'UB2202091519439881', 26.21, 3, 1, 1644391190, NULL);
INSERT INTO `xy_balance_log` VALUES (3037, 181, 181, 'UB2202091519439881', 4368.00, 2, 1, 1644391190, NULL);
INSERT INTO `xy_balance_log` VALUES (3038, 171, 181, 'UB2202091519439881', 4.19, 6, 1, 1644391190, NULL);
INSERT INTO `xy_balance_log` VALUES (3039, 181, 181, 'UB2202091519574381', 6072.00, 2, 2, 1644391204, NULL);
INSERT INTO `xy_balance_log` VALUES (3040, 181, 181, 'UB2202091519574381', 36.43, 3, 1, 1644391204, NULL);
INSERT INTO `xy_balance_log` VALUES (3041, 181, 181, 'UB2202091519574381', 6072.00, 2, 1, 1644391204, NULL);
INSERT INTO `xy_balance_log` VALUES (3042, 171, 181, 'UB2202091519574381', 5.83, 6, 1, 1644391204, NULL);
INSERT INTO `xy_balance_log` VALUES (3043, 181, 181, 'UB2202091520146431', 7326.00, 2, 2, 1644391224, NULL);
INSERT INTO `xy_balance_log` VALUES (3044, 181, 181, 'UB2202091520146431', 43.96, 3, 1, 1644391224, NULL);
INSERT INTO `xy_balance_log` VALUES (3045, 181, 181, 'UB2202091520146431', 7326.00, 2, 1, 1644391224, NULL);
INSERT INTO `xy_balance_log` VALUES (3046, 171, 181, 'UB2202091520146431', 7.03, 6, 1, 1644391224, NULL);
INSERT INTO `xy_balance_log` VALUES (3047, 181, 181, 'UB2202091520345612', 7707.00, 2, 2, 1644391242, NULL);
INSERT INTO `xy_balance_log` VALUES (3048, 181, 181, 'UB2202091520345612', 46.24, 3, 1, 1644391242, NULL);
INSERT INTO `xy_balance_log` VALUES (3049, 181, 181, 'UB2202091520345612', 7707.00, 2, 1, 1644391242, NULL);
INSERT INTO `xy_balance_log` VALUES (3050, 171, 181, 'UB2202091520345612', 7.40, 6, 1, 1644391242, NULL);
INSERT INTO `xy_balance_log` VALUES (3051, 181, 181, 'UB2202091520489118', 8396.00, 2, 2, 1644391256, NULL);
INSERT INTO `xy_balance_log` VALUES (3052, 181, 181, 'UB2202091520489118', 50.38, 3, 1, 1644391256, NULL);
INSERT INTO `xy_balance_log` VALUES (3053, 181, 181, 'UB2202091520489118', 8396.00, 2, 1, 1644391256, NULL);
INSERT INTO `xy_balance_log` VALUES (3054, 171, 181, 'UB2202091520489118', 8.06, 6, 1, 1644391256, NULL);
INSERT INTO `xy_balance_log` VALUES (3055, 181, 181, 'UB2202091521023258', 3301.00, 2, 2, 1644391269, NULL);
INSERT INTO `xy_balance_log` VALUES (3056, 181, 181, 'UB2202091521023258', 19.81, 3, 1, 1644391269, NULL);
INSERT INTO `xy_balance_log` VALUES (3057, 181, 181, 'UB2202091521023258', 3301.00, 2, 1, 1644391269, NULL);
INSERT INTO `xy_balance_log` VALUES (3058, 171, 181, 'UB2202091521023258', 3.17, 6, 1, 1644391269, NULL);
INSERT INTO `xy_balance_log` VALUES (3059, 181, 181, 'UB2202091521159078', 3373.00, 2, 2, 1644391282, NULL);
INSERT INTO `xy_balance_log` VALUES (3060, 181, 181, 'UB2202091521159078', 20.24, 3, 1, 1644391282, NULL);
INSERT INTO `xy_balance_log` VALUES (3061, 181, 181, 'UB2202091521159078', 3373.00, 2, 1, 1644391282, NULL);
INSERT INTO `xy_balance_log` VALUES (3062, 171, 181, 'UB2202091521159078', 3.24, 6, 1, 1644391282, NULL);
INSERT INTO `xy_balance_log` VALUES (3063, 181, 181, 'UB2202091521294116', 2292.00, 2, 2, 1644391296, NULL);
INSERT INTO `xy_balance_log` VALUES (3064, 181, 181, 'UB2202091521294116', 13.75, 3, 1, 1644391296, NULL);
INSERT INTO `xy_balance_log` VALUES (3065, 181, 181, 'UB2202091521294116', 2292.00, 2, 1, 1644391296, NULL);
INSERT INTO `xy_balance_log` VALUES (3066, 171, 181, 'UB2202091521294116', 2.20, 6, 1, 1644391296, NULL);
INSERT INTO `xy_balance_log` VALUES (3067, 181, 181, 'UB2202091521432330', 5159.00, 2, 2, 1644391310, NULL);
INSERT INTO `xy_balance_log` VALUES (3068, 181, 181, 'UB2202091521432330', 30.95, 3, 1, 1644391310, NULL);
INSERT INTO `xy_balance_log` VALUES (3069, 181, 181, 'UB2202091521432330', 5159.00, 2, 1, 1644391310, NULL);
INSERT INTO `xy_balance_log` VALUES (3070, 171, 181, 'UB2202091521432330', 4.95, 6, 1, 1644391310, NULL);
INSERT INTO `xy_balance_log` VALUES (3071, 181, 181, 'UB2202091521575336', 8372.00, 2, 2, 1644391324, NULL);
INSERT INTO `xy_balance_log` VALUES (3072, 181, 181, 'UB2202091521575336', 50.23, 3, 1, 1644391324, NULL);
INSERT INTO `xy_balance_log` VALUES (3073, 181, 181, 'UB2202091521575336', 8372.00, 2, 1, 1644391324, NULL);
INSERT INTO `xy_balance_log` VALUES (3074, 171, 181, 'UB2202091521575336', 8.04, 6, 1, 1644391324, NULL);
INSERT INTO `xy_balance_log` VALUES (3075, 181, 181, 'UB2202091522122883', 4266.00, 2, 2, 1644391339, NULL);
INSERT INTO `xy_balance_log` VALUES (3076, 181, 181, 'UB2202091522122883', 25.60, 3, 1, 1644391339, NULL);
INSERT INTO `xy_balance_log` VALUES (3077, 181, 181, 'UB2202091522122883', 4266.00, 2, 1, 1644391339, NULL);
INSERT INTO `xy_balance_log` VALUES (3078, 171, 181, 'UB2202091522122883', 4.10, 6, 1, 1644391339, NULL);
INSERT INTO `xy_balance_log` VALUES (3079, 181, 181, 'UB2202091522258405', 6052.00, 2, 2, 1644391352, NULL);
INSERT INTO `xy_balance_log` VALUES (3080, 181, 181, 'UB2202091522258405', 36.31, 3, 1, 1644391352, NULL);
INSERT INTO `xy_balance_log` VALUES (3081, 181, 181, 'UB2202091522258405', 6052.00, 2, 1, 1644391352, NULL);
INSERT INTO `xy_balance_log` VALUES (3082, 171, 181, 'UB2202091522258405', 5.81, 6, 1, 1644391352, NULL);
INSERT INTO `xy_balance_log` VALUES (3083, 181, 181, 'UB2202091522399896', 5557.00, 2, 2, 1644391366, NULL);
INSERT INTO `xy_balance_log` VALUES (3084, 181, 181, 'UB2202091522399896', 33.34, 3, 1, 1644391366, NULL);
INSERT INTO `xy_balance_log` VALUES (3085, 181, 181, 'UB2202091522399896', 5557.00, 2, 1, 1644391366, NULL);
INSERT INTO `xy_balance_log` VALUES (3086, 171, 181, 'UB2202091522399896', 5.33, 6, 1, 1644391366, NULL);
INSERT INTO `xy_balance_log` VALUES (3087, 181, 181, 'UB2202091522526723', 7586.00, 2, 2, 1644391380, NULL);
INSERT INTO `xy_balance_log` VALUES (3088, 181, 181, 'UB2202091522526723', 45.52, 3, 1, 1644391380, NULL);
INSERT INTO `xy_balance_log` VALUES (3089, 181, 181, 'UB2202091522526723', 7586.00, 2, 1, 1644391380, NULL);
INSERT INTO `xy_balance_log` VALUES (3090, 171, 181, 'UB2202091522526723', 7.28, 6, 1, 1644391380, NULL);
INSERT INTO `xy_balance_log` VALUES (3091, 181, 181, 'UB2202091523078068', 5981.00, 2, 2, 1644391394, NULL);
INSERT INTO `xy_balance_log` VALUES (3092, 181, 181, 'UB2202091523078068', 35.89, 3, 1, 1644391394, NULL);
INSERT INTO `xy_balance_log` VALUES (3093, 181, 181, 'UB2202091523078068', 5981.00, 2, 1, 1644391394, NULL);
INSERT INTO `xy_balance_log` VALUES (3094, 171, 181, 'UB2202091523078068', 5.74, 6, 1, 1644391394, NULL);
INSERT INTO `xy_balance_log` VALUES (3095, 181, 0, 'CO2202091523386825', 1000.00, 7, 2, 1644391418, NULL);
INSERT INTO `xy_balance_log` VALUES (3096, 181, 0, 'CO2202091523386825', 1000.00, 8, 1, 1644391436, NULL);
INSERT INTO `xy_balance_log` VALUES (3097, 181, 187, '', 0.50, 5, 1, 1644476955, NULL);
INSERT INTO `xy_balance_log` VALUES (3098, 187, 0, 'SY2202101509552895', 100.00, 1, 1, 1644477007, NULL);
INSERT INTO `xy_balance_log` VALUES (3099, 181, 0, 'SY2202101509552895', 5.00, 5, 1, 1644477007, NULL);
INSERT INTO `xy_balance_log` VALUES (3100, 187, 187, 'UB2202101511291217', 45.00, 2, 2, 1644477098, NULL);
INSERT INTO `xy_balance_log` VALUES (3101, 187, 187, 'UB2202101511291217', 0.27, 3, 1, 1644477098, NULL);
INSERT INTO `xy_balance_log` VALUES (3102, 187, 187, 'UB2202101511291217', 45.00, 2, 1, 1644477098, NULL);
INSERT INTO `xy_balance_log` VALUES (3103, 187, 187, 'UB2202101511443639', 74.00, 2, 2, 1644477111, NULL);
INSERT INTO `xy_balance_log` VALUES (3104, 187, 187, 'UB2202101511443639', 0.44, 3, 1, 1644477111, NULL);
INSERT INTO `xy_balance_log` VALUES (3105, 187, 187, 'UB2202101511443639', 74.00, 2, 1, 1644477111, NULL);
INSERT INTO `xy_balance_log` VALUES (3106, 187, 187, 'UB2202101511583278', 81.00, 2, 2, 1644477126, NULL);
INSERT INTO `xy_balance_log` VALUES (3107, 187, 187, 'UB2202101511583278', 0.48, 3, 1, 1644477126, NULL);
INSERT INTO `xy_balance_log` VALUES (3108, 187, 187, 'UB2202101511583278', 81.00, 2, 1, 1644477126, NULL);
INSERT INTO `xy_balance_log` VALUES (3109, 187, 0, 'CO2202101515443084', 102.00, 7, 2, 1644477344, NULL);
INSERT INTO `xy_balance_log` VALUES (3110, 187, 0, 'CO2202101515443084', 102.00, 8, 1, 1644502310, NULL);
INSERT INTO `xy_balance_log` VALUES (3111, 184, 0, 'SY2202111020045480', 500.00, 1, 1, 1644546084, NULL);
INSERT INTO `xy_balance_log` VALUES (3112, 184, 184, 'UB2202111029108047', 340.00, 2, 2, 1644546558, NULL);
INSERT INTO `xy_balance_log` VALUES (3113, 184, 184, 'UB2202111029108047', 1.84, 3, 1, 1644546558, NULL);
INSERT INTO `xy_balance_log` VALUES (3114, 184, 184, 'UB2202111029108047', 340.00, 2, 1, 1644546558, NULL);
INSERT INTO `xy_balance_log` VALUES (3115, 171, 184, 'UB2202111029108047', 0.17, 6, 1, 1644546558, NULL);
INSERT INTO `xy_balance_log` VALUES (3116, 181, 184, 'UB2202111029108047', 0.26, 6, 1, 1644546558, NULL);
INSERT INTO `xy_balance_log` VALUES (3117, 184, 184, 'UB2202111030293062', 268.00, 2, 2, 1644546637, NULL);
INSERT INTO `xy_balance_log` VALUES (3118, 184, 184, 'UB2202111030293062', 1.45, 3, 1, 1644546637, NULL);
INSERT INTO `xy_balance_log` VALUES (3119, 184, 184, 'UB2202111030293062', 268.00, 2, 1, 1644546637, NULL);
INSERT INTO `xy_balance_log` VALUES (3120, 171, 184, 'UB2202111030293062', 0.13, 6, 1, 1644546637, NULL);
INSERT INTO `xy_balance_log` VALUES (3121, 181, 184, 'UB2202111030293062', 0.20, 6, 1, 1644546637, NULL);
INSERT INTO `xy_balance_log` VALUES (3122, 184, 184, 'UB2202111030446606', 384.00, 2, 2, 1644546652, NULL);
INSERT INTO `xy_balance_log` VALUES (3123, 184, 184, 'UB2202111030446606', 2.07, 3, 1, 1644546652, NULL);
INSERT INTO `xy_balance_log` VALUES (3124, 184, 184, 'UB2202111030446606', 384.00, 2, 1, 1644546652, NULL);
INSERT INTO `xy_balance_log` VALUES (3125, 171, 184, 'UB2202111030446606', 0.19, 6, 1, 1644546652, NULL);
INSERT INTO `xy_balance_log` VALUES (3126, 181, 184, 'UB2202111030446606', 0.29, 6, 1, 1644546652, NULL);
INSERT INTO `xy_balance_log` VALUES (3127, 184, 184, 'UB2202111030593185', 135.00, 2, 2, 1644546666, NULL);
INSERT INTO `xy_balance_log` VALUES (3128, 184, 184, 'UB2202111030593185', 0.73, 3, 1, 1644546666, NULL);
INSERT INTO `xy_balance_log` VALUES (3129, 184, 184, 'UB2202111030593185', 135.00, 2, 1, 1644546666, NULL);
INSERT INTO `xy_balance_log` VALUES (3130, 171, 184, 'UB2202111030593185', 0.07, 6, 1, 1644546666, NULL);
INSERT INTO `xy_balance_log` VALUES (3131, 181, 184, 'UB2202111030593185', 0.10, 6, 1, 1644546666, NULL);
INSERT INTO `xy_balance_log` VALUES (3132, 184, 184, 'UB2202111031189869', 145.00, 2, 2, 1644546686, NULL);
INSERT INTO `xy_balance_log` VALUES (3133, 184, 184, 'UB2202111031189869', 0.78, 3, 1, 1644546686, NULL);
INSERT INTO `xy_balance_log` VALUES (3134, 184, 184, 'UB2202111031189869', 145.00, 2, 1, 1644546686, NULL);
INSERT INTO `xy_balance_log` VALUES (3135, 171, 184, 'UB2202111031189869', 0.07, 6, 1, 1644546686, NULL);
INSERT INTO `xy_balance_log` VALUES (3136, 181, 184, 'UB2202111031189869', 0.11, 6, 1, 1644546686, NULL);
INSERT INTO `xy_balance_log` VALUES (3137, 184, 184, 'UB2202111031349937', 201.00, 2, 2, 1644546701, NULL);
INSERT INTO `xy_balance_log` VALUES (3138, 184, 184, 'UB2202111031349937', 1.09, 3, 1, 1644546701, NULL);
INSERT INTO `xy_balance_log` VALUES (3139, 184, 184, 'UB2202111031349937', 201.00, 2, 1, 1644546701, NULL);
INSERT INTO `xy_balance_log` VALUES (3140, 171, 184, 'UB2202111031349937', 0.10, 6, 1, 1644546701, NULL);
INSERT INTO `xy_balance_log` VALUES (3141, 181, 184, 'UB2202111031349937', 0.15, 6, 1, 1644546701, NULL);
INSERT INTO `xy_balance_log` VALUES (3142, 184, 184, 'UB2202111031489436', 161.00, 2, 2, 1644546727, NULL);
INSERT INTO `xy_balance_log` VALUES (3143, 184, 184, 'UB2202111031489436', 0.87, 3, 1, 1644546727, NULL);
INSERT INTO `xy_balance_log` VALUES (3144, 184, 184, 'UB2202111031489436', 161.00, 2, 1, 1644546727, NULL);
INSERT INTO `xy_balance_log` VALUES (3145, 171, 184, 'UB2202111031489436', 0.08, 6, 1, 1644546727, NULL);
INSERT INTO `xy_balance_log` VALUES (3146, 181, 184, 'UB2202111031489436', 0.12, 6, 1, 1644546727, NULL);
INSERT INTO `xy_balance_log` VALUES (3147, 184, 184, 'UB2202111033255062', 364.00, 2, 2, 1644546813, NULL);
INSERT INTO `xy_balance_log` VALUES (3148, 184, 184, 'UB2202111033255062', 1.97, 3, 1, 1644546813, NULL);
INSERT INTO `xy_balance_log` VALUES (3149, 184, 184, 'UB2202111033255062', 364.00, 2, 1, 1644546813, NULL);
INSERT INTO `xy_balance_log` VALUES (3150, 171, 184, 'UB2202111033255062', 0.18, 6, 1, 1644546813, NULL);
INSERT INTO `xy_balance_log` VALUES (3151, 181, 184, 'UB2202111033255062', 0.28, 6, 1, 1644546813, NULL);
INSERT INTO `xy_balance_log` VALUES (3152, 184, 184, 'UB2202111033403946', 179.00, 2, 2, 1644546827, NULL);
INSERT INTO `xy_balance_log` VALUES (3153, 184, 184, 'UB2202111033403946', 0.97, 3, 1, 1644546827, NULL);
INSERT INTO `xy_balance_log` VALUES (3154, 184, 184, 'UB2202111033403946', 179.00, 2, 1, 1644546827, NULL);
INSERT INTO `xy_balance_log` VALUES (3155, 171, 184, 'UB2202111033403946', 0.09, 6, 1, 1644546828, NULL);
INSERT INTO `xy_balance_log` VALUES (3156, 181, 184, 'UB2202111033403946', 0.14, 6, 1, 1644546828, NULL);
INSERT INTO `xy_balance_log` VALUES (3157, 184, 184, 'UB2202111033559165', 439.00, 2, 2, 1644546846, NULL);
INSERT INTO `xy_balance_log` VALUES (3158, 184, 184, 'UB2202111033559165', 2.37, 3, 1, 1644546846, NULL);
INSERT INTO `xy_balance_log` VALUES (3159, 184, 184, 'UB2202111033559165', 439.00, 2, 1, 1644546846, NULL);
INSERT INTO `xy_balance_log` VALUES (3160, 171, 184, 'UB2202111033559165', 0.21, 6, 1, 1644546846, NULL);
INSERT INTO `xy_balance_log` VALUES (3161, 181, 184, 'UB2202111033559165', 0.33, 6, 1, 1644546846, NULL);
INSERT INTO `xy_balance_log` VALUES (3162, 184, 0, 'CO2202111101246782', 464.00, 7, 2, 1644548484, NULL);
INSERT INTO `xy_balance_log` VALUES (3163, 184, 0, 'CO2202111101246782', 464.00, 8, 1, 1644548543, NULL);
INSERT INTO `xy_balance_log` VALUES (3164, 183, 0, 'SY2202111101254115', 500.00, 1, 1, 1644548553, NULL);
INSERT INTO `xy_balance_log` VALUES (3165, 183, 183, 'UB2202111103505919', 116.00, 2, 2, 1644548640, NULL);
INSERT INTO `xy_balance_log` VALUES (3166, 183, 183, 'UB2202111103505919', 0.63, 3, 1, 1644548640, NULL);
INSERT INTO `xy_balance_log` VALUES (3167, 183, 183, 'UB2202111103505919', 116.00, 2, 1, 1644548640, NULL);
INSERT INTO `xy_balance_log` VALUES (3168, 171, 183, 'UB2202111103505919', 0.06, 6, 1, 1644548640, NULL);
INSERT INTO `xy_balance_log` VALUES (3169, 181, 183, 'UB2202111103505919', 0.09, 6, 1, 1644548640, NULL);
INSERT INTO `xy_balance_log` VALUES (3170, 183, 183, 'UB2202111104068048', 321.00, 2, 2, 1644548661, NULL);
INSERT INTO `xy_balance_log` VALUES (3171, 183, 183, 'UB2202111104068048', 1.73, 3, 1, 1644548661, NULL);
INSERT INTO `xy_balance_log` VALUES (3172, 183, 183, 'UB2202111104068048', 321.00, 2, 1, 1644548661, NULL);
INSERT INTO `xy_balance_log` VALUES (3173, 171, 183, 'UB2202111104068048', 0.16, 6, 1, 1644548661, NULL);
INSERT INTO `xy_balance_log` VALUES (3174, 181, 183, 'UB2202111104068048', 0.24, 6, 1, 1644548661, NULL);
INSERT INTO `xy_balance_log` VALUES (3175, 184, 0, 'CO2202111104262474', 464.00, 7, 2, 1644548666, NULL);
INSERT INTO `xy_balance_log` VALUES (3176, 183, 183, 'UB2202111104295104', 164.00, 2, 2, 1644548678, NULL);
INSERT INTO `xy_balance_log` VALUES (3177, 183, 183, 'UB2202111104295104', 0.89, 3, 1, 1644548678, NULL);
INSERT INTO `xy_balance_log` VALUES (3178, 183, 183, 'UB2202111104295104', 164.00, 2, 1, 1644548678, NULL);
INSERT INTO `xy_balance_log` VALUES (3179, 171, 183, 'UB2202111104295104', 0.08, 6, 1, 1644548678, NULL);
INSERT INTO `xy_balance_log` VALUES (3180, 181, 183, 'UB2202111104295104', 0.12, 6, 1, 1644548678, NULL);
INSERT INTO `xy_balance_log` VALUES (3181, 183, 183, 'UB2202111104458815', 418.00, 2, 2, 1644548693, NULL);
INSERT INTO `xy_balance_log` VALUES (3182, 183, 183, 'UB2202111104458815', 2.26, 3, 1, 1644548693, NULL);
INSERT INTO `xy_balance_log` VALUES (3183, 183, 183, 'UB2202111104458815', 418.00, 2, 1, 1644548693, NULL);
INSERT INTO `xy_balance_log` VALUES (3184, 171, 183, 'UB2202111104458815', 0.20, 6, 1, 1644548693, NULL);
INSERT INTO `xy_balance_log` VALUES (3185, 181, 183, 'UB2202111104458815', 0.32, 6, 1, 1644548693, NULL);
INSERT INTO `xy_balance_log` VALUES (3186, 183, 183, 'UB2202111105031218', 438.00, 2, 2, 1644548712, NULL);
INSERT INTO `xy_balance_log` VALUES (3187, 183, 183, 'UB2202111105031218', 2.37, 3, 1, 1644548712, NULL);
INSERT INTO `xy_balance_log` VALUES (3188, 183, 183, 'UB2202111105031218', 438.00, 2, 1, 1644548712, NULL);
INSERT INTO `xy_balance_log` VALUES (3189, 171, 183, 'UB2202111105031218', 0.21, 6, 1, 1644548712, NULL);
INSERT INTO `xy_balance_log` VALUES (3190, 181, 183, 'UB2202111105031218', 0.33, 6, 1, 1644548712, NULL);
INSERT INTO `xy_balance_log` VALUES (3191, 183, 183, 'UB2202111105201384', 364.00, 2, 2, 1644548729, NULL);
INSERT INTO `xy_balance_log` VALUES (3192, 183, 183, 'UB2202111105201384', 1.97, 3, 1, 1644548729, NULL);
INSERT INTO `xy_balance_log` VALUES (3193, 183, 183, 'UB2202111105201384', 364.00, 2, 1, 1644548729, NULL);
INSERT INTO `xy_balance_log` VALUES (3194, 171, 183, 'UB2202111105201384', 0.18, 6, 1, 1644548729, NULL);
INSERT INTO `xy_balance_log` VALUES (3195, 181, 183, 'UB2202111105201384', 0.28, 6, 1, 1644548729, NULL);
INSERT INTO `xy_balance_log` VALUES (3196, 183, 183, 'UB2202111105372463', 429.00, 2, 2, 1644548747, NULL);
INSERT INTO `xy_balance_log` VALUES (3197, 183, 183, 'UB2202111105372463', 2.32, 3, 1, 1644548747, NULL);
INSERT INTO `xy_balance_log` VALUES (3198, 183, 183, 'UB2202111105372463', 429.00, 2, 1, 1644548747, NULL);
INSERT INTO `xy_balance_log` VALUES (3199, 171, 183, 'UB2202111105372463', 0.21, 6, 1, 1644548747, NULL);
INSERT INTO `xy_balance_log` VALUES (3200, 181, 183, 'UB2202111105372463', 0.32, 6, 1, 1644548747, NULL);
INSERT INTO `xy_balance_log` VALUES (3201, 183, 183, 'UB2202111105547135', 209.00, 2, 2, 1644548763, NULL);
INSERT INTO `xy_balance_log` VALUES (3202, 183, 183, 'UB2202111105547135', 1.13, 3, 1, 1644548763, NULL);
INSERT INTO `xy_balance_log` VALUES (3203, 183, 183, 'UB2202111105547135', 209.00, 2, 1, 1644548763, NULL);
INSERT INTO `xy_balance_log` VALUES (3204, 171, 183, 'UB2202111105547135', 0.10, 6, 1, 1644548763, NULL);
INSERT INTO `xy_balance_log` VALUES (3205, 181, 183, 'UB2202111105547135', 0.16, 6, 1, 1644548763, NULL);
INSERT INTO `xy_balance_log` VALUES (3206, 183, 183, 'UB2202111106125120', 128.00, 2, 2, 1644548779, NULL);
INSERT INTO `xy_balance_log` VALUES (3207, 183, 183, 'UB2202111106125120', 0.69, 3, 1, 1644548779, NULL);
INSERT INTO `xy_balance_log` VALUES (3208, 183, 183, 'UB2202111106125120', 128.00, 2, 1, 1644548779, NULL);
INSERT INTO `xy_balance_log` VALUES (3209, 171, 183, 'UB2202111106125120', 0.06, 6, 1, 1644548779, NULL);
INSERT INTO `xy_balance_log` VALUES (3210, 181, 183, 'UB2202111106125120', 0.10, 6, 1, 1644548779, NULL);
INSERT INTO `xy_balance_log` VALUES (3211, 186, 0, 'SY2202111104164504', 500.00, 1, 1, 1644548779, NULL);
INSERT INTO `xy_balance_log` VALUES (3212, 183, 183, 'UB2202111106276987', 393.00, 2, 2, 1644548796, NULL);
INSERT INTO `xy_balance_log` VALUES (3213, 183, 183, 'UB2202111106276987', 2.12, 3, 1, 1644548796, NULL);
INSERT INTO `xy_balance_log` VALUES (3214, 183, 183, 'UB2202111106276987', 393.00, 2, 1, 1644548796, NULL);
INSERT INTO `xy_balance_log` VALUES (3215, 171, 183, 'UB2202111106276987', 0.19, 6, 1, 1644548796, NULL);
INSERT INTO `xy_balance_log` VALUES (3216, 181, 183, 'UB2202111106276987', 0.30, 6, 1, 1644548796, NULL);
INSERT INTO `xy_balance_log` VALUES (3217, 186, 186, 'UB2202111106543157', 396.00, 2, 2, 1644548824, NULL);
INSERT INTO `xy_balance_log` VALUES (3218, 186, 186, 'UB2202111106543157', 2.06, 3, 1, 1644548824, NULL);
INSERT INTO `xy_balance_log` VALUES (3219, 186, 186, 'UB2202111106543157', 396.00, 2, 1, 1644548824, NULL);
INSERT INTO `xy_balance_log` VALUES (3220, 171, 186, 'UB2202111106543157', 0.19, 6, 1, 1644548824, NULL);
INSERT INTO `xy_balance_log` VALUES (3221, 181, 186, 'UB2202111106543157', 0.29, 6, 1, 1644548825, NULL);
INSERT INTO `xy_balance_log` VALUES (3222, 186, 186, 'UB2202111107126977', 489.00, 2, 2, 1644548842, NULL);
INSERT INTO `xy_balance_log` VALUES (3223, 186, 186, 'UB2202111107126977', 2.54, 3, 1, 1644548842, NULL);
INSERT INTO `xy_balance_log` VALUES (3224, 186, 186, 'UB2202111107126977', 489.00, 2, 1, 1644548842, NULL);
INSERT INTO `xy_balance_log` VALUES (3225, 171, 186, 'UB2202111107126977', 0.23, 6, 1, 1644548842, NULL);
INSERT INTO `xy_balance_log` VALUES (3226, 181, 186, 'UB2202111107126977', 0.36, 6, 1, 1644548842, NULL);
INSERT INTO `xy_balance_log` VALUES (3227, 186, 186, 'UB2202111107298631', 176.00, 2, 2, 1644548859, NULL);
INSERT INTO `xy_balance_log` VALUES (3228, 186, 186, 'UB2202111107298631', 0.92, 3, 1, 1644548859, NULL);
INSERT INTO `xy_balance_log` VALUES (3229, 186, 186, 'UB2202111107298631', 176.00, 2, 1, 1644548859, NULL);
INSERT INTO `xy_balance_log` VALUES (3230, 171, 186, 'UB2202111107298631', 0.08, 6, 1, 1644548859, NULL);
INSERT INTO `xy_balance_log` VALUES (3231, 181, 186, 'UB2202111107298631', 0.13, 6, 1, 1644548859, NULL);
INSERT INTO `xy_balance_log` VALUES (3232, 186, 186, 'UB2202111107468186', 302.00, 2, 2, 1644548874, NULL);
INSERT INTO `xy_balance_log` VALUES (3233, 186, 186, 'UB2202111107468186', 1.57, 3, 1, 1644548874, NULL);
INSERT INTO `xy_balance_log` VALUES (3234, 186, 186, 'UB2202111107468186', 302.00, 2, 1, 1644548874, NULL);
INSERT INTO `xy_balance_log` VALUES (3235, 171, 186, 'UB2202111107468186', 0.14, 6, 1, 1644548874, NULL);
INSERT INTO `xy_balance_log` VALUES (3236, 181, 186, 'UB2202111107468186', 0.22, 6, 1, 1644548874, NULL);
INSERT INTO `xy_balance_log` VALUES (3237, 186, 186, 'UB2202111108027576', 494.00, 2, 2, 1644548889, NULL);
INSERT INTO `xy_balance_log` VALUES (3238, 186, 186, 'UB2202111108027576', 2.57, 3, 1, 1644548889, NULL);
INSERT INTO `xy_balance_log` VALUES (3239, 186, 186, 'UB2202111108027576', 494.00, 2, 1, 1644548889, NULL);
INSERT INTO `xy_balance_log` VALUES (3240, 171, 186, 'UB2202111108027576', 0.23, 6, 1, 1644548889, NULL);
INSERT INTO `xy_balance_log` VALUES (3241, 181, 186, 'UB2202111108027576', 0.36, 6, 1, 1644548889, NULL);
INSERT INTO `xy_balance_log` VALUES (3242, 186, 0, 'CO2202111109353953', 499.00, 7, 2, 1644548975, NULL);
INSERT INTO `xy_balance_log` VALUES (3243, 186, 0, 'SY2202111142048054', 1000.00, 1, 1, 1644550965, NULL);
INSERT INTO `xy_balance_log` VALUES (3244, 182, 0, 'SY2202111143412913', 1000.00, 1, 1, 1644551073, NULL);
INSERT INTO `xy_balance_log` VALUES (3245, 182, 182, 'UB2202111144557679', 835.00, 2, 2, 1644551104, NULL);
INSERT INTO `xy_balance_log` VALUES (3246, 182, 182, 'UB2202111144557679', 4.68, 3, 1, 1644551104, NULL);
INSERT INTO `xy_balance_log` VALUES (3247, 182, 182, 'UB2202111144557679', 835.00, 2, 1, 1644551104, NULL);
INSERT INTO `xy_balance_log` VALUES (3248, 171, 182, 'UB2202111144557679', 0.42, 6, 1, 1644551104, NULL);
INSERT INTO `xy_balance_log` VALUES (3249, 181, 182, 'UB2202111144557679', 0.66, 6, 1, 1644551104, NULL);
INSERT INTO `xy_balance_log` VALUES (3250, 182, 182, 'UB2202111145116751', 230.00, 2, 2, 1644551119, NULL);
INSERT INTO `xy_balance_log` VALUES (3251, 182, 182, 'UB2202111145116751', 1.29, 3, 1, 1644551119, NULL);
INSERT INTO `xy_balance_log` VALUES (3252, 182, 182, 'UB2202111145116751', 230.00, 2, 1, 1644551119, NULL);
INSERT INTO `xy_balance_log` VALUES (3253, 171, 182, 'UB2202111145116751', 0.12, 6, 1, 1644551119, NULL);
INSERT INTO `xy_balance_log` VALUES (3254, 181, 182, 'UB2202111145116751', 0.18, 6, 1, 1644551119, NULL);
INSERT INTO `xy_balance_log` VALUES (3255, 182, 182, 'UB2202111145256672', 757.00, 2, 2, 1644551133, NULL);
INSERT INTO `xy_balance_log` VALUES (3256, 182, 182, 'UB2202111145256672', 4.24, 3, 1, 1644551133, NULL);
INSERT INTO `xy_balance_log` VALUES (3257, 182, 182, 'UB2202111145256672', 757.00, 2, 1, 1644551133, NULL);
INSERT INTO `xy_balance_log` VALUES (3258, 171, 182, 'UB2202111145256672', 0.38, 6, 1, 1644551133, NULL);
INSERT INTO `xy_balance_log` VALUES (3259, 181, 182, 'UB2202111145256672', 0.59, 6, 1, 1644551133, NULL);
INSERT INTO `xy_balance_log` VALUES (3260, 186, 186, 'UB2202111144587300', 841.00, 2, 2, 1644551139, NULL);
INSERT INTO `xy_balance_log` VALUES (3261, 186, 186, 'UB2202111144587300', 4.71, 3, 1, 1644551139, NULL);
INSERT INTO `xy_balance_log` VALUES (3262, 186, 186, 'UB2202111144587300', 841.00, 2, 1, 1644551139, NULL);
INSERT INTO `xy_balance_log` VALUES (3263, 171, 186, 'UB2202111144587300', 0.42, 6, 1, 1644551139, NULL);
INSERT INTO `xy_balance_log` VALUES (3264, 181, 186, 'UB2202111144587300', 0.66, 6, 1, 1644551139, NULL);
INSERT INTO `xy_balance_log` VALUES (3265, 182, 182, 'UB2202111145402539', 280.00, 2, 2, 1644551147, NULL);
INSERT INTO `xy_balance_log` VALUES (3266, 182, 182, 'UB2202111145402539', 1.57, 3, 1, 1644551147, NULL);
INSERT INTO `xy_balance_log` VALUES (3267, 182, 182, 'UB2202111145402539', 280.00, 2, 1, 1644551147, NULL);
INSERT INTO `xy_balance_log` VALUES (3268, 171, 182, 'UB2202111145402539', 0.14, 6, 1, 1644551147, NULL);
INSERT INTO `xy_balance_log` VALUES (3269, 181, 182, 'UB2202111145402539', 0.22, 6, 1, 1644551147, NULL);
INSERT INTO `xy_balance_log` VALUES (3270, 186, 186, 'UB2202111145486703', 1020.00, 2, 2, 1644551160, NULL);
INSERT INTO `xy_balance_log` VALUES (3271, 186, 186, 'UB2202111145486703', 5.71, 3, 1, 1644551160, NULL);
INSERT INTO `xy_balance_log` VALUES (3272, 186, 186, 'UB2202111145486703', 1020.00, 2, 1, 1644551160, NULL);
INSERT INTO `xy_balance_log` VALUES (3273, 171, 186, 'UB2202111145486703', 0.51, 6, 1, 1644551160, NULL);
INSERT INTO `xy_balance_log` VALUES (3274, 181, 186, 'UB2202111145486703', 0.80, 6, 1, 1644551160, NULL);
INSERT INTO `xy_balance_log` VALUES (3275, 182, 182, 'UB2202111145538580', 705.00, 2, 2, 1644551162, NULL);
INSERT INTO `xy_balance_log` VALUES (3276, 182, 182, 'UB2202111145538580', 3.95, 3, 1, 1644551162, NULL);
INSERT INTO `xy_balance_log` VALUES (3277, 182, 182, 'UB2202111145538580', 705.00, 2, 1, 1644551162, NULL);
INSERT INTO `xy_balance_log` VALUES (3278, 171, 182, 'UB2202111145538580', 0.36, 6, 1, 1644551162, NULL);
INSERT INTO `xy_balance_log` VALUES (3279, 181, 182, 'UB2202111145538580', 0.55, 6, 1, 1644551162, NULL);
INSERT INTO `xy_balance_log` VALUES (3280, 182, 182, 'UB2202111146085503', 810.00, 2, 2, 1644551177, NULL);
INSERT INTO `xy_balance_log` VALUES (3281, 182, 182, 'UB2202111146085503', 4.54, 3, 1, 1644551177, NULL);
INSERT INTO `xy_balance_log` VALUES (3282, 182, 182, 'UB2202111146085503', 810.00, 2, 1, 1644551177, NULL);
INSERT INTO `xy_balance_log` VALUES (3283, 171, 182, 'UB2202111146085503', 0.41, 6, 1, 1644551177, NULL);
INSERT INTO `xy_balance_log` VALUES (3284, 181, 182, 'UB2202111146085503', 0.64, 6, 1, 1644551177, NULL);
INSERT INTO `xy_balance_log` VALUES (3285, 182, 182, 'UB2202111146233828', 742.00, 2, 2, 1644551190, NULL);
INSERT INTO `xy_balance_log` VALUES (3286, 182, 182, 'UB2202111146233828', 4.16, 3, 1, 1644551190, NULL);
INSERT INTO `xy_balance_log` VALUES (3287, 182, 182, 'UB2202111146233828', 742.00, 2, 1, 1644551190, NULL);
INSERT INTO `xy_balance_log` VALUES (3288, 171, 182, 'UB2202111146233828', 0.37, 6, 1, 1644551190, NULL);
INSERT INTO `xy_balance_log` VALUES (3289, 181, 182, 'UB2202111146233828', 0.58, 6, 1, 1644551190, NULL);
INSERT INTO `xy_balance_log` VALUES (3290, 186, 186, 'UB2202111146254082', 526.00, 2, 2, 1644551192, NULL);
INSERT INTO `xy_balance_log` VALUES (3291, 186, 186, 'UB2202111146254082', 2.95, 3, 1, 1644551192, NULL);
INSERT INTO `xy_balance_log` VALUES (3292, 186, 186, 'UB2202111146254082', 526.00, 2, 1, 1644551192, NULL);
INSERT INTO `xy_balance_log` VALUES (3293, 171, 186, 'UB2202111146254082', 0.27, 6, 1, 1644551192, NULL);
INSERT INTO `xy_balance_log` VALUES (3294, 181, 186, 'UB2202111146254082', 0.41, 6, 1, 1644551192, NULL);
INSERT INTO `xy_balance_log` VALUES (3295, 182, 182, 'UB2202111146362224', 323.00, 2, 2, 1644551203, NULL);
INSERT INTO `xy_balance_log` VALUES (3296, 182, 182, 'UB2202111146362224', 1.81, 3, 1, 1644551203, NULL);
INSERT INTO `xy_balance_log` VALUES (3297, 182, 182, 'UB2202111146362224', 323.00, 2, 1, 1644551203, NULL);
INSERT INTO `xy_balance_log` VALUES (3298, 171, 182, 'UB2202111146362224', 0.16, 6, 1, 1644551203, NULL);
INSERT INTO `xy_balance_log` VALUES (3299, 181, 182, 'UB2202111146362224', 0.25, 6, 1, 1644551203, NULL);
INSERT INTO `xy_balance_log` VALUES (3300, 186, 186, 'UB2202111146398206', 1004.00, 2, 2, 1644551206, NULL);
INSERT INTO `xy_balance_log` VALUES (3301, 186, 186, 'UB2202111146398206', 5.62, 3, 1, 1644551206, NULL);
INSERT INTO `xy_balance_log` VALUES (3302, 186, 186, 'UB2202111146398206', 1004.00, 2, 1, 1644551206, NULL);
INSERT INTO `xy_balance_log` VALUES (3303, 171, 186, 'UB2202111146398206', 0.51, 6, 1, 1644551206, NULL);
INSERT INTO `xy_balance_log` VALUES (3304, 181, 186, 'UB2202111146398206', 0.79, 6, 1, 1644551206, NULL);
INSERT INTO `xy_balance_log` VALUES (3305, 182, 182, 'UB2202111146505302', 273.00, 2, 2, 1644551217, NULL);
INSERT INTO `xy_balance_log` VALUES (3306, 182, 182, 'UB2202111146505302', 1.53, 3, 1, 1644551217, NULL);
INSERT INTO `xy_balance_log` VALUES (3307, 182, 182, 'UB2202111146505302', 273.00, 2, 1, 1644551217, NULL);
INSERT INTO `xy_balance_log` VALUES (3308, 171, 182, 'UB2202111146505302', 0.14, 6, 1, 1644551217, NULL);
INSERT INTO `xy_balance_log` VALUES (3309, 181, 182, 'UB2202111146505302', 0.21, 6, 1, 1644551217, NULL);
INSERT INTO `xy_balance_log` VALUES (3310, 186, 186, 'UB2202111146551594', 293.00, 2, 2, 1644551225, NULL);
INSERT INTO `xy_balance_log` VALUES (3311, 186, 186, 'UB2202111146551594', 1.64, 3, 1, 1644551225, NULL);
INSERT INTO `xy_balance_log` VALUES (3312, 186, 186, 'UB2202111146551594', 293.00, 2, 1, 1644551225, NULL);
INSERT INTO `xy_balance_log` VALUES (3313, 171, 186, 'UB2202111146551594', 0.15, 6, 1, 1644551225, NULL);
INSERT INTO `xy_balance_log` VALUES (3314, 181, 186, 'UB2202111146551594', 0.23, 6, 1, 1644551225, NULL);
INSERT INTO `xy_balance_log` VALUES (3315, 182, 182, 'UB2202111147051309', 728.00, 2, 2, 1644551234, NULL);
INSERT INTO `xy_balance_log` VALUES (3316, 182, 182, 'UB2202111147051309', 4.08, 3, 1, 1644551234, NULL);
INSERT INTO `xy_balance_log` VALUES (3317, 182, 182, 'UB2202111147051309', 728.00, 2, 1, 1644551234, NULL);
INSERT INTO `xy_balance_log` VALUES (3318, 171, 182, 'UB2202111147051309', 0.37, 6, 1, 1644551234, NULL);
INSERT INTO `xy_balance_log` VALUES (3319, 181, 182, 'UB2202111147051309', 0.57, 6, 1, 1644551234, NULL);
INSERT INTO `xy_balance_log` VALUES (3320, 186, 186, 'UB2202111147106744', 1023.00, 2, 2, 1644551237, NULL);
INSERT INTO `xy_balance_log` VALUES (3321, 186, 186, 'UB2202111147106744', 5.73, 3, 1, 1644551237, NULL);
INSERT INTO `xy_balance_log` VALUES (3322, 186, 186, 'UB2202111147106744', 1023.00, 2, 1, 1644551237, NULL);
INSERT INTO `xy_balance_log` VALUES (3323, 171, 186, 'UB2202111147106744', 0.52, 6, 1, 1644551237, NULL);
INSERT INTO `xy_balance_log` VALUES (3324, 181, 186, 'UB2202111147106744', 0.80, 6, 1, 1644551237, NULL);
INSERT INTO `xy_balance_log` VALUES (3325, 182, 182, 'UB2202111147215035', 443.00, 2, 2, 1644551249, NULL);
INSERT INTO `xy_balance_log` VALUES (3326, 182, 182, 'UB2202111147215035', 2.48, 3, 1, 1644551249, NULL);
INSERT INTO `xy_balance_log` VALUES (3327, 182, 182, 'UB2202111147215035', 443.00, 2, 1, 1644551249, NULL);
INSERT INTO `xy_balance_log` VALUES (3328, 171, 182, 'UB2202111147215035', 0.22, 6, 1, 1644551249, NULL);
INSERT INTO `xy_balance_log` VALUES (3329, 181, 182, 'UB2202111147215035', 0.35, 6, 1, 1644551249, NULL);
INSERT INTO `xy_balance_log` VALUES (3330, 186, 186, 'UB2202111147258819', 763.00, 2, 2, 1644551252, NULL);
INSERT INTO `xy_balance_log` VALUES (3331, 186, 186, 'UB2202111147258819', 4.27, 3, 1, 1644551252, NULL);
INSERT INTO `xy_balance_log` VALUES (3332, 186, 186, 'UB2202111147258819', 763.00, 2, 1, 1644551252, NULL);
INSERT INTO `xy_balance_log` VALUES (3333, 171, 186, 'UB2202111147258819', 0.38, 6, 1, 1644551252, NULL);
INSERT INTO `xy_balance_log` VALUES (3334, 181, 186, 'UB2202111147258819', 0.60, 6, 1, 1644551252, NULL);
INSERT INTO `xy_balance_log` VALUES (3335, 182, 182, 'UB2202111147367061', 865.00, 2, 2, 1644551263, NULL);
INSERT INTO `xy_balance_log` VALUES (3336, 182, 182, 'UB2202111147367061', 4.84, 3, 1, 1644551263, NULL);
INSERT INTO `xy_balance_log` VALUES (3337, 182, 182, 'UB2202111147367061', 865.00, 2, 1, 1644551263, NULL);
INSERT INTO `xy_balance_log` VALUES (3338, 171, 182, 'UB2202111147367061', 0.44, 6, 1, 1644551263, NULL);
INSERT INTO `xy_balance_log` VALUES (3339, 181, 182, 'UB2202111147367061', 0.68, 6, 1, 1644551263, NULL);
INSERT INTO `xy_balance_log` VALUES (3340, 186, 186, 'UB2202111147394456', 1072.00, 2, 2, 1644551266, NULL);
INSERT INTO `xy_balance_log` VALUES (3341, 186, 186, 'UB2202111147394456', 6.00, 3, 1, 1644551266, NULL);
INSERT INTO `xy_balance_log` VALUES (3342, 186, 186, 'UB2202111147394456', 1072.00, 2, 1, 1644551266, NULL);
INSERT INTO `xy_balance_log` VALUES (3343, 171, 186, 'UB2202111147394456', 0.54, 6, 1, 1644551266, NULL);
INSERT INTO `xy_balance_log` VALUES (3344, 181, 186, 'UB2202111147394456', 0.84, 6, 1, 1644551266, NULL);
INSERT INTO `xy_balance_log` VALUES (3345, 182, 182, 'UB2202111147502936', 254.00, 2, 2, 1644551278, NULL);
INSERT INTO `xy_balance_log` VALUES (3346, 182, 182, 'UB2202111147502936', 1.42, 3, 1, 1644551278, NULL);
INSERT INTO `xy_balance_log` VALUES (3347, 182, 182, 'UB2202111147502936', 254.00, 2, 1, 1644551278, NULL);
INSERT INTO `xy_balance_log` VALUES (3348, 171, 182, 'UB2202111147502936', 0.13, 6, 1, 1644551278, NULL);
INSERT INTO `xy_balance_log` VALUES (3349, 181, 182, 'UB2202111147502936', 0.20, 6, 1, 1644551278, NULL);
INSERT INTO `xy_balance_log` VALUES (3350, 186, 186, 'UB2202111147535167', 351.00, 2, 2, 1644551283, NULL);
INSERT INTO `xy_balance_log` VALUES (3351, 186, 186, 'UB2202111147535167', 1.97, 3, 1, 1644551283, NULL);
INSERT INTO `xy_balance_log` VALUES (3352, 186, 186, 'UB2202111147535167', 351.00, 2, 1, 1644551283, NULL);
INSERT INTO `xy_balance_log` VALUES (3353, 171, 186, 'UB2202111147535167', 0.18, 6, 1, 1644551283, NULL);
INSERT INTO `xy_balance_log` VALUES (3354, 181, 186, 'UB2202111147535167', 0.28, 6, 1, 1644551283, NULL);
INSERT INTO `xy_balance_log` VALUES (3355, 182, 182, 'UB2202111148055190', 829.00, 2, 2, 1644551292, NULL);
INSERT INTO `xy_balance_log` VALUES (3356, 182, 182, 'UB2202111148055190', 4.64, 3, 1, 1644551292, NULL);
INSERT INTO `xy_balance_log` VALUES (3357, 182, 182, 'UB2202111148055190', 829.00, 2, 1, 1644551292, NULL);
INSERT INTO `xy_balance_log` VALUES (3358, 171, 182, 'UB2202111148055190', 0.42, 6, 1, 1644551292, NULL);
INSERT INTO `xy_balance_log` VALUES (3359, 181, 182, 'UB2202111148055190', 0.65, 6, 1, 1644551292, NULL);
INSERT INTO `xy_balance_log` VALUES (3360, 186, 186, 'UB2202111148129879', 884.00, 2, 2, 1644551301, NULL);
INSERT INTO `xy_balance_log` VALUES (3361, 186, 186, 'UB2202111148129879', 4.95, 3, 1, 1644551301, NULL);
INSERT INTO `xy_balance_log` VALUES (3362, 186, 186, 'UB2202111148129879', 884.00, 2, 1, 1644551301, NULL);
INSERT INTO `xy_balance_log` VALUES (3363, 171, 186, 'UB2202111148129879', 0.45, 6, 1, 1644551301, NULL);
INSERT INTO `xy_balance_log` VALUES (3364, 181, 186, 'UB2202111148129879', 0.69, 6, 1, 1644551301, NULL);
INSERT INTO `xy_balance_log` VALUES (3365, 182, 182, 'UB2202111148191699', 443.00, 2, 2, 1644551306, NULL);
INSERT INTO `xy_balance_log` VALUES (3366, 182, 182, 'UB2202111148191699', 2.48, 3, 1, 1644551306, NULL);
INSERT INTO `xy_balance_log` VALUES (3367, 182, 182, 'UB2202111148191699', 443.00, 2, 1, 1644551306, NULL);
INSERT INTO `xy_balance_log` VALUES (3368, 171, 182, 'UB2202111148191699', 0.22, 6, 1, 1644551306, NULL);
INSERT INTO `xy_balance_log` VALUES (3369, 181, 182, 'UB2202111148191699', 0.35, 6, 1, 1644551306, NULL);
INSERT INTO `xy_balance_log` VALUES (3370, 186, 186, 'UB2202111148277093', 734.00, 2, 2, 1644551317, NULL);
INSERT INTO `xy_balance_log` VALUES (3371, 186, 186, 'UB2202111148277093', 4.11, 3, 1, 1644551317, NULL);
INSERT INTO `xy_balance_log` VALUES (3372, 186, 186, 'UB2202111148277093', 734.00, 2, 1, 1644551317, NULL);
INSERT INTO `xy_balance_log` VALUES (3373, 171, 186, 'UB2202111148277093', 0.37, 6, 1, 1644551317, NULL);
INSERT INTO `xy_balance_log` VALUES (3374, 181, 186, 'UB2202111148277093', 0.58, 6, 1, 1644551317, NULL);
INSERT INTO `xy_balance_log` VALUES (3375, 186, 186, 'UB2202111148458207', 610.00, 2, 2, 1644551333, NULL);
INSERT INTO `xy_balance_log` VALUES (3376, 186, 186, 'UB2202111148458207', 3.42, 3, 1, 1644551333, NULL);
INSERT INTO `xy_balance_log` VALUES (3377, 186, 186, 'UB2202111148458207', 610.00, 2, 1, 1644551333, NULL);
INSERT INTO `xy_balance_log` VALUES (3378, 171, 186, 'UB2202111148458207', 0.31, 6, 1, 1644551333, NULL);
INSERT INTO `xy_balance_log` VALUES (3379, 181, 186, 'UB2202111148458207', 0.48, 6, 1, 1644551333, NULL);
INSERT INTO `xy_balance_log` VALUES (3380, 182, 0, 'CO2202111149348481', 956.00, 7, 2, 1644551374, NULL);
INSERT INTO `xy_balance_log` VALUES (3381, 186, 186, 'UB2202111257062962', 725.00, 2, 2, 1644555434, NULL);
INSERT INTO `xy_balance_log` VALUES (3382, 186, 186, 'UB2202111257062962', 4.06, 3, 1, 1644555434, NULL);
INSERT INTO `xy_balance_log` VALUES (3383, 186, 186, 'UB2202111257062962', 725.00, 2, 1, 1644555434, NULL);
INSERT INTO `xy_balance_log` VALUES (3384, 171, 186, 'UB2202111257062962', 0.37, 6, 1, 1644555434, NULL);
INSERT INTO `xy_balance_log` VALUES (3385, 181, 186, 'UB2202111257062962', 0.57, 6, 1, 1644555434, NULL);
INSERT INTO `xy_balance_log` VALUES (3386, 186, 186, 'UB2202111257227693', 735.00, 2, 2, 1644555451, NULL);
INSERT INTO `xy_balance_log` VALUES (3387, 186, 186, 'UB2202111257227693', 4.12, 3, 1, 1644555451, NULL);
INSERT INTO `xy_balance_log` VALUES (3388, 186, 186, 'UB2202111257227693', 735.00, 2, 1, 1644555451, NULL);
INSERT INTO `xy_balance_log` VALUES (3389, 171, 186, 'UB2202111257227693', 0.37, 6, 1, 1644555451, NULL);
INSERT INTO `xy_balance_log` VALUES (3390, 181, 186, 'UB2202111257227693', 0.58, 6, 1, 1644555451, NULL);
INSERT INTO `xy_balance_log` VALUES (3391, 186, 186, 'UB2202111257546418', 576.00, 2, 2, 1644555490, NULL);
INSERT INTO `xy_balance_log` VALUES (3392, 186, 186, 'UB2202111257546418', 3.23, 3, 1, 1644555490, NULL);
INSERT INTO `xy_balance_log` VALUES (3393, 186, 186, 'UB2202111257546418', 576.00, 2, 1, 1644555490, NULL);
INSERT INTO `xy_balance_log` VALUES (3394, 171, 186, 'UB2202111257546418', 0.29, 6, 1, 1644555490, NULL);
INSERT INTO `xy_balance_log` VALUES (3395, 181, 186, 'UB2202111257546418', 0.45, 6, 1, 1644555490, NULL);
INSERT INTO `xy_balance_log` VALUES (3396, 186, 0, 'CO2202111259084872', 1000.00, 7, 2, 1644555548, NULL);
INSERT INTO `xy_balance_log` VALUES (3397, 182, 0, 'SY2202111407545294', 64.00, 1, 1, 1644560227, NULL);
INSERT INTO `xy_balance_log` VALUES (3398, 187, 0, 'SY2202111418182512', 500.00, 1, 1, 1644560306, NULL);
INSERT INTO `xy_balance_log` VALUES (3399, 182, 0, 'SY2202111420205937', 50.00, 1, 1, 1644560430, NULL);
INSERT INTO `xy_balance_log` VALUES (3400, 183, 188, '', 0.50, 5, 1, 1644560686, NULL);
INSERT INTO `xy_balance_log` VALUES (3401, 181, 189, '', 0.50, 5, 1, 1644560724, NULL);
INSERT INTO `xy_balance_log` VALUES (3402, 184, 190, '', 0.50, 5, 1, 1644560957, NULL);
INSERT INTO `xy_balance_log` VALUES (3403, 190, 0, 'SY2202111431289940', 100.00, 1, 1, 1644561116, NULL);
INSERT INTO `xy_balance_log` VALUES (3404, 184, 0, 'SY2202111431289940', 5.00, 5, 1, 1644561116, NULL);
INSERT INTO `xy_balance_log` VALUES (3405, 190, 190, 'UB2202111440079443', 108.00, 2, 2, 1644561701, NULL);
INSERT INTO `xy_balance_log` VALUES (3406, 190, 190, 'UB2202111440079443', 16.20, 3, 1, 1644561701, NULL);
INSERT INTO `xy_balance_log` VALUES (3407, 190, 190, 'UB2202111440079443', 108.00, 2, 1, 1644561701, NULL);
INSERT INTO `xy_balance_log` VALUES (3408, 190, 190, 'UB2202111443184310', 58.00, 2, 2, 1644561806, NULL);
INSERT INTO `xy_balance_log` VALUES (3409, 190, 190, 'UB2202111443184310', 8.70, 3, 1, 1644561806, NULL);
INSERT INTO `xy_balance_log` VALUES (3410, 190, 190, 'UB2202111443184310', 58.00, 2, 1, 1644561806, NULL);
INSERT INTO `xy_balance_log` VALUES (3411, 190, 190, 'UB2202111443351904', 125.00, 2, 2, 1644561822, NULL);
INSERT INTO `xy_balance_log` VALUES (3412, 190, 190, 'UB2202111443351904', 18.75, 3, 1, 1644561822, NULL);
INSERT INTO `xy_balance_log` VALUES (3413, 190, 190, 'UB2202111443351904', 125.00, 2, 1, 1644561822, NULL);
INSERT INTO `xy_balance_log` VALUES (3414, 188, 0, 'SY2202111458412212', 500.00, 1, 1, 1644562997, NULL);
INSERT INTO `xy_balance_log` VALUES (3415, 183, 0, 'SY2202111458412212', 25.00, 5, 1, 1644562997, NULL);
INSERT INTO `xy_balance_log` VALUES (3416, 190, 0, 'CO2202111507569911', 150.00, 7, 2, 1644563276, NULL);
INSERT INTO `xy_balance_log` VALUES (3417, 190, 0, 'SY2202111518214111', 1000.00, 1, 1, 1644563964, NULL);
INSERT INTO `xy_balance_log` VALUES (3418, 188, 188, 'UB2202111519499956', 213.00, 2, 2, 1644563999, NULL);
INSERT INTO `xy_balance_log` VALUES (3419, 188, 188, 'UB2202111519499956', 1.11, 3, 1, 1644563999, NULL);
INSERT INTO `xy_balance_log` VALUES (3420, 188, 188, 'UB2202111519499956', 213.00, 2, 1, 1644563999, NULL);
INSERT INTO `xy_balance_log` VALUES (3421, 171, 188, 'UB2202111519499956', 0.01, 6, 1, 1644563999, NULL);
INSERT INTO `xy_balance_log` VALUES (3422, 181, 188, 'UB2202111519499956', 0.08, 6, 1, 1644563999, NULL);
INSERT INTO `xy_balance_log` VALUES (3423, 183, 188, 'UB2202111519499956', 0.12, 6, 1, 1644563999, NULL);
INSERT INTO `xy_balance_log` VALUES (3424, 190, 190, 'UB2202111520298048', 747.00, 2, 2, 1644564037, NULL);
INSERT INTO `xy_balance_log` VALUES (3425, 190, 190, 'UB2202111520298048', 4.03, 3, 1, 1644564037, NULL);
INSERT INTO `xy_balance_log` VALUES (3426, 190, 190, 'UB2202111520298048', 747.00, 2, 1, 1644564037, NULL);
INSERT INTO `xy_balance_log` VALUES (3427, 171, 190, 'UB2202111520298048', 0.04, 6, 1, 1644564037, NULL);
INSERT INTO `xy_balance_log` VALUES (3428, 181, 190, 'UB2202111520298048', 0.28, 6, 1, 1644564037, NULL);
INSERT INTO `xy_balance_log` VALUES (3429, 184, 190, 'UB2202111520298048', 0.44, 6, 1, 1644564037, NULL);
INSERT INTO `xy_balance_log` VALUES (3430, 190, 190, 'UB2202111520449231', 799.00, 2, 2, 1644564054, NULL);
INSERT INTO `xy_balance_log` VALUES (3431, 190, 190, 'UB2202111520449231', 4.31, 3, 1, 1644564054, NULL);
INSERT INTO `xy_balance_log` VALUES (3432, 190, 190, 'UB2202111520449231', 799.00, 2, 1, 1644564054, NULL);
INSERT INTO `xy_balance_log` VALUES (3433, 171, 190, 'UB2202111520449231', 0.04, 6, 1, 1644564054, NULL);
INSERT INTO `xy_balance_log` VALUES (3434, 181, 190, 'UB2202111520449231', 0.30, 6, 1, 1644564054, NULL);
INSERT INTO `xy_balance_log` VALUES (3435, 184, 190, 'UB2202111520449231', 0.47, 6, 1, 1644564054, NULL);
INSERT INTO `xy_balance_log` VALUES (3436, 190, 190, 'UB2202111521003909', 684.00, 2, 2, 1644564069, NULL);
INSERT INTO `xy_balance_log` VALUES (3437, 190, 190, 'UB2202111521003909', 3.69, 3, 1, 1644564069, NULL);
INSERT INTO `xy_balance_log` VALUES (3438, 190, 190, 'UB2202111521003909', 684.00, 2, 1, 1644564069, NULL);
INSERT INTO `xy_balance_log` VALUES (3439, 171, 190, 'UB2202111521003909', 0.04, 6, 1, 1644564069, NULL);
INSERT INTO `xy_balance_log` VALUES (3440, 181, 190, 'UB2202111521003909', 0.26, 6, 1, 1644564069, NULL);
INSERT INTO `xy_balance_log` VALUES (3441, 184, 190, 'UB2202111521003909', 0.41, 6, 1, 1644564069, NULL);
INSERT INTO `xy_balance_log` VALUES (3442, 190, 190, 'UB2202111521167122', 496.00, 2, 2, 1644564083, NULL);
INSERT INTO `xy_balance_log` VALUES (3443, 190, 190, 'UB2202111521167122', 2.68, 3, 1, 1644564083, NULL);
INSERT INTO `xy_balance_log` VALUES (3444, 190, 190, 'UB2202111521167122', 496.00, 2, 1, 1644564083, NULL);
INSERT INTO `xy_balance_log` VALUES (3445, 171, 190, 'UB2202111521167122', 0.03, 6, 1, 1644564083, NULL);
INSERT INTO `xy_balance_log` VALUES (3446, 181, 190, 'UB2202111521167122', 0.19, 6, 1, 1644564083, NULL);
INSERT INTO `xy_balance_log` VALUES (3447, 184, 190, 'UB2202111521167122', 0.29, 6, 1, 1644564083, NULL);
INSERT INTO `xy_balance_log` VALUES (3448, 190, 190, 'UB2202111521323279', 680.00, 2, 2, 1644564099, NULL);
INSERT INTO `xy_balance_log` VALUES (3449, 190, 190, 'UB2202111521323279', 3.67, 3, 1, 1644564099, NULL);
INSERT INTO `xy_balance_log` VALUES (3450, 190, 190, 'UB2202111521323279', 680.00, 2, 1, 1644564099, NULL);
INSERT INTO `xy_balance_log` VALUES (3451, 171, 190, 'UB2202111521323279', 0.04, 6, 1, 1644564099, NULL);
INSERT INTO `xy_balance_log` VALUES (3452, 181, 190, 'UB2202111521323279', 0.26, 6, 1, 1644564099, NULL);
INSERT INTO `xy_balance_log` VALUES (3453, 184, 190, 'UB2202111521323279', 0.40, 6, 1, 1644564099, NULL);
INSERT INTO `xy_balance_log` VALUES (3454, 190, 190, 'UB2202111521473189', 570.00, 2, 2, 1644564114, NULL);
INSERT INTO `xy_balance_log` VALUES (3455, 190, 190, 'UB2202111521473189', 3.08, 3, 1, 1644564114, NULL);
INSERT INTO `xy_balance_log` VALUES (3456, 190, 190, 'UB2202111521473189', 570.00, 2, 1, 1644564114, NULL);
INSERT INTO `xy_balance_log` VALUES (3457, 171, 190, 'UB2202111521473189', 0.03, 6, 1, 1644564114, NULL);
INSERT INTO `xy_balance_log` VALUES (3458, 181, 190, 'UB2202111521473189', 0.22, 6, 1, 1644564114, NULL);
INSERT INTO `xy_balance_log` VALUES (3459, 184, 190, 'UB2202111521473189', 0.34, 6, 1, 1644564114, NULL);
INSERT INTO `xy_balance_log` VALUES (3460, 190, 190, 'UB2202111522006509', 433.00, 2, 2, 1644564127, NULL);
INSERT INTO `xy_balance_log` VALUES (3461, 190, 190, 'UB2202111522006509', 2.34, 3, 1, 1644564127, NULL);
INSERT INTO `xy_balance_log` VALUES (3462, 190, 190, 'UB2202111522006509', 433.00, 2, 1, 1644564127, NULL);
INSERT INTO `xy_balance_log` VALUES (3463, 171, 190, 'UB2202111522006509', 0.02, 6, 1, 1644564127, NULL);
INSERT INTO `xy_balance_log` VALUES (3464, 181, 190, 'UB2202111522006509', 0.16, 6, 1, 1644564127, NULL);
INSERT INTO `xy_balance_log` VALUES (3465, 184, 190, 'UB2202111522006509', 0.26, 6, 1, 1644564127, NULL);
INSERT INTO `xy_balance_log` VALUES (3466, 190, 190, 'UB2202111522143012', 751.00, 2, 2, 1644564141, NULL);
INSERT INTO `xy_balance_log` VALUES (3467, 190, 190, 'UB2202111522143012', 4.06, 3, 1, 1644564141, NULL);
INSERT INTO `xy_balance_log` VALUES (3468, 190, 190, 'UB2202111522143012', 751.00, 2, 1, 1644564141, NULL);
INSERT INTO `xy_balance_log` VALUES (3469, 171, 190, 'UB2202111522143012', 0.04, 6, 1, 1644564141, NULL);
INSERT INTO `xy_balance_log` VALUES (3470, 181, 190, 'UB2202111522143012', 0.28, 6, 1, 1644564141, NULL);
INSERT INTO `xy_balance_log` VALUES (3471, 184, 190, 'UB2202111522143012', 0.45, 6, 1, 1644564141, NULL);
INSERT INTO `xy_balance_log` VALUES (3472, 188, 188, 'UB2202111522256692', 194.00, 2, 2, 1644564154, NULL);
INSERT INTO `xy_balance_log` VALUES (3473, 188, 188, 'UB2202111522256692', 1.01, 3, 1, 1644564154, NULL);
INSERT INTO `xy_balance_log` VALUES (3474, 188, 188, 'UB2202111522256692', 194.00, 2, 1, 1644564154, NULL);
INSERT INTO `xy_balance_log` VALUES (3475, 171, 188, 'UB2202111522256692', 0.01, 6, 1, 1644564154, NULL);
INSERT INTO `xy_balance_log` VALUES (3476, 181, 188, 'UB2202111522256692', 0.07, 6, 1, 1644564154, NULL);
INSERT INTO `xy_balance_log` VALUES (3477, 183, 188, 'UB2202111522256692', 0.11, 6, 1, 1644564154, NULL);
INSERT INTO `xy_balance_log` VALUES (3478, 190, 190, 'UB2202111522286687', 832.00, 2, 2, 1644564155, NULL);
INSERT INTO `xy_balance_log` VALUES (3479, 190, 190, 'UB2202111522286687', 4.49, 3, 1, 1644564155, NULL);
INSERT INTO `xy_balance_log` VALUES (3480, 190, 190, 'UB2202111522286687', 832.00, 2, 1, 1644564155, NULL);
INSERT INTO `xy_balance_log` VALUES (3481, 171, 190, 'UB2202111522286687', 0.04, 6, 1, 1644564155, NULL);
INSERT INTO `xy_balance_log` VALUES (3482, 181, 190, 'UB2202111522286687', 0.31, 6, 1, 1644564155, NULL);
INSERT INTO `xy_balance_log` VALUES (3483, 184, 190, 'UB2202111522286687', 0.49, 6, 1, 1644564155, NULL);
INSERT INTO `xy_balance_log` VALUES (3484, 190, 190, 'UB2202111522426024', 528.00, 2, 2, 1644564169, NULL);
INSERT INTO `xy_balance_log` VALUES (3485, 190, 190, 'UB2202111522426024', 2.85, 3, 1, 1644564169, NULL);
INSERT INTO `xy_balance_log` VALUES (3486, 190, 190, 'UB2202111522426024', 528.00, 2, 1, 1644564169, NULL);
INSERT INTO `xy_balance_log` VALUES (3487, 171, 190, 'UB2202111522426024', 0.03, 6, 1, 1644564169, NULL);
INSERT INTO `xy_balance_log` VALUES (3488, 181, 190, 'UB2202111522426024', 0.20, 6, 1, 1644564169, NULL);
INSERT INTO `xy_balance_log` VALUES (3489, 184, 190, 'UB2202111522426024', 0.31, 6, 1, 1644564169, NULL);
INSERT INTO `xy_balance_log` VALUES (3490, 188, 188, 'UB2202111522433082', 210.00, 2, 2, 1644564171, NULL);
INSERT INTO `xy_balance_log` VALUES (3491, 188, 188, 'UB2202111522433082', 1.09, 3, 1, 1644564171, NULL);
INSERT INTO `xy_balance_log` VALUES (3492, 188, 188, 'UB2202111522433082', 210.00, 2, 1, 1644564171, NULL);
INSERT INTO `xy_balance_log` VALUES (3493, 171, 188, 'UB2202111522433082', 0.01, 6, 1, 1644564171, NULL);
INSERT INTO `xy_balance_log` VALUES (3494, 181, 188, 'UB2202111522433082', 0.08, 6, 1, 1644564171, NULL);
INSERT INTO `xy_balance_log` VALUES (3495, 183, 188, 'UB2202111522433082', 0.12, 6, 1, 1644564171, NULL);
INSERT INTO `xy_balance_log` VALUES (3496, 188, 188, 'UB2202111522596910', 282.00, 2, 2, 1644564186, NULL);
INSERT INTO `xy_balance_log` VALUES (3497, 188, 188, 'UB2202111522596910', 1.47, 3, 1, 1644564186, NULL);
INSERT INTO `xy_balance_log` VALUES (3498, 188, 188, 'UB2202111522596910', 282.00, 2, 1, 1644564186, NULL);
INSERT INTO `xy_balance_log` VALUES (3499, 171, 188, 'UB2202111522596910', 0.01, 6, 1, 1644564186, NULL);
INSERT INTO `xy_balance_log` VALUES (3500, 181, 188, 'UB2202111522596910', 0.10, 6, 1, 1644564186, NULL);
INSERT INTO `xy_balance_log` VALUES (3501, 183, 188, 'UB2202111522596910', 0.16, 6, 1, 1644564186, NULL);
INSERT INTO `xy_balance_log` VALUES (3502, 188, 188, 'UB2202111523143954', 380.00, 2, 2, 1644564202, NULL);
INSERT INTO `xy_balance_log` VALUES (3503, 188, 188, 'UB2202111523143954', 1.98, 3, 1, 1644564202, NULL);
INSERT INTO `xy_balance_log` VALUES (3504, 188, 188, 'UB2202111523143954', 380.00, 2, 1, 1644564202, NULL);
INSERT INTO `xy_balance_log` VALUES (3505, 171, 188, 'UB2202111523143954', 0.02, 6, 1, 1644564202, NULL);
INSERT INTO `xy_balance_log` VALUES (3506, 181, 188, 'UB2202111523143954', 0.14, 6, 1, 1644564202, NULL);
INSERT INTO `xy_balance_log` VALUES (3507, 183, 188, 'UB2202111523143954', 0.22, 6, 1, 1644564202, NULL);
INSERT INTO `xy_balance_log` VALUES (3508, 190, 0, 'CO2202111524245653', 950.00, 7, 2, 1644564264, NULL);
INSERT INTO `xy_balance_log` VALUES (3509, 187, 187, 'UB2202111540572198', 217.00, 2, 2, 1644565264, NULL);
INSERT INTO `xy_balance_log` VALUES (3510, 187, 187, 'UB2202111540572198', 1.13, 3, 1, 1644565264, NULL);
INSERT INTO `xy_balance_log` VALUES (3511, 187, 187, 'UB2202111540572198', 217.00, 2, 1, 1644565264, NULL);
INSERT INTO `xy_balance_log` VALUES (3512, 171, 187, 'UB2202111540572198', 0.10, 6, 1, 1644565264, NULL);
INSERT INTO `xy_balance_log` VALUES (3513, 181, 187, 'UB2202111540572198', 0.16, 6, 1, 1644565264, NULL);
INSERT INTO `xy_balance_log` VALUES (3514, 187, 187, 'UB2202111541104059', 239.00, 2, 2, 1644565277, NULL);
INSERT INTO `xy_balance_log` VALUES (3515, 187, 187, 'UB2202111541104059', 1.24, 3, 1, 1644565277, NULL);
INSERT INTO `xy_balance_log` VALUES (3516, 187, 187, 'UB2202111541104059', 239.00, 2, 1, 1644565277, NULL);
INSERT INTO `xy_balance_log` VALUES (3517, 171, 187, 'UB2202111541104059', 0.11, 6, 1, 1644565277, NULL);
INSERT INTO `xy_balance_log` VALUES (3518, 181, 187, 'UB2202111541104059', 0.17, 6, 1, 1644565277, NULL);
INSERT INTO `xy_balance_log` VALUES (3519, 190, 0, 'SY2202111540507732', 400.00, 1, 1, 1644565278, NULL);
INSERT INTO `xy_balance_log` VALUES (3520, 187, 187, 'UB2202111541272213', 196.00, 2, 2, 1644565298, NULL);
INSERT INTO `xy_balance_log` VALUES (3521, 187, 187, 'UB2202111541272213', 1.02, 3, 1, 1644565298, NULL);
INSERT INTO `xy_balance_log` VALUES (3522, 187, 187, 'UB2202111541272213', 196.00, 2, 1, 1644565298, NULL);
INSERT INTO `xy_balance_log` VALUES (3523, 171, 187, 'UB2202111541272213', 0.09, 6, 1, 1644565298, NULL);
INSERT INTO `xy_balance_log` VALUES (3524, 181, 187, 'UB2202111541272213', 0.14, 6, 1, 1644565298, NULL);
INSERT INTO `xy_balance_log` VALUES (3525, 188, 0, 'CO2202111541492480', 490.00, 7, 2, 1644565309, NULL);
INSERT INTO `xy_balance_log` VALUES (3526, 187, 187, 'UB2202111541451619', 410.00, 2, 2, 1644565312, NULL);
INSERT INTO `xy_balance_log` VALUES (3527, 187, 187, 'UB2202111541451619', 2.13, 3, 1, 1644565312, NULL);
INSERT INTO `xy_balance_log` VALUES (3528, 187, 187, 'UB2202111541451619', 410.00, 2, 1, 1644565312, NULL);
INSERT INTO `xy_balance_log` VALUES (3529, 171, 187, 'UB2202111541451619', 0.19, 6, 1, 1644565312, NULL);
INSERT INTO `xy_balance_log` VALUES (3530, 181, 187, 'UB2202111541451619', 0.30, 6, 1, 1644565312, NULL);
INSERT INTO `xy_balance_log` VALUES (3531, 187, 187, 'UB2202111541587862', 192.00, 2, 2, 1644565325, NULL);
INSERT INTO `xy_balance_log` VALUES (3532, 187, 187, 'UB2202111541587862', 1.00, 3, 1, 1644565325, NULL);
INSERT INTO `xy_balance_log` VALUES (3533, 187, 187, 'UB2202111541587862', 192.00, 2, 1, 1644565325, NULL);
INSERT INTO `xy_balance_log` VALUES (3534, 171, 187, 'UB2202111541587862', 0.09, 6, 1, 1644565325, NULL);
INSERT INTO `xy_balance_log` VALUES (3535, 181, 187, 'UB2202111541587862', 0.14, 6, 1, 1644565325, NULL);
INSERT INTO `xy_balance_log` VALUES (3536, 187, 0, 'CO2202111547009121', 500.00, 7, 2, 1644565620, NULL);
INSERT INTO `xy_balance_log` VALUES (3537, 187, 0, 'CO2202111547009121', 500.00, 8, 1, 1644565669, NULL);
INSERT INTO `xy_balance_log` VALUES (3538, 190, 0, 'SY2202111549245939', 1000.00, 1, 1, 1644565775, NULL);
INSERT INTO `xy_balance_log` VALUES (3539, 190, 190, 'UB2202111556243532', 640.00, 2, 2, 1644566192, NULL);
INSERT INTO `xy_balance_log` VALUES (3540, 190, 190, 'UB2202111556243532', 1651.20, 3, 1, 1644566192, NULL);
INSERT INTO `xy_balance_log` VALUES (3541, 190, 190, 'UB2202111556243532', 640.00, 2, 1, 1644566192, NULL);
INSERT INTO `xy_balance_log` VALUES (3542, 171, 190, 'UB2202111556243532', 16.51, 6, 1, 1644566192, NULL);
INSERT INTO `xy_balance_log` VALUES (3543, 181, 190, 'UB2202111556243532', 115.58, 6, 1, 1644566193, NULL);
INSERT INTO `xy_balance_log` VALUES (3544, 184, 190, 'UB2202111556243532', 181.63, 6, 1, 1644566193, NULL);
INSERT INTO `xy_balance_log` VALUES (3545, 190, 0, 'SY2202111603283785', 100000.00, 1, 1, 1644566634, NULL);
INSERT INTO `xy_balance_log` VALUES (3546, 190, 190, 'UB2202111556396055', 5697.00, 2, 2, 1644566673, NULL);
INSERT INTO `xy_balance_log` VALUES (3547, 190, 190, 'UB2202111556396055', 1709.10, 3, 1, 1644566673, NULL);
INSERT INTO `xy_balance_log` VALUES (3548, 190, 190, 'UB2202111556396055', 5697.00, 2, 1, 1644566673, NULL);
INSERT INTO `xy_balance_log` VALUES (3549, 171, 190, 'UB2202111556396055', 17.09, 6, 1, 1644566673, NULL);
INSERT INTO `xy_balance_log` VALUES (3550, 181, 190, 'UB2202111556396055', 119.64, 6, 1, 1644566673, NULL);
INSERT INTO `xy_balance_log` VALUES (3551, 184, 190, 'UB2202111556396055', 188.00, 6, 1, 1644566673, NULL);
INSERT INTO `xy_balance_log` VALUES (3552, 186, 191, '', 0.50, 5, 1, 1644569123, NULL);
INSERT INTO `xy_balance_log` VALUES (3553, 187, 192, '', 0.50, 5, 1, 1644569279, NULL);
INSERT INTO `xy_balance_log` VALUES (3554, 192, 0, 'SY2202111648459792', 100.00, 1, 1, 1644569342, NULL);
INSERT INTO `xy_balance_log` VALUES (3555, 187, 0, 'SY2202111648459792', 5.00, 5, 1, 1644569342, NULL);
INSERT INTO `xy_balance_log` VALUES (3556, 192, 192, 'UB2202111650425542', 63.00, 2, 2, 1644569453, NULL);
INSERT INTO `xy_balance_log` VALUES (3557, 192, 192, 'UB2202111650425542', 9.45, 3, 1, 1644569453, NULL);
INSERT INTO `xy_balance_log` VALUES (3558, 192, 192, 'UB2202111650425542', 63.00, 2, 1, 1644569453, NULL);
INSERT INTO `xy_balance_log` VALUES (3559, 192, 192, 'UB2202111651046699', 45.00, 2, 2, 1644569473, NULL);
INSERT INTO `xy_balance_log` VALUES (3560, 192, 192, 'UB2202111651046699', 6.75, 3, 1, 1644569473, NULL);
INSERT INTO `xy_balance_log` VALUES (3561, 192, 192, 'UB2202111651046699', 45.00, 2, 1, 1644569473, NULL);
INSERT INTO `xy_balance_log` VALUES (3562, 192, 192, 'UB2202111651296461', 105.00, 2, 2, 1644569497, NULL);
INSERT INTO `xy_balance_log` VALUES (3563, 192, 192, 'UB2202111651296461', 15.75, 3, 1, 1644569497, NULL);
INSERT INTO `xy_balance_log` VALUES (3564, 192, 192, 'UB2202111651296461', 105.00, 2, 1, 1644569497, NULL);
INSERT INTO `xy_balance_log` VALUES (3565, 190, 193, '', 0.50, 5, 1, 1644569575, NULL);
INSERT INTO `xy_balance_log` VALUES (3566, 192, 0, 'CO2202111701261436', 100.00, 7, 2, 1644570086, NULL);
INSERT INTO `xy_balance_log` VALUES (3567, 192, 0, 'CO2202111701261436', 100.00, 8, 1, 1644570113, NULL);
INSERT INTO `xy_balance_log` VALUES (3568, 191, 0, 'SY2202111657498969', 100.00, 1, 1, 1644570157, NULL);
INSERT INTO `xy_balance_log` VALUES (3569, 186, 0, 'SY2202111657498969', 5.00, 5, 1, 1644570157, NULL);
INSERT INTO `xy_balance_log` VALUES (3570, 192, 0, 'CO2202111702445261', 100.00, 7, 2, 1644570164, NULL);
INSERT INTO `xy_balance_log` VALUES (3571, 192, 0, 'CO2202111702445261', 100.00, 8, 1, 1644570190, NULL);
INSERT INTO `xy_balance_log` VALUES (3572, 192, 0, 'CO2202111704007041', 100.00, 7, 2, 1644570240, NULL);
INSERT INTO `xy_balance_log` VALUES (3573, 193, 0, 'SY2202111706413470', 64.00, 1, 1, 1644570481, NULL);
INSERT INTO `xy_balance_log` VALUES (3574, 190, 0, 'SY2202111706413470', 3.20, 5, 1, 1644570481, NULL);
INSERT INTO `xy_balance_log` VALUES (3575, 191, 191, 'UB2202111709082216', 98.00, 2, 2, 1644570560, NULL);
INSERT INTO `xy_balance_log` VALUES (3576, 191, 191, 'UB2202111709082216', 14.70, 3, 1, 1644570560, NULL);
INSERT INTO `xy_balance_log` VALUES (3577, 191, 191, 'UB2202111709082216', 98.00, 2, 1, 1644570560, NULL);
INSERT INTO `xy_balance_log` VALUES (3578, 191, 191, 'UB2202111709284771', 103.00, 2, 2, 1644570577, NULL);
INSERT INTO `xy_balance_log` VALUES (3579, 191, 191, 'UB2202111709284771', 15.45, 3, 1, 1644570577, NULL);
INSERT INTO `xy_balance_log` VALUES (3580, 191, 191, 'UB2202111709284771', 103.00, 2, 1, 1644570577, NULL);
INSERT INTO `xy_balance_log` VALUES (3581, 191, 191, 'UB2202111709442870', 72.00, 2, 2, 1644570593, NULL);
INSERT INTO `xy_balance_log` VALUES (3582, 191, 191, 'UB2202111709442870', 10.80, 3, 1, 1644570593, NULL);
INSERT INTO `xy_balance_log` VALUES (3583, 191, 191, 'UB2202111709442870', 72.00, 2, 1, 1644570593, NULL);
INSERT INTO `xy_balance_log` VALUES (3584, 191, 0, 'CO2202111751088896', 100.00, 7, 2, 1644573068, NULL);
INSERT INTO `xy_balance_log` VALUES (3585, 193, 193, 'UB2202111803337490', 76.00, 2, 2, 1644573932, NULL);
INSERT INTO `xy_balance_log` VALUES (3586, 193, 193, 'UB2202111803337490', 11.40, 3, 1, 1644573932, NULL);
INSERT INTO `xy_balance_log` VALUES (3587, 193, 193, 'UB2202111803337490', 76.00, 2, 1, 1644573932, NULL);
INSERT INTO `xy_balance_log` VALUES (3588, 193, 193, 'UB2202111807224280', 67.00, 2, 2, 1644574050, NULL);
INSERT INTO `xy_balance_log` VALUES (3589, 193, 193, 'UB2202111807224280', 10.05, 3, 1, 1644574050, NULL);
INSERT INTO `xy_balance_log` VALUES (3590, 193, 193, 'UB2202111807224280', 67.00, 2, 1, 1644574050, NULL);
INSERT INTO `xy_balance_log` VALUES (3591, 193, 193, 'UB2202111807388459', 71.00, 2, 2, 1644574080, NULL);
INSERT INTO `xy_balance_log` VALUES (3592, 193, 193, 'UB2202111807388459', 10.65, 3, 1, 1644574080, NULL);
INSERT INTO `xy_balance_log` VALUES (3593, 193, 193, 'UB2202111807388459', 71.00, 2, 1, 1644574080, NULL);
INSERT INTO `xy_balance_log` VALUES (3594, 191, 0, 'SY2202111824344932', 5000.00, 1, 1, 1644575089, NULL);
INSERT INTO `xy_balance_log` VALUES (3595, 191, 191, 'UB2202111826074576', 3916.00, 2, 2, 1644575180, NULL);
INSERT INTO `xy_balance_log` VALUES (3596, 191, 191, 'UB2202111826074576', 25.06, 3, 1, 1644575180, NULL);
INSERT INTO `xy_balance_log` VALUES (3597, 191, 191, 'UB2202111826074576', 3916.00, 2, 1, 1644575180, NULL);
INSERT INTO `xy_balance_log` VALUES (3598, 171, 191, 'UB2202111826074576', 0.25, 6, 1, 1644575180, NULL);
INSERT INTO `xy_balance_log` VALUES (3599, 181, 191, 'UB2202111826074576', 1.75, 6, 1, 1644575180, NULL);
INSERT INTO `xy_balance_log` VALUES (3600, 186, 191, 'UB2202111826074576', 3.01, 6, 1, 1644575180, NULL);
INSERT INTO `xy_balance_log` VALUES (3601, 191, 191, 'UB2202111826322346', 2164.00, 2, 2, 1644575201, NULL);
INSERT INTO `xy_balance_log` VALUES (3602, 191, 191, 'UB2202111826322346', 13.85, 3, 1, 1644575201, NULL);
INSERT INTO `xy_balance_log` VALUES (3603, 191, 191, 'UB2202111826322346', 2164.00, 2, 1, 1644575201, NULL);
INSERT INTO `xy_balance_log` VALUES (3604, 171, 191, 'UB2202111826322346', 0.14, 6, 1, 1644575201, NULL);
INSERT INTO `xy_balance_log` VALUES (3605, 181, 191, 'UB2202111826322346', 0.97, 6, 1, 1644575201, NULL);
INSERT INTO `xy_balance_log` VALUES (3606, 186, 191, 'UB2202111826322346', 1.66, 6, 1, 1644575201, NULL);
INSERT INTO `xy_balance_log` VALUES (3607, 191, 191, 'UB2202111826517018', 3317.00, 2, 2, 1644575220, NULL);
INSERT INTO `xy_balance_log` VALUES (3608, 191, 191, 'UB2202111826517018', 21.23, 3, 1, 1644575220, NULL);
INSERT INTO `xy_balance_log` VALUES (3609, 191, 191, 'UB2202111826517018', 3317.00, 2, 1, 1644575220, NULL);
INSERT INTO `xy_balance_log` VALUES (3610, 171, 191, 'UB2202111826517018', 0.21, 6, 1, 1644575220, NULL);
INSERT INTO `xy_balance_log` VALUES (3611, 181, 191, 'UB2202111826517018', 1.49, 6, 1, 1644575220, NULL);
INSERT INTO `xy_balance_log` VALUES (3612, 186, 191, 'UB2202111826517018', 2.55, 6, 1, 1644575220, NULL);
INSERT INTO `xy_balance_log` VALUES (3613, 191, 191, 'UB2202111827073644', 4101.00, 2, 2, 1644575240, NULL);
INSERT INTO `xy_balance_log` VALUES (3614, 191, 191, 'UB2202111827073644', 26.25, 3, 1, 1644575240, NULL);
INSERT INTO `xy_balance_log` VALUES (3615, 191, 191, 'UB2202111827073644', 4101.00, 2, 1, 1644575240, NULL);
INSERT INTO `xy_balance_log` VALUES (3616, 171, 191, 'UB2202111827073644', 0.26, 6, 1, 1644575240, NULL);
INSERT INTO `xy_balance_log` VALUES (3617, 181, 191, 'UB2202111827073644', 1.84, 6, 1, 1644575240, NULL);
INSERT INTO `xy_balance_log` VALUES (3618, 186, 191, 'UB2202111827073644', 3.15, 6, 1, 1644575240, NULL);
INSERT INTO `xy_balance_log` VALUES (3619, 191, 191, 'UB2202111827274915', 1976.00, 2, 2, 1644575257, NULL);
INSERT INTO `xy_balance_log` VALUES (3620, 191, 191, 'UB2202111827274915', 12.65, 3, 1, 1644575257, NULL);
INSERT INTO `xy_balance_log` VALUES (3621, 191, 191, 'UB2202111827274915', 1976.00, 2, 1, 1644575257, NULL);
INSERT INTO `xy_balance_log` VALUES (3622, 171, 191, 'UB2202111827274915', 0.13, 6, 1, 1644575257, NULL);
INSERT INTO `xy_balance_log` VALUES (3623, 181, 191, 'UB2202111827274915', 0.89, 6, 1, 1644575257, NULL);
INSERT INTO `xy_balance_log` VALUES (3624, 186, 191, 'UB2202111827274915', 1.52, 6, 1, 1644575257, NULL);
INSERT INTO `xy_balance_log` VALUES (3625, 191, 191, 'UB2202111827447483', 3534.00, 2, 2, 1644575271, NULL);
INSERT INTO `xy_balance_log` VALUES (3626, 191, 191, 'UB2202111827447483', 22.62, 3, 1, 1644575271, NULL);
INSERT INTO `xy_balance_log` VALUES (3627, 191, 191, 'UB2202111827447483', 3534.00, 2, 1, 1644575271, NULL);
INSERT INTO `xy_balance_log` VALUES (3628, 171, 191, 'UB2202111827447483', 0.23, 6, 1, 1644575271, NULL);
INSERT INTO `xy_balance_log` VALUES (3629, 181, 191, 'UB2202111827447483', 1.58, 6, 1, 1644575271, NULL);
INSERT INTO `xy_balance_log` VALUES (3630, 186, 191, 'UB2202111827447483', 2.71, 6, 1, 1644575271, NULL);
INSERT INTO `xy_balance_log` VALUES (3631, 191, 191, 'UB2202111827589947', 3766.00, 2, 2, 1644575286, NULL);
INSERT INTO `xy_balance_log` VALUES (3632, 191, 191, 'UB2202111827589947', 24.10, 3, 1, 1644575286, NULL);
INSERT INTO `xy_balance_log` VALUES (3633, 191, 191, 'UB2202111827589947', 3766.00, 2, 1, 1644575286, NULL);
INSERT INTO `xy_balance_log` VALUES (3634, 171, 191, 'UB2202111827589947', 0.24, 6, 1, 1644575286, NULL);
INSERT INTO `xy_balance_log` VALUES (3635, 181, 191, 'UB2202111827589947', 1.69, 6, 1, 1644575286, NULL);
INSERT INTO `xy_balance_log` VALUES (3636, 186, 191, 'UB2202111827589947', 2.89, 6, 1, 1644575286, NULL);
INSERT INTO `xy_balance_log` VALUES (3637, 191, 191, 'UB2202111828137751', 2905.00, 2, 2, 1644575301, NULL);
INSERT INTO `xy_balance_log` VALUES (3638, 191, 191, 'UB2202111828137751', 18.59, 3, 1, 1644575301, NULL);
INSERT INTO `xy_balance_log` VALUES (3639, 191, 191, 'UB2202111828137751', 2905.00, 2, 1, 1644575301, NULL);
INSERT INTO `xy_balance_log` VALUES (3640, 171, 191, 'UB2202111828137751', 0.19, 6, 1, 1644575301, NULL);
INSERT INTO `xy_balance_log` VALUES (3641, 181, 191, 'UB2202111828137751', 1.30, 6, 1, 1644575301, NULL);
INSERT INTO `xy_balance_log` VALUES (3642, 186, 191, 'UB2202111828137751', 2.23, 6, 1, 1644575301, NULL);
INSERT INTO `xy_balance_log` VALUES (3643, 191, 191, 'UB2202111828282971', 4038.00, 2, 2, 1644575316, NULL);
INSERT INTO `xy_balance_log` VALUES (3644, 191, 191, 'UB2202111828282971', 25.84, 3, 1, 1644575316, NULL);
INSERT INTO `xy_balance_log` VALUES (3645, 191, 191, 'UB2202111828282971', 4038.00, 2, 1, 1644575316, NULL);
INSERT INTO `xy_balance_log` VALUES (3646, 171, 191, 'UB2202111828282971', 0.26, 6, 1, 1644575316, NULL);
INSERT INTO `xy_balance_log` VALUES (3647, 181, 191, 'UB2202111828282971', 1.81, 6, 1, 1644575316, NULL);
INSERT INTO `xy_balance_log` VALUES (3648, 186, 191, 'UB2202111828282971', 3.10, 6, 1, 1644575316, NULL);
INSERT INTO `xy_balance_log` VALUES (3649, 191, 191, 'UB2202111828533686', 2466.00, 2, 2, 1644575343, NULL);
INSERT INTO `xy_balance_log` VALUES (3650, 191, 191, 'UB2202111828533686', 15.78, 3, 1, 1644575343, NULL);
INSERT INTO `xy_balance_log` VALUES (3651, 191, 191, 'UB2202111828533686', 2466.00, 2, 1, 1644575343, NULL);
INSERT INTO `xy_balance_log` VALUES (3652, 171, 191, 'UB2202111828533686', 0.16, 6, 1, 1644575343, NULL);
INSERT INTO `xy_balance_log` VALUES (3653, 181, 191, 'UB2202111828533686', 1.10, 6, 1, 1644575343, NULL);
INSERT INTO `xy_balance_log` VALUES (3654, 186, 191, 'UB2202111828533686', 1.89, 6, 1, 1644575343, NULL);
INSERT INTO `xy_balance_log` VALUES (3655, 191, 191, 'UB2202111829284011', 1829.00, 2, 2, 1644575377, NULL);
INSERT INTO `xy_balance_log` VALUES (3656, 191, 191, 'UB2202111829284011', 11.71, 3, 1, 1644575377, NULL);
INSERT INTO `xy_balance_log` VALUES (3657, 191, 191, 'UB2202111829284011', 1829.00, 2, 1, 1644575377, NULL);
INSERT INTO `xy_balance_log` VALUES (3658, 171, 191, 'UB2202111829284011', 0.12, 6, 1, 1644575377, NULL);
INSERT INTO `xy_balance_log` VALUES (3659, 181, 191, 'UB2202111829284011', 0.82, 6, 1, 1644575377, NULL);
INSERT INTO `xy_balance_log` VALUES (3660, 186, 191, 'UB2202111829284011', 1.41, 6, 1, 1644575377, NULL);
INSERT INTO `xy_balance_log` VALUES (3661, 191, 191, 'UB2202111829458941', 2763.00, 2, 2, 1644575393, NULL);
INSERT INTO `xy_balance_log` VALUES (3662, 191, 191, 'UB2202111829458941', 17.68, 3, 1, 1644575393, NULL);
INSERT INTO `xy_balance_log` VALUES (3663, 191, 191, 'UB2202111829458941', 2763.00, 2, 1, 1644575393, NULL);
INSERT INTO `xy_balance_log` VALUES (3664, 171, 191, 'UB2202111829458941', 0.18, 6, 1, 1644575393, NULL);
INSERT INTO `xy_balance_log` VALUES (3665, 181, 191, 'UB2202111829458941', 1.24, 6, 1, 1644575393, NULL);
INSERT INTO `xy_balance_log` VALUES (3666, 186, 191, 'UB2202111829458941', 2.12, 6, 1, 1644575393, NULL);
INSERT INTO `xy_balance_log` VALUES (3667, 191, 191, 'UB2202111829598039', 2738.00, 2, 2, 1644575407, NULL);
INSERT INTO `xy_balance_log` VALUES (3668, 191, 191, 'UB2202111829598039', 17.52, 3, 1, 1644575407, NULL);
INSERT INTO `xy_balance_log` VALUES (3669, 191, 191, 'UB2202111829598039', 2738.00, 2, 1, 1644575407, NULL);
INSERT INTO `xy_balance_log` VALUES (3670, 171, 191, 'UB2202111829598039', 0.18, 6, 1, 1644575407, NULL);
INSERT INTO `xy_balance_log` VALUES (3671, 181, 191, 'UB2202111829598039', 1.23, 6, 1, 1644575407, NULL);
INSERT INTO `xy_balance_log` VALUES (3672, 186, 191, 'UB2202111829598039', 2.10, 6, 1, 1644575407, NULL);
INSERT INTO `xy_balance_log` VALUES (3673, 191, 191, 'UB2202111830142332', 2822.00, 2, 2, 1644575422, NULL);
INSERT INTO `xy_balance_log` VALUES (3674, 191, 191, 'UB2202111830142332', 18.06, 3, 1, 1644575422, NULL);
INSERT INTO `xy_balance_log` VALUES (3675, 191, 191, 'UB2202111830142332', 2822.00, 2, 1, 1644575422, NULL);
INSERT INTO `xy_balance_log` VALUES (3676, 171, 191, 'UB2202111830142332', 0.18, 6, 1, 1644575422, NULL);
INSERT INTO `xy_balance_log` VALUES (3677, 181, 191, 'UB2202111830142332', 1.26, 6, 1, 1644575422, NULL);
INSERT INTO `xy_balance_log` VALUES (3678, 186, 191, 'UB2202111830142332', 2.17, 6, 1, 1644575422, NULL);
INSERT INTO `xy_balance_log` VALUES (3679, 191, 191, 'UB2202111830297932', 2951.00, 2, 2, 1644575438, NULL);
INSERT INTO `xy_balance_log` VALUES (3680, 191, 191, 'UB2202111830297932', 18.89, 3, 1, 1644575438, NULL);
INSERT INTO `xy_balance_log` VALUES (3681, 191, 191, 'UB2202111830297932', 2951.00, 2, 1, 1644575438, NULL);
INSERT INTO `xy_balance_log` VALUES (3682, 171, 191, 'UB2202111830297932', 0.19, 6, 1, 1644575438, NULL);
INSERT INTO `xy_balance_log` VALUES (3683, 181, 191, 'UB2202111830297932', 1.32, 6, 1, 1644575438, NULL);
INSERT INTO `xy_balance_log` VALUES (3684, 186, 191, 'UB2202111830297932', 2.27, 6, 1, 1644575438, NULL);
INSERT INTO `xy_balance_log` VALUES (3685, 191, 191, 'UB2202111830448954', 3668.00, 2, 2, 1644575452, NULL);
INSERT INTO `xy_balance_log` VALUES (3686, 191, 191, 'UB2202111830448954', 23.48, 3, 1, 1644575452, NULL);
INSERT INTO `xy_balance_log` VALUES (3687, 191, 191, 'UB2202111830448954', 3668.00, 2, 1, 1644575452, NULL);
INSERT INTO `xy_balance_log` VALUES (3688, 171, 191, 'UB2202111830448954', 0.23, 6, 1, 1644575452, NULL);
INSERT INTO `xy_balance_log` VALUES (3689, 181, 191, 'UB2202111830448954', 1.64, 6, 1, 1644575452, NULL);
INSERT INTO `xy_balance_log` VALUES (3690, 186, 191, 'UB2202111830448954', 2.82, 6, 1, 1644575452, NULL);
INSERT INTO `xy_balance_log` VALUES (3691, 191, 191, 'UB2202111830582783', 3741.00, 2, 2, 1644575466, NULL);
INSERT INTO `xy_balance_log` VALUES (3692, 191, 191, 'UB2202111830582783', 23.94, 3, 1, 1644575466, NULL);
INSERT INTO `xy_balance_log` VALUES (3693, 191, 191, 'UB2202111830582783', 3741.00, 2, 1, 1644575466, NULL);
INSERT INTO `xy_balance_log` VALUES (3694, 171, 191, 'UB2202111830582783', 0.24, 6, 1, 1644575466, NULL);
INSERT INTO `xy_balance_log` VALUES (3695, 181, 191, 'UB2202111830582783', 1.68, 6, 1, 1644575466, NULL);
INSERT INTO `xy_balance_log` VALUES (3696, 186, 191, 'UB2202111830582783', 2.87, 6, 1, 1644575466, NULL);
INSERT INTO `xy_balance_log` VALUES (3697, 191, 191, 'UB2202111831141527', 2090.00, 2, 2, 1644575481, NULL);
INSERT INTO `xy_balance_log` VALUES (3698, 191, 191, 'UB2202111831141527', 13.38, 3, 1, 1644575481, NULL);
INSERT INTO `xy_balance_log` VALUES (3699, 191, 191, 'UB2202111831141527', 2090.00, 2, 1, 1644575481, NULL);
INSERT INTO `xy_balance_log` VALUES (3700, 171, 191, 'UB2202111831141527', 0.13, 6, 1, 1644575481, NULL);
INSERT INTO `xy_balance_log` VALUES (3701, 181, 191, 'UB2202111831141527', 0.94, 6, 1, 1644575481, NULL);
INSERT INTO `xy_balance_log` VALUES (3702, 186, 191, 'UB2202111831141527', 1.61, 6, 1, 1644575481, NULL);
INSERT INTO `xy_balance_log` VALUES (3703, 191, 191, 'UB2202111831289050', 3448.00, 2, 2, 1644575496, NULL);
INSERT INTO `xy_balance_log` VALUES (3704, 191, 191, 'UB2202111831289050', 22.07, 3, 1, 1644575496, NULL);
INSERT INTO `xy_balance_log` VALUES (3705, 191, 191, 'UB2202111831289050', 3448.00, 2, 1, 1644575496, NULL);
INSERT INTO `xy_balance_log` VALUES (3706, 171, 191, 'UB2202111831289050', 0.22, 6, 1, 1644575496, NULL);
INSERT INTO `xy_balance_log` VALUES (3707, 181, 191, 'UB2202111831289050', 1.54, 6, 1, 1644575496, NULL);
INSERT INTO `xy_balance_log` VALUES (3708, 186, 191, 'UB2202111831289050', 2.65, 6, 1, 1644575496, NULL);
INSERT INTO `xy_balance_log` VALUES (3709, 191, 191, 'UB2202111831444984', 3033.00, 2, 2, 1644575512, NULL);
INSERT INTO `xy_balance_log` VALUES (3710, 191, 191, 'UB2202111831444984', 19.41, 3, 1, 1644575512, NULL);
INSERT INTO `xy_balance_log` VALUES (3711, 191, 191, 'UB2202111831444984', 3033.00, 2, 1, 1644575512, NULL);
INSERT INTO `xy_balance_log` VALUES (3712, 171, 191, 'UB2202111831444984', 0.19, 6, 1, 1644575512, NULL);
INSERT INTO `xy_balance_log` VALUES (3713, 181, 191, 'UB2202111831444984', 1.36, 6, 1, 1644575512, NULL);
INSERT INTO `xy_balance_log` VALUES (3714, 186, 191, 'UB2202111831444984', 2.33, 6, 1, 1644575512, NULL);
INSERT INTO `xy_balance_log` VALUES (3715, 193, 0, 'CO2202111832049201', 132.00, 7, 2, 1644575524, NULL);
INSERT INTO `xy_balance_log` VALUES (3716, 191, 191, 'UB2202111831583057', 3627.00, 2, 2, 1644575527, NULL);
INSERT INTO `xy_balance_log` VALUES (3717, 191, 191, 'UB2202111831583057', 23.21, 3, 1, 1644575527, NULL);
INSERT INTO `xy_balance_log` VALUES (3718, 191, 191, 'UB2202111831583057', 3627.00, 2, 1, 1644575527, NULL);
INSERT INTO `xy_balance_log` VALUES (3719, 171, 191, 'UB2202111831583057', 0.23, 6, 1, 1644575527, NULL);
INSERT INTO `xy_balance_log` VALUES (3720, 181, 191, 'UB2202111831583057', 1.62, 6, 1, 1644575527, NULL);
INSERT INTO `xy_balance_log` VALUES (3721, 186, 191, 'UB2202111831583057', 2.79, 6, 1, 1644575527, NULL);
INSERT INTO `xy_balance_log` VALUES (3722, 191, 191, 'UB2202111832146920', 2913.00, 2, 2, 1644575541, NULL);
INSERT INTO `xy_balance_log` VALUES (3723, 191, 191, 'UB2202111832146920', 18.64, 3, 1, 1644575541, NULL);
INSERT INTO `xy_balance_log` VALUES (3724, 191, 191, 'UB2202111832146920', 2913.00, 2, 1, 1644575541, NULL);
INSERT INTO `xy_balance_log` VALUES (3725, 171, 191, 'UB2202111832146920', 0.19, 6, 1, 1644575541, NULL);
INSERT INTO `xy_balance_log` VALUES (3726, 181, 191, 'UB2202111832146920', 1.30, 6, 1, 1644575541, NULL);
INSERT INTO `xy_balance_log` VALUES (3727, 186, 191, 'UB2202111832146920', 2.24, 6, 1, 1644575541, NULL);
INSERT INTO `xy_balance_log` VALUES (3728, 191, 191, 'UB2202111832312348', 2612.00, 2, 2, 1644575559, NULL);
INSERT INTO `xy_balance_log` VALUES (3729, 191, 191, 'UB2202111832312348', 16.72, 3, 1, 1644575559, NULL);
INSERT INTO `xy_balance_log` VALUES (3730, 191, 191, 'UB2202111832312348', 2612.00, 2, 1, 1644575559, NULL);
INSERT INTO `xy_balance_log` VALUES (3731, 171, 191, 'UB2202111832312348', 0.17, 6, 1, 1644575559, NULL);
INSERT INTO `xy_balance_log` VALUES (3732, 181, 191, 'UB2202111832312348', 1.17, 6, 1, 1644575559, NULL);
INSERT INTO `xy_balance_log` VALUES (3733, 186, 191, 'UB2202111832312348', 2.01, 6, 1, 1644575559, NULL);
INSERT INTO `xy_balance_log` VALUES (3734, 191, 191, 'UB2202111832467739', 4120.00, 2, 2, 1644575575, NULL);
INSERT INTO `xy_balance_log` VALUES (3735, 191, 191, 'UB2202111832467739', 26.37, 3, 1, 1644575575, NULL);
INSERT INTO `xy_balance_log` VALUES (3736, 191, 191, 'UB2202111832467739', 4120.00, 2, 1, 1644575575, NULL);
INSERT INTO `xy_balance_log` VALUES (3737, 171, 191, 'UB2202111832467739', 0.26, 6, 1, 1644575575, NULL);
INSERT INTO `xy_balance_log` VALUES (3738, 181, 191, 'UB2202111832467739', 1.85, 6, 1, 1644575575, NULL);
INSERT INTO `xy_balance_log` VALUES (3739, 186, 191, 'UB2202111832467739', 3.16, 6, 1, 1644575575, NULL);
INSERT INTO `xy_balance_log` VALUES (3740, 191, 191, 'UB2202111833028985', 2575.00, 2, 2, 1644575592, NULL);
INSERT INTO `xy_balance_log` VALUES (3741, 191, 191, 'UB2202111833028985', 16.48, 3, 1, 1644575592, NULL);
INSERT INTO `xy_balance_log` VALUES (3742, 191, 191, 'UB2202111833028985', 2575.00, 2, 1, 1644575592, NULL);
INSERT INTO `xy_balance_log` VALUES (3743, 171, 191, 'UB2202111833028985', 0.16, 6, 1, 1644575592, NULL);
INSERT INTO `xy_balance_log` VALUES (3744, 181, 191, 'UB2202111833028985', 1.15, 6, 1, 1644575592, NULL);
INSERT INTO `xy_balance_log` VALUES (3745, 186, 191, 'UB2202111833028985', 1.98, 6, 1, 1644575592, NULL);
INSERT INTO `xy_balance_log` VALUES (3746, 191, 191, 'UB2202111833198596', 4426.00, 2, 2, 1644575606, NULL);
INSERT INTO `xy_balance_log` VALUES (3747, 191, 191, 'UB2202111833198596', 28.33, 3, 1, 1644575606, NULL);
INSERT INTO `xy_balance_log` VALUES (3748, 191, 191, 'UB2202111833198596', 4426.00, 2, 1, 1644575606, NULL);
INSERT INTO `xy_balance_log` VALUES (3749, 171, 191, 'UB2202111833198596', 0.28, 6, 1, 1644575606, NULL);
INSERT INTO `xy_balance_log` VALUES (3750, 181, 191, 'UB2202111833198596', 1.98, 6, 1, 1644575606, NULL);
INSERT INTO `xy_balance_log` VALUES (3751, 186, 191, 'UB2202111833198596', 3.40, 6, 1, 1644575606, NULL);
INSERT INTO `xy_balance_log` VALUES (3752, 191, 191, 'UB2202111833356778', 2131.00, 2, 2, 1644575622, NULL);
INSERT INTO `xy_balance_log` VALUES (3753, 191, 191, 'UB2202111833356778', 13.64, 3, 1, 1644575622, NULL);
INSERT INTO `xy_balance_log` VALUES (3754, 191, 191, 'UB2202111833356778', 2131.00, 2, 1, 1644575622, NULL);
INSERT INTO `xy_balance_log` VALUES (3755, 171, 191, 'UB2202111833356778', 0.14, 6, 1, 1644575622, NULL);
INSERT INTO `xy_balance_log` VALUES (3756, 181, 191, 'UB2202111833356778', 0.95, 6, 1, 1644575622, NULL);
INSERT INTO `xy_balance_log` VALUES (3757, 186, 191, 'UB2202111833356778', 1.64, 6, 1, 1644575622, NULL);
INSERT INTO `xy_balance_log` VALUES (3758, 191, 191, 'UB2202111833498709', 2569.00, 2, 2, 1644575637, NULL);
INSERT INTO `xy_balance_log` VALUES (3759, 191, 191, 'UB2202111833498709', 16.44, 3, 1, 1644575637, NULL);
INSERT INTO `xy_balance_log` VALUES (3760, 191, 191, 'UB2202111833498709', 2569.00, 2, 1, 1644575637, NULL);
INSERT INTO `xy_balance_log` VALUES (3761, 171, 191, 'UB2202111833498709', 0.16, 6, 1, 1644575637, NULL);
INSERT INTO `xy_balance_log` VALUES (3762, 181, 191, 'UB2202111833498709', 1.15, 6, 1, 1644575637, NULL);
INSERT INTO `xy_balance_log` VALUES (3763, 186, 191, 'UB2202111833498709', 1.97, 6, 1, 1644575637, NULL);
INSERT INTO `xy_balance_log` VALUES (3764, 191, 191, 'UB2202111834049491', 3324.00, 2, 2, 1644575657, NULL);
INSERT INTO `xy_balance_log` VALUES (3765, 191, 191, 'UB2202111834049491', 21.27, 3, 1, 1644575657, NULL);
INSERT INTO `xy_balance_log` VALUES (3766, 191, 191, 'UB2202111834049491', 3324.00, 2, 1, 1644575657, NULL);
INSERT INTO `xy_balance_log` VALUES (3767, 171, 191, 'UB2202111834049491', 0.21, 6, 1, 1644575657, NULL);
INSERT INTO `xy_balance_log` VALUES (3768, 181, 191, 'UB2202111834049491', 1.49, 6, 1, 1644575657, NULL);
INSERT INTO `xy_balance_log` VALUES (3769, 186, 191, 'UB2202111834049491', 2.55, 6, 1, 1644575657, NULL);
INSERT INTO `xy_balance_log` VALUES (3770, 191, 191, 'UB2202111834242058', 3211.00, 2, 2, 1644575673, NULL);
INSERT INTO `xy_balance_log` VALUES (3771, 191, 191, 'UB2202111834242058', 20.55, 3, 1, 1644575673, NULL);
INSERT INTO `xy_balance_log` VALUES (3772, 191, 191, 'UB2202111834242058', 3211.00, 2, 1, 1644575673, NULL);
INSERT INTO `xy_balance_log` VALUES (3773, 171, 191, 'UB2202111834242058', 0.21, 6, 1, 1644575673, NULL);
INSERT INTO `xy_balance_log` VALUES (3774, 181, 191, 'UB2202111834242058', 1.44, 6, 1, 1644575673, NULL);
INSERT INTO `xy_balance_log` VALUES (3775, 186, 191, 'UB2202111834242058', 2.47, 6, 1, 1644575673, NULL);
INSERT INTO `xy_balance_log` VALUES (3776, 191, 191, 'UB2202111834425137', 1986.00, 2, 2, 1644575689, NULL);
INSERT INTO `xy_balance_log` VALUES (3777, 191, 191, 'UB2202111834425137', 12.71, 3, 1, 1644575689, NULL);
INSERT INTO `xy_balance_log` VALUES (3778, 191, 191, 'UB2202111834425137', 1986.00, 2, 1, 1644575689, NULL);
INSERT INTO `xy_balance_log` VALUES (3779, 171, 191, 'UB2202111834425137', 0.13, 6, 1, 1644575689, NULL);
INSERT INTO `xy_balance_log` VALUES (3780, 181, 191, 'UB2202111834425137', 0.89, 6, 1, 1644575689, NULL);
INSERT INTO `xy_balance_log` VALUES (3781, 186, 191, 'UB2202111834425137', 1.53, 6, 1, 1644575689, NULL);
INSERT INTO `xy_balance_log` VALUES (3782, 191, 191, 'UB2202111834575139', 4316.00, 2, 2, 1644575706, NULL);
INSERT INTO `xy_balance_log` VALUES (3783, 191, 191, 'UB2202111834575139', 27.62, 3, 1, 1644575706, NULL);
INSERT INTO `xy_balance_log` VALUES (3784, 191, 191, 'UB2202111834575139', 4316.00, 2, 1, 1644575706, NULL);
INSERT INTO `xy_balance_log` VALUES (3785, 171, 191, 'UB2202111834575139', 0.28, 6, 1, 1644575706, NULL);
INSERT INTO `xy_balance_log` VALUES (3786, 181, 191, 'UB2202111834575139', 1.93, 6, 1, 1644575706, NULL);
INSERT INTO `xy_balance_log` VALUES (3787, 186, 191, 'UB2202111834575139', 3.31, 6, 1, 1644575706, NULL);
INSERT INTO `xy_balance_log` VALUES (3788, 191, 191, 'UB2202111835166706', 2831.00, 2, 2, 1644575724, NULL);
INSERT INTO `xy_balance_log` VALUES (3789, 191, 191, 'UB2202111835166706', 18.12, 3, 1, 1644575724, NULL);
INSERT INTO `xy_balance_log` VALUES (3790, 191, 191, 'UB2202111835166706', 2831.00, 2, 1, 1644575724, NULL);
INSERT INTO `xy_balance_log` VALUES (3791, 171, 191, 'UB2202111835166706', 0.18, 6, 1, 1644575724, NULL);
INSERT INTO `xy_balance_log` VALUES (3792, 181, 191, 'UB2202111835166706', 1.27, 6, 1, 1644575724, NULL);
INSERT INTO `xy_balance_log` VALUES (3793, 186, 191, 'UB2202111835166706', 2.17, 6, 1, 1644575724, NULL);
INSERT INTO `xy_balance_log` VALUES (3794, 191, 191, 'UB2202111835305268', 4552.00, 2, 2, 1644575738, NULL);
INSERT INTO `xy_balance_log` VALUES (3795, 191, 191, 'UB2202111835305268', 29.13, 3, 1, 1644575738, NULL);
INSERT INTO `xy_balance_log` VALUES (3796, 191, 191, 'UB2202111835305268', 4552.00, 2, 1, 1644575738, NULL);
INSERT INTO `xy_balance_log` VALUES (3797, 171, 191, 'UB2202111835305268', 0.29, 6, 1, 1644575738, NULL);
INSERT INTO `xy_balance_log` VALUES (3798, 181, 191, 'UB2202111835305268', 2.04, 6, 1, 1644575738, NULL);
INSERT INTO `xy_balance_log` VALUES (3799, 186, 191, 'UB2202111835305268', 3.50, 6, 1, 1644575738, NULL);
INSERT INTO `xy_balance_log` VALUES (3800, 191, 191, 'UB2202111835457858', 2075.00, 2, 2, 1644575753, NULL);
INSERT INTO `xy_balance_log` VALUES (3801, 191, 191, 'UB2202111835457858', 13.28, 3, 1, 1644575753, NULL);
INSERT INTO `xy_balance_log` VALUES (3802, 191, 191, 'UB2202111835457858', 2075.00, 2, 1, 1644575753, NULL);
INSERT INTO `xy_balance_log` VALUES (3803, 171, 191, 'UB2202111835457858', 0.13, 6, 1, 1644575753, NULL);
INSERT INTO `xy_balance_log` VALUES (3804, 181, 191, 'UB2202111835457858', 0.93, 6, 1, 1644575753, NULL);
INSERT INTO `xy_balance_log` VALUES (3805, 186, 191, 'UB2202111835457858', 1.59, 6, 1, 1644575753, NULL);
INSERT INTO `xy_balance_log` VALUES (3806, 191, 191, 'UB2202111836007171', 2189.00, 2, 2, 1644575769, NULL);
INSERT INTO `xy_balance_log` VALUES (3807, 191, 191, 'UB2202111836007171', 14.01, 3, 1, 1644575769, NULL);
INSERT INTO `xy_balance_log` VALUES (3808, 191, 191, 'UB2202111836007171', 2189.00, 2, 1, 1644575769, NULL);
INSERT INTO `xy_balance_log` VALUES (3809, 171, 191, 'UB2202111836007171', 0.14, 6, 1, 1644575769, NULL);
INSERT INTO `xy_balance_log` VALUES (3810, 181, 191, 'UB2202111836007171', 0.98, 6, 1, 1644575769, NULL);
INSERT INTO `xy_balance_log` VALUES (3811, 186, 191, 'UB2202111836007171', 1.68, 6, 1, 1644575769, NULL);
INSERT INTO `xy_balance_log` VALUES (3812, 191, 191, 'UB2202111836165071', 3598.00, 2, 2, 1644575784, NULL);
INSERT INTO `xy_balance_log` VALUES (3813, 191, 191, 'UB2202111836165071', 23.03, 3, 1, 1644575784, NULL);
INSERT INTO `xy_balance_log` VALUES (3814, 191, 191, 'UB2202111836165071', 3598.00, 2, 1, 1644575784, NULL);
INSERT INTO `xy_balance_log` VALUES (3815, 171, 191, 'UB2202111836165071', 0.23, 6, 1, 1644575784, NULL);
INSERT INTO `xy_balance_log` VALUES (3816, 181, 191, 'UB2202111836165071', 1.61, 6, 1, 1644575784, NULL);
INSERT INTO `xy_balance_log` VALUES (3817, 186, 191, 'UB2202111836165071', 2.76, 6, 1, 1644575784, NULL);
INSERT INTO `xy_balance_log` VALUES (3818, 191, 191, 'UB2202111836348061', 1962.00, 2, 2, 1644575803, NULL);
INSERT INTO `xy_balance_log` VALUES (3819, 191, 191, 'UB2202111836348061', 12.56, 3, 1, 1644575803, NULL);
INSERT INTO `xy_balance_log` VALUES (3820, 191, 191, 'UB2202111836348061', 1962.00, 2, 1, 1644575803, NULL);
INSERT INTO `xy_balance_log` VALUES (3821, 171, 191, 'UB2202111836348061', 0.13, 6, 1, 1644575803, NULL);
INSERT INTO `xy_balance_log` VALUES (3822, 181, 191, 'UB2202111836348061', 0.88, 6, 1, 1644575803, NULL);
INSERT INTO `xy_balance_log` VALUES (3823, 186, 191, 'UB2202111836348061', 1.51, 6, 1, 1644575803, NULL);
INSERT INTO `xy_balance_log` VALUES (3824, 191, 191, 'UB2202111836504841', 3374.00, 2, 2, 1644575819, NULL);
INSERT INTO `xy_balance_log` VALUES (3825, 191, 191, 'UB2202111836504841', 21.59, 3, 1, 1644575819, NULL);
INSERT INTO `xy_balance_log` VALUES (3826, 191, 191, 'UB2202111836504841', 3374.00, 2, 1, 1644575819, NULL);
INSERT INTO `xy_balance_log` VALUES (3827, 171, 191, 'UB2202111836504841', 0.22, 6, 1, 1644575819, NULL);
INSERT INTO `xy_balance_log` VALUES (3828, 181, 191, 'UB2202111836504841', 1.51, 6, 1, 1644575819, NULL);
INSERT INTO `xy_balance_log` VALUES (3829, 186, 191, 'UB2202111836504841', 2.59, 6, 1, 1644575819, NULL);
INSERT INTO `xy_balance_log` VALUES (3830, 191, 191, 'UB2202111837057662', 3271.00, 2, 2, 1644575833, NULL);
INSERT INTO `xy_balance_log` VALUES (3831, 191, 191, 'UB2202111837057662', 20.93, 3, 1, 1644575833, NULL);
INSERT INTO `xy_balance_log` VALUES (3832, 191, 191, 'UB2202111837057662', 3271.00, 2, 1, 1644575833, NULL);
INSERT INTO `xy_balance_log` VALUES (3833, 171, 191, 'UB2202111837057662', 0.21, 6, 1, 1644575833, NULL);
INSERT INTO `xy_balance_log` VALUES (3834, 181, 191, 'UB2202111837057662', 1.47, 6, 1, 1644575833, NULL);
INSERT INTO `xy_balance_log` VALUES (3835, 186, 191, 'UB2202111837057662', 2.51, 6, 1, 1644575833, NULL);
INSERT INTO `xy_balance_log` VALUES (3836, 191, 191, 'UB2202111837196976', 3487.00, 2, 2, 1644575847, NULL);
INSERT INTO `xy_balance_log` VALUES (3837, 191, 191, 'UB2202111837196976', 22.32, 3, 1, 1644575847, NULL);
INSERT INTO `xy_balance_log` VALUES (3838, 191, 191, 'UB2202111837196976', 3487.00, 2, 1, 1644575847, NULL);
INSERT INTO `xy_balance_log` VALUES (3839, 171, 191, 'UB2202111837196976', 0.22, 6, 1, 1644575847, NULL);
INSERT INTO `xy_balance_log` VALUES (3840, 181, 191, 'UB2202111837196976', 1.56, 6, 1, 1644575847, NULL);
INSERT INTO `xy_balance_log` VALUES (3841, 186, 191, 'UB2202111837196976', 2.68, 6, 1, 1644575847, NULL);
INSERT INTO `xy_balance_log` VALUES (3842, 191, 191, 'UB2202111837352803', 2735.00, 2, 2, 1644575862, NULL);
INSERT INTO `xy_balance_log` VALUES (3843, 191, 191, 'UB2202111837352803', 17.50, 3, 1, 1644575862, NULL);
INSERT INTO `xy_balance_log` VALUES (3844, 191, 191, 'UB2202111837352803', 2735.00, 2, 1, 1644575862, NULL);
INSERT INTO `xy_balance_log` VALUES (3845, 171, 191, 'UB2202111837352803', 0.18, 6, 1, 1644575862, NULL);
INSERT INTO `xy_balance_log` VALUES (3846, 181, 191, 'UB2202111837352803', 1.23, 6, 1, 1644575862, NULL);
INSERT INTO `xy_balance_log` VALUES (3847, 186, 191, 'UB2202111837352803', 2.10, 6, 1, 1644575862, NULL);
INSERT INTO `xy_balance_log` VALUES (3848, 191, 191, 'UB2202111837493290', 3699.00, 2, 2, 1644575877, NULL);
INSERT INTO `xy_balance_log` VALUES (3849, 191, 191, 'UB2202111837493290', 23.67, 3, 1, 1644575877, NULL);
INSERT INTO `xy_balance_log` VALUES (3850, 191, 191, 'UB2202111837493290', 3699.00, 2, 1, 1644575877, NULL);
INSERT INTO `xy_balance_log` VALUES (3851, 171, 191, 'UB2202111837493290', 0.24, 6, 1, 1644575877, NULL);
INSERT INTO `xy_balance_log` VALUES (3852, 181, 191, 'UB2202111837493290', 1.66, 6, 1, 1644575877, NULL);
INSERT INTO `xy_balance_log` VALUES (3853, 186, 191, 'UB2202111837493290', 2.84, 6, 1, 1644575877, NULL);
INSERT INTO `xy_balance_log` VALUES (3854, 191, 191, 'UB2202111838052750', 1869.00, 2, 2, 1644575892, NULL);
INSERT INTO `xy_balance_log` VALUES (3855, 191, 191, 'UB2202111838052750', 11.96, 3, 1, 1644575892, NULL);
INSERT INTO `xy_balance_log` VALUES (3856, 191, 191, 'UB2202111838052750', 1869.00, 2, 1, 1644575892, NULL);
INSERT INTO `xy_balance_log` VALUES (3857, 171, 191, 'UB2202111838052750', 0.12, 6, 1, 1644575892, NULL);
INSERT INTO `xy_balance_log` VALUES (3858, 181, 191, 'UB2202111838052750', 0.84, 6, 1, 1644575892, NULL);
INSERT INTO `xy_balance_log` VALUES (3859, 186, 191, 'UB2202111838052750', 1.44, 6, 1, 1644575892, NULL);
INSERT INTO `xy_balance_log` VALUES (3860, 191, 191, 'UB2202111838196537', 3362.00, 2, 2, 1644575906, NULL);
INSERT INTO `xy_balance_log` VALUES (3861, 191, 191, 'UB2202111838196537', 21.52, 3, 1, 1644575906, NULL);
INSERT INTO `xy_balance_log` VALUES (3862, 191, 191, 'UB2202111838196537', 3362.00, 2, 1, 1644575906, NULL);
INSERT INTO `xy_balance_log` VALUES (3863, 171, 191, 'UB2202111838196537', 0.22, 6, 1, 1644575906, NULL);
INSERT INTO `xy_balance_log` VALUES (3864, 181, 191, 'UB2202111838196537', 1.51, 6, 1, 1644575906, NULL);
INSERT INTO `xy_balance_log` VALUES (3865, 186, 191, 'UB2202111838196537', 2.58, 6, 1, 1644575906, NULL);
INSERT INTO `xy_balance_log` VALUES (3866, 191, 191, 'UB2202111838338057', 4204.00, 2, 2, 1644575921, NULL);
INSERT INTO `xy_balance_log` VALUES (3867, 191, 191, 'UB2202111838338057', 26.91, 3, 1, 1644575921, NULL);
INSERT INTO `xy_balance_log` VALUES (3868, 191, 191, 'UB2202111838338057', 4204.00, 2, 1, 1644575921, NULL);
INSERT INTO `xy_balance_log` VALUES (3869, 171, 191, 'UB2202111838338057', 0.27, 6, 1, 1644575921, NULL);
INSERT INTO `xy_balance_log` VALUES (3870, 181, 191, 'UB2202111838338057', 1.88, 6, 1, 1644575921, NULL);
INSERT INTO `xy_balance_log` VALUES (3871, 186, 191, 'UB2202111838338057', 3.23, 6, 1, 1644575921, NULL);
INSERT INTO `xy_balance_log` VALUES (3872, 191, 191, 'UB2202111838474737', 4003.00, 2, 2, 1644575935, NULL);
INSERT INTO `xy_balance_log` VALUES (3873, 191, 191, 'UB2202111838474737', 25.62, 3, 1, 1644575935, NULL);
INSERT INTO `xy_balance_log` VALUES (3874, 191, 191, 'UB2202111838474737', 4003.00, 2, 1, 1644575935, NULL);
INSERT INTO `xy_balance_log` VALUES (3875, 171, 191, 'UB2202111838474737', 0.26, 6, 1, 1644575935, NULL);
INSERT INTO `xy_balance_log` VALUES (3876, 181, 191, 'UB2202111838474737', 1.79, 6, 1, 1644575935, NULL);
INSERT INTO `xy_balance_log` VALUES (3877, 186, 191, 'UB2202111838474737', 3.07, 6, 1, 1644575935, NULL);
INSERT INTO `xy_balance_log` VALUES (3878, 191, 191, 'UB2202111839034494', 2859.00, 2, 2, 1644575950, NULL);
INSERT INTO `xy_balance_log` VALUES (3879, 191, 191, 'UB2202111839034494', 18.30, 3, 1, 1644575950, NULL);
INSERT INTO `xy_balance_log` VALUES (3880, 191, 191, 'UB2202111839034494', 2859.00, 2, 1, 1644575950, NULL);
INSERT INTO `xy_balance_log` VALUES (3881, 171, 191, 'UB2202111839034494', 0.18, 6, 1, 1644575950, NULL);
INSERT INTO `xy_balance_log` VALUES (3882, 181, 191, 'UB2202111839034494', 1.28, 6, 1, 1644575950, NULL);
INSERT INTO `xy_balance_log` VALUES (3883, 186, 191, 'UB2202111839034494', 2.20, 6, 1, 1644575950, NULL);
INSERT INTO `xy_balance_log` VALUES (3884, 191, 191, 'UB2202111839173111', 4208.00, 2, 2, 1644575965, NULL);
INSERT INTO `xy_balance_log` VALUES (3885, 191, 191, 'UB2202111839173111', 26.93, 3, 1, 1644575965, NULL);
INSERT INTO `xy_balance_log` VALUES (3886, 191, 191, 'UB2202111839173111', 4208.00, 2, 1, 1644575965, NULL);
INSERT INTO `xy_balance_log` VALUES (3887, 171, 191, 'UB2202111839173111', 0.27, 6, 1, 1644575965, NULL);
INSERT INTO `xy_balance_log` VALUES (3888, 181, 191, 'UB2202111839173111', 1.89, 6, 1, 1644575965, NULL);
INSERT INTO `xy_balance_log` VALUES (3889, 186, 191, 'UB2202111839173111', 3.23, 6, 1, 1644575965, NULL);
INSERT INTO `xy_balance_log` VALUES (3890, 191, 191, 'UB2202111839333076', 2449.00, 2, 2, 1644575980, NULL);
INSERT INTO `xy_balance_log` VALUES (3891, 191, 191, 'UB2202111839333076', 15.67, 3, 1, 1644575980, NULL);
INSERT INTO `xy_balance_log` VALUES (3892, 191, 191, 'UB2202111839333076', 2449.00, 2, 1, 1644575980, NULL);
INSERT INTO `xy_balance_log` VALUES (3893, 171, 191, 'UB2202111839333076', 0.16, 6, 1, 1644575980, NULL);
INSERT INTO `xy_balance_log` VALUES (3894, 181, 191, 'UB2202111839333076', 1.10, 6, 1, 1644575980, NULL);
INSERT INTO `xy_balance_log` VALUES (3895, 186, 191, 'UB2202111839333076', 1.88, 6, 1, 1644575980, NULL);
INSERT INTO `xy_balance_log` VALUES (3896, 191, 0, 'CO2202111842421826', 3000.00, 7, 2, 1644576162, NULL);
INSERT INTO `xy_balance_log` VALUES (3897, 191, 0, 'CO2202111844458699', 2000.00, 7, 2, 1644576285, NULL);
INSERT INTO `xy_balance_log` VALUES (3898, 193, 0, 'SY2202111901396990', 300.00, 1, 1, 1644577373, NULL);
INSERT INTO `xy_balance_log` VALUES (3899, 193, 0, 'SY2202111848144323', 100.00, 1, 1, 1644577385, NULL);
INSERT INTO `xy_balance_log` VALUES (3900, 191, 194, '', 0.50, 5, 1, 1644585497, NULL);
INSERT INTO `xy_balance_log` VALUES (3901, 191, 195, '', 0.50, 5, 1, 1644585819, NULL);
INSERT INTO `xy_balance_log` VALUES (3902, 195, 0, 'SY2202112156596259', 100.00, 1, 1, 1644588021, NULL);
INSERT INTO `xy_balance_log` VALUES (3903, 191, 0, 'SY2202112156596259', 5.00, 5, 1, 1644588021, NULL);
INSERT INTO `xy_balance_log` VALUES (3904, 186, 0, 'SY2202121142144734', 500.00, 1, 1, 1644637427, NULL);
INSERT INTO `xy_balance_log` VALUES (3905, 186, 186, 'UB2202121144118318', 440.00, 2, 2, 1644637459, NULL);
INSERT INTO `xy_balance_log` VALUES (3906, 186, 186, 'UB2202121144118318', 2.55, 3, 1, 1644637459, NULL);
INSERT INTO `xy_balance_log` VALUES (3907, 186, 186, 'UB2202121144118318', 440.00, 2, 1, 1644637459, NULL);
INSERT INTO `xy_balance_log` VALUES (3908, 171, 186, 'UB2202121144118318', 0.23, 6, 1, 1644637459, NULL);
INSERT INTO `xy_balance_log` VALUES (3909, 181, 186, 'UB2202121144118318', 0.36, 6, 1, 1644637459, NULL);
INSERT INTO `xy_balance_log` VALUES (3910, 186, 186, 'UB2202121144317082', 632.00, 2, 2, 1644637483, NULL);
INSERT INTO `xy_balance_log` VALUES (3911, 186, 186, 'UB2202121144317082', 3.67, 3, 1, 1644637483, NULL);
INSERT INTO `xy_balance_log` VALUES (3912, 186, 186, 'UB2202121144317082', 632.00, 2, 1, 1644637483, NULL);
INSERT INTO `xy_balance_log` VALUES (3913, 171, 186, 'UB2202121144317082', 0.33, 6, 1, 1644637483, NULL);
INSERT INTO `xy_balance_log` VALUES (3914, 181, 186, 'UB2202121144317082', 0.51, 6, 1, 1644637483, NULL);
INSERT INTO `xy_balance_log` VALUES (3915, 186, 186, 'UB2202121145115465', 443.00, 2, 2, 1644637531, NULL);
INSERT INTO `xy_balance_log` VALUES (3916, 186, 186, 'UB2202121145115465', 2.57, 3, 1, 1644637531, NULL);
INSERT INTO `xy_balance_log` VALUES (3917, 186, 186, 'UB2202121145115465', 443.00, 2, 1, 1644637531, NULL);
INSERT INTO `xy_balance_log` VALUES (3918, 171, 186, 'UB2202121145115465', 0.23, 6, 1, 1644637531, NULL);
INSERT INTO `xy_balance_log` VALUES (3919, 181, 186, 'UB2202121145115465', 0.36, 6, 1, 1644637531, NULL);
INSERT INTO `xy_balance_log` VALUES (3920, 186, 186, 'UB2202121145489080', 507.00, 2, 2, 1644637565, NULL);
INSERT INTO `xy_balance_log` VALUES (3921, 186, 186, 'UB2202121145489080', 2.94, 3, 1, 1644637565, NULL);
INSERT INTO `xy_balance_log` VALUES (3922, 186, 186, 'UB2202121145489080', 507.00, 2, 1, 1644637565, NULL);
INSERT INTO `xy_balance_log` VALUES (3923, 171, 186, 'UB2202121145489080', 0.26, 6, 1, 1644637565, NULL);
INSERT INTO `xy_balance_log` VALUES (3924, 181, 186, 'UB2202121145489080', 0.41, 6, 1, 1644637565, NULL);
INSERT INTO `xy_balance_log` VALUES (3925, 186, 186, 'UB2202121146171553', 788.00, 2, 2, 1644637589, NULL);
INSERT INTO `xy_balance_log` VALUES (3926, 186, 186, 'UB2202121146171553', 4.57, 3, 1, 1644637589, NULL);
INSERT INTO `xy_balance_log` VALUES (3927, 186, 186, 'UB2202121146171553', 788.00, 2, 1, 1644637589, NULL);
INSERT INTO `xy_balance_log` VALUES (3928, 171, 186, 'UB2202121146171553', 0.41, 6, 1, 1644637589, NULL);
INSERT INTO `xy_balance_log` VALUES (3929, 181, 186, 'UB2202121146171553', 0.64, 6, 1, 1644637589, NULL);
INSERT INTO `xy_balance_log` VALUES (3930, 186, 186, 'UB2202121146464488', 635.00, 2, 2, 1644637619, NULL);
INSERT INTO `xy_balance_log` VALUES (3931, 186, 186, 'UB2202121146464488', 3.68, 3, 1, 1644637619, NULL);
INSERT INTO `xy_balance_log` VALUES (3932, 186, 186, 'UB2202121146464488', 635.00, 2, 1, 1644637619, NULL);
INSERT INTO `xy_balance_log` VALUES (3933, 171, 186, 'UB2202121146464488', 0.33, 6, 1, 1644637619, NULL);
INSERT INTO `xy_balance_log` VALUES (3934, 181, 186, 'UB2202121146464488', 0.52, 6, 1, 1644637619, NULL);
INSERT INTO `xy_balance_log` VALUES (3935, 186, 186, 'UB2202121147106403', 754.00, 2, 2, 1644637639, NULL);
INSERT INTO `xy_balance_log` VALUES (3936, 186, 186, 'UB2202121147106403', 4.37, 3, 1, 1644637639, NULL);
INSERT INTO `xy_balance_log` VALUES (3937, 186, 186, 'UB2202121147106403', 754.00, 2, 1, 1644637639, NULL);
INSERT INTO `xy_balance_log` VALUES (3938, 171, 186, 'UB2202121147106403', 0.39, 6, 1, 1644637639, NULL);
INSERT INTO `xy_balance_log` VALUES (3939, 181, 186, 'UB2202121147106403', 0.61, 6, 1, 1644637639, NULL);
INSERT INTO `xy_balance_log` VALUES (3940, 186, 186, 'UB2202121147272010', 604.00, 2, 2, 1644637656, NULL);
INSERT INTO `xy_balance_log` VALUES (3941, 186, 186, 'UB2202121147272010', 3.50, 3, 1, 1644637656, NULL);
INSERT INTO `xy_balance_log` VALUES (3942, 186, 186, 'UB2202121147272010', 604.00, 2, 1, 1644637656, NULL);
INSERT INTO `xy_balance_log` VALUES (3943, 171, 186, 'UB2202121147272010', 0.32, 6, 1, 1644637656, NULL);
INSERT INTO `xy_balance_log` VALUES (3944, 181, 186, 'UB2202121147272010', 0.49, 6, 1, 1644637656, NULL);
INSERT INTO `xy_balance_log` VALUES (3945, 186, 186, 'UB2202121147453414', 356.00, 2, 2, 1644637675, NULL);
INSERT INTO `xy_balance_log` VALUES (3946, 186, 186, 'UB2202121147453414', 2.06, 3, 1, 1644637675, NULL);
INSERT INTO `xy_balance_log` VALUES (3947, 186, 186, 'UB2202121147453414', 356.00, 2, 1, 1644637675, NULL);
INSERT INTO `xy_balance_log` VALUES (3948, 171, 186, 'UB2202121147453414', 0.19, 6, 1, 1644637675, NULL);
INSERT INTO `xy_balance_log` VALUES (3949, 181, 186, 'UB2202121147453414', 0.29, 6, 1, 1644637675, NULL);
INSERT INTO `xy_balance_log` VALUES (3950, 186, 186, 'UB2202121148058242', 492.00, 2, 2, 1644637696, NULL);
INSERT INTO `xy_balance_log` VALUES (3951, 186, 186, 'UB2202121148058242', 2.85, 3, 1, 1644637696, NULL);
INSERT INTO `xy_balance_log` VALUES (3952, 186, 186, 'UB2202121148058242', 492.00, 2, 1, 1644637696, NULL);
INSERT INTO `xy_balance_log` VALUES (3953, 171, 186, 'UB2202121148058242', 0.26, 6, 1, 1644637696, NULL);
INSERT INTO `xy_balance_log` VALUES (3954, 181, 186, 'UB2202121148058242', 0.40, 6, 1, 1644637696, NULL);
INSERT INTO `xy_balance_log` VALUES (3955, 186, 186, 'UB2202121148351652', 748.00, 2, 2, 1644637724, NULL);
INSERT INTO `xy_balance_log` VALUES (3956, 186, 186, 'UB2202121148351652', 4.34, 3, 1, 1644637724, NULL);
INSERT INTO `xy_balance_log` VALUES (3957, 186, 186, 'UB2202121148351652', 748.00, 2, 1, 1644637724, NULL);
INSERT INTO `xy_balance_log` VALUES (3958, 171, 186, 'UB2202121148351652', 0.39, 6, 1, 1644637724, NULL);
INSERT INTO `xy_balance_log` VALUES (3959, 181, 186, 'UB2202121148351652', 0.61, 6, 1, 1644637724, NULL);
INSERT INTO `xy_balance_log` VALUES (3960, 186, 186, 'UB2202121148543130', 402.00, 2, 2, 1644637741, NULL);
INSERT INTO `xy_balance_log` VALUES (3961, 186, 186, 'UB2202121148543130', 2.33, 3, 1, 1644637741, NULL);
INSERT INTO `xy_balance_log` VALUES (3962, 186, 186, 'UB2202121148543130', 402.00, 2, 1, 1644637741, NULL);
INSERT INTO `xy_balance_log` VALUES (3963, 171, 186, 'UB2202121148543130', 0.21, 6, 1, 1644637742, NULL);
INSERT INTO `xy_balance_log` VALUES (3964, 181, 186, 'UB2202121148543130', 0.33, 6, 1, 1644637742, NULL);
INSERT INTO `xy_balance_log` VALUES (3965, 193, 196, '', 0.50, 5, 1, 1644645599, NULL);
INSERT INTO `xy_balance_log` VALUES (3966, 196, 0, 'SY2202121415302737', 64.00, 1, 1, 1644646729, NULL);
INSERT INTO `xy_balance_log` VALUES (3967, 193, 0, 'SY2202121415302737', 3.20, 5, 1, 1644646729, NULL);
INSERT INTO `xy_balance_log` VALUES (3968, 196, 196, 'UB2202121429489996', 55.00, 2, 2, 1644647398, NULL);
INSERT INTO `xy_balance_log` VALUES (3969, 196, 196, 'UB2202121429489996', 8.25, 3, 1, 1644647398, NULL);
INSERT INTO `xy_balance_log` VALUES (3970, 196, 196, 'UB2202121429489996', 55.00, 2, 1, 1644647398, NULL);
INSERT INTO `xy_balance_log` VALUES (3971, 196, 196, 'UB2202121430051690', 61.00, 2, 2, 1644647412, NULL);
INSERT INTO `xy_balance_log` VALUES (3972, 196, 196, 'UB2202121430051690', 9.15, 3, 1, 1644647412, NULL);
INSERT INTO `xy_balance_log` VALUES (3973, 196, 196, 'UB2202121430051690', 61.00, 2, 1, 1644647412, NULL);
INSERT INTO `xy_balance_log` VALUES (3974, 196, 196, 'UB2202121430236661', 48.00, 2, 2, 1644647432, NULL);
INSERT INTO `xy_balance_log` VALUES (3975, 196, 196, 'UB2202121430236661', 7.20, 3, 1, 1644647432, NULL);
INSERT INTO `xy_balance_log` VALUES (3976, 196, 196, 'UB2202121430236661', 48.00, 2, 1, 1644647432, NULL);
INSERT INTO `xy_balance_log` VALUES (3977, 196, 0, 'CO2202121441479089', 124.00, 7, 2, 1644648107, NULL);
INSERT INTO `xy_balance_log` VALUES (3978, 186, 186, 'UB2202121454473020', 341.00, 2, 2, 1644648897, NULL);
INSERT INTO `xy_balance_log` VALUES (3979, 186, 186, 'UB2202121454473020', 1.98, 3, 1, 1644648897, NULL);
INSERT INTO `xy_balance_log` VALUES (3980, 186, 186, 'UB2202121454473020', 341.00, 2, 1, 1644648897, NULL);
INSERT INTO `xy_balance_log` VALUES (3981, 171, 186, 'UB2202121454473020', 0.18, 6, 1, 1644648897, NULL);
INSERT INTO `xy_balance_log` VALUES (3982, 181, 186, 'UB2202121454473020', 0.28, 6, 1, 1644648897, NULL);
INSERT INTO `xy_balance_log` VALUES (3983, 186, 186, 'UB2202121455297487', 389.00, 2, 2, 1644648939, NULL);
INSERT INTO `xy_balance_log` VALUES (3984, 186, 186, 'UB2202121455297487', 2.26, 3, 1, 1644648939, NULL);
INSERT INTO `xy_balance_log` VALUES (3985, 186, 186, 'UB2202121455297487', 389.00, 2, 1, 1644648939, NULL);
INSERT INTO `xy_balance_log` VALUES (3986, 171, 186, 'UB2202121455297487', 0.20, 6, 1, 1644648939, NULL);
INSERT INTO `xy_balance_log` VALUES (3987, 181, 186, 'UB2202121455297487', 0.32, 6, 1, 1644648939, NULL);
INSERT INTO `xy_balance_log` VALUES (3988, 186, 186, 'UB2202121456196130', 567.00, 2, 2, 1644648988, NULL);
INSERT INTO `xy_balance_log` VALUES (3989, 186, 186, 'UB2202121456196130', 3.29, 3, 1, 1644648988, NULL);
INSERT INTO `xy_balance_log` VALUES (3990, 186, 186, 'UB2202121456196130', 567.00, 2, 1, 1644648988, NULL);
INSERT INTO `xy_balance_log` VALUES (3991, 171, 186, 'UB2202121456196130', 0.30, 6, 1, 1644648988, NULL);
INSERT INTO `xy_balance_log` VALUES (3992, 181, 186, 'UB2202121456196130', 0.46, 6, 1, 1644648988, NULL);
INSERT INTO `xy_balance_log` VALUES (3993, 186, 186, 'UB2202121456361311', 324.00, 2, 2, 1644649005, NULL);
INSERT INTO `xy_balance_log` VALUES (3994, 186, 186, 'UB2202121456361311', 1.88, 3, 1, 1644649005, NULL);
INSERT INTO `xy_balance_log` VALUES (3995, 186, 186, 'UB2202121456361311', 324.00, 2, 1, 1644649005, NULL);
INSERT INTO `xy_balance_log` VALUES (3996, 171, 186, 'UB2202121456361311', 0.17, 6, 1, 1644649005, NULL);
INSERT INTO `xy_balance_log` VALUES (3997, 181, 186, 'UB2202121456361311', 0.26, 6, 1, 1644649005, NULL);
INSERT INTO `xy_balance_log` VALUES (3998, 186, 186, 'UB2202121456525378', 317.00, 2, 2, 1644649024, NULL);
INSERT INTO `xy_balance_log` VALUES (3999, 186, 186, 'UB2202121456525378', 1.84, 3, 1, 1644649024, NULL);
INSERT INTO `xy_balance_log` VALUES (4000, 186, 186, 'UB2202121456525378', 317.00, 2, 1, 1644649024, NULL);
INSERT INTO `xy_balance_log` VALUES (4001, 171, 186, 'UB2202121456525378', 0.17, 6, 1, 1644649024, NULL);
INSERT INTO `xy_balance_log` VALUES (4002, 181, 186, 'UB2202121456525378', 0.26, 6, 1, 1644649024, NULL);
INSERT INTO `xy_balance_log` VALUES (4003, 186, 186, 'UB2202121457116748', 404.00, 2, 2, 1644649043, NULL);
INSERT INTO `xy_balance_log` VALUES (4004, 186, 186, 'UB2202121457116748', 2.34, 3, 1, 1644649043, NULL);
INSERT INTO `xy_balance_log` VALUES (4005, 186, 186, 'UB2202121457116748', 404.00, 2, 1, 1644649043, NULL);
INSERT INTO `xy_balance_log` VALUES (4006, 171, 186, 'UB2202121457116748', 0.21, 6, 1, 1644649043, NULL);
INSERT INTO `xy_balance_log` VALUES (4007, 181, 186, 'UB2202121457116748', 0.33, 6, 1, 1644649043, NULL);
INSERT INTO `xy_balance_log` VALUES (4008, 186, 186, 'UB2202121457358303', 768.00, 2, 2, 1644649062, NULL);
INSERT INTO `xy_balance_log` VALUES (4009, 186, 186, 'UB2202121457358303', 4.45, 3, 1, 1644649062, NULL);
INSERT INTO `xy_balance_log` VALUES (4010, 186, 186, 'UB2202121457358303', 768.00, 2, 1, 1644649062, NULL);
INSERT INTO `xy_balance_log` VALUES (4011, 171, 186, 'UB2202121457358303', 0.40, 6, 1, 1644649062, NULL);
INSERT INTO `xy_balance_log` VALUES (4012, 181, 186, 'UB2202121457358303', 0.62, 6, 1, 1644649062, NULL);
INSERT INTO `xy_balance_log` VALUES (4013, 186, 186, 'UB2202121457502581', 465.00, 2, 2, 1644649083, NULL);
INSERT INTO `xy_balance_log` VALUES (4014, 186, 186, 'UB2202121457502581', 2.70, 3, 1, 1644649083, NULL);
INSERT INTO `xy_balance_log` VALUES (4015, 186, 186, 'UB2202121457502581', 465.00, 2, 1, 1644649083, NULL);
INSERT INTO `xy_balance_log` VALUES (4016, 171, 186, 'UB2202121457502581', 0.24, 6, 1, 1644649083, NULL);
INSERT INTO `xy_balance_log` VALUES (4017, 181, 186, 'UB2202121457502581', 0.38, 6, 1, 1644649083, NULL);
INSERT INTO `xy_balance_log` VALUES (4018, 186, 0, 'CO2202121459576236', 500.00, 7, 2, 1644649197, NULL);
INSERT INTO `xy_balance_log` VALUES (4019, 186, 0, 'CO2202121511206963', 300.00, 7, 2, 1644649880, NULL);
INSERT INTO `xy_balance_log` VALUES (4020, 186, 186, 'UB2202121516384837', 192.00, 2, 2, 1644650206, NULL);
INSERT INTO `xy_balance_log` VALUES (4021, 186, 186, 'UB2202121516384837', 28.80, 3, 1, 1644650206, NULL);
INSERT INTO `xy_balance_log` VALUES (4022, 186, 186, 'UB2202121516384837', 192.00, 2, 1, 1644650206, NULL);
INSERT INTO `xy_balance_log` VALUES (4023, 171, 186, 'UB2202121516384837', 2.59, 6, 1, 1644650206, NULL);
INSERT INTO `xy_balance_log` VALUES (4024, 181, 186, 'UB2202121516384837', 4.03, 6, 1, 1644650206, NULL);
INSERT INTO `xy_balance_log` VALUES (4025, 186, 186, 'UB2202121516561731', 204.00, 2, 2, 1644650223, NULL);
INSERT INTO `xy_balance_log` VALUES (4026, 186, 186, 'UB2202121516561731', 30.60, 3, 1, 1644650223, NULL);
INSERT INTO `xy_balance_log` VALUES (4027, 186, 186, 'UB2202121516561731', 204.00, 2, 1, 1644650223, NULL);
INSERT INTO `xy_balance_log` VALUES (4028, 171, 186, 'UB2202121516561731', 2.75, 6, 1, 1644650223, NULL);
INSERT INTO `xy_balance_log` VALUES (4029, 181, 186, 'UB2202121516561731', 4.28, 6, 1, 1644650223, NULL);
INSERT INTO `xy_balance_log` VALUES (4030, 186, 186, 'UB2202121517113865', 223.00, 2, 2, 1644650238, NULL);
INSERT INTO `xy_balance_log` VALUES (4031, 186, 186, 'UB2202121517113865', 33.45, 3, 1, 1644650238, NULL);
INSERT INTO `xy_balance_log` VALUES (4032, 186, 186, 'UB2202121517113865', 223.00, 2, 1, 1644650238, NULL);
INSERT INTO `xy_balance_log` VALUES (4033, 171, 186, 'UB2202121517113865', 3.01, 6, 1, 1644650238, NULL);
INSERT INTO `xy_balance_log` VALUES (4034, 181, 186, 'UB2202121517113865', 4.68, 6, 1, 1644650238, NULL);
INSERT INTO `xy_balance_log` VALUES (4035, 186, 186, 'UB2202121517259068', 142.00, 2, 2, 1644650273, NULL);
INSERT INTO `xy_balance_log` VALUES (4036, 186, 186, 'UB2202121517259068', 21.30, 3, 1, 1644650273, NULL);
INSERT INTO `xy_balance_log` VALUES (4037, 186, 186, 'UB2202121517259068', 142.00, 2, 1, 1644650273, NULL);
INSERT INTO `xy_balance_log` VALUES (4038, 171, 186, 'UB2202121517259068', 1.92, 6, 1, 1644650273, NULL);
INSERT INTO `xy_balance_log` VALUES (4039, 181, 186, 'UB2202121517259068', 2.98, 6, 1, 1644650273, NULL);
INSERT INTO `xy_balance_log` VALUES (4040, 186, 186, 'UB2202121518117276', 235.00, 2, 2, 1644650299, NULL);
INSERT INTO `xy_balance_log` VALUES (4041, 186, 186, 'UB2202121518117276', 35.25, 3, 1, 1644650299, NULL);
INSERT INTO `xy_balance_log` VALUES (4042, 186, 186, 'UB2202121518117276', 235.00, 2, 1, 1644650299, NULL);
INSERT INTO `xy_balance_log` VALUES (4043, 171, 186, 'UB2202121518117276', 3.17, 6, 1, 1644650299, NULL);
INSERT INTO `xy_balance_log` VALUES (4044, 181, 186, 'UB2202121518117276', 4.94, 6, 1, 1644650299, NULL);
INSERT INTO `xy_balance_log` VALUES (4045, 186, 0, 'SY2202121646231467', 3000.00, 1, 1, 1644655665, NULL);
INSERT INTO `xy_balance_log` VALUES (4046, 186, 186, 'UB2202121648033501', 1301.00, 2, 2, 1644655691, NULL);
INSERT INTO `xy_balance_log` VALUES (4047, 186, 186, 'UB2202121648033501', 3356.58, 3, 1, 1644655691, NULL);
INSERT INTO `xy_balance_log` VALUES (4048, 186, 186, 'UB2202121648033501', 1301.00, 2, 1, 1644655691, NULL);
INSERT INTO `xy_balance_log` VALUES (4049, 171, 186, 'UB2202121648033501', 302.09, 6, 1, 1644655691, NULL);
INSERT INTO `xy_balance_log` VALUES (4050, 181, 186, 'UB2202121648033501', 469.92, 6, 1, 1644655691, NULL);
INSERT INTO `xy_balance_log` VALUES (4051, 186, 0, 'SY2202121652294419', 3000.00, 1, 1, 1644655986, NULL);
INSERT INTO `xy_balance_log` VALUES (4052, 186, 0, 'SY2202121655041012', 5000.00, 1, 1, 1644656128, NULL);
INSERT INTO `xy_balance_log` VALUES (4053, 186, 0, 'SY2202121657139348', 100000.00, 1, 1, 1644656268, NULL);
INSERT INTO `xy_balance_log` VALUES (4054, 186, 0, 'SY2202121700489534', 300.00, 1, 1, 1644656470, NULL);
INSERT INTO `xy_balance_log` VALUES (4055, 171, 171, 'UB2202101820131797', 26084.00, 2, 2, 1644997961, NULL);
INSERT INTO `xy_balance_log` VALUES (4056, 171, 171, 'UB2202101820131797', 3912.60, 3, 1, 1644997961, NULL);
INSERT INTO `xy_balance_log` VALUES (4057, 171, 171, 'UB2202101820131797', 26084.00, 2, 1, 1644997961, NULL);
INSERT INTO `xy_balance_log` VALUES (4058, 171, 171, 'UB2202161552555675', 42665.00, 2, 2, 1644998004, NULL);
INSERT INTO `xy_balance_log` VALUES (4059, 171, 171, 'UB2202161552555675', 221.86, 3, 1, 1644998004, NULL);
INSERT INTO `xy_balance_log` VALUES (4060, 171, 171, 'UB2202161552555675', 42665.00, 2, 1, 1644998004, NULL);
INSERT INTO `xy_balance_log` VALUES (4061, 171, 171, 'UB2202161553336769', 70074.00, 2, 2, 1644998252, NULL);
INSERT INTO `xy_balance_log` VALUES (4062, 171, 171, 'UB2202161553336769', 364.38, 3, 1, 1644998252, NULL);
INSERT INTO `xy_balance_log` VALUES (4063, 171, 171, 'UB2202161553336769', 70074.00, 2, 1, 1644998252, NULL);
INSERT INTO `xy_balance_log` VALUES (4064, 171, 171, 'UB2202161557448574', 50480.00, 2, 2, 1644998273, NULL);
INSERT INTO `xy_balance_log` VALUES (4065, 171, 171, 'UB2202161557448574', 5552.80, 3, 1, 1644998273, NULL);
INSERT INTO `xy_balance_log` VALUES (4066, 171, 171, 'UB2202161557448574', 50480.00, 2, 1, 1644998273, NULL);
INSERT INTO `xy_balance_log` VALUES (4067, 171, 171, 'UB2202161558009856', 135788.00, 2, 2, 1644998302, NULL);
INSERT INTO `xy_balance_log` VALUES (4068, 171, 171, 'UB2202161558009856', 17652.44, 3, 1, 1644998302, NULL);
INSERT INTO `xy_balance_log` VALUES (4069, 171, 171, 'UB2202161558009856', 135788.00, 2, 1, 1644998302, NULL);
INSERT INTO `xy_balance_log` VALUES (4070, 171, 0, 'SY2202161602545670', 700000.00, 1, 1, 1644998579, NULL);
INSERT INTO `xy_balance_log` VALUES (4071, 0, 0, 'SY2202161602545670', 35000.00, 5, 1, 1644998579, NULL);
INSERT INTO `xy_balance_log` VALUES (4072, 171, 171, 'UB2202161558007005', 257997.00, 2, 2, 1644998608, NULL);
INSERT INTO `xy_balance_log` VALUES (4073, 171, 171, 'UB2202161558007005', 33539.61, 3, 1, 1644998608, NULL);
INSERT INTO `xy_balance_log` VALUES (4074, 171, 171, 'UB2202161558007005', 257997.00, 2, 1, 1644998608, NULL);
INSERT INTO `xy_balance_log` VALUES (4075, 171, 171, 'UB2202161558006312', 203682.00, 2, 2, 1644998608, NULL);
INSERT INTO `xy_balance_log` VALUES (4076, 171, 171, 'UB2202161558006312', 26478.66, 3, 1, 1644998608, NULL);
INSERT INTO `xy_balance_log` VALUES (4077, 171, 171, 'UB2202161558006312', 203682.00, 2, 1, 1644998608, NULL);
INSERT INTO `xy_balance_log` VALUES (4078, 171, 171, 'UB2202161558005458', 176524.00, 2, 2, 1644998608, NULL);
INSERT INTO `xy_balance_log` VALUES (4079, 171, 171, 'UB2202161558005458', 22948.12, 3, 1, 1644998608, NULL);
INSERT INTO `xy_balance_log` VALUES (4080, 171, 171, 'UB2202161558005458', 176524.00, 2, 1, 1644998608, NULL);
INSERT INTO `xy_balance_log` VALUES (4081, 171, 0, 'SY2202161605236536', 2000000.00, 1, 1, 1644998731, NULL);
INSERT INTO `xy_balance_log` VALUES (4082, 171, 171, 'UB2202161603419990', 1807265.00, 2, 2, 1644998750, NULL);
INSERT INTO `xy_balance_log` VALUES (4083, 171, 171, 'UB2202161603419990', 180726.50, 3, 1, 1644998750, NULL);
INSERT INTO `xy_balance_log` VALUES (4084, 171, 171, 'UB2202161603419990', 1807265.00, 2, 1, 1644998750, NULL);
INSERT INTO `xy_balance_log` VALUES (4085, 171, 171, 'UB2202161606097719', 1257442.00, 2, 2, 1644998777, NULL);
INSERT INTO `xy_balance_log` VALUES (4086, 171, 171, 'UB2202161606097719', 138318.62, 3, 1, 1644998777, NULL);
INSERT INTO `xy_balance_log` VALUES (4087, 171, 171, 'UB2202161606097719', 1257442.00, 2, 1, 1644998777, NULL);
INSERT INTO `xy_balance_log` VALUES (4088, 191, 0, 'SY2202111824296599', 5000.00, 1, 1, 1645451884, NULL);
INSERT INTO `xy_balance_log` VALUES (4089, 191, 0, 'CO2202111844458699', 2000.00, 8, 1, 1645452112, NULL);
INSERT INTO `xy_balance_log` VALUES (4090, 171, 171, 'UB2202161606477013', 3255451.00, 2, 2, 1645622552, NULL);
INSERT INTO `xy_balance_log` VALUES (4091, 171, 171, 'UB2202161606477013', 423208.63, 3, 1, 1645622552, NULL);
INSERT INTO `xy_balance_log` VALUES (4092, 171, 171, 'UB2202161606477013', 3255451.00, 2, 1, 1645622552, NULL);
INSERT INTO `xy_balance_log` VALUES (4093, 199, 199, 'UB2202260240057387', 100036.00, 2, 2, 1645814413, NULL);
INSERT INTO `xy_balance_log` VALUES (4094, 199, 199, 'UB2202260240057387', 15005.40, 3, 1, 1645814413, NULL);
INSERT INTO `xy_balance_log` VALUES (4095, 199, 199, 'UB2202260240057387', 100036.00, 2, 1, 1645814413, NULL);
INSERT INTO `xy_balance_log` VALUES (4096, 199, 199, 'UB2202260240245278', 54531.00, 2, 2, 1645814431, NULL);
INSERT INTO `xy_balance_log` VALUES (4097, 199, 199, 'UB2202260240245278', 8179.65, 3, 1, 1645814431, NULL);
INSERT INTO `xy_balance_log` VALUES (4098, 199, 199, 'UB2202260240245278', 54531.00, 2, 1, 1645814431, NULL);
INSERT INTO `xy_balance_log` VALUES (4099, 199, 199, 'UB2202260240399683', 57683.00, 2, 2, 1645814447, NULL);
INSERT INTO `xy_balance_log` VALUES (4100, 199, 199, 'UB2202260240399683', 8652.45, 3, 1, 1645814447, NULL);
INSERT INTO `xy_balance_log` VALUES (4101, 199, 199, 'UB2202260240399683', 57683.00, 2, 1, 1645814447, NULL);
INSERT INTO `xy_balance_log` VALUES (4102, 199, 199, 'UB2202260240556230', 72888.00, 2, 2, 1645814462, NULL);
INSERT INTO `xy_balance_log` VALUES (4103, 199, 199, 'UB2202260240556230', 10933.20, 3, 1, 1645814462, NULL);
INSERT INTO `xy_balance_log` VALUES (4104, 199, 199, 'UB2202260240556230', 72888.00, 2, 1, 1645814462, NULL);
INSERT INTO `xy_balance_log` VALUES (4105, 199, 199, 'UB2202260241157768', 101802.00, 2, 2, 1645814483, NULL);
INSERT INTO `xy_balance_log` VALUES (4106, 199, 199, 'UB2202260241157768', 15270.30, 3, 1, 1645814483, NULL);
INSERT INTO `xy_balance_log` VALUES (4107, 199, 199, 'UB2202260241157768', 101802.00, 2, 1, 1645814483, NULL);
INSERT INTO `xy_balance_log` VALUES (4108, 199, 199, 'UB2202260241324521', 73416.00, 2, 2, 1645814505, NULL);
INSERT INTO `xy_balance_log` VALUES (4109, 199, 199, 'UB2202260241324521', 11012.40, 3, 1, 1645814505, NULL);
INSERT INTO `xy_balance_log` VALUES (4110, 199, 199, 'UB2202260241324521', 73416.00, 2, 1, 1645814505, NULL);
INSERT INTO `xy_balance_log` VALUES (4111, 199, 199, 'UB2202260242245970', 59190.00, 2, 2, 1645814554, NULL);
INSERT INTO `xy_balance_log` VALUES (4112, 199, 199, 'UB2202260242245970', 152710.20, 3, 1, 1645814554, NULL);
INSERT INTO `xy_balance_log` VALUES (4113, 199, 199, 'UB2202260242245970', 59190.00, 2, 1, 1645814554, NULL);
INSERT INTO `xy_balance_log` VALUES (4114, 199, 199, 'UB2202260242422653', 579238.00, 2, 2, 1645814793, NULL);
INSERT INTO `xy_balance_log` VALUES (4115, 199, 199, 'UB2202260242422653', 173771.40, 3, 1, 1645814793, NULL);
INSERT INTO `xy_balance_log` VALUES (4116, 199, 199, 'UB2202260242422653', 579238.00, 2, 1, 1645814793, NULL);
INSERT INTO `xy_balance_log` VALUES (4117, 199, 199, 'UB2202260246442184', 1432027.00, 2, 2, 1645817355, NULL);
INSERT INTO `xy_balance_log` VALUES (4118, 199, 199, 'UB2202260246442184', 214804.05, 3, 1, 1645817355, NULL);
INSERT INTO `xy_balance_log` VALUES (4119, 199, 199, 'UB2202260246442184', 1432027.00, 2, 1, 1645817355, NULL);
INSERT INTO `xy_balance_log` VALUES (4120, 199, 199, 'UB2202260329247733', 1154963.00, 2, 2, 1645817372, NULL);
INSERT INTO `xy_balance_log` VALUES (4121, 199, 199, 'UB2202260329247733', 127045.93, 3, 1, 1645817372, NULL);
INSERT INTO `xy_balance_log` VALUES (4122, 199, 199, 'UB2202260329247733', 1154963.00, 2, 1, 1645817372, NULL);
INSERT INTO `xy_balance_log` VALUES (4123, 199, 199, 'UB2202260329408516', 1837419.00, 2, 2, 1645817455, NULL);
INSERT INTO `xy_balance_log` VALUES (4124, 199, 199, 'UB2202260329408516', 238864.47, 3, 1, 1645817455, NULL);
INSERT INTO `xy_balance_log` VALUES (4125, 199, 199, 'UB2202260329408516', 1837419.00, 2, 1, 1645817455, NULL);
INSERT INTO `xy_balance_log` VALUES (4126, 199, 199, 'UB2202260329406248', 2388645.00, 2, 2, 1645817464, NULL);
INSERT INTO `xy_balance_log` VALUES (4127, 199, 199, 'UB2202260329406248', 310523.85, 3, 1, 1645817464, NULL);
INSERT INTO `xy_balance_log` VALUES (4128, 199, 199, 'UB2202260329406248', 2388645.00, 2, 1, 1645817464, NULL);
INSERT INTO `xy_balance_log` VALUES (4129, 199, 199, 'UB2202260329401808', 3491097.00, 2, 2, 1645817475, NULL);
INSERT INTO `xy_balance_log` VALUES (4130, 199, 199, 'UB2202260329401808', 453842.61, 3, 1, 1645817475, NULL);
INSERT INTO `xy_balance_log` VALUES (4131, 199, 199, 'UB2202260329401808', 3491097.00, 2, 1, 1645817475, NULL);
INSERT INTO `xy_balance_log` VALUES (4132, 199, 199, 'UB2202260329403771', 2756129.00, 2, 2, 1645817486, NULL);
INSERT INTO `xy_balance_log` VALUES (4133, 199, 199, 'UB2202260329403771', 358296.77, 3, 1, 1645817486, NULL);
INSERT INTO `xy_balance_log` VALUES (4134, 199, 199, 'UB2202260329403771', 2756129.00, 2, 1, 1645817486, NULL);
INSERT INTO `xy_balance_log` VALUES (4135, 199, 199, 'UB2202260331555081', 25473969.00, 2, 2, 1645817552, NULL);
INSERT INTO `xy_balance_log` VALUES (4136, 199, 199, 'UB2202260331555081', 2547396.90, 3, 1, 1645817552, NULL);
INSERT INTO `xy_balance_log` VALUES (4137, 199, 199, 'UB2202260331555081', 25473969.00, 2, 1, 1645817552, NULL);
INSERT INTO `xy_balance_log` VALUES (4138, 199, 199, 'UB2202260340227812', 18812360.00, 2, 2, 1645818030, NULL);
INSERT INTO `xy_balance_log` VALUES (4139, 199, 199, 'UB2202260340227812', 564370.80, 3, 1, 1645818030, NULL);
INSERT INTO `xy_balance_log` VALUES (4140, 199, 199, 'UB2202260340227812', 18812360.00, 2, 1, 1645818030, NULL);
INSERT INTO `xy_balance_log` VALUES (4141, 199, 199, 'UB2202260340453409', 16277594.00, 2, 2, 1645818052, NULL);
INSERT INTO `xy_balance_log` VALUES (4142, 199, 199, 'UB2202260340453409', 488327.82, 3, 1, 1645818052, NULL);
INSERT INTO `xy_balance_log` VALUES (4143, 199, 199, 'UB2202260340453409', 16277594.00, 2, 1, 1645818052, NULL);
INSERT INTO `xy_balance_log` VALUES (4144, 199, 199, 'UB2202260340591091', 22793397.00, 2, 2, 1645818066, NULL);
INSERT INTO `xy_balance_log` VALUES (4145, 199, 199, 'UB2202260340591091', 683801.91, 3, 1, 1645818066, NULL);
INSERT INTO `xy_balance_log` VALUES (4146, 199, 199, 'UB2202260340591091', 22793397.00, 2, 1, 1645818066, NULL);
INSERT INTO `xy_balance_log` VALUES (4147, 199, 199, 'UB2202260341144545', 48724266.00, 2, 2, 1645818122, NULL);
INSERT INTO `xy_balance_log` VALUES (4148, 199, 199, 'UB2202260341144545', 2436213.30, 3, 1, 1645818122, NULL);
INSERT INTO `xy_balance_log` VALUES (4149, 199, 199, 'UB2202260341144545', 48724266.00, 2, 1, 1645818122, NULL);
INSERT INTO `xy_balance_log` VALUES (4150, 199, 199, 'UB2202260343277805', 93454304.00, 2, 2, 1645818235, NULL);
INSERT INTO `xy_balance_log` VALUES (4151, 199, 199, 'UB2202260343277805', 4672715.20, 3, 1, 1645818235, NULL);
INSERT INTO `xy_balance_log` VALUES (4152, 199, 199, 'UB2202260343277805', 93454304.00, 2, 1, 1645818235, NULL);
INSERT INTO `xy_balance_log` VALUES (4153, 199, 0, 'CO2202260345298703', 800.00, 7, 2, 1645818329, NULL);
INSERT INTO `xy_balance_log` VALUES (4154, 199, 199, 'UB2202260531414437', 421.00, 2, 2, 1645824709, NULL);
INSERT INTO `xy_balance_log` VALUES (4155, 199, 199, 'UB2202260531414437', 42.10, 3, 1, 1645824709, NULL);
INSERT INTO `xy_balance_log` VALUES (4156, 199, 199, 'UB2202260531414437', 421.00, 2, 1, 1645824709, NULL);
INSERT INTO `xy_balance_log` VALUES (4157, 199, 199, 'UB2202260531574303', 2030.00, 2, 2, 1645824790, NULL);
INSERT INTO `xy_balance_log` VALUES (4158, 199, 199, 'UB2202260531574303', 304.50, 3, 1, 1645824790, NULL);
INSERT INTO `xy_balance_log` VALUES (4159, 199, 199, 'UB2202260531574303', 2030.00, 2, 1, 1645824790, NULL);
INSERT INTO `xy_balance_log` VALUES (4160, 199, 199, 'UB2202260531573360', 812.00, 2, 2, 1645824790, NULL);
INSERT INTO `xy_balance_log` VALUES (4161, 199, 199, 'UB2202260531573360', 121.80, 3, 1, 1645824790, NULL);
INSERT INTO `xy_balance_log` VALUES (4162, 199, 199, 'UB2202260531573360', 812.00, 2, 1, 1645824790, NULL);
INSERT INTO `xy_balance_log` VALUES (4163, 199, 199, 'UB2202260531572824', 1522.00, 2, 2, 1645824790, NULL);
INSERT INTO `xy_balance_log` VALUES (4164, 199, 199, 'UB2202260531572824', 228.30, 3, 1, 1645824790, NULL);
INSERT INTO `xy_balance_log` VALUES (4165, 199, 199, 'UB2202260531572824', 1522.00, 2, 1, 1645824790, NULL);
INSERT INTO `xy_balance_log` VALUES (4166, 199, 199, 'UB2202260536161853', 3428.00, 2, 2, 1645824983, NULL);
INSERT INTO `xy_balance_log` VALUES (4167, 199, 199, 'UB2202260536161853', 514.20, 3, 1, 1645824983, NULL);
INSERT INTO `xy_balance_log` VALUES (4168, 199, 199, 'UB2202260536161853', 3428.00, 2, 1, 1645824983, NULL);
INSERT INTO `xy_balance_log` VALUES (4169, 199, 199, 'UB2202260536313878', 4902.00, 2, 2, 1645824998, NULL);
INSERT INTO `xy_balance_log` VALUES (4170, 199, 199, 'UB2202260536313878', 735.30, 3, 1, 1645824998, NULL);
INSERT INTO `xy_balance_log` VALUES (4171, 199, 199, 'UB2202260536313878', 4902.00, 2, 1, 1645824998, NULL);
INSERT INTO `xy_balance_log` VALUES (4172, 199, 199, 'UB2202260536468241', 5945.00, 2, 2, 1645825014, NULL);
INSERT INTO `xy_balance_log` VALUES (4173, 199, 199, 'UB2202260536468241', 891.75, 3, 1, 1645825014, NULL);
INSERT INTO `xy_balance_log` VALUES (4174, 199, 199, 'UB2202260536468241', 5945.00, 2, 1, 1645825014, NULL);
INSERT INTO `xy_balance_log` VALUES (4175, 199, 199, 'UB2202260548153739', 2649.00, 2, 2, 1645825702, NULL);
INSERT INTO `xy_balance_log` VALUES (4176, 199, 199, 'UB2202260548153739', 317.88, 3, 1, 1645825702, NULL);
INSERT INTO `xy_balance_log` VALUES (4177, 199, 199, 'UB2202260548153739', 2649.00, 2, 1, 1645825702, NULL);
INSERT INTO `xy_balance_log` VALUES (4178, 199, 199, 'UB2202260548291062', 7221.00, 2, 2, 1645825716, NULL);
INSERT INTO `xy_balance_log` VALUES (4179, 199, 199, 'UB2202260548291062', 866.52, 3, 1, 1645825716, NULL);
INSERT INTO `xy_balance_log` VALUES (4180, 199, 199, 'UB2202260548291062', 7221.00, 2, 1, 1645825716, NULL);
INSERT INTO `xy_balance_log` VALUES (4181, 199, 199, 'UB2202260548438653', 12741.00, 2, 2, 1645825750, NULL);
INSERT INTO `xy_balance_log` VALUES (4182, 199, 199, 'UB2202260548438653', 1528.92, 3, 1, 1645825750, NULL);
INSERT INTO `xy_balance_log` VALUES (4183, 199, 199, 'UB2202260548438653', 12741.00, 2, 1, 1645825750, NULL);
INSERT INTO `xy_balance_log` VALUES (4184, 199, 199, 'UB2202260549182606', 9697.00, 2, 2, 1645825765, NULL);
INSERT INTO `xy_balance_log` VALUES (4185, 199, 199, 'UB2202260549182606', 1163.64, 3, 1, 1645825765, NULL);
INSERT INTO `xy_balance_log` VALUES (4186, 199, 199, 'UB2202260549182606', 9697.00, 2, 1, 1645825765, NULL);
INSERT INTO `xy_balance_log` VALUES (4187, 199, 199, 'UB2202260549328402', 5998.00, 2, 2, 1645825779, NULL);
INSERT INTO `xy_balance_log` VALUES (4188, 199, 199, 'UB2202260549328402', 719.76, 3, 1, 1645825779, NULL);
INSERT INTO `xy_balance_log` VALUES (4189, 199, 199, 'UB2202260549328402', 5998.00, 2, 1, 1645825779, NULL);
INSERT INTO `xy_balance_log` VALUES (4190, 199, 200, '', 0.50, 5, 1, 1646080540, NULL);
INSERT INTO `xy_balance_log` VALUES (4191, 201, 201, 'UB2203122202019102', 672.00, 2, 2, 1647093730, NULL);
INSERT INTO `xy_balance_log` VALUES (4192, 201, 201, 'UB2203122202019102', 100.80, 3, 1, 1647093730, NULL);
INSERT INTO `xy_balance_log` VALUES (4193, 201, 201, 'UB2203122202019102', 672.00, 2, 1, 1647093730, NULL);
INSERT INTO `xy_balance_log` VALUES (4194, 172, 0, 'SY2203171621301809', 500.00, 1, 1, 1647505370, NULL);
INSERT INTO `xy_balance_log` VALUES (4195, 171, 0, 'SY2203171621301809', 25.00, 5, 1, 1647505370, NULL);
INSERT INTO `xy_balance_log` VALUES (4196, 172, 172, 'UB2203171640046846', 334.00, 2, 2, 1647506413, NULL);
INSERT INTO `xy_balance_log` VALUES (4197, 172, 172, 'UB2203171640046846', 167.00, 3, 1, 1647506413, NULL);
INSERT INTO `xy_balance_log` VALUES (4198, 172, 172, 'UB2203171640046846', 334.00, 2, 1, 1647506413, NULL);
INSERT INTO `xy_balance_log` VALUES (4199, 171, 172, 'UB2203171640046846', 23.38, 6, 1, 1647506413, NULL);
INSERT INTO `xy_balance_log` VALUES (4200, 172, 172, 'UB2203171640265827', 561.00, 2, 2, 1647506435, NULL);
INSERT INTO `xy_balance_log` VALUES (4201, 172, 172, 'UB2203171640265827', 280.50, 3, 1, 1647506435, NULL);
INSERT INTO `xy_balance_log` VALUES (4202, 172, 172, 'UB2203171640265827', 561.00, 2, 1, 1647506435, NULL);
INSERT INTO `xy_balance_log` VALUES (4203, 171, 172, 'UB2203171640265827', 39.27, 6, 1, 1647506435, NULL);
INSERT INTO `xy_balance_log` VALUES (4204, 172, 172, 'UB2203171640444727', 493.00, 2, 2, 1647506454, NULL);
INSERT INTO `xy_balance_log` VALUES (4205, 172, 172, 'UB2203171640444727', 246.50, 3, 1, 1647506454, NULL);
INSERT INTO `xy_balance_log` VALUES (4206, 172, 172, 'UB2203171640444727', 493.00, 2, 1, 1647506454, NULL);
INSERT INTO `xy_balance_log` VALUES (4207, 171, 172, 'UB2203171640444727', 34.51, 6, 1, 1647506454, NULL);
INSERT INTO `xy_balance_log` VALUES (4208, 172, 0, 'SY2203171646531330', 500.00, 1, 1, 1647506825, NULL);
INSERT INTO `xy_balance_log` VALUES (4209, 172, 172, 'UB2203171650295580', 443.00, 2, 2, 1647507040, NULL);
INSERT INTO `xy_balance_log` VALUES (4210, 172, 172, 'UB2203171650295580', 110.75, 3, 1, 1647507040, NULL);
INSERT INTO `xy_balance_log` VALUES (4211, 172, 172, 'UB2203171650295580', 443.00, 2, 1, 1647507040, NULL);
INSERT INTO `xy_balance_log` VALUES (4212, 171, 172, 'UB2203171650295580', 15.51, 6, 1, 1647507040, NULL);
INSERT INTO `xy_balance_log` VALUES (4213, 172, 172, 'UB2203171650513080', 219.00, 2, 2, 1647507058, NULL);
INSERT INTO `xy_balance_log` VALUES (4214, 172, 172, 'UB2203171650513080', 54.75, 3, 1, 1647507058, NULL);
INSERT INTO `xy_balance_log` VALUES (4215, 172, 172, 'UB2203171650513080', 219.00, 2, 1, 1647507058, NULL);
INSERT INTO `xy_balance_log` VALUES (4216, 171, 172, 'UB2203171650513080', 7.67, 6, 1, 1647507058, NULL);
INSERT INTO `xy_balance_log` VALUES (4217, 172, 172, 'UB2203171651082934', 207.00, 2, 2, 1647507075, NULL);
INSERT INTO `xy_balance_log` VALUES (4218, 172, 172, 'UB2203171651082934', 51.75, 3, 1, 1647507075, NULL);
INSERT INTO `xy_balance_log` VALUES (4219, 172, 172, 'UB2203171651082934', 207.00, 2, 1, 1647507075, NULL);
INSERT INTO `xy_balance_log` VALUES (4220, 171, 172, 'UB2203171651082934', 7.25, 6, 1, 1647507075, NULL);
INSERT INTO `xy_balance_log` VALUES (4221, 172, 0, 'SY2203171658149804', 1000.00, 1, 1, 1647507514, NULL);
INSERT INTO `xy_balance_log` VALUES (4222, 200, 200, 'UB2203192013196870', 641.00, 2, 2, 1647692029, NULL);
INSERT INTO `xy_balance_log` VALUES (4223, 200, 200, 'UB2203192013196870', 96.15, 3, 1, 1647692029, NULL);
INSERT INTO `xy_balance_log` VALUES (4224, 200, 200, 'UB2203192013196870', 641.00, 2, 1, 1647692029, NULL);
INSERT INTO `xy_balance_log` VALUES (4225, 171, 171, 'UB2202161606477659', 4883177.00, 2, 2, 1647692299, NULL);
INSERT INTO `xy_balance_log` VALUES (4226, 171, 171, 'UB2202161606477659', 634813.01, 3, 1, 1647692299, NULL);
INSERT INTO `xy_balance_log` VALUES (4227, 171, 171, 'UB2202161606477659', 4883177.00, 2, 1, 1647692299, NULL);
INSERT INTO `xy_balance_log` VALUES (4228, 171, 171, 'UB2202161606474126', 4232087.00, 2, 2, 1647692299, NULL);
INSERT INTO `xy_balance_log` VALUES (4229, 171, 171, 'UB2202161606474126', 550171.31, 3, 1, 1647692299, NULL);
INSERT INTO `xy_balance_log` VALUES (4230, 171, 171, 'UB2202161606474126', 4232087.00, 2, 1, 1647692299, NULL);
INSERT INTO `xy_balance_log` VALUES (4231, 171, 171, 'UB2203192018577203', 6908684.00, 2, 2, 1647692345, NULL);
INSERT INTO `xy_balance_log` VALUES (4232, 171, 171, 'UB2203192018577203', 276347.36, 3, 1, 1647692345, NULL);
INSERT INTO `xy_balance_log` VALUES (4233, 171, 171, 'UB2203192018577203', 6908684.00, 2, 1, 1647692345, NULL);
INSERT INTO `xy_balance_log` VALUES (4234, 171, 171, 'UB2203192019129701', 15876618.00, 2, 2, 1647692363, NULL);
INSERT INTO `xy_balance_log` VALUES (4235, 171, 171, 'UB2203192019129701', 635064.72, 3, 1, 1647692363, NULL);
INSERT INTO `xy_balance_log` VALUES (4236, 171, 171, 'UB2203192019129701', 15876618.00, 2, 1, 1647692363, NULL);
INSERT INTO `xy_balance_log` VALUES (4237, 171, 171, 'UB2203192019308907', 12350184.00, 2, 2, 1647692381, NULL);
INSERT INTO `xy_balance_log` VALUES (4238, 171, 171, 'UB2203192019308907', 494007.36, 3, 1, 1647692381, NULL);
INSERT INTO `xy_balance_log` VALUES (4239, 171, 171, 'UB2203192019308907', 12350184.00, 2, 1, 1647692381, NULL);
INSERT INTO `xy_balance_log` VALUES (4240, 171, 171, 'UB2203192019481637', 8466964.00, 2, 2, 1647692395, NULL);
INSERT INTO `xy_balance_log` VALUES (4241, 171, 171, 'UB2203192019481637', 338678.56, 3, 1, 1647692395, NULL);
INSERT INTO `xy_balance_log` VALUES (4242, 171, 171, 'UB2203192019481637', 8466964.00, 2, 1, 1647692395, NULL);
INSERT INTO `xy_balance_log` VALUES (4243, 171, 171, 'UB2203192020045952', 15346270.00, 2, 2, 1647692411, NULL);
INSERT INTO `xy_balance_log` VALUES (4244, 171, 171, 'UB2203192020045952', 613850.80, 3, 1, 1647692411, NULL);
INSERT INTO `xy_balance_log` VALUES (4245, 171, 171, 'UB2203192020045952', 15346270.00, 2, 1, 1647692411, NULL);
INSERT INTO `xy_balance_log` VALUES (4246, 171, 171, 'UB2203192021449016', 7532.00, 2, 2, 1647692513, NULL);
INSERT INTO `xy_balance_log` VALUES (4247, 171, 171, 'UB2203192021449016', 301.28, 3, 1, 1647692513, NULL);
INSERT INTO `xy_balance_log` VALUES (4248, 171, 171, 'UB2203192021449016', 7532.00, 2, 1, 1647692513, NULL);
INSERT INTO `xy_balance_log` VALUES (4249, 171, 171, 'UB2203192022011466', 11294.00, 2, 2, 1647692528, NULL);
INSERT INTO `xy_balance_log` VALUES (4250, 171, 171, 'UB2203192022011466', 451.76, 3, 1, 1647692528, NULL);
INSERT INTO `xy_balance_log` VALUES (4251, 171, 171, 'UB2203192022011466', 11294.00, 2, 1, 1647692528, NULL);
INSERT INTO `xy_balance_log` VALUES (4252, 171, 171, 'UB2203192022156072', 9307.00, 2, 2, 1647692542, NULL);
INSERT INTO `xy_balance_log` VALUES (4253, 171, 171, 'UB2203192022156072', 372.28, 3, 1, 1647692542, NULL);
INSERT INTO `xy_balance_log` VALUES (4254, 171, 171, 'UB2203192022156072', 9307.00, 2, 1, 1647692542, NULL);
INSERT INTO `xy_balance_log` VALUES (4255, 171, 171, 'UB2203192022292185', 7297.00, 2, 2, 1647692556, NULL);
INSERT INTO `xy_balance_log` VALUES (4256, 171, 171, 'UB2203192022292185', 291.88, 3, 1, 1647692556, NULL);
INSERT INTO `xy_balance_log` VALUES (4257, 171, 171, 'UB2203192022292185', 7297.00, 2, 1, 1647692556, NULL);
INSERT INTO `xy_balance_log` VALUES (4258, 171, 171, 'UB2203200101468718', 4923.00, 2, 2, 1647709314, NULL);
INSERT INTO `xy_balance_log` VALUES (4259, 171, 171, 'UB2203200101468718', 196.92, 3, 1, 1647709314, NULL);
INSERT INTO `xy_balance_log` VALUES (4260, 171, 171, 'UB2203200101468718', 4923.00, 2, 1, 1647709314, NULL);
INSERT INTO `xy_balance_log` VALUES (4261, 171, 171, 'UB2203200102161972', 10421.00, 2, 2, 1647709354, NULL);
INSERT INTO `xy_balance_log` VALUES (4262, 171, 171, 'UB2203200102161972', 26886.18, 3, 1, 1647709354, NULL);
INSERT INTO `xy_balance_log` VALUES (4263, 171, 171, 'UB2203200102161972', 10421.00, 2, 1, 1647709354, NULL);
INSERT INTO `xy_balance_log` VALUES (4264, 171, 171, 'UB2203200102413104', 71105.00, 2, 2, 1647709430, NULL);
INSERT INTO `xy_balance_log` VALUES (4265, 171, 171, 'UB2203200102413104', 21331.50, 3, 1, 1647709430, NULL);
INSERT INTO `xy_balance_log` VALUES (4266, 171, 171, 'UB2203200102413104', 71105.00, 2, 1, 1647709430, NULL);
INSERT INTO `xy_balance_log` VALUES (4267, 171, 171, 'UB2203200104005532', 166386.00, 2, 2, 1647709496, NULL);
INSERT INTO `xy_balance_log` VALUES (4268, 171, 171, 'UB2203200104005532', 24957.90, 3, 1, 1647709496, NULL);
INSERT INTO `xy_balance_log` VALUES (4269, 171, 171, 'UB2203200104005532', 166386.00, 2, 1, 1647709496, NULL);
INSERT INTO `xy_balance_log` VALUES (4270, 171, 171, 'UB2203200105119815', 344420.00, 2, 2, 1647709546, NULL);
INSERT INTO `xy_balance_log` VALUES (4271, 171, 171, 'UB2203200105119815', 103326.00, 3, 1, 1647709546, NULL);
INSERT INTO `xy_balance_log` VALUES (4272, 171, 171, 'UB2203200105119815', 344420.00, 2, 1, 1647709546, NULL);
INSERT INTO `xy_balance_log` VALUES (4273, 171, 171, 'UB2203200105584373', 537295.00, 2, 2, 1647709590, NULL);
INSERT INTO `xy_balance_log` VALUES (4274, 171, 171, 'UB2203200105584373', 161188.50, 3, 1, 1647709590, NULL);
INSERT INTO `xy_balance_log` VALUES (4275, 171, 171, 'UB2203200105584373', 537295.00, 2, 1, 1647709590, NULL);
INSERT INTO `xy_balance_log` VALUES (4276, 171, 171, 'UB2203200106388092', 1746210.00, 2, 2, 1647709632, NULL);
INSERT INTO `xy_balance_log` VALUES (4277, 171, 171, 'UB2203200106388092', 523863.00, 3, 1, 1647709632, NULL);
INSERT INTO `xy_balance_log` VALUES (4278, 171, 171, 'UB2203200106388092', 1746210.00, 2, 1, 1647709632, NULL);
INSERT INTO `xy_balance_log` VALUES (4279, 171, 171, 'UB2203200107202330', 3632116.00, 2, 2, 1647709690, NULL);
INSERT INTO `xy_balance_log` VALUES (4280, 171, 171, 'UB2203200107202330', 1089634.80, 3, 1, 1647709690, NULL);
INSERT INTO `xy_balance_log` VALUES (4281, 171, 171, 'UB2203200107202330', 3632116.00, 2, 1, 1647709690, NULL);
INSERT INTO `xy_balance_log` VALUES (4282, 171, 171, 'UB2203200108299984', 10387851.00, 2, 2, 1647709746, NULL);
INSERT INTO `xy_balance_log` VALUES (4283, 171, 171, 'UB2203200108299984', 6232710.60, 3, 1, 1647709746, NULL);
INSERT INTO `xy_balance_log` VALUES (4284, 171, 171, 'UB2203200108299984', 10387851.00, 2, 1, 1647709746, NULL);
INSERT INTO `xy_balance_log` VALUES (4285, 171, 171, 'UB2203200504157664', 42.00, 2, 2, 1647723864, NULL);
INSERT INTO `xy_balance_log` VALUES (4286, 171, 171, 'UB2203200504157664', 1.68, 3, 1, 1647723864, NULL);
INSERT INTO `xy_balance_log` VALUES (4287, 171, 171, 'UB2203200504157664', 42.00, 2, 1, 1647723864, NULL);
INSERT INTO `xy_balance_log` VALUES (4288, 171, 171, 'UB2203200504318458', 67.00, 2, 2, 1647723879, NULL);
INSERT INTO `xy_balance_log` VALUES (4289, 171, 171, 'UB2203200504318458', 2.68, 3, 1, 1647723879, NULL);
INSERT INTO `xy_balance_log` VALUES (4290, 171, 171, 'UB2203200504318458', 67.00, 2, 1, 1647723879, NULL);
INSERT INTO `xy_balance_log` VALUES (4291, 171, 171, 'UB2203200504464493', 43.00, 2, 2, 1647723895, NULL);
INSERT INTO `xy_balance_log` VALUES (4292, 171, 171, 'UB2203200504464493', 1.72, 3, 1, 1647723895, NULL);
INSERT INTO `xy_balance_log` VALUES (4293, 171, 171, 'UB2203200504464493', 43.00, 2, 1, 1647723895, NULL);
INSERT INTO `xy_balance_log` VALUES (4294, 171, 171, 'UB2203200505052120', 36.00, 2, 2, 1647723913, NULL);
INSERT INTO `xy_balance_log` VALUES (4295, 171, 171, 'UB2203200505052120', 1.44, 3, 1, 1647723913, NULL);
INSERT INTO `xy_balance_log` VALUES (4296, 171, 171, 'UB2203200505052120', 36.00, 2, 1, 1647723913, NULL);
INSERT INTO `xy_balance_log` VALUES (4297, 171, 171, 'UB2203200505205225', 103.00, 2, 2, 1647723946, NULL);
INSERT INTO `xy_balance_log` VALUES (4298, 171, 171, 'UB2203200505205225', 4.12, 3, 1, 1647723946, NULL);
INSERT INTO `xy_balance_log` VALUES (4299, 171, 171, 'UB2203200505205225', 103.00, 2, 1, 1647723946, NULL);
INSERT INTO `xy_balance_log` VALUES (4300, 171, 171, 'UB2203200507343319', 98.00, 2, 2, 1647724063, NULL);
INSERT INTO `xy_balance_log` VALUES (4301, 171, 171, 'UB2203200507343319', 19.60, 3, 1, 1647724063, NULL);
INSERT INTO `xy_balance_log` VALUES (4302, 171, 171, 'UB2203200507343319', 98.00, 2, 1, 1647724063, NULL);
INSERT INTO `xy_balance_log` VALUES (4303, 171, 171, 'UB2203200507519843', 76.00, 2, 2, 1647724079, NULL);
INSERT INTO `xy_balance_log` VALUES (4304, 171, 171, 'UB2203200507519843', 15.20, 3, 1, 1647724079, NULL);
INSERT INTO `xy_balance_log` VALUES (4305, 171, 171, 'UB2203200507519843', 76.00, 2, 1, 1647724079, NULL);
INSERT INTO `xy_balance_log` VALUES (4306, 171, 171, 'UB2203200508078535', 45.00, 2, 2, 1647724095, NULL);
INSERT INTO `xy_balance_log` VALUES (4307, 171, 171, 'UB2203200508078535', 9.00, 3, 1, 1647724095, NULL);
INSERT INTO `xy_balance_log` VALUES (4308, 171, 171, 'UB2203200508078535', 45.00, 2, 1, 1647724095, NULL);
INSERT INTO `xy_balance_log` VALUES (4309, 171, 171, 'UB2203200508322067', 89.00, 2, 2, 1647724119, NULL);
INSERT INTO `xy_balance_log` VALUES (4310, 171, 171, 'UB2203200508322067', 17.80, 3, 1, 1647724119, NULL);
INSERT INTO `xy_balance_log` VALUES (4311, 171, 171, 'UB2203200508322067', 89.00, 2, 1, 1647724119, NULL);
INSERT INTO `xy_balance_log` VALUES (4312, 171, 171, 'UB2203200508489690', 74.00, 2, 2, 1647724136, NULL);
INSERT INTO `xy_balance_log` VALUES (4313, 171, 171, 'UB2203200508489690', 14.80, 3, 1, 1647724136, NULL);
INSERT INTO `xy_balance_log` VALUES (4314, 171, 171, 'UB2203200508489690', 74.00, 2, 1, 1647724136, NULL);
INSERT INTO `xy_balance_log` VALUES (4315, 171, 171, 'UB2203200510344200', 108.00, 2, 2, 1647724242, NULL);
INSERT INTO `xy_balance_log` VALUES (4316, 171, 171, 'UB2203200510344200', 21.60, 3, 1, 1647724242, NULL);
INSERT INTO `xy_balance_log` VALUES (4317, 171, 171, 'UB2203200510344200', 108.00, 2, 1, 1647724242, NULL);
INSERT INTO `xy_balance_log` VALUES (4318, 171, 171, 'UB2203200511045286', 68.00, 2, 2, 1647724358, NULL);
INSERT INTO `xy_balance_log` VALUES (4319, 171, 171, 'UB2203200511045286', 13.60, 3, 1, 1647724358, NULL);
INSERT INTO `xy_balance_log` VALUES (4320, 171, 171, 'UB2203200511045286', 68.00, 2, 1, 1647724358, NULL);
INSERT INTO `xy_balance_log` VALUES (4321, 171, 171, 'UB2203200512511848', 104.00, 2, 2, 1647724380, NULL);
INSERT INTO `xy_balance_log` VALUES (4322, 171, 171, 'UB2203200512511848', 4.16, 3, 1, 1647724380, NULL);
INSERT INTO `xy_balance_log` VALUES (4323, 171, 171, 'UB2203200512511848', 104.00, 2, 1, 1647724380, NULL);
INSERT INTO `xy_balance_log` VALUES (4324, 171, 171, 'UB2203200513074051', 323.00, 2, 2, 1647724423, NULL);
INSERT INTO `xy_balance_log` VALUES (4325, 171, 171, 'UB2203200513074051', 12.92, 3, 1, 1647724423, NULL);
INSERT INTO `xy_balance_log` VALUES (4326, 171, 171, 'UB2203200513074051', 323.00, 2, 1, 1647724423, NULL);
INSERT INTO `xy_balance_log` VALUES (4327, 171, 171, 'UB2203200513566414', 857.00, 2, 2, 1647724473, NULL);
INSERT INTO `xy_balance_log` VALUES (4328, 171, 171, 'UB2203200513566414', 34.28, 3, 1, 1647724473, NULL);
INSERT INTO `xy_balance_log` VALUES (4329, 171, 171, 'UB2203200513566414', 857.00, 2, 1, 1647724473, NULL);
INSERT INTO `xy_balance_log` VALUES (4330, 171, 171, 'UB2203200514425064', 856.00, 2, 2, 1647724490, NULL);
INSERT INTO `xy_balance_log` VALUES (4331, 171, 171, 'UB2203200514425064', 34.24, 3, 1, 1647724490, NULL);
INSERT INTO `xy_balance_log` VALUES (4332, 171, 171, 'UB2203200514425064', 856.00, 2, 1, 1647724490, NULL);
INSERT INTO `xy_balance_log` VALUES (4333, 171, 171, 'UB2203200515087139', 933.00, 2, 2, 1647724516, NULL);
INSERT INTO `xy_balance_log` VALUES (4334, 171, 171, 'UB2203200515087139', 37.32, 3, 1, 1647724516, NULL);
INSERT INTO `xy_balance_log` VALUES (4335, 171, 171, 'UB2203200515087139', 933.00, 2, 1, 1647724516, NULL);
INSERT INTO `xy_balance_log` VALUES (4336, 171, 171, 'UB2203210218497476', 593.00, 2, 2, 1647800368, NULL);
INSERT INTO `xy_balance_log` VALUES (4337, 171, 171, 'UB2203210218497476', 23.72, 3, 1, 1647800368, NULL);
INSERT INTO `xy_balance_log` VALUES (4338, 171, 171, 'UB2203210218497476', 593.00, 2, 1, 1647800368, NULL);
INSERT INTO `xy_balance_log` VALUES (4339, 171, 0, 'SY2202271643325821', 100.00, 1, 1, 1648366817, NULL);

-- ----------------------------
-- Table structure for xy_bank_list
-- ----------------------------
DROP TABLE IF EXISTS `xy_bank_list`;
CREATE TABLE `xy_bank_list`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `number` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '银行编号',
  `bankname` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '银行名称',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 25 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '提现银行编码表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of xy_bank_list
-- ----------------------------
INSERT INTO `xy_bank_list` VALUES (1, 'ICBC', '工商银行');
INSERT INTO `xy_bank_list` VALUES (2, 'ABC', '农业银行');
INSERT INTO `xy_bank_list` VALUES (3, 'CMB', '招商银行');
INSERT INTO `xy_bank_list` VALUES (4, 'BCM', '交通银行');
INSERT INTO `xy_bank_list` VALUES (5, 'CCB', '建设银行');
INSERT INTO `xy_bank_list` VALUES (6, 'CMBC', '民生银行');
INSERT INTO `xy_bank_list` VALUES (7, 'CIB', '兴业银行');
INSERT INTO `xy_bank_list` VALUES (8, 'BOC', '中国银行');
INSERT INTO `xy_bank_list` VALUES (9, 'SPDB', '浦发银行');
INSERT INTO `xy_bank_list` VALUES (10, 'CEB ', '光大银行');
INSERT INTO `xy_bank_list` VALUES (11, 'PSBC', '邮政储蓄银行');
INSERT INTO `xy_bank_list` VALUES (12, 'PAB', '平安银行');
INSERT INTO `xy_bank_list` VALUES (13, 'HXB', '华夏银行');
INSERT INTO `xy_bank_list` VALUES (14, 'CGB', '广发银行');
INSERT INTO `xy_bank_list` VALUES (15, 'HKBEA', '东亚银行');
INSERT INTO `xy_bank_list` VALUES (16, 'NBCB', '宁波银行');
INSERT INTO `xy_bank_list` VALUES (17, 'CITIC', '中信银行');
INSERT INTO `xy_bank_list` VALUES (18, 'CBHB', '渤海银行');
INSERT INTO `xy_bank_list` VALUES (19, 'BOB', '北京银行');
INSERT INTO `xy_bank_list` VALUES (20, 'BJCB', '南京银行');
INSERT INTO `xy_bank_list` VALUES (21, 'SHB', '上海银行');
INSERT INTO `xy_bank_list` VALUES (22, 'GZYH', '广州银行');
INSERT INTO `xy_bank_list` VALUES (23, 'HZYH', '杭州银行');
INSERT INTO `xy_bank_list` VALUES (24, 'HZLHNCSYYH', '杭州联合商业银行');

-- ----------------------------
-- Table structure for xy_bankinfo
-- ----------------------------
DROP TABLE IF EXISTS `xy_bankinfo`;
CREATE TABLE `xy_bankinfo`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `uid` int(10) UNSIGNED NOT NULL COMMENT '会员ID',
  `bankname` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '银行名称',
  `cardnum` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '卡号',
  `username` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '用户名',
  `document_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `document_id` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `bank_code` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '银行代码',
  `bank_branch` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '支行代码',
  `bank_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '银行类型 SAVINGS or CHECKING',
  `account_digit` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT 'account digit',
  `wallet_tel` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `wallet_document_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `wallet_document_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `site` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '开户行地址',
  `tel` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '手机号',
  `status` tinyint(1) NOT NULL DEFAULT 0 COMMENT '状态，1启用，0禁用',
  `address` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `qq` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `Uid`(`uid`) USING BTREE,
  INDEX `Cardnum`(`cardnum`) USING BTREE,
  INDEX `bankname`(`bankname`) USING BTREE,
  INDEX `username`(`username`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 28 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '会员-银行卡信息表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of xy_bankinfo
-- ----------------------------
INSERT INTO `xy_bankinfo` VALUES (12, 172, 'HSBC', '4', '1', '', '5', 'MXNHSBC', '', '', '', '', '', '', '', '3', 1, '', '');
INSERT INTO `xy_bankinfo` VALUES (14, 171, 'name', '3333333222323', 'CBA', 'bsb1112233', 'payid111222', 'CBA', '5', '', '1', '2', '3', '', '4', '12312333', 1, '', '');
INSERT INTO `xy_bankinfo` VALUES (15, 181, 'NAB', '453453453453', '阿文', '', '', 'NAB', '', '', '', '', '', '', '', '0541729510', 1, '', '');
INSERT INTO `xy_bankinfo` VALUES (16, 184, 'NAB', '367168589233', 'rroon', '', '', 'NAB', '', '', '', '', '', '', '', '0627835680', 1, '', '');
INSERT INTO `xy_bankinfo` VALUES (17, 183, 'CBA', '27737338488222', 'saka', '', '', 'CBA', '', '', '', '', '', '', '', 'saka', 1, '', '');
INSERT INTO `xy_bankinfo` VALUES (18, 182, 'CBA', 'aa123456', 'ANNA', '', '', 'CBA', '', '', '', '', '', '', '', '0832499122', 1, '', '');
INSERT INTO `xy_bankinfo` VALUES (19, 186, 'NAB', '519687645648', 'nbkjnjk', '', '', 'NAB', '', '', '', '', '', '', '', '0633758710', 1, '', '');
INSERT INTO `xy_bankinfo` VALUES (20, 187, 'NAB', '1245785346788337', '9999', '', '', 'NAB', '', '', '', '', '', '', '', '0841729510', 1, '', '');
INSERT INTO `xy_bankinfo` VALUES (21, 190, 'CBA', '2456852453688', 'hgv', '', '', 'CBA', '', '', '', '', '', '', '', '0825527487', 1, '', '');
INSERT INTO `xy_bankinfo` VALUES (22, 188, 'NAB', '519687645648', 'mimi', '', '', 'NAB', '', '', '', '', '', '', '', '500', 1, '', '');
INSERT INTO `xy_bankinfo` VALUES (23, 192, 'NAB', '245245224452', 'ddddd', '', '', 'NAB', '', '', '', '', '', '', '', '0681563540', 1, '', '');
INSERT INTO `xy_bankinfo` VALUES (24, 191, 'CBA', '32546', 'SAKA', '', '', 'CBA', '', '', '', '', '', '', '', '0995150929', 1, '', '');
INSERT INTO `xy_bankinfo` VALUES (25, 193, 'CBA', '332545236456', 'wwe', '', '', 'CBA', '', '', '', '', '', '', '', '092607083', 1, '', '');
INSERT INTO `xy_bankinfo` VALUES (26, 196, 'CBA', 'aa123456', 'aaa', '', '', 'CBA', '', '', '', '', '', '', '', '832499122', 1, '', '');
INSERT INTO `xy_bankinfo` VALUES (27, 199, 'NAB', '273738847484', 'shshhs', '', '', 'NAB', '', '', '', '', '', '', '', '45464945', 1, '', '');

-- ----------------------------
-- Table structure for xy_banner
-- ----------------------------
DROP TABLE IF EXISTS `xy_banner`;
CREATE TABLE `xy_banner`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL,
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 4 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '首页轮播图' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of xy_banner
-- ----------------------------
INSERT INTO `xy_banner` VALUES (3, '/banner.jpg', NULL, '/index/ctrl/recharge');

-- ----------------------------
-- Table structure for xy_convey
-- ----------------------------
DROP TABLE IF EXISTS `xy_convey`;
CREATE TABLE `xy_convey`  (
  `oid` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `id` char(18) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `uid` int(11) NOT NULL COMMENT '会员ID',
  `level_id` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '会员级别',
  `parent_uid` int(11) NOT NULL DEFAULT 0 COMMENT '上级id',
  `num` decimal(15, 2) NOT NULL DEFAULT 0.00 COMMENT '交易金额',
  `user_balance` decimal(15, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '用户余额',
  `user_freeze_balance` decimal(15, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '用户冻结金额',
  `addtime` int(11) NOT NULL DEFAULT 0 COMMENT '下单时间',
  `endtime` int(11) NOT NULL DEFAULT 0 COMMENT '完成交易时间',
  `status` int(11) NOT NULL DEFAULT 0 COMMENT '订单状态 0待付款 1交易完成 2用户取消  3强制完成 4强制取消  5交易冻结',
  `is_pay` tinyint(3) UNSIGNED NOT NULL DEFAULT 0 COMMENT '是否付款',
  `pay_time` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '付款时间',
  `commission` decimal(15, 2) NOT NULL DEFAULT 0.00 COMMENT '佣金',
  `parent_commission` decimal(15, 2) NOT NULL DEFAULT 0.00 COMMENT ' 上级佣金',
  `c_status` int(11) NOT NULL DEFAULT 0 COMMENT '佣金发放状态 0未发放 1已发放 2账号冻结',
  `add_id` int(11) NOT NULL COMMENT '收货地址',
  `goods_id` int(11) NOT NULL COMMENT '商品ID',
  `goods_count` int(11) NOT NULL DEFAULT 1 COMMENT '商品数量',
  `group_id` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '杀猪组订单',
  `group_rule_num` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '杀猪组第几单',
  `group_is_active` tinyint(3) UNSIGNED NOT NULL DEFAULT 1 COMMENT '杀猪组是否激活',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `oid`(`oid`) USING BTREE,
  INDEX `uid`(`uid`) USING BTREE,
  INDEX `endtime`(`endtime`) USING BTREE,
  INDEX `addtime`(`addtime`) USING BTREE,
  INDEX `c_status`(`c_status`) USING BTREE,
  INDEX `parent_uid`(`parent_uid`) USING BTREE,
  INDEX `status`(`status`) USING BTREE,
  INDEX `group_id`(`group_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 360 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '会员-订单表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of xy_convey
-- ----------------------------
INSERT INTO `xy_convey` VALUES (16, 'UB2201020141434706', 179, 1, 0, 15.00, 200.00, 0.00, 1641058903, 1641062503, 1, 1, 1641058911, 0.08, 0.00, 1, 2, 369, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (17, 'UB2201020143457930', 179, 1, 0, 130.00, 200.08, 0.00, 1641059025, 1641062625, 1, 1, 1641059032, 0.68, 0.00, 1, 2, 82, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (18, 'UB2202082139142509', 180, 14, 0, 44721.00, 100001.00, 0.00, 1644327554, 1644331154, 1, 1, 1644327589, 348.82, 0.00, 1, 3, 7535, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (19, 'UB2202082141235964', 180, 14, 0, 100349.00, 100349.82, 0.00, 1644327683, 1644331283, 1, 1, 1644327736, 782.72, 0.00, 1, 3, 3384, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (20, 'UB2202082153331806', 171, 13, 0, 54237.00, 100000.03, 0.00, 1644328413, 1644332013, 1, 1, 1644328424, 412.20, 0.00, 1, 1, 5675, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (21, 'UB2202082157226077', 171, 13, 0, 38350.00, 100412.23, 0.00, 1644328642, 1644332242, 1, 1, 1644328651, 291.46, 0.00, 1, 1, 1996, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (22, 'UB2202082207309240', 171, 13, 0, 69407.00, 100703.69, 0.00, 1644329250, 1644332850, 1, 1, 1644329260, 527.49, 0.00, 1, 1, 2583, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (23, 'UB2202082207464651', 171, 13, 0, 71927.00, 101231.18, 0.00, 1644329266, 1644332866, 1, 1, 1644329277, 546.65, 0.00, 1, 1, 1285, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (24, 'UB2202082208065853', 171, 13, 0, 57957.00, 101777.83, 0.00, 1644329286, 1644332886, 1, 1, 1644329295, 440.47, 0.00, 1, 1, 1044, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (25, 'UB2202082209425203', 171, 13, 0, 57656.00, 102218.00, 0.00, 1644329382, 1644332982, 1, 1, 1644329389, 8648.40, 0.00, 1, 1, 3148, 1, 15, 1, 1);
INSERT INTO `xy_convey` VALUES (26, 'UB2202082210008738', 171, 13, 0, 88595.00, 110866.40, 0.00, 1644329400, 1644333000, 1, 1, 1644329409, 13289.25, 0.00, 1, 1, 7271, 1, 15, 2, 1);
INSERT INTO `xy_convey` VALUES (27, 'UB2202082210168477', 171, 13, 0, 310389.00, 124155.65, 0.00, 1644329416, 1644333016, 2, 0, 1644331813, 93116.70, 0.00, 0, 1, 701, 1, 15, 3, 1);
INSERT INTO `xy_convey` VALUES (28, 'UB2202082302371213', 181, 4, 171, 1139.00, 3001.00, 0.00, 1644332557, 1644336157, 1, 1, 1644332574, 6.61, 1.06, 1, 4, 2519, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (29, 'UB2202082303016634', 181, 4, 171, 683.00, 3007.61, 0.00, 1644332581, 1644336181, 1, 1, 1644332594, 3.96, 0.63, 1, 4, 4729, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (30, 'UB2202082303215832', 181, 4, 171, 1043.00, 3011.57, 0.00, 1644332601, 1644336201, 1, 1, 1644332608, 6.05, 0.97, 1, 4, 2355, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (31, 'UB2202082303367119', 181, 4, 171, 1694.00, 3017.62, 0.00, 1644332616, 1644336216, 1, 1, 1644332623, 9.83, 1.57, 1, 4, 6326, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (32, 'UB2202082303498297', 181, 4, 171, 1233.00, 3027.45, 0.00, 1644332629, 1644336229, 1, 1, 1644332636, 7.15, 1.14, 1, 4, 5158, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (33, 'UB2202082304037361', 181, 4, 171, 1922.00, 3034.60, 0.00, 1644332643, 1644336243, 1, 1, 1644332650, 11.15, 1.78, 1, 4, 5381, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (34, 'UB2202082304177331', 181, 4, 171, 1234.00, 3045.75, 0.00, 1644332657, 1644336257, 1, 1, 1644332664, 7.16, 1.15, 1, 4, 3296, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (35, 'UB2202082304312518', 181, 4, 171, 2348.00, 3052.91, 0.00, 1644332671, 1644336271, 1, 1, 1644332678, 13.62, 2.18, 1, 4, 317, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (36, 'UB2202082304488626', 181, 4, 171, 1787.00, 3066.53, 0.00, 1644332688, 1644336288, 1, 1, 1644332695, 10.36, 1.66, 1, 4, 3725, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (37, 'UB2202082305135238', 181, 4, 171, 2221.00, 3076.89, 0.00, 1644332713, 1644336313, 1, 1, 1644332720, 12.88, 2.06, 1, 4, 5353, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (38, 'UB2202082305474826', 181, 4, 171, 2129.00, 3089.77, 0.00, 1644332747, 1644336347, 1, 1, 1644332755, 12.35, 1.98, 1, 4, 1780, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (39, 'UB2202082306022217', 181, 4, 171, 2399.00, 3102.12, 0.00, 1644332762, 1644336362, 1, 1, 1644332769, 13.91, 2.23, 1, 4, 4602, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (40, 'UB2202082306156506', 181, 4, 171, 1566.00, 3116.03, 0.00, 1644332775, 1644336375, 1, 1, 1644332783, 9.08, 1.45, 1, 4, 4207, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (41, 'UB2202082306297619', 181, 4, 171, 2193.00, 3125.11, 0.00, 1644332789, 1644336389, 1, 1, 1644332796, 12.72, 2.04, 1, 4, 4730, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (42, 'UB2202082307113064', 181, 4, 171, 1371.00, 3137.83, 0.00, 1644332831, 1644336431, 1, 1, 1644332843, 7.95, 1.27, 1, 4, 2371, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (43, 'UB2202082307303087', 181, 4, 171, 1231.00, 3145.78, 0.00, 1644332850, 1644336450, 1, 1, 1644332857, 7.14, 1.14, 1, 4, 3394, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (44, 'UB2202082312423578', 181, 4, 171, 997.00, 3152.00, 0.00, 1644333162, 1644336762, 1, 1, 1644333170, 5.78, 0.93, 1, 4, 7550, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (45, 'UB2202082315485544', 181, 4, 171, 2364.00, 3157.00, 0.00, 1644333348, 1644336948, 1, 1, 1644333356, 6099.12, 975.86, 1, 4, 232, 1, 16, 1, 1);
INSERT INTO `xy_convey` VALUES (46, 'UB2202082316051155', 181, 4, 171, 16661.00, 9256.12, 0.00, 1644333365, 1644336965, 2, 0, 1644385227, 4998.30, 0.00, 0, 4, 522, 1, 16, 2, 1);
INSERT INTO `xy_convey` VALUES (47, 'UB2202091418182663', 184, 1, 181, 171.00, 501.00, 0.00, 1644387498, 1644391098, 1, 1, 1644387506, 0.89, 0.12, 1, 5, 1248, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (48, 'UB2202091418384200', 184, 1, 181, 207.00, 501.89, 0.00, 1644387518, 1644391118, 1, 1, 1644387525, 1.08, 0.14, 1, 5, 247, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (49, 'UB2202091419037900', 184, 1, 181, 155.00, 502.97, 0.00, 1644387543, 1644391143, 1, 1, 1644387550, 0.81, 0.10, 1, 5, 7070, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (50, 'UB2202091419173994', 184, 1, 181, 280.00, 503.78, 0.00, 1644387557, 1644391157, 1, 1, 1644387565, 1.46, 0.19, 1, 5, 8092, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (51, 'UB2202091419319447', 184, 1, 181, 101.00, 505.24, 0.00, 1644387571, 1644391171, 1, 1, 1644387578, 0.53, 0.07, 1, 5, 1891, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (52, 'UB2202091426288603', 183, 1, 181, 110.00, 501.00, 0.00, 1644387988, 1644391588, 1, 1, 1644387996, 0.57, 0.07, 1, 6, 715, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (53, 'UB2202091426474247', 183, 1, 181, 257.00, 501.57, 0.00, 1644388007, 1644391607, 1, 1, 1644388019, 1.34, 0.17, 1, 6, 3287, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (54, 'UB2202091427078095', 183, 1, 181, 364.00, 502.91, 0.00, 1644388027, 1644391627, 1, 1, 1644388036, 1.89, 0.25, 1, 6, 1092, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (55, 'UB2202091427252722', 183, 1, 181, 181.00, 504.80, 0.00, 1644388045, 1644391645, 1, 1, 1644388052, 0.94, 0.12, 1, 6, 1868, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (56, 'UB2202091427425768', 183, 1, 181, 316.00, 505.74, 0.00, 1644388062, 1644391662, 1, 1, 1644388069, 1.64, 0.21, 1, 6, 6065, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (57, 'UB2202091452008426', 182, 1, 181, 388.00, 501.00, 0.00, 1644389520, 1644393120, 1, 1, 1644389536, 2.02, 0.26, 1, 7, 3847, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (58, 'UB2202091452293910', 182, 1, 181, 383.00, 503.02, 0.00, 1644389549, 1644393149, 1, 1, 1644389556, 1.99, 0.26, 1, 7, 2706, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (59, 'UB2202091452422290', 182, 1, 181, 157.00, 505.01, 0.00, 1644389562, 1644393162, 1, 1, 1644389572, 0.82, 0.11, 1, 7, 55, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (60, 'UB2202091452588166', 182, 1, 181, 352.00, 505.83, 0.00, 1644389578, 1644393178, 1, 1, 1644389586, 1.83, 0.24, 1, 7, 7569, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (61, 'UB2202091453139504', 182, 1, 181, 231.00, 507.66, 0.00, 1644389593, 1644393193, 1, 1, 1644389600, 1.20, 0.16, 1, 7, 6825, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (62, 'UB2202091506465747', 186, 0, 181, 79.00, 301.00, 0.00, 1644390406, 1644394006, 1, 1, 1644390415, 0.47, 0.06, 1, 8, 6702, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (63, 'UB2202091507039214', 186, 0, 181, 129.00, 301.47, 0.00, 1644390423, 1644394023, 1, 1, 1644390434, 0.76, 0.10, 1, 8, 6014, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (64, 'UB2202091507248890', 186, 0, 181, 95.00, 302.23, 0.00, 1644390444, 1644394044, 1, 1, 1644390459, 0.56, 0.07, 1, 8, 2051, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (65, 'UB2202091515344139', 181, 5, 171, 2147.00, 10350.03, 0.00, 1644390934, 1644394534, 1, 1, 1644390942, 12.88, 2.06, 1, 4, 6487, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (66, 'UB2202091515491447', 181, 5, 171, 2554.00, 10362.91, 0.00, 1644390949, 1644394549, 1, 1, 1644390983, 15.32, 2.45, 1, 4, 1196, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (67, 'UB2202091516292078', 181, 5, 171, 6767.00, 10378.23, 0.00, 1644390989, 1644394589, 1, 1, 1644390997, 40.60, 6.50, 1, 4, 1837, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (68, 'UB2202091516445898', 181, 5, 171, 5733.00, 10418.83, 0.00, 1644391004, 1644394604, 1, 1, 1644391011, 34.40, 5.50, 1, 4, 3317, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (69, 'UB2202091516583540', 181, 5, 171, 3624.00, 10453.23, 0.00, 1644391018, 1644394618, 1, 1, 1644391025, 21.74, 3.48, 1, 4, 5671, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (70, 'UB2202091517124959', 181, 5, 171, 3328.00, 10474.97, 0.00, 1644391032, 1644394632, 1, 1, 1644391039, 19.97, 3.19, 1, 4, 3795, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (71, 'UB2202091517262954', 181, 5, 171, 7311.00, 10494.94, 0.00, 1644391046, 1644394646, 1, 1, 1644391053, 43.87, 7.02, 1, 4, 5455, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (72, 'UB2202091517426571', 181, 5, 171, 7089.00, 10538.81, 0.00, 1644391062, 1644394662, 1, 1, 1644391070, 42.53, 6.81, 1, 4, 315, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (73, 'UB2202091517562582', 181, 5, 171, 3777.00, 10581.34, 0.00, 1644391076, 1644394676, 1, 1, 1644391084, 22.66, 3.63, 1, 4, 1279, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (74, 'UB2202091518118795', 181, 5, 171, 7818.00, 10604.00, 0.00, 1644391091, 1644394691, 1, 1, 1644391100, 46.91, 7.51, 1, 4, 4594, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (75, 'UB2202091518272023', 181, 5, 171, 2746.00, 10650.91, 0.00, 1644391107, 1644394707, 1, 1, 1644391115, 16.48, 2.64, 1, 4, 2828, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (76, 'UB2202091518422814', 181, 5, 171, 3438.00, 10667.39, 0.00, 1644391122, 1644394722, 1, 1, 1644391129, 20.63, 3.30, 1, 4, 2984, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (77, 'UB2202091518556902', 181, 5, 171, 2545.00, 10688.02, 0.00, 1644391135, 1644394735, 1, 1, 1644391148, 15.27, 2.44, 1, 4, 1829, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (78, 'UB2202091519145203', 181, 5, 171, 7253.00, 10703.29, 0.00, 1644391154, 1644394754, 1, 1, 1644391163, 43.52, 6.96, 1, 4, 2016, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (79, 'UB2202091519303922', 181, 5, 171, 3299.00, 10746.81, 0.00, 1644391170, 1644394770, 1, 1, 1644391177, 19.79, 3.17, 1, 4, 5032, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (80, 'UB2202091519439881', 181, 5, 171, 4368.00, 10766.60, 0.00, 1644391183, 1644394783, 1, 1, 1644391190, 26.21, 4.19, 1, 4, 4115, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (81, 'UB2202091519574381', 181, 5, 171, 6072.00, 10792.81, 0.00, 1644391197, 1644394797, 1, 1, 1644391204, 36.43, 5.83, 1, 4, 991, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (82, 'UB2202091520146431', 181, 5, 171, 7326.00, 10829.24, 0.00, 1644391214, 1644394814, 1, 1, 1644391224, 43.96, 7.03, 1, 4, 5745, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (83, 'UB2202091520345612', 181, 5, 171, 7707.00, 10873.20, 0.00, 1644391234, 1644394834, 1, 1, 1644391242, 46.24, 7.40, 1, 4, 2411, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (84, 'UB2202091520489118', 181, 5, 171, 8396.00, 10919.44, 0.00, 1644391248, 1644394848, 1, 1, 1644391256, 50.38, 8.06, 1, 4, 7206, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (85, 'UB2202091521023258', 181, 5, 171, 3301.00, 10969.82, 0.00, 1644391262, 1644394862, 1, 1, 1644391269, 19.81, 3.17, 1, 4, 7176, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (86, 'UB2202091521159078', 181, 5, 171, 3373.00, 10989.63, 0.00, 1644391275, 1644394875, 1, 1, 1644391282, 20.24, 3.24, 1, 4, 7375, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (87, 'UB2202091521294116', 181, 5, 171, 2292.00, 11009.87, 0.00, 1644391289, 1644394889, 1, 1, 1644391296, 13.75, 2.20, 1, 4, 7963, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (88, 'UB2202091521432330', 181, 5, 171, 5159.00, 11023.62, 0.00, 1644391303, 1644394903, 1, 1, 1644391310, 30.95, 4.95, 1, 4, 6986, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (89, 'UB2202091521575336', 181, 5, 171, 8372.00, 11054.57, 0.00, 1644391317, 1644394917, 1, 1, 1644391324, 50.23, 8.04, 1, 4, 2232, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (90, 'UB2202091522122883', 181, 5, 171, 4266.00, 11104.80, 0.00, 1644391332, 1644394932, 1, 1, 1644391339, 25.60, 4.10, 1, 4, 7426, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (91, 'UB2202091522258405', 181, 5, 171, 6052.00, 11130.40, 0.00, 1644391345, 1644394945, 1, 1, 1644391352, 36.31, 5.81, 1, 4, 7302, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (92, 'UB2202091522399896', 181, 5, 171, 5557.00, 11166.71, 0.00, 1644391359, 1644394959, 1, 1, 1644391366, 33.34, 5.33, 1, 4, 7084, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (93, 'UB2202091522526723', 181, 5, 171, 7586.00, 11200.05, 0.00, 1644391372, 1644394972, 1, 1, 1644391380, 45.52, 7.28, 1, 4, 2022, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (94, 'UB2202091523078068', 181, 5, 171, 5981.00, 11245.57, 0.00, 1644391387, 1644394987, 1, 1, 1644391394, 35.89, 5.74, 1, 4, 3580, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (95, 'UB2202101511291217', 187, 0, 181, 45.00, 101.00, 0.00, 1644477089, 1644480689, 1, 1, 1644477098, 0.27, 0.04, 1, 9, 3724, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (96, 'UB2202101511443639', 187, 0, 181, 74.00, 101.27, 0.00, 1644477104, 1644480704, 1, 1, 1644477111, 0.44, 0.06, 1, 9, 1283, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (97, 'UB2202101511583278', 187, 0, 181, 81.00, 101.71, 0.00, 1644477118, 1644480718, 1, 1, 1644477126, 0.48, 0.07, 1, 9, 7306, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (98, 'UB2202101754004863', 180, 14, 0, 21675.00, 101132.00, 0.00, 1644486840, 1644490440, 0, 0, 0, 3251.25, 0.00, 0, 3, 6424, 1, 15, 1, 1);
INSERT INTO `xy_convey` VALUES (99, 'UB2202101820131797', 171, 13, 0, 26084.00, 125357.97, 0.00, 1644488413, 1644492013, 1, 1, 1644997961, 3912.60, 0.00, 1, 1, 7922, 1, 15, 4, 1);
INSERT INTO `xy_convey` VALUES (100, 'UB2202111029108047', 184, 2, 181, 340.00, 550.77, 0.00, 1644546550, 1644550150, 1, 1, 1644546558, 1.84, 0.26, 1, 5, 4624, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (101, 'UB2202111030293062', 184, 2, 181, 268.00, 552.61, 0.00, 1644546629, 1644550229, 1, 1, 1644546637, 1.45, 0.20, 1, 5, 3100, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (102, 'UB2202111030446606', 184, 2, 181, 384.00, 554.06, 0.00, 1644546644, 1644550244, 1, 1, 1644546652, 2.07, 0.29, 1, 5, 1614, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (103, 'UB2202111030593185', 184, 2, 181, 135.00, 556.13, 0.00, 1644546659, 1644550259, 1, 1, 1644546666, 0.73, 0.10, 1, 5, 4854, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (104, 'UB2202111031189869', 184, 2, 181, 145.00, 556.86, 0.00, 1644546678, 1644550278, 1, 1, 1644546686, 0.78, 0.11, 1, 5, 260, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (105, 'UB2202111031349937', 184, 2, 181, 201.00, 557.64, 0.00, 1644546694, 1644550294, 1, 1, 1644546701, 1.09, 0.15, 1, 5, 4384, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (106, 'UB2202111031489436', 184, 2, 181, 161.00, 558.73, 0.00, 1644546708, 1644550308, 1, 1, 1644546727, 0.87, 0.12, 1, 5, 4516, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (107, 'UB2202111033255062', 184, 2, 181, 364.00, 559.60, 0.00, 1644546805, 1644550405, 1, 1, 1644546813, 1.97, 0.28, 1, 5, 3813, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (108, 'UB2202111033403946', 184, 2, 181, 179.00, 561.57, 0.00, 1644546820, 1644550420, 1, 1, 1644546827, 0.97, 0.14, 1, 5, 4867, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (109, 'UB2202111033559165', 184, 2, 181, 439.00, 562.54, 0.00, 1644546835, 1644550435, 1, 1, 1644546846, 2.37, 0.33, 1, 5, 747, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (110, 'UB2202111103505919', 183, 2, 181, 116.00, 557.00, 0.00, 1644548630, 1644552230, 1, 1, 1644548640, 0.63, 0.09, 1, 6, 969, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (111, 'UB2202111104068048', 183, 2, 181, 321.00, 557.63, 0.00, 1644548646, 1644552246, 1, 1, 1644548661, 1.73, 0.24, 1, 6, 5207, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (112, 'UB2202111104295104', 183, 2, 181, 164.00, 559.36, 0.00, 1644548669, 1644552269, 1, 1, 1644548678, 0.89, 0.12, 1, 6, 1974, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (113, 'UB2202111104458815', 183, 2, 181, 418.00, 560.25, 0.00, 1644548685, 1644552285, 1, 1, 1644548693, 2.26, 0.32, 1, 6, 797, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (114, 'UB2202111105031218', 183, 2, 181, 438.00, 562.51, 0.00, 1644548703, 1644552303, 1, 1, 1644548712, 2.37, 0.33, 1, 6, 4385, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (115, 'UB2202111105201384', 183, 2, 181, 364.00, 564.88, 0.00, 1644548720, 1644552320, 1, 1, 1644548729, 1.97, 0.28, 1, 6, 6860, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (116, 'UB2202111105372463', 183, 2, 181, 429.00, 566.85, 0.00, 1644548737, 1644552337, 1, 1, 1644548747, 2.32, 0.32, 1, 6, 3390, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (117, 'UB2202111105547135', 183, 2, 181, 209.00, 569.17, 0.00, 1644548754, 1644552354, 1, 1, 1644548763, 1.13, 0.16, 1, 6, 490, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (118, 'UB2202111106125120', 183, 2, 181, 128.00, 570.30, 0.00, 1644548772, 1644552372, 1, 1, 1644548779, 0.69, 0.10, 1, 6, 3539, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (119, 'UB2202111106276987', 183, 2, 181, 393.00, 570.99, 0.00, 1644548787, 1644552387, 1, 1, 1644548796, 2.12, 0.30, 1, 6, 6675, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (120, 'UB2202111106543157', 186, 1, 181, 396.00, 802.79, 0.00, 1644548814, 1644552414, 1, 1, 1644548824, 2.06, 0.29, 1, 8, 7140, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (121, 'UB2202111107126977', 186, 1, 181, 489.00, 804.85, 0.00, 1644548832, 1644552432, 1, 1, 1644548842, 2.54, 0.36, 1, 8, 828, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (122, 'UB2202111107298631', 186, 1, 181, 176.00, 807.39, 0.00, 1644548849, 1644552449, 1, 1, 1644548859, 0.92, 0.13, 1, 8, 1805, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (123, 'UB2202111107468186', 186, 1, 181, 302.00, 808.31, 0.00, 1644548866, 1644552466, 1, 1, 1644548874, 1.57, 0.22, 1, 8, 1977, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (124, 'UB2202111108027576', 186, 1, 181, 494.00, 809.88, 0.00, 1644548882, 1644552482, 1, 1, 1644548889, 2.57, 0.36, 1, 8, 6075, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (125, 'UB2202111144557679', 182, 3, 181, 835.00, 1058.86, 0.00, 1644551095, 1644554695, 1, 1, 1644551104, 4.68, 0.65, 1, 7, 1637, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (126, 'UB2202111144587300', 186, 3, 181, 841.00, 1313.45, 0.00, 1644551098, 1644554698, 1, 1, 1644551139, 4.71, 0.66, 1, 8, 4634, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (127, 'UB2202111145116751', 182, 3, 181, 230.00, 1063.54, 0.00, 1644551111, 1644554711, 1, 1, 1644551119, 1.29, 0.18, 1, 7, 5566, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (128, 'UB2202111145256672', 182, 3, 181, 757.00, 1064.83, 0.00, 1644551125, 1644554725, 1, 1, 1644551133, 4.24, 0.59, 1, 7, 6993, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (129, 'UB2202111145402539', 182, 3, 181, 280.00, 1069.07, 0.00, 1644551140, 1644554740, 1, 1, 1644551147, 1.57, 0.22, 1, 7, 6347, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (130, 'UB2202111145486703', 186, 3, 181, 1020.00, 1318.16, 0.00, 1644551148, 1644554748, 1, 1, 1644551160, 5.71, 0.80, 1, 8, 429, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (131, 'UB2202111145538580', 182, 3, 181, 705.00, 1070.64, 0.00, 1644551153, 1644554753, 1, 1, 1644551162, 3.95, 0.55, 1, 7, 4636, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (132, 'UB2202111146085503', 182, 3, 181, 810.00, 1074.59, 0.00, 1644551168, 1644554768, 1, 1, 1644551177, 4.54, 0.64, 1, 7, 4197, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (133, 'UB2202111146233828', 182, 3, 181, 742.00, 1079.13, 0.00, 1644551183, 1644554783, 1, 1, 1644551190, 4.16, 0.58, 1, 7, 18, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (134, 'UB2202111146254082', 186, 3, 181, 526.00, 1323.87, 0.00, 1644551185, 1644554785, 1, 1, 1644551192, 2.95, 0.41, 1, 8, 311, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (135, 'UB2202111146362224', 182, 3, 181, 323.00, 1083.29, 0.00, 1644551196, 1644554796, 1, 1, 1644551203, 1.81, 0.25, 1, 7, 2735, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (136, 'UB2202111146398206', 186, 3, 181, 1004.00, 1326.82, 0.00, 1644551199, 1644554799, 1, 1, 1644551206, 5.62, 0.79, 1, 8, 799, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (137, 'UB2202111146505302', 182, 3, 181, 273.00, 1085.10, 0.00, 1644551210, 1644554810, 1, 1, 1644551217, 1.53, 0.21, 1, 7, 8056, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (138, 'UB2202111146551594', 186, 3, 181, 293.00, 1332.44, 0.00, 1644551215, 1644554815, 1, 1, 1644551225, 1.64, 0.23, 1, 8, 2467, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (139, 'UB2202111147051309', 182, 3, 181, 728.00, 1086.63, 0.00, 1644551225, 1644554825, 1, 1, 1644551234, 4.08, 0.57, 1, 7, 753, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (140, 'UB2202111147106744', 186, 3, 181, 1023.00, 1334.08, 0.00, 1644551230, 1644554830, 1, 1, 1644551237, 5.73, 0.80, 1, 8, 578, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (141, 'UB2202111147215035', 182, 3, 181, 443.00, 1090.71, 0.00, 1644551241, 1644554841, 1, 1, 1644551249, 2.48, 0.35, 1, 7, 688, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (142, 'UB2202111147258819', 186, 3, 181, 763.00, 1339.81, 0.00, 1644551245, 1644554845, 1, 1, 1644551252, 4.27, 0.60, 1, 8, 6627, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (143, 'UB2202111147367061', 182, 3, 181, 865.00, 1093.19, 0.00, 1644551256, 1644554856, 1, 1, 1644551263, 4.84, 0.68, 1, 7, 4208, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (144, 'UB2202111147394456', 186, 3, 181, 1072.00, 1344.08, 0.00, 1644551259, 1644554859, 1, 1, 1644551266, 6.00, 0.84, 1, 8, 151, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (145, 'UB2202111147502936', 182, 3, 181, 254.00, 1098.03, 0.00, 1644551270, 1644554870, 1, 1, 1644551278, 1.42, 0.20, 1, 7, 1373, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (146, 'UB2202111147535167', 186, 3, 181, 351.00, 1350.08, 0.00, 1644551273, 1644554873, 1, 1, 1644551283, 1.97, 0.28, 1, 8, 672, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (147, 'UB2202111148055190', 182, 3, 181, 829.00, 1099.45, 0.00, 1644551285, 1644554885, 1, 1, 1644551292, 4.64, 0.65, 1, 7, 2974, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (148, 'UB2202111148129879', 186, 3, 181, 884.00, 1352.05, 0.00, 1644551292, 1644554892, 1, 1, 1644551301, 4.95, 0.69, 1, 8, 3742, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (149, 'UB2202111148191699', 182, 3, 181, 443.00, 1104.09, 0.00, 1644551299, 1644554899, 1, 1, 1644551306, 2.48, 0.35, 1, 7, 3925, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (150, 'UB2202111148277093', 186, 3, 181, 734.00, 1357.00, 0.00, 1644551307, 1644554907, 1, 1, 1644551317, 4.11, 0.58, 1, 8, 2957, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (151, 'UB2202111148458207', 186, 3, 181, 610.00, 1361.11, 0.00, 1644551325, 1644554925, 1, 1, 1644551333, 3.42, 0.48, 1, 8, 5305, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (152, 'UB2202111257062962', 186, 3, 181, 725.00, 1364.53, 0.00, 1644555426, 1644559026, 1, 1, 1644555434, 4.06, 0.57, 1, 8, 727, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (153, 'UB2202111257227693', 186, 3, 181, 735.00, 1368.59, 0.00, 1644555442, 1644559042, 1, 1, 1644555451, 4.12, 0.58, 1, 8, 5524, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (154, 'UB2202111257546418', 186, 3, 181, 576.00, 1372.71, 0.00, 1644555474, 1644559074, 1, 1, 1644555490, 3.23, 0.45, 1, 8, 7753, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (155, 'UB2202111440079443', 190, 0, 184, 108.00, 136.00, 0.00, 1644561607, 1644565207, 1, 1, 1644561701, 16.20, 1.78, 1, 10, 5192, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (156, 'UB2202111443184310', 190, 0, 184, 58.00, 152.20, 0.00, 1644561798, 1644565398, 1, 1, 1644561806, 8.70, 0.96, 1, 10, 7206, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (157, 'UB2202111443351904', 190, 0, 184, 125.00, 160.90, 0.00, 1644561815, 1644565415, 1, 1, 1644561822, 18.75, 2.06, 1, 10, 7566, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (158, 'UB2202111519499956', 188, 1, 183, 213.00, 536.00, 0.00, 1644563989, 1644567589, 1, 1, 1644563999, 1.11, 0.12, 1, 11, 844, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (159, 'UB2202111520298048', 190, 2, 184, 747.00, 1029.65, 0.00, 1644564029, 1644567629, 1, 1, 1644564037, 4.03, 0.44, 1, 10, 3079, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (160, 'UB2202111520449231', 190, 2, 184, 799.00, 1033.68, 0.00, 1644564044, 1644567644, 1, 1, 1644564054, 4.31, 0.47, 1, 10, 1850, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (161, 'UB2202111521003909', 190, 2, 184, 684.00, 1037.99, 0.00, 1644564060, 1644567660, 1, 1, 1644564069, 3.69, 0.41, 1, 10, 6753, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (162, 'UB2202111521167122', 190, 2, 184, 496.00, 1041.68, 0.00, 1644564076, 1644567676, 1, 1, 1644564083, 2.68, 0.29, 1, 10, 32, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (163, 'UB2202111521323279', 190, 2, 184, 680.00, 1044.36, 0.00, 1644564092, 1644567692, 1, 1, 1644564099, 3.67, 0.40, 1, 10, 319, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (164, 'UB2202111521473189', 190, 2, 184, 570.00, 1048.03, 0.00, 1644564107, 1644567707, 1, 1, 1644564114, 3.08, 0.34, 1, 10, 1564, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (165, 'UB2202111522006509', 190, 2, 184, 433.00, 1051.11, 0.00, 1644564120, 1644567720, 1, 1, 1644564127, 2.34, 0.26, 1, 10, 2786, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (166, 'UB2202111522143012', 190, 2, 184, 751.00, 1053.45, 0.00, 1644564134, 1644567734, 1, 1, 1644564141, 4.06, 0.45, 1, 10, 6588, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (167, 'UB2202111522256692', 188, 1, 183, 194.00, 537.11, 0.00, 1644564145, 1644567745, 1, 1, 1644564154, 1.01, 0.11, 1, 11, 1262, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (168, 'UB2202111522286687', 190, 2, 184, 832.00, 1057.51, 0.00, 1644564148, 1644567748, 1, 1, 1644564155, 4.49, 0.49, 1, 10, 5014, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (169, 'UB2202111522426024', 190, 2, 184, 528.00, 1062.00, 0.00, 1644564162, 1644567762, 1, 1, 1644564169, 2.85, 0.31, 1, 10, 5632, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (170, 'UB2202111522433082', 188, 1, 183, 210.00, 538.12, 0.00, 1644564163, 1644567763, 1, 1, 1644564171, 1.09, 0.12, 1, 11, 2646, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (171, 'UB2202111522596910', 188, 1, 183, 282.00, 539.21, 0.00, 1644564179, 1644567779, 1, 1, 1644564186, 1.47, 0.16, 1, 11, 4621, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (172, 'UB2202111523143954', 188, 1, 183, 380.00, 540.68, 0.00, 1644564194, 1644567794, 1, 1, 1644564202, 1.98, 0.22, 1, 11, 6057, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (173, 'UB2202111540572198', 187, 1, 181, 217.00, 602.00, 0.00, 1644565257, 1644568857, 1, 1, 1644565264, 1.13, 0.16, 1, 9, 7928, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (174, 'UB2202111541104059', 187, 1, 181, 239.00, 603.13, 0.00, 1644565270, 1644568870, 1, 1, 1644565277, 1.24, 0.17, 1, 9, 7046, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (175, 'UB2202111541272213', 187, 1, 181, 196.00, 604.37, 0.00, 1644565287, 1644568887, 1, 1, 1644565298, 1.02, 0.14, 1, 9, 4071, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (176, 'UB2202111541451619', 187, 1, 181, 410.00, 605.39, 0.00, 1644565305, 1644568905, 1, 1, 1644565312, 2.13, 0.30, 1, 9, 4652, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (177, 'UB2202111541587862', 187, 1, 181, 192.00, 607.52, 0.00, 1644565318, 1644568918, 1, 1, 1644565325, 1.00, 0.14, 1, 9, 5912, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (178, 'UB2202111556243532', 190, 4, 184, 640.00, 1514.00, 0.00, 1644566184, 1644569784, 1, 1, 1644566192, 1651.20, 181.63, 1, 10, 77, 1, 16, 1, 1);
INSERT INTO `xy_convey` VALUES (179, 'UB2202111556396055', 190, 4, 184, 5697.00, 3165.20, 0.00, 1644566199, 1644569799, 1, 1, 1644566673, 1709.10, 0.00, 1, 10, 6122, 1, 16, 2, 1);
INSERT INTO `xy_convey` VALUES (180, 'UB2202111604434688', 190, 14, 184, 188773.00, 104874.30, 0.00, 1644566683, 1644570283, 0, 0, 0, 28315.95, 0.00, 0, 10, 3399, 1, 16, 3, 1);
INSERT INTO `xy_convey` VALUES (181, 'UB2202111650425542', 192, 0, 187, 63.00, 136.00, 0.00, 1644569442, 1644573042, 1, 1, 1644569453, 9.45, 0.95, 1, 12, 887, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (182, 'UB2202111651046699', 192, 0, 187, 45.00, 145.45, 0.00, 1644569464, 1644573064, 1, 1, 1644569473, 6.75, 0.68, 1, 12, 6933, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (183, 'UB2202111651296461', 192, 0, 187, 105.00, 152.20, 0.00, 1644569489, 1644573089, 1, 1, 1644569497, 15.75, 1.58, 1, 12, 4068, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (184, 'UB2202111709082216', 191, 0, 186, 98.00, 136.00, 0.00, 1644570548, 1644574148, 1, 1, 1644570560, 14.70, 1.76, 1, 13, 6453, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (185, 'UB2202111709284771', 191, 0, 186, 103.00, 150.70, 0.00, 1644570568, 1644574168, 1, 1, 1644570577, 15.45, 1.85, 1, 13, 7317, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (186, 'UB2202111709442870', 191, 0, 186, 72.00, 166.15, 0.00, 1644570584, 1644574184, 1, 1, 1644570593, 10.80, 1.30, 1, 13, 1695, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (187, 'UB2202111803337490', 193, 0, 190, 76.00, 100.00, 0.00, 1644573813, 1644577413, 1, 1, 1644573932, 11.40, 1.82, 1, 14, 329, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (188, 'UB2202111807224280', 193, 0, 190, 67.00, 111.40, 0.00, 1644574042, 1644577642, 1, 1, 1644574050, 10.05, 1.61, 1, 14, 1306, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (189, 'UB2202111807388459', 193, 0, 190, 71.00, 121.45, 0.00, 1644574058, 1644577658, 1, 1, 1644574080, 10.65, 1.70, 1, 14, 2821, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (190, 'UB2202111826074576', 191, 7, 186, 3916.00, 5076.95, 0.00, 1644575167, 1644578767, 1, 1, 1644575180, 25.06, 3.01, 1, 13, 4114, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (191, 'UB2202111826322346', 191, 7, 186, 2164.00, 5102.01, 0.00, 1644575192, 1644578792, 1, 1, 1644575201, 13.85, 1.66, 1, 13, 2108, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (192, 'UB2202111826517018', 191, 7, 186, 3317.00, 5115.86, 0.00, 1644575211, 1644578811, 1, 1, 1644575220, 21.23, 2.55, 1, 13, 2881, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (193, 'UB2202111827073644', 191, 7, 186, 4101.00, 5137.09, 0.00, 1644575227, 1644578827, 1, 1, 1644575240, 26.25, 3.15, 1, 13, 54, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (194, 'UB2202111827274915', 191, 7, 186, 1976.00, 5163.34, 0.00, 1644575247, 1644578847, 1, 1, 1644575257, 12.65, 1.52, 1, 13, 2143, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (195, 'UB2202111827447483', 191, 7, 186, 3534.00, 5175.99, 0.00, 1644575264, 1644578864, 1, 1, 1644575271, 22.62, 2.71, 1, 13, 1233, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (196, 'UB2202111827589947', 191, 7, 186, 3766.00, 5198.61, 0.00, 1644575278, 1644578878, 1, 1, 1644575286, 24.10, 2.89, 1, 13, 1528, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (197, 'UB2202111828137751', 191, 7, 186, 2905.00, 5222.71, 0.00, 1644575293, 1644578893, 1, 1, 1644575301, 18.59, 2.23, 1, 13, 1694, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (198, 'UB2202111828282971', 191, 7, 186, 4038.00, 5241.30, 0.00, 1644575308, 1644578908, 1, 1, 1644575316, 25.84, 3.10, 1, 13, 3941, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (199, 'UB2202111828533686', 191, 7, 186, 2466.00, 5267.14, 0.00, 1644575333, 1644578933, 1, 1, 1644575343, 15.78, 1.89, 1, 13, 3441, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (200, 'UB2202111829284011', 191, 7, 186, 1829.00, 5282.92, 0.00, 1644575368, 1644578968, 1, 1, 1644575377, 11.71, 1.40, 1, 13, 5401, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (201, 'UB2202111829458941', 191, 7, 186, 2763.00, 5294.63, 0.00, 1644575385, 1644578985, 1, 1, 1644575393, 17.68, 2.12, 1, 13, 7350, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (202, 'UB2202111829598039', 191, 7, 186, 2738.00, 5312.31, 0.00, 1644575399, 1644578999, 1, 1, 1644575407, 17.52, 2.10, 1, 13, 3566, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (203, 'UB2202111830142332', 191, 7, 186, 2822.00, 5329.83, 0.00, 1644575414, 1644579014, 1, 1, 1644575422, 18.06, 2.17, 1, 13, 115, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (204, 'UB2202111830297932', 191, 7, 186, 2951.00, 5347.89, 0.00, 1644575429, 1644579029, 1, 1, 1644575438, 18.89, 2.27, 1, 13, 6185, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (205, 'UB2202111830448954', 191, 7, 186, 3668.00, 5366.78, 0.00, 1644575444, 1644579044, 1, 1, 1644575452, 23.48, 2.82, 1, 13, 3714, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (206, 'UB2202111830582783', 191, 7, 186, 3741.00, 5390.26, 0.00, 1644575458, 1644579058, 1, 1, 1644575466, 23.94, 2.87, 1, 13, 3969, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (207, 'UB2202111831141527', 191, 7, 186, 2090.00, 5414.20, 0.00, 1644575474, 1644579074, 1, 1, 1644575481, 13.38, 1.61, 1, 13, 5201, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (208, 'UB2202111831289050', 191, 7, 186, 3448.00, 5427.58, 0.00, 1644575488, 1644579088, 1, 1, 1644575496, 22.07, 2.65, 1, 13, 3118, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (209, 'UB2202111831444984', 191, 7, 186, 3033.00, 5449.65, 0.00, 1644575504, 1644579104, 1, 1, 1644575512, 19.41, 2.33, 1, 13, 6976, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (210, 'UB2202111831583057', 191, 7, 186, 3627.00, 5469.06, 0.00, 1644575518, 1644579118, 1, 1, 1644575527, 23.21, 2.79, 1, 13, 1189, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (211, 'UB2202111832146920', 191, 7, 186, 2913.00, 5492.27, 0.00, 1644575534, 1644579134, 1, 1, 1644575541, 18.64, 2.24, 1, 13, 4180, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (212, 'UB2202111832312348', 191, 7, 186, 2612.00, 5510.91, 0.00, 1644575551, 1644579151, 1, 1, 1644575559, 16.72, 2.01, 1, 13, 3388, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (213, 'UB2202111832467739', 191, 7, 186, 4120.00, 5527.63, 0.00, 1644575566, 1644579166, 1, 1, 1644575575, 26.37, 3.16, 1, 13, 5553, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (214, 'UB2202111833028985', 191, 7, 186, 2575.00, 5554.00, 0.00, 1644575582, 1644579182, 1, 1, 1644575592, 16.48, 1.98, 1, 13, 7285, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (215, 'UB2202111833198596', 191, 7, 186, 4426.00, 5570.48, 0.00, 1644575599, 1644579199, 1, 1, 1644575606, 28.33, 3.40, 1, 13, 1935, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (216, 'UB2202111833356778', 191, 7, 186, 2131.00, 5598.81, 0.00, 1644575615, 1644579215, 1, 1, 1644575622, 13.64, 1.64, 1, 13, 7947, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (217, 'UB2202111833498709', 191, 7, 186, 2569.00, 5612.45, 0.00, 1644575629, 1644579229, 1, 1, 1644575637, 16.44, 1.97, 1, 13, 7211, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (218, 'UB2202111834049491', 191, 7, 186, 3324.00, 5628.89, 0.00, 1644575644, 1644579244, 1, 1, 1644575657, 21.27, 2.55, 1, 13, 4055, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (219, 'UB2202111834242058', 191, 7, 186, 3211.00, 5650.16, 0.00, 1644575664, 1644579264, 1, 1, 1644575673, 20.55, 2.47, 1, 13, 801, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (220, 'UB2202111834425137', 191, 7, 186, 1986.00, 5670.71, 0.00, 1644575682, 1644579282, 1, 1, 1644575689, 12.71, 1.53, 1, 13, 4819, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (221, 'UB2202111834575139', 191, 7, 186, 4316.00, 5683.42, 0.00, 1644575697, 1644579297, 1, 1, 1644575706, 27.62, 3.31, 1, 13, 6375, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (222, 'UB2202111835166706', 191, 7, 186, 2831.00, 5711.04, 0.00, 1644575716, 1644579316, 1, 1, 1644575724, 18.12, 2.17, 1, 13, 3289, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (223, 'UB2202111835305268', 191, 7, 186, 4552.00, 5729.16, 0.00, 1644575730, 1644579330, 1, 1, 1644575738, 29.13, 3.50, 1, 13, 1707, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (224, 'UB2202111835457858', 191, 7, 186, 2075.00, 5758.29, 0.00, 1644575745, 1644579345, 1, 1, 1644575753, 13.28, 1.59, 1, 13, 4783, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (225, 'UB2202111836007171', 191, 7, 186, 2189.00, 5771.57, 0.00, 1644575760, 1644579360, 1, 1, 1644575769, 14.01, 1.68, 1, 13, 2204, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (226, 'UB2202111836165071', 191, 7, 186, 3598.00, 5785.58, 0.00, 1644575776, 1644579376, 1, 1, 1644575784, 23.03, 2.76, 1, 13, 717, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (227, 'UB2202111836348061', 191, 7, 186, 1962.00, 5808.61, 0.00, 1644575794, 1644579394, 1, 1, 1644575803, 12.56, 1.51, 1, 13, 1801, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (228, 'UB2202111836504841', 191, 7, 186, 3374.00, 5821.17, 0.00, 1644575810, 1644579410, 1, 1, 1644575819, 21.59, 2.59, 1, 13, 5738, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (229, 'UB2202111837057662', 191, 7, 186, 3271.00, 5842.76, 0.00, 1644575825, 1644579425, 1, 1, 1644575833, 20.93, 2.51, 1, 13, 1742, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (230, 'UB2202111837196976', 191, 7, 186, 3487.00, 5863.69, 0.00, 1644575839, 1644579439, 1, 1, 1644575847, 22.32, 2.68, 1, 13, 4334, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (231, 'UB2202111837352803', 191, 7, 186, 2735.00, 5886.01, 0.00, 1644575855, 1644579455, 1, 1, 1644575862, 17.50, 2.10, 1, 13, 1252, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (232, 'UB2202111837493290', 191, 7, 186, 3699.00, 5903.51, 0.00, 1644575869, 1644579469, 1, 1, 1644575877, 23.67, 2.84, 1, 13, 912, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (233, 'UB2202111838052750', 191, 7, 186, 1869.00, 5927.18, 0.00, 1644575885, 1644579485, 1, 1, 1644575892, 11.96, 1.44, 1, 13, 4615, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (234, 'UB2202111838196537', 191, 7, 186, 3362.00, 5939.14, 0.00, 1644575899, 1644579499, 1, 1, 1644575906, 21.52, 2.58, 1, 13, 5755, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (235, 'UB2202111838338057', 191, 7, 186, 4204.00, 5960.66, 0.00, 1644575913, 1644579513, 1, 1, 1644575921, 26.91, 3.23, 1, 13, 6538, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (236, 'UB2202111838474737', 191, 7, 186, 4003.00, 5987.57, 0.00, 1644575927, 1644579527, 1, 1, 1644575935, 25.62, 3.07, 1, 13, 4815, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (237, 'UB2202111839034494', 191, 7, 186, 2859.00, 6013.19, 0.00, 1644575943, 1644579543, 1, 1, 1644575950, 18.30, 2.20, 1, 13, 5717, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (238, 'UB2202111839173111', 191, 7, 186, 4208.00, 6031.49, 0.00, 1644575957, 1644579557, 1, 1, 1644575965, 26.93, 3.23, 1, 13, 3057, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (239, 'UB2202111839333076', 191, 7, 186, 2449.00, 6058.42, 0.00, 1644575973, 1644579573, 1, 1, 1644575980, 15.67, 1.88, 1, 13, 5946, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (240, 'UB2202121144118318', 186, 4, 181, 440.00, 1001.11, 0.00, 1644637451, 1644641051, 1, 1, 1644637459, 2.55, 0.36, 1, 8, 2364, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (241, 'UB2202121144317082', 186, 4, 181, 632.00, 1003.66, 0.00, 1644637471, 1644641071, 1, 1, 1644637483, 3.67, 0.51, 1, 8, 2643, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (242, 'UB2202121145115465', 186, 4, 181, 443.00, 1007.33, 0.00, 1644637511, 1644641111, 1, 1, 1644637531, 2.57, 0.36, 1, 8, 1705, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (243, 'UB2202121145489080', 186, 4, 181, 507.00, 1009.90, 0.00, 1644637548, 1644641148, 1, 1, 1644637565, 2.94, 0.41, 1, 8, 2555, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (244, 'UB2202121146171553', 186, 4, 181, 788.00, 1012.84, 0.00, 1644637577, 1644641177, 1, 1, 1644637589, 4.57, 0.64, 1, 8, 2032, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (245, 'UB2202121146464488', 186, 4, 181, 635.00, 1017.41, 0.00, 1644637606, 1644641206, 1, 1, 1644637619, 3.68, 0.52, 1, 8, 490, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (246, 'UB2202121147106403', 186, 4, 181, 754.00, 1021.09, 0.00, 1644637630, 1644641230, 1, 1, 1644637639, 4.37, 0.61, 1, 8, 6566, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (247, 'UB2202121147272010', 186, 4, 181, 604.00, 1025.46, 0.00, 1644637647, 1644641247, 1, 1, 1644637656, 3.50, 0.49, 1, 8, 4927, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (248, 'UB2202121147453414', 186, 4, 181, 356.00, 1028.96, 0.00, 1644637665, 1644641265, 1, 1, 1644637675, 2.06, 0.29, 1, 8, 7442, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (249, 'UB2202121148058242', 186, 4, 181, 492.00, 1031.02, 0.00, 1644637685, 1644641285, 1, 1, 1644637696, 2.85, 0.40, 1, 8, 2121, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (250, 'UB2202121148351652', 186, 4, 181, 748.00, 1033.87, 0.00, 1644637715, 1644641315, 1, 1, 1644637724, 4.34, 0.61, 1, 8, 4159, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (251, 'UB2202121148543130', 186, 4, 181, 402.00, 1038.21, 0.00, 1644637734, 1644641334, 1, 1, 1644637741, 2.33, 0.33, 1, 8, 786, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (252, 'UB2202121429489996', 196, 0, 0, 55.00, 100.00, 0.00, 1644647388, 1644650988, 1, 1, 1644647398, 8.25, 0.00, 1, 16, 756, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (253, 'UB2202121430051690', 196, 0, 0, 61.00, 108.25, 0.00, 1644647405, 1644651005, 1, 1, 1644647412, 9.15, 0.00, 1, 16, 7735, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (254, 'UB2202121430236661', 196, 0, 0, 48.00, 117.40, 0.00, 1644647423, 1644651023, 1, 1, 1644647432, 7.20, 0.00, 1, 16, 4418, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (255, 'UB2202121454473020', 186, 4, 181, 341.00, 1040.54, 0.00, 1644648887, 1644652487, 1, 1, 1644648897, 1.98, 0.28, 1, 8, 4246, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (256, 'UB2202121455297487', 186, 4, 181, 389.00, 1042.52, 0.00, 1644648929, 1644652529, 1, 1, 1644648939, 2.26, 0.32, 1, 8, 6401, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (257, 'UB2202121456196130', 186, 4, 181, 567.00, 1044.78, 0.00, 1644648979, 1644652579, 1, 1, 1644648988, 3.29, 0.46, 1, 8, 6173, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (258, 'UB2202121456361311', 186, 4, 181, 324.00, 1048.07, 0.00, 1644648996, 1644652596, 1, 1, 1644649005, 1.88, 0.26, 1, 8, 781, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (259, 'UB2202121456525378', 186, 4, 181, 317.00, 1049.95, 0.00, 1644649012, 1644652612, 1, 1, 1644649024, 1.84, 0.26, 1, 8, 4059, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (260, 'UB2202121457116748', 186, 4, 181, 404.00, 1051.79, 0.00, 1644649031, 1644652631, 1, 1, 1644649043, 2.34, 0.33, 1, 8, 7625, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (261, 'UB2202121457358303', 186, 4, 181, 768.00, 1054.13, 0.00, 1644649055, 1644652655, 1, 1, 1644649062, 4.45, 0.62, 1, 8, 4600, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (262, 'UB2202121457502581', 186, 4, 181, 465.00, 1058.58, 0.00, 1644649070, 1644652670, 1, 1, 1644649083, 2.70, 0.38, 1, 8, 3804, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (263, 'UB2202121516384837', 186, 4, 181, 192.00, 261.00, 0.00, 1644650198, 1644653798, 1, 1, 1644650206, 28.80, 4.03, 1, 8, 1654, 1, 18, 1, 1);
INSERT INTO `xy_convey` VALUES (264, 'UB2202121516561731', 186, 4, 181, 204.00, 289.80, 0.00, 1644650216, 1644653816, 1, 1, 1644650223, 30.60, 4.28, 1, 8, 911, 1, 18, 2, 1);
INSERT INTO `xy_convey` VALUES (265, 'UB2202121517113865', 186, 4, 181, 223.00, 320.40, 0.00, 1644650231, 1644653831, 1, 1, 1644650238, 33.45, 4.68, 1, 8, 384, 1, 18, 3, 1);
INSERT INTO `xy_convey` VALUES (266, 'UB2202121517259068', 186, 4, 181, 142.00, 353.85, 0.00, 1644650245, 1644653845, 1, 1, 1644650273, 21.30, 2.98, 1, 8, 1457, 1, 18, 4, 1);
INSERT INTO `xy_convey` VALUES (267, 'UB2202121518117276', 186, 4, 181, 235.00, 375.15, 0.00, 1644650291, 1644653891, 1, 1, 1644650299, 35.25, 4.94, 1, 8, 3644, 1, 18, 5, 1);
INSERT INTO `xy_convey` VALUES (268, 'UB2202121648033501', 186, 7, 181, 1301.00, 3410.00, 0.00, 1644655683, 1644659283, 1, 1, 1644655691, 3356.58, 469.92, 1, 8, 6065, 1, 16, 1, 1);
INSERT INTO `xy_convey` VALUES (269, 'UB2202121648214813', 186, 7, 181, 12179.00, 6766.58, 0.00, 1644655701, 1644659301, 0, 0, 0, 3653.70, 0.00, 0, 8, 2364, 1, 16, 2, 1);
INSERT INTO `xy_convey` VALUES (270, 'UB2202161552555675', 171, 1, 0, 42665.00, 129649.60, 0.00, 1644997975, 1645001575, 1, 1, 1644998004, 221.86, 0.00, 1, 1, 4589, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (271, 'UB2202161553336769', 171, 1, 0, 70074.00, 129871.46, 0.00, 1644998013, 1645001613, 1, 1, 1644998252, 364.38, 0.00, 1, 1, 2606, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (272, 'UB2202161557448574', 171, 1, 0, 50480.00, 130235.38, 0.00, 1644998264, 1645001864, 1, 1, 1644998273, 5552.80, 0.00, 1, 1, 5793, 1, 19, 1, 0);
INSERT INTO `xy_convey` VALUES (274, 'UB2202161558005458', 171, 1, 0, 176524.00, 135788.18, 0.00, 1644998280, 1645001880, 1, 1, 1644998608, 22948.12, 0.00, 1, 1, 7774, 1, 19, 2, 0);
INSERT INTO `xy_convey` VALUES (276, 'UB2202161558006312', 171, 1, 0, 203682.00, 135788.18, 0.00, 1644998280, 1645001880, 1, 1, 1644998608, 26478.66, 0.00, 1, 1, 8001, 1, 19, 2, 0);
INSERT INTO `xy_convey` VALUES (275, 'UB2202161558007005', 171, 1, 0, 257997.00, 135788.18, 0.00, 1644998280, 1645001880, 1, 1, 1644998608, 33539.61, 0.00, 1, 1, 3500, 1, 19, 2, 0);
INSERT INTO `xy_convey` VALUES (273, 'UB2202161558009856', 171, 1, 0, 135788.00, 135788.18, 0.00, 1644998280, 1645001880, 1, 1, 1644998302, 17652.44, 0.00, 1, 1, 2687, 1, 19, 2, 0);
INSERT INTO `xy_convey` VALUES (277, 'UB2202161603419990', 171, 14, 0, 1807265.00, 936406.83, 0.00, 1644998621, 1645002221, 1, 1, 1644998750, 180726.50, 0.00, 1, 1, 4367, 1, 19, 3, 0);
INSERT INTO `xy_convey` VALUES (278, 'UB2202161606097719', 171, 14, 0, 1257442.00, 3117133.33, 0.00, 1644998769, 1645002369, 1, 1, 1644998776, 138318.62, 0.00, 1, 1, 1395, 1, 19, 1, 1);
INSERT INTO `xy_convey` VALUES (280, 'UB2202161606474126', 171, 14, 0, 4232087.00, 3255451.95, 0.00, 1644998807, 1645002407, 1, 1, 1647692299, 550171.31, 0.00, 1, 1, 2486, 1, 19, 2, 1);
INSERT INTO `xy_convey` VALUES (279, 'UB2202161606477013', 171, 14, 0, 3255451.00, 3255451.95, 0.00, 1644998807, 1645002407, 1, 1, 1645622552, 423208.63, 0.00, 1, 1, 3804, 1, 19, 2, 1);
INSERT INTO `xy_convey` VALUES (282, 'UB2202161606477659', 171, 14, 0, 4883177.00, 3255451.95, 0.00, 1644998807, 1645002407, 1, 1, 1647692299, 634813.01, 0.00, 1, 1, 1304, 1, 19, 2, 1);
INSERT INTO `xy_convey` VALUES (281, 'UB2202161606479365', 171, 14, 0, 6185358.00, 3255451.95, 0.00, 1644998807, 1645002407, 1, 0, 0, 804096.54, 0.00, 1, 1, 2997, 1, 19, 2, 1);
INSERT INTO `xy_convey` VALUES (283, 'UB2202260240057387', 199, 7, 0, 100036.00, 100036.00, 0.00, 1645814405, 1645818005, 1, 1, 1645814413, 15005.40, 0.00, 1, 17, 2482, 1, 18, 1, 0);
INSERT INTO `xy_convey` VALUES (284, 'UB2202260240245278', 199, 7, 0, 54531.00, 115041.40, 0.00, 1645814424, 1645818024, 1, 1, 1645814431, 8179.65, 0.00, 1, 17, 2789, 1, 18, 2, 0);
INSERT INTO `xy_convey` VALUES (285, 'UB2202260240399683', 199, 7, 0, 57683.00, 123221.05, 0.00, 1645814439, 1645818039, 1, 1, 1645814447, 8652.45, 0.00, 1, 17, 3006, 1, 18, 3, 0);
INSERT INTO `xy_convey` VALUES (286, 'UB2202260240556230', 199, 7, 0, 72888.00, 131873.50, 0.00, 1645814455, 1645818055, 1, 1, 1645814462, 10933.20, 0.00, 1, 17, 4827, 1, 18, 4, 0);
INSERT INTO `xy_convey` VALUES (287, 'UB2202260241157768', 199, 7, 0, 101802.00, 142806.70, 0.00, 1645814475, 1645818075, 1, 1, 1645814483, 15270.30, 0.00, 1, 17, 5363, 1, 18, 5, 0);
INSERT INTO `xy_convey` VALUES (288, 'UB2202260241324521', 199, 7, 0, 73416.00, 158077.00, 0.00, 1645814492, 1645818092, 1, 1, 1645814505, 11012.40, 0.00, 1, 17, 3124, 1, 18, 6, 0);
INSERT INTO `xy_convey` VALUES (289, 'UB2202260242245970', 199, 7, 0, 59190.00, 169089.00, 0.00, 1645814544, 1645818144, 1, 1, 1645814554, 152710.20, 0.00, 1, 17, 506, 1, 16, 1, 1);
INSERT INTO `xy_convey` VALUES (290, 'UB2202260242422653', 199, 7, 0, 579238.00, 321799.20, 0.00, 1645814562, 1645818162, 1, 1, 1645814793, 173771.40, 0.00, 1, 17, 5128, 1, 16, 2, 1);
INSERT INTO `xy_convey` VALUES (291, 'UB2202260246442184', 199, 7, 0, 1432027.00, 795570.60, 0.00, 1645814804, 1645818404, 1, 1, 1645817355, 214804.05, 0.00, 1, 17, 2572, 1, 16, 3, 1);
INSERT INTO `xy_convey` VALUES (292, 'UB2202260329247733', 199, 7, 0, 1154963.00, 1710374.05, 0.00, 1645817364, 1645820964, 1, 1, 1645817372, 127045.93, 0.00, 1, 17, 6193, 1, 19, 1, 0);
INSERT INTO `xy_convey` VALUES (295, 'UB2202260329401808', 199, 7, 0, 3491097.00, 1837419.98, 0.00, 1645817380, 1645820980, 1, 1, 1645817475, 453842.61, 0.00, 1, 17, 4448, 1, 19, 2, 0);
INSERT INTO `xy_convey` VALUES (296, 'UB2202260329403771', 199, 7, 0, 2756129.00, 1837419.98, 0.00, 1645817380, 1645820980, 1, 1, 1645817486, 358296.77, 0.00, 1, 17, 3855, 1, 19, 2, 0);
INSERT INTO `xy_convey` VALUES (294, 'UB2202260329406248', 199, 7, 0, 2388645.00, 1837419.98, 0.00, 1645817380, 1645820980, 1, 1, 1645817464, 310523.85, 0.00, 1, 17, 2102, 1, 19, 2, 0);
INSERT INTO `xy_convey` VALUES (293, 'UB2202260329408516', 199, 7, 0, 1837419.00, 1837419.98, 0.00, 1645817380, 1645820980, 1, 1, 1645817455, 238864.47, 0.00, 1, 17, 6226, 1, 19, 2, 0);
INSERT INTO `xy_convey` VALUES (297, 'UB2202260331555081', 199, 7, 0, 25473969.00, 13198947.68, 0.00, 1645817514, 1645821114, 1, 1, 1645817552, 2547396.90, 0.00, 1, 17, 4900, 1, 19, 3, 0);
INSERT INTO `xy_convey` VALUES (298, 'UB2202260340227812', 199, 7, 0, 18812360.00, 30746344.00, 0.00, 1645818022, 1645821622, 1, 1, 1645818030, 564370.80, 0.00, 1, 17, 3461, 1, 21, 1, 0);
INSERT INTO `xy_convey` VALUES (299, 'UB2202260340453409', 199, 7, 0, 16277594.00, 31310714.80, 0.00, 1645818045, 1645821645, 1, 1, 1645818052, 488327.82, 0.00, 1, 17, 3284, 1, 21, 2, 0);
INSERT INTO `xy_convey` VALUES (300, 'UB2202260340591091', 199, 7, 0, 22793397.00, 31799042.62, 0.00, 1645818059, 1645821659, 1, 1, 1645818066, 683801.91, 0.00, 1, 17, 6521, 1, 21, 3, 0);
INSERT INTO `xy_convey` VALUES (301, 'UB2202260341144545', 199, 7, 0, 48724266.00, 32482844.53, 0.00, 1645818074, 1645821674, 1, 1, 1645818122, 2436213.30, 0.00, 1, 17, 1060, 1, 21, 4, 0);
INSERT INTO `xy_convey` VALUES (302, 'UB2202260343277805', 199, 7, 0, 93454304.00, 51919057.83, 0.00, 1645818207, 1645821807, 1, 1, 1645818235, 4672715.20, 0.00, 1, 17, 4769, 1, 21, 5, 0);
INSERT INTO `xy_convey` VALUES (303, 'UB2202260531414437', 199, 7, 0, 421.00, 973.00, 0.00, 1645824701, 1645828301, 1, 1, 1645824709, 42.10, 0.00, 1, 17, 383, 1, 22, 1, 0);
INSERT INTO `xy_convey` VALUES (304, 'UB2202260531572824', 199, 7, 0, 1522.00, 1015.10, 0.00, 1645824717, 1645828317, 1, 1, 1645824790, 228.30, 0.00, 1, 17, 1009, 1, 22, 2, 0);
INSERT INTO `xy_convey` VALUES (305, 'UB2202260531573360', 199, 7, 0, 812.00, 1015.10, 0.00, 1645824717, 1645828317, 1, 1, 1645824790, 121.80, 0.00, 1, 17, 26, 1, 22, 2, 0);
INSERT INTO `xy_convey` VALUES (306, 'UB2202260531574303', 199, 7, 0, 2030.00, 1015.10, 0.00, 1645824717, 1645828317, 1, 1, 1645824790, 304.50, 0.00, 1, 17, 5673, 1, 22, 2, 0);
INSERT INTO `xy_convey` VALUES (307, 'UB2202260536161853', 199, 0, 0, 3428.00, 5169.00, 0.00, 1645824976, 1645828576, 1, 1, 1645824983, 514.20, 0.00, 1, 17, 6643, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (308, 'UB2202260536313878', 199, 0, 0, 4902.00, 5683.20, 0.00, 1645824991, 1645828591, 1, 1, 1645824998, 735.30, 0.00, 1, 17, 2171, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (309, 'UB2202260536468241', 199, 0, 0, 5945.00, 6418.50, 0.00, 1645825006, 1645828606, 1, 1, 1645825013, 891.75, 0.00, 1, 17, 5386, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (310, 'UB2202260548153739', 199, 2, 0, 2649.00, 7310.25, 0.00, 1645825695, 1645829295, 1, 1, 1645825702, 317.88, 0.00, 1, 17, 4039, 1, 14, 1, 0);
INSERT INTO `xy_convey` VALUES (311, 'UB2202260548291062', 199, 2, 0, 7221.00, 7628.13, 0.00, 1645825709, 1645829309, 1, 1, 1645825716, 866.52, 0.00, 1, 17, 6922, 1, 14, 2, 0);
INSERT INTO `xy_convey` VALUES (312, 'UB2202260548438653', 199, 2, 0, 12741.00, 8494.65, 0.00, 1645825723, 1645829323, 1, 1, 1645825750, 1528.92, 0.00, 1, 17, 2960, 1, 14, 3, 0);
INSERT INTO `xy_convey` VALUES (313, 'UB2202260549182606', 199, 2, 0, 9697.00, 15023.57, 0.00, 1645825758, 1645829358, 1, 1, 1645825765, 1163.64, 0.00, 1, 17, 7218, 1, 14, 4, 0);
INSERT INTO `xy_convey` VALUES (314, 'UB2202260549328402', 199, 2, 0, 5998.00, 16187.21, 0.00, 1645825772, 1645829372, 1, 1, 1645825779, 719.76, 0.00, 1, 17, 2467, 1, 14, 5, 0);
INSERT INTO `xy_convey` VALUES (315, 'UB2203122202019102', 201, 0, 0, 672.00, 1036.00, 0.00, 1647093721, 1647097321, 1, 1, 1647093730, 100.80, 0.00, 1, 19, 2532, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (316, 'UB2203171640046846', 172, 1, 171, 334.00, 500.00, 0.00, 1647506404, 1647510004, 1, 1, 1647506413, 167.00, 23.38, 1, 20, 3422, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (317, 'UB2203171640265827', 172, 1, 171, 561.00, 667.00, 0.00, 1647506426, 1647510026, 1, 1, 1647506435, 280.50, 39.27, 1, 20, 7884, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (318, 'UB2203171640444727', 172, 1, 171, 493.00, 947.50, 0.00, 1647506444, 1647510044, 1, 1, 1647506454, 246.50, 34.51, 1, 20, 1538, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (319, 'UB2203171650295580', 172, 2, 171, 443.00, 500.00, 0.00, 1647507029, 1647510629, 1, 1, 1647507040, 110.75, 15.51, 1, 20, 449, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (320, 'UB2203171650513080', 172, 2, 171, 219.00, 610.75, 0.00, 1647507051, 1647510651, 1, 1, 1647507058, 54.75, 7.67, 1, 20, 5246, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (321, 'UB2203171651082934', 172, 2, 171, 207.00, 665.50, 0.00, 1647507068, 1647510668, 1, 1, 1647507075, 51.75, 7.25, 1, 20, 3966, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (322, 'UB2203192013196870', 200, 0, 199, 641.00, 1000.00, 0.00, 1647691999, 1647695599, 1, 1, 1647692029, 96.15, 10.58, 1, 18, 828, 1, 0, 0, 1);
INSERT INTO `xy_convey` VALUES (323, 'UB2203192018577203', 171, 5, 0, 6908684.00, 21853251.49, 0.00, 1647692337, 1647695937, 1, 1, 1647692345, 276347.36, 0.00, 1, 1, 5480, 1, 26, 1, 0);
INSERT INTO `xy_convey` VALUES (324, 'UB2203192019129701', 171, 5, 0, 15876618.00, 22129598.85, 0.00, 1647692352, 1647695952, 1, 1, 1647692363, 635064.72, 0.00, 1, 1, 4899, 1, 26, 2, 0);
INSERT INTO `xy_convey` VALUES (325, 'UB2203192019308907', 171, 5, 0, 12350184.00, 22764663.57, 0.00, 1647692370, 1647695970, 1, 1, 1647692381, 494007.36, 0.00, 1, 1, 418, 1, 26, 3, 0);
INSERT INTO `xy_convey` VALUES (326, 'UB2203192019481637', 171, 5, 0, 8466964.00, 23258670.93, 0.00, 1647692388, 1647695988, 1, 1, 1647692395, 338678.56, 0.00, 1, 1, 964, 1, 26, 4, 0);
INSERT INTO `xy_convey` VALUES (327, 'UB2203192020045952', 171, 5, 0, 15346270.00, 23597349.49, 0.00, 1647692404, 1647696004, 1, 1, 1647692411, 613850.80, 0.00, 1, 1, 1766, 1, 26, 5, 0);
INSERT INTO `xy_convey` VALUES (328, 'UB2203192021449016', 171, 5, 0, 7532.00, 11200.00, 0.00, 1647692504, 1647696104, 1, 1, 1647692513, 301.28, 0.00, 1, 1, 4133, 1, 26, 1, 0);
INSERT INTO `xy_convey` VALUES (329, 'UB2203192022011466', 171, 5, 0, 11294.00, 11501.28, 0.00, 1647692521, 1647696121, 1, 1, 1647692528, 451.76, 0.00, 1, 1, 3035, 1, 26, 2, 0);
INSERT INTO `xy_convey` VALUES (330, 'UB2203192022156072', 171, 5, 0, 9307.00, 11953.04, 0.00, 1647692535, 1647696135, 1, 1, 1647692542, 372.28, 0.00, 1, 1, 3134, 1, 26, 3, 0);
INSERT INTO `xy_convey` VALUES (331, 'UB2203192022292185', 171, 5, 0, 7297.00, 12325.32, 0.00, 1647692549, 1647696149, 1, 1, 1647692556, 291.88, 0.00, 1, 1, 3293, 1, 26, 4, 0);
INSERT INTO `xy_convey` VALUES (332, 'UB2203200101468718', 171, 5, 0, 4923.00, 12617.20, 0.00, 1647709306, 1647712906, 1, 1, 1647709314, 196.92, 0.00, 1, 1, 276, 1, 26, 5, 0);
INSERT INTO `xy_convey` VALUES (333, 'UB2203200102161972', 171, 5, 0, 10421.00, 12617.00, 0.00, 1647709335, 1647712935, 1, 1, 1647709354, 26886.18, 0.00, 1, 1, 285, 1, 16, 1, 0);
INSERT INTO `xy_convey` VALUES (334, 'UB2203200102413104', 171, 5, 0, 71105.00, 39503.18, 0.00, 1647709361, 1647712961, 1, 1, 1647709430, 21331.50, 0.00, 1, 1, 373, 1, 16, 2, 0);
INSERT INTO `xy_convey` VALUES (335, 'UB2203200104005532', 171, 5, 0, 166386.00, 92436.68, 0.00, 1647709440, 1647713040, 1, 1, 1647709496, 24957.90, 0.00, 1, 1, 5355, 1, 16, 3, 0);
INSERT INTO `xy_convey` VALUES (336, 'UB2203200105119815', 171, 5, 0, 344420.00, 191344.58, 0.00, 1647709511, 1647713111, 1, 1, 1647709546, 103326.00, 0.00, 1, 1, 3810, 1, 16, 4, 0);
INSERT INTO `xy_convey` VALUES (337, 'UB2203200105584373', 171, 5, 0, 537295.00, 447746.58, 0.00, 1647709558, 1647713158, 1, 1, 1647709590, 161188.50, 0.00, 1, 1, 272, 1, 16, 5, 0);
INSERT INTO `xy_convey` VALUES (338, 'UB2203200106388092', 171, 5, 0, 1746210.00, 698484.08, 0.00, 1647709598, 1647713198, 1, 1, 1647709632, 523863.00, 0.00, 1, 1, 3182, 1, 16, 6, 0);
INSERT INTO `xy_convey` VALUES (339, 'UB2203200107202330', 171, 5, 0, 3632116.00, 2270073.08, 0.00, 1647709640, 1647713240, 1, 1, 1647709690, 1089634.80, 0.00, 1, 1, 7702, 1, 16, 7, 0);
INSERT INTO `xy_convey` VALUES (340, 'UB2203200108299984', 171, 5, 0, 10387851.00, 4721750.88, 0.00, 1647709709, 1647713309, 1, 1, 1647709746, 6232710.60, 0.00, 1, 1, 6854, 1, 16, 8, 0);
INSERT INTO `xy_convey` VALUES (341, 'UB2203200504157664', 171, 0, 0, 42.00, 100.00, 0.00, 1647723855, 1647727455, 1, 1, 1647723864, 1.68, 0.00, 1, 1, 3424, 1, 26, 1, 0);
INSERT INTO `xy_convey` VALUES (342, 'UB2203200504318458', 171, 0, 0, 67.00, 101.68, 0.00, 1647723871, 1647727471, 1, 1, 1647723879, 2.68, 0.00, 1, 1, 6610, 1, 26, 2, 0);
INSERT INTO `xy_convey` VALUES (343, 'UB2203200504464493', 171, 0, 0, 43.00, 104.36, 0.00, 1647723886, 1647727486, 1, 1, 1647723895, 1.72, 0.00, 1, 1, 4017, 1, 26, 3, 0);
INSERT INTO `xy_convey` VALUES (344, 'UB2203200505052120', 171, 0, 0, 36.00, 106.08, 0.00, 1647723905, 1647727505, 1, 1, 1647723913, 1.44, 0.00, 1, 1, 1102, 1, 26, 4, 0);
INSERT INTO `xy_convey` VALUES (345, 'UB2203200505205225', 171, 0, 0, 103.00, 107.52, 0.00, 1647723920, 1647727520, 1, 1, 1647723946, 4.12, 0.00, 1, 1, 6912, 1, 26, 5, 0);
INSERT INTO `xy_convey` VALUES (346, 'UB2203200507343319', 171, 1, 0, 98.00, 111.00, 0.00, 1647724054, 1647727654, 1, 1, 1647724063, 19.60, 0.00, 1, 1, 3049, 1, 27, 1, 0);
INSERT INTO `xy_convey` VALUES (347, 'UB2203200507519843', 171, 1, 0, 76.00, 130.60, 0.00, 1647724071, 1647727671, 1, 1, 1647724079, 15.20, 0.00, 1, 1, 5198, 1, 27, 1, 0);
INSERT INTO `xy_convey` VALUES (348, 'UB2203200508078535', 171, 1, 0, 45.00, 145.80, 0.00, 1647724087, 1647727687, 1, 1, 1647724095, 9.00, 0.00, 1, 1, 8044, 1, 27, 1, 0);
INSERT INTO `xy_convey` VALUES (349, 'UB2203200508322067', 171, 1, 0, 89.00, 145.00, 0.00, 1647724112, 1647727712, 1, 1, 1647724119, 17.80, 0.00, 1, 1, 7230, 1, 27, 1, 0);
INSERT INTO `xy_convey` VALUES (350, 'UB2203200508489690', 171, 1, 0, 74.00, 162.80, 0.00, 1647724128, 1647727728, 1, 1, 1647724136, 14.80, 0.00, 1, 1, 2168, 1, 27, 1, 0);
INSERT INTO `xy_convey` VALUES (351, 'UB2203200510344200', 171, 1, 0, 108.00, 177.00, 0.00, 1647724234, 1647727834, 1, 1, 1647724242, 21.60, 0.00, 1, 1, 798, 1, 27, 1, 0);
INSERT INTO `xy_convey` VALUES (352, 'UB2203200511045286', 171, 1, 0, 68.00, 198.60, 0.00, 1647724264, 1647727864, 1, 1, 1647724358, 13.60, 0.00, 1, 1, 3779, 1, 27, 1, 1);
INSERT INTO `xy_convey` VALUES (353, 'UB2203200512511848', 171, 1, 0, 104.00, 211.60, 0.00, 1647724371, 1647727971, 1, 1, 1647724380, 4.16, 0.00, 1, 1, 3862, 1, 26, 1, 0);
INSERT INTO `xy_convey` VALUES (354, 'UB2203200513074051', 171, 1, 0, 323.00, 215.76, 0.00, 1647724387, 1647727987, 1, 1, 1647724423, 12.92, 0.00, 1, 1, 3907, 1, 26, 2, 0);
INSERT INTO `xy_convey` VALUES (355, 'UB2203200513566414', 171, 1, 0, 857.00, 428.68, 0.00, 1647724436, 1647728036, 1, 1, 1647724473, 34.28, 0.00, 1, 1, 805, 1, 26, 3, 0);
INSERT INTO `xy_convey` VALUES (356, 'UB2203200514425064', 171, 1, 0, 856.00, 962.96, 0.00, 1647724482, 1647728082, 1, 1, 1647724490, 34.24, 0.00, 1, 1, 1212, 1, 26, 4, 0);
INSERT INTO `xy_convey` VALUES (357, 'UB2203200515087139', 171, 1, 0, 933.00, 997.20, 0.00, 1647724508, 1647728108, 1, 1, 1647724516, 37.32, 0.00, 1, 1, 1752, 1, 26, 5, 0);
INSERT INTO `xy_convey` VALUES (358, 'UB2203210218497476', 171, 1, 0, 593.00, 1034.00, 0.00, 1647800329, 1647803929, 1, 1, 1647800368, 23.72, 0.00, 1, 1, 4718, 1, 26, 1, 1);
INSERT INTO `xy_convey` VALUES (359, 'UB2203231645145276', 171, 1, 0, 1586.00, 1057.72, 0.00, 1648025114, 1648028714, 0, 0, 0, 63.44, 0.00, 0, 1, 6094, 1, 26, 2, 1);

-- ----------------------------
-- Table structure for xy_cs
-- ----------------------------
DROP TABLE IF EXISTS `xy_cs`;
CREATE TABLE `xy_cs`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tel` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '手机号',
  `username` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '用户名',
  `pwd` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '密码',
  `salt` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '盐',
  `qq` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'QQ号',
  `wechat` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '微信号',
  `qr_code` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '微信二维码',
  `btime` char(5) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '0' COMMENT '上班时间',
  `etime` char(5) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '下班时间',
  `status` int(11) NOT NULL DEFAULT 1 COMMENT '账号状态 1启用 2禁用',
  `addtime` int(11) NOT NULL COMMENT '添加时间',
  `url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 5 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '客服-用户表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of xy_cs
-- ----------------------------
INSERT INTO `xy_cs` VALUES (1, '13112343213', 'service one', '12346578', '', '0', '', 'http://www.kkugea.cn/upload/8d8974e94ea71793/ef08b1ba42a6f787.jpg', '09:00', '22:00', 2, 1571970644, '#');
INSERT INTO `xy_cs` VALUES (2, '13142134213', 'service two', '12345678', '', '0', '', 'http://www.kkugea.cn/upload/8d8974e94ea71793/ef08b1ba42a6f787.jpg', '09:00', '22:00', 2, 1571971118, '#');
INSERT INTO `xy_cs` VALUES (3, '', 'LINE', 'c123456789.', '', '0', '', '', '10:00', '22:00', 2, 1575521614, '123123');
INSERT INTO `xy_cs` VALUES (4, '', 'LINE', 'queen123456', '', '0', '', '', '09:00', '22:00', 1, 1575595897, 'https:');

-- ----------------------------
-- Table structure for xy_deal_elog
-- ----------------------------
DROP TABLE IF EXISTS `xy_deal_elog`;
CREATE TABLE `xy_deal_elog`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `oid` char(18) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '相关订单',
  `uid` int(10) UNSIGNED NOT NULL COMMENT '用户id',
  `errmsg` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '错误信息',
  `addtime` int(10) UNSIGNED NOT NULL COMMENT '添加时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `oid`(`oid`) USING BTREE,
  INDEX `uid`(`uid`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '交易错误日志表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for xy_deposit
-- ----------------------------
DROP TABLE IF EXISTS `xy_deposit`;
CREATE TABLE `xy_deposit`  (
  `id` char(18) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `uid` int(11) NOT NULL COMMENT '提现用户',
  `bk_id` int(11) NOT NULL COMMENT '银行卡信息',
  `num` decimal(15, 2) NOT NULL COMMENT '提现金额',
  `num2` decimal(15, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '提现金额2 usdt',
  `addtime` int(11) NOT NULL COMMENT '提交时间',
  `endtime` int(11) NOT NULL DEFAULT 0 COMMENT '审核时间',
  `status` int(11) NOT NULL DEFAULT 1 COMMENT '订单状态 1待处理 2审核通过 3审核不通过',
  `agent_status` tinyint(3) UNSIGNED NOT NULL DEFAULT 1 COMMENT '代理审核 1待处理，2通过，3拒绝',
  `type` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `real_num` decimal(15, 2) NULL DEFAULT NULL,
  `shouxu` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `usdt` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `payout_id` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '三方付款订单号',
  `payout_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `payout_status` tinyint(3) UNSIGNED NOT NULL DEFAULT 0 COMMENT '三方付款状态 0未提交，1已提交，2成功，3失败',
  `payout_time` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '三方支付回掉时间',
  `payout_err_msg` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '三方付款错误内容',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `payout_id`(`payout_id`) USING BTREE,
  INDEX `uid`(`uid`) USING BTREE,
  INDEX `addtime`(`addtime`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '会员-余额提现表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of xy_deposit
-- ----------------------------
INSERT INTO `xy_deposit` VALUES ('CO2201180044176200', 171, 14, 300.00, 3.90, 1642437857, 1644324739, 3, 1, 'USDT', 300.00, '0', '3332232312fwer', NULL, NULL, 0, 0, '1');
INSERT INTO `xy_deposit` VALUES ('CO2202091433372065', 184, 16, 455.00, 0.00, 1644388417, 1644388463, 2, 1, 'bank', 455.00, '0', '', NULL, NULL, 0, 0, NULL);
INSERT INTO `xy_deposit` VALUES ('CO2202091434309439', 183, 17, 450.00, 0.00, 1644388470, 1644388512, 2, 1, 'bank', 450.00, '0', '', NULL, NULL, 0, 0, NULL);
INSERT INTO `xy_deposit` VALUES ('CO2202091453573279', 182, 18, 450.00, 0.00, 1644389637, 1644389677, 2, 1, 'bank', 450.00, '0', '', NULL, NULL, 0, 0, NULL);
INSERT INTO `xy_deposit` VALUES ('CO2202091508531418', 186, 19, 245.00, 0.00, 1644390533, 1644390600, 3, 1, 'bank', 245.00, '0', '', NULL, NULL, 0, 0, '');
INSERT INTO `xy_deposit` VALUES ('CO2202091510599662', 186, 19, 292.00, 0.00, 1644390659, 1644390690, 3, 1, 'bank', 292.00, '0', '', NULL, NULL, 0, 0, '');
INSERT INTO `xy_deposit` VALUES ('CO2202091523386825', 181, 15, 1000.00, 0.00, 1644391418, 1644391436, 3, 1, 'bank', 1000.00, '0', '', NULL, NULL, 0, 0, '');
INSERT INTO `xy_deposit` VALUES ('CO2202101515443084', 187, 20, 102.00, 0.00, 1644477344, 1644502310, 3, 1, 'wallet', 102.00, '0', '', NULL, NULL, 0, 0, '');
INSERT INTO `xy_deposit` VALUES ('CO2202111101246782', 184, 16, 464.00, 0.00, 1644548484, 1644548543, 3, 1, 'bank', 464.00, '0', '', NULL, NULL, 0, 0, '');
INSERT INTO `xy_deposit` VALUES ('CO2202111104262474', 184, 16, 464.00, 0.00, 1644548666, 1644548730, 2, 1, 'bank', 464.00, '0', '', NULL, NULL, 0, 0, NULL);
INSERT INTO `xy_deposit` VALUES ('CO2202111109353953', 186, 19, 499.00, 0.00, 1644548975, 1644549013, 2, 1, 'bank', 499.00, '0', '', NULL, NULL, 0, 0, NULL);
INSERT INTO `xy_deposit` VALUES ('CO2202111149348481', 182, 18, 956.00, 0.00, 1644551374, 1644551456, 2, 1, 'bank', 956.00, '0', '', NULL, NULL, 0, 0, NULL);
INSERT INTO `xy_deposit` VALUES ('CO2202111259084872', 186, 19, 1000.00, 0.00, 1644555548, 0, 1, 1, 'bank', 1000.00, '0', '', NULL, NULL, 0, 0, NULL);
INSERT INTO `xy_deposit` VALUES ('CO2202111507569911', 190, 21, 150.00, 0.00, 1644563276, 1644563389, 2, 1, 'bank', 150.00, '0', '', NULL, NULL, 0, 0, NULL);
INSERT INTO `xy_deposit` VALUES ('CO2202111524245653', 190, 21, 950.00, 0.00, 1644564264, 1644564383, 2, 1, 'bank', 950.00, '0', '', NULL, NULL, 0, 0, NULL);
INSERT INTO `xy_deposit` VALUES ('CO2202111541492480', 188, 22, 490.00, 0.00, 1644565309, 0, 1, 1, 'bank', 490.00, '0', '', NULL, NULL, 0, 0, NULL);
INSERT INTO `xy_deposit` VALUES ('CO2202111547009121', 187, 20, 500.00, 0.00, 1644565620, 1644565669, 3, 1, 'wallet', 500.00, '0', '', NULL, NULL, 0, 0, '');
INSERT INTO `xy_deposit` VALUES ('CO2202111701261436', 192, 23, 100.00, 0.00, 1644570086, 1644570113, 3, 1, 'wallet', 100.00, '0', '', NULL, NULL, 0, 0, '');
INSERT INTO `xy_deposit` VALUES ('CO2202111702445261', 192, 23, 100.00, 0.00, 1644570164, 1644570190, 3, 1, 'bank', 100.00, '0', '', NULL, NULL, 0, 0, '');
INSERT INTO `xy_deposit` VALUES ('CO2202111704007041', 192, 23, 100.00, 1.30, 1644570240, 0, 1, 1, 'USDT', 100.00, '0', 'fbdfhjgfnhgmghmgh', NULL, NULL, 0, 0, NULL);
INSERT INTO `xy_deposit` VALUES ('CO2202111751088896', 191, 24, 100.00, 0.00, 1644573068, 0, 1, 1, 'bank', 100.00, '0', '', NULL, NULL, 0, 0, NULL);
INSERT INTO `xy_deposit` VALUES ('CO2202111832049201', 193, 25, 132.00, 0.00, 1644575524, 1644575671, 2, 1, 'bank', 132.00, '0', '', NULL, NULL, 0, 0, NULL);
INSERT INTO `xy_deposit` VALUES ('CO2202111842421826', 191, 24, 3000.00, 0.00, 1644576162, 0, 1, 1, 'bank', 3000.00, '0', '', NULL, NULL, 0, 0, NULL);
INSERT INTO `xy_deposit` VALUES ('CO2202111844458699', 191, 24, 2000.00, 0.00, 1644576285, 1645452112, 3, 1, 'bank', 2000.00, '0', '', NULL, NULL, 0, 0, '5555');
INSERT INTO `xy_deposit` VALUES ('CO2202121441479089', 196, 26, 124.00, 0.00, 1644648107, 1644648202, 2, 1, 'bank', 124.00, '0', '', NULL, NULL, 0, 0, NULL);
INSERT INTO `xy_deposit` VALUES ('CO2202121459576236', 186, 19, 500.00, 0.00, 1644649197, 1644649451, 2, 1, 'bank', 500.00, '0', '', NULL, NULL, 0, 0, NULL);
INSERT INTO `xy_deposit` VALUES ('CO2202121511206963', 186, 19, 300.00, 0.00, 1644649880, 1644649931, 2, 1, 'bank', 300.00, '0', '', NULL, NULL, 0, 0, NULL);
INSERT INTO `xy_deposit` VALUES ('CO2202260345298703', 199, 27, 800.00, 0.00, 1645818329, 1645818341, 2, 1, 'wallet', 800.00, '0', '', NULL, NULL, 0, 0, NULL);

-- ----------------------------
-- Table structure for xy_goods_cate
-- ----------------------------
DROP TABLE IF EXISTS `xy_goods_cate`;
CREATE TABLE `xy_goods_cate`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '商店名称',
  `bili` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '商品名称',
  `cate_info` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '商品描述',
  `goods_price` decimal(10, 2) NULL DEFAULT NULL COMMENT '商品价格',
  `cate_pic` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '商品展示图片',
  `addtime` int(11) NOT NULL COMMENT '添加时间',
  `status` int(11) NULL DEFAULT 0 COMMENT '上架状态 0不上架 1上架',
  `min` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '最小金额限制',
  `level_id` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 5 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '商品表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of xy_goods_cate
-- ----------------------------
INSERT INTO `xy_goods_cate` VALUES (1, 'Pinduoduo', '0.002', 'Silver', NULL, '/static_new6/img/vip_1a.b5838bd.png', 1579586171, 0, '110', 1);
INSERT INTO `xy_goods_cate` VALUES (2, 'TaoBao', '0.003', 'Gold', NULL, '/static_new6/img/vip_2a.be0ead6.png', 1578196081, 0, '110', 2);
INSERT INTO `xy_goods_cate` VALUES (3, 'Tmall', '0.004', 'Platinum', NULL, '/static_new6/img/vip_3a.90bd5b6.png', 1578196305, 0, '110', 3);
INSERT INTO `xy_goods_cate` VALUES (4, 'JD', '0.005', 'Diamonds', NULL, '/static_new6/img/vip_4a.fe406d7.png', 1578196305, 0, '110', 4);

-- ----------------------------
-- Table structure for xy_goods_list
-- ----------------------------
DROP TABLE IF EXISTS `xy_goods_list`;
CREATE TABLE `xy_goods_list`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `shop_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '商店名称',
  `goods_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '商品名称',
  `goods_info` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '商品描述',
  `goods_price` decimal(15, 2) NOT NULL COMMENT '商品价格',
  `goods_pic` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '商品展示图片',
  `addtime` int(11) NOT NULL COMMENT '添加时间',
  `status` int(11) NOT NULL DEFAULT 0 COMMENT '上架状态 0不上架 1上架',
  `cid` int(11) NULL DEFAULT 1,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `status`(`status`) USING BTREE,
  INDEX `addtime`(`addtime`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 8101 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '商品表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of xy_goods_list
-- ----------------------------
INSERT INTO `xy_goods_list` VALUES (1, 'APACER 16GB / 32GB  USB2.0 Pendrive Pen Drive /Flash Drive / Thumb Drive AH334 / AH335 16GB 32GB', 'APACER 16GB / 32GB  USB2.0 Pendrive Pen Drive /Flash Drive / Thumb Drive AH334 / AH335 16GB 32GB', '<p>APACER 16GB / 32GB USB2.0 Pendrive Pen Drive /Flash Drive / Thumb Drive AH334 / AH335 16GB 32GB</p>', 139.90, 'https://mxn-demo.hzwservice.top/upload/72886baa68cd2510/58740fb9626288f5.jpg', 1648365366, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2, 'M&g gel pen r3/r5 0.5mm/0.7mm 1pcs', 'M&g gel pen r3/r5 0.5mm/0.7mm 1pcs', 'M&g gel pen r3/r5 0.5mm/0.7mm 1pcs', 11.20, 'https://cf.shopee.com.my/file/f1b2e293f65c884da551f6aa2c417ef6', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (3, '(0.5-1.0MM) Elastic Line Transparent Crystal Beading Cord String Thread Making DIY Bracelet', '(0.5-1.0MM) Elastic Line Transparent Crystal Beading Cord String Thread Making DIY Bracelet', '(0.5-1.0MM) Elastic Line Transparent Crystal Beading Cord String Thread Making DIY Bracelet', 27.50, 'https://cf.shopee.com.my/file/9b016d4071eb64e98b3b2fcc159b19c6', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (4, 'Kerongsang 0.8CM 1pc Batu Korea Baby Brooch Rhinestone Color Mixed Randomly Ready Stock', 'Kerongsang 0.8CM 1pc Batu Korea Baby Brooch Rhinestone Color Mixed Randomly Ready Stock', 'Kerongsang 0.8CM 1pc Batu Korea Baby Brooch Rhinestone Color Mixed Randomly Ready Stock', 1.90, 'https://cf.shopee.com.my/file/238e3554ae64445f7cdceed0a07bf1f0', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (5, 'Gel Pen Stationery Ballpoint Pen Office School Supplies Red Blue Black Gel Pen Refill 0.5mm', 'Gel Pen Stationery Ballpoint Pen Office School Supplies Red Blue Black Gel Pen Refill 0.5mm', 'Gel Pen Stationery Ballpoint Pen Office School Supplies Red Blue Black Gel Pen Refill 0.5mm', 0.90, 'https://cf.shopee.com.my/file/0249009a4084273fa6c25d016f939a3c', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (6, 'SNOWPLUS New 3.0 Pods Flavors - Grape Ice/Pineapple Ice/Lychee/Ice Cola/Mix Berry/Watermelon/Mango Ice/Mint', 'SNOWPLUS New 3.0 Pods Flavors - Grape Ice/Pineapple Ice/Lychee/Ice Cola/Mix Berry/Watermelon/Mango Ice/Mint', 'SNOWPLUS New 3.0 Pods Flavors - Grape Ice/Pineapple Ice/Lychee/Ice Cola/Mix Berry/Watermelon/Mango Ice/Mint', 350.00, 'https://cf.shopee.com.my/file/abfe0f954418f5ab1d1e01ea2fb84fbb', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (8, '*HOT* *NEW* Made 14mm ( Power 0-500  )Natural Size Contact Lens/Color Lens Original Korea Lens', '*HOT* *NEW* Made 14mm ( Power 0-500  )Natural Size Contact Lens/Color Lens Original Korea Lens', '*HOT* *NEW* Made 14mm ( Power 0-500  )Natural Size Contact Lens/Color Lens Original Korea Lens', 98.00, 'https://cf.shopee.com.my/file/fda990ea1c9435f68c5ac873646b08f9', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (10, '[Office Matters] LATOR SIMPLE RETRACTABLE BALL PEN 0.5 / 0.7', '[Office Matters] LATOR SIMPLE RETRACTABLE BALL PEN 0.5 / 0.7', '[Office Matters] LATOR SIMPLE RETRACTABLE BALL PEN 0.5 / 0.7', 3.50, 'https://cf.shopee.com.my/file/cb67662bcf8171b535ed9fa8e7e0ebc2', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (11, 'i12 TWS Bluetooth wireless earphones Inpod Airpod EarPods inPod V5.0 3D Touch Macaro colorful sports earphones', 'i12 TWS Bluetooth wireless earphones Inpod Airpod EarPods inPod V5.0 3D Touch Macaro colorful sports earphones', 'i12 TWS Bluetooth wireless earphones Inpod Airpod EarPods inPod V5.0 3D Touch Macaro colorful sports earphones', 127.90, 'https://cf.shopee.com.my/file/06a173adcda6bd173a700b83bd92529b', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (13, 'Royal Canin Feline Health Nutrition - Second Age Kitten (0.4kg)', 'Royal Canin Feline Health Nutrition - Second Age Kitten (0.4kg)', 'Royal Canin Feline Health Nutrition - Second Age Kitten (0.4kg)', 180.00, 'https://cf.shopee.com.my/file/28f95bfb1183fd1cca928b2776dfeeb9', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (14, '*Hot Sales* Macaron Bluetooth Earpod InPods 12(True Wireless Stereo V5.0)-8 Colour & Matt Surface Charging Box', '*Hot Sales* Macaron Bluetooth Earpod InPods 12(True Wireless Stereo V5.0)-8 Colour & Matt Surface Charging Box', '*Hot Sales* Macaron Bluetooth Earpod InPods 12(True Wireless Stereo V5.0)-8 Colour & Matt Surface Charging Box', 140.00, 'https://cf.shopee.com.my/file/516ade897a2f73327f4a2b096afc402d', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (15, 'MUJI Gel Pen Black/Blue/Red Ink Color Pens 0.5mm 0.38mm Pens School Stationary', 'MUJI Gel Pen Black/Blue/Red Ink Color Pens 0.5mm 0.38mm Pens School Stationary', 'MUJI Gel Pen Black/Blue/Red Ink Color Pens 0.5mm 0.38mm Pens School Stationary', 14.90, 'https://cf.shopee.com.my/file/f64c8b346c3dad19b4ebeaedb42f91b7', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (16, 'LOWEST PRICE* Desire 14mm Natural Size Contact Lens/Color Lens Original Korea Lens ( Power 0-600 )', 'LOWEST PRICE* Desire 14mm Natural Size Contact Lens/Color Lens Original Korea Lens ( Power 0-600 )', 'LOWEST PRICE* Desire 14mm Natural Size Contact Lens/Color Lens Original Korea Lens ( Power 0-600 )', 59.00, 'https://cf.shopee.com.my/file/3674f387482813f8c77860b4a70d289b', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (17, '0.5mm Water-based Pen Gel Pen Black/Red/Blue Ink Pen Maker Pen  Stationery For Students', '0.5mm Water-based Pen Gel Pen Black/Red/Blue Ink Pen Maker Pen  Stationery For Students', '0.5mm Water-based Pen Gel Pen Black/Red/Blue Ink Pen Maker Pen  Stationery For Students', 7.50, 'https://cf.shopee.com.my/file/549b69e2c9ba50d84e7fcf8ebfbf2246', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (18, 'Remax RPP-108 5A 20000mAh Power Bank Super Fast Charge Support PPS,PD3.0,FCP,SCP,QC4+,QC4,QC3.0,FSCP,VOOC,AFC,PE2.0', 'Remax RPP-108 5A 20000mAh Power Bank Super Fast Charge Support PPS,PD3.0,FCP,SCP,QC4+,QC4,QC3.0,FSCP,VOOC,AFC,PE2.0', 'Remax RPP-108 5A 20000mAh Power Bank Super Fast Charge Support PPS,PD3.0,FCP,SCP,QC4+,QC4,QC3.0,FSCP,VOOC,AFC,PE2.0', 677.00, 'https://cf.shopee.com.my/file/9f2407c4649a2043935c0cebd2c867d7', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (19, 'TOPK J01 Cable Organizer Wire Winder Earphone Velcro holder Mouse Cord Protector 0.5M / 1M / 2M / 3M /5M', 'TOPK J01 Cable Organizer Wire Winder Earphone Velcro holder Mouse Cord Protector 0.5M / 1M / 2M / 3M /5M', 'TOPK J01 Cable Organizer Wire Winder Earphone Velcro holder Mouse Cord Protector 0.5M / 1M / 2M / 3M /5M', 15.60, 'https://cf.shopee.com.my/file/33e8e2ad8678ef5c99c7d23438c70f4f', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (21, 'toys 0-3Yrs children toys baby toys Kid S Baby Boys  Girls Educational Toys Early  Fun Ball Tower Turn Music', 'toys 0-3Yrs children toys baby toys Kid S Baby Boys  Girls Educational Toys Early  Fun Ball Tower Turn Music', 'toys 0-3Yrs children toys baby toys Kid S Baby Boys  Girls Educational Toys Early  Fun Ball Tower Turn Music', 124.00, 'https://cf.shopee.com.my/file/41d89d7f9a81c3d4f780e5a351290542', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (22, '[PCG] PILOT MECHANICAL PENCIL 0.5MM / 0.7MM', '[PCG] PILOT MECHANICAL PENCIL 0.5MM / 0.7MM', '[PCG] PILOT MECHANICAL PENCIL 0.5MM / 0.7MM', 39.90, 'https://cf.shopee.com.my/file/7622e69031c308a415410f10c4ae015a', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (23, 'Faber-Castell RX Gel Pen 0.5mm / 0.7mm Back to School 6pcs Set Pack Value Sets 540887 540888 540889 RXGEL', 'Faber-Castell RX Gel Pen 0.5mm / 0.7mm Back to School 6pcs Set Pack Value Sets 540887 540888 540889 RXGEL', 'Faber-Castell RX Gel Pen 0.5mm / 0.7mm Back to School 6pcs Set Pack Value Sets 540887 540888 540889 RXGEL', 83.90, 'https://cf.shopee.com.my/file/227fdd36b6018e233a5743abc73300e6', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (24, 'PILOT FRIXION CLICKER REFILL 0.5MM/ 0.7MM FINE ERASABLE ROLLER BALL GEL PEN REFILL (READY STOCK / 100% ORIGINAL)', 'PILOT FRIXION CLICKER REFILL 0.5MM/ 0.7MM FINE ERASABLE ROLLER BALL GEL PEN REFILL (READY STOCK / 100% ORIGINAL)', 'PILOT FRIXION CLICKER REFILL 0.5MM/ 0.7MM FINE ERASABLE ROLLER BALL GEL PEN REFILL (READY STOCK / 100% ORIGINAL)', 35.00, 'https://cf.shopee.com.my/file/5b68f2f304ac69bddf69571e3cee71a0', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (26, 'Dolly 16.5mm(eff 17.5mm) Big eyes Contact Lens/Color Lens/Korea Lens (P-0.00 till P-8.00) Free Case', 'Dolly 16.5mm(eff 17.5mm) Big eyes Contact Lens/Color Lens/Korea Lens (P-0.00 till P-8.00) Free Case', 'Dolly 16.5mm(eff 17.5mm) Big eyes Contact Lens/Color Lens/Korea Lens (P-0.00 till P-8.00) Free Case', 99.00, 'https://cf.shopee.com.my/file/c9f1b221afdaaa1b792be55ac644e254', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (27, '[Ready Stock]0.25-2.5mm 540 Microneedle roller Micro Needle Derma Roller Dermaroller Therapy Skin', '[Ready Stock]0.25-2.5mm 540 Microneedle roller Micro Needle Derma Roller Dermaroller Therapy Skin', '[Ready Stock]0.25-2.5mm 540 Microneedle roller Micro Needle Derma Roller Dermaroller Therapy Skin', 38.30, 'https://cf.shopee.com.my/file/17b84f84def37deae2e6ef00782ea968', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (29, 'Pilot Frixion Ball Pen 0.5mm / 0.7mm', 'Pilot Frixion Ball Pen 0.5mm / 0.7mm', 'Pilot Frixion Ball Pen 0.5mm / 0.7mm', 59.20, 'https://cf.shopee.com.my/file/1afba9d2403d287af0b6644c2275e7e8', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (30, 'THE HISTORY OF WHOO GONGJINHYANG SEOL Radiant White Ultimate Corrector 0.5g*20ea', 'THE HISTORY OF WHOO GONGJINHYANG SEOL Radiant White Ultimate Corrector 0.5g*20ea', 'THE HISTORY OF WHOO GONGJINHYANG SEOL Radiant White Ultimate Corrector 0.5g*20ea', 600.00, 'https://cf.shopee.com.my/file/997771b832c0bbe36671aa2ee62b6a29', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (31, 'Uni-ball Uniball One Gel Pen 0.5mm UMN-S-05 [New 2021]', 'Uni-ball Uniball One Gel Pen 0.5mm UMN-S-05 [New 2021]', 'Uni-ball Uniball One Gel Pen 0.5mm UMN-S-05 [New 2021]', 49.00, 'https://cf.shopee.com.my/file/4a3d6f6370dc3cd54fe81cc2ff944a03', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (32, 'Led Strip Lights USB 2835 Led Light Strip SMD DC5V Flexibele Light Tape Rgb 0.5M 1M 2M 3M Tv Desktop Scherm Backlight Diode Tape Lampu Tidur', 'Led Strip Lights USB 2835 Led Light Strip SMD DC5V Flexibele Light Tape Rgb 0.5M 1M 2M 3M Tv Desktop Scherm Backlight Diode Tape Lampu Tidur', 'Led Strip Lights USB 2835 Led Light Strip SMD DC5V Flexibele Light Tape Rgb 0.5M 1M 2M 3M Tv Desktop Scherm Backlight Diode Tape Lampu Tidur', 39.90, 'https://cf.shopee.com.my/file/e6dcd465ba18636080d07652ae9184b5', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (34, 'USB3.0 high speed USB Flash Drive 16GB 32GB 64GB  128GB 256GB Memory Pendrive Stick OTG USB Flash Drive', 'USB3.0 high speed USB Flash Drive 16GB 32GB 64GB  128GB 256GB Memory Pendrive Stick OTG USB Flash Drive', 'USB3.0 high speed USB Flash Drive 16GB 32GB 64GB  128GB 256GB Memory Pendrive Stick OTG USB Flash Drive', 172.00, 'https://cf.shopee.com.my/file/6aa41e4cb3912c64e4e62e08ae8d1619', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (35, 'Faber-Castell RX Gel Pen 0.38/0.5/0.7mm FC RXGel / Faber Castell Click Gel Pen (1pc)', 'Faber-Castell RX Gel Pen 0.38/0.5/0.7mm FC RXGel / Faber Castell Click Gel Pen (1pc)', 'Faber-Castell RX Gel Pen 0.38/0.5/0.7mm FC RXGel / Faber Castell Click Gel Pen (1pc)', 13.80, 'https://cf.shopee.com.my/file/3019360b4e35e1a48e8d0e385899076b', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (36, '[THE ORDINARY] Retinol 0.2% in Squalane / Retinol 0.5% in Squalane / Retinol 1% in Squalane', '[THE ORDINARY] Retinol 0.2% in Squalane / Retinol 0.5% in Squalane / Retinol 1% in Squalane', '[THE ORDINARY] Retinol 0.2% in Squalane / Retinol 0.5% in Squalane / Retinol 1% in Squalane', 338.00, 'https://cf.shopee.com.my/file/2722897adc2d2d8bbb7c188e3113e065', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (37, '0-3 MONTHS NEWBORN HIPPIE BABY WEAR 100% COTTON', '0-3 MONTHS NEWBORN HIPPIE BABY WEAR 100% COTTON', '0-3 MONTHS NEWBORN HIPPIE BABY WEAR 100% COTTON', 90.00, 'https://cf.shopee.com.my/file/fba1abc527e05dde44a6f118b207cdc3', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (38, 'Samsung Galaxy Tab A 8.0 inch 2019 SM-T290 T295 T297 multiple protection heavy armor case with bracket hit color tablet cover', 'Samsung Galaxy Tab A 8.0 inch 2019 SM-T290 T295 T297 multiple protection heavy armor case with bracket hit color tablet cover', 'Samsung Galaxy Tab A 8.0 inch 2019 SM-T290 T295 T297 multiple protection heavy armor case with bracket hit color tablet cover', 84.50, 'https://cf.shopee.com.my/file/154454eaec849625dab448554fc0a8a1', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (39, 'Authentic! OLAPLEX NO.0 / NO.3 / NO.4 / NO.5 / NO.6 / NO.7 -Hair Perfector/Shampoo/Conditioner/Bond Smoother/Oil', 'Authentic! OLAPLEX NO.0 / NO.3 / NO.4 / NO.5 / NO.6 / NO.7 -Hair Perfector/Shampoo/Conditioner/Bond Smoother/Oil', 'Authentic! OLAPLEX NO.0 / NO.3 / NO.4 / NO.5 / NO.6 / NO.7 -Hair Perfector/Shampoo/Conditioner/Bond Smoother/Oil', 979.00, 'https://cf.shopee.com.my/file/2badf3e20dc52d64bbb6c1a5bac55f42', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (40, 'plastik aiskrim malaysia 0.5kg', 'plastik aiskrim malaysia 0.5kg', 'plastik aiskrim malaysia 0.5kg', 100.00, 'https://cf.shopee.com.my/file/79134c6b2a10b323296a434dba098c3d', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (41, '50pcs Resistor 0.25W 5%', '50pcs Resistor 0.25W 5%', '50pcs Resistor 0.25W 5%', 9.90, 'https://cf.shopee.com.my/file/187ca8e7641d15e3eb89d053e477dbc0', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (42, 'Audacity 3.0.3 [Latest June 2021]', 'Audacity 3.0.3 [Latest June 2021]', 'Audacity 3.0.3 [Latest June 2021]', 75.00, 'https://cf.shopee.com.my/file/ee42521c2cb5c9d9dea4d6c6a8dd399d', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (44, '0-12month Baby Girl Boy Pattern Anti-Slip Casual Shoes Baby Socks Breathable Prewalker With Soft Rubber Soles', '0-12month Baby Girl Boy Pattern Anti-Slip Casual Shoes Baby Socks Breathable Prewalker With Soft Rubber Soles', '0-12month Baby Girl Boy Pattern Anti-Slip Casual Shoes Baby Socks Breathable Prewalker With Soft Rubber Soles', 60.40, 'https://cf.shopee.com.my/file/459fb366c51139303b7d9d690f86b05a', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (46, '[LIMITED FREE GIFT] Versatile 4 or 7 Port USB HUB | USB 3.0 & USB 2.0 | Can Be Use With Power Adapter (9B)', '[LIMITED FREE GIFT] Versatile 4 or 7 Port USB HUB | USB 3.0 & USB 2.0 | Can Be Use With Power Adapter (9B)', '[LIMITED FREE GIFT] Versatile 4 or 7 Port USB HUB | USB 3.0 & USB 2.0 | Can Be Use With Power Adapter (9B)', 45.00, 'https://cf.shopee.com.my/file/bb73fdf57e5c40edecb171a0b2796ff8', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (48, 'Original Smoant Pasito Replacement Coil Occ 0.6 DTL / 1.4 MTL / RBA', 'Original Smoant Pasito Replacement Coil Occ 0.6 DTL / 1.4 MTL / RBA', 'Original Smoant Pasito Replacement Coil Occ 0.6 DTL / 1.4 MTL / RBA', 158.00, 'https://cf.shopee.com.my/file/de7586fbf3e2551a766389193f52694c', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (49, '16MM [POWER 0 -1000] BIGEYE LENS KIMCHI PRINCE BLACK KOREAN COLOR CONTACT LENS', '16MM [POWER 0 -1000] BIGEYE LENS KIMCHI PRINCE BLACK KOREAN COLOR CONTACT LENS', '16MM [POWER 0 -1000] BIGEYE LENS KIMCHI PRINCE BLACK KOREAN COLOR CONTACT LENS', 129.80, 'https://cf.shopee.com.my/file/c0e4123a686b53a9219ca8a5bbd39379', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (50, 'New Lambda CC  HNB -  Version 3.0', 'New Lambda CC  HNB -  Version 3.0', 'New Lambda CC  HNB -  Version 3.0', 2399.90, 'https://cf.shopee.com.my/file/0e76ad1d41334d540eab43478b30ca53', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (51, 'IDT HDMI2.0 Extension Cable male to female support 4K60Hz HDMI Extender Adapter Cable for HD TV LCD Laptop 4K Projector', 'IDT HDMI2.0 Extension Cable male to female support 4K60Hz HDMI Extender Adapter Cable for HD TV LCD Laptop 4K Projector', 'IDT HDMI2.0 Extension Cable male to female support 4K60Hz HDMI Extender Adapter Cable for HD TV LCD Laptop 4K Projector', 122.70, 'https://cf.shopee.com.my/file/ecd08a596f8efd68ba1cd2e42246f4b1', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (53, '0.05/0.07C/D/DD Fast Fanning Lashes Not Loose Magnetic Automatic Eyelash Extensions', '0.05/0.07C/D/DD Fast Fanning Lashes Not Loose Magnetic Automatic Eyelash Extensions', '0.05/0.07C/D/DD Fast Fanning Lashes Not Loose Magnetic Automatic Eyelash Extensions', 180.00, 'https://cf.shopee.com.my/file/3a91dbd83f8f7cbe455f8ae5cc8f2dd3', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (54, 'QC 3.0 PD 20W 36W Quick Charge TYPE C to Iphone 4 USB Phone Charger Power Adapter / 5A fast charge data cable Type C', 'QC 3.0 PD 20W 36W Quick Charge TYPE C to Iphone 4 USB Phone Charger Power Adapter / 5A fast charge data cable Type C', 'QC 3.0 PD 20W 36W Quick Charge TYPE C to Iphone 4 USB Phone Charger Power Adapter / 5A fast charge data cable Type C', 79.80, 'https://cf.shopee.com.my/file/dd5268515d93ff000d24a588563ea0a4', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (55, '* HOT SELLING * POPULAR  * STUNNING * TEARS SERIES 14.2mm Contact Lens/Color Lens Original Korea Lens ( Power 0-1000 )', '* HOT SELLING * POPULAR  * STUNNING * TEARS SERIES 14.2mm Contact Lens/Color Lens Original Korea Lens ( Power 0-1000 )', '* HOT SELLING * POPULAR  * STUNNING * TEARS SERIES 14.2mm Contact Lens/Color Lens Original Korea Lens ( Power 0-1000 )', 99.00, 'https://cf.shopee.com.my/file/b04f5ae9e95e11c4fdc84d846eb563b1', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (56, '2000*150mm*0.45mm Elastic Resistance Band Body Stretching Pilates', '2000*150mm*0.45mm Elastic Resistance Band Body Stretching Pilates', '2000*150mm*0.45mm Elastic Resistance Band Body Stretching Pilates', 55.00, 'https://cf.shopee.com.my/file/ad6047885980749bc66568f2de0d8657', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (57, '5ft Tikar Getah Quality,Buatan Thailand,Tebal Penuh 0.40mm', '5ft Tikar Getah Quality,Buatan Thailand,Tebal Penuh 0.40mm', '5ft Tikar Getah Quality,Buatan Thailand,Tebal Penuh 0.40mm', 39.00, 'https://cf.shopee.com.my/file/1afbe4bdf5cf6d52889f4d9c4a63b10a', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (58, 'LEO 50 WQD 10-10-0.75 SUBMERSIBLE SEWAGE PUMP 230V', 'LEO 50 WQD 10-10-0.75 SUBMERSIBLE SEWAGE PUMP 230V', 'LEO 50 WQD 10-10-0.75 SUBMERSIBLE SEWAGE PUMP 230V', 5220.00, 'https://cf.shopee.com.my/file/0ec02cd70d2fa465d60de94aab752d6f', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (59, 'Faber-Castell RX GEL Gel Pen 10pcs/box 0.38mm / 0.5mm / 0.7mm', 'Faber-Castell RX GEL Gel Pen 10pcs/box 0.38mm / 0.5mm / 0.7mm', 'Faber-Castell RX GEL Gel Pen 10pcs/box 0.38mm / 0.5mm / 0.7mm', 130.00, 'https://cf.shopee.com.my/file/ef8aa8b85089be357b9329dad43994b2', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (60, 'CONTACT LENS LENSSES MURAH OFFER BY PAIR SEPASANG RM6.90 Paling Murah Harga Borong 0 power (KOSONG POWER ONLY)', 'CONTACT LENS LENSSES MURAH OFFER BY PAIR SEPASANG RM6.90 Paling Murah Harga Borong 0 power (KOSONG POWER ONLY)', 'CONTACT LENS LENSSES MURAH OFFER BY PAIR SEPASANG RM6.90 Paling Murah Harga Borong 0 power (KOSONG POWER ONLY)', 69.00, 'https://cf.shopee.com.my/file/c0ec64a7a7f631bc58ed3f3b7d942153', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (61, 'Buncho 2B 0.5mm / 0.7mm Mechanical Pencil Lead', 'Buncho 2B 0.5mm / 0.7mm Mechanical Pencil Lead', 'Buncho 2B 0.5mm / 0.7mm Mechanical Pencil Lead', 9.90, 'https://cf.shopee.com.my/file/39ee76924f9120aa914447bc97fa59aa', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (62, 'Faber Castell RX Gel Colour 0.38 / 0.5 / 0.7 Gel Pen Black / Blue / Red / Green / Lilac / Pink / Gold', 'Faber Castell RX Gel Colour 0.38 / 0.5 / 0.7 Gel Pen Black / Blue / Red / Green / Lilac / Pink / Gold', 'Faber Castell RX Gel Colour 0.38 / 0.5 / 0.7 Gel Pen Black / Blue / Red / Green / Lilac / Pink / Gold', 12.50, 'https://cf.shopee.com.my/file/dc078b8fd175819deb697ceab49a4fdd', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (66, 'RX24 Aluminum Power Metal Shell Case Wirewound Gold Resistor 10W 25W  0.1R 1R 10R 50R 100R 200R 1K ohm', 'RX24 Aluminum Power Metal Shell Case Wirewound Gold Resistor 10W 25W  0.1R 1R 10R 50R 100R 200R 1K ohm', 'RX24 Aluminum Power Metal Shell Case Wirewound Gold Resistor 10W 25W  0.1R 1R 10R 50R 100R 200R 1K ohm', 40.10, 'https://cf.shopee.com.my/file/52481c842a520be202a337f43319dc63', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (67, '[Mall4Baby - Ready Stock in Malaysia] 0-1Y Baby  3D Socks Cute Cartoon Design Anti Slip Footwear Stokin Bayi Sarung Kaki', '[Mall4Baby - Ready Stock in Malaysia] 0-1Y Baby  3D Socks Cute Cartoon Design Anti Slip Footwear Stokin Bayi Sarung Kaki', '[Mall4Baby - Ready Stock in Malaysia] 0-1Y Baby  3D Socks Cute Cartoon Design Anti Slip Footwear Stokin Bayi Sarung Kaki', 34.30, 'https://cf.shopee.com.my/file/547ca586c1631e269c22548ef3f1594f', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (68, 'Faber-Castell RX Gel Colour Pen 0.7mm FC Rxgel Pen Bright Ink Gel RX Gel Color Set / Faber Castell 249710', 'Faber-Castell RX Gel Colour Pen 0.7mm FC Rxgel Pen Bright Ink Gel RX Gel Color Set / Faber Castell 249710', 'Faber-Castell RX Gel Colour Pen 0.7mm FC Rxgel Pen Bright Ink Gel RX Gel Color Set / Faber Castell 249710', 15.80, 'https://cf.shopee.com.my/file/1234f1dede81bbca5f5740a51216c909', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (69, 'TOHO OPAQUE 11/0 BEADS - 100GM', 'TOHO OPAQUE 11/0 BEADS - 100GM', 'TOHO OPAQUE 11/0 BEADS - 100GM', 235.00, 'https://cf.shopee.com.my/file/29c1db790cd9dfc2f68c06fcf8572873', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (70, 'Boy suit baby boy clothes 2-piece set 0-5 years old musim panas kanak-kanak pendek lengan T-shirt + seluar pendek penyamaran', 'Boy suit baby boy clothes 2-piece set 0-5 years old musim panas kanak-kanak pendek lengan T-shirt + seluar pendek penyamaran', 'Boy suit baby boy clothes 2-piece set 0-5 years old musim panas kanak-kanak pendek lengan T-shirt + seluar pendek penyamaran', 139.00, 'https://cf.shopee.com.my/file/404e39d00baea6f6b1113f4d3f5b3088', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (72, 'faber castle rx gel pen 0.5mm & 0.7mm per pc (satu batang)', 'faber castle rx gel pen 0.5mm & 0.7mm per pc (satu batang)', 'faber castle rx gel pen 0.5mm & 0.7mm per pc (satu batang)', 12.90, 'https://cf.shopee.com.my/file/52788fb293b378150c8dceb5ad3a02cc', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (73, 'MIKUSO 3-PORT | 4-PORT USB HUB (USB3.0 | USB2.0 | USB 2.0 + Card Reader)', 'MIKUSO 3-PORT | 4-PORT USB HUB (USB3.0 | USB2.0 | USB 2.0 + Card Reader)', 'MIKUSO 3-PORT | 4-PORT USB HUB (USB3.0 | USB2.0 | USB 2.0 + Card Reader)', 80.00, 'https://cf.shopee.com.my/file/60b301363884040fdc7390bb93f2595e', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (74, 'Lambda CC 3.0  - Local Version [Lambda2u]', 'Lambda CC 3.0  - Local Version [Lambda2u]', 'Lambda CC 3.0  - Local Version [Lambda2u]', 2399.90, 'https://cf.shopee.com.my/file/0e76ad1d41334d540eab43478b30ca53', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (75, 'MIDEA 0.6L RICE COOKER MG-GP06B', 'MIDEA 0.6L RICE COOKER MG-GP06B', 'MIDEA 0.6L RICE COOKER MG-GP06B', 379.90, 'https://cf.shopee.com.my/file/01e1d7ac8475dbf0d58f30f3310fe05a', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (76, 'Zebra Sarasa Clip Gel Pen Refill  (0.5MM/0.7MM)', 'Zebra Sarasa Clip Gel Pen Refill  (0.5MM/0.7MM)', 'Zebra Sarasa Clip Gel Pen Refill  (0.5MM/0.7MM)', 27.00, 'https://cf.shopee.com.my/file/2acebefa1a50689f15e81c9d8b6db3c5', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (77, 'Number Candle 0-9 Numbering Baking Decoration Paraffin Candles Birthday Party Cake Topper Kek Harijadi Lilin Nombor', 'Number Candle 0-9 Numbering Baking Decoration Paraffin Candles Birthday Party Cake Topper Kek Harijadi Lilin Nombor', 'Number Candle 0-9 Numbering Baking Decoration Paraffin Candles Birthday Party Cake Topper Kek Harijadi Lilin Nombor', 17.50, 'https://cf.shopee.com.my/file/50ec17790567f0b675823c10d306d1b5', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (78, '[READY STOCK] INSIZE DIGITAL OUTSIDE MICROMETER 0-25mmx 0.001mm (3109-25A)', '[READY STOCK] INSIZE DIGITAL OUTSIDE MICROMETER 0-25mmx 0.001mm (3109-25A)', '[READY STOCK] INSIZE DIGITAL OUTSIDE MICROMETER 0-25mmx 0.001mm (3109-25A)', 2210.00, 'https://cf.shopee.com.my/file/66a8c96bd1595c876f27d60a68071b64', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (79, 'STRETCH FILM 500MM x 1.8KG/2.0KG/2.2KG x 23 MICRON x 1 ROLL {CORE=0.2KG} / Clear Transparent Shrink Wrap', 'STRETCH FILM 500MM x 1.8KG/2.0KG/2.2KG x 23 MICRON x 1 ROLL {CORE=0.2KG} / Clear Transparent Shrink Wrap', 'STRETCH FILM 500MM x 1.8KG/2.0KG/2.2KG x 23 MICRON x 1 ROLL {CORE=0.2KG} / Clear Transparent Shrink Wrap', 148.00, 'https://cf.shopee.com.my/file/94b9202ec525101225bdcfc17830a5f9', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (80, 'SanDisk OTG Pendrive Ultra Dual Drive M3.0 Pen Drive Flash Drive Micro USBFor Android (256GB/128GB/64GB/32GB/16GB) SDDD3', 'SanDisk OTG Pendrive Ultra Dual Drive M3.0 Pen Drive Flash Drive Micro USBFor Android (256GB/128GB/64GB/32GB/16GB) SDDD3', 'SanDisk OTG Pendrive Ultra Dual Drive M3.0 Pen Drive Flash Drive Micro USBFor Android (256GB/128GB/64GB/32GB/16GB) SDDD3', 235.00, 'https://cf.shopee.com.my/file/a17514c6fadabc6244da10242297e110', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (82, 'ActivePresenter Pro 8.5.0[Latest June 2021]', 'ActivePresenter Pro 8.5.0[Latest June 2021]', 'ActivePresenter Pro 8.5.0[Latest June 2021]', 29.90, 'https://cf.shopee.com.my/file/dce390ae76f754d15979462f56fec3be', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (83, 'Winzige 0.5mm Black Ink Gel Pen School Office Supplies', 'Winzige 0.5mm Black Ink Gel Pen School Office Supplies', 'Winzige 0.5mm Black Ink Gel Pen School Office Supplies', 6.50, 'https://cf.shopee.com.my/file/86b053cd8021ede37afdc60f07890403', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (84, 'Thermalright ODYSSEY Thermal conductive silicone Pad 12.8W/mk 85x45mm Non-Conductive Thermal Mat 0.5mm/1.0mm/1.5mm/2.0mm Original Authentic Thermal pad', 'Thermalright ODYSSEY Thermal conductive silicone Pad 12.8W/mk 85x45mm Non-Conductive Thermal Mat 0.5mm/1.0mm/1.5mm/2.0mm Original Authentic Thermal pad', 'Thermalright ODYSSEY Thermal conductive silicone Pad 12.8W/mk 85x45mm Non-Conductive Thermal Mat 0.5mm/1.0mm/1.5mm/2.0mm Original Authentic Thermal pad', 195.00, 'https://cf.shopee.com.my/file/cdb25ad643cada1b86a7217120d3338c', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (85, 'Sandisk Blade Pendrive USB2.0/Compatible With USB 3.0 (8GB/16GB/32GB/64GB)', 'Sandisk Blade Pendrive USB2.0/Compatible With USB 3.0 (8GB/16GB/32GB/64GB)', 'Sandisk Blade Pendrive USB2.0/Compatible With USB 3.0 (8GB/16GB/32GB/64GB)', 159.90, 'https://cf.shopee.com.my/file/6cdf5c969ed13a2af9904226282d984e', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (86, 'Novel: HATIKU UNTUK DIA | Penulis: Rose Harissa | Penerbit: Penulisan2u | ISBN: 978-967-2102-41-0', 'Novel: HATIKU UNTUK DIA | Penulis: Rose Harissa | Penerbit: Penulisan2u | ISBN: 978-967-2102-41-0', 'Novel: HATIKU UNTUK DIA | Penulis: Rose Harissa | Penerbit: Penulisan2u | ISBN: 978-967-2102-41-0', 280.00, 'https://cf.shopee.com.my/file/8a1021e6beb204349bbc711e2b4f056a', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (87, '16inch Number 0-9 Foil Balloons Happy Birthday Party', '16inch Number 0-9 Foil Balloons Happy Birthday Party', '16inch Number 0-9 Foil Balloons Happy Birthday Party', 6.50, 'https://cf.shopee.com.my/file/957da868a4a6a40a08664e3c29c28ed4', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (88, 'Pigeon Unisex Newborn Baby Clothes Eyelet Singlet Baju Berlubang Singlet 0-18 Bulan Baju Baby Baru Lahir 100% Cotton', 'Pigeon Unisex Newborn Baby Clothes Eyelet Singlet Baju Berlubang Singlet 0-18 Bulan Baju Baby Baru Lahir 100% Cotton', 'Pigeon Unisex Newborn Baby Clothes Eyelet Singlet Baju Berlubang Singlet 0-18 Bulan Baju Baby Baru Lahir 100% Cotton', 119.00, 'https://cf.shopee.com.my/file/3d32c326722b6afae4360372e6ff5602', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (89, 'A4 Rigid Sheet 0.2mm | Transparent Book Binding Binder Cover PVC Plastic Cover Comb Cover Clear Plastic Cover', 'A4 Rigid Sheet 0.2mm | Transparent Book Binding Binder Cover PVC Plastic Cover Comb Cover Clear Plastic Cover', 'A4 Rigid Sheet 0.2mm | Transparent Book Binding Binder Cover PVC Plastic Cover Comb Cover Clear Plastic Cover', 35.00, 'https://cf.shopee.com.my/file/b85e8bfb3ed420abbd6f0b7ee510fcf9', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (90, 'Toon Boom Harmony Premium 20.0.3[Latest March 2021]', 'Toon Boom Harmony Premium 20.0.3[Latest March 2021]', 'Toon Boom Harmony Premium 20.0.3[Latest March 2021]', 35.00, 'https://cf.shopee.com.my/file/afdf81316884b4d73d6fc4ff3c660f27', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (91, 'Pineng PN899pd QC 3.0/PD 3.0 Fast Charging 30000mAh Type-C PN899 18W Powerbank [100% Original]', 'Pineng PN899pd QC 3.0/PD 3.0 Fast Charging 30000mAh Type-C PN899 18W Powerbank [100% Original]', 'Pineng PN899pd QC 3.0/PD 3.0 Fast Charging 30000mAh Type-C PN899 18W Powerbank [100% Original]', 669.00, 'https://cf.shopee.com.my/file/ee7786d57c3965f0714dbb6693feb12a', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (92, 'Pilot Super Grip Neon Mechanical Pencil / Progrex / Rexgrip / G2 / Shaker / Snapclick / Corone / 0.3mm / 0.5mm / 0.7mm', 'Pilot Super Grip Neon Mechanical Pencil / Progrex / Rexgrip / G2 / Shaker / Snapclick / Corone / 0.3mm / 0.5mm / 0.7mm', 'Pilot Super Grip Neon Mechanical Pencil / Progrex / Rexgrip / G2 / Shaker / Snapclick / Corone / 0.3mm / 0.5mm / 0.7mm', 33.00, 'https://cf.shopee.com.my/file/40d280240f19ac2b57094adf8235071b', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (94, 'For Samsung Galaxy Tab A 8.0\" 2019 SM-T290 T295 Case Shockproof Kids Eva Handle Cover', 'For Samsung Galaxy Tab A 8.0\" 2019 SM-T290 T295 Case Shockproof Kids Eva Handle Cover', 'For Samsung Galaxy Tab A 8.0\" 2019 SM-T290 T295 Case Shockproof Kids Eva Handle Cover', 99.00, 'https://cf.shopee.com.my/file/ed69bd975998ff16f6b0ed7091bc5665', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (97, 'USB3.0 ULTRA HIGHSPEED TRANSPARENT / BLACK HARDDISK CASE USB 3.0 SATA 2.5\" HDD SSD External CASE. ORICO HARRIDSK CASE', 'USB3.0 ULTRA HIGHSPEED TRANSPARENT / BLACK HARDDISK CASE USB 3.0 SATA 2.5\" HDD SSD External CASE. ORICO HARRIDSK CASE', 'USB3.0 ULTRA HIGHSPEED TRANSPARENT / BLACK HARDDISK CASE USB 3.0 SATA 2.5\" HDD SSD External CASE. ORICO HARRIDSK CASE', 198.80, 'https://cf.shopee.com.my/file/90458131909d7eb58c60d512427b624e', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (98, 'Boy 2-piece set baby boy clothes Kanak-kanak saman lengan pendek 0-5 tahun bayi berusia kartun comel pusingan leher T-shirt + seluar pendek', 'Boy 2-piece set baby boy clothes Kanak-kanak saman lengan pendek 0-5 tahun bayi berusia kartun comel pusingan leher T-shirt + seluar pendek', 'Boy 2-piece set baby boy clothes Kanak-kanak saman lengan pendek 0-5 tahun bayi berusia kartun comel pusingan leher T-shirt + seluar pendek', 219.00, 'https://cf.shopee.com.my/file/f9d85f8e00c5e389674040c0b6c85479', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (99, 'Gsoft WM5 WM7 Ball Pen 0.5mm 0.7mm Blue Black Red ballpen', 'Gsoft WM5 WM7 Ball Pen 0.5mm 0.7mm Blue Black Red ballpen', 'Gsoft WM5 WM7 Ball Pen 0.5mm 0.7mm Blue Black Red ballpen', 6.00, 'https://cf.shopee.com.my/file/8bbcede22ead2eead53059f25168b6df', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (100, 'Jarum Kait Pemegang Getah (2.0-6.0mm)/Crochet Hook with rubber handle (2.0mm-6.0mm)', 'Jarum Kait Pemegang Getah (2.0-6.0mm)/Crochet Hook with rubber handle (2.0mm-6.0mm)', 'Jarum Kait Pemegang Getah (2.0-6.0mm)/Crochet Hook with rubber handle (2.0mm-6.0mm)', 30.00, 'https://cf.shopee.com.my/file/2d80c65fe5147414fee46d68c7e68e3d', 1627909649, 1, 1);
INSERT INTO `xy_goods_list` VALUES (101, 'Derma Roller 0.25mm 0.3mm 0.5mm 1.0mm 1.5mm Titanium Micro Needle Rawat muka - Tumbuhkan Jambang & Rambut', 'Derma Roller 0.25mm 0.3mm 0.5mm 1.0mm 1.5mm Titanium Micro Needle Rawat muka - Tumbuhkan Jambang & Rambut', 'Derma Roller 0.25mm 0.3mm 0.5mm 1.0mm 1.5mm Titanium Micro Needle Rawat muka - Tumbuhkan Jambang & Rambut', 255.00, 'https://cf.shopee.com.my/file/b7ea47e4cd1bbdfbd71c87fa06a0ff03', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (102, 'Topaz Video Enhance AI 2.2.0 [Updated June 2021] Latest Version', 'Topaz Video Enhance AI 2.2.0 [Updated June 2021] Latest Version', 'Topaz Video Enhance AI 2.2.0 [Updated June 2021] Latest Version', 49.00, 'https://cf.shopee.com.my/file/d31c8d569bfb2f3f55877d9d4b35ade8', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (103, 'Faber Castell CX Plus 5 / 7 0.5mm 0.7mm Pen Black, Blue, Red', 'Faber Castell CX Plus 5 / 7 0.5mm 0.7mm Pen Black, Blue, Red', 'Faber Castell CX Plus 5 / 7 0.5mm 0.7mm Pen Black, Blue, Red', 10.00, 'https://cf.shopee.com.my/file/9d634b91b6d4dd75624ab89610351bc2', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (104, 'Panasonic KDK Ceiling Fan Condenser Capacitor 1.8uF 2.4uF 5uF 0.1uF 0.82uF 275VAC (5 Pieces /set)', 'Panasonic KDK Ceiling Fan Condenser Capacitor 1.8uF 2.4uF 5uF 0.1uF 0.82uF 275VAC (5 Pieces /set)', 'Panasonic KDK Ceiling Fan Condenser Capacitor 1.8uF 2.4uF 5uF 0.1uF 0.82uF 275VAC (5 Pieces /set)', 118.90, 'https://cf.shopee.com.my/file/7a0e22358831f451c7f209b99982e53c', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (106, '100% Original DD Live Flavor Ready Stock !!!9.0', '100% Original DD Live Flavor Ready Stock !!!9.0', '100% Original DD Live Flavor Ready Stock !!!9.0', 288.80, 'https://cf.shopee.com.my/file/dc76d7c8c2357ae7597d75ffb1250568', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (107, 'Kerongsang 0.8CM Batu Korea Baby Brooch Color Mixed Randomly Ready Stock', 'Kerongsang 0.8CM Batu Korea Baby Brooch Color Mixed Randomly Ready Stock', 'Kerongsang 0.8CM Batu Korea Baby Brooch Color Mixed Randomly Ready Stock', 123.60, 'https://cf.shopee.com.my/file/f8726a0f322b0981cac7c1e603f03ab7', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (110, '*2021 New Lens* Angela Natural.Color.Korea.Lens (P-0.00 till P-8.00) Free Case', '*2021 New Lens* Angela Natural.Color.Korea.Lens (P-0.00 till P-8.00) Free Case', '*2021 New Lens* Angela Natural.Color.Korea.Lens (P-0.00 till P-8.00) Free Case', 99.00, 'https://cf.shopee.com.my/file/520a0b4300ad6f34f0237ac8a1931416', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (111, 'BIGEYE LENS EFFECT 20MM i.FAIRY Pandora POWER 0-850 16.2MM BIG EFFECT Korean Color Contact Lens', 'BIGEYE LENS EFFECT 20MM i.FAIRY Pandora POWER 0-850 16.2MM BIG EFFECT Korean Color Contact Lens', 'BIGEYE LENS EFFECT 20MM i.FAIRY Pandora POWER 0-850 16.2MM BIG EFFECT Korean Color Contact Lens', 129.80, 'https://cf.shopee.com.my/file/71a83165f223505ea3e091c95a32dc38', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (112, '[Global Version] Box S / TV Box S 4K HDR Android TV Box With Google Assistant Media Player Android 9.0', '[Global Version] Box S / TV Box S 4K HDR Android TV Box With Google Assistant Media Player Android 9.0', '[Global Version] Box S / TV Box S 4K HDR Android TV Box With Google Assistant Media Player Android 9.0', 2490.00, 'https://cf.shopee.com.my/file/e5ee103c53f856b9d77709849ba4d31d', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (115, 'ZGTS 192 Micro Needle 0.2-3.0mm Derma Roller Titanium Needle Anti Aging Scar Acne Wrinkle Cellulite CE', 'ZGTS 192 Micro Needle 0.2-3.0mm Derma Roller Titanium Needle Anti Aging Scar Acne Wrinkle Cellulite CE', 'ZGTS 192 Micro Needle 0.2-3.0mm Derma Roller Titanium Needle Anti Aging Scar Acne Wrinkle Cellulite CE', 148.80, 'https://cf.shopee.com.my/file/d05fc78aed958a287d31325d439273de', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (116, 'Jet Black PU PVC Leather by half meter - thickness 0.70mm', 'Jet Black PU PVC Leather by half meter - thickness 0.70mm', 'Jet Black PU PVC Leather by half meter - thickness 0.70mm', 98.50, 'https://cf.shopee.com.my/file/31fe67dfd045306ed0ba963865c6c2d6', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (117, '50m/lot 0.8mm Cotton Cord Nylon Cord Thread String DIY Beading Braided Bracelet Jewelry Making', '50m/lot 0.8mm Cotton Cord Nylon Cord Thread String DIY Beading Braided Bracelet Jewelry Making', '50m/lot 0.8mm Cotton Cord Nylon Cord Thread String DIY Beading Braided Bracelet Jewelry Making', 26.60, 'https://cf.shopee.com.my/file/b2f69ef0fd46c6e8ea90a526f25bb7a0', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (118, 'Samsung Galaxy Tab A 8.0 T295 2019 Kickstand Tough Case Cover ( Without Spen)', 'Samsung Galaxy Tab A 8.0 T295 2019 Kickstand Tough Case Cover ( Without Spen)', 'Samsung Galaxy Tab A 8.0 T295 2019 Kickstand Tough Case Cover ( Without Spen)', 250.00, 'https://cf.shopee.com.my/file/040eeb53732ac889e42f9b1b324d9508', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (119, 'Fixguru. Bubble Wrap Rolls & Sheets Single & Double Layer 0.5MX0.5M / 0.5MX1M / 1MX1M Clear & Black', 'Fixguru. Bubble Wrap Rolls & Sheets Single & Double Layer 0.5MX0.5M / 0.5MX1M / 1MX1M Clear & Black', 'Fixguru. Bubble Wrap Rolls & Sheets Single & Double Layer 0.5MX0.5M / 0.5MX1M / 1MX1M Clear & Black', 5.60, 'https://cf.shopee.com.my/file/2c8286faa7cc4eed4bd9233b22c79cdb', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (121, 'Black/Clear Stretch Film 500mm X 2.2KG X ( 0.2KG CORE)', 'Black/Clear Stretch Film 500mm X 2.2KG X ( 0.2KG CORE)', 'Black/Clear Stretch Film 500mm X 2.2KG X ( 0.2KG CORE)', 165.00, 'https://cf.shopee.com.my/file/134f1caccd5a615a323df46149b17091', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (122, 'InPixio Photo Studio Ultimate 11.0.7753.22643 [ Windows 7/8/10-64bit ]', 'InPixio Photo Studio Ultimate 11.0.7753.22643 [ Windows 7/8/10-64bit ]', 'InPixio Photo Studio Ultimate 11.0.7753.22643 [ Windows 7/8/10-64bit ]', 35.00, 'https://cf.shopee.com.my/file/77805194a191ae8eb61283ec543abac6', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (123, 'Bubble Wrap Clear/Black 0.5m x 1M / 1m x 1M', 'Bubble Wrap Clear/Black 0.5m x 1M / 1m x 1M', 'Bubble Wrap Clear/Black 0.5m x 1M / 1m x 1M', 7.00, 'https://cf.shopee.com.my/file/e7007456f887870ad0b374fb90c21f08', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (124, 'QC3.0 FAST CHARGING QUALCOM QC 3.0 FAST CHARGER LENYES LCH082', 'QC3.0 FAST CHARGING QUALCOM QC 3.0 FAST CHARGER LENYES LCH082', 'QC3.0 FAST CHARGING QUALCOM QC 3.0 FAST CHARGER LENYES LCH082', 180.00, 'https://cf.shopee.com.my/file/81298daac7ace95ab422869d813bea62', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (126, 'Total War Combo 1 ( 5 In 1) New 2.0/64GB Pen-Drive Install Edition', 'Total War Combo 1 ( 5 In 1) New 2.0/64GB Pen-Drive Install Edition', 'Total War Combo 1 ( 5 In 1) New 2.0/64GB Pen-Drive Install Edition', 440.00, 'https://cf.shopee.com.my/file/5be29fe479f75b1de1447d5b7e8c4220', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (128, '[READY STOCK] MARVEL Extra Large Gaming Mouse Pad 90cm*40cm*0.2cm', '[READY STOCK] MARVEL Extra Large Gaming Mouse Pad 90cm*40cm*0.2cm', '[READY STOCK] MARVEL Extra Large Gaming Mouse Pad 90cm*40cm*0.2cm', 193.70, 'https://cf.shopee.com.my/file/03bba55b269c080cfc3113b333ae6879', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (129, 'Striped Newborn Baby Toddler Tight Long Cotton Pants Leggings 0-2Yrs', 'Striped Newborn Baby Toddler Tight Long Cotton Pants Leggings 0-2Yrs', 'Striped Newborn Baby Toddler Tight Long Cotton Pants Leggings 0-2Yrs', 33.60, 'https://cf.shopee.com.my/file/5073ee4f12b8ee9690b9e74ea5e71839', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (130, 'Baby boy clothes boy 2-piece set 0-5 tahun budak lelaki berusia saman musim panas surat kartun comel percetakan kapas T-shirt + seluar pendek', 'Baby boy clothes boy 2-piece set 0-5 tahun budak lelaki berusia saman musim panas surat kartun comel percetakan kapas T-shirt + seluar pendek', 'Baby boy clothes boy 2-piece set 0-5 tahun budak lelaki berusia saman musim panas surat kartun comel percetakan kapas T-shirt + seluar pendek', 139.00, 'https://cf.shopee.com.my/file/8d57f6064f9803ba871cc751d6d26548', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (131, '(0-5months) OFFER !!! Newborn Baby SKK Baby Wrist Rattle Toy Toys (0-5m)', '(0-5months) OFFER !!! Newborn Baby SKK Baby Wrist Rattle Toy Toys (0-5m)', '(0-5months) OFFER !!! Newborn Baby SKK Baby Wrist Rattle Toy Toys (0-5m)', 29.90, 'https://cf.shopee.com.my/file/06768fc19b66d7b0d62442433abc50a5', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (132, 'Sandisk Ultra Dual Drive Otg M3.0 (16GB/32GB/64GB/128GB)', 'Sandisk Ultra Dual Drive Otg M3.0 (16GB/32GB/64GB/128GB)', 'Sandisk Ultra Dual Drive Otg M3.0 (16GB/32GB/64GB/128GB)', 219.90, 'https://cf.shopee.com.my/file/84fcdce36fca84e20167f4c9e7065947', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (133, 'Bubble Wrap Murah Borong Wholesale 1m x 1m / 1m x 0.5m', 'Bubble Wrap Murah Borong Wholesale 1m x 1m / 1m x 0.5m', 'Bubble Wrap Murah Borong Wholesale 1m x 1m / 1m x 0.5m', 3.00, 'https://cf.shopee.com.my/file/0de9767f120450a3dcd2179f350aea6d', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (134, 'ORGINAL Nada Peach Gray 14.mm Contact Lens Lenses Grey (Degree/0.Degree)  B407-5 Kanta Lekap', 'ORGINAL Nada Peach Gray 14.mm Contact Lens Lenses Grey (Degree/0.Degree)  B407-5 Kanta Lekap', 'ORGINAL Nada Peach Gray 14.mm Contact Lens Lenses Grey (Degree/0.Degree)  B407-5 Kanta Lekap', 89.00, 'https://cf.shopee.com.my/file/380c7bfd10dd56f2672a9dd39fb2834b', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (135, 'Ikan bilis ori tanjung dawai... ... (Siap kopek) 0.50kg', 'Ikan bilis ori tanjung dawai... ... (Siap kopek) 0.50kg', 'Ikan bilis ori tanjung dawai... ... (Siap kopek) 0.50kg', 280.00, 'https://cf.shopee.com.my/file/abf98ffc6a12180054227d6efd10b07f', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (137, '(0-12Y) KIDS LEGGING BLACK COLOR PLAIN SELUAR LEGGING BUDAK HITAM BAYI & KANAK-KANAK 100% Cotton Spandex', '(0-12Y) KIDS LEGGING BLACK COLOR PLAIN SELUAR LEGGING BUDAK HITAM BAYI & KANAK-KANAK 100% Cotton Spandex', '(0-12Y) KIDS LEGGING BLACK COLOR PLAIN SELUAR LEGGING BUDAK HITAM BAYI & KANAK-KANAK 100% Cotton Spandex', 15.90, 'https://cf.shopee.com.my/file/8d20119ddb55890bcb1d03d0492a3d59', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (138, 'Conophytum Red Maughanii (0.8cm+-)', 'Conophytum Red Maughanii (0.8cm+-)', 'Conophytum Red Maughanii (0.8cm+-)', 240.00, 'https://cf.shopee.com.my/file/26e2aafc558d949a8b264fde7587f86c', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (139, 'Anakku Disney Baby Boy Newborn Romper Snap-on Button Rompers Baju Bayi Lelaki [0-12 Months] EDS232-2', 'Anakku Disney Baby Boy Newborn Romper Snap-on Button Rompers Baju Bayi Lelaki [0-12 Months] EDS232-2', 'Anakku Disney Baby Boy Newborn Romper Snap-on Button Rompers Baju Bayi Lelaki [0-12 Months] EDS232-2', 180.00, 'https://cf.shopee.com.my/file/62d8dda445499e157a88b02432cfe4de', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (140, '100% Original Remax RPP108 5A Super Fast Charge 20000mAh Power Bank RPP-108 PD3.0 Riji Series Power Bank QC3.0 Fast', '100% Original Remax RPP108 5A Super Fast Charge 20000mAh Power Bank RPP-108 PD3.0 Riji Series Power Bank QC3.0 Fast', '100% Original Remax RPP108 5A Super Fast Charge 20000mAh Power Bank RPP-108 PD3.0 Riji Series Power Bank QC3.0 Fast', 499.00, 'https://cf.shopee.com.my/file/d97fcc905c9d8811acc500621616e632', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (141, 'Auto Lead Rotation Uni Kuru Toga Roulette Model Mechanical Pencil (0.5mm)', 'Auto Lead Rotation Uni Kuru Toga Roulette Model Mechanical Pencil (0.5mm)', 'Auto Lead Rotation Uni Kuru Toga Roulette Model Mechanical Pencil (0.5mm)', 397.00, 'https://cf.shopee.com.my/file/610a302f052392660cb289b3d93722fa', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (142, 'USAMS 10,000mAh PD/QC3.0 Fast Charging Power Bank with Lanyard for iPhone & Android (QC/FCP/AFC/PD)', 'USAMS 10,000mAh PD/QC3.0 Fast Charging Power Bank with Lanyard for iPhone & Android (QC/FCP/AFC/PD)', 'USAMS 10,000mAh PD/QC3.0 Fast Charging Power Bank with Lanyard for iPhone & Android (QC/FCP/AFC/PD)', 499.80, 'https://cf.shopee.com.my/file/fe6118716dd87d9f64041cfeed77f24a', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (144, '0-4Y SUMMER Korea lovely Comfortable TOP Children\'s Short-sleeved T-shirt Cotton Baby Breathable Casual Cartoon Printed Shirt', '0-4Y SUMMER Korea lovely Comfortable TOP Children\'s Short-sleeved T-shirt Cotton Baby Breathable Casual Cartoon Printed Shirt', '0-4Y SUMMER Korea lovely Comfortable TOP Children\'s Short-sleeved T-shirt Cotton Baby Breathable Casual Cartoon Printed Shirt', 49.00, 'https://cf.shopee.com.my/file/395ef10a9fd4be6a72353065cc6a3fad', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (145, '(0-3m) BAJU BABY NEWBORN / Baju Baby Murah / Baby Clothing / baju baby girl baju baby boy / BABY CLOTHING SUIT MYKIDS', '(0-3m) BAJU BABY NEWBORN / Baju Baby Murah / Baby Clothing / baju baby girl baju baby boy / BABY CLOTHING SUIT MYKIDS', '(0-3m) BAJU BABY NEWBORN / Baju Baby Murah / Baby Clothing / baju baby girl baju baby boy / BABY CLOTHING SUIT MYKIDS', 84.00, 'https://cf.shopee.com.my/file/a5acddfa1d2694279f98964342d7677c', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (146, 'Baby Toys 0-1 Years Old Animal Bed Bells Soothing Stuffed Dolls Plush Toy for Toddler Gift Babys Rattles Carriage Hanging Infant', 'Baby Toys 0-1 Years Old Animal Bed Bells Soothing Stuffed Dolls Plush Toy for Toddler Gift Babys Rattles Carriage Hanging Infant', 'Baby Toys 0-1 Years Old Animal Bed Bells Soothing Stuffed Dolls Plush Toy for Toddler Gift Babys Rattles Carriage Hanging Infant', 255.10, 'https://cf.shopee.com.my/file/9ee59985dce44fe388dae1fe74aa8864', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (147, 'Kasut Baby Girl Shoes 0-1 Years Newborn Shoes Bow-knot Cute Anti-Slip Toddler Soft Sole Baby Shoes', 'Kasut Baby Girl Shoes 0-1 Years Newborn Shoes Bow-knot Cute Anti-Slip Toddler Soft Sole Baby Shoes', 'Kasut Baby Girl Shoes 0-1 Years Newborn Shoes Bow-knot Cute Anti-Slip Toddler Soft Sole Baby Shoes', 106.30, 'https://cf.shopee.com.my/file/f6a8b46142309c3f519b07c26fa75832', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (148, 'KINGSTON PENDRIVE 32GB / 64GB / 128GB (DT100G3) USB3.0', 'KINGSTON PENDRIVE 32GB / 64GB / 128GB (DT100G3) USB3.0', 'KINGSTON PENDRIVE 32GB / 64GB / 128GB (DT100G3) USB3.0', 175.00, 'https://cf.shopee.com.my/file/02289337c598a24d91a156d359e3313e', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (150, '0-4 tahun budak lelaki berusia lengan pendek baju sut bayi lelaki kasual fesyen set 2 keping saman kanak-kanak', '0-4 tahun budak lelaki berusia lengan pendek baju sut bayi lelaki kasual fesyen set 2 keping saman kanak-kanak', '0-4 tahun budak lelaki berusia lengan pendek baju sut bayi lelaki kasual fesyen set 2 keping saman kanak-kanak', 114.40, 'https://cf.shopee.com.my/file/afe56ff1703319b2ef6697a3e412bdba', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (151, 'SanDisk Ultra Dual M3.0 16GB/32GB/64GB/128GB Flash Drive OTG Dual Drive OTG', 'SanDisk Ultra Dual M3.0 16GB/32GB/64GB/128GB Flash Drive OTG Dual Drive OTG', 'SanDisk Ultra Dual M3.0 16GB/32GB/64GB/128GB Flash Drive OTG Dual Drive OTG', 222.00, 'https://cf.shopee.com.my/file/6a7bf89a1db2b559a2d13c919e4c7ac0', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (152, 'Baju Baby Clothing 0-2 Years Gaun Baby Sleeveless Cute Baby Dress and Bow-knot Headband 2Pcs Baju Bayi Perempuan Fashion Lace Baptism Dress', 'Baju Baby Clothing 0-2 Years Gaun Baby Sleeveless Cute Baby Dress and Bow-knot Headband 2Pcs Baju Bayi Perempuan Fashion Lace Baptism Dress', 'Baju Baby Clothing 0-2 Years Gaun Baby Sleeveless Cute Baby Dress and Bow-knot Headband 2Pcs Baju Bayi Perempuan Fashion Lace Baptism Dress', 198.30, 'https://cf.shopee.com.my/file/05c3b28cff55c98c3c3259027ad16b85', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (153, 'Artline Writing Pen Artline 200 Artline 210 Artline 220 Artline 250 0.2 0.4 0.6', 'Artline Writing Pen Artline 200 Artline 210 Artline 220 Artline 250 0.2 0.4 0.6', 'Artline Writing Pen Artline 200 Artline 210 Artline 220 Artline 250 0.2 0.4 0.6', 24.00, 'https://cf.shopee.com.my/file/baf33eb9447e376ddea7c84a2124fc86', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (154, 'Samsung Galaxy Tab A 8.0 2019 SM T290 T295 T297 Silicone Cover  With Bracket Anti-Shock Tablet Case', 'Samsung Galaxy Tab A 8.0 2019 SM T290 T295 T297 Silicone Cover  With Bracket Anti-Shock Tablet Case', 'Samsung Galaxy Tab A 8.0 2019 SM T290 T295 T297 Silicone Cover  With Bracket Anti-Shock Tablet Case', 298.00, 'https://cf.shopee.com.my/file/8d623458f77448fe263198c5cb9d024e', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (155, 'DERMAROLLER Clear Hepburn Basic size 0.2mm 0.5mm 1.0mm Stainless Steel Titanium Serum Evoe', 'DERMAROLLER Clear Hepburn Basic size 0.2mm 0.5mm 1.0mm Stainless Steel Titanium Serum Evoe', 'DERMAROLLER Clear Hepburn Basic size 0.2mm 0.5mm 1.0mm Stainless Steel Titanium Serum Evoe', 200.00, 'https://cf.shopee.com.my/file/8278d5592940ecc7979550a927b9121f', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (156, 'IKEA PRODUKT MILK FROTHER BLACK IKEA MILK-FROTHER COFFEE MILK SPIN MILK PEMBUIH SUSU MATTLIG MILK-FROTHING JUG 0.5L', 'IKEA PRODUKT MILK FROTHER BLACK IKEA MILK-FROTHER COFFEE MILK SPIN MILK PEMBUIH SUSU MATTLIG MILK-FROTHING JUG 0.5L', 'IKEA PRODUKT MILK FROTHER BLACK IKEA MILK-FROTHER COFFEE MILK SPIN MILK PEMBUIH SUSU MATTLIG MILK-FROTHING JUG 0.5L', 219.00, 'https://cf.shopee.com.my/file/22dc13e89145fed14ad24baced502b47', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (158, 'Set Baju Musim Panas Boys Dicetak Penuh Baju Daun Seluar T-shirt Seluar 0-4 Tahun Kanak-kanak Modis Set Dua helai', 'Set Baju Musim Panas Boys Dicetak Penuh Baju Daun Seluar T-shirt Seluar 0-4 Tahun Kanak-kanak Modis Set Dua helai', 'Set Baju Musim Panas Boys Dicetak Penuh Baju Daun Seluar T-shirt Seluar 0-4 Tahun Kanak-kanak Modis Set Dua helai', 114.40, 'https://cf.shopee.com.my/file/f2ca1597ecbdb28f812e9cc5963006e5', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (162, '0-4 tahun budak lelaki berusia saman lengan pendek gaya Hawaii bunga penuh dicetak lengan pendek baju two-piece pakaian musim panas kanak-kanak kanak-kanak', '0-4 tahun budak lelaki berusia saman lengan pendek gaya Hawaii bunga penuh dicetak lengan pendek baju two-piece pakaian musim panas kanak-kanak kanak-kanak', '0-4 tahun budak lelaki berusia saman lengan pendek gaya Hawaii bunga penuh dicetak lengan pendek baju two-piece pakaian musim panas kanak-kanak kanak-kanak', 114.40, 'https://cf.shopee.com.my/file/5ae1154a5f3de157014ef72248f8ce8d', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (163, 'Papermate Kilometrico Ball Pen 0.8mm Fine / 1.0mm Medium (ORIGINAL)', 'Papermate Kilometrico Ball Pen 0.8mm Fine / 1.0mm Medium (ORIGINAL)', 'Papermate Kilometrico Ball Pen 0.8mm Fine / 1.0mm Medium (ORIGINAL)', 5.00, 'https://cf.shopee.com.my/file/d2b03339cf51d6455be89324881fc1c0', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (165, '0-12Month Baby Legging Boy Girl Plain Tight Pant Leggings Newborn Stokin Seluar Legging Stoking Bayi Selesa Murah', '0-12Month Baby Legging Boy Girl Plain Tight Pant Leggings Newborn Stokin Seluar Legging Stoking Bayi Selesa Murah', '0-12Month Baby Legging Boy Girl Plain Tight Pant Leggings Newborn Stokin Seluar Legging Stoking Bayi Selesa Murah', 69.90, 'https://cf.shopee.com.my/file/2b65094f7ee5808559438008fc63bfcc', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (166, 'CONTACT LENS TERESA SOFT LENS CONTACT LENSES 14.5MM (0 DEGREE) C215', 'CONTACT LENS TERESA SOFT LENS CONTACT LENSES 14.5MM (0 DEGREE) C215', 'CONTACT LENS TERESA SOFT LENS CONTACT LENSES 14.5MM (0 DEGREE) C215', 89.00, 'https://cf.shopee.com.my/file/1ac16d23081737117097c6143706def6', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (167, '[Global version] Xiaomi Mi TV Stick 2K Android 9.0 1GB + 8GB ROM Media Streaming AndroidTV Box', '[Global version] Xiaomi Mi TV Stick 2K Android 9.0 1GB + 8GB ROM Media Streaming AndroidTV Box', '[Global version] Xiaomi Mi TV Stick 2K Android 9.0 1GB + 8GB ROM Media Streaming AndroidTV Box', 1588.00, 'https://cf.shopee.com.my/file/2fd170c8ebd99ebf49b9d03ea86d9109', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (168, '(0-12Y) Seluar Tidur Budak Perempuan/lelaki. Random. Cotton Casual Long Pant Girl/Boy Pyjamas Kid Sleeping Pants', '(0-12Y) Seluar Tidur Budak Perempuan/lelaki. Random. Cotton Casual Long Pant Girl/Boy Pyjamas Kid Sleeping Pants', '(0-12Y) Seluar Tidur Budak Perempuan/lelaki. Random. Cotton Casual Long Pant Girl/Boy Pyjamas Kid Sleeping Pants', 29.90, 'https://cf.shopee.com.my/file/fce0d87a02ce6499c0c28c503716b7fb', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (169, 'Pentel Caplet A105 Mechanical Pencil 0.5mm', 'Pentel Caplet A105 Mechanical Pencil 0.5mm', 'Pentel Caplet A105 Mechanical Pencil 0.5mm', 27.60, 'https://cf.shopee.com.my/file/587287ff1647001bc0788c778efa1f18', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (170, 'NONO.Flamingo Cartoon Gel Pen Black Ink 0.5mm Cute Gel Pen Office School Door Gift Student Stationery Pencil Skirt', 'NONO.Flamingo Cartoon Gel Pen Black Ink 0.5mm Cute Gel Pen Office School Door Gift Student Stationery Pencil Skirt', 'NONO.Flamingo Cartoon Gel Pen Black Ink 0.5mm Cute Gel Pen Office School Door Gift Student Stationery Pencil Skirt', 5.90, 'https://cf.shopee.com.my/file/9ccff970a6a2889064c24f304e90f668', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (171, 'Novel: AKU PILIH BAHAGIA | Penulis: Umie Nadzimah | Penerbit: Karyaseni  | ISBN: 978-967-469-137-0', 'Novel: AKU PILIH BAHAGIA | Penulis: Umie Nadzimah | Penerbit: Karyaseni  | ISBN: 978-967-469-137-0', 'Novel: AKU PILIH BAHAGIA | Penulis: Umie Nadzimah | Penerbit: Karyaseni  | ISBN: 978-967-469-137-0', 180.00, 'https://cf.shopee.com.my/file/b7825b50e311128f71f4d7b6cb52a1cc', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (172, 'DUTCH LADY 0-12/123/456 850GM (3PACK)', 'DUTCH LADY 0-12/123/456 850GM (3PACK)', 'DUTCH LADY 0-12/123/456 850GM (3PACK)', 225.00, 'https://cf.shopee.com.my/file/5759a6207e69c38ddb9931bcf56e4081', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (173, '0-12Y Seluar Tidur Budak / Seluar Panjang Budak Perempuan Loose Cut Kids Long Pant Casual Cotton', '0-12Y Seluar Tidur Budak / Seluar Panjang Budak Perempuan Loose Cut Kids Long Pant Casual Cotton', '0-12Y Seluar Tidur Budak / Seluar Panjang Budak Perempuan Loose Cut Kids Long Pant Casual Cotton', 29.90, 'https://cf.shopee.com.my/file/634119e40d1160586efb2406edfc80a1', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (174, 'Plastic Lutsinar OPP Nipis (0.04) [4x6.5] 200pcs/pkt with seal - Stok Tempatan!', 'Plastic Lutsinar OPP Nipis (0.04) [4x6.5] 200pcs/pkt with seal - Stok Tempatan!', 'Plastic Lutsinar OPP Nipis (0.04) [4x6.5] 200pcs/pkt with seal - Stok Tempatan!', 230.00, 'https://cf.shopee.com.my/file/276084b8527ca967f21b99cf9d9015a7', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (175, 'WD My Passport 1TB / 2TB / 4TB / 5TB Portable External Hard Disk Drive HDD USB3.0 Red / Blue / Black / White', 'WD My Passport 1TB / 2TB / 4TB / 5TB Portable External Hard Disk Drive HDD USB3.0 Red / Blue / Black / White', 'WD My Passport 1TB / 2TB / 4TB / 5TB Portable External Hard Disk Drive HDD USB3.0 Red / Blue / Black / White', 2390.00, 'https://cf.shopee.com.my/file/c335923d5d33ae3927d9fd772d4ab3b4', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (176, '[1TB/2TB/4TB] TOSHIBA CANVIO BASIC 2.5\" EXT EXTERNAL HARDDISK HARD DRIVE SUPERSPEED USB3.0 PORTABLE HARD DISK FREE POUCH', '[1TB/2TB/4TB] TOSHIBA CANVIO BASIC 2.5\" EXT EXTERNAL HARDDISK HARD DRIVE SUPERSPEED USB3.0 PORTABLE HARD DISK FREE POUCH', '[1TB/2TB/4TB] TOSHIBA CANVIO BASIC 2.5\" EXT EXTERNAL HARDDISK HARD DRIVE SUPERSPEED USB3.0 PORTABLE HARD DISK FREE POUCH', 1650.00, 'https://cf.shopee.com.my/file/92131b66de33162759d0ca9b6143ba70', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (182, 'VIVO Y71 3+32GB Used Fullset (One year warranty) Conditions 95% New (6.0 inch / Dual Sim)', 'VIVO Y71 3+32GB Used Fullset (One year warranty) Conditions 95% New (6.0 inch / Dual Sim)', 'VIVO Y71 3+32GB Used Fullset (One year warranty) Conditions 95% New (6.0 inch / Dual Sim)', 2380.00, 'https://cf.shopee.com.my/file/1bd1e141dde942e331bfcb11af723caf', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (183, 'TINYTECH USB2.0 TRANSPARENT LAPTOP / NOTEBOOK COOLER PAD 1 BIG FAN W/ LED LIGHT (P1)', 'TINYTECH USB2.0 TRANSPARENT LAPTOP / NOTEBOOK COOLER PAD 1 BIG FAN W/ LED LIGHT (P1)', 'TINYTECH USB2.0 TRANSPARENT LAPTOP / NOTEBOOK COOLER PAD 1 BIG FAN W/ LED LIGHT (P1)', 139.00, 'https://cf.shopee.com.my/file/e65ad003521b50dec7e8fecbbf2e2651', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (184, 'Avent Ultra Air Baby Soother 0-6 Month Twin Pack Ultra Soft Single Loose', 'Avent Ultra Air Baby Soother 0-6 Month Twin Pack Ultra Soft Single Loose', 'Avent Ultra Air Baby Soother 0-6 Month Twin Pack Ultra Soft Single Loose', 147.90, 'https://cf.shopee.com.my/file/196905b158267b7b6616b0078fbf939f', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (185, 'Cleanrance Stock Kain Pasang Paloma Twill Cotton Silk Sangat Lembut Cotton Soffy Cotton Bidang 58 Harga Utk 0.5m', 'Cleanrance Stock Kain Pasang Paloma Twill Cotton Silk Sangat Lembut Cotton Soffy Cotton Bidang 58 Harga Utk 0.5m', 'Cleanrance Stock Kain Pasang Paloma Twill Cotton Silk Sangat Lembut Cotton Soffy Cotton Bidang 58 Harga Utk 0.5m', 42.80, 'https://cf.shopee.com.my/file/f1391791ffd453531a0cb2656ae55a58', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (186, 'Plastic Lutsinar PP Nipis (0.04) [7x10] 2kg/pkt - Stok Tempatan!', 'Plastic Lutsinar PP Nipis (0.04) [7x10] 2kg/pkt - Stok Tempatan!', 'Plastic Lutsinar PP Nipis (0.04) [7x10] 2kg/pkt - Stok Tempatan!', 250.00, 'https://cf.shopee.com.my/file/19452a80297bc755def6046ba878aa15', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (187, 'Maiwo 2.5\" SATA HDD & SSD USB3.0 Enclosure (K104)', 'Maiwo 2.5\" SATA HDD & SSD USB3.0 Enclosure (K104)', 'Maiwo 2.5\" SATA HDD & SSD USB3.0 Enclosure (K104)', 269.00, 'https://cf.shopee.com.my/file/77ec2f92425e3f6198220415a0028fa0', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (188, 'Clinical Medical Science Lab Test Glass Tube Tiub Kaca 12cm x 0.7cm 120mm Multipurpose Creative Art DIY Decoration', 'Clinical Medical Science Lab Test Glass Tube Tiub Kaca 12cm x 0.7cm 120mm Multipurpose Creative Art DIY Decoration', 'Clinical Medical Science Lab Test Glass Tube Tiub Kaca 12cm x 0.7cm 120mm Multipurpose Creative Art DIY Decoration', 9.00, 'https://cf.shopee.com.my/file/7bc8464bc919da13ee8e052e0eccc7e6', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (189, 'Faber Castell / Faber-Castell Click Ball Pen X5 0.5mm X7 0.7mm', 'Faber Castell / Faber-Castell Click Ball Pen X5 0.5mm X7 0.7mm', 'Faber Castell / Faber-Castell Click Ball Pen X5 0.5mm X7 0.7mm', 4.70, 'https://cf.shopee.com.my/file/bb85adaec0e9a7c3cff5b45769a38843', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (191, 'READY STOCK - DESSINI 6L ELECTRIC PRESSURE COOKER ALUMINUM NON STICK POT MULTI FUNCTION PRE PROGRAMMED 6.0  BIG CAPACITY', 'READY STOCK - DESSINI 6L ELECTRIC PRESSURE COOKER ALUMINUM NON STICK POT MULTI FUNCTION PRE PROGRAMMED 6.0  BIG CAPACITY', 'READY STOCK - DESSINI 6L ELECTRIC PRESSURE COOKER ALUMINUM NON STICK POT MULTI FUNCTION PRE PROGRAMMED 6.0  BIG CAPACITY', 1458.40, 'https://cf.shopee.com.my/file/43133994e2be5115077866f9f9bfcf5c', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (192, 'BAWAL ANTI KEDUT SPECIAL EDITION 9.0', 'BAWAL ANTI KEDUT SPECIAL EDITION 9.0', 'BAWAL ANTI KEDUT SPECIAL EDITION 9.0', 270.00, 'https://cf.shopee.com.my/file/9f0d6dd2ecb7519eb7caec6fa4ed75be', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (193, 'NUK - Sensitive 100% Silicone Soother Pacifier (0-6Months/ 6-18Months)', 'NUK - Sensitive 100% Silicone Soother Pacifier (0-6Months/ 6-18Months)', 'NUK - Sensitive 100% Silicone Soother Pacifier (0-6Months/ 6-18Months)', 298.00, 'https://cf.shopee.com.my/file/342aa6a5170093247eff9c27191d442a', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (194, 'M&G Office G Gel Pen AGP13271 0.5mm', 'M&G Office G Gel Pen AGP13271 0.5mm', 'M&G Office G Gel Pen AGP13271 0.5mm', 8.50, 'https://cf.shopee.com.my/file/f5198df711fa6d4b2ad74121bcb27698', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (196, 'Philips Avent NIGHT TIME Soother/ Pacifier [ 0-6m/ 6-18m ] Nighttime Puting Kosong Classic / Berry Ultra Air', 'Philips Avent NIGHT TIME Soother/ Pacifier [ 0-6m/ 6-18m ] Nighttime Puting Kosong Classic / Berry Ultra Air', 'Philips Avent NIGHT TIME Soother/ Pacifier [ 0-6m/ 6-18m ] Nighttime Puting Kosong Classic / Berry Ultra Air', 335.00, 'https://cf.shopee.com.my/file/eb9f68d9fd2ffb45a41637030c501e3f', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (197, 'Philips Avent ANIMAL Soother/ Pacifier [ 0-6m/ 6-18m/ 18m+ ] Puting Kosong', 'Philips Avent ANIMAL Soother/ Pacifier [ 0-6m/ 6-18m/ 18m+ ] Puting Kosong', 'Philips Avent ANIMAL Soother/ Pacifier [ 0-6m/ 6-18m/ 18m+ ] Puting Kosong', 359.00, 'https://cf.shopee.com.my/file/1d40b42610052eb308dd5ee949c59953', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (198, 'Urara Story Monthly Color Contact Lenses FREE Lens Case (Power 0 to -6.00 half yearly lens)', 'Urara Story Monthly Color Contact Lenses FREE Lens Case (Power 0 to -6.00 half yearly lens)', 'Urara Story Monthly Color Contact Lenses FREE Lens Case (Power 0 to -6.00 half yearly lens)', 50.00, 'https://cf.shopee.com.my/file/fa3ed25d38e2c67c707c7ded9ec53d05', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (199, '0-5Y \"LC&TF 2\" Baby Kid Set Pajamas Shirt+Pants Boy Girl Sleepwear', '0-5Y \"LC&TF 2\" Baby Kid Set Pajamas Shirt+Pants Boy Girl Sleepwear', '0-5Y \"LC&TF 2\" Baby Kid Set Pajamas Shirt+Pants Boy Girl Sleepwear', 67.90, 'https://cf.shopee.com.my/file/68fe06b33a3936262225e06d80e85a0e', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (200, 'ASROCK A320M-HDV r4.0 Combo AMD RYZEN CPU', 'ASROCK A320M-HDV r4.0 Combo AMD RYZEN CPU', 'ASROCK A320M-HDV r4.0 Combo AMD RYZEN CPU', 1790.00, 'https://cf.shopee.com.my/file/d21a4d39823680b534e9ece7343bcb7e', 1627909650, 1, 1);
INSERT INTO `xy_goods_list` VALUES (201, 'ASROCK A320M-HDV r4.0 Combo AMD RYZEN CPU', 'ASROCK A320M-HDV r4.0 Combo AMD RYZEN CPU', 'ASROCK A320M-HDV r4.0 Combo AMD RYZEN CPU', 1790.00, 'https://cf.shopee.com.my/file/d21a4d39823680b534e9ece7343bcb7e', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (203, 'MUJI Style 3 Colors 0.5mm Water-based Pen Gel Pen Black/Red/Blue Ink Pen Maker Pen Stationery For Students', 'MUJI Style 3 Colors 0.5mm Water-based Pen Gel Pen Black/Red/Blue Ink Pen Maker Pen Stationery For Students', 'MUJI Style 3 Colors 0.5mm Water-based Pen Gel Pen Black/Red/Blue Ink Pen Maker Pen Stationery For Students', 8.40, 'https://cf.shopee.com.my/file/ad18ab852563acc9c6af1830a6bbed46', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (204, 'Trading Card Album v2.0 - BoBoiBoy Galaxy Card', 'Trading Card Album v2.0 - BoBoiBoy Galaxy Card', 'Trading Card Album v2.0 - BoBoiBoy Galaxy Card', 179.10, 'https://cf.shopee.com.my/file/0d6bb98a3603a2ad42635de280a8b74a', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (205, 'Faber-Castell True Gel Pen 0.38mm 0.5mm 0.7mm / Faber Castell Truegel Pen', 'Faber-Castell True Gel Pen 0.38mm 0.5mm 0.7mm / Faber Castell Truegel Pen', 'Faber-Castell True Gel Pen 0.38mm 0.5mm 0.7mm / Faber Castell Truegel Pen', 17.80, 'https://cf.shopee.com.my/file/b19ac938712bc7a4e68b55ac055c29d4', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (206, 'Nevoks - Feelin / Pagee OCC Coil - SPL 10 - 0.6 / 0.8 / 1.0 - 5 Pieces / 1 Box', 'Nevoks - Feelin / Pagee OCC Coil - SPL 10 - 0.6 / 0.8 / 1.0 - 5 Pieces / 1 Box', 'Nevoks - Feelin / Pagee OCC Coil - SPL 10 - 0.6 / 0.8 / 1.0 - 5 Pieces / 1 Box', 450.00, 'https://cf.shopee.com.my/file/0ea8c69b20521562fe8b864bba29df63', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (207, 'PalingKeras. Bubble Wrap 0.5M X 0.5M / 0.5M X 1M / 1M X 1M Single & Double Layer. Rolls & Sheet. Clear & Black Color.', 'PalingKeras. Bubble Wrap 0.5M X 0.5M / 0.5M X 1M / 1M X 1M Single & Double Layer. Rolls & Sheet. Clear & Black Color.', 'PalingKeras. Bubble Wrap 0.5M X 0.5M / 0.5M X 1M / 1M X 1M Single & Double Layer. Rolls & Sheet. Clear & Black Color.', 5.60, 'https://cf.shopee.com.my/file/84813924006642f0e426f901951c4866', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (208, 'Contact Lens Nudy 16mm 0-800 POWER', 'Contact Lens Nudy 16mm 0-800 POWER', 'Contact Lens Nudy 16mm 0-800 POWER', 100.00, 'https://cf.shopee.com.my/file/70e62d4d4031871132ef5cf719e91d96', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (209, 'Khind Mini Chopper (0.6 L) FPC900', 'Khind Mini Chopper (0.6 L) FPC900', 'Khind Mini Chopper (0.6 L) FPC900', 630.00, 'https://cf.shopee.com.my/file/5eb27792c2244ac786c0d74e0e5afeab', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (210, '100% Original DD Live Flavor Ready Stock !!!3.0', '100% Original DD Live Flavor Ready Stock !!!3.0', '100% Original DD Live Flavor Ready Stock !!!3.0', 288.80, 'https://cf.shopee.com.my/file/3ceb099eb1f2304d8e8ecc00ceb0bc31', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (211, 'Bubble Wrap PE Foam 0.5m (50cm) x 10m / 1m x 5m BLUECON', 'Bubble Wrap PE Foam 0.5m (50cm) x 10m / 1m x 5m BLUECON', 'Bubble Wrap PE Foam 0.5m (50cm) x 10m / 1m x 5m BLUECON', 49.90, 'https://cf.shopee.com.my/file/f4da3c8c717a2296b836803e76a59068', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (212, '3 in 1 Capsule Coffee Machine Compatible with Nespresso Dolce Gusto Coffee Powder 19 Bar Pressure 0.6L Mesin Kopi', '3 in 1 Capsule Coffee Machine Compatible with Nespresso Dolce Gusto Coffee Powder 19 Bar Pressure 0.6L Mesin Kopi', '3 in 1 Capsule Coffee Machine Compatible with Nespresso Dolce Gusto Coffee Powder 19 Bar Pressure 0.6L Mesin Kopi', 3299.00, 'https://cf.shopee.com.my/file/974e933b660b3dd96e726c2af046d980', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (213, 'Faber-Castell RX Gel Colour Pen 0.7mm RXGel Green, Gold, Purple, Turquoise, Pink Pen Colourful Color Faber Castell RX7', 'Faber-Castell RX Gel Colour Pen 0.7mm RXGel Green, Gold, Purple, Turquoise, Pink Pen Colourful Color Faber Castell RX7', 'Faber-Castell RX Gel Colour Pen 0.7mm RXGel Green, Gold, Purple, Turquoise, Pink Pen Colourful Color Faber Castell RX7', 14.50, 'https://cf.shopee.com.my/file/07169af15b07cbe5894014b1630a0b1d', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (214, '(READY STOCK) 0-90% Brix Refractometer Sugar ContentTester (JUICE/JAM/HONEY/LIQUID SWEETENER)', '(READY STOCK) 0-90% Brix Refractometer Sugar ContentTester (JUICE/JAM/HONEY/LIQUID SWEETENER)', '(READY STOCK) 0-90% Brix Refractometer Sugar ContentTester (JUICE/JAM/HONEY/LIQUID SWEETENER)', 449.00, 'https://cf.shopee.com.my/file/62e01d470df2123414a7c63e510b8a61', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (215, '1pcs 5x20mm (5x20) Quick Blow Glass Tube Fuse 250V 0.1A 0.2A 0.5A 1A 1.5A 2A 3A 4A 5A 8A 10A 12A 15A 20A 30A', '1pcs 5x20mm (5x20) Quick Blow Glass Tube Fuse 250V 0.1A 0.2A 0.5A 1A 1.5A 2A 3A 4A 5A 8A 10A 12A 15A 20A 30A', '1pcs 5x20mm (5x20) Quick Blow Glass Tube Fuse 250V 0.1A 0.2A 0.5A 1A 1.5A 2A 3A 4A 5A 8A 10A 12A 15A 20A 30A', 1.80, 'https://cf.shopee.com.my/file/5d0dc9a6256f0348d77734d0dce7e65d', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (216, 'Twin Tip Permanent Marker Pen Fine Point Waterproof Ink Thin Nib Crude Nib Black Ink 0.5mm-2mm Fine Color', 'Twin Tip Permanent Marker Pen Fine Point Waterproof Ink Thin Nib Crude Nib Black Ink 0.5mm-2mm Fine Color', 'Twin Tip Permanent Marker Pen Fine Point Waterproof Ink Thin Nib Crude Nib Black Ink 0.5mm-2mm Fine Color', 4.20, 'https://cf.shopee.com.my/file/7bbeb21476af799b37ec073b0a402a2c', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (218, '100% ORIGINAL VULCAN REPLACEMENT COIL COMPATIBLE WITH VOOPOO VINCI / VINCI X / VINCI AIR OCC 0.3OHM', '100% ORIGINAL VULCAN REPLACEMENT COIL COMPATIBLE WITH VOOPOO VINCI / VINCI X / VINCI AIR OCC 0.3OHM', '100% ORIGINAL VULCAN REPLACEMENT COIL COMPATIBLE WITH VOOPOO VINCI / VINCI X / VINCI AIR OCC 0.3OHM', 65.00, 'https://cf.shopee.com.my/file/0f3eb550e02b948a4b719d30bbe60fa4', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (219, 'Micro Titanium Needle Derma Roller 0.25mm,0.5mm,1.0mm,2.5mm (Ready Stock)', 'Micro Titanium Needle Derma Roller 0.25mm,0.5mm,1.0mm,2.5mm (Ready Stock)', 'Micro Titanium Needle Derma Roller 0.25mm,0.5mm,1.0mm,2.5mm (Ready Stock)', 125.00, 'https://cf.shopee.com.my/file/7c7132d24f6fbb9bf5778a09404353c5', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (221, 'Baby Toy Sozzy 2pcs Wrist Rattle, 2pcs Foot Finder (0-6months)', 'Baby Toy Sozzy 2pcs Wrist Rattle, 2pcs Foot Finder (0-6months)', 'Baby Toy Sozzy 2pcs Wrist Rattle, 2pcs Foot Finder (0-6months)', 69.90, 'https://cf.shopee.com.my/file/9accc6ef27402bf6fa83fe51086df6bf', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (222, 'Plastic Lutsinar PP Nipis (0.04) [6x9] 200pcs/pkt with Seal - Stok Tempatan!', 'Plastic Lutsinar PP Nipis (0.04) [6x9] 200pcs/pkt with Seal - Stok Tempatan!', 'Plastic Lutsinar PP Nipis (0.04) [6x9] 200pcs/pkt with Seal - Stok Tempatan!', 240.00, 'https://cf.shopee.com.my/file/57627ec3d2b4ca775b2b0e806949ed68', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (223, 'Faber Castell Faber-Castell School & Office Retractable RX Gel Pen Black Blue Red 0.5mm 0.7mm', 'Faber Castell Faber-Castell School & Office Retractable RX Gel Pen Black Blue Red 0.5mm 0.7mm', 'Faber Castell Faber-Castell School & Office Retractable RX Gel Pen Black Blue Red 0.5mm 0.7mm', 13.00, 'https://cf.shopee.com.my/file/c4fa2751f0d42c7dde62c8329880750e', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (225, 'Winzige Clearance SALE Gel Pen 0.35/0.38/0.5mm Black Blue Ink Pen Office School Writing Student Supplies', 'Winzige Clearance SALE Gel Pen 0.35/0.38/0.5mm Black Blue Ink Pen Office School Writing Student Supplies', 'Winzige Clearance SALE Gel Pen 0.35/0.38/0.5mm Black Blue Ink Pen Office School Writing Student Supplies', 6.30, 'https://cf.shopee.com.my/file/9c156b481aafe0ac05b27efb9e44d450', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (226, 'SHARP INVERTER AIRCOND R32 1.0 HP [AHX9VED]', 'SHARP INVERTER AIRCOND R32 1.0 HP [AHX9VED]', 'SHARP INVERTER AIRCOND R32 1.0 HP [AHX9VED]', 9690.00, 'https://cf.shopee.com.my/file/18a09d58dc51d0ea4e1654ba515c75a2', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (227, '0-8Years Kids Baby Girls Cotton Leggings Socks Children Babygirl Elastic Waist Tights Pant', '0-8Years Kids Baby Girls Cotton Leggings Socks Children Babygirl Elastic Waist Tights Pant', '0-8Years Kids Baby Girls Cotton Leggings Socks Children Babygirl Elastic Waist Tights Pant', 99.00, 'https://cf.shopee.com.my/file/6f60f2aa91cab5005ac5b5e59d5147b8', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (228, 'M&G R3/R5 Gel Pen (12pcs/Box) Refill 0.5/0.7 (20pcs/Box)', 'M&G R3/R5 Gel Pen (12pcs/Box) Refill 0.5/0.7 (20pcs/Box)', 'M&G R3/R5 Gel Pen (12pcs/Box) Refill 0.5/0.7 (20pcs/Box)', 110.00, 'https://cf.shopee.com.my/file/16baf77878cc9066c1179f410285fb8a', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (229, 'Faster Shine CX1076 Ball Pen 0.7mm (1pcs)', 'Faster Shine CX1076 Ball Pen 0.7mm (1pcs)', 'Faster Shine CX1076 Ball Pen 0.7mm (1pcs)', 6.30, 'https://cf.shopee.com.my/file/d585b20e4cf7f272c2fa9bd33548f970', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (230, '1pcs 1/2/3/4/5-Bit 7 Segment Red LED Display (0.56 Inch 0.56\" Digi Word Size ) (CC, Common Cathode / CA, Common Anode)', '1pcs 1/2/3/4/5-Bit 7 Segment Red LED Display (0.56 Inch 0.56\" Digi Word Size ) (CC, Common Cathode / CA, Common Anode)', '1pcs 1/2/3/4/5-Bit 7 Segment Red LED Display (0.56 Inch 0.56\" Digi Word Size ) (CC, Common Cathode / CA, Common Anode)', 6.00, 'https://cf.shopee.com.my/file/32cdcf956963470c1fb5aa244ff98f00', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (231, 'GLOBAL VERSION Xiaomi Mi TV Stick 9.0 /MI BOX S TV FHD Android TV 8.1 + Chromecast 1GB RAM + 8GB ROM 5G WiFi', 'GLOBAL VERSION Xiaomi Mi TV Stick 9.0 /MI BOX S TV FHD Android TV 8.1 + Chromecast 1GB RAM + 8GB ROM 5G WiFi', 'GLOBAL VERSION Xiaomi Mi TV Stick 9.0 /MI BOX S TV FHD Android TV 8.1 + Chromecast 1GB RAM + 8GB ROM 5G WiFi', 1479.00, 'https://cf.shopee.com.my/file/7894240684432a849f6112b9ad76a14b', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (232, '0-4Years Newborn Baby Girls Floral Princess Dress Babygirl Kids Tutu Dresses', '0-4Years Newborn Baby Girls Floral Princess Dress Babygirl Kids Tutu Dresses', '0-4Years Newborn Baby Girls Floral Princess Dress Babygirl Kids Tutu Dresses', 169.00, 'https://cf.shopee.com.my/file/94e24e694bef4dba24a2efebd19d8be6', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (233, 'Pineng PN-986 Portable QC3.0 + PD Fast Charging Small Power Bank (10000mAh)', 'Pineng PN-986 Portable QC3.0 + PD Fast Charging Small Power Bank (10000mAh)', 'Pineng PN-986 Portable QC3.0 + PD Fast Charging Small Power Bank (10000mAh)', 449.00, 'https://cf.shopee.com.my/file/c9faa6ea92f60fa2481b96d0fade3e11', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (234, 'EVISU Bluetooth Wireless Earphone Earpods v5.0', 'EVISU Bluetooth Wireless Earphone Earpods v5.0', 'EVISU Bluetooth Wireless Earphone Earpods v5.0', 149.00, 'https://cf.shopee.com.my/file/e38266bceed61f9d2a90814b1955206d', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (236, '[2m X 0.5m=1unit Jointed Roll] Artificial Grass/ Rumput Karpet/ Artificial Grass Carpet Outdoor/ Artificial Grass Roll', '[2m X 0.5m=1unit Jointed Roll] Artificial Grass/ Rumput Karpet/ Artificial Grass Carpet Outdoor/ Artificial Grass Roll', '[2m X 0.5m=1unit Jointed Roll] Artificial Grass/ Rumput Karpet/ Artificial Grass Carpet Outdoor/ Artificial Grass Roll', 79.90, 'https://cf.shopee.com.my/file/a8ac8f50db1fa1f110bbddb1e1aefb64', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (237, 'Original Geekvape Aegis Boost / Aegis Boost Plus / Hero  Replacement Occ 0.4 Ohm Mesh / Occ 0.6 Ohm Mesh', 'Original Geekvape Aegis Boost / Aegis Boost Plus / Hero  Replacement Occ 0.4 Ohm Mesh / Occ 0.6 Ohm Mesh', 'Original Geekvape Aegis Boost / Aegis Boost Plus / Hero  Replacement Occ 0.4 Ohm Mesh / Occ 0.6 Ohm Mesh', 350.00, 'https://cf.shopee.com.my/file/76ecb3063df0c467e76158ae9ab08a89', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (238, 'Children\'S Holes / HIJAB Children / Children\'s Holster / Children HIJAB / Children Holster 0-3 Years Old / Big Lace', 'Children\'S Holes / HIJAB Children / Children\'s Holster / Children HIJAB / Children Holster 0-3 Years Old / Big Lace', 'Children\'S Holes / HIJAB Children / Children\'s Holster / Children HIJAB / Children Holster 0-3 Years Old / Big Lace', 59.70, 'https://cf.shopee.com.my/file/f58c4bb5b3f2975a52def91726de9e1a', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (240, 'Normal saline 0.9% IV BP 500ml', 'Normal saline 0.9% IV BP 500ml', 'Normal saline 0.9% IV BP 500ml', 29.20, 'https://cf.shopee.com.my/file/59b4f2b616dd76ad287452fc0c604765', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (241, '(0-3m) BAJU BABY NEWBORN / Baju Baby Murah / Baby Clothing / baju baby girl baju baby boy / BABY CLOTHING SUIT MYKIDS V2', '(0-3m) BAJU BABY NEWBORN / Baju Baby Murah / Baby Clothing / baju baby girl baju baby boy / BABY CLOTHING SUIT MYKIDS V2', '(0-3m) BAJU BABY NEWBORN / Baju Baby Murah / Baby Clothing / baju baby girl baju baby boy / BABY CLOTHING SUIT MYKIDS V2', 84.00, 'https://cf.shopee.com.my/file/1df952d9c3ea816823a86eda83fd9b8f', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (242, 'LiGeek F10w Wireless  Powerbank 10000mAh 18W PD Output QC 3.0  Dual Fast Charging  Wireless Charger', 'LiGeek F10w Wireless  Powerbank 10000mAh 18W PD Output QC 3.0  Dual Fast Charging  Wireless Charger', 'LiGeek F10w Wireless  Powerbank 10000mAh 18W PD Output QC 3.0  Dual Fast Charging  Wireless Charger', 299.00, 'https://cf.shopee.com.my/file/69ef0e29cc52179e8a25e5182386acfc', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (243, 'Gel Pens - 9 Colors, 0.8MM Fine Tip White Gel Pen Set for Artists, Black Paper', 'Gel Pens - 9 Colors, 0.8MM Fine Tip White Gel Pen Set for Artists, Black Paper', 'Gel Pens - 9 Colors, 0.8MM Fine Tip White Gel Pen Set for Artists, Black Paper', 10.90, 'https://cf.shopee.com.my/file/7f4023493faea9641f18e4fd18769bd4', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (245, 'Zebra Sarasa Push Clip Gel Pen -0.5 mm -Vintage Color (5 Colors Available)', 'Zebra Sarasa Push Clip Gel Pen -0.5 mm -Vintage Color (5 Colors Available)', 'Zebra Sarasa Push Clip Gel Pen -0.5 mm -Vintage Color (5 Colors Available)', 39.00, 'https://cf.shopee.com.my/file/94e5718cd4326c7ad96aa16c6d3ba173', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (246, '2Litre 2000ml Sanitizer . 0% Alcohol, Can use Spray , Fogging Gun, Hands sanitizer, Multi Surface Disinfectant', '2Litre 2000ml Sanitizer . 0% Alcohol, Can use Spray , Fogging Gun, Hands sanitizer, Multi Surface Disinfectant', '2Litre 2000ml Sanitizer . 0% Alcohol, Can use Spray , Fogging Gun, Hands sanitizer, Multi Surface Disinfectant', 138.00, 'https://cf.shopee.com.my/file/1859727391affce93141636551120b30', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (247, 'Innisfree Auto Eyebrow Pencil 0.3g [GLAM]', 'Innisfree Auto Eyebrow Pencil 0.3g [GLAM]', 'Innisfree Auto Eyebrow Pencil 0.3g [GLAM]', 90.00, 'https://cf.shopee.com.my/file/3964556a1ad469c019f3eddeadd82a0d', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (249, '0.02MM TO 1.00MM 17 BLADES FEELER GAUGE THICKNESS MEASUREMENT TOOLS PISTON RULLER UKURAN VALVE ADJUSTER TOOL ROCKER ARM', '0.02MM TO 1.00MM 17 BLADES FEELER GAUGE THICKNESS MEASUREMENT TOOLS PISTON RULLER UKURAN VALVE ADJUSTER TOOL ROCKER ARM', '0.02MM TO 1.00MM 17 BLADES FEELER GAUGE THICKNESS MEASUREMENT TOOLS PISTON RULLER UKURAN VALVE ADJUSTER TOOL ROCKER ARM', 88.90, 'https://cf.shopee.com.my/file/b979ceb10ef931467b77beb312f87525', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (251, 'Lace Newborn Baby Socks Princess Solid Baby Girl Socks 0-1 Years', 'Lace Newborn Baby Socks Princess Solid Baby Girl Socks 0-1 Years', 'Lace Newborn Baby Socks Princess Solid Baby Girl Socks 0-1 Years', 29.50, 'https://cf.shopee.com.my/file/a0c64f5c68d64ae5dcc2a27622bfd391', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (254, 'PRO IDOL BROWN CONTACT LENS C150-1/C150-1-3 NORMAL EYE LENS 14MM 0 DEGREE (FREE CASING) KANTA LEKAP', 'PRO IDOL BROWN CONTACT LENS C150-1/C150-1-3 NORMAL EYE LENS 14MM 0 DEGREE (FREE CASING) KANTA LEKAP', 'PRO IDOL BROWN CONTACT LENS C150-1/C150-1-3 NORMAL EYE LENS 14MM 0 DEGREE (FREE CASING) KANTA LEKAP', 84.90, 'https://cf.shopee.com.my/file/5f64cd37cd5bc16b8bdd910d1f92387a', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (255, 'MUJI Style 0.5mm Water-based Pen Gel Pen Black/Red/Blue Ink Pen Maker Pen  Stationery For Students', 'MUJI Style 0.5mm Water-based Pen Gel Pen Black/Red/Blue Ink Pen Maker Pen  Stationery For Students', 'MUJI Style 0.5mm Water-based Pen Gel Pen Black/Red/Blue Ink Pen Maker Pen  Stationery For Students', 7.50, 'https://cf.shopee.com.my/file/549b69e2c9ba50d84e7fcf8ebfbf2246', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (257, 'Faber Castell Click X5 Ball Pen 0.5MM- Blue-0582', 'Faber Castell Click X5 Ball Pen 0.5MM- Blue-0582', 'Faber Castell Click X5 Ball Pen 0.5MM- Blue-0582', 21.00, 'https://cf.shopee.com.my/file/b466a631c41b6c89576b91d97837e74b', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (259, 'Original NEVOKS FEELIN POD KIT / OCC SP10 MESH COIL Feelin  Occ Feelin Coil Feelin Cartridge Nevoks Coil Occ/0.6/1.0', 'Original NEVOKS FEELIN POD KIT / OCC SP10 MESH COIL Feelin  Occ Feelin Coil Feelin Cartridge Nevoks Coil Occ/0.6/1.0', 'Original NEVOKS FEELIN POD KIT / OCC SP10 MESH COIL Feelin  Occ Feelin Coil Feelin Cartridge Nevoks Coil Occ/0.6/1.0', 80.00, 'https://cf.shopee.com.my/file/462104a397dcc08ebf1a4ddd2f2d191d', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (260, 'Gsoft W2 Ball Pen 0.5mm 0.7mm 1.0mm Blue Black Red', 'Gsoft W2 Ball Pen 0.5mm 0.7mm 1.0mm Blue Black Red', 'Gsoft W2 Ball Pen 0.5mm 0.7mm 1.0mm Blue Black Red', 6.30, 'https://cf.shopee.com.my/file/5d6aba8c9f354eb38fbca6110c3f753a', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (262, 'SATA 3.0 6Gbps L Shaped / Straight Serial ATA Data Cable SATA III With Clip For SSD HDD', 'SATA 3.0 6Gbps L Shaped / Straight Serial ATA Data Cable SATA III With Clip For SSD HDD', 'SATA 3.0 6Gbps L Shaped / Straight Serial ATA Data Cable SATA III With Clip For SSD HDD', 19.90, 'https://cf.shopee.com.my/file/64504ff5369dd63a4a7408c365bd71c4', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (263, '0-4Y Kids Baby Boys Mickey T Shirt + Pants Set Child Cartoon Clothes Suit Set', '0-4Y Kids Baby Boys Mickey T Shirt + Pants Set Child Cartoon Clothes Suit Set', '0-4Y Kids Baby Boys Mickey T Shirt + Pants Set Child Cartoon Clothes Suit Set', 163.30, 'https://cf.shopee.com.my/file/8e251a575e3a15c834f8f544c9e68bdf', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (264, 'PD12-PD30 New Stock Hot Kain Pasang Premium Diamond Sonata Satin 0.5m Bidang 58/60', 'PD12-PD30 New Stock Hot Kain Pasang Premium Diamond Sonata Satin 0.5m Bidang 58/60', 'PD12-PD30 New Stock Hot Kain Pasang Premium Diamond Sonata Satin 0.5m Bidang 58/60', 56.90, 'https://cf.shopee.com.my/file/46334bcec51f27340dbcaf2f16198b05', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (265, '3D 4K 8K HD UHD HDMI Cable v2.0/v2.1 2160p Gold Plate Head 1.5/3/5 Meter', '3D 4K 8K HD UHD HDMI Cable v2.0/v2.1 2160p Gold Plate Head 1.5/3/5 Meter', '3D 4K 8K HD UHD HDMI Cable v2.0/v2.1 2160p Gold Plate Head 1.5/3/5 Meter', 219.00, 'https://cf.shopee.com.my/file/f4370dfc041f78793ebbdf501a4e495a', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (266, 'M&G G-5i GEL PEN REFILL 0.5  R3 /Changli U-8 Gel Ink Pen Refill 0.5mm (Price for 1pc)', 'M&G G-5i GEL PEN REFILL 0.5  R3 /Changli U-8 Gel Ink Pen Refill 0.5mm (Price for 1pc)', 'M&G G-5i GEL PEN REFILL 0.5  R3 /Changli U-8 Gel Ink Pen Refill 0.5mm (Price for 1pc)', 5.60, 'https://cf.shopee.com.my/file/57c9159b696f09a4c464e4d6858fdeb7', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (267, 'NIEKI BALL POINT PEN 0.7mm/Ready Stock', 'NIEKI BALL POINT PEN 0.7mm/Ready Stock', 'NIEKI BALL POINT PEN 0.7mm/Ready Stock', 2.20, 'https://cf.shopee.com.my/file/a2795eb73ef74489d6b2bab39246ec9b', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (268, 'M&G Gel Pen Refill R3/R5 0.5mm/0.7mm - (1\'pc)', 'M&G Gel Pen Refill R3/R5 0.5mm/0.7mm - (1\'pc)', 'M&G Gel Pen Refill R3/R5 0.5mm/0.7mm - (1\'pc)', 6.40, 'https://cf.shopee.com.my/file/fdf8e0a01cb684342b486660bd15b549', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (269, 'Comfortable and Soft Baby Cap With Cute Mickey Cartoon (0-6 Mths)', 'Comfortable and Soft Baby Cap With Cute Mickey Cartoon (0-6 Mths)', 'Comfortable and Soft Baby Cap With Cute Mickey Cartoon (0-6 Mths)', 76.00, 'https://cf.shopee.com.my/file/b53699daf686fde1127b8c58442e6f89', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (270, 'Plastic Lutsinar PP Nipis (0.04) [8x11] 2kg/pkt - Stok Tempatan!', 'Plastic Lutsinar PP Nipis (0.04) [8x11] 2kg/pkt - Stok Tempatan!', 'Plastic Lutsinar PP Nipis (0.04) [8x11] 2kg/pkt - Stok Tempatan!', 250.00, 'https://cf.shopee.com.my/file/469b2529dd562e03afa8494be259d198', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (271, 'High quality fountain pen set with disposable blue and black ink cartidge refills 0.5mm iraurita ink pen Replaceable stylo plume School office supplies stationery', 'High quality fountain pen set with disposable blue and black ink cartidge refills 0.5mm iraurita ink pen Replaceable stylo plume School office supplies stationery', 'High quality fountain pen set with disposable blue and black ink cartidge refills 0.5mm iraurita ink pen Replaceable stylo plume School office supplies stationery', 25.00, 'https://cf.shopee.com.my/file/d64712560dd9a9232a6a28bf6ad87140', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (272, 'TOPK I1015P 18W QC3.0 10000mAh Powerbank Quick Charge Light Display Backup Battery', 'TOPK I1015P 18W QC3.0 10000mAh Powerbank Quick Charge Light Display Backup Battery', 'TOPK I1015P 18W QC3.0 10000mAh Powerbank Quick Charge Light Display Backup Battery', 299.90, 'https://cf.shopee.com.my/file/59e975c28cbf03c379cfbf1a01efb8ae', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (273, 'Gasless Wire 1kg 0.8mm Flux Cored Gasless Mig Welding Wire', 'Gasless Wire 1kg 0.8mm Flux Cored Gasless Mig Welding Wire', 'Gasless Wire 1kg 0.8mm Flux Cored Gasless Mig Welding Wire', 195.00, 'https://cf.shopee.com.my/file/ee688e9e0d1f94c5fb99d76d214fd9a3', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (275, '0-8Years Summer Sweet Kids Baby Girls Sleeveless Dress Cotton Printing Princess Dresses', '0-8Years Summer Sweet Kids Baby Girls Sleeveless Dress Cotton Printing Princess Dresses', '0-8Years Summer Sweet Kids Baby Girls Sleeveless Dress Cotton Printing Princess Dresses', 89.80, 'https://cf.shopee.com.my/file/b4cf294f1ccdd2c0b77bc6fb2cd2f24c', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (276, 'Faber-Castell RX Gel Pen 0.5mm / 0.7mm RXGel Faber Castell RX7 X5', 'Faber-Castell RX Gel Pen 0.5mm / 0.7mm RXGel Faber Castell RX7 X5', 'Faber-Castell RX Gel Pen 0.5mm / 0.7mm RXGel Faber Castell RX7 X5', 11.50, 'https://cf.shopee.com.my/file/82207f106569915730d73da4a09953fc', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (277, '*HOT* *NEW* Desire 14mm Natural Size Contact Lens/Color Lens Original Korea Lens ( Power 0-1000 )', '*HOT* *NEW* Desire 14mm Natural Size Contact Lens/Color Lens Original Korea Lens ( Power 0-1000 )', '*HOT* *NEW* Desire 14mm Natural Size Contact Lens/Color Lens Original Korea Lens ( Power 0-1000 )', 98.00, 'https://cf.shopee.com.my/file/f289325af806e9eba36592aa896f27a8', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (279, 'Original Voopoo Drag S / Vinci /  Vinci X / Vinci Air / Find S / Drag X Replacement Coil 5pcs Occ 0.15 / 0.2 / 0.3 / 0.6', 'Original Voopoo Drag S / Vinci /  Vinci X / Vinci Air / Find S / Drag X Replacement Coil 5pcs Occ 0.15 / 0.2 / 0.3 / 0.6', 'Original Voopoo Drag S / Vinci /  Vinci X / Vinci Air / Find S / Drag X Replacement Coil 5pcs Occ 0.15 / 0.2 / 0.3 / 0.6', 380.00, 'https://cf.shopee.com.my/file/64be5a12a3fcb10457229573ef2b9fc6', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (281, '(0-12Y) Cuff Kids Long Pants Boy & Girl / Seluar Panjang Budak Bercekak Unisex Cotton (Kids Jogger @ Jogger Budak)', '(0-12Y) Cuff Kids Long Pants Boy & Girl / Seluar Panjang Budak Bercekak Unisex Cotton (Kids Jogger @ Jogger Budak)', '(0-12Y) Cuff Kids Long Pants Boy & Girl / Seluar Panjang Budak Bercekak Unisex Cotton (Kids Jogger @ Jogger Budak)', 39.90, 'https://cf.shopee.com.my/file/aca4e1f9f1c1fb001755b15f5c6b1d82', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (283, 'Pilot Ball Pen 0.7mm / 1.0mm BP-1 RT', 'Pilot Ball Pen 0.7mm / 1.0mm BP-1 RT', 'Pilot Ball Pen 0.7mm / 1.0mm BP-1 RT', 10.00, 'https://cf.shopee.com.my/file/ee57ea4cfea2112da0a1d31fd3724a00', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (284, 'RESTOCK!! CHEAPEST!!!! 0-4Years Old Baby Legging Baby Tight Legging Children Pants Plain Boy Girl Pantyhose', 'RESTOCK!! CHEAPEST!!!! 0-4Years Old Baby Legging Baby Tight Legging Children Pants Plain Boy Girl Pantyhose', 'RESTOCK!! CHEAPEST!!!! 0-4Years Old Baby Legging Baby Tight Legging Children Pants Plain Boy Girl Pantyhose', 129.00, 'https://cf.shopee.com.my/file/505397817d9674105009038e25eeaa48', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (285, 'M&G Black Gel Pen 0.5MM-0317', 'M&G Black Gel Pen 0.5MM-0317', 'M&G Black Gel Pen 0.5MM-0317', 21.00, 'https://cf.shopee.com.my/file/cc058d12e41827967e2033581c8fd44a', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (286, '(READY STOCK) SUGAR 0-32% / SALINITY 0-28% 2 WAY TESTER REFRACTOMETER', '(READY STOCK) SUGAR 0-32% / SALINITY 0-28% 2 WAY TESTER REFRACTOMETER', '(READY STOCK) SUGAR 0-32% / SALINITY 0-28% 2 WAY TESTER REFRACTOMETER', 531.10, 'https://cf.shopee.com.my/file/08db751d8bac8f868d677d2dce7b754e', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (287, 'TB21-TB40 Kain Pasang Original Toyobo Cotton Japan Bidang 58\' Harga Utk 0.5m German Cotton Egyptian Cotton', 'TB21-TB40 Kain Pasang Original Toyobo Cotton Japan Bidang 58\' Harga Utk 0.5m German Cotton Egyptian Cotton', 'TB21-TB40 Kain Pasang Original Toyobo Cotton Japan Bidang 58\' Harga Utk 0.5m German Cotton Egyptian Cotton', 46.90, 'https://cf.shopee.com.my/file/118c5f97df579fb447ba74e0290c0ec8', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (288, '0-4mm or 0-6.5mm Flexible Shaft Flexi Shaft For Electric Drill Grinder 6mm 3mm Rotary Tool Porting Polishing Tool', '0-4mm or 0-6.5mm Flexible Shaft Flexi Shaft For Electric Drill Grinder 6mm 3mm Rotary Tool Porting Polishing Tool', '0-4mm or 0-6.5mm Flexible Shaft Flexi Shaft For Electric Drill Grinder 6mm 3mm Rotary Tool Porting Polishing Tool', 69.00, 'https://cf.shopee.com.my/file/59aa5379a908196a13d3553ab354300a', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (289, 'READY STOCK NEVOKS EMPTY CATRIDGE/OCC 0.6/1.0 FAST SHIPPING 100% ORIGINAL', 'READY STOCK NEVOKS EMPTY CATRIDGE/OCC 0.6/1.0 FAST SHIPPING 100% ORIGINAL', 'READY STOCK NEVOKS EMPTY CATRIDGE/OCC 0.6/1.0 FAST SHIPPING 100% ORIGINAL', 110.00, 'https://cf.shopee.com.my/file/220b123e8c9434db9df826bb0ce66d85', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (290, 'Tefal Travel Mug - 0.36L (Berry Sleeve Stainless Steel ) ( K30851 )', 'Tefal Travel Mug - 0.36L (Berry Sleeve Stainless Steel ) ( K30851 )', 'Tefal Travel Mug - 0.36L (Berry Sleeve Stainless Steel ) ( K30851 )', 790.00, 'https://cf.shopee.com.my/file/023be25efdf1f50c77348342bbb66f37', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (291, 'PsDs 0.7mm ABS Webcam Camera Cover Privacy Protection for Smart Phone iPhone iPad Tablet NoteBook MacBook Mat', 'PsDs 0.7mm ABS Webcam Camera Cover Privacy Protection for Smart Phone iPhone iPad Tablet NoteBook MacBook Mat', 'PsDs 0.7mm ABS Webcam Camera Cover Privacy Protection for Smart Phone iPhone iPad Tablet NoteBook MacBook Mat', 16.00, 'https://cf.shopee.com.my/file/ff72b1c5fea7b8385e98803853ee3399', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (292, '[The Ordinary] Retinol 0.2% in Squalane / Retinol 0.5% in Squalane / Retinol 1% in Squalane', '[The Ordinary] Retinol 0.2% in Squalane / Retinol 0.5% in Squalane / Retinol 1% in Squalane', '[The Ordinary] Retinol 0.2% in Squalane / Retinol 0.5% in Squalane / Retinol 1% in Squalane', 338.00, 'https://cf.shopee.com.my/file/5f00262217dfe8ade357e22a89786d34', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (293, 'MALL HDMI 2.1 8K 60Hz Cable V2.0 Dolby Vision Atmos UHD HDR 4K 120Hz eARC ARC to DP v2.1 PS4 PS5 Xbox S X High Speed 2.0', 'MALL HDMI 2.1 8K 60Hz Cable V2.0 Dolby Vision Atmos UHD HDR 4K 120Hz eARC ARC to DP v2.1 PS4 PS5 Xbox S X High Speed 2.0', 'MALL HDMI 2.1 8K 60Hz Cable V2.0 Dolby Vision Atmos UHD HDR 4K 120Hz eARC ARC to DP v2.1 PS4 PS5 Xbox S X High Speed 2.0', 212.00, 'https://cf.shopee.com.my/file/5ff4f2229dfb3ac30f3b6ed4c3507da9', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (294, 'Plastic Lutsinar PP Nipis (0.04) [4x6] 2kg/pkt - Stok Tempatan!', 'Plastic Lutsinar PP Nipis (0.04) [4x6] 2kg/pkt - Stok Tempatan!', 'Plastic Lutsinar PP Nipis (0.04) [4x6] 2kg/pkt - Stok Tempatan!', 250.00, 'https://cf.shopee.com.my/file/9a1762d105be9965415044977b54ab6c', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (295, 'Faber Castell / Faber-Castell Z Mechanical Pencil Tekan 0.5mm 0.7mm', 'Faber Castell / Faber-Castell Z Mechanical Pencil Tekan 0.5mm 0.7mm', 'Faber Castell / Faber-Castell Z Mechanical Pencil Tekan 0.5mm 0.7mm', 27.50, 'https://cf.shopee.com.my/file/dec8dc1cda0ca1a8fbe0951141a6310a', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (297, '0-15Y Kid Set Pajamas Shirt+Pants Boy Girl Sleepwear 1', '0-15Y Kid Set Pajamas Shirt+Pants Boy Girl Sleepwear 1', '0-15Y Kid Set Pajamas Shirt+Pants Boy Girl Sleepwear 1', 85.00, 'https://cf.shopee.com.my/file/bdcb314f5b9d09185a3518c2dc6eaa88', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (298, 'Creative Press Gel Pens Cute Macaron Signing Pens 0.5mm Colored Neutral Pens For Kids Girls School Supplies Stationery', 'Creative Press Gel Pens Cute Macaron Signing Pens 0.5mm Colored Neutral Pens For Kids Girls School Supplies Stationery', 'Creative Press Gel Pens Cute Macaron Signing Pens 0.5mm Colored Neutral Pens For Kids Girls School Supplies Stationery', 1.90, 'https://cf.shopee.com.my/file/9ab377cc0d627fc7df36c9adcedf2f9e', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (299, 'Newborn baby wear ~ infant suit,baju set bayi baru lahir,color or white 0 to 12bulan', 'Newborn baby wear ~ infant suit,baju set bayi baru lahir,color or white 0 to 12bulan', 'Newborn baby wear ~ infant suit,baju set bayi baru lahir,color or white 0 to 12bulan', 49.00, 'https://cf.shopee.com.my/file/a7103e918d3a7a7ab9b95327f958dc2e', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (300, 'Meinkind Athena ISOFIX 0 - 25kg 8 years old Convertible Baby Car Seat JPJ MIROS ECE R44/04 Certified Kerusi Kereta Bayi', 'Meinkind Athena ISOFIX 0 - 25kg 8 years old Convertible Baby Car Seat JPJ MIROS ECE R44/04 Certified Kerusi Kereta Bayi', 'Meinkind Athena ISOFIX 0 - 25kg 8 years old Convertible Baby Car Seat JPJ MIROS ECE R44/04 Certified Kerusi Kereta Bayi', 1990.00, 'https://cf.shopee.com.my/file/df9bb1b193eb236d3dedeace0b94cfdb', 1627909651, 1, 1);
INSERT INTO `xy_goods_list` VALUES (301, 'Montessori Baby Flash Card Baby Visual Stimulus Cards 0-36 Months Baby Vision Early Education Card Pictures Card', 'Montessori Baby Flash Card Baby Visual Stimulus Cards 0-36 Months Baby Vision Early Education Card Pictures Card', 'Montessori Baby Flash Card Baby Visual Stimulus Cards 0-36 Months Baby Vision Early Education Card Pictures Card', 59.90, 'https://cf.shopee.com.my/file/95224c9db4518921cd0ca2a497ac1554', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (303, 'Pilot Frixion Clicker Erasable Roller Ball Gel Pen 0.5mm/0.7mm', 'Pilot Frixion Clicker Erasable Roller Ball Gel Pen 0.5mm/0.7mm', 'Pilot Frixion Clicker Erasable Roller Ball Gel Pen 0.5mm/0.7mm', 57.00, 'https://cf.shopee.com.my/file/11c29764bb84ba08ce031b3bf776fef8', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (304, 'Boys\' shirt suit 0-4-year-old Summer Boys\' cotton shirt + pants 2-piece set', 'Boys\' shirt suit 0-4-year-old Summer Boys\' cotton shirt + pants 2-piece set', 'Boys\' shirt suit 0-4-year-old Summer Boys\' cotton shirt + pants 2-piece set', 121.30, 'https://cf.shopee.com.my/file/96462350342197acaaf6cc25dafd5b3c', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (305, '0-7Years Cute Baby Girls Knitted Cotton Tights Ankle Length Stockings Pantyhose Elastic Leggings Pants', '0-7Years Cute Baby Girls Knitted Cotton Tights Ankle Length Stockings Pantyhose Elastic Leggings Pants', '0-7Years Cute Baby Girls Knitted Cotton Tights Ankle Length Stockings Pantyhose Elastic Leggings Pants', 130.80, 'https://cf.shopee.com.my/file/0ea55503a11fe94362720a29e9387203', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (306, 'Creative Press Gel Pens Cute Macaron Signing Pens 0.5mm Colored Neutral Pens For Kids Girls School Supplies Stationery', 'Creative Press Gel Pens Cute Macaron Signing Pens 0.5mm Colored Neutral Pens For Kids Girls School Supplies Stationery', 'Creative Press Gel Pens Cute Macaron Signing Pens 0.5mm Colored Neutral Pens For Kids Girls School Supplies Stationery', 1.90, 'https://cf.shopee.com.my/file/9ab377cc0d627fc7df36c9adcedf2f9e', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (307, 'Tommee Tippee CTN Night Time Baby Pacifier Soother 0-6/6-18 mths Single Loose/Twin Pack', 'Tommee Tippee CTN Night Time Baby Pacifier Soother 0-6/6-18 mths Single Loose/Twin Pack', 'Tommee Tippee CTN Night Time Baby Pacifier Soother 0-6/6-18 mths Single Loose/Twin Pack', 99.00, 'https://cf.shopee.com.my/file/f5c73c60cf6ba3d4e65c0bd1ef4c9633', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (309, '<Loose Cut-Feet> Air Cond Copper Pipe 1/4 , 3/8 , 1/2 Inch X 0.61mm SIRIM Approved Copper Tube Air Cond Piping', '<Loose Cut-Feet> Air Cond Copper Pipe 1/4 , 3/8 , 1/2 Inch X 0.61mm SIRIM Approved Copper Tube Air Cond Piping', '<Loose Cut-Feet> Air Cond Copper Pipe 1/4 , 3/8 , 1/2 Inch X 0.61mm SIRIM Approved Copper Tube Air Cond Piping', 27.00, 'https://cf.shopee.com.my/file/50a4247fd2ca7701b6ea4ac777e7d37e', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (310, 'Wenbo Deli Retractable 0.7mm Ballpoint Pen Blue Black [Per Box] EQ00330', 'Wenbo Deli Retractable 0.7mm Ballpoint Pen Blue Black [Per Box] EQ00330', 'Wenbo Deli Retractable 0.7mm Ballpoint Pen Blue Black [Per Box] EQ00330', 56.00, 'https://cf.shopee.com.my/file/d0dc9e22383c5e739f414121b528a67a', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (311, '[PnP Ready Stock] Buncho 0.5 2B Pencil Lead Hi-Polymer 0.5mm x 70mm / Mata Pencil Ubat / 4in1 Set', '[PnP Ready Stock] Buncho 0.5 2B Pencil Lead Hi-Polymer 0.5mm x 70mm / Mata Pencil Ubat / 4in1 Set', '[PnP Ready Stock] Buncho 0.5 2B Pencil Lead Hi-Polymer 0.5mm x 70mm / Mata Pencil Ubat / 4in1 Set', 7.40, 'https://cf.shopee.com.my/file/db85d816c1958a9dba77bdb507de2308', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (312, '[GLOBAL VERSION] TV Stick / Mstick TV FHD Android TV 9.0 + Chromecast 1GB RAM + 8GB ROM 5G WiFi', '[GLOBAL VERSION] TV Stick / Mstick TV FHD Android TV 9.0 + Chromecast 1GB RAM + 8GB ROM 5G WiFi', '[GLOBAL VERSION] TV Stick / Mstick TV FHD Android TV 9.0 + Chromecast 1GB RAM + 8GB ROM 5G WiFi', 1790.00, 'https://cf.shopee.com.my/file/dd7e2cd49ae4076637192dbe782c6b29', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (313, 'Harris Copper Brazing Alloy Rod (500mm) 0% Silver Phos Copper Rod Welding Rod Brazing Rod Mapp Gas', 'Harris Copper Brazing Alloy Rod (500mm) 0% Silver Phos Copper Rod Welding Rod Brazing Rod Mapp Gas', 'Harris Copper Brazing Alloy Rod (500mm) 0% Silver Phos Copper Rod Welding Rod Brazing Rod Mapp Gas', 14.00, 'https://cf.shopee.com.my/file/d534a26a539cbc4a313b2fc0ed3843ed', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (314, 'Estee Lauder Advanced Night Repair Synchronized Recovery Complex II 0.24oz/7ml', 'Estee Lauder Advanced Night Repair Synchronized Recovery Complex II 0.24oz/7ml', 'Estee Lauder Advanced Night Repair Synchronized Recovery Complex II 0.24oz/7ml', 430.00, 'https://cf.shopee.com.my/file/228fc2167bf68bf025be41d1bda0f4a4', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (315, 'Pilot G2 Roller Ball Pen Refill 0.38/0.5/0.7/1.0mm-Per Piece', 'Pilot G2 Roller Ball Pen Refill 0.38/0.5/0.7/1.0mm-Per Piece', 'Pilot G2 Roller Ball Pen Refill 0.38/0.5/0.7/1.0mm-Per Piece', 27.90, 'https://cf.shopee.com.my/file/6812e6a85dc61fcbf8a2c834a5d1646c', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (317, '0.3M High Speed HDMI Extension Cable Male to Female V1.4 3D Full HD 1080P', '0.3M High Speed HDMI Extension Cable Male to Female V1.4 3D Full HD 1080P', '0.3M High Speed HDMI Extension Cable Male to Female V1.4 3D Full HD 1080P', 73.80, 'https://cf.shopee.com.my/file/e4c639d2234dd310fed37b95e6a7d6de', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (319, 'Jarum Kait Aluminum (2.0-6.0mm)/Aluminum Crochet Hook (2.0mm-6.0mm)', 'Jarum Kait Aluminum (2.0-6.0mm)/Aluminum Crochet Hook (2.0mm-6.0mm)', 'Jarum Kait Aluminum (2.0-6.0mm)/Aluminum Crochet Hook (2.0mm-6.0mm)', 20.00, 'https://cf.shopee.com.my/file/23c940acc29c5d242a4c408ab33d71aa', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (320, '1PCS T10 LED bulb car light W5W Car LED 194 168 W5W CANBUS  26SMD Car LED 4014 2.5W 0.2A Non polar Auto Wedge Tail Side Bulb reading plate lamp', '1PCS T10 LED bulb car light W5W Car LED 194 168 W5W CANBUS  26SMD Car LED 4014 2.5W 0.2A Non polar Auto Wedge Tail Side Bulb reading plate lamp', '1PCS T10 LED bulb car light W5W Car LED 194 168 W5W CANBUS  26SMD Car LED 4014 2.5W 0.2A Non polar Auto Wedge Tail Side Bulb reading plate lamp', 28.00, 'https://cf.shopee.com.my/file/e998a443a5e20a1f4241bece946b57b3', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (323, '1pcs Freshkon Fusion Daily Color Shimering Grey - 0.00 to -5.00 (1 Pc)', '1pcs Freshkon Fusion Daily Color Shimering Grey - 0.00 to -5.00 (1 Pc)', '1pcs Freshkon Fusion Daily Color Shimering Grey - 0.00 to -5.00 (1 Pc)', 20.50, 'https://cf.shopee.com.my/file/9330c11e786146b567055c912dc43b92', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (324, 'Pilot BP-1 RT Ball Pen - 0.7/1.0MM Black/Blue/Red BP1-RT BP1RT', 'Pilot BP-1 RT Ball Pen - 0.7/1.0MM Black/Blue/Red BP1-RT BP1RT', 'Pilot BP-1 RT Ball Pen - 0.7/1.0MM Black/Blue/Red BP1-RT BP1RT', 10.00, 'https://cf.shopee.com.my/file/817b9db8828a28a207bbbdfde53c33e1', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (325, 'School RBT Kipas Solar Use 0.33W 5.5V 80mA Big Polycrystalline Panel with Red & Black Wires 60mm X 80mm', 'School RBT Kipas Solar Use 0.33W 5.5V 80mA Big Polycrystalline Panel with Red & Black Wires 60mm X 80mm', 'School RBT Kipas Solar Use 0.33W 5.5V 80mA Big Polycrystalline Panel with Red & Black Wires 60mm X 80mm', 15.00, 'https://cf.shopee.com.my/file/200da2c8c64981ce862f26fa6b983361', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (326, 'QC 3.0+2.4A DUAL OUTPUT QC3.0 FAST CHARGING QUALCOM  FAST TRAVAL CHARGER WITH CN UK EUROP PLUG', 'QC 3.0+2.4A DUAL OUTPUT QC3.0 FAST CHARGING QUALCOM  FAST TRAVAL CHARGER WITH CN UK EUROP PLUG', 'QC 3.0+2.4A DUAL OUTPUT QC3.0 FAST CHARGING QUALCOM  FAST TRAVAL CHARGER WITH CN UK EUROP PLUG', 320.00, 'https://cf.shopee.com.my/file/d295e8299fd461d4f53ee7ec577fa4fe', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (327, 'M&G Retractable Gel Pen R3=0.5mm R5=0.7mm Black Blue Red AGP02372', 'M&G Retractable Gel Pen R3=0.5mm R5=0.7mm Black Blue Red AGP02372', 'M&G Retractable Gel Pen R3=0.5mm R5=0.7mm Black Blue Red AGP02372', 10.80, 'https://cf.shopee.com.my/file/b8c8744c60b1581af094c7720395c831', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (328, 'Faber Castell NX23 Ball Pen 0.5MM- Blue-0584', 'Faber Castell NX23 Ball Pen 0.5MM- Blue-0584', 'Faber Castell NX23 Ball Pen 0.5MM- Blue-0584', 21.00, 'https://cf.shopee.com.my/file/c4d7438af86911a9d95f04811bb19b66', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (329, '*Original* Pilot BP-1 RT ball pen 0.7mm 1.0mm Black Blue Red BP-1RT BP1RT', '*Original* Pilot BP-1 RT ball pen 0.7mm 1.0mm Black Blue Red BP-1RT BP1RT', '*Original* Pilot BP-1 RT ball pen 0.7mm 1.0mm Black Blue Red BP-1RT BP1RT', 9.80, 'https://cf.shopee.com.my/file/30860fbbb6e05ad12e677829b656b8b6', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (332, 'Cotton German TOYOBO - Bidang 58\" - Harga utk 0.5mtr (setengah meter)', 'Cotton German TOYOBO - Bidang 58\" - Harga utk 0.5mtr (setengah meter)', 'Cotton German TOYOBO - Bidang 58\" - Harga utk 0.5mtr (setengah meter)', 50.40, 'https://cf.shopee.com.my/file/cbc8c7b83f989f6d03b2e606ccf3ff09', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (333, 'CC42-CC45 Premium Heavy Como Crepe 58 Kain Pasang Ela (Harga utk 0.5m) For Raya 2021', 'CC42-CC45 Premium Heavy Como Crepe 58 Kain Pasang Ela (Harga utk 0.5m) For Raya 2021', 'CC42-CC45 Premium Heavy Como Crepe 58 Kain Pasang Ela (Harga utk 0.5m) For Raya 2021', 28.80, 'https://cf.shopee.com.my/file/eb5e8eb71922f43577b127776bd187ca', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (334, 'TUDUNG SARUNG INSTANT BOKITA CORAK l ORIGINAL I AWNING SCUBA I PINLESS I IRONLESS I MOSSCREPE I BOKITA UQASHA ROSE 2.0', 'TUDUNG SARUNG INSTANT BOKITA CORAK l ORIGINAL I AWNING SCUBA I PINLESS I IRONLESS I MOSSCREPE I BOKITA UQASHA ROSE 2.0', 'TUDUNG SARUNG INSTANT BOKITA CORAK l ORIGINAL I AWNING SCUBA I PINLESS I IRONLESS I MOSSCREPE I BOKITA UQASHA ROSE 2.0', 235.00, 'https://cf.shopee.com.my/file/af6a275c60cd25bfe21740ca9586b66e', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (335, 'STARWELD 1 KG X 0.8MM MIG WIRE (GASLESS)', 'STARWELD 1 KG X 0.8MM MIG WIRE (GASLESS)', 'STARWELD 1 KG X 0.8MM MIG WIRE (GASLESS)', 189.70, 'https://cf.shopee.com.my/file/6c628fe779c3d3d72d566d034cdc1bf2', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (337, 'Multipurpose PVC Transparent Binding Plastic Cover A4/Quality PVC Rigid Sheet 0.2mm - 1 pc', 'Multipurpose PVC Transparent Binding Plastic Cover A4/Quality PVC Rigid Sheet 0.2mm - 1 pc', 'Multipurpose PVC Transparent Binding Plastic Cover A4/Quality PVC Rigid Sheet 0.2mm - 1 pc', 4.50, 'https://cf.shopee.com.my/file/70083242f9f8a4a0da18eb9b5157bfa6', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (338, 'C-MALL Mute Silent Wireless Mouse Optical Bluetooth5.0 Adjustable Rechargeable Dual Mode2.4g Mouse PC Laptop Office Game', 'C-MALL Mute Silent Wireless Mouse Optical Bluetooth5.0 Adjustable Rechargeable Dual Mode2.4g Mouse PC Laptop Office Game', 'C-MALL Mute Silent Wireless Mouse Optical Bluetooth5.0 Adjustable Rechargeable Dual Mode2.4g Mouse PC Laptop Office Game', 168.40, 'https://cf.shopee.com.my/file/80014074ad126cc868ee482a02082178', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (339, 'M&G R3/R5 Retractable Gel Pen 0.5 / 0.7mm Bullet Nib', 'M&G R3/R5 Retractable Gel Pen 0.5 / 0.7mm Bullet Nib', 'M&G R3/R5 Retractable Gel Pen 0.5 / 0.7mm Bullet Nib', 13.00, 'https://cf.shopee.com.my/file/c0042eeab013d68a5320c03fc96a3842', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (341, 'Artline 041T Twin / Dual Tip Permanent Marker Pen 0.4mm & 1mm Black Blue Red', 'Artline 041T Twin / Dual Tip Permanent Marker Pen 0.4mm & 1mm Black Blue Red', 'Artline 041T Twin / Dual Tip Permanent Marker Pen 0.4mm & 1mm Black Blue Red', 25.50, 'https://cf.shopee.com.my/file/ca152e85590e33b6d576e73f592a7d9c', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (342, '(Ready Stock) Wireless Bluetooth Headphone In ear Earphone Earplug Electric Quantity Display Touch Headset Hi-Fi P20 Pro Double V5.0 for Apple Huawei Xiaomi', '(Ready Stock) Wireless Bluetooth Headphone In ear Earphone Earplug Electric Quantity Display Touch Headset Hi-Fi P20 Pro Double V5.0 for Apple Huawei Xiaomi', '(Ready Stock) Wireless Bluetooth Headphone In ear Earphone Earplug Electric Quantity Display Touch Headset Hi-Fi P20 Pro Double V5.0 for Apple Huawei Xiaomi', 708.00, 'https://cf.shopee.com.my/file/fd352bcef53165588703f2334d543c46', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (343, 'New Stock!! KF94 / KN95 Baby Face Mask 4 ply 0 1 2 3 4 5 12 years old Korea Version Disposable 4D Kids Mask 5 pcs', 'New Stock!! KF94 / KN95 Baby Face Mask 4 ply 0 1 2 3 4 5 12 years old Korea Version Disposable 4D Kids Mask 5 pcs', 'New Stock!! KF94 / KN95 Baby Face Mask 4 ply 0 1 2 3 4 5 12 years old Korea Version Disposable 4D Kids Mask 5 pcs', 64.30, 'https://cf.shopee.com.my/file/2c1e3e23650e8fb8f82e8bbbc7eed68d', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (344, '0-4Y \"BY\" Baby Kid Set Pajamas Shirt+Pant Boy Girl Sleepwear', '0-4Y \"BY\" Baby Kid Set Pajamas Shirt+Pant Boy Girl Sleepwear', '0-4Y \"BY\" Baby Kid Set Pajamas Shirt+Pant Boy Girl Sleepwear', 120.00, 'https://cf.shopee.com.my/file/be2c3c77f6a64697a73ca8c34da71403', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (346, 'JOO HUAT 0.5mm / 0.7mm Zhidi 3116 Mechanical Pencil', 'JOO HUAT 0.5mm / 0.7mm Zhidi 3116 Mechanical Pencil', 'JOO HUAT 0.5mm / 0.7mm Zhidi 3116 Mechanical Pencil', 6.10, 'https://cf.shopee.com.my/file/6a49156338110601a10407d494347ad0', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (347, 'The Ordinary Retinol 0.2 0.5 1.0% Granactive Retinoid 2% 5% Emulsion Squalane', 'The Ordinary Retinol 0.2 0.5 1.0% Granactive Retinoid 2% 5% Emulsion Squalane', 'The Ordinary Retinol 0.2 0.5 1.0% Granactive Retinoid 2% 5% Emulsion Squalane', 373.00, 'https://cf.shopee.com.my/file/a723f18eceb8461fc293d89d89103556', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (348, '3 in 1 Capsule Coffee Machine Compatible with Nespresso Dolce Gusto Coffee Powder 19 Bar Pressure 0.6L Mesin Kopi', '3 in 1 Capsule Coffee Machine Compatible with Nespresso Dolce Gusto Coffee Powder 19 Bar Pressure 0.6L Mesin Kopi', '3 in 1 Capsule Coffee Machine Compatible with Nespresso Dolce Gusto Coffee Powder 19 Bar Pressure 0.6L Mesin Kopi', 3299.00, 'https://cf.shopee.com.my/file/26fcfa8fde7b77c41fd95ddb8ef16d49', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (349, 'WSS 130 mini motor DC3V-12V Hobby Micro Motors DC 0.35-0.4A Mini motor', 'WSS 130 mini motor DC3V-12V Hobby Micro Motors DC 0.35-0.4A Mini motor', 'WSS 130 mini motor DC3V-12V Hobby Micro Motors DC 0.35-0.4A Mini motor', 12.00, 'https://cf.shopee.com.my/file/a0d654453b781be8633d4c67c91e63bb', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (351, 'AirPods i12 TWS Wireless Bluetooth5.0 HiFi Earbuds Touch Control For Iphone and Android Phone inpods Macaron', 'AirPods i12 TWS Wireless Bluetooth5.0 HiFi Earbuds Touch Control For Iphone and Android Phone inpods Macaron', 'AirPods i12 TWS Wireless Bluetooth5.0 HiFi Earbuds Touch Control For Iphone and Android Phone inpods Macaron', 113.90, 'https://cf.shopee.com.my/file/bd95d15dc09c996b72a0c781775c6a7c', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (352, '[Grab2Go] Pencil Leads - STABILO Mechanical Pencil Leads (0.5mm) Pack of 4', '[Grab2Go] Pencil Leads - STABILO Mechanical Pencil Leads (0.5mm) Pack of 4', '[Grab2Go] Pencil Leads - STABILO Mechanical Pencil Leads (0.5mm) Pack of 4', 22.00, 'https://cf.shopee.com.my/file/5c952e4c3996bd911f7071795c3108b5', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (353, 'M&G Retractable Gel Pen R3 0.5mm R5 0.7mm Black, Blue, Red AGP02372', 'M&G Retractable Gel Pen R3 0.5mm R5 0.7mm Black, Blue, Red AGP02372', 'M&G Retractable Gel Pen R3 0.5mm R5 0.7mm Black, Blue, Red AGP02372', 10.00, 'https://cf.shopee.com.my/file/c4e5aa8e015654d898a6a20f136d9ef1', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (354, '*Original* Pilot Ball Liner 0.8mm Black', '*Original* Pilot Ball Liner 0.8mm Black', '*Original* Pilot Ball Liner 0.8mm Black', 29.90, 'https://cf.shopee.com.my/file/e05a945953cc65d2ef4e1f32084b1971', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (356, '0.9mm Rel Langsir Aluminium Set Lengkap Jenis Single (0.9mm Aluminium Curtain Rail/ Track Single Complete Set)', '0.9mm Rel Langsir Aluminium Set Lengkap Jenis Single (0.9mm Aluminium Curtain Rail/ Track Single Complete Set)', '0.9mm Rel Langsir Aluminium Set Lengkap Jenis Single (0.9mm Aluminium Curtain Rail/ Track Single Complete Set)', 69.90, 'https://cf.shopee.com.my/file/3034e314dca5c8d2355d76a4505a829c', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (357, 'Polarizer TV Film Polarizing 19/29/24/32/37/42/46/47/49/52/55/60inch 0/90 Degree LCD Led Repair Tv Replacement Film original in stock', 'Polarizer TV Film Polarizing 19/29/24/32/37/42/46/47/49/52/55/60inch 0/90 Degree LCD Led Repair Tv Replacement Film original in stock', 'Polarizer TV Film Polarizing 19/29/24/32/37/42/46/47/49/52/55/60inch 0/90 Degree LCD Led Repair Tv Replacement Film original in stock', 265.00, 'https://cf.shopee.com.my/file/9df1960804ab680f84817448564de1f1', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (358, 'Zhi Xin Lovein Test Good Gel Pen / Ink 0.5mm (G-2501 / ZX-205)', 'Zhi Xin Lovein Test Good Gel Pen / Ink 0.5mm (G-2501 / ZX-205)', 'Zhi Xin Lovein Test Good Gel Pen / Ink 0.5mm (G-2501 / ZX-205)', 5.00, 'https://cf.shopee.com.my/file/4d7735354f0aeee1c3b090bac44c722a', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (360, '150mm 6 inch LCD Digital Electronic Carbon Fiber Caliper Gauge Micrometer 0-6\" Range', '150mm 6 inch LCD Digital Electronic Carbon Fiber Caliper Gauge Micrometer 0-6\" Range', '150mm 6 inch LCD Digital Electronic Carbon Fiber Caliper Gauge Micrometer 0-6\" Range', 101.90, 'https://cf.shopee.com.my/file/7e2178add825f3fdec7aa64b86d8804e', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (362, '0.2/0.25/0.3/0.4/0.5/0.6/0.8/1mm Silver Gold Color Alloy Cord Beading Wire DIY Craft Making Jewelry Cord String Accessories', '0.2/0.25/0.3/0.4/0.5/0.6/0.8/1mm Silver Gold Color Alloy Cord Beading Wire DIY Craft Making Jewelry Cord String Accessories', '0.2/0.25/0.3/0.4/0.5/0.6/0.8/1mm Silver Gold Color Alloy Cord Beading Wire DIY Craft Making Jewelry Cord String Accessories', 15.20, 'https://cf.shopee.com.my/file/f4facea6bfbaff66595ed9e7b9e6773c', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (363, 'Baby Romper Boy Girl Romper Baby Boy Girl Baju Baby Boy Girl 0 to 18months Jumpsuit Baby Baju Baby Lelaki Perempuan', 'Baby Romper Boy Girl Romper Baby Boy Girl Baju Baby Boy Girl 0 to 18months Jumpsuit Baby Baju Baby Lelaki Perempuan', 'Baby Romper Boy Girl Romper Baby Boy Girl Baju Baby Boy Girl 0 to 18months Jumpsuit Baby Baju Baby Lelaki Perempuan', 84.50, 'https://cf.shopee.com.my/file/fa0f7b588c8af02232b706e51d68dac7', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (364, '1pcs Freshkon Alluring Daily Color Magnetic Grey - 0.00 to -5.00 (1 Pc)', '1pcs Freshkon Alluring Daily Color Magnetic Grey - 0.00 to -5.00 (1 Pc)', '1pcs Freshkon Alluring Daily Color Magnetic Grey - 0.00 to -5.00 (1 Pc)', 20.50, 'https://cf.shopee.com.my/file/073af805484233f385f560e62599958d', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (365, '[READY STOCK] OKAZAWA /PECKER House Use Automatic Water Pump  P150 B2 0.5HP (Pump Air) APP Centrifugal Pump GPA-90', '[READY STOCK] OKAZAWA /PECKER House Use Automatic Water Pump  P150 B2 0.5HP (Pump Air) APP Centrifugal Pump GPA-90', '[READY STOCK] OKAZAWA /PECKER House Use Automatic Water Pump  P150 B2 0.5HP (Pump Air) APP Centrifugal Pump GPA-90', 1280.00, 'https://cf.shopee.com.my/file/9dc1109b570478544eebb95a774a4cd0', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (366, 'Faber Castell Ball Pen NX23 0.5mm 0.7mm 1.0mm Black / Blue / Red', 'Faber Castell Ball Pen NX23 0.5mm 0.7mm 1.0mm Black / Blue / Red', 'Faber Castell Ball Pen NX23 0.5mm 0.7mm 1.0mm Black / Blue / Red', 4.50, 'https://cf.shopee.com.my/file/eb6c0c260f71dadf608635ea594f2615', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (367, 'Normal Saline 0.9% IV BP', 'Normal Saline 0.9% IV BP', 'Normal Saline 0.9% IV BP', 27.50, 'https://cf.shopee.com.my/file/37aaa5bb27d211be9ffd1bcf24b2beac', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (368, 'TACKLE GARAGE Slow Fast Jigging Hook J-Pike Stainless Steel 2/0 3/0 4/0 5/0 6/0 HEAVY DUTY', 'TACKLE GARAGE Slow Fast Jigging Hook J-Pike Stainless Steel 2/0 3/0 4/0 5/0 6/0 HEAVY DUTY', 'TACKLE GARAGE Slow Fast Jigging Hook J-Pike Stainless Steel 2/0 3/0 4/0 5/0 6/0 HEAVY DUTY', 3.90, 'https://cf.shopee.com.my/file/c0610a79230d648b1d976116615b2fff', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (369, 'Faber-Castell Ball Pen Click X5 X7 (0.5mm/0.7mm) Black Blue Red 1422 1425 Click X Retractable', 'Faber-Castell Ball Pen Click X5 X7 (0.5mm/0.7mm) Black Blue Red 1422 1425 Click X Retractable', 'Faber-Castell Ball Pen Click X5 X7 (0.5mm/0.7mm) Black Blue Red 1422 1425 Click X Retractable', 6.80, 'https://cf.shopee.com.my/file/139820bf2f528efeb4e97c56252eee0b', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (370, '(0.05sen/Page) A4 BLACK & WHITE, DOUBLE SIDED Printing service | Photocopy | Ebook | Notes | Examspaper | Booklet', '(0.05sen/Page) A4 BLACK & WHITE, DOUBLE SIDED Printing service | Photocopy | Ebook | Notes | Examspaper | Booklet', '(0.05sen/Page) A4 BLACK & WHITE, DOUBLE SIDED Printing service | Photocopy | Ebook | Notes | Examspaper | Booklet', 1.00, 'https://cf.shopee.com.my/file/18cd4c7c9220984a163e546732db90ee', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (371, '[MD Keto] Lakanto 200g monk fruit erythritol sweetener keto 0% sugar low carb low calorie (Exp :  2024)', '[MD Keto] Lakanto 200g monk fruit erythritol sweetener keto 0% sugar low carb low calorie (Exp :  2024)', '[MD Keto] Lakanto 200g monk fruit erythritol sweetener keto 0% sugar low carb low calorie (Exp :  2024)', 149.90, 'https://cf.shopee.com.my/file/9c4b8d7b78f19134b31fe8af27e62c69', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (372, 'ALLUSKIN NEW AHT/TRIAL KIT 2.0/CLEANSER/ALS/ABC', 'ALLUSKIN NEW AHT/TRIAL KIT 2.0/CLEANSER/ALS/ABC', 'ALLUSKIN NEW AHT/TRIAL KIT 2.0/CLEANSER/ALS/ABC', 150.00, 'https://cf.shopee.com.my/file/3b5a60d9c1bbd318a818a749ad12008e', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (373, '100% Original Geekvape Aegis Boost Replacement Coil Occ 0.4 Ohm / 0.6 Ohm For Aegis Boost Cool Gadget', '100% Original Geekvape Aegis Boost Replacement Coil Occ 0.4 Ohm / 0.6 Ohm For Aegis Boost Cool Gadget', '100% Original Geekvape Aegis Boost Replacement Coil Occ 0.4 Ohm / 0.6 Ohm For Aegis Boost Cool Gadget', 350.00, 'https://cf.shopee.com.my/file/254d07fc7bbc4a0cd808e82ed07aa23b', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (375, '1pcs - A4 magnet sheet / thickness: 0.5mm / 1mm / 2mm', '1pcs - A4 magnet sheet / thickness: 0.5mm / 1mm / 2mm', '1pcs - A4 magnet sheet / thickness: 0.5mm / 1mm / 2mm', 25.00, 'https://cf.shopee.com.my/file/5bdc1275114d6c9587475925f5abaa28', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (377, '[ READY STOCK ] Xiaomi Mi Stick TV FHD Android TV 9.0 + Chromecast 1GB RAM + 8GB ROM 5G WiFi [GLOBAL VERSION]', '[ READY STOCK ] Xiaomi Mi Stick TV FHD Android TV 9.0 + Chromecast 1GB RAM + 8GB ROM 5G WiFi [GLOBAL VERSION]', '[ READY STOCK ] Xiaomi Mi Stick TV FHD Android TV 9.0 + Chromecast 1GB RAM + 8GB ROM 5G WiFi [GLOBAL VERSION]', 799.00, 'https://cf.shopee.com.my/file/b4c5d4f5d60bff467dd25aae674942eb', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (378, 'PILOT BP1 BRT BALL PEN (FINE 0.7MM / MEDIUM 1.0MM) *READY STOCK* *100% ORIGINAL*', 'PILOT BP1 BRT BALL PEN (FINE 0.7MM / MEDIUM 1.0MM) *READY STOCK* *100% ORIGINAL*', 'PILOT BP1 BRT BALL PEN (FINE 0.7MM / MEDIUM 1.0MM) *READY STOCK* *100% ORIGINAL*', 11.00, 'https://cf.shopee.com.my/file/c3fe7eff7ae6f21eca2a6099c62a9b77', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (379, '[Malaysia] Gel Pen 0.5mm Black Red Blue Pen Office/School/ Transparent Pen Doorgift Hadiah/Pen Murah', '[Malaysia] Gel Pen 0.5mm Black Red Blue Pen Office/School/ Transparent Pen Doorgift Hadiah/Pen Murah', '[Malaysia] Gel Pen 0.5mm Black Red Blue Pen Office/School/ Transparent Pen Doorgift Hadiah/Pen Murah', 1.20, 'https://cf.shopee.com.my/file/c22e305a4aaded23acb265c13d87d2fa', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (380, 'Original Nevoks Feelin Pod Kit 22W 100mAh 2.8ML Pod Capacity Nevoks Occ 0.6ohm / 1.0ohm Nevoks Yellow Kit', 'Original Nevoks Feelin Pod Kit 22W 100mAh 2.8ML Pod Capacity Nevoks Occ 0.6ohm / 1.0ohm Nevoks Yellow Kit', 'Original Nevoks Feelin Pod Kit 22W 100mAh 2.8ML Pod Capacity Nevoks Occ 0.6ohm / 1.0ohm Nevoks Yellow Kit', 245.00, 'https://cf.shopee.com.my/file/952b1292a0a54ccf9c81e58e93c92a21', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (381, 'EVA Foam (RM 0.60 per sqft)', 'EVA Foam (RM 0.60 per sqft)', 'EVA Foam (RM 0.60 per sqft)', 6.00, 'https://cf.shopee.com.my/file/8f6f118fd2a52102920d839323985712', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (382, '(0.05sen/Page) A4 BLACK & WHITE, DOUBLE SIDED Printing service | Photocopy | Ebook | Notes | Examspaper | Voucher', '(0.05sen/Page) A4 BLACK & WHITE, DOUBLE SIDED Printing service | Photocopy | Ebook | Notes | Examspaper | Voucher', '(0.05sen/Page) A4 BLACK & WHITE, DOUBLE SIDED Printing service | Photocopy | Ebook | Notes | Examspaper | Voucher', 15.00, 'https://cf.shopee.com.my/file/9fdbe82038e4b941a6f3ee1215a757f2', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (383, 'Etude House Drawing Eye Brow 0.25g', 'Etude House Drawing Eye Brow 0.25g', 'Etude House Drawing Eye Brow 0.25g', 75.00, 'https://cf.shopee.com.my/file/af2f9ecffa3f50d6b25e186868d30b32', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (384, 'Zinc / GI Pan Head Machine Screw M4 x 6mm ~ 30mm (Coarse Thread Pitch 0.7mm) (Phillips PH MC Bolt)', 'Zinc / GI Pan Head Machine Screw M4 x 6mm ~ 30mm (Coarse Thread Pitch 0.7mm) (Phillips PH MC Bolt)', 'Zinc / GI Pan Head Machine Screw M4 x 6mm ~ 30mm (Coarse Thread Pitch 0.7mm) (Phillips PH MC Bolt)', 1.00, 'https://cf.shopee.com.my/file/61a0a00c2fc5eaa4dc8039688b21456c', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (385, 'ENFALAC A+ STEP 1 (0-12m) Infant baby milk powder', 'ENFALAC A+ STEP 1 (0-12m) Infant baby milk powder', 'ENFALAC A+ STEP 1 (0-12m) Infant baby milk powder', 780.00, 'https://cf.shopee.com.my/file/487ba54232ad1d711db408196a5e7889', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (386, 'Comocrepe Polkadot Rm5.00 Untuk Potongan  0.5m', 'Comocrepe Polkadot Rm5.00 Untuk Potongan  0.5m', 'Comocrepe Polkadot Rm5.00 Untuk Potongan  0.5m', 50.00, 'https://cf.shopee.com.my/file/fcdf6afd13b27f116ede16c9a7417d9b', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (387, 'Faber Castell NX23 0.5mm Ball Pen', 'Faber Castell NX23 0.5mm Ball Pen', 'Faber Castell NX23 0.5mm Ball Pen', 9.60, 'https://cf.shopee.com.my/file/a2529a353db23afa25a75e0bfccb8759', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (388, '0-8Y Baby Kid Set Pajamas (1 Baju+1 Seluar) Boy Girl Sleepwear', '0-8Y Baby Kid Set Pajamas (1 Baju+1 Seluar) Boy Girl Sleepwear', '0-8Y Baby Kid Set Pajamas (1 Baju+1 Seluar) Boy Girl Sleepwear', 80.00, 'https://cf.shopee.com.my/file/c553b528c83f45126bb6a3e70db28c07', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (389, 'Deli Kakao Series Bullet Tip Gel Pen - Black Ink (0.5mm) A457', 'Deli Kakao Series Bullet Tip Gel Pen - Black Ink (0.5mm) A457', 'Deli Kakao Series Bullet Tip Gel Pen - Black Ink (0.5mm) A457', 15.70, 'https://cf.shopee.com.my/file/fe0d3539c81d4b0cf2d6760bd91ba69a', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (390, 'Original NEVOKS FEELIN / Pagee Replacement 0.6/1.0 MESH COIL (5PCS/BOX) FEELIN OCC NEVOKS COIL', 'Original NEVOKS FEELIN / Pagee Replacement 0.6/1.0 MESH COIL (5PCS/BOX) FEELIN OCC NEVOKS COIL', 'Original NEVOKS FEELIN / Pagee Replacement 0.6/1.0 MESH COIL (5PCS/BOX) FEELIN OCC NEVOKS COIL', 340.00, 'https://cf.shopee.com.my/file/d7dab8bd0ccf2986b2cf1e6c8e466809', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (391, 'Faber-Castell Grip X X5/X7 0.5/0.7MM Ball Pen Metallic (1\'pc)', 'Faber-Castell Grip X X5/X7 0.5/0.7MM Ball Pen Metallic (1\'pc)', 'Faber-Castell Grip X X5/X7 0.5/0.7MM Ball Pen Metallic (1\'pc)', 12.40, 'https://cf.shopee.com.my/file/4f4bd1055ce1eb256feee2d0175941d4', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (392, 'Global Version Xiaomi TV Stick Mi TV Stick with Android TV 9.0 + Chromecast (1GB RAM + 8GB ROM 5G WiFi/English Version)', 'Global Version Xiaomi TV Stick Mi TV Stick with Android TV 9.0 + Chromecast (1GB RAM + 8GB ROM 5G WiFi/English Version)', 'Global Version Xiaomi TV Stick Mi TV Stick with Android TV 9.0 + Chromecast (1GB RAM + 8GB ROM 5G WiFi/English Version)', 1590.00, 'https://cf.shopee.com.my/file/b156daca076e926d0967fa6192fb11d0', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (394, 'G Soft Ball Pen W2 0.5MM/0.7MM', 'G Soft Ball Pen W2 0.5MM/0.7MM', 'G Soft Ball Pen W2 0.5MM/0.7MM', 5.60, 'https://cf.shopee.com.my/file/71e8e2050efebfedb2973d3993ce6cf0', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (397, 'Faber Castell / Faber-Castell RX 5/7 Gel 0.5mm 0.7mm Gel Pen PRICE FOR 1PC', 'Faber Castell / Faber-Castell RX 5/7 Gel 0.5mm 0.7mm Gel Pen PRICE FOR 1PC', 'Faber Castell / Faber-Castell RX 5/7 Gel 0.5mm 0.7mm Gel Pen PRICE FOR 1PC', 10.50, 'https://cf.shopee.com.my/file/7780c2e8ab3a82d3e2a1e63d9556af87', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (398, 'Joran Udang / Joran Pancing Udang 120 (4\'-0\") / 135 (4\'-6\")', 'Joran Udang / Joran Pancing Udang 120 (4\'-0\") / 135 (4\'-6\")', 'Joran Udang / Joran Pancing Udang 120 (4\'-0\") / 135 (4\'-6\")', 120.00, 'https://cf.shopee.com.my/file/7ef2e24d4c1214de1c952ef677174011', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (399, '0-6m 6-12m Baby Newborn Plain Legging Unisex Boy Girl Tight Pants Pantyhose', '0-6m 6-12m Baby Newborn Plain Legging Unisex Boy Girl Tight Pants Pantyhose', '0-6m 6-12m Baby Newborn Plain Legging Unisex Boy Girl Tight Pants Pantyhose', 78.50, 'https://cf.shopee.com.my/file/8efa41d4166fc47e6aff11ea05192883', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (400, 'Faber-Castell True Gel Pen 0.7mm Vibrant Colour Pen / Faber Castell Color Gel Pen / Truegel Pen', 'Faber-Castell True Gel Pen 0.7mm Vibrant Colour Pen / Faber Castell Color Gel Pen / Truegel Pen', 'Faber-Castell True Gel Pen 0.7mm Vibrant Colour Pen / Faber Castell Color Gel Pen / Truegel Pen', 17.90, 'https://cf.shopee.com.my/file/1d9ac6e0a3a532bfd50a629f1b69b9c4', 1627909653, 1, 1);
INSERT INTO `xy_goods_list` VALUES (401, 'BRAZING ROD 0% WELDING ROD', 'BRAZING ROD 0% WELDING ROD', 'BRAZING ROD 0% WELDING ROD', 17.00, 'https://cf.shopee.com.my/file/f5981b13e66cced0823af4de81aa2044', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (403, '0.5mm Plastic Gel Pen For Writing Material Gel-ink Pen Creative Office School Student Stationery Supplies 040172', '0.5mm Plastic Gel Pen For Writing Material Gel-ink Pen Creative Office School Student Stationery Supplies 040172', '0.5mm Plastic Gel Pen For Writing Material Gel-ink Pen Creative Office School Student Stationery Supplies 040172', 3.00, 'https://cf.shopee.com.my/file/4a609fa85dfea7259bd7f2d7f97efacb', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (404, '0-5-year-old children\'s summer trend short sleeve cotton shirt with two-piece cotton leisure shorts Baju Baby boy Clothing Wearing', '0-5-year-old children\'s summer trend short sleeve cotton shirt with two-piece cotton leisure shorts Baju Baby boy Clothing Wearing', '0-5-year-old children\'s summer trend short sleeve cotton shirt with two-piece cotton leisure shorts Baju Baby boy Clothing Wearing', 158.80, 'https://cf.shopee.com.my/file/c8697a7472a8487b2bb3682f97181043', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (405, '10.1/11.6/12.1/14.0/15.6/17 inch Notebook Dustproof Keyboard Cover Universal Silicone Laptop Keyboard Protector', '10.1/11.6/12.1/14.0/15.6/17 inch Notebook Dustproof Keyboard Cover Universal Silicone Laptop Keyboard Protector', '10.1/11.6/12.1/14.0/15.6/17 inch Notebook Dustproof Keyboard Cover Universal Silicone Laptop Keyboard Protector', 25.00, 'https://cf.shopee.com.my/file/40d5c25038418f4c1703cafe5ef9e161', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (406, '*Ready Stock* AWG24 Single Core Wire Cable 1/0.5mm (1meter)', '*Ready Stock* AWG24 Single Core Wire Cable 1/0.5mm (1meter)', '*Ready Stock* AWG24 Single Core Wire Cable 1/0.5mm (1meter)', 8.00, 'https://cf.shopee.com.my/file/59422179f20de5a8a66d6d22257aac67', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (408, '[PROMO PKP3.0] Malaysia \'\'Harimau Malaya\" Jersey Blackout', '[PROMO PKP3.0] Malaysia \'\'Harimau Malaya\" Jersey Blackout', '[PROMO PKP3.0] Malaysia \'\'Harimau Malaya\" Jersey Blackout', 299.90, 'https://cf.shopee.com.my/file/48982daef5884d2eea75f0f56caf072a', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (409, 'Jarum Kait Aluminum (2.0-6.0mm)/Aluminum Crochet Hook (2.0mm-6.0mm)', 'Jarum Kait Aluminum (2.0-6.0mm)/Aluminum Crochet Hook (2.0mm-6.0mm)', 'Jarum Kait Aluminum (2.0-6.0mm)/Aluminum Crochet Hook (2.0mm-6.0mm)', 20.00, 'https://cf.shopee.com.my/file/23c940acc29c5d242a4c408ab33d71aa', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (412, '0.3M Super Speed USB 3.0 External Hard Disk Cable 5Gbps Type A Male to Micro B Male', '0.3M Super Speed USB 3.0 External Hard Disk Cable 5Gbps Type A Male to Micro B Male', '0.3M Super Speed USB 3.0 External Hard Disk Cable 5Gbps Type A Male to Micro B Male', 43.50, 'https://cf.shopee.com.my/file/865694b83f3d3ca0b1c6126a680710d3', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (413, '[Top+Skirt] Baju Skirt Perempuan Bayi 0-6 Bulan Set Top Skirt Girl Newborn Infant Sleeveless Printed Printed 0-6 Months', '[Top+Skirt] Baju Skirt Perempuan Bayi 0-6 Bulan Set Top Skirt Girl Newborn Infant Sleeveless Printed Printed 0-6 Months', '[Top+Skirt] Baju Skirt Perempuan Bayi 0-6 Bulan Set Top Skirt Girl Newborn Infant Sleeveless Printed Printed 0-6 Months', 109.00, 'https://cf.shopee.com.my/file/c59dd9102d30f911d585d46a49055a2b', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (414, '3D 4K 8K HD UHD HDMI Cable v2.0/ v2.1 Gold Plate Head 1.5 /3/ 5 /10 /15 Meter', '3D 4K 8K HD UHD HDMI Cable v2.0/ v2.1 Gold Plate Head 1.5 /3/ 5 /10 /15 Meter', '3D 4K 8K HD UHD HDMI Cable v2.0/ v2.1 Gold Plate Head 1.5 /3/ 5 /10 /15 Meter', 219.00, 'https://cf.shopee.com.my/file/1c3f4703caac14658cfe5bd5a9a93878', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (415, 'READY STOCK!! 0.7L 1.5L MANUAL SLOW COOKER STEWING POT BABY PORRIDGE SOUP COOKING CERAMIC', 'READY STOCK!! 0.7L 1.5L MANUAL SLOW COOKER STEWING POT BABY PORRIDGE SOUP COOKING CERAMIC', 'READY STOCK!! 0.7L 1.5L MANUAL SLOW COOKER STEWING POT BABY PORRIDGE SOUP COOKING CERAMIC', 379.00, 'https://cf.shopee.com.my/file/cd2d4b87c834cfde42e0bc7179d632ba', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (417, 'Freshkon 58 Monthly Clear Contact Lenses - Power -0.50 to -10.00 (6 Pcs)', 'Freshkon 58 Monthly Clear Contact Lenses - Power -0.50 to -10.00 (6 Pcs)', 'Freshkon 58 Monthly Clear Contact Lenses - Power -0.50 to -10.00 (6 Pcs)', 283.10, 'https://cf.shopee.com.my/file/7df4bb125902b77bd00a33a25e6f138e', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (418, 'Newborn baby wear ~Infant summer suit ,baju set bayi berjaring,baju baby set 0-3months', 'Newborn baby wear ~Infant summer suit ,baju set bayi berjaring,baju baby set 0-3months', 'Newborn baby wear ~Infant summer suit ,baju set bayi berjaring,baju baby set 0-3months', 39.00, 'https://cf.shopee.com.my/file/c491ad24b5ce23efdce2740a2fe2c20a', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (419, 'Type-C 3.1a TO HDMI 4K HD 3 IN 1 USB3.0 HUB PD USB C CHARGING MULTIPORT ADAPTER', 'Type-C 3.1a TO HDMI 4K HD 3 IN 1 USB3.0 HUB PD USB C CHARGING MULTIPORT ADAPTER', 'Type-C 3.1a TO HDMI 4K HD 3 IN 1 USB3.0 HUB PD USB C CHARGING MULTIPORT ADAPTER', 350.00, 'https://cf.shopee.com.my/file/cb1faa45ac7f8e77c6341bfb36d2b8ab', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (421, 'Tommee Tippee CTN Night Time Baby Pacifier Soother 0-6/6-18 mths Single Loose/Twin Pack', 'Tommee Tippee CTN Night Time Baby Pacifier Soother 0-6/6-18 mths Single Loose/Twin Pack', 'Tommee Tippee CTN Night Time Baby Pacifier Soother 0-6/6-18 mths Single Loose/Twin Pack', 99.00, 'https://cf.shopee.com.my/file/f5c73c60cf6ba3d4e65c0bd1ef4c9633', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (422, 'Zebra SARASA Clip Pen 0.5mm', 'Zebra SARASA Clip Pen 0.5mm', 'Zebra SARASA Clip Pen 0.5mm', 28.70, 'https://cf.shopee.com.my/file/90c7eac0ba4f5279af846d453dd35705', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (425, '0-24M baju baby romper newborn baby clothing gentle style 100% Cotton for boys', '0-24M baju baby romper newborn baby clothing gentle style 100% Cotton for boys', '0-24M baju baby romper newborn baby clothing gentle style 100% Cotton for boys', 284.90, 'https://cf.shopee.com.my/file/3608e7938de218590c095c577d48456c', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (427, '( 0.1, 0.15, 0.22, 0.33, 0.39, 0.47, 0.68, 0.82, 1.0, 1.5, 2.0, 2.2, 2.5, 3.0, 3.5)uF 310v AC Fan Capacitor', '( 0.1, 0.15, 0.22, 0.33, 0.39, 0.47, 0.68, 0.82, 1.0, 1.5, 2.0, 2.2, 2.5, 3.0, 3.5)uF 310v AC Fan Capacitor', '( 0.1, 0.15, 0.22, 0.33, 0.39, 0.47, 0.68, 0.82, 1.0, 1.5, 2.0, 2.2, 2.5, 3.0, 3.5)uF 310v AC Fan Capacitor', 15.00, 'https://cf.shopee.com.my/file/8cdc60ce839dbbf5d207d8433afc9cae', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (428, 'Rocketek Bluetooth 4.0/5.0 Adapter USB Dongle For PC Computer Speaker Audio/Switch/PS4 Controller', 'Rocketek Bluetooth 4.0/5.0 Adapter USB Dongle For PC Computer Speaker Audio/Switch/PS4 Controller', 'Rocketek Bluetooth 4.0/5.0 Adapter USB Dongle For PC Computer Speaker Audio/Switch/PS4 Controller', 149.00, 'https://cf.shopee.com.my/file/e4127f8b1ceb70322921b243e9468e31', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (429, 'Air Optix Plus Hydraglyde Alcon Monthly - Power -0.50 to -12.00 (3 Pcs)', 'Air Optix Plus Hydraglyde Alcon Monthly - Power -0.50 to -12.00 (3 Pcs)', 'Air Optix Plus Hydraglyde Alcon Monthly - Power -0.50 to -12.00 (3 Pcs)', 410.00, 'https://cf.shopee.com.my/file/3209f4573334234ca672d9e77d08c121', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (431, 'Pilot Pen Polymer Pencil Lead - 0.5mm / 0.7mm / 0.3mm / 0.9mm', 'Pilot Pen Polymer Pencil Lead - 0.5mm / 0.7mm / 0.3mm / 0.9mm', 'Pilot Pen Polymer Pencil Lead - 0.5mm / 0.7mm / 0.3mm / 0.9mm', 9.70, 'https://cf.shopee.com.my/file/d896561f8c8fbf8876cd1b0d139fe663', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (432, 'Part 1 Heavy Premium Como Crepe Lessiron 0.5m Bidang 60 Untuk Baju Kurung 63 Warna', 'Part 1 Heavy Premium Como Crepe Lessiron 0.5m Bidang 60 Untuk Baju Kurung 63 Warna', 'Part 1 Heavy Premium Como Crepe Lessiron 0.5m Bidang 60 Untuk Baju Kurung 63 Warna', 29.00, 'https://cf.shopee.com.my/file/ab5dbcadab36fae5352e4ac2fee47447', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (435, 'Global Version Xiaomi TV Stick Mi TV Stick with Android TV 9.0 + Chromecast (1GB RAM + 8GB ROM 5G WiFi/English Version)', 'Global Version Xiaomi TV Stick Mi TV Stick with Android TV 9.0 + Chromecast (1GB RAM + 8GB ROM 5G WiFi/English Version)', 'Global Version Xiaomi TV Stick Mi TV Stick with Android TV 9.0 + Chromecast (1GB RAM + 8GB ROM 5G WiFi/English Version)', 1590.00, 'https://cf.shopee.com.my/file/b156daca076e926d0967fa6192fb11d0', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (436, 'Faber Castell Faber-Castell School & Office Retractable RX Gel Pen Black Blue Red 0.5mm 0.7mm', 'Faber Castell Faber-Castell School & Office Retractable RX Gel Pen Black Blue Red 0.5mm 0.7mm', 'Faber Castell Faber-Castell School & Office Retractable RX Gel Pen Black Blue Red 0.5mm 0.7mm', 13.00, 'https://cf.shopee.com.my/file/c4fa2751f0d42c7dde62c8329880750e', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (437, 'BK Kerongsang Batu Korea Premium Rhinestone 0.8CM - Baby Brooch Ready Stock (K87)', 'BK Kerongsang Batu Korea Premium Rhinestone 0.8CM - Baby Brooch Ready Stock (K87)', 'BK Kerongsang Batu Korea Premium Rhinestone 0.8CM - Baby Brooch Ready Stock (K87)', 2.00, 'https://cf.shopee.com.my/file/08efab3d75343fff01161c48da3c4642', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (439, '0.2/0.25/0.3/0.4/0.5/0.6/0.8/1mm Silver Gold Color Alloy Cord Beading Wire DIY Craft Making Jewelry Cord String Accessories', '0.2/0.25/0.3/0.4/0.5/0.6/0.8/1mm Silver Gold Color Alloy Cord Beading Wire DIY Craft Making Jewelry Cord String Accessories', '0.2/0.25/0.3/0.4/0.5/0.6/0.8/1mm Silver Gold Color Alloy Cord Beading Wire DIY Craft Making Jewelry Cord String Accessories', 15.20, 'https://cf.shopee.com.my/file/f4facea6bfbaff66595ed9e7b9e6773c', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (441, 'Lovely Baby Girls Shoes Soft Toddler Flower Shoes 0-18M', 'Lovely Baby Girls Shoes Soft Toddler Flower Shoes 0-18M', 'Lovely Baby Girls Shoes Soft Toddler Flower Shoes 0-18M', 103.50, 'https://cf.shopee.com.my/file/db59ad588f5d1657d110e017ff7bbfaf', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (442, 'Bubble Wrap Clear/Black 0.5m x 1M / 1m x 1M', 'Bubble Wrap Clear/Black 0.5m x 1M / 1m x 1M', 'Bubble Wrap Clear/Black 0.5m x 1M / 1m x 1M', 7.00, 'https://cf.shopee.com.my/file/e7007456f887870ad0b374fb90c21f08', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (443, 'BD Micro fine Plus 4mm Jarum Insulin BD Ultra Fine Plus 0.23mm (32G) x 4mm lose needles no box', 'BD Micro fine Plus 4mm Jarum Insulin BD Ultra Fine Plus 0.23mm (32G) x 4mm lose needles no box', 'BD Micro fine Plus 4mm Jarum Insulin BD Ultra Fine Plus 0.23mm (32G) x 4mm lose needles no box', 5.40, 'https://cf.shopee.com.my/file/191dcce10623fa6721cfc59a0aa5ab82', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (444, '[MD Keto] [2-4 packs] Lakanto monk fruit sweetener 200g keto friendly, 0% sugar low carb monkfruit Non-GMO Erythritol', '[MD Keto] [2-4 packs] Lakanto monk fruit sweetener 200g keto friendly, 0% sugar low carb monkfruit Non-GMO Erythritol', '[MD Keto] [2-4 packs] Lakanto monk fruit sweetener 200g keto friendly, 0% sugar low carb monkfruit Non-GMO Erythritol', 299.90, 'https://cf.shopee.com.my/file/3059c900bbe716fe8335ab4b4fdd0c2b', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (445, 'Cleanrance Stock Kain Pasang Paloma Twill Cotton Silk Sangat Lembut Cotton Soffy Cotton Bidang 58 Harga Utk 0.5m', 'Cleanrance Stock Kain Pasang Paloma Twill Cotton Silk Sangat Lembut Cotton Soffy Cotton Bidang 58 Harga Utk 0.5m', 'Cleanrance Stock Kain Pasang Paloma Twill Cotton Silk Sangat Lembut Cotton Soffy Cotton Bidang 58 Harga Utk 0.5m', 42.80, 'https://cf.shopee.com.my/file/f1391791ffd453531a0cb2656ae55a58', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (446, 'Striped Newborn Baby Toddler Tight Long Cotton Pants Leggings 0-2Yrs', 'Striped Newborn Baby Toddler Tight Long Cotton Pants Leggings 0-2Yrs', 'Striped Newborn Baby Toddler Tight Long Cotton Pants Leggings 0-2Yrs', 33.60, 'https://cf.shopee.com.my/file/5073ee4f12b8ee9690b9e74ea5e71839', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (448, '0.2ml~10ml Disposable Pipette Plastic Pasteur Dropper For Lab', '0.2ml~10ml Disposable Pipette Plastic Pasteur Dropper For Lab', '0.2ml~10ml Disposable Pipette Plastic Pasteur Dropper For Lab', 2.20, 'https://cf.shopee.com.my/file/381f350ae07d5354f21261f579f58a1f', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (449, 'TOPK J01 Cable Organizer Wire Winder Earphone Velcro holder Mouse Cord Protector 0.5M / 1M / 2M / 3M /5M', 'TOPK J01 Cable Organizer Wire Winder Earphone Velcro holder Mouse Cord Protector 0.5M / 1M / 2M / 3M /5M', 'TOPK J01 Cable Organizer Wire Winder Earphone Velcro holder Mouse Cord Protector 0.5M / 1M / 2M / 3M /5M', 15.60, 'https://cf.shopee.com.my/file/33e8e2ad8678ef5c99c7d23438c70f4f', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (450, 'Simple Color Gel Pen 0.5mm Pen Tip Cute Pen for Hand Account Annotation, Drawing Graffiti School Supplies, Stationery', 'Simple Color Gel Pen 0.5mm Pen Tip Cute Pen for Hand Account Annotation, Drawing Graffiti School Supplies, Stationery', 'Simple Color Gel Pen 0.5mm Pen Tip Cute Pen for Hand Account Annotation, Drawing Graffiti School Supplies, Stationery', 10.00, 'https://cf.shopee.com.my/file/69c3094436476c4fcf09c938fe3e2b8c', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (452, 'Pilot G2 Roller Ball Pen Refill 0.38/0.5/0.7/1.0mm-Per Piece', 'Pilot G2 Roller Ball Pen Refill 0.38/0.5/0.7/1.0mm-Per Piece', 'Pilot G2 Roller Ball Pen Refill 0.38/0.5/0.7/1.0mm-Per Piece', 27.90, 'https://cf.shopee.com.my/file/6812e6a85dc61fcbf8a2c834a5d1646c', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (453, 'Innisfree Auto Eyebrow Pencil 0.3g [GLAM]', 'Innisfree Auto Eyebrow Pencil 0.3g [GLAM]', 'Innisfree Auto Eyebrow Pencil 0.3g [GLAM]', 90.00, 'https://cf.shopee.com.my/file/3964556a1ad469c019f3eddeadd82a0d', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (454, 'Bubble Wrap PE Foam 0.5m (50cm) x 10m / 1m x 5m BLUECON', 'Bubble Wrap PE Foam 0.5m (50cm) x 10m / 1m x 5m BLUECON', 'Bubble Wrap PE Foam 0.5m (50cm) x 10m / 1m x 5m BLUECON', 49.90, 'https://cf.shopee.com.my/file/f4da3c8c717a2296b836803e76a59068', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (455, '50pcs Resistor 0.25W 5%', '50pcs Resistor 0.25W 5%', '50pcs Resistor 0.25W 5%', 9.90, 'https://cf.shopee.com.my/file/187ca8e7641d15e3eb89d053e477dbc0', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (456, 'Pilot G2 Retractable Gel Pen 0.5/0.7/1.0 mm (Black/Blue/Red)', 'Pilot G2 Retractable Gel Pen 0.5/0.7/1.0 mm (Black/Blue/Red)', 'Pilot G2 Retractable Gel Pen 0.5/0.7/1.0 mm (Black/Blue/Red)', 39.00, 'https://cf.shopee.com.my/file/148f6e4c010828bf646c84800d253f06', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (457, 'IKEA PRODUKT MILK FROTHER BLACK IKEA MILK-FROTHER COFFEE MILK SPIN MILK PEMBUIH SUSU MATTLIG MILK-FROTHING JUG 0.5L', 'IKEA PRODUKT MILK FROTHER BLACK IKEA MILK-FROTHER COFFEE MILK SPIN MILK PEMBUIH SUSU MATTLIG MILK-FROTHING JUG 0.5L', 'IKEA PRODUKT MILK FROTHER BLACK IKEA MILK-FROTHER COFFEE MILK SPIN MILK PEMBUIH SUSU MATTLIG MILK-FROTHING JUG 0.5L', 219.00, 'https://cf.shopee.com.my/file/22dc13e89145fed14ad24baced502b47', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (458, 'Clinical Medical Science Lab Test Glass Tube Tiub Kaca 12cm x 0.7cm 120mm Multipurpose Creative Art DIY Decoration', 'Clinical Medical Science Lab Test Glass Tube Tiub Kaca 12cm x 0.7cm 120mm Multipurpose Creative Art DIY Decoration', 'Clinical Medical Science Lab Test Glass Tube Tiub Kaca 12cm x 0.7cm 120mm Multipurpose Creative Art DIY Decoration', 9.00, 'https://cf.shopee.com.my/file/7bc8464bc919da13ee8e052e0eccc7e6', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (460, 'OOREE UH401 4 PORTS HIGH SPEED USB2.0 USB HUB ON/OFF PORTABLE SWITCH, BLACK', 'OOREE UH401 4 PORTS HIGH SPEED USB2.0 USB HUB ON/OFF PORTABLE SWITCH, BLACK', 'OOREE UH401 4 PORTS HIGH SPEED USB2.0 USB HUB ON/OFF PORTABLE SWITCH, BLACK', 119.00, 'https://cf.shopee.com.my/file/dd480f61a9431763cd39e430c46ece45', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (461, 'M&G R3/R5 Gel Pen (12pcs/Box) Refill 0.5/0.7 (20pcs/Box)', 'M&G R3/R5 Gel Pen (12pcs/Box) Refill 0.5/0.7 (20pcs/Box)', 'M&G R3/R5 Gel Pen (12pcs/Box) Refill 0.5/0.7 (20pcs/Box)', 110.00, 'https://cf.shopee.com.my/file/16baf77878cc9066c1179f410285fb8a', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (463, 'M&G Retractable Gel Ink Ballpoint Pens R3-0.5mm/R5-0.7mm -Per pc', 'M&G Retractable Gel Ink Ballpoint Pens R3-0.5mm/R5-0.7mm -Per pc', 'M&G Retractable Gel Ink Ballpoint Pens R3-0.5mm/R5-0.7mm -Per pc', 13.00, 'https://cf.shopee.com.my/file/f1441c9194ed37e5c10fa90673af6672', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (464, '0.5Kg Firebeater Auto Fire Extinguisher Portable Car Home', '0.5Kg Firebeater Auto Fire Extinguisher Portable Car Home', '0.5Kg Firebeater Auto Fire Extinguisher Portable Car Home', 101.00, 'https://cf.shopee.com.my/file/f4bdd8503b0d3995667e80f08b5c1ec0', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (465, '(READY STOCK) DENTAL BRACKET MESH BASE STANDARD MBT / MONOBLOCK MINI 0.22 MBT / DENTAL BRACKET HIGH QUALITY', '(READY STOCK) DENTAL BRACKET MESH BASE STANDARD MBT / MONOBLOCK MINI 0.22 MBT / DENTAL BRACKET HIGH QUALITY', '(READY STOCK) DENTAL BRACKET MESH BASE STANDARD MBT / MONOBLOCK MINI 0.22 MBT / DENTAL BRACKET HIGH QUALITY', 100.00, 'https://cf.shopee.com.my/file/96101956db489a34fa43eb9d303dfec4', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (466, '0-3 MONTHS NEWBORN HIPPIE BABY WEAR 100% COTTON', '0-3 MONTHS NEWBORN HIPPIE BABY WEAR 100% COTTON', '0-3 MONTHS NEWBORN HIPPIE BABY WEAR 100% COTTON', 90.00, 'https://cf.shopee.com.my/file/fba1abc527e05dde44a6f118b207cdc3', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (467, 'AirPods i12 TWS Wireless Bluetooth5.0 HiFi Earbuds Touch Control For Iphone and Android Phone inpods Macaron', 'AirPods i12 TWS Wireless Bluetooth5.0 HiFi Earbuds Touch Control For Iphone and Android Phone inpods Macaron', 'AirPods i12 TWS Wireless Bluetooth5.0 HiFi Earbuds Touch Control For Iphone and Android Phone inpods Macaron', 113.90, 'https://cf.shopee.com.my/file/bd95d15dc09c996b72a0c781775c6a7c', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (468, '1pcs Freshkon Alluring Daily Color Magnetic Grey - 0.00 to -5.00 (1 Pc)', '1pcs Freshkon Alluring Daily Color Magnetic Grey - 0.00 to -5.00 (1 Pc)', '1pcs Freshkon Alluring Daily Color Magnetic Grey - 0.00 to -5.00 (1 Pc)', 20.50, 'https://cf.shopee.com.my/file/073af805484233f385f560e62599958d', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (469, '1PCS T10 LED bulb car light W5W Car LED 194 168 W5W CANBUS  26SMD Car LED 4014 2.5W 0.2A Non polar Auto Wedge Tail Side Bulb reading plate lamp', '1PCS T10 LED bulb car light W5W Car LED 194 168 W5W CANBUS  26SMD Car LED 4014 2.5W 0.2A Non polar Auto Wedge Tail Side Bulb reading plate lamp', '1PCS T10 LED bulb car light W5W Car LED 194 168 W5W CANBUS  26SMD Car LED 4014 2.5W 0.2A Non polar Auto Wedge Tail Side Bulb reading plate lamp', 28.00, 'https://cf.shopee.com.my/file/e998a443a5e20a1f4241bece946b57b3', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (470, 'M&G TR3 Triangle Grip Semi Gel Ball Pen 0.7mm (Price For 1pc)', 'M&G TR3 Triangle Grip Semi Gel Ball Pen 0.7mm (Price For 1pc)', 'M&G TR3 Triangle Grip Semi Gel Ball Pen 0.7mm (Price For 1pc)', 5.90, 'https://cf.shopee.com.my/file/f6442289b9255d38fe7f8f764ddae935', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (471, 'Tribit XFree Go Bluetooth Headphones - Bluetooth 5.0, 24 Hours Play Time, CVC8.0, High Clarity', 'Tribit XFree Go Bluetooth Headphones - Bluetooth 5.0, 24 Hours Play Time, CVC8.0, High Clarity', 'Tribit XFree Go Bluetooth Headphones - Bluetooth 5.0, 24 Hours Play Time, CVC8.0, High Clarity', 1350.00, 'https://cf.shopee.com.my/file/a6f61e4846bbbed6deb72c16ea1061ec', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (473, '3M SUPER STRONG TAPE / water proof / heavy duty / outdoor / vehicle tape/ foam tape / double sided tape 0.1x1CM', '3M SUPER STRONG TAPE / water proof / heavy duty / outdoor / vehicle tape/ foam tape / double sided tape 0.1x1CM', '3M SUPER STRONG TAPE / water proof / heavy duty / outdoor / vehicle tape/ foam tape / double sided tape 0.1x1CM', 35.00, 'https://cf.shopee.com.my/file/2039712a6ac74b40a9ca07257ece19bf', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (474, '1pcs Freshkon Fusion Daily Color Brilliant Brown - 0.00 to -5.00 (1 Pc)', '1pcs Freshkon Fusion Daily Color Brilliant Brown - 0.00 to -5.00 (1 Pc)', '1pcs Freshkon Fusion Daily Color Brilliant Brown - 0.00 to -5.00 (1 Pc)', 20.50, 'https://cf.shopee.com.my/file/b6165767c2ad9eb1cbd40e2734911f04', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (475, 'L Type 0.6-1.5mm Tooth Brush Orthodontic\nBrush Angled Interdental Brushes', 'L Type 0.6-1.5mm Tooth Brush Orthodontic\nBrush Angled Interdental Brushes', 'L Type 0.6-1.5mm Tooth Brush Orthodontic\nBrush Angled Interdental Brushes', 48.10, 'https://cf.shopee.com.my/file/ca6feb9e24f370e0b1738da1863b246d', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (476, '9D 9H 0.3MM Tempered Glass Screen Protector For Huawei P20 P30 P40 Pro + Plus Mate 10 20 30 40 Y9 Prime Y5P Y6P', '9D 9H 0.3MM Tempered Glass Screen Protector For Huawei P20 P30 P40 Pro + Plus Mate 10 20 30 40 Y9 Prime Y5P Y6P', '9D 9H 0.3MM Tempered Glass Screen Protector For Huawei P20 P30 P40 Pro + Plus Mate 10 20 30 40 Y9 Prime Y5P Y6P', 32.00, 'https://cf.shopee.com.my/file/cd44070b2e01495b56b87455ebfc58ee', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (477, 'LOOSE CUT 40/0.16MM X 3C 100% Pure Full Copper 3 Core Flexible Wire Cable PVC Insulated Sheathed Made in Malaysia 40/016', 'LOOSE CUT 40/0.16MM X 3C 100% Pure Full Copper 3 Core Flexible Wire Cable PVC Insulated Sheathed Made in Malaysia 40/016', 'LOOSE CUT 40/0.16MM X 3C 100% Pure Full Copper 3 Core Flexible Wire Cable PVC Insulated Sheathed Made in Malaysia 40/016', 17.50, 'https://cf.shopee.com.my/file/f2b8ad2b12d97eafbbb2972432f9b6a8', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (478, '0.5mm Gel Pen Neutral Pen Signing Pen Office Transparent Pen', '0.5mm Gel Pen Neutral Pen Signing Pen Office Transparent Pen', '0.5mm Gel Pen Neutral Pen Signing Pen Office Transparent Pen', 3.00, 'https://cf.shopee.com.my/file/dc71536df5057dad479ba12dd5985e65', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (479, '[THE ORDINARY] Retinol 0.2% in Squalane / Retinol 0.5% in Squalane / Retinol 1% in Squalane', '[THE ORDINARY] Retinol 0.2% in Squalane / Retinol 0.5% in Squalane / Retinol 1% in Squalane', '[THE ORDINARY] Retinol 0.2% in Squalane / Retinol 0.5% in Squalane / Retinol 1% in Squalane', 338.00, 'https://cf.shopee.com.my/file/2722897adc2d2d8bbb7c188e3113e065', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (480, 'Faber Castell Faber-Castell School & Office Capped True Gel Pen Black Blue Red 0.5mm 0.7mm', 'Faber Castell Faber-Castell School & Office Capped True Gel Pen Black Blue Red 0.5mm 0.7mm', 'Faber Castell Faber-Castell School & Office Capped True Gel Pen Black Blue Red 0.5mm 0.7mm', 15.00, 'https://cf.shopee.com.my/file/592ce65d4e9d0b75242037ef7e6b0b80', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (482, '1/0.5 (1Meter) Single Core Single Strand Wire Red Black Yellow Green Blue Brown', '1/0.5 (1Meter) Single Core Single Strand Wire Red Black Yellow Green Blue Brown', '1/0.5 (1Meter) Single Core Single Strand Wire Red Black Yellow Green Blue Brown', 10.00, 'https://cf.shopee.com.my/file/d8045a3ed723d207bd13fe7ee8944436', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (483, 'Faber Castell Click X Ball Pen X5 0.5mm 1425 / X7 0.7mm 1422 / Faber-Castell Click X7 (Pena Mata Bulat)', 'Faber Castell Click X Ball Pen X5 0.5mm 1425 / X7 0.7mm 1422 / Faber-Castell Click X7 (Pena Mata Bulat)', 'Faber Castell Click X Ball Pen X5 0.5mm 1425 / X7 0.7mm 1422 / Faber-Castell Click X7 (Pena Mata Bulat)', 5.90, 'https://cf.shopee.com.my/file/4ae9065a07a55a112687f4db0b78d544', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (484, 'GLOBAL VERSION Xiaomi Mi TV Stick 9.0 /MI BOX S TV FHD Android TV 8.1 + Chromecast 1GB RAM + 8GB ROM 5G WiFi', 'GLOBAL VERSION Xiaomi Mi TV Stick 9.0 /MI BOX S TV FHD Android TV 8.1 + Chromecast 1GB RAM + 8GB ROM 5G WiFi', 'GLOBAL VERSION Xiaomi Mi TV Stick 9.0 /MI BOX S TV FHD Android TV 8.1 + Chromecast 1GB RAM + 8GB ROM 5G WiFi', 1479.00, 'https://cf.shopee.com.my/file/7894240684432a849f6112b9ad76a14b', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (485, '(0.00 To -5.00 )1 Piece Freshkon Alluring Daily Color Magnetic Grey (Loose Pack)', '(0.00 To -5.00 )1 Piece Freshkon Alluring Daily Color Magnetic Grey (Loose Pack)', '(0.00 To -5.00 )1 Piece Freshkon Alluring Daily Color Magnetic Grey (Loose Pack)', 20.50, 'https://cf.shopee.com.my/file/0138bbb5267a969e2d3ee85577f8c763', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (486, 'STARWELD 1 KG X 0.8MM MIG WIRE (GASLESS)', 'STARWELD 1 KG X 0.8MM MIG WIRE (GASLESS)', 'STARWELD 1 KG X 0.8MM MIG WIRE (GASLESS)', 189.70, 'https://cf.shopee.com.my/file/6c628fe779c3d3d72d566d034cdc1bf2', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (487, 'Original Uwell Caliburn G Occ Replacement Coil 0.8 Ohm 4pcs', 'Original Uwell Caliburn G Occ Replacement Coil 0.8 Ohm 4pcs', 'Original Uwell Caliburn G Occ Replacement Coil 0.8 Ohm 4pcs', 170.00, 'https://cf.shopee.com.my/file/9667ec3b59201a845ab62edb376cbf68', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (488, 'Zhi Xin Lovein Test Good Gel Pen 0.5mm (SELL IN BOX-12pcs) Test Good 2501', 'Zhi Xin Lovein Test Good Gel Pen 0.5mm (SELL IN BOX-12pcs) Test Good 2501', 'Zhi Xin Lovein Test Good Gel Pen 0.5mm (SELL IN BOX-12pcs) Test Good 2501', 39.00, 'https://cf.shopee.com.my/file/61d7ecb4c98919f42a73e3f08c2b93bf', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (489, 'LR44 SR920SW SR626SW LR1130 LR41 SR927SW SR521SW SR936SW SR621 LR1120 SR721SW LR754 AG5 AG 0 1 3 4 5 6 7 8 9 10 11 13', 'LR44 SR920SW SR626SW LR1130 LR41 SR927SW SR521SW SR936SW SR621 LR1120 SR721SW LR754 AG5 AG 0 1 3 4 5 6 7 8 9 10 11 13', 'LR44 SR920SW SR626SW LR1130 LR41 SR927SW SR521SW SR936SW SR621 LR1120 SR721SW LR754 AG5 AG 0 1 3 4 5 6 7 8 9 10 11 13', 5.00, 'https://cf.shopee.com.my/file/9a0faed99c737588a6ee49ea40391479', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (490, '[Grab2Go] Mechanical Pencil - STABILO Mechanical Pencil (0.7mm) Set with Hi Polymer Leads and Eraser', '[Grab2Go] Mechanical Pencil - STABILO Mechanical Pencil (0.7mm) Set with Hi Polymer Leads and Eraser', '[Grab2Go] Mechanical Pencil - STABILO Mechanical Pencil (0.7mm) Set with Hi Polymer Leads and Eraser', 22.00, 'https://cf.shopee.com.my/file/e60a51da0a3c783f7d3da5700804dbcf', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (491, 'Imi Tamiya Aluminum Tube Spacer Set - 1.5/3.0/6.0/12.0mm', 'Imi Tamiya Aluminum Tube Spacer Set - 1.5/3.0/6.0/12.0mm', 'Imi Tamiya Aluminum Tube Spacer Set - 1.5/3.0/6.0/12.0mm', 80.00, 'https://cf.shopee.com.my/file/9189e2aafca0d40143848dd27eafc080', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (492, '[JPJ Approved] Number Plate Sticker 0-9 Motorcycle White Nombor Sticker Motor Moto Motosikal 123 ABC Putih A-Z', '[JPJ Approved] Number Plate Sticker 0-9 Motorcycle White Nombor Sticker Motor Moto Motosikal 123 ABC Putih A-Z', '[JPJ Approved] Number Plate Sticker 0-9 Motorcycle White Nombor Sticker Motor Moto Motosikal 123 ABC Putih A-Z', 4.50, 'https://cf.shopee.com.my/file/bd5a05dc7c8caa1c89a00722d0513b72', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (493, 'ZUIXUA CS801 Gel Pen 0.38mm/ 0.5mm Smooth Writing Rollerball - Black/Blue/Red (Test Good)', 'ZUIXUA CS801 Gel Pen 0.38mm/ 0.5mm Smooth Writing Rollerball - Black/Blue/Red (Test Good)', 'ZUIXUA CS801 Gel Pen 0.38mm/ 0.5mm Smooth Writing Rollerball - Black/Blue/Red (Test Good)', 3.30, 'https://cf.shopee.com.my/file/406f8677a17243bb10ab082557c9de97', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (494, 'Boys\' shirt suit 0-4-year-old Summer Boys\' cotton shirt + pants 2-piece set', 'Boys\' shirt suit 0-4-year-old Summer Boys\' cotton shirt + pants 2-piece set', 'Boys\' shirt suit 0-4-year-old Summer Boys\' cotton shirt + pants 2-piece set', 121.30, 'https://cf.shopee.com.my/file/96462350342197acaaf6cc25dafd5b3c', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (495, 'M&G TR3 Triangle Grip Semi Gel Ball Pen 0.7mm', 'M&G TR3 Triangle Grip Semi Gel Ball Pen 0.7mm', 'M&G TR3 Triangle Grip Semi Gel Ball Pen 0.7mm', 6.00, 'https://cf.shopee.com.my/file/7269203b6b953ea4360aea9aa4873851', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (496, '0.15mm 6A Jaring Pukat Ikan Tangsi  Complete Net [Ready stock]', '0.15mm 6A Jaring Pukat Ikan Tangsi  Complete Net [Ready stock]', '0.15mm 6A Jaring Pukat Ikan Tangsi  Complete Net [Ready stock]', 130.00, 'https://cf.shopee.com.my/file/9cd8bd3b7a443cdaac72c925a35bdc14', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (497, '100% Original Smok Nfix Replacement Cartridge 0.8 Ohm Mesh / MTL', '100% Original Smok Nfix Replacement Cartridge 0.8 Ohm Mesh / MTL', '100% Original Smok Nfix Replacement Cartridge 0.8 Ohm Mesh / MTL', 220.00, 'https://cf.shopee.com.my/file/1bd126125c1c2ac036927d53b10dcca3', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (498, 'SACE LADY Matte Cream Concealer Full Coverage Waterproof Face Makeup Cosmetics 6g/0.2oz', 'SACE LADY Matte Cream Concealer Full Coverage Waterproof Face Makeup Cosmetics 6g/0.2oz', 'SACE LADY Matte Cream Concealer Full Coverage Waterproof Face Makeup Cosmetics 6g/0.2oz', 39.90, 'https://cf.shopee.com.my/file/8e3e4113fd00cc39877086b6dc740d54', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (500, 'Loose Meter - Flexible Cable 40/0.76 x 3 Core [100% Pure Copper) Flex Cord Wire 1.25mm 3C FULL Copper as FAJAR', 'Loose Meter - Flexible Cable 40/0.76 x 3 Core [100% Pure Copper) Flex Cord Wire 1.25mm 3C FULL Copper as FAJAR', 'Loose Meter - Flexible Cable 40/0.76 x 3 Core [100% Pure Copper) Flex Cord Wire 1.25mm 3C FULL Copper as FAJAR', 20.00, 'https://cf.shopee.com.my/file/7cf90fdd3ca61f32a02a9330e26dbb1d', 1627909655, 1, 1);
INSERT INTO `xy_goods_list` VALUES (501, '[Top+Skirt] Baju Skirt Perempuan Bayi 0-6 Bulan Set Top Skirt Girl Newborn Infant Sleeveless Printed Printed 0-6 Months', '[Top+Skirt] Baju Skirt Perempuan Bayi 0-6 Bulan Set Top Skirt Girl Newborn Infant Sleeveless Printed Printed 0-6 Months', '[Top+Skirt] Baju Skirt Perempuan Bayi 0-6 Bulan Set Top Skirt Girl Newborn Infant Sleeveless Printed Printed 0-6 Months', 109.00, 'https://cf.shopee.com.my/file/c59dd9102d30f911d585d46a49055a2b', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (502, '1pcs Freshkon Alluring Daily Color Winsome Brown - 0.00 to -5.00 (1 Pc)', '1pcs Freshkon Alluring Daily Color Winsome Brown - 0.00 to -5.00 (1 Pc)', '1pcs Freshkon Alluring Daily Color Winsome Brown - 0.00 to -5.00 (1 Pc)', 20.50, 'https://cf.shopee.com.my/file/0b719dba858a79b2c803555bd647f13d', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (504, 'Tommee Tippee Ultra-Light Silicone Baby Soother Puting 0-6m / 6-18m / 18-36m', 'Tommee Tippee Ultra-Light Silicone Baby Soother Puting 0-6m / 6-18m / 18-36m', 'Tommee Tippee Ultra-Light Silicone Baby Soother Puting 0-6m / 6-18m / 18-36m', 179.20, 'https://cf.shopee.com.my/file/58eceaef5c37a91e6c9d08cb6fe8a365', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (505, 'Twill Cotton 60\" / Comb Cotton (Kain Cotton Bidang 60 inci) (Harga untuk 0.5 meter  ) POCODOT 0.8cm', 'Twill Cotton 60\" / Comb Cotton (Kain Cotton Bidang 60 inci) (Harga untuk 0.5 meter  ) POCODOT 0.8cm', 'Twill Cotton 60\" / Comb Cotton (Kain Cotton Bidang 60 inci) (Harga untuk 0.5 meter  ) POCODOT 0.8cm', 54.50, 'https://cf.shopee.com.my/file/64540cffd52e9bd13ecdfac26ef9d528', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (506, '0.3M/1.5M/3M/5M/10M High Speed USB 2.0 Printer Cable for Canon Epson HP Printer', '0.3M/1.5M/3M/5M/10M High Speed USB 2.0 Printer Cable for Canon Epson HP Printer', '0.3M/1.5M/3M/5M/10M High Speed USB 2.0 Printer Cable for Canon Epson HP Printer', 46.80, 'https://cf.shopee.com.my/file/2f84a22428d05eeb2cae296533708181', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (507, 'Novel: RAMPAS CINTAMU (Sugar Daddy) | Penulis: Puteri Jacaranda | Penerbit: NovelPlus  | ISBN - 978-967-18358-0-7', 'Novel: RAMPAS CINTAMU (Sugar Daddy) | Penulis: Puteri Jacaranda | Penerbit: NovelPlus  | ISBN - 978-967-18358-0-7', 'Novel: RAMPAS CINTAMU (Sugar Daddy) | Penulis: Puteri Jacaranda | Penerbit: NovelPlus  | ISBN - 978-967-18358-0-7', 280.00, 'https://cf.shopee.com.my/file/df541bc049930c4174fbc79589e440f0', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (508, 'KAIN ELA | KAIN PASANG Material Premium Como Crepe (0.5M) Bidang 60', 'KAIN ELA | KAIN PASANG Material Premium Como Crepe (0.5M) Bidang 60', 'KAIN ELA | KAIN PASANG Material Premium Como Crepe (0.5M) Bidang 60', 24.80, 'https://cf.shopee.com.my/file/e391ff0c03751d1b5403141ddb45b6aa', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (509, '10Pcs/set Creative Cartoon 0.5mm Colorful Gel Pen Set Kawaii  Stationary Flamingo Pen School Stationery Pens Writing Gift', '10Pcs/set Creative Cartoon 0.5mm Colorful Gel Pen Set Kawaii  Stationary Flamingo Pen School Stationery Pens Writing Gift', '10Pcs/set Creative Cartoon 0.5mm Colorful Gel Pen Set Kawaii  Stationary Flamingo Pen School Stationery Pens Writing Gift', 66.40, 'https://cf.shopee.com.my/file/c88f90922fb4782803e6d2649f29f0f3', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (510, 'Animal Crossing: New Horizon Flowers - All colors flower plant only RM 0.10 for each', 'Animal Crossing: New Horizon Flowers - All colors flower plant only RM 0.10 for each', 'Animal Crossing: New Horizon Flowers - All colors flower plant only RM 0.10 for each', 1.00, 'https://cf.shopee.com.my/file/b14198520827417eddf3c4cccb23d8d6', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (511, '1 Pair Newborn 0-12m Winter Design Cotton Comfortable Socks Stocking Baby', '1 Pair Newborn 0-12m Winter Design Cotton Comfortable Socks Stocking Baby', '1 Pair Newborn 0-12m Winter Design Cotton Comfortable Socks Stocking Baby', 32.00, 'https://cf.shopee.com.my/file/13aab59b8e613fd0492ebd6790b50a5f', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (512, '16 inch Large Size Oversize Number Silver Foil Balloon 0 to 9 Helium Belon Nombor Happy Birthday Hadiah Ulang Tahun', '16 inch Large Size Oversize Number Silver Foil Balloon 0 to 9 Helium Belon Nombor Happy Birthday Hadiah Ulang Tahun', '16 inch Large Size Oversize Number Silver Foil Balloon 0 to 9 Helium Belon Nombor Happy Birthday Hadiah Ulang Tahun', 9.80, 'https://cf.shopee.com.my/file/0707a0b7b7553b6f4769580a4bef38aa', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (513, '[M\'sia] Big Size (80cm*30cm*0.2cm) Gaming Mouse Pad Mousepad for Dota LOL CS GO', '[M\'sia] Big Size (80cm*30cm*0.2cm) Gaming Mouse Pad Mousepad for Dota LOL CS GO', '[M\'sia] Big Size (80cm*30cm*0.2cm) Gaming Mouse Pad Mousepad for Dota LOL CS GO', 69.00, 'https://cf.shopee.com.my/file/c2f9972d9403088482cea044ab24bd09', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (514, 'Dia 0.5-1.0mm Transparent Elastic Crystal Line Making Beading Rope String Cord Thread', 'Dia 0.5-1.0mm Transparent Elastic Crystal Line Making Beading Rope String Cord Thread', 'Dia 0.5-1.0mm Transparent Elastic Crystal Line Making Beading Rope String Cord Thread', 10.10, 'https://cf.shopee.com.my/file/5073d23a31a46de2f38435a50a6116e8', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (515, 'Apacer AH334 Pendrive - Usb2.0/Compatible With Usb 3.0 (16GB/32GB/64GB) flash drive', 'Apacer AH334 Pendrive - Usb2.0/Compatible With Usb 3.0 (16GB/32GB/64GB) flash drive', 'Apacer AH334 Pendrive - Usb2.0/Compatible With Usb 3.0 (16GB/32GB/64GB) flash drive', 149.90, 'https://cf.shopee.com.my/file/226473cc8ee02a16c42aeb9bd179e25e', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (518, 'Tefal Rice Cooker Mini (0.7L) RK5001', 'Tefal Rice Cooker Mini (0.7L) RK5001', 'Tefal Rice Cooker Mini (0.7L) RK5001', 1890.00, 'https://cf.shopee.com.my/file/224ef41c460e11bdebaa6a0f12fa5042', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (519, 'BABY Newborn baby wear Infant summer suit ,baju set cotton/ bayi berjaring/lubang baju baby/mitten&booties set 0-3months', 'BABY Newborn baby wear Infant summer suit ,baju set cotton/ bayi berjaring/lubang baju baby/mitten&booties set 0-3months', 'BABY Newborn baby wear Infant summer suit ,baju set cotton/ bayi berjaring/lubang baju baby/mitten&booties set 0-3months', 39.00, 'https://cf.shopee.com.my/file/163d581efcb082d7ee4a310edee74af6', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (520, '10.1/11.6/12.1/14.0/15.6/17 inch Notebook Dustproof Keyboard Cover Universal Silicone Laptop Keyboard Protector', '10.1/11.6/12.1/14.0/15.6/17 inch Notebook Dustproof Keyboard Cover Universal Silicone Laptop Keyboard Protector', '10.1/11.6/12.1/14.0/15.6/17 inch Notebook Dustproof Keyboard Cover Universal Silicone Laptop Keyboard Protector', 25.00, 'https://cf.shopee.com.my/file/40d5c25038418f4c1703cafe5ef9e161', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (521, 'SACE LADY Matte Cream Concealer Full Coverage Waterproof Face Makeup Cosmetics 6g/0.2oz', 'SACE LADY Matte Cream Concealer Full Coverage Waterproof Face Makeup Cosmetics 6g/0.2oz', 'SACE LADY Matte Cream Concealer Full Coverage Waterproof Face Makeup Cosmetics 6g/0.2oz', 39.90, 'https://cf.shopee.com.my/file/8e3e4113fd00cc39877086b6dc740d54', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (522, 'Boy fashion suit Baju corak bunga untuk kanak-kanak lelaki, sesuai untuk kanak-kanak berumur 0-5 tahun Baby boy T-shirt Boy shirt', 'Boy fashion suit Baju corak bunga untuk kanak-kanak lelaki, sesuai untuk kanak-kanak berumur 0-5 tahun Baby boy T-shirt Boy shirt', 'Boy fashion suit Baju corak bunga untuk kanak-kanak lelaki, sesuai untuk kanak-kanak berumur 0-5 tahun Baby boy T-shirt Boy shirt', 137.20, 'https://cf.shopee.com.my/file/4a86f185ddb8bbbc1e6f28104472eed5', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (523, 'VAPESAJA Original Nevoks Feelin Occ Nevoks Pagee Occ SPL 10 Mesh Coil 0.6 Ohm 0.8 Ohm 1.0 Ohm', 'VAPESAJA Original Nevoks Feelin Occ Nevoks Pagee Occ SPL 10 Mesh Coil 0.6 Ohm 0.8 Ohm 1.0 Ohm', 'VAPESAJA Original Nevoks Feelin Occ Nevoks Pagee Occ SPL 10 Mesh Coil 0.6 Ohm 0.8 Ohm 1.0 Ohm', 80.00, 'https://cf.shopee.com.my/file/2eabf72e8c56221f3bfbf173dc8c6b83', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (524, 'Faber Castell Air Gel Pen Refill 0.5/0.7- (1s/ PKT)', 'Faber Castell Air Gel Pen Refill 0.5/0.7- (1s/ PKT)', 'Faber Castell Air Gel Pen Refill 0.5/0.7- (1s/ PKT)', 25.00, 'https://cf.shopee.com.my/file/767b8b1e111caf6391b2c936d96b9100', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (525, 'Reben satin 0.5inch 25yd satin ribbon 1gulung', 'Reben satin 0.5inch 25yd satin ribbon 1gulung', 'Reben satin 0.5inch 25yd satin ribbon 1gulung', 28.00, 'https://cf.shopee.com.my/file/a5bb9a9619030791de95ba0d53d5bff8', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (527, 'UTS GANCU Jigging Hook 1/0;2/0;3/0;4/0  (20/50PCS)', 'UTS GANCU Jigging Hook 1/0;2/0;3/0;4/0  (20/50PCS)', 'UTS GANCU Jigging Hook 1/0;2/0;3/0;4/0  (20/50PCS)', 120.00, 'https://cf.shopee.com.my/file/185662a817b4cb71a5e032f7b218a30e', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (528, 'CASTROL SCOOTER GEAR OIL 0.12L 100% Original NVX Vario NMAX XMAX VESPA EGO NOUVO', 'CASTROL SCOOTER GEAR OIL 0.12L 100% Original NVX Vario NMAX XMAX VESPA EGO NOUVO', 'CASTROL SCOOTER GEAR OIL 0.12L 100% Original NVX Vario NMAX XMAX VESPA EGO NOUVO', 65.00, 'https://cf.shopee.com.my/file/9bd9650c3238dd87bb698bfe2b27b7aa', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (529, 'Perfume Pipette 0.5ML,3ML,5ML & 10ML', 'Perfume Pipette 0.5ML,3ML,5ML & 10ML', 'Perfume Pipette 0.5ML,3ML,5ML & 10ML', 2.50, 'https://cf.shopee.com.my/file/e1ba69f82fe6161712cce577d0e94cda', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (530, 'Anti Mosquito Net Happy Baby Crib Bed Netting Portable Travel Foldable Net Kelambu (0-24month)', 'Anti Mosquito Net Happy Baby Crib Bed Netting Portable Travel Foldable Net Kelambu (0-24month)', 'Anti Mosquito Net Happy Baby Crib Bed Netting Portable Travel Foldable Net Kelambu (0-24month)', 122.40, 'https://cf.shopee.com.my/file/8de9142c1197ac23355aa2fa63b0ff8e', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (531, '(0.00 to 500) 1 piece freshkon fusion daily color brilliant brown (loose pack)', '(0.00 to 500) 1 piece freshkon fusion daily color brilliant brown (loose pack)', '(0.00 to 500) 1 piece freshkon fusion daily color brilliant brown (loose pack)', 20.50, 'https://cf.shopee.com.my/file/f9720972598acbed59909e415fb03184', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (532, '20 yards Getah Pinggang Kain Elastic Tape / Size 0.5\", 0.75\" & 1\"', '20 yards Getah Pinggang Kain Elastic Tape / Size 0.5\", 0.75\" & 1\"', '20 yards Getah Pinggang Kain Elastic Tape / Size 0.5\", 0.75\" & 1\"', 70.00, 'https://cf.shopee.com.my/file/f6d250c231bfa64c422a0ea05018f401', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (533, 'Local Seller Ready stock 0-24M baby rompers Newborn Infant Baby Boy Girl Short sleeve kids clothes .', 'Local Seller Ready stock 0-24M baby rompers Newborn Infant Baby Boy Girl Short sleeve kids clothes .', 'Local Seller Ready stock 0-24M baby rompers Newborn Infant Baby Boy Girl Short sleeve kids clothes .', 96.50, 'https://cf.shopee.com.my/file/e287ebd12d848bbe6f4b713fcb4b00cd', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (535, 'VR Vritual Reality Shinecon 6.0 Bluetooth Headset VR Glasses Helmet 3D Box support 7 inch,VR Handset,VR Box', 'VR Vritual Reality Shinecon 6.0 Bluetooth Headset VR Glasses Helmet 3D Box support 7 inch,VR Handset,VR Box', 'VR Vritual Reality Shinecon 6.0 Bluetooth Headset VR Glasses Helmet 3D Box support 7 inch,VR Handset,VR Box', 137.00, 'https://cf.shopee.com.my/file/a72c5861d425da7d60967b363f59ccdd', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (536, 'Dutch Baby 0 - 12 Months 900g', 'Dutch Baby 0 - 12 Months 900g', 'Dutch Baby 0 - 12 Months 900g', 269.90, 'https://cf.shopee.com.my/file/eb279c7e7bc056b8a3f1aaddd57831b9', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (538, 'AVON True Color Glimmersticks EYE LINER 0.28g (Black, Brown, Blue)', 'AVON True Color Glimmersticks EYE LINER 0.28g (Black, Brown, Blue)', 'AVON True Color Glimmersticks EYE LINER 0.28g (Black, Brown, Blue)', 88.00, 'https://cf.shopee.com.my/file/493eb2cea81089b471c101154065971b', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (539, 'Big Size(70cm*30cm*0.2cm) Gaming World Map Mouse Pad Mousepad for Dota LOL CS GO', 'Big Size(70cm*30cm*0.2cm) Gaming World Map Mouse Pad Mousepad for Dota LOL CS GO', 'Big Size(70cm*30cm*0.2cm) Gaming World Map Mouse Pad Mousepad for Dota LOL CS GO', 48.00, 'https://cf.shopee.com.my/file/7273325a6bacacfbad6aa22bbccbd693', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (540, 'Baju Baby Boy Girl (0-24months) Baju Budak Lelaki Perempuan Baju Baby Newborn Baby Clothing Baby Clothes', 'Baju Baby Boy Girl (0-24months) Baju Budak Lelaki Perempuan Baju Baby Newborn Baby Clothing Baby Clothes', 'Baju Baby Boy Girl (0-24months) Baju Budak Lelaki Perempuan Baju Baby Newborn Baby Clothing Baby Clothes', 89.70, 'https://cf.shopee.com.my/file/cfcba1a84761e96b98feceea34652c9c', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (541, '[0.04] Printing, Photocopy Book, Print, Cetak A4, Single-Sided - BLACK & WHITE, | Photocopy | Fotostat | EBook', '[0.04] Printing, Photocopy Book, Print, Cetak A4, Single-Sided - BLACK & WHITE, | Photocopy | Fotostat | EBook', '[0.04] Printing, Photocopy Book, Print, Cetak A4, Single-Sided - BLACK & WHITE, | Photocopy | Fotostat | EBook', 1.00, 'https://cf.shopee.com.my/file/0362ec1e3437aede38cb83febec9b5b6', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (542, 'Teclast M40 Tablet PC Android 10.0 Tablets 6GB RAM 128GB ROM 10.1 inch 8MP Dual Camera Dual 4G Phone Call Bluetooth 5.0 UNISOC T618 Octa Core/1 Year Warranty', 'Teclast M40 Tablet PC Android 10.0 Tablets 6GB RAM 128GB ROM 10.1 inch 8MP Dual Camera Dual 4G Phone Call Bluetooth 5.0 UNISOC T618 Octa Core/1 Year Warranty', 'Teclast M40 Tablet PC Android 10.0 Tablets 6GB RAM 128GB ROM 10.1 inch 8MP Dual Camera Dual 4G Phone Call Bluetooth 5.0 UNISOC T618 Octa Core/1 Year Warranty', 6990.00, 'https://cf.shopee.com.my/file/5d2916d4a8000bb01c764693934184c7', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (543, '0-12month baby rompers Long sleeve cotton newborn baby clothes jumpsuit baby boys girls clothes', '0-12month baby rompers Long sleeve cotton newborn baby clothes jumpsuit baby boys girls clothes', '0-12month baby rompers Long sleeve cotton newborn baby clothes jumpsuit baby boys girls clothes', 130.90, 'https://cf.shopee.com.my/file/20a803b652c97e14241b0a85c6b9115f', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (544, 'Reben satin 0.25inch 15yd satin ribbon 1gulung', 'Reben satin 0.25inch 15yd satin ribbon 1gulung', 'Reben satin 0.25inch 15yd satin ribbon 1gulung', 8.00, 'https://cf.shopee.com.my/file/a09c75c298cd57cddd5ef8de1791aa48', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (545, '0-4 years old boy clothing summer baby boy fashion cartoon giraffe shirt T-shirt + shorts 2 piece set', '0-4 years old boy clothing summer baby boy fashion cartoon giraffe shirt T-shirt + shorts 2 piece set', '0-4 years old boy clothing summer baby boy fashion cartoon giraffe shirt T-shirt + shorts 2 piece set', 150.90, 'https://cf.shopee.com.my/file/18bd7805fc1312e92372048a8f38f301', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (546, 'ORICO 2020U3 USB3.0 Hard Disk Case Enclosure (2.5\")', 'ORICO 2020U3 USB3.0 Hard Disk Case Enclosure (2.5\")', 'ORICO 2020U3 USB3.0 Hard Disk Case Enclosure (2.5\")', 250.00, 'https://cf.shopee.com.my/file/d88b1425b30195df64328d86c8c379ee', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (547, 'Matt Satin Bidang 60 Kain Langsir  READY STOCK  | Matte Sateen Part 2 (0.5m/unit)', 'Matt Satin Bidang 60 Kain Langsir  READY STOCK  | Matte Sateen Part 2 (0.5m/unit)', 'Matt Satin Bidang 60 Kain Langsir  READY STOCK  | Matte Sateen Part 2 (0.5m/unit)', 34.60, 'https://cf.shopee.com.my/file/a2e0831b4366047cb7a43d6fe75d2649', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (549, 'Hard Disk Case Enclosure HDD SATA 2.5 inch notebook external hard disk USB2.0 USB3.0 External Hard Drive screw free', 'Hard Disk Case Enclosure HDD SATA 2.5 inch notebook external hard disk USB2.0 USB3.0 External Hard Drive screw free', 'Hard Disk Case Enclosure HDD SATA 2.5 inch notebook external hard disk USB2.0 USB3.0 External Hard Drive screw free', 179.00, 'https://cf.shopee.com.my/file/7da2db8c36ab74c219ca1b70135cf1b1', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (550, 'Baby Mask Kids Mask 0-2 3-5 years old 3D Face Mask Disposable 3Ply 10pcs', 'Baby Mask Kids Mask 0-2 3-5 years old 3D Face Mask Disposable 3Ply 10pcs', 'Baby Mask Kids Mask 0-2 3-5 years old 3D Face Mask Disposable 3Ply 10pcs', 98.00, 'https://cf.shopee.com.my/file/98d81406856508ae9de57e7d8a0e3429', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (551, '130 DC Motor / DC Motor with Wire / 89mm Propeller -Mini Small 1-6v 0.4A High Speed Toy Toys RC 2WD Car Arduino Robotics', '130 DC Motor / DC Motor with Wire / 89mm Propeller -Mini Small 1-6v 0.4A High Speed Toy Toys RC 2WD Car Arduino Robotics', '130 DC Motor / DC Motor with Wire / 89mm Propeller -Mini Small 1-6v 0.4A High Speed Toy Toys RC 2WD Car Arduino Robotics', 19.00, 'https://cf.shopee.com.my/file/270efeaa2ab6ff1eb1c27960aec7bd81', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (552, 'AMZ Wall Paper Dinding Premium Thick 4.5mm Or Standard 3.0mm (+-0.5)DIY Wallpaper 3D Brick 70x77cm Waterproof', 'AMZ Wall Paper Dinding Premium Thick 4.5mm Or Standard 3.0mm (+-0.5)DIY Wallpaper 3D Brick 70x77cm Waterproof', 'AMZ Wall Paper Dinding Premium Thick 4.5mm Or Standard 3.0mm (+-0.5)DIY Wallpaper 3D Brick 70x77cm Waterproof', 17.90, 'https://cf.shopee.com.my/file/121cdaa1fba9432e92e36115a73ac58a', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (553, 'UYAAI Magic Series Colored Contact Lenses 2pcs(1Pair) Yearly Use 0 degree -Gray', 'UYAAI Magic Series Colored Contact Lenses 2pcs(1Pair) Yearly Use 0 degree -Gray', 'UYAAI Magic Series Colored Contact Lenses 2pcs(1Pair) Yearly Use 0 degree -Gray', 59.00, 'https://cf.shopee.com.my/file/86dec3e90dd41a3e041b7d125117703a', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (554, 'Midea Rice Cooker (0.6 L) MG-GP06B MGGP06B', 'Midea Rice Cooker (0.6 L) MG-GP06B MGGP06B', 'Midea Rice Cooker (0.6 L) MG-GP06B MGGP06B', 509.00, 'https://cf.shopee.com.my/file/ced693830c4cc5b2e0ac7abefe5ee029', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (556, 'Newborn Baby Boy Summer Clothes Set Cotton Solid Letters Print Short Sleeve Romper Camouflage Pants and Camouflage Hat 3pcs Outfits Cool Breath 0-18 Months', 'Newborn Baby Boy Summer Clothes Set Cotton Solid Letters Print Short Sleeve Romper Camouflage Pants and Camouflage Hat 3pcs Outfits Cool Breath 0-18 Months', 'Newborn Baby Boy Summer Clothes Set Cotton Solid Letters Print Short Sleeve Romper Camouflage Pants and Camouflage Hat 3pcs Outfits Cool Breath 0-18 Months', 206.00, 'https://cf.shopee.com.my/file/66d81e8ae7da4716eb4d5e466f0486ec', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (557, 'Winzige 20 Colors Retro Gel Pen 0.5mm Journal Vintage Gel Pen Marker Pen Office School Supplies', 'Winzige 20 Colors Retro Gel Pen 0.5mm Journal Vintage Gel Pen Marker Pen Office School Supplies', 'Winzige 20 Colors Retro Gel Pen 0.5mm Journal Vintage Gel Pen Marker Pen Office School Supplies', 22.90, 'https://cf.shopee.com.my/file/e2dfe2535df2681ef27d373e0214e753', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (558, '4.0\" 4.5\" 6.0\" 8.0\" Sofa Leg Bulat Furniture Leg Kaki Perabot DIY Gold Plate High Class', '4.0\" 4.5\" 6.0\" 8.0\" Sofa Leg Bulat Furniture Leg Kaki Perabot DIY Gold Plate High Class', '4.0\" 4.5\" 6.0\" 8.0\" Sofa Leg Bulat Furniture Leg Kaki Perabot DIY Gold Plate High Class', 70.00, 'https://cf.shopee.com.my/file/72d01f608ebedcfdae4cd6a203bc1034', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (559, '0-3Year Newborn Baby Cotton Autumn And Winter Terry Thickening Baby Socks Non-Slip Baby Floor Socks In The Tube Socks Children Socks', '0-3Year Newborn Baby Cotton Autumn And Winter Terry Thickening Baby Socks Non-Slip Baby Floor Socks In The Tube Socks Children Socks', '0-3Year Newborn Baby Cotton Autumn And Winter Terry Thickening Baby Socks Non-Slip Baby Floor Socks In The Tube Socks Children Socks', 39.00, 'https://cf.shopee.com.my/file/4dd9bd42182f0a3595c362c34068a8fd', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (561, 'Original SMOK RPM40 / Fetch 5Pcs Occ / 0.17 RGC Coil / 0.4 Mesh / 1.0 SC / 0.6 Triple', 'Original SMOK RPM40 / Fetch 5Pcs Occ / 0.17 RGC Coil / 0.4 Mesh / 1.0 SC / 0.6 Triple', 'Original SMOK RPM40 / Fetch 5Pcs Occ / 0.17 RGC Coil / 0.4 Mesh / 1.0 SC / 0.6 Triple', 300.00, 'https://cf.shopee.com.my/file/76c2baba07a777fe107d4277ea251c1e', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (563, '40 Inch Super Large Size Number Aluminium Foil Balloon 0 to 9 Digital Happy Birthday Helium Gas Float Bobo Belon Nombor', '40 Inch Super Large Size Number Aluminium Foil Balloon 0 to 9 Digital Happy Birthday Helium Gas Float Bobo Belon Nombor', '40 Inch Super Large Size Number Aluminium Foil Balloon 0 to 9 Digital Happy Birthday Helium Gas Float Bobo Belon Nombor', 48.90, 'https://cf.shopee.com.my/file/f0fd765f1513c0f303750a30008ee346', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (564, '[Ship Today]LM.20pcs Cute Unicorn Pen stationery Set penyidai baju Pencil Bag Student Stationery Pencil Box School Supplies Cute Animal Pattern School Office 0.5mm Black Ink', '[Ship Today]LM.20pcs Cute Unicorn Pen stationery Set penyidai baju Pencil Bag Student Stationery Pencil Box School Supplies Cute Animal Pattern School Office 0.5mm Black Ink', '[Ship Today]LM.20pcs Cute Unicorn Pen stationery Set penyidai baju Pencil Bag Student Stationery Pencil Box School Supplies Cute Animal Pattern School Office 0.5mm Black Ink', 59.90, 'https://cf.shopee.com.my/file/f7d09f0608f21a2b018ba5dc31830417', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (565, 'Air Conditioner Cleaning Cover 1-1.5hp 2.0-3.0hp Cover Cuci Aircond Canvas DIY', 'Air Conditioner Cleaning Cover 1-1.5hp 2.0-3.0hp Cover Cuci Aircond Canvas DIY', 'Air Conditioner Cleaning Cover 1-1.5hp 2.0-3.0hp Cover Cuci Aircond Canvas DIY', 225.00, 'https://cf.shopee.com.my/file/9e5395317773a47e08f29e0b3503574c', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (567, 'Public Gold LBMA Bullion Bar PG 0.5g - Tun Mahathir', 'Public Gold LBMA Bullion Bar PG 0.5g - Tun Mahathir', 'Public Gold LBMA Bullion Bar PG 0.5g - Tun Mahathir', 1900.00, 'https://cf.shopee.com.my/file/d4f5a020bb9b2b654bd8261823790903', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (568, '12Size Sakura Pigma Micron Pen-SIZE :1.0/005/01/02/03/04/05/08/1/2/3/BR/', '12Size Sakura Pigma Micron Pen-SIZE :1.0/005/01/02/03/04/05/08/1/2/3/BR/', '12Size Sakura Pigma Micron Pen-SIZE :1.0/005/01/02/03/04/05/08/1/2/3/BR/', 16.90, 'https://cf.shopee.com.my/file/8a1a87c8bce14c0aed4d5eb37db01ee3', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (569, '[READY STOCK] Original Cartridges Werti Guard 1.0/1.3 Ohm Dual Coils 3pcs Per Pack', '[READY STOCK] Original Cartridges Werti Guard 1.0/1.3 Ohm Dual Coils 3pcs Per Pack', '[READY STOCK] Original Cartridges Werti Guard 1.0/1.3 Ohm Dual Coils 3pcs Per Pack', 250.00, 'https://cf.shopee.com.my/file/84e22773089b5f20305ae8934d1fd964', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (571, 'Faber Castell RX Gel Pen 0.5mm', 'Faber Castell RX Gel Pen 0.5mm', 'Faber Castell RX Gel Pen 0.5mm', 14.40, 'https://cf.shopee.com.my/file/89507c7600b91f0efb21e9a82b783922', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (572, 'Japan Toho Round Seed Beads Opaque 11/0 (20g) paket kecil (11 warna)', 'Japan Toho Round Seed Beads Opaque 11/0 (20g) paket kecil (11 warna)', 'Japan Toho Round Seed Beads Opaque 11/0 (20g) paket kecil (11 warna)', 50.00, 'https://cf.shopee.com.my/file/1e13b122306922196dd1f4e27e4faff1', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (573, 'NEWBORN BABY SUIT | BABY SET | BABY CLOTHING 0~3 month', 'NEWBORN BABY SUIT | BABY SET | BABY CLOTHING 0~3 month', 'NEWBORN BABY SUIT | BABY SET | BABY CLOTHING 0~3 month', 89.00, 'https://cf.shopee.com.my/file/427b4dabb42f67dfe11ccaa47c86ed72', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (575, '[0 - 6 MONTHS] Foot Finder | Wrist | Rattle | Wind Chimes - Baby Plush Soft Toy Toys Infant Animal Lion Giraffe Squeeze', '[0 - 6 MONTHS] Foot Finder | Wrist | Rattle | Wind Chimes - Baby Plush Soft Toy Toys Infant Animal Lion Giraffe Squeeze', '[0 - 6 MONTHS] Foot Finder | Wrist | Rattle | Wind Chimes - Baby Plush Soft Toy Toys Infant Animal Lion Giraffe Squeeze', 73.70, 'https://cf.shopee.com.my/file/7524d8caf07575f33fb2e17af7edef25', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (576, 'Sweet Heart Paris CS375 Group 0+ Car Seat Carrier with Adjustable Canopy ECE R44/04 Verified (4 Colours Available)', 'Sweet Heart Paris CS375 Group 0+ Car Seat Carrier with Adjustable Canopy ECE R44/04 Verified (4 Colours Available)', 'Sweet Heart Paris CS375 Group 0+ Car Seat Carrier with Adjustable Canopy ECE R44/04 Verified (4 Colours Available)', 1190.00, 'https://cf.shopee.com.my/file/0df8c9ecf92eeab9fddec7ddbb13c52f', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (577, '1 Roll Fish Line Wire Clear Non-stretch Strong Nylon String 0.2/0.25/0.3/0.35/0.4/0.45/0.5/0.6mm  Beading Cord Thread Jewelry Making', '1 Roll Fish Line Wire Clear Non-stretch Strong Nylon String 0.2/0.25/0.3/0.35/0.4/0.45/0.5/0.6mm  Beading Cord Thread Jewelry Making', '1 Roll Fish Line Wire Clear Non-stretch Strong Nylon String 0.2/0.25/0.3/0.35/0.4/0.45/0.5/0.6mm  Beading Cord Thread Jewelry Making', 10.50, 'https://cf.shopee.com.my/file/a74d3480273d0695b6e60bca85375692', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (578, '0.3M/1.5M/3M/5M/10M High Speed USB 2.0 Extension Cable', '0.3M/1.5M/3M/5M/10M High Speed USB 2.0 Extension Cable', '0.3M/1.5M/3M/5M/10M High Speed USB 2.0 Extension Cable', 38.80, 'https://cf.shopee.com.my/file/a0789fc7a2dc2a27332e00650564aa15', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (580, 'SS Pan Head Machine Screw M3 x 6mm ~ 20mm (Coarse Thread Pitch 0.5mm) (Stainless Steel 304 Phillips PH MC Bolt)', 'SS Pan Head Machine Screw M3 x 6mm ~ 20mm (Coarse Thread Pitch 0.5mm) (Stainless Steel 304 Phillips PH MC Bolt)', 'SS Pan Head Machine Screw M3 x 6mm ~ 20mm (Coarse Thread Pitch 0.5mm) (Stainless Steel 304 Phillips PH MC Bolt)', 1.00, 'https://cf.shopee.com.my/file/07a33ebab3737f67b70d6fa47ce6e8e4', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (584, 'Tribit XFree Go Bluetooth Headphones - Bluetooth 5.0, 24 Hours Play Time, CVC8.0, High Clarity', 'Tribit XFree Go Bluetooth Headphones - Bluetooth 5.0, 24 Hours Play Time, CVC8.0, High Clarity', 'Tribit XFree Go Bluetooth Headphones - Bluetooth 5.0, 24 Hours Play Time, CVC8.0, High Clarity', 1350.00, 'https://cf.shopee.com.my/file/a6f61e4846bbbed6deb72c16ea1061ec', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (585, 'USB 3.0/Type-C External DVD Drive Portable DVD Burner Writer Rewriter DVD/CD/VCD Player ROM Drive for Window 7/8/10', 'USB 3.0/Type-C External DVD Drive Portable DVD Burner Writer Rewriter DVD/CD/VCD Player ROM Drive for Window 7/8/10', 'USB 3.0/Type-C External DVD Drive Portable DVD Burner Writer Rewriter DVD/CD/VCD Player ROM Drive for Window 7/8/10', 564.00, 'https://cf.shopee.com.my/file/db77a04494c80555aea8c127e39e2dac', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (586, '1pcs Freshkon Fusion Daily Color Brilliant Brown - 0.00 to -5.00 (1 Pc)', '1pcs Freshkon Fusion Daily Color Brilliant Brown - 0.00 to -5.00 (1 Pc)', '1pcs Freshkon Fusion Daily Color Brilliant Brown - 0.00 to -5.00 (1 Pc)', 20.50, 'https://cf.shopee.com.my/file/b6165767c2ad9eb1cbd40e2734911f04', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (589, '13yrd /ROLL 0.635cm (1/4\') SATIN RIBBON / REBEN  / RIBBON HADIAH / RB-134', '13yrd /ROLL 0.635cm (1/4\') SATIN RIBBON / REBEN  / RIBBON HADIAH / RB-134', '13yrd /ROLL 0.635cm (1/4\') SATIN RIBBON / REBEN  / RIBBON HADIAH / RB-134', 8.00, 'https://cf.shopee.com.my/file/24f9770e290d6c4d8658e20acaa768b4', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (591, '(0-12Y) KIDS SHORT PANTS BOY & GIRL CASUAL COTTON / SELUAR PENDEK BUDAK LELAKI PEREMPUAN', '(0-12Y) KIDS SHORT PANTS BOY & GIRL CASUAL COTTON / SELUAR PENDEK BUDAK LELAKI PEREMPUAN', '(0-12Y) KIDS SHORT PANTS BOY & GIRL CASUAL COTTON / SELUAR PENDEK BUDAK LELAKI PEREMPUAN', 29.90, 'https://cf.shopee.com.my/file/d8c943635c1f79de249089d1155fe08f', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (592, 'Number foil balloon 0 to 9 16 inch Gold Silver color', 'Number foil balloon 0 to 9 16 inch Gold Silver color', 'Number foil balloon 0 to 9 16 inch Gold Silver color', 9.90, 'https://cf.shopee.com.my/file/522b9e883343a80eaf017ab75e79151a', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (593, 'IN STOCK HUAWEI 2TB 1TB USB3.0 Flash Drive Metal Waterproof High Speed U Disk Flash Drive Memory Card', 'IN STOCK HUAWEI 2TB 1TB USB3.0 Flash Drive Metal Waterproof High Speed U Disk Flash Drive Memory Card', 'IN STOCK HUAWEI 2TB 1TB USB3.0 Flash Drive Metal Waterproof High Speed U Disk Flash Drive Memory Card', 80.00, 'https://cf.shopee.com.my/file/5a802538834649756e70906164d42f60', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (594, 'LC135 ALLOY VPRO BLOCK GASKET 74MM / 78MM SPACER ASHUKA 0.3MM 0.4Mm 0.5MM 0.8M 1MM 2MM 3MM 4MM 4.5MM 5MM 6MM 7MM 8MM 9MM', 'LC135 ALLOY VPRO BLOCK GASKET 74MM / 78MM SPACER ASHUKA 0.3MM 0.4Mm 0.5MM 0.8M 1MM 2MM 3MM 4MM 4.5MM 5MM 6MM 7MM 8MM 9MM', 'LC135 ALLOY VPRO BLOCK GASKET 74MM / 78MM SPACER ASHUKA 0.3MM 0.4Mm 0.5MM 0.8M 1MM 2MM 3MM 4MM 4.5MM 5MM 6MM 7MM 8MM 9MM', 59.00, 'https://cf.shopee.com.my/file/8530f36db63af6b2f2e4ab6962fafcaf', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (595, 'Kids Tales One Piece Romper Jumpsuit Newborn Infant Toddler Baby Baby Girl Baby Boy Cartoon Printed Short Sleeve Rompers 0-3 Years Bonds', 'Kids Tales One Piece Romper Jumpsuit Newborn Infant Toddler Baby Baby Girl Baby Boy Cartoon Printed Short Sleeve Rompers 0-3 Years Bonds', 'Kids Tales One Piece Romper Jumpsuit Newborn Infant Toddler Baby Baby Girl Baby Boy Cartoon Printed Short Sleeve Rompers 0-3 Years Bonds', 209.80, 'https://cf.shopee.com.my/file/524c42307a3b37b4f60fe90e74289d94', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (596, 'Lovely Baby Girls Shoes Soft Toddler Flower Shoes 0-18M', 'Lovely Baby Girls Shoes Soft Toddler Flower Shoes 0-18M', 'Lovely Baby Girls Shoes Soft Toddler Flower Shoes 0-18M', 103.50, 'https://cf.shopee.com.my/file/db59ad588f5d1657d110e017ff7bbfaf', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (597, 'Ready Stock 100% Good Cotton Baby Romper Newborn Baju Bayi Infant Pajamas Boy Girl Long Sleeves Romper Jumpsuit Cartoon Bodysuit Baby One Pieces 0-18 months', 'Ready Stock 100% Good Cotton Baby Romper Newborn Baju Bayi Infant Pajamas Boy Girl Long Sleeves Romper Jumpsuit Cartoon Bodysuit Baby One Pieces 0-18 months', 'Ready Stock 100% Good Cotton Baby Romper Newborn Baju Bayi Infant Pajamas Boy Girl Long Sleeves Romper Jumpsuit Cartoon Bodysuit Baby One Pieces 0-18 months', 98.00, 'https://cf.shopee.com.my/file/72f3ae456ace827629a00d34caabb3b7', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (598, 'Faber Castell NX23 Ball Pen 0.5MM- Black-0585', 'Faber Castell NX23 Ball Pen 0.5MM- Black-0585', 'Faber Castell NX23 Ball Pen 0.5MM- Black-0585', 21.00, 'https://cf.shopee.com.my/file/7a62171ffae8b3979c8d974e47d9c5e1', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (599, '0-5-year-old children\'s summer trend short sleeve cotton shirt with two-piece cotton leisure shorts Baju Baby boy Clothing Wearing', '0-5-year-old children\'s summer trend short sleeve cotton shirt with two-piece cotton leisure shorts Baju Baby boy Clothing Wearing', '0-5-year-old children\'s summer trend short sleeve cotton shirt with two-piece cotton leisure shorts Baju Baby boy Clothing Wearing', 158.80, 'https://cf.shopee.com.my/file/c8697a7472a8487b2bb3682f97181043', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (600, 'M&G R3/R5 Retractable Gel Pen 0.5/0.7mm Bullet Nib (1\'pc)', 'M&G R3/R5 Retractable Gel Pen 0.5/0.7mm Bullet Nib (1\'pc)', 'M&G R3/R5 Retractable Gel Pen 0.5/0.7mm Bullet Nib (1\'pc)', 9.80, 'https://cf.shopee.com.my/file/147d28e032130c8370371f0dbd35cf77', 1627909656, 1, 1);
INSERT INTO `xy_goods_list` VALUES (601, 'M&G R3/R5 Retractable Gel Pen 0.5/0.7mm Bullet Nib (1\'pc)', 'M&G R3/R5 Retractable Gel Pen 0.5/0.7mm Bullet Nib (1\'pc)', 'M&G R3/R5 Retractable Gel Pen 0.5/0.7mm Bullet Nib (1\'pc)', 9.80, 'https://cf.shopee.com.my/file/147d28e032130c8370371f0dbd35cf77', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (602, '(0.03sen/Page) Printing Service | A4 A5 Black & White| Double Sided | Photocopy | Fotostat | TextBook Printing', '(0.03sen/Page) Printing Service | A4 A5 Black & White| Double Sided | Photocopy | Fotostat | TextBook Printing', '(0.03sen/Page) Printing Service | A4 A5 Black & White| Double Sided | Photocopy | Fotostat | TextBook Printing', 1.00, 'https://cf.shopee.com.my/file/12669741522365bef67c8ca72000055d', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (603, 'READY STOCK!! 0.7L 1.5L MANUAL SLOW COOKER STEWING POT BABY PORRIDGE SOUP COOKING CERAMIC', 'READY STOCK!! 0.7L 1.5L MANUAL SLOW COOKER STEWING POT BABY PORRIDGE SOUP COOKING CERAMIC', 'READY STOCK!! 0.7L 1.5L MANUAL SLOW COOKER STEWING POT BABY PORRIDGE SOUP COOKING CERAMIC', 379.00, 'https://cf.shopee.com.my/file/cd2d4b87c834cfde42e0bc7179d632ba', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (604, 'MIDEA 0.6L Mini Conventional Rice Cooker (MG-GP06B / MGGP06B)', 'MIDEA 0.6L Mini Conventional Rice Cooker (MG-GP06B / MGGP06B)', 'MIDEA 0.6L Mini Conventional Rice Cooker (MG-GP06B / MGGP06B)', 468.00, 'https://cf.shopee.com.my/file/e64e09d66fe5353fc80acb2810933730', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (606, '5ft 0.4mm Tikar Getah PVC Brand Florica Buatan Malaysia (5ft 0.4mm PVC Florica Floor Mat Made in Malaysia)', '5ft 0.4mm Tikar Getah PVC Brand Florica Buatan Malaysia (5ft 0.4mm PVC Florica Floor Mat Made in Malaysia)', '5ft 0.4mm Tikar Getah PVC Brand Florica Buatan Malaysia (5ft 0.4mm PVC Florica Floor Mat Made in Malaysia)', 34.90, 'https://cf.shopee.com.my/file/0ba9702c34a98e116f1708c92a03f69b', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (607, 'Tulip Crochet Hooks / Jarum Kait Single Ended Size 0 - 14 & Double Ended 1/0-2/0 & 3/0-4/0', 'Tulip Crochet Hooks / Jarum Kait Single Ended Size 0 - 14 & Double Ended 1/0-2/0 & 3/0-4/0', 'Tulip Crochet Hooks / Jarum Kait Single Ended Size 0 - 14 & Double Ended 1/0-2/0 & 3/0-4/0', 23.00, 'https://cf.shopee.com.my/file/107416ca9a2a52c7a761d3f892ef40a4', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (608, 'Mi TV Stick - Android TV Quad Core 9.0 Dolby DTS HD Dual Decoding', 'Mi TV Stick - Android TV Quad Core 9.0 Dolby DTS HD Dual Decoding', 'Mi TV Stick - Android TV Quad Core 9.0 Dolby DTS HD Dual Decoding', 1590.00, 'https://cf.shopee.com.my/file/9e897a0b777ea8b0d36ac03ed698441c', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (609, '0-3 year old 3D 4-ply Baby Face Mask Kid Face Mask 4 layers Disposable Children Face Mask', '0-3 year old 3D 4-ply Baby Face Mask Kid Face Mask 4 layers Disposable Children Face Mask', '0-3 year old 3D 4-ply Baby Face Mask Kid Face Mask 4 layers Disposable Children Face Mask', 20.10, 'https://cf.shopee.com.my/file/d0bc2544fa7eb4a61826103c143fee18', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (611, 'Novel: AKULAH SI HEROIN | Penulis: Syu Ariani | Penerbit: Karyaseni | ISBN: 978-967-469-124-0', 'Novel: AKULAH SI HEROIN | Penulis: Syu Ariani | Penerbit: Karyaseni | ISBN: 978-967-469-124-0', 'Novel: AKULAH SI HEROIN | Penulis: Syu Ariani | Penerbit: Karyaseni | ISBN: 978-967-469-124-0', 190.00, 'https://cf.shopee.com.my/file/7bcca64fed1f977914a040a1b356af15', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (612, 'My Flavor Oil Based Colors 25g (0.88oz)', 'My Flavor Oil Based Colors 25g (0.88oz)', 'My Flavor Oil Based Colors 25g (0.88oz)', 55.00, 'https://cf.shopee.com.my/file/f88b78a95d4be6806da815d306da0c09', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (613, 'Radiator cap R124, R148, R125, R126(0.9&1.1)for Proton Saga iswara wira blm gen2 persona, perdoua myvi kenari kelisa', 'Radiator cap R124, R148, R125, R126(0.9&1.1)for Proton Saga iswara wira blm gen2 persona, perdoua myvi kenari kelisa', 'Radiator cap R124, R148, R125, R126(0.9&1.1)for Proton Saga iswara wira blm gen2 persona, perdoua myvi kenari kelisa', 68.90, 'https://cf.shopee.com.my/file/255f82c8025e02e6a917bbd471497fe9', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (615, '**Mark on most surface** Changli Dual Tip 0.5/1 mm Permanent Marker Pen', '**Mark on most surface** Changli Dual Tip 0.5/1 mm Permanent Marker Pen', '**Mark on most surface** Changli Dual Tip 0.5/1 mm Permanent Marker Pen', 7.00, 'https://cf.shopee.com.my/file/fab1a7a2b9a89b79b0df84c050d4b29b', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (616, '(0.30sen/Page) COLOUR A4 Printing service | Photocopy | Ebook | Notes | Examspaper | Booklet | Slides | Manga | Brochure', '(0.30sen/Page) COLOUR A4 Printing service | Photocopy | Ebook | Notes | Examspaper | Booklet | Slides | Manga | Brochure', '(0.30sen/Page) COLOUR A4 Printing service | Photocopy | Ebook | Notes | Examspaper | Booklet | Slides | Manga | Brochure', 3.00, 'https://cf.shopee.com.my/file/8f8170fad06743bf5c7c58f4551305be', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (617, 'CAT6 Solid Copper 23AWG Network Cable | 0.5m-15m', 'CAT6 Solid Copper 23AWG Network Cable | 0.5m-15m', 'CAT6 Solid Copper 23AWG Network Cable | 0.5m-15m', 119.00, 'https://cf.shopee.com.my/file/a3939b5190b593d79c942dac06b2308c', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (618, 'Part 1 Heavy Premium Como Crepe (harga utk 0.5m)Bidang 60', 'Part 1 Heavy Premium Como Crepe (harga utk 0.5m)Bidang 60', 'Part 1 Heavy Premium Como Crepe (harga utk 0.5m)Bidang 60', 29.90, 'https://cf.shopee.com.my/file/86c3a23bf10c168dfe353c4707230e97', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (619, 'Artpac Nylon Brush Round S818 Size 3/0 - 12 / Berus Warna / Painting Brush Drawing', 'Artpac Nylon Brush Round S818 Size 3/0 - 12 / Berus Warna / Painting Brush Drawing', 'Artpac Nylon Brush Round S818 Size 3/0 - 12 / Berus Warna / Painting Brush Drawing', 68.50, 'https://cf.shopee.com.my/file/818fc8f6967fb257d7b6b114fb4fb170', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (622, 'Rocketek Bluetooth 4.0/5.0 Adapter USB Dongle For PC Computer Speaker Audio/Switch/PS4 Controller', 'Rocketek Bluetooth 4.0/5.0 Adapter USB Dongle For PC Computer Speaker Audio/Switch/PS4 Controller', 'Rocketek Bluetooth 4.0/5.0 Adapter USB Dongle For PC Computer Speaker Audio/Switch/PS4 Controller', 149.00, 'https://cf.shopee.com.my/file/e4127f8b1ceb70322921b243e9468e31', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (624, '0.25mm Gem Camera Lens Protective Film for IPhone 11 Pro Max 12 Pro Max Full Back Lens Protective Glass Screen Protector Camera Accessories', '0.25mm Gem Camera Lens Protective Film for IPhone 11 Pro Max 12 Pro Max Full Back Lens Protective Glass Screen Protector Camera Accessories', '0.25mm Gem Camera Lens Protective Film for IPhone 11 Pro Max 12 Pro Max Full Back Lens Protective Glass Screen Protector Camera Accessories', 19.00, 'https://cf.shopee.com.my/file/c06225b90d6dbeefb4424717a31a519b', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (625, '14.0\" - 15.6\" Universal Laptop Silicone Keyboard Skin Cover Protector for Laptop', '14.0\" - 15.6\" Universal Laptop Silicone Keyboard Skin Cover Protector for Laptop', '14.0\" - 15.6\" Universal Laptop Silicone Keyboard Skin Cover Protector for Laptop', 15.00, 'https://cf.shopee.com.my/file/a326df23fedd5b8dc3df73693dd16857', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (626, 'Edible Image Printing Icing Paper 1sheet Frosting Sugar Paper 0.65mm', 'Edible Image Printing Icing Paper 1sheet Frosting Sugar Paper 0.65mm', 'Edible Image Printing Icing Paper 1sheet Frosting Sugar Paper 0.65mm', 65.00, 'https://cf.shopee.com.my/file/994b402a2abef27463e896400ff479d0', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (627, 'Baju Bayi 0-1 Years Dress Baby Girl Summer New Baby Girl Clothing 3pcs Sunflower Headband Newborn Romper Gauze Skirt Suit', 'Baju Bayi 0-1 Years Dress Baby Girl Summer New Baby Girl Clothing 3pcs Sunflower Headband Newborn Romper Gauze Skirt Suit', 'Baju Bayi 0-1 Years Dress Baby Girl Summer New Baby Girl Clothing 3pcs Sunflower Headband Newborn Romper Gauze Skirt Suit', 179.90, 'https://cf.shopee.com.my/file/0f886c27f7e39061b19a039b59cc49dc', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (628, 'Faber-Castell RX GEL Gel Pen Colour 0.7mm', 'Faber-Castell RX GEL Gel Pen Colour 0.7mm', 'Faber-Castell RX GEL Gel Pen Colour 0.7mm', 15.00, 'https://cf.shopee.com.my/file/5f901b4014bdd1e81e048e45f74c5331', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (629, '0-3 Years Baby Girl Clothing Set / Baju siang budak perempuan/ Playset Baby Girl / Kids Blouse', '0-3 Years Baby Girl Clothing Set / Baju siang budak perempuan/ Playset Baby Girl / Kids Blouse', '0-3 Years Baby Girl Clothing Set / Baju siang budak perempuan/ Playset Baby Girl / Kids Blouse', 108.00, 'https://cf.shopee.com.my/file/353e5df541ce9fd8a48259e42a3813c3', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (631, '3M SUPER STRONG TAPE / water proof / heavy duty / outdoor / vehicle tape/ foam tape / double sided tape 0.1x1CM', '3M SUPER STRONG TAPE / water proof / heavy duty / outdoor / vehicle tape/ foam tape / double sided tape 0.1x1CM', '3M SUPER STRONG TAPE / water proof / heavy duty / outdoor / vehicle tape/ foam tape / double sided tape 0.1x1CM', 35.00, 'https://cf.shopee.com.my/file/2039712a6ac74b40a9ca07257ece19bf', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (632, 'Faster Colourful Ball Pen CX-1076 0.7mm', 'Faster Colourful Ball Pen CX-1076 0.7mm', 'Faster Colourful Ball Pen CX-1076 0.7mm', 5.90, 'https://cf.shopee.com.my/file/f087831d5129a6419970f1435971e672', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (633, 'MUJI Poly Sharp Pencil W/Rubber Grip 0.5mm', 'MUJI Poly Sharp Pencil W/Rubber Grip 0.5mm', 'MUJI Poly Sharp Pencil W/Rubber Grip 0.5mm', 49.00, 'https://cf.shopee.com.my/file/5468355790c19486773a1df6bc77f6b5', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (634, 'Faber-Castell RX Gel Pen 0.5mm/0.7mm - (1\'pc)', 'Faber-Castell RX Gel Pen 0.5mm/0.7mm - (1\'pc)', 'Faber-Castell RX Gel Pen 0.5mm/0.7mm - (1\'pc)', 13.50, 'https://cf.shopee.com.my/file/46106215e6b0c4fa169de0c7ef5b5b4b', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (635, 'Wilson Pro Comfort Overgrip Tennis Badminton Squash (Thin grip 0.6mm)', 'Wilson Pro Comfort Overgrip Tennis Badminton Squash (Thin grip 0.6mm)', 'Wilson Pro Comfort Overgrip Tennis Badminton Squash (Thin grip 0.6mm)', 52.00, 'https://cf.shopee.com.my/file/a45cdc7ca8f5dcec00b2d90c1d30d106', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (636, 'Simple Color Gel Pen 0.5mm Pen Tip Cute Pen for Hand Account Annotation, Drawing Graffiti School Supplies, Stationery', 'Simple Color Gel Pen 0.5mm Pen Tip Cute Pen for Hand Account Annotation, Drawing Graffiti School Supplies, Stationery', 'Simple Color Gel Pen 0.5mm Pen Tip Cute Pen for Hand Account Annotation, Drawing Graffiti School Supplies, Stationery', 10.00, 'https://cf.shopee.com.my/file/69c3094436476c4fcf09c938fe3e2b8c', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (637, '[FAST DELIVER] Guitar String Set (6 string)  // Acoustic Guitar String // Tali Gitar // 0.010-0.048 [ZIKO Guitar String]', '[FAST DELIVER] Guitar String Set (6 string)  // Acoustic Guitar String // Tali Gitar // 0.010-0.048 [ZIKO Guitar String]', '[FAST DELIVER] Guitar String Set (6 string)  // Acoustic Guitar String // Tali Gitar // 0.010-0.048 [ZIKO Guitar String]', 93.00, 'https://cf.shopee.com.my/file/999603319b03c40163cdef54eaf61dbe', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (638, 'Part 2 Heavy Premium Como Crepe Lessiron 0.5m Bidang 60 Untuk Baju Kurung Lembut Warna', 'Part 2 Heavy Premium Como Crepe Lessiron 0.5m Bidang 60 Untuk Baju Kurung Lembut Warna', 'Part 2 Heavy Premium Como Crepe Lessiron 0.5m Bidang 60 Untuk Baju Kurung Lembut Warna', 29.00, 'https://cf.shopee.com.my/file/0a777e0efe9f088f8de908acf8314f5b', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (639, 'Assorted general duty screwdriver mobile phone repairs 0.6Y T2 T3 T4 T5', 'Assorted general duty screwdriver mobile phone repairs 0.6Y T2 T3 T4 T5', 'Assorted general duty screwdriver mobile phone repairs 0.6Y T2 T3 T4 T5', 9.90, 'https://cf.shopee.com.my/file/c8546df09fc0a17e22825aed7c2f4369', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (641, 'OOREE UH402 4 PORTS HIGH SPEED USB2.0 USB HUB ON/OFF PORTABLE SWITCH, BLACK', 'OOREE UH402 4 PORTS HIGH SPEED USB2.0 USB HUB ON/OFF PORTABLE SWITCH, BLACK', 'OOREE UH402 4 PORTS HIGH SPEED USB2.0 USB HUB ON/OFF PORTABLE SWITCH, BLACK', 119.00, 'https://cf.shopee.com.my/file/64dc2fe116bc9fa127755b832ebc15ad', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (642, 'Original Uwell Caliburn G Occ Replacement Coil 0.8 Ohm 4pcs', 'Original Uwell Caliburn G Occ Replacement Coil 0.8 Ohm 4pcs', 'Original Uwell Caliburn G Occ Replacement Coil 0.8 Ohm 4pcs', 170.00, 'https://cf.shopee.com.my/file/9667ec3b59201a845ab62edb376cbf68', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (643, 'Roze 14.2mm(0.00-5.00) Contact Lens/Color Lens Original Korea Lens', 'Roze 14.2mm(0.00-5.00) Contact Lens/Color Lens Original Korea Lens', 'Roze 14.2mm(0.00-5.00) Contact Lens/Color Lens Original Korea Lens', 98.00, 'https://cf.shopee.com.my/file/d0c417a9f6e3fcac7e0227e869e3f171', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (644, 'PD1-PD19 Hot Kain Pasang Premium Diamond Sonata Satin 0.5m Bidang 58/60', 'PD1-PD19 Hot Kain Pasang Premium Diamond Sonata Satin 0.5m Bidang 58/60', 'PD1-PD19 Hot Kain Pasang Premium Diamond Sonata Satin 0.5m Bidang 58/60', 56.90, 'https://cf.shopee.com.my/file/de3f445425c84de49992b16746a6db37', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (646, 'Oxy Anti-Bacterial Acne Patch (0.03CM) 35\'s Clearance', 'Oxy Anti-Bacterial Acne Patch (0.03CM) 35\'s Clearance', 'Oxy Anti-Bacterial Acne Patch (0.03CM) 35\'s Clearance', 69.20, 'https://cf.shopee.com.my/file/d712f9e4db993c0eb298e729017006e3', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (648, 'Faber Castell Grip X5 0.5/ Grip X7 0.7/  Grip X10 1.0 Semi Gel Pen Faber-Castell', 'Faber Castell Grip X5 0.5/ Grip X7 0.7/  Grip X10 1.0 Semi Gel Pen Faber-Castell', 'Faber Castell Grip X5 0.5/ Grip X7 0.7/  Grip X10 1.0 Semi Gel Pen Faber-Castell', 9.50, 'https://cf.shopee.com.my/file/89e49c5d4cc16a95e9bfdfc24f43025f', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (649, 'Ayako 16.5mm(eff 17.5mm) Big eyes Contact Lens/Color Lens/Korea Lens (P-0.00 till P-8.00) Free Case', 'Ayako 16.5mm(eff 17.5mm) Big eyes Contact Lens/Color Lens/Korea Lens (P-0.00 till P-8.00) Free Case', 'Ayako 16.5mm(eff 17.5mm) Big eyes Contact Lens/Color Lens/Korea Lens (P-0.00 till P-8.00) Free Case', 99.00, 'https://cf.shopee.com.my/file/6ffdb2ca5def09376dbca40512af75e2', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (651, 'Bunting/Banner School kindergarden (0-6 Yrs old) - Suku Kata', 'Bunting/Banner School kindergarden (0-6 Yrs old) - Suku Kata', 'Bunting/Banner School kindergarden (0-6 Yrs old) - Suku Kata', 230.00, 'https://cf.shopee.com.my/file/2b834b6ffc87e6abd7cb9ff717b64cac', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (653, '( DAILY 1 Pc ) Bausch & Lomb Lacelle Diamond Daily brown (1 Pc) power 0.00 to -6.00', '( DAILY 1 Pc ) Bausch & Lomb Lacelle Diamond Daily brown (1 Pc) power 0.00 to -6.00', '( DAILY 1 Pc ) Bausch & Lomb Lacelle Diamond Daily brown (1 Pc) power 0.00 to -6.00', 25.00, 'https://cf.shopee.com.my/file/1a117b0c3e77e70696d2f127006073f3', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (654, 'Midea Conventional Rice Cooker 0.6L [MG-GP06B] |Ready Stocks | Fast Shipping', 'Midea Conventional Rice Cooker 0.6L [MG-GP06B] |Ready Stocks | Fast Shipping', 'Midea Conventional Rice Cooker 0.6L [MG-GP06B] |Ready Stocks | Fast Shipping', 449.00, 'https://cf.shopee.com.my/file/915f049e6cfd5c1a109b8818215d344a', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (657, '[1pc] Faber-Castell RX GEL Gel Pen 0.38mm / 0.5mm / 0.7mm', '[1pc] Faber-Castell RX GEL Gel Pen 0.38mm / 0.5mm / 0.7mm', '[1pc] Faber-Castell RX GEL Gel Pen 0.38mm / 0.5mm / 0.7mm', 13.50, 'https://cf.shopee.com.my/file/ba52aa9229b853311a241f97b7920a3b', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (658, 'Baby Romper Ready Stock 0-18M Premium Quality Long Sleeve Baby Clothing Infant Baju Cartoon Baby One Piece Baby Jumpsuit', 'Baby Romper Ready Stock 0-18M Premium Quality Long Sleeve Baby Clothing Infant Baju Cartoon Baby One Piece Baby Jumpsuit', 'Baby Romper Ready Stock 0-18M Premium Quality Long Sleeve Baby Clothing Infant Baju Cartoon Baby One Piece Baby Jumpsuit', 99.40, 'https://cf.shopee.com.my/file/ed9f6a12f9d489db4789002d0f732c01', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (659, 'M&G gel pen refill 0.5mm & 0.7mm ( 1pcs )', 'M&G gel pen refill 0.5mm & 0.7mm ( 1pcs )', 'M&G gel pen refill 0.5mm & 0.7mm ( 1pcs )', 5.40, 'https://cf.shopee.com.my/file/2dd915add37e85186565b210a9083b96', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (660, 'CAT6 Flat Patch Cord LAN Cable Gigabit Ethernet 10G RJ45 UTP 0.25m 0.5m 1M 2M 3M 5M 8M 1 2 3 5 8 meters 25cm 50cm', 'CAT6 Flat Patch Cord LAN Cable Gigabit Ethernet 10G RJ45 UTP 0.25m 0.5m 1M 2M 3M 5M 8M 1 2 3 5 8 meters 25cm 50cm', 'CAT6 Flat Patch Cord LAN Cable Gigabit Ethernet 10G RJ45 UTP 0.25m 0.5m 1M 2M 3M 5M 8M 1 2 3 5 8 meters 25cm 50cm', 47.00, 'https://cf.shopee.com.my/file/7283f6abeb81b61686c399f3778d065f', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (662, '(0.09sen/Page) Single Sided - Printing Service | A4 A5 Black & White | Print | Photocopy | Fotostat | Book Printing', '(0.09sen/Page) Single Sided - Printing Service | A4 A5 Black & White | Print | Photocopy | Fotostat | Book Printing', '(0.09sen/Page) Single Sided - Printing Service | A4 A5 Black & White | Print | Photocopy | Fotostat | Book Printing', 1.50, 'https://cf.shopee.com.my/file/014cef3fc9489d606c470aa6b0210983', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (664, 'READY STOCK 0.02mm to 1.00mm 17 Blades Thickness Gap Filler Feeler Gauge Ruler', 'READY STOCK 0.02mm to 1.00mm 17 Blades Thickness Gap Filler Feeler Gauge Ruler', 'READY STOCK 0.02mm to 1.00mm 17 Blades Thickness Gap Filler Feeler Gauge Ruler', 85.00, 'https://cf.shopee.com.my/file/5b691b9a0fb5236ff334c2a0ac349791', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (666, 'PREMIUM New Born Baby Hat 3 pcs Set Infant Beanie 0-6 Months', 'PREMIUM New Born Baby Hat 3 pcs Set Infant Beanie 0-6 Months', 'PREMIUM New Born Baby Hat 3 pcs Set Infant Beanie 0-6 Months', 165.00, 'https://cf.shopee.com.my/file/1578a754a82820f63da023c0d562cbea', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (670, 'Creative 0.5mm Cartoon Kawaii Japanese Totoro black core signature gel pen', 'Creative 0.5mm Cartoon Kawaii Japanese Totoro black core signature gel pen', 'Creative 0.5mm Cartoon Kawaii Japanese Totoro black core signature gel pen', 4.40, 'https://cf.shopee.com.my/file/3f1d1640da32680bf1661156c311f03b', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (671, 'M&G Retractable Gel Ink Ballpoint Pens R3-0.5mm/R5-0.7mm -Per pc', 'M&G Retractable Gel Ink Ballpoint Pens R3-0.5mm/R5-0.7mm -Per pc', 'M&G Retractable Gel Ink Ballpoint Pens R3-0.5mm/R5-0.7mm -Per pc', 13.00, 'https://cf.shopee.com.my/file/f1441c9194ed37e5c10fa90673af6672', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (672, 'One  ROLL 0.2/0.3/0.4/0.6/0.7/0.8mm  (NON ELASTIC TRANSPARENT FISHING LINE) For Diy Handmade', 'One  ROLL 0.2/0.3/0.4/0.6/0.7/0.8mm  (NON ELASTIC TRANSPARENT FISHING LINE) For Diy Handmade', 'One  ROLL 0.2/0.3/0.4/0.6/0.7/0.8mm  (NON ELASTIC TRANSPARENT FISHING LINE) For Diy Handmade', 5.00, 'https://cf.shopee.com.my/file/b71318ebcbe9db3c1b0ffe43aef4e6ac', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (674, 'Pentel BLN105 Energel-X Retractable Gel Roller Pen 0.5mm', 'Pentel BLN105 Energel-X Retractable Gel Roller Pen 0.5mm', 'Pentel BLN105 Energel-X Retractable Gel Roller Pen 0.5mm', 32.20, 'https://cf.shopee.com.my/file/8ee23f82b891b064c9977400363fa41d', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (675, '*CHEAPEST IN MALAYSIA* Desire 14.0mm Natural Size Contact Lens/Color Lens Original Korea Lens ( Power 0-1000 )', '*CHEAPEST IN MALAYSIA* Desire 14.0mm Natural Size Contact Lens/Color Lens Original Korea Lens ( Power 0-1000 )', '*CHEAPEST IN MALAYSIA* Desire 14.0mm Natural Size Contact Lens/Color Lens Original Korea Lens ( Power 0-1000 )', 99.00, 'https://cf.shopee.com.my/file/14d1f339a0179006c8eaeb17d3837737', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (676, 'LIVE ONLY Baju Bundle Baby 0-2Y', 'LIVE ONLY Baju Bundle Baby 0-2Y', 'LIVE ONLY Baju Bundle Baby 0-2Y', 10.00, 'https://cf.shopee.com.my/file/46b832af8a1c153e3c2449c3c412086a', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (677, 'Toshiba Canvio Basic 2.5\'\' Portable Harddisk USB3.0 (1TB/2TB)', 'Toshiba Canvio Basic 2.5\'\' Portable Harddisk USB3.0 (1TB/2TB)', 'Toshiba Canvio Basic 2.5\'\' Portable Harddisk USB3.0 (1TB/2TB)', 1709.90, 'https://cf.shopee.com.my/file/88f01b457345c8a1f28827f1d900cc73', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (678, 'Nylon Watercolour Brush Flat/Paint Brush Size 0/2/4/6/8/10/12/14/16/18', 'Nylon Watercolour Brush Flat/Paint Brush Size 0/2/4/6/8/10/12/14/16/18', 'Nylon Watercolour Brush Flat/Paint Brush Size 0/2/4/6/8/10/12/14/16/18', 3.30, 'https://cf.shopee.com.my/file/6a8bd711ad32720a7f9e410a7d0ef5a8', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (679, 'One Roll DIY Beaded Transparent Crystal Elastic Line White Transparent Crystal Elastic Line Handmade Diy Beaded Bracelet Accessories / GETAH (0.5, 0.6, 0.7, 0.8, 1mm)', 'One Roll DIY Beaded Transparent Crystal Elastic Line White Transparent Crystal Elastic Line Handmade Diy Beaded Bracelet Accessories / GETAH (0.5, 0.6, 0.7, 0.8, 1mm)', 'One Roll DIY Beaded Transparent Crystal Elastic Line White Transparent Crystal Elastic Line Handmade Diy Beaded Bracelet Accessories / GETAH (0.5, 0.6, 0.7, 0.8, 1mm)', 5.00, 'https://cf.shopee.com.my/file/bbad9bb1043536c267af3509d92fdea6', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (680, '0-8Y \"LC5\" Baby Kids Clothes Set Tshirt (1 baju+1 seluar) T-Shirt+Pant Boy Girl', '0-8Y \"LC5\" Baby Kids Clothes Set Tshirt (1 baju+1 seluar) T-Shirt+Pant Boy Girl', '0-8Y \"LC5\" Baby Kids Clothes Set Tshirt (1 baju+1 seluar) T-Shirt+Pant Boy Girl', 65.00, 'https://cf.shopee.com.my/file/28a4a97fb2ae8714ceb54b188fc1e454', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (681, 'Etude House 0.2mm Therapy Air Mask', 'Etude House 0.2mm Therapy Air Mask', 'Etude House 0.2mm Therapy Air Mask', 29.00, 'https://cf.shopee.com.my/file/6115641a89cfe75408ea4f0bfb61fb7b', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (682, 'Girl fashion suit Sut skirt musim panas untuk kanak-kanak perempuan berumur 0-4 tahun, corak arnab comel untuk bayi perempuan + skirt kotak-kotak lipit 2pcs', 'Girl fashion suit Sut skirt musim panas untuk kanak-kanak perempuan berumur 0-4 tahun, corak arnab comel untuk bayi perempuan + skirt kotak-kotak lipit 2pcs', 'Girl fashion suit Sut skirt musim panas untuk kanak-kanak perempuan berumur 0-4 tahun, corak arnab comel untuk bayi perempuan + skirt kotak-kotak lipit 2pcs', 138.00, 'https://cf.shopee.com.my/file/9f0c4c75c3bd143e3c0eb531475a35e7', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (683, 'Pigeon Unisex Newborn Baby Clothes Eyelet Short Sleeves Long Pants Baju Berlubang 0-18 Bulan Baju Baby Baru Lahir', 'Pigeon Unisex Newborn Baby Clothes Eyelet Short Sleeves Long Pants Baju Berlubang 0-18 Bulan Baju Baby Baru Lahir', 'Pigeon Unisex Newborn Baby Clothes Eyelet Short Sleeves Long Pants Baju Berlubang 0-18 Bulan Baju Baby Baru Lahir', 119.00, 'https://cf.shopee.com.my/file/0cd4cb66fe90b20fdb7da2ddb89f4017', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (684, 'YAMALUBE 10W-40 AT Scooter SEMI SYNTHETIC 4T Motor Oil 0.8L / 20W-40 AT Scooter 4T Motor Oil 0.8L (Old Packing 2019)', 'YAMALUBE 10W-40 AT Scooter SEMI SYNTHETIC 4T Motor Oil 0.8L / 20W-40 AT Scooter 4T Motor Oil 0.8L (Old Packing 2019)', 'YAMALUBE 10W-40 AT Scooter SEMI SYNTHETIC 4T Motor Oil 0.8L / 20W-40 AT Scooter 4T Motor Oil 0.8L (Old Packing 2019)', 125.00, 'https://cf.shopee.com.my/file/055d4c453a685cbb856052bdcbffeacd', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (686, '(0.00 to -5.00 )1 piece freshkon alluring daily color magnetic grey (loose pack)', '(0.00 to -5.00 )1 piece freshkon alluring daily color magnetic grey (loose pack)', '(0.00 to -5.00 )1 piece freshkon alluring daily color magnetic grey (loose pack)', 20.50, 'https://cf.shopee.com.my/file/6cbff49c58141006de8e731463be33b6', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (687, 'DENN Speaker Wire Pure Copper Cable 23/0.14 x 2 Core [5mx2] [10mx2] [20m] [30m] [50m] [70m]', 'DENN Speaker Wire Pure Copper Cable 23/0.14 x 2 Core [5mx2] [10mx2] [20m] [30m] [50m] [70m]', 'DENN Speaker Wire Pure Copper Cable 23/0.14 x 2 Core [5mx2] [10mx2] [20m] [30m] [50m] [70m]', 179.00, 'https://cf.shopee.com.my/file/5747e86f0fe3aa3a295394dfd9057569', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (688, 'M&G R1 & R3 0.5mm GEL INK PEN 1pcs', 'M&G R1 & R3 0.5mm GEL INK PEN 1pcs', 'M&G R1 & R3 0.5mm GEL INK PEN 1pcs', 9.60, 'https://cf.shopee.com.my/file/307d7b01c518ae79273622c6100a90d6', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (689, 'Part 2 Heavy Premium como crepe (harga utk 0.5m) Bidang 60', 'Part 2 Heavy Premium como crepe (harga utk 0.5m) Bidang 60', 'Part 2 Heavy Premium como crepe (harga utk 0.5m) Bidang 60', 29.90, 'https://cf.shopee.com.my/file/c1d8f0c52306af09ef857bb380e3a6c2', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (690, 'M&G R3/R5 Retractable Gel Pen 0.5 / 0.7mm Bullet Nib / Refill', 'M&G R3/R5 Retractable Gel Pen 0.5 / 0.7mm Bullet Nib / Refill', 'M&G R3/R5 Retractable Gel Pen 0.5 / 0.7mm Bullet Nib / Refill', 9.50, 'https://cf.shopee.com.my/file/af0ad530b95454cc383b600c9b785a3c', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (691, 'Contact Lens Sugar Candy / Sakura 16mm 0-550 POWER', 'Contact Lens Sugar Candy / Sakura 16mm 0-550 POWER', 'Contact Lens Sugar Candy / Sakura 16mm 0-550 POWER', 100.00, 'https://cf.shopee.com.my/file/6a02bc07a26baceb66237e36d88cf0c7', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (692, '16mm PRINCE BLACK / CHOCO [POWER 0 to 850]', '16mm PRINCE BLACK / CHOCO [POWER 0 to 850]', '16mm PRINCE BLACK / CHOCO [POWER 0 to 850]', 129.80, 'https://cf.shopee.com.my/file/61d1d2c91f686cdc4f2692aa6af0ec00', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (695, '(0.00 To -5.00 )1 Piece Freshkon Alluring Daily Color Magnetic Grey (Loose Pack)', '(0.00 To -5.00 )1 Piece Freshkon Alluring Daily Color Magnetic Grey (Loose Pack)', '(0.00 To -5.00 )1 Piece Freshkon Alluring Daily Color Magnetic Grey (Loose Pack)', 20.50, 'https://cf.shopee.com.my/file/0138bbb5267a969e2d3ee85577f8c763', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (696, '10.0/12.0/14.0/15.0 inch Universal Silicone  Keyboard Protector cover for Laptop', '10.0/12.0/14.0/15.0 inch Universal Silicone  Keyboard Protector cover for Laptop', '10.0/12.0/14.0/15.0 inch Universal Silicone  Keyboard Protector cover for Laptop', 19.00, 'https://cf.shopee.com.my/file/0dab8c2bc4db11e1d0d1c5e8f9273603', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (697, 'Yoko Style Hair Color Developing Powder 0/00 Blond Lighten Colour', 'Yoko Style Hair Color Developing Powder 0/00 Blond Lighten Colour', 'Yoko Style Hair Color Developing Powder 0/00 Blond Lighten Colour', 50.00, 'https://cf.shopee.com.my/file/4287dd678b073d7efc00f2b208a65eda', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (698, '3pcs/set Baby Mom\'s Care Adjustable Hat 100% Cotton Baby Cap 0-6months Topi Baby', '3pcs/set Baby Mom\'s Care Adjustable Hat 100% Cotton Baby Cap 0-6months Topi Baby', '3pcs/set Baby Mom\'s Care Adjustable Hat 100% Cotton Baby Cap 0-6months Topi Baby', 165.00, 'https://cf.shopee.com.my/file/f05ab0e88e1b51db215e27b1f5dee097', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (699, 'Public Gold LBMA Bullion Bar 0.5g (Au 999.9) - KLCC', 'Public Gold LBMA Bullion Bar 0.5g (Au 999.9) - KLCC', 'Public Gold LBMA Bullion Bar 0.5g (Au 999.9) - KLCC', 1800.00, 'https://cf.shopee.com.my/file/5b7cde2d3fdd57f5b608542e3c80c847', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (700, '(1PCS)UTS SUPER HEAVY DUTY PIKE JIGGING HOOK 1/0;2/0;3/0;4/0 FLAT TYPE', '(1PCS)UTS SUPER HEAVY DUTY PIKE JIGGING HOOK 1/0;2/0;3/0;4/0 FLAT TYPE', '(1PCS)UTS SUPER HEAVY DUTY PIKE JIGGING HOOK 1/0;2/0;3/0;4/0 FLAT TYPE', 6.00, 'https://cf.shopee.com.my/file/fbc66a957b6dd5a3e172417fe3859cec', 1627909658, 1, 1);
INSERT INTO `xy_goods_list` VALUES (701, '(1PCS)UTS SUPER HEAVY DUTY PIKE JIGGING HOOK 1/0;2/0;3/0;4/0 FLAT TYPE', '(1PCS)UTS SUPER HEAVY DUTY PIKE JIGGING HOOK 1/0;2/0;3/0;4/0 FLAT TYPE', '(1PCS)UTS SUPER HEAVY DUTY PIKE JIGGING HOOK 1/0;2/0;3/0;4/0 FLAT TYPE', 6.00, 'https://cf.shopee.com.my/file/fbc66a957b6dd5a3e172417fe3859cec', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (702, 'Pilot Color Eno Mechanical Pencils Lead - 0.7MM', 'Pilot Color Eno Mechanical Pencils Lead - 0.7MM', 'Pilot Color Eno Mechanical Pencils Lead - 0.7MM', 33.20, 'https://cf.shopee.com.my/file/ecf162a7491576d1719b0e6e172567d2', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (705, '100% AUTHENTIC NEVOKS FEELIN 0.6/1.0 Mesh Coil or Nevoks Feelin Empty 2.8ml Cartridge (Ready Stock)', '100% AUTHENTIC NEVOKS FEELIN 0.6/1.0 Mesh Coil or Nevoks Feelin Empty 2.8ml Cartridge (Ready Stock)', '100% AUTHENTIC NEVOKS FEELIN 0.6/1.0 Mesh Coil or Nevoks Feelin Empty 2.8ml Cartridge (Ready Stock)', 100.00, 'https://cf.shopee.com.my/file/5033c46fa9570315e4995ebab9acc989', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (707, 'Umobile Direct Topup 5.0%', 'Umobile Direct Topup 5.0%', 'Umobile Direct Topup 5.0%', 95.00, 'https://cf.shopee.com.my/file/63d2f6cdafe2fe0fe1a8f58c98870fb9', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (708, '0 - 18 Month BABY 100% COTTON CLOTHING | BABY SINGLET SUIT | BABY SLEEP WEAR | BABY SET 0~18 months', '0 - 18 Month BABY 100% COTTON CLOTHING | BABY SINGLET SUIT | BABY SLEEP WEAR | BABY SET 0~18 months', '0 - 18 Month BABY 100% COTTON CLOTHING | BABY SINGLET SUIT | BABY SLEEP WEAR | BABY SET 0~18 months', 139.90, 'https://cf.shopee.com.my/file/eb053bc12eb6b4d7eb5f222415ec1c64', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (709, 'Pilot G2 Gel Pen Refill 0.5mm, 0.7mm, 1.0 mm Black Blue Red (ORIGINAL) G-2', 'Pilot G2 Gel Pen Refill 0.5mm, 0.7mm, 1.0 mm Black Blue Red (ORIGINAL) G-2', 'Pilot G2 Gel Pen Refill 0.5mm, 0.7mm, 1.0 mm Black Blue Red (ORIGINAL) G-2', 25.50, 'https://cf.shopee.com.my/file/09d32ed75d9f5d24b8cb07145616426d', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (711, 'EURO GIRL 15MM 0-650 POWER CONTACT LENS', 'EURO GIRL 15MM 0-650 POWER CONTACT LENS', 'EURO GIRL 15MM 0-650 POWER CONTACT LENS', 100.00, 'https://cf.shopee.com.my/file/e156e5fb7f3b11f017fdd458ef436ce0', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (713, '0.5MM 1MM 50G 100G 63/37 Soldering Wire Lead Wire Rosin Core Flux', '0.5MM 1MM 50G 100G 63/37 Soldering Wire Lead Wire Rosin Core Flux', '0.5MM 1MM 50G 100G 63/37 Soldering Wire Lead Wire Rosin Core Flux', 85.50, 'https://cf.shopee.com.my/file/fa2862722ad6b6a58599c155ccba0042', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (714, 'BIG 15MM I.FAIRY ROZE  [ POWER 0-850 ] KOREAN COLOR CONTACT LENS', 'BIG 15MM I.FAIRY ROZE  [ POWER 0-850 ] KOREAN COLOR CONTACT LENS', 'BIG 15MM I.FAIRY ROZE  [ POWER 0-850 ] KOREAN COLOR CONTACT LENS', 119.80, 'https://cf.shopee.com.my/file/09f90e305314f366d29645f33340c0a9', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (715, 'KITKAT 1 piece>RM 0.88 !! Kitkat+Cadbury+1milo NUGGET_M&M choco/peanut > 1 piece ^^  , Rumah_Duduk DIAM-DIAM > Makan -)', 'KITKAT 1 piece>RM 0.88 !! Kitkat+Cadbury+1milo NUGGET_M&M choco/peanut > 1 piece ^^  , Rumah_Duduk DIAM-DIAM > Makan -)', 'KITKAT 1 piece>RM 0.88 !! Kitkat+Cadbury+1milo NUGGET_M&M choco/peanut > 1 piece ^^  , Rumah_Duduk DIAM-DIAM > Makan -)', 8.80, 'https://cf.shopee.com.my/file/16ccdf0cdcbc25088c65dc9b1aa305a8', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (716, 'Faster 0.5mm Ball Pen CX-445  (Price For 1pcs)', 'Faster 0.5mm Ball Pen CX-445  (Price For 1pcs)', 'Faster 0.5mm Ball Pen CX-445  (Price For 1pcs)', 6.20, 'https://cf.shopee.com.my/file/7212c88c41a4ae94dfb9557905f7b86f', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (717, '0.02mm to 1.00mm 17 Blades Thickness Gap Filler Feeler Gauge Ruler 2024.1', '0.02mm to 1.00mm 17 Blades Thickness Gap Filler Feeler Gauge Ruler 2024.1', '0.02mm to 1.00mm 17 Blades Thickness Gap Filler Feeler Gauge Ruler 2024.1', 88.00, 'https://cf.shopee.com.my/file/1bf9d0c968022f60fc1fcd6af191b625', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (718, '*SALES*Midea 0.6L Rice Cooker MG-GP06B Glass Lid', '*SALES*Midea 0.6L Rice Cooker MG-GP06B Glass Lid', '*SALES*Midea 0.6L Rice Cooker MG-GP06B Glass Lid', 469.00, 'https://cf.shopee.com.my/file/46ae7941cfa631c0c333362c04daca15', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (719, 'Faber Castell Click X Ball Pen X5 0.5mm / X7 0.7mm 1422 / Faber-Castell Click X7 - (1\'s)', 'Faber Castell Click X Ball Pen X5 0.5mm / X7 0.7mm 1422 / Faber-Castell Click X7 - (1\'s)', 'Faber Castell Click X Ball Pen X5 0.5mm / X7 0.7mm 1422 / Faber-Castell Click X7 - (1\'s)', 5.80, 'https://cf.shopee.com.my/file/05131df900b97b5a807c10dcd09215e3', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (721, 'Type-C 3.1a TO HDMI 4K HD 3 IN 1 USB3.0 HUB PD USB C CHARGING MULTIPORT ADAPTER', 'Type-C 3.1a TO HDMI 4K HD 3 IN 1 USB3.0 HUB PD USB C CHARGING MULTIPORT ADAPTER', 'Type-C 3.1a TO HDMI 4K HD 3 IN 1 USB3.0 HUB PD USB C CHARGING MULTIPORT ADAPTER', 350.00, 'https://cf.shopee.com.my/file/cb1faa45ac7f8e77c6341bfb36d2b8ab', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (722, '**Loose Cut-Feet** Air Cond Copper Pipe 1/4 , 3/8 , 1/2, 5/8 Inch X 0.61mm SIRIM Approved Copper Tube Air Cond Piping', '**Loose Cut-Feet** Air Cond Copper Pipe 1/4 , 3/8 , 1/2, 5/8 Inch X 0.61mm SIRIM Approved Copper Tube Air Cond Piping', '**Loose Cut-Feet** Air Cond Copper Pipe 1/4 , 3/8 , 1/2, 5/8 Inch X 0.61mm SIRIM Approved Copper Tube Air Cond Piping', 25.00, 'https://cf.shopee.com.my/file/03af0361e36c77ef121b92ffcddc3d9b', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (723, '0-5Y \"LC&TF 1\" Baby Kid Set Pajamas Shirt+Pants Boy Girl Sleepwear', '0-5Y \"LC&TF 1\" Baby Kid Set Pajamas Shirt+Pants Boy Girl Sleepwear', '0-5Y \"LC&TF 1\" Baby Kid Set Pajamas Shirt+Pants Boy Girl Sleepwear', 75.00, 'https://cf.shopee.com.my/file/1fff47cb5dc4f3e738958bdca641621b', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (724, '14 Blades Feeler Gauge Thickness Gap Feeler Valve Gauge 0.05-1.00mm 100B14', '14 Blades Feeler Gauge Thickness Gap Feeler Valve Gauge 0.05-1.00mm 100B14', '14 Blades Feeler Gauge Thickness Gap Feeler Valve Gauge 0.05-1.00mm 100B14', 60.50, 'https://cf.shopee.com.my/file/e6ff9455f428482ae2a20dbf5fd1cc76', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (726, 'Vritual Reality Shinecon 6.0 Headset VR Glasses Vr Glass Helmet 3D Box', 'Vritual Reality Shinecon 6.0 Headset VR Glasses Vr Glass Helmet 3D Box', 'Vritual Reality Shinecon 6.0 Headset VR Glasses Vr Glass Helmet 3D Box', 549.90, 'https://cf.shopee.com.my/file/9f82471160a817c75683c6aab0e196d9', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (727, 'Clinbon Newborn baby wear ~ infant suit,baju set bayi baru lahir 0-3months', 'Clinbon Newborn baby wear ~ infant suit,baju set bayi baru lahir 0-3months', 'Clinbon Newborn baby wear ~ infant suit,baju set bayi baru lahir 0-3months', 35.00, 'https://cf.shopee.com.my/file/264c368632bee68519f03abae4741dec', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (728, '[Original]MCDODO 20W Fast Charger 18W Fast Charger QC3.0 USB PD Dual Port For iPhone Huawei Samsung Xiaomi Travel Charge', '[Original]MCDODO 20W Fast Charger 18W Fast Charger QC3.0 USB PD Dual Port For iPhone Huawei Samsung Xiaomi Travel Charge', '[Original]MCDODO 20W Fast Charger 18W Fast Charger QC3.0 USB PD Dual Port For iPhone Huawei Samsung Xiaomi Travel Charge', 493.80, 'https://cf.shopee.com.my/file/ad587dfdde80a4fc216b66fdcb215bea', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (729, 'Stretch Film 250mm x 0.8KG  (Clear/Black)', 'Stretch Film 250mm x 0.8KG  (Clear/Black)', 'Stretch Film 250mm x 0.8KG  (Clear/Black)', 115.00, 'https://cf.shopee.com.my/file/6de202cfd76efcb264220207d9a58921', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (730, 'Pilot Rexgrip Ballpoint Pen - 0.5mm / 0.7mm / 1.0mm (BRG-10EF/F/M)', 'Pilot Rexgrip Ballpoint Pen - 0.5mm / 0.7mm / 1.0mm (BRG-10EF/F/M)', 'Pilot Rexgrip Ballpoint Pen - 0.5mm / 0.7mm / 1.0mm (BRG-10EF/F/M)', 29.90, 'https://cf.shopee.com.my/file/e0e42d65e081a9cbe0d14e90a50a3521', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (732, 'Ready Stock Cute Cartoon Baju Baby Boy Girl Shirts Baju Budak Lelaki  Baju Anak Lelaki Newborn Baby Girl Boy Cloths Baby T-shirts Kids Short Sleeves Boy Suit 2pcs 0-6 Year Old', 'Ready Stock Cute Cartoon Baju Baby Boy Girl Shirts Baju Budak Lelaki  Baju Anak Lelaki Newborn Baby Girl Boy Cloths Baby T-shirts Kids Short Sleeves Boy Suit 2pcs 0-6 Year Old', 'Ready Stock Cute Cartoon Baju Baby Boy Girl Shirts Baju Budak Lelaki  Baju Anak Lelaki Newborn Baby Girl Boy Cloths Baby T-shirts Kids Short Sleeves Boy Suit 2pcs 0-6 Year Old', 66.80, 'https://cf.shopee.com.my/file/0eecf143111f4d76676ccf826a6f790c', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (733, 'M&G Gel Pen R3/R5 0.5/0.7mm PRICE FOR 1PC', 'M&G Gel Pen R3/R5 0.5/0.7mm PRICE FOR 1PC', 'M&G Gel Pen R3/R5 0.5/0.7mm PRICE FOR 1PC', 9.90, 'https://cf.shopee.com.my/file/d60ca13d604ba2bf01a11e6c8d995c57', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (734, 'Buncho LEAD 0.5mm /0.7mm', 'Buncho LEAD 0.5mm /0.7mm', 'Buncho LEAD 0.5mm /0.7mm', 5.80, 'https://cf.shopee.com.my/file/95f4a10dbae3e0aae4e196ef69727e54', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (735, '100% Original Artery Pal II Replacement 5pcs Hp Core Occ 0.6Ohm Mesh/ Occ 1.0Ohm Regular Coil Vape', '100% Original Artery Pal II Replacement 5pcs Hp Core Occ 0.6Ohm Mesh/ Occ 1.0Ohm Regular Coil Vape', '100% Original Artery Pal II Replacement 5pcs Hp Core Occ 0.6Ohm Mesh/ Occ 1.0Ohm Regular Coil Vape', 230.00, 'https://cf.shopee.com.my/file/642941857bf15eaea4c7c816fb7626cc', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (738, 'Bausch & Lomb Soflens 59 Monthly Contact Lenses - Power -0.50 to -9.00 (6 Pcs)', 'Bausch & Lomb Soflens 59 Monthly Contact Lenses - Power -0.50 to -9.00 (6 Pcs)', 'Bausch & Lomb Soflens 59 Monthly Contact Lenses - Power -0.50 to -9.00 (6 Pcs)', 367.00, 'https://cf.shopee.com.my/file/309f8724de03e473393a151fe3fbdbbc', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (739, 'PFT7-0-24 Months Baby Splicing O-Neck Sleeveless Ribbed Jumpsuits with Crotch Buttons for Toddlers, Boys, 5 Colors', 'PFT7-0-24 Months Baby Splicing O-Neck Sleeveless Ribbed Jumpsuits with Crotch Buttons for Toddlers, Boys, 5 Colors', 'PFT7-0-24 Months Baby Splicing O-Neck Sleeveless Ribbed Jumpsuits with Crotch Buttons for Toddlers, Boys, 5 Colors', 200.60, 'https://cf.shopee.com.my/file/e5ab09e6af455a1a226c5cf85e8e79b5', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (741, '( 0.1, 0.15, 0.22, 0.33, 0.39, 0.47, 0.68, 0.82, 1.0, 1.5, 2.0, 2.2, 2.5, 3.0, 3.5)uF 310v AC Fan Capacitor', '( 0.1, 0.15, 0.22, 0.33, 0.39, 0.47, 0.68, 0.82, 1.0, 1.5, 2.0, 2.2, 2.5, 3.0, 3.5)uF 310v AC Fan Capacitor', '( 0.1, 0.15, 0.22, 0.33, 0.39, 0.47, 0.68, 0.82, 1.0, 1.5, 2.0, 2.2, 2.5, 3.0, 3.5)uF 310v AC Fan Capacitor', 15.00, 'https://cf.shopee.com.my/file/8cdc60ce839dbbf5d207d8433afc9cae', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (742, '50pcs/100pcs 453 U-shaped terminal tab cold inserts connectors cold terminal small teeth fascia terminal,0.3-1.5mm2', '50pcs/100pcs 453 U-shaped terminal tab cold inserts connectors cold terminal small teeth fascia terminal,0.3-1.5mm2', '50pcs/100pcs 453 U-shaped terminal tab cold inserts connectors cold terminal small teeth fascia terminal,0.3-1.5mm2', 25.00, 'https://cf.shopee.com.my/file/3d866ad3769b54ab44c8b0024977d30b', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (743, 'Kurta Cotton Exclusive 24.0', 'Kurta Cotton Exclusive 24.0', 'Kurta Cotton Exclusive 24.0', 390.00, 'https://cf.shopee.com.my/file/3525f71de1db8a384ebeb2333e9271cc', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (744, 'Pilot G2 Gel Ink Pen 0.38mm/0.5mm/0.7mm/1.0mm', 'Pilot G2 Gel Ink Pen 0.38mm/0.5mm/0.7mm/1.0mm', 'Pilot G2 Gel Ink Pen 0.38mm/0.5mm/0.7mm/1.0mm', 35.20, 'https://cf.shopee.com.my/file/030e33c79ce5dd6f4776dbf7952633a2', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (745, 'Original NEVOKS FEELIN nevoks pagee Mesh Coil SPL 10 0.6ohm 1.0 ohm occ', 'Original NEVOKS FEELIN nevoks pagee Mesh Coil SPL 10 0.6ohm 1.0 ohm occ', 'Original NEVOKS FEELIN nevoks pagee Mesh Coil SPL 10 0.6ohm 1.0 ohm occ', 130.00, 'https://cf.shopee.com.my/file/8241f77b45abe899714b2f0a66fb5822', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (746, 'Ready Stock 1 Pairs 5D Design Cute Newborn Baby Sock Breathable Boy Girl 0-12 month baby socks', 'Ready Stock 1 Pairs 5D Design Cute Newborn Baby Sock Breathable Boy Girl 0-12 month baby socks', 'Ready Stock 1 Pairs 5D Design Cute Newborn Baby Sock Breathable Boy Girl 0-12 month baby socks', 39.80, 'https://cf.shopee.com.my/file/fa95f9ed657ccd28818a738ef22295cb', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (747, 'Ready Stock baby dress girl fashion Summer skirt Korean style mesh princess dress 0-4Y', 'Ready Stock baby dress girl fashion Summer skirt Korean style mesh princess dress 0-4Y', 'Ready Stock baby dress girl fashion Summer skirt Korean style mesh princess dress 0-4Y', 55.00, 'https://cf.shopee.com.my/file/77210340c06e4b14060d3cf84bfb82f1', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (748, 'GSOFT WX1 0.4MM SEMI GEL BALL PEN - 25PCS /DRUM', 'GSOFT WX1 0.4MM SEMI GEL BALL PEN - 25PCS /DRUM', 'GSOFT WX1 0.4MM SEMI GEL BALL PEN - 25PCS /DRUM', 178.00, 'https://cf.shopee.com.my/file/1f0693b7b29c0e48ee099a5057f8dfca', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (749, 'Air Optix Plus Hydraglyde Alcon Monthly - Power -0.50 to -12.00 (3 Pcs)', 'Air Optix Plus Hydraglyde Alcon Monthly - Power -0.50 to -12.00 (3 Pcs)', 'Air Optix Plus Hydraglyde Alcon Monthly - Power -0.50 to -12.00 (3 Pcs)', 410.00, 'https://cf.shopee.com.my/file/3209f4573334234ca672d9e77d08c121', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (750, 'Faber Castell K-One Kone Gel Pen Ball Pen 0.5mm', 'Faber Castell K-One Kone Gel Pen Ball Pen 0.5mm', 'Faber Castell K-One Kone Gel Pen Ball Pen 0.5mm', 10.50, 'https://cf.shopee.com.my/file/671d423b5b963085e287647b327e7165', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (751, 'RM24.57* Dutch Baby 0 - 12 Months 850g x 1', 'RM24.57* Dutch Baby 0 - 12 Months 850g x 1', 'RM24.57* Dutch Baby 0 - 12 Months 850g x 1', 273.00, 'https://cf.shopee.com.my/file/e4a9892851f26d2965726bd1b4257439', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (753, '(0.00 To 500) 1 Piece Freshkon Fusion Daily Color Brilliant Brown (Loose Pack)', '(0.00 To 500) 1 Piece Freshkon Fusion Daily Color Brilliant Brown (Loose Pack)', '(0.00 To 500) 1 Piece Freshkon Fusion Daily Color Brilliant Brown (Loose Pack)', 20.50, 'https://cf.shopee.com.my/file/ba9e1aaa1f5d63d96e2a023f5723bc40', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (755, 'Tikar Getah 20m x 1.83m (6 kaki) Tebal 0.4mm PVC Vinyl Carpet Flooring Rug Mat Canopy Karpet Velvet Toto Khemah Kanopi', 'Tikar Getah 20m x 1.83m (6 kaki) Tebal 0.4mm PVC Vinyl Carpet Flooring Rug Mat Canopy Karpet Velvet Toto Khemah Kanopi', 'Tikar Getah 20m x 1.83m (6 kaki) Tebal 0.4mm PVC Vinyl Carpet Flooring Rug Mat Canopy Karpet Velvet Toto Khemah Kanopi', 1154.00, 'https://cf.shopee.com.my/file/9d599cdcc6e5581e2c65af5284fe790d', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (756, 'Winzige 0.5mm Colorful Gel Pen Painting Writing Supplies School Office Stationery', 'Winzige 0.5mm Colorful Gel Pen Painting Writing Supplies School Office Stationery', 'Winzige 0.5mm Colorful Gel Pen Painting Writing Supplies School Office Stationery', 11.50, 'https://cf.shopee.com.my/file/233080398eb21e32c9f1cb5d540a6485', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (757, '0.5MM Thickness A3 / A4 / A5 Size Magnet Sheet /Fridge Magnet)', '0.5MM Thickness A3 / A4 / A5 Size Magnet Sheet /Fridge Magnet)', '0.5MM Thickness A3 / A4 / A5 Size Magnet Sheet /Fridge Magnet)', 15.00, 'https://cf.shopee.com.my/file/56886057c7df832e4e948d7fcfb76060', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (758, 'Gel Pen 0.5mm Black Red Blue Neutral Pen Office Transparent Pen Doorgift Hadiah', 'Gel Pen 0.5mm Black Red Blue Neutral Pen Office Transparent Pen Doorgift Hadiah', 'Gel Pen 0.5mm Black Red Blue Neutral Pen Office Transparent Pen Doorgift Hadiah', 3.50, 'https://cf.shopee.com.my/file/c22e305a4aaded23acb265c13d87d2fa', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (759, 'Vicks Inhaler with Keychain (0.5m)', 'Vicks Inhaler with Keychain (0.5m)', 'Vicks Inhaler with Keychain (0.5m)', 67.70, 'https://cf.shopee.com.my/file/fac0095509c74eb48a92d65a28be0048', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (760, '(2nd Batch Pre-order) Bandai Digimon Digital Monster Vital Bracelet & DIM Card (Vol.0.5 / Vol.3 / Vol.1 / Vol.2)', '(2nd Batch Pre-order) Bandai Digimon Digital Monster Vital Bracelet & DIM Card (Vol.0.5 / Vol.3 / Vol.1 / Vol.2)', '(2nd Batch Pre-order) Bandai Digimon Digital Monster Vital Bracelet & DIM Card (Vol.0.5 / Vol.3 / Vol.1 / Vol.2)', 150.00, 'https://cf.shopee.com.my/file/f36ca785ae5a39efbbd69834592d3325', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (761, 'I.FAIRY TERESA ( POWER 0-850 ) KOREAN COLOR CONTACT LENS', 'I.FAIRY TERESA ( POWER 0-850 ) KOREAN COLOR CONTACT LENS', 'I.FAIRY TERESA ( POWER 0-850 ) KOREAN COLOR CONTACT LENS', 109.80, 'https://cf.shopee.com.my/file/d500f6624f91002d0b7ed6168b27e555', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (762, 'Freshkon 58 Monthly Clear Contact Lenses - Power -0.50 to -10.00 (6 Pcs)', 'Freshkon 58 Monthly Clear Contact Lenses - Power -0.50 to -10.00 (6 Pcs)', 'Freshkon 58 Monthly Clear Contact Lenses - Power -0.50 to -10.00 (6 Pcs)', 283.10, 'https://cf.shopee.com.my/file/7df4bb125902b77bd00a33a25e6f138e', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (763, '18W QC3.0 Fast Wall Charger Mobile Phone USB Adapter Quick Charging Qualcomm Qucik Charge 3.0 Mini Travel Charger', '18W QC3.0 Fast Wall Charger Mobile Phone USB Adapter Quick Charging Qualcomm Qucik Charge 3.0 Mini Travel Charger', '18W QC3.0 Fast Wall Charger Mobile Phone USB Adapter Quick Charging Qualcomm Qucik Charge 3.0 Mini Travel Charger', 95.00, 'https://cf.shopee.com.my/file/156e3a979382dac78f8582e42b402ff4', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (765, '500g x 0.01g Mini Digital Jewellery Pocket Scale / Penimbang digital / Penimbang Emas / Penimbang Batu Permata / Timbang', '500g x 0.01g Mini Digital Jewellery Pocket Scale / Penimbang digital / Penimbang Emas / Penimbang Batu Permata / Timbang', '500g x 0.01g Mini Digital Jewellery Pocket Scale / Penimbang digital / Penimbang Emas / Penimbang Batu Permata / Timbang', 163.80, 'https://cf.shopee.com.my/file/00277c216f6b2f0a7ce8d48dd68ff53a', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (767, 'KM 0.5mm Cute Black Ink Cartoon Ballpoint Gel Pen Stationery Silicone Head Ballpen [1783]', 'KM 0.5mm Cute Black Ink Cartoon Ballpoint Gel Pen Stationery Silicone Head Ballpen [1783]', 'KM 0.5mm Cute Black Ink Cartoon Ballpoint Gel Pen Stationery Silicone Head Ballpen [1783]', 4.80, 'https://cf.shopee.com.my/file/348e90ce679777c807f37bd968aa663d', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (768, '[0.05sen/page] MURAHH FAST PRINTING Online Service Quality  A4lA5 Black&White Double Sided Paper|Print|Book Printing', '[0.05sen/page] MURAHH FAST PRINTING Online Service Quality  A4lA5 Black&White Double Sided Paper|Print|Book Printing', '[0.05sen/page] MURAHH FAST PRINTING Online Service Quality  A4lA5 Black&White Double Sided Paper|Print|Book Printing', 1.00, 'https://cf.shopee.com.my/file/3ea8a9662b666af63c311637171d8c9a', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (770, 'Craft Wire, Copper-Based Wire, 0.2mm-1.0mm', 'Craft Wire, Copper-Based Wire, 0.2mm-1.0mm', 'Craft Wire, Copper-Based Wire, 0.2mm-1.0mm', 37.60, 'https://cf.shopee.com.my/file/2f56ea5f32fd441eaa49583858a3047e', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (771, '0.5\", 0.75\", 1\", 1.25\", 1.5\" & 2\" Black Soft Elastic / Getah Lembut  (3Meter/Lot)', '0.5\", 0.75\", 1\", 1.25\", 1.5\" & 2\" Black Soft Elastic / Getah Lembut  (3Meter/Lot)', '0.5\", 0.75\", 1\", 1.25\", 1.5\" & 2\" Black Soft Elastic / Getah Lembut  (3Meter/Lot)', 25.00, 'https://cf.shopee.com.my/file/69e4354e68c09e6bd4ed09e9813c81a6', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (772, 'RM47.25* Dumex Dupro 1 (0 - 12) 850G x 2', 'RM47.25* Dumex Dupro 1 (0 - 12) 850G x 2', 'RM47.25* Dumex Dupro 1 (0 - 12) 850G x 2', 528.00, 'https://cf.shopee.com.my/file/1035069d27dc862290680ce0ac05ab9b', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (773, '0 - 18 Month | Baby Clothing | Baju Baby Set | Baby Cotton Suit | Baby Sleepwear | Baju Tidur Bayi', '0 - 18 Month | Baby Clothing | Baju Baby Set | Baby Cotton Suit | Baby Sleepwear | Baju Tidur Bayi', '0 - 18 Month | Baby Clothing | Baju Baby Set | Baby Cotton Suit | Baby Sleepwear | Baju Tidur Bayi', 114.90, 'https://cf.shopee.com.my/file/5506944834137a60733da9f24a537683', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (774, '2.5in USB3.0 SATA Box 3TB HDD Hard Drive SSD External Enclosure Case for PC', '2.5in USB3.0 SATA Box 3TB HDD Hard Drive SSD External Enclosure Case for PC', '2.5in USB3.0 SATA Box 3TB HDD Hard Drive SSD External Enclosure Case for PC', 155.70, 'https://cf.shopee.com.my/file/f5a40f4b74dd35133756cd0382a418f3', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (777, '0.3M HDMI Male to 2 x Y Splitter HDMI Female Cable High Speed 1M/2F', '0.3M HDMI Male to 2 x Y Splitter HDMI Female Cable High Speed 1M/2F', '0.3M HDMI Male to 2 x Y Splitter HDMI Female Cable High Speed 1M/2F', 48.50, 'https://cf.shopee.com.my/file/87dd264c8ca044859fdcbb3d81b12043', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (778, 'Stretch Film 500mm x 2.2kg x Core 0.2kg x 23micron Clear / Black with Invoice BLUECON', 'Stretch Film 500mm x 2.2kg x Core 0.2kg x 23micron Clear / Black with Invoice BLUECON', 'Stretch Film 500mm x 2.2kg x Core 0.2kg x 23micron Clear / Black with Invoice BLUECON', 174.00, 'https://cf.shopee.com.my/file/9a64a8ba345c5685a920fed42552ec24', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (779, 'Faber Castell Faber-Castell School & Office Capped True Gel Pen Black Blue Red 0.5mm 0.7mm', 'Faber Castell Faber-Castell School & Office Capped True Gel Pen Black Blue Red 0.5mm 0.7mm', 'Faber Castell Faber-Castell School & Office Capped True Gel Pen Black Blue Red 0.5mm 0.7mm', 15.00, 'https://cf.shopee.com.my/file/592ce65d4e9d0b75242037ef7e6b0b80', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (780, 'Pilot BP-1RT Pen Medium / Fine ( 1.0mm / 0.7mm )', 'Pilot BP-1RT Pen Medium / Fine ( 1.0mm / 0.7mm )', 'Pilot BP-1RT Pen Medium / Fine ( 1.0mm / 0.7mm )', 8.90, 'https://cf.shopee.com.my/file/0b66cb450a7ff66cc45251c75b41bc86', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (781, 'Resistor 220 ohm (Carbon - 0.25W)', 'Resistor 220 ohm (Carbon - 0.25W)', 'Resistor 220 ohm (Carbon - 0.25W)', 1.00, 'https://cf.shopee.com.my/file/74acb04324c6e76958c67505344feefa', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (784, '0-4 year old boy clothes summer baby boy fashion cotton printed flower shirt T-shirt + shorts 2 piece set', '0-4 year old boy clothes summer baby boy fashion cotton printed flower shirt T-shirt + shorts 2 piece set', '0-4 year old boy clothes summer baby boy fashion cotton printed flower shirt T-shirt + shorts 2 piece set', 136.90, 'https://cf.shopee.com.my/file/fff3b063451649ed2fcfbea908cec540', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (785, 'WD Western Digital My Passport 1TB / 2TB USB3.0 Portable External Hard Disk Drive HDD (Red / Blue / Black/ White)', 'WD Western Digital My Passport 1TB / 2TB USB3.0 Portable External Hard Disk Drive HDD (Red / Blue / Black/ White)', 'WD Western Digital My Passport 1TB / 2TB USB3.0 Portable External Hard Disk Drive HDD (Red / Blue / Black/ White)', 1785.00, 'https://cf.shopee.com.my/file/f149186ad0d853456df4cb2870d9ef14', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (786, '5 pcs baby clothes romper baju baby newborn jumpsuit onesies pajama rompers summer cotton short sleeve umpsuit lightweight  new born boys girls gift set 0-12m', '5 pcs baby clothes romper baju baby newborn jumpsuit onesies pajama rompers summer cotton short sleeve umpsuit lightweight  new born boys girls gift set 0-12m', '5 pcs baby clothes romper baju baby newborn jumpsuit onesies pajama rompers summer cotton short sleeve umpsuit lightweight  new born boys girls gift set 0-12m', 388.70, 'https://cf.shopee.com.my/file/fe1258a7c10daf390d9c4a3c83c15265', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (787, 'Tommee Tippee CTN Air Style Soother 0-6m / 6-18m / 18-36m Single Twin Pack', 'Tommee Tippee CTN Air Style Soother 0-6m / 6-18m / 18-36m Single Twin Pack', 'Tommee Tippee CTN Air Style Soother 0-6m / 6-18m / 18-36m Single Twin Pack', 119.00, 'https://cf.shopee.com.my/file/ae12844c0d26035aad0ee6ed07a85cc2', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (788, '1Roll/50M 0.7mm Elastic Thread Round Crystal Line Nylon Rubber Stretchy Cord For Jewelry Making Beading Bracelet  14colors', '1Roll/50M 0.7mm Elastic Thread Round Crystal Line Nylon Rubber Stretchy Cord For Jewelry Making Beading Bracelet  14colors', '1Roll/50M 0.7mm Elastic Thread Round Crystal Line Nylon Rubber Stretchy Cord For Jewelry Making Beading Bracelet  14colors', 21.60, 'https://cf.shopee.com.my/file/425172051ab1f423aa226d0e7ea8e512', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (789, 'CC1-CC22 Premium Heavy Como Crepe Bidang 58 Kain Pasang Harga Utk 0.5m', 'CC1-CC22 Premium Heavy Como Crepe Bidang 58 Kain Pasang Harga Utk 0.5m', 'CC1-CC22 Premium Heavy Como Crepe Bidang 58 Kain Pasang Harga Utk 0.5m', 28.80, 'https://cf.shopee.com.my/file/8b0b2984bd2df3b0fa11e251f3cfc5bd', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (790, 'Xiaomi Mi TV Stick 2K Android 9.0 ROM Media Streaming AndroidTV Mi Box Player Global Version (1GB + 8GB)', 'Xiaomi Mi TV Stick 2K Android 9.0 ROM Media Streaming AndroidTV Mi Box Player Global Version (1GB + 8GB)', 'Xiaomi Mi TV Stick 2K Android 9.0 ROM Media Streaming AndroidTV Mi Box Player Global Version (1GB + 8GB)', 1490.00, 'https://cf.shopee.com.my/file/05f06ad059d9e98af8f9cc23ae29836b', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (791, 'BK Kerongsang Batu Korea Premium Rhinestone 0.8CM - Baby Brooch Ready Stock (K87)', 'BK Kerongsang Batu Korea Premium Rhinestone 0.8CM - Baby Brooch Ready Stock (K87)', 'BK Kerongsang Batu Korea Premium Rhinestone 0.8CM - Baby Brooch Ready Stock (K87)', 2.00, 'https://cf.shopee.com.my/file/08efab3d75343fff01161c48da3c4642', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (792, 'NIKKI Korean style Color Gel Pen 0.5mm 12 colors-1 pcs', 'NIKKI Korean style Color Gel Pen 0.5mm 12 colors-1 pcs', 'NIKKI Korean style Color Gel Pen 0.5mm 12 colors-1 pcs', 13.20, 'https://cf.shopee.com.my/file/5d267ea45617c3a0c1f129b9c57bd608', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (793, 'Contact Lens Mavis / Indy 16MM 0-800 POWER', 'Contact Lens Mavis / Indy 16MM 0-800 POWER', 'Contact Lens Mavis / Indy 16MM 0-800 POWER', 100.00, 'https://cf.shopee.com.my/file/00896867bec2210c056e355e36233bc1', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (794, '0-9M Set Baju Baby Girl Shirt Singlet Pants Kids Clothing Romper Cotton Baju Jalan Bayi Murah Comel', '0-9M Set Baju Baby Girl Shirt Singlet Pants Kids Clothing Romper Cotton Baju Jalan Bayi Murah Comel', '0-9M Set Baju Baby Girl Shirt Singlet Pants Kids Clothing Romper Cotton Baju Jalan Bayi Murah Comel', 97.00, 'https://cf.shopee.com.my/file/ee81b30dc1e09f72b651a07db1f926c3', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (795, 'Micol Emilly Princess Dress Kids 100% Cotton Gauze Birthday Party Dress Baby Girls Colorful Rainbow Kids Dress Girls Gift 0-6 years Old', 'Micol Emilly Princess Dress Kids 100% Cotton Gauze Birthday Party Dress Baby Girls Colorful Rainbow Kids Dress Girls Gift 0-6 years Old', 'Micol Emilly Princess Dress Kids 100% Cotton Gauze Birthday Party Dress Baby Girls Colorful Rainbow Kids Dress Girls Gift 0-6 years Old', 224.90, 'https://cf.shopee.com.my/file/8dd0a31c104ab910a994441340755e54', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (796, '#CALIBURN G OCC & CARTRIDGE# ORIGINAL UWELL CALIBURN G OCC CALIBURN G 0.8 MESH OCC UWELL CALIBURN G CARTRIDGE 2ML', '#CALIBURN G OCC & CARTRIDGE# ORIGINAL UWELL CALIBURN G OCC CALIBURN G 0.8 MESH OCC UWELL CALIBURN G CARTRIDGE 2ML', '#CALIBURN G OCC & CARTRIDGE# ORIGINAL UWELL CALIBURN G OCC CALIBURN G 0.8 MESH OCC UWELL CALIBURN G CARTRIDGE 2ML', 89.90, 'https://cf.shopee.com.my/file/6fa27c0236b8d948a10c56acff67b03e', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (797, 'M&g gel pen 0.5mm/0.7mm 1pcs', 'M&g gel pen 0.5mm/0.7mm 1pcs', 'M&g gel pen 0.5mm/0.7mm 1pcs', 6.00, 'https://cf.shopee.com.my/file/9097d8d97767b5ebdb91fa31e52cb9ee', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (798, 'Art hook line pens Makers Fast dry Waterproof 0.05 mm to 0.8mm Porous-Point Pens Brush Journal writing Professional sketching', 'Art hook line pens Makers Fast dry Waterproof 0.05 mm to 0.8mm Porous-Point Pens Brush Journal writing Professional sketching', 'Art hook line pens Makers Fast dry Waterproof 0.05 mm to 0.8mm Porous-Point Pens Brush Journal writing Professional sketching', 15.90, 'https://cf.shopee.com.my/file/1195adda1a7cd075657672b6eb82ff58', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (799, 'Tommee Tippee Orthodontic NEWBORN MOON /CLOUD / STAR / NARWHAL / SEAHORSE Soother / Pacifier 0-2m With CAP (Puting Susu)', 'Tommee Tippee Orthodontic NEWBORN MOON /CLOUD / STAR / NARWHAL / SEAHORSE Soother / Pacifier 0-2m With CAP (Puting Susu)', 'Tommee Tippee Orthodontic NEWBORN MOON /CLOUD / STAR / NARWHAL / SEAHORSE Soother / Pacifier 0-2m With CAP (Puting Susu)', 125.00, 'https://cf.shopee.com.my/file/1fafe725cd17f9063c03ecf53f6f2f54', 1627909661, 1, 1);
INSERT INTO `xy_goods_list` VALUES (801, 'Bausch & Lomb Soflens Daily Disposable Power -0.50 to -9.00 (30 Pcs)', 'Bausch & Lomb Soflens Daily Disposable Power -0.50 to -9.00 (30 Pcs)', 'Bausch & Lomb Soflens Daily Disposable Power -0.50 to -9.00 (30 Pcs)', 62.00, 'https://cf.shopee.com.my/file/213b2eb0ce2e813517541ba28de62205', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (802, '[READYSTOCK] The Ordinary Retinol 0.2%, 0.5 % and 1 % in Squalane 30ml', '[READYSTOCK] The Ordinary Retinol 0.2%, 0.5 % and 1 % in Squalane 30ml', '[READYSTOCK] The Ordinary Retinol 0.2%, 0.5 % and 1 % in Squalane 30ml', 410.00, 'https://cf.shopee.com.my/file/5aa49a166a5dfad180898bb09f0841d0', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (803, 'Faber Castell Grip X Ball Pen X5 (0.5mm) X7 (0.7mm) X10 (1.0mm) / Faber-Castell Grip x Faber Grip X Click Pen (1pc)', 'Faber Castell Grip X Ball Pen X5 (0.5mm) X7 (0.7mm) X10 (1.0mm) / Faber-Castell Grip x Faber Grip X Click Pen (1pc)', 'Faber Castell Grip X Ball Pen X5 (0.5mm) X7 (0.7mm) X10 (1.0mm) / Faber-Castell Grip x Faber Grip X Click Pen (1pc)', 12.40, 'https://cf.shopee.com.my/file/bb6373ebfc9383868ff4c9228bb0e5c0', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (805, 'Yoga Resistance Rubber Bands Indoor Latex Fitness Equipment 0.35mm-1.1mm Pilates Sport Training Workout Elastic Bands', 'Yoga Resistance Rubber Bands Indoor Latex Fitness Equipment 0.35mm-1.1mm Pilates Sport Training Workout Elastic Bands', 'Yoga Resistance Rubber Bands Indoor Latex Fitness Equipment 0.35mm-1.1mm Pilates Sport Training Workout Elastic Bands', 18.90, 'https://cf.shopee.com.my/file/685c0b25466f16ad96d55ace2a6055aa', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (807, 'Original Uwell Caliburn G / Koko Prime Replacement Coil Occ 0.8 Ohm / 1.0 Ohm 4 Pcs / Pack', 'Original Uwell Caliburn G / Koko Prime Replacement Coil Occ 0.8 Ohm / 1.0 Ohm 4 Pcs / Pack', 'Original Uwell Caliburn G / Koko Prime Replacement Coil Occ 0.8 Ohm / 1.0 Ohm 4 Pcs / Pack', 285.00, 'https://cf.shopee.com.my/file/f3c4d13223717a3afba109dd072e602d', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (808, 'SANDISK BLADE CZ50 PENDRIVE 8GB/16GB/32GB  USB2.0 /(COMPATIBLE WITH USB 3.0)', 'SANDISK BLADE CZ50 PENDRIVE 8GB/16GB/32GB  USB2.0 /(COMPATIBLE WITH USB 3.0)', 'SANDISK BLADE CZ50 PENDRIVE 8GB/16GB/32GB  USB2.0 /(COMPATIBLE WITH USB 3.0)', 200.00, 'https://cf.shopee.com.my/file/53f88b5a9959f8818296c6cc283ee476', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (809, 'Suntaiho 2M 1.2M 0.5M 3A Magnetic USB Cable Micro Usb Type C iphone ios Fast Charging Cable', 'Suntaiho 2M 1.2M 0.5M 3A Magnetic USB Cable Micro Usb Type C iphone ios Fast Charging Cable', 'Suntaiho 2M 1.2M 0.5M 3A Magnetic USB Cable Micro Usb Type C iphone ios Fast Charging Cable', 19.80, 'https://cf.shopee.com.my/file/1d7978c477f0e5b20dadde54966bd3e7', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (810, '10.0/14.0/15.6 inch Notebook Dustproof Keyboard Cover Universal Silicone Laptop Keyboard Protector', '10.0/14.0/15.6 inch Notebook Dustproof Keyboard Cover Universal Silicone Laptop Keyboard Protector', '10.0/14.0/15.6 inch Notebook Dustproof Keyboard Cover Universal Silicone Laptop Keyboard Protector', 15.70, 'https://cf.shopee.com.my/file/71ebbeae7eca46911f91192e1f8c6a00', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (812, 'Babyku Baju Baby Berlubang Short/Long Sleeve Long Pants 0-18 Bulan/ Newborn Baby Clothing Eyelet Ready Stock', 'Babyku Baju Baby Berlubang Short/Long Sleeve Long Pants 0-18 Bulan/ Newborn Baby Clothing Eyelet Ready Stock', 'Babyku Baju Baby Berlubang Short/Long Sleeve Long Pants 0-18 Bulan/ Newborn Baby Clothing Eyelet Ready Stock', 139.00, 'https://cf.shopee.com.my/file/e7b1a625febec51d82d91c2062f1387f', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (813, '3Pcs Long Sleeves New Born Baju Baby(0-6Mths)', '3Pcs Long Sleeves New Born Baju Baby(0-6Mths)', '3Pcs Long Sleeves New Born Baju Baby(0-6Mths)', 218.80, 'https://cf.shopee.com.my/file/8ccc62cce99873fafadbcfaee9e9114c', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (814, 'Cute Cartoon 0-18M Newborn Infant Short Sleeve Baby Rompers Boy Girl Kids Clothes One Piece Pyjamas Baju Bayi QY009', 'Cute Cartoon 0-18M Newborn Infant Short Sleeve Baby Rompers Boy Girl Kids Clothes One Piece Pyjamas Baju Bayi QY009', 'Cute Cartoon 0-18M Newborn Infant Short Sleeve Baby Rompers Boy Girl Kids Clothes One Piece Pyjamas Baju Bayi QY009', 74.70, 'https://cf.shopee.com.my/file/c8514fdabeadef5b9a4d93309cb187c5', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (816, '0-24M Baby Shoes With Sound Kid Boys Girls Toddler Sandals Soft Bottom Antiskid Sandal Kasut Bayi Selipar Budak Umur 0-2', '0-24M Baby Shoes With Sound Kid Boys Girls Toddler Sandals Soft Bottom Antiskid Sandal Kasut Bayi Selipar Budak Umur 0-2', '0-24M Baby Shoes With Sound Kid Boys Girls Toddler Sandals Soft Bottom Antiskid Sandal Kasut Bayi Selipar Budak Umur 0-2', 175.00, 'https://cf.shopee.com.my/file/2410feb4d3d8ac3a76ebeb116a0c7797', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (817, '3 PSG LOWEST PRICE 3 HELAI NEW BORN BABY INFANT SUIT 3 IN 1 SET 0-6 M - BORONG', '3 PSG LOWEST PRICE 3 HELAI NEW BORN BABY INFANT SUIT 3 IN 1 SET 0-6 M - BORONG', '3 PSG LOWEST PRICE 3 HELAI NEW BORN BABY INFANT SUIT 3 IN 1 SET 0-6 M - BORONG', 150.00, 'https://cf.shopee.com.my/file/e722920cd76a06ffd5b2ed50c4b81164', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (819, 'AC-DC power supply 6V 500mA 0.5A Adapter for Omron HEM-7121 HEM-7120 M2 Basic Blood Pressure Monitor', 'AC-DC power supply 6V 500mA 0.5A Adapter for Omron HEM-7121 HEM-7120 M2 Basic Blood Pressure Monitor', 'AC-DC power supply 6V 500mA 0.5A Adapter for Omron HEM-7121 HEM-7120 M2 Basic Blood Pressure Monitor', 151.00, 'https://cf.shopee.com.my/file/8c15cfea09500297fcde18df5e1d1ea5', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (821, '(30 Pcs) Freshkon Daily Disposable 1 Day Contact Lenses - Power -0.75 to -10.00', '(30 Pcs) Freshkon Daily Disposable 1 Day Contact Lenses - Power -0.75 to -10.00', '(30 Pcs) Freshkon Daily Disposable 1 Day Contact Lenses - Power -0.75 to -10.00', 396.80, 'https://cf.shopee.com.my/file/a03e558bfca5af0d0eac62193aa597b1', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (822, 'BD Micro fine Plus 4mm Jarum Insulin BD Ultra Fine Plus 0.23mm (32G) x 4mm lose needles no box', 'BD Micro fine Plus 4mm Jarum Insulin BD Ultra Fine Plus 0.23mm (32G) x 4mm lose needles no box', 'BD Micro fine Plus 4mm Jarum Insulin BD Ultra Fine Plus 0.23mm (32G) x 4mm lose needles no box', 5.40, 'https://cf.shopee.com.my/file/191dcce10623fa6721cfc59a0aa5ab82', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (823, 'BIGEYE LENS EFFECT 20MM I.FAIRY PEARL BLACK/CHOCO POWER 0-850 BIG EFFECT Korean Color Contact Lens', 'BIGEYE LENS EFFECT 20MM I.FAIRY PEARL BLACK/CHOCO POWER 0-850 BIG EFFECT Korean Color Contact Lens', 'BIGEYE LENS EFFECT 20MM I.FAIRY PEARL BLACK/CHOCO POWER 0-850 BIG EFFECT Korean Color Contact Lens', 111.30, 'https://cf.shopee.com.my/file/150808375b38d1d4b2e6dcd2fecf86b0', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (824, 'Newborn baby wear ~Infant summer suit ,baju set bayi berjaring,baju baby set 0-3months', 'Newborn baby wear ~Infant summer suit ,baju set bayi berjaring,baju baby set 0-3months', 'Newborn baby wear ~Infant summer suit ,baju set bayi berjaring,baju baby set 0-3months', 39.00, 'https://cf.shopee.com.my/file/c491ad24b5ce23efdce2740a2fe2c20a', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (825, '[M\'sia] Ready Stock  cartoon pattern gel pen student cute stationery 0.5MM Penanda tandatangan Alat cartoon pen kartun', '[M\'sia] Ready Stock  cartoon pattern gel pen student cute stationery 0.5MM Penanda tandatangan Alat cartoon pen kartun', '[M\'sia] Ready Stock  cartoon pattern gel pen student cute stationery 0.5MM Penanda tandatangan Alat cartoon pen kartun', 4.80, 'https://cf.shopee.com.my/file/0b1f185f218b1774c019813892355453', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (826, 'Faber Castell NX23 Ball Pen 0.5mm 0.7mm 1.0mm Black Blue Red (1pc)', 'Faber Castell NX23 Ball Pen 0.5mm 0.7mm 1.0mm Black Blue Red (1pc)', 'Faber Castell NX23 Ball Pen 0.5mm 0.7mm 1.0mm Black Blue Red (1pc)', 6.80, 'https://cf.shopee.com.my/file/c2879c91fd760a5ada2ed171b3761f92', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (828, 'Kreati Black Pen 0.7mm 4 IN 1 - 0679', 'Kreati Black Pen 0.7mm 4 IN 1 - 0679', 'Kreati Black Pen 0.7mm 4 IN 1 - 0679', 21.00, 'https://cf.shopee.com.my/file/c96b56a525ba8ce406e31b58eb287ba5', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (829, 'Yamalube 4T 20W-50 20W50 Motorcycle 100% ORIGINAL YAMAHA ENGINE OIL (1 Liter or 0.85 L) MINYAK HITAM GREY GRAY', 'Yamalube 4T 20W-50 20W50 Motorcycle 100% ORIGINAL YAMAHA ENGINE OIL (1 Liter or 0.85 L) MINYAK HITAM GREY GRAY', 'Yamalube 4T 20W-50 20W50 Motorcycle 100% ORIGINAL YAMAHA ENGINE OIL (1 Liter or 0.85 L) MINYAK HITAM GREY GRAY', 98.00, 'https://cf.shopee.com.my/file/693e565284515fd287bf674b9ea37fd1', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (830, '0-5Y Baby Kid Set Pajamas Pyjamas Long Sleeve with Long Pants Boy Girl Kids Sleepwear Baju Bayi QY008', '0-5Y Baby Kid Set Pajamas Pyjamas Long Sleeve with Long Pants Boy Girl Kids Sleepwear Baju Bayi QY008', '0-5Y Baby Kid Set Pajamas Pyjamas Long Sleeve with Long Pants Boy Girl Kids Sleepwear Baju Bayi QY008', 62.60, 'https://cf.shopee.com.my/file/955878a1e37c6d5899ab8b997d3a3055', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (831, 'Resistor 1k ohm (Carbon - 0.25W)', 'Resistor 1k ohm (Carbon - 0.25W)', 'Resistor 1k ohm (Carbon - 0.25W)', 1.00, 'https://cf.shopee.com.my/file/e264f89231173d9f3f1450e29ae2d15e', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (832, '3pcs /set Newborn Baby Sleepsuit Cartoon Girls Rompers 100% Cotton Jumpsuit Long Sleeve Footies Newborn Clothes 0-12M', '3pcs /set Newborn Baby Sleepsuit Cartoon Girls Rompers 100% Cotton Jumpsuit Long Sleeve Footies Newborn Clothes 0-12M', '3pcs /set Newborn Baby Sleepsuit Cartoon Girls Rompers 100% Cotton Jumpsuit Long Sleeve Footies Newborn Clothes 0-12M', 639.90, 'https://cf.shopee.com.my/file/52b86d03e092e26fe9b85ad8c5a1f36e', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (833, '3M SUPER STRONG TAPE / water proof / heavy duty / outdoor / vehicle tape/ foam tape / double sided tape 0.1x1CM', '3M SUPER STRONG TAPE / water proof / heavy duty / outdoor / vehicle tape/ foam tape / double sided tape 0.1x1CM', '3M SUPER STRONG TAPE / water proof / heavy duty / outdoor / vehicle tape/ foam tape / double sided tape 0.1x1CM', 18.90, 'https://cf.shopee.com.my/file/dd315435a76902df5602c5ed457e4431', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (834, 'IsALifestyle Baby Zip Swaddle Instant Sleeping Bag Cotton Bedung Bayi New Born Sleep Bag Size S&L(0-12M)', 'IsALifestyle Baby Zip Swaddle Instant Sleeping Bag Cotton Bedung Bayi New Born Sleep Bag Size S&L(0-12M)', 'IsALifestyle Baby Zip Swaddle Instant Sleeping Bag Cotton Bedung Bayi New Born Sleep Bag Size S&L(0-12M)', 259.90, 'https://cf.shopee.com.my/file/43a5fc6b5ce8f5ff464228d4405428a1', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (835, '0-3 Years Baby Girl Clothing Set / Short Sleeve Shirt & Pants / Playset Baby Girl/ Kids Blouse', '0-3 Years Baby Girl Clothing Set / Short Sleeve Shirt & Pants / Playset Baby Girl/ Kids Blouse', '0-3 Years Baby Girl Clothing Set / Short Sleeve Shirt & Pants / Playset Baby Girl/ Kids Blouse', 107.80, 'https://cf.shopee.com.my/file/12e8d8a82a141d2cd7b1ae0e3fb464d1', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (836, 'Original DOT AIO DOTMOD COIL HEAD OCC 0.3 OHM/0.7OHM/1.2OHM', 'Original DOT AIO DOTMOD COIL HEAD OCC 0.3 OHM/0.7OHM/1.2OHM', 'Original DOT AIO DOTMOD COIL HEAD OCC 0.3 OHM/0.7OHM/1.2OHM', 570.00, 'https://cf.shopee.com.my/file/dd3648fc9528dcef1b672ad04682f813', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (837, 'Part ABS Plastic Pla Plate 0.5mm 0.8mm 1mm OMG Gundam Pla-Plate PlaPlate Gundam Plastic Parts Gundam ABS Part', 'Part ABS Plastic Pla Plate 0.5mm 0.8mm 1mm OMG Gundam Pla-Plate PlaPlate Gundam Plastic Parts Gundam ABS Part', 'Part ABS Plastic Pla Plate 0.5mm 0.8mm 1mm OMG Gundam Pla-Plate PlaPlate Gundam Plastic Parts Gundam ABS Part', 10.00, 'https://cf.shopee.com.my/file/c1235405de8bff39015dd6b6d75df71d', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (838, 'MALL Display Port V1.4 V1.2 DP CABLE Displayport ThunderBolt 3 UHD 8K 4K 2K 60HZ 120HZ 144HZ 1.4 1.2 to HDMI V2.0 Mini M', 'MALL Display Port V1.4 V1.2 DP CABLE Displayport ThunderBolt 3 UHD 8K 4K 2K 60HZ 120HZ 144HZ 1.4 1.2 to HDMI V2.0 Mini M', 'MALL Display Port V1.4 V1.2 DP CABLE Displayport ThunderBolt 3 UHD 8K 4K 2K 60HZ 120HZ 144HZ 1.4 1.2 to HDMI V2.0 Mini M', 150.00, 'https://cf.shopee.com.my/file/e301fe6ed59f5f6e64f295934ec9c8f6', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (839, 'BRAZING ROD 0% WELDING ROD', 'BRAZING ROD 0% WELDING ROD', 'BRAZING ROD 0% WELDING ROD', 17.00, 'https://cf.shopee.com.my/file/f5981b13e66cced0823af4de81aa2044', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (840, 'BIGEYE 20MM EFFECT PEARL BLACK [POWER 0 to 1000]', 'BIGEYE 20MM EFFECT PEARL BLACK [POWER 0 to 1000]', 'BIGEYE 20MM EFFECT PEARL BLACK [POWER 0 to 1000]', 129.80, 'https://cf.shopee.com.my/file/89ce101c65d3ffc9df15d507940cb275', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (841, 'Kids Baby Sandals Cartoon Bear Shoes 0-2Yrs Boy Girls Soft Rubber Flat Sandal Beach Shoes', 'Kids Baby Sandals Cartoon Bear Shoes 0-2Yrs Boy Girls Soft Rubber Flat Sandal Beach Shoes', 'Kids Baby Sandals Cartoon Bear Shoes 0-2Yrs Boy Girls Soft Rubber Flat Sandal Beach Shoes', 115.00, 'https://cf.shopee.com.my/file/5f9c640b6dee5471b52fdb9ddb9ee747', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (842, '500g/0.1g Penimbang Emas Mini Scale Timbang Digital Pocket Scale / Digital Weighing Scale Electronic Kitchen Scale', '500g/0.1g Penimbang Emas Mini Scale Timbang Digital Pocket Scale / Digital Weighing Scale Electronic Kitchen Scale', '500g/0.1g Penimbang Emas Mini Scale Timbang Digital Pocket Scale / Digital Weighing Scale Electronic Kitchen Scale', 156.80, 'https://cf.shopee.com.my/file/f2e6aa3441dba29c4e001c10783d61c2', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (843, '(RM 0.05/page) A4 Black & White Printing Service | Double sided | BOOK | NOTE |', '(RM 0.05/page) A4 Black & White Printing Service | Double sided | BOOK | NOTE |', '(RM 0.05/page) A4 Black & White Printing Service | Double sided | BOOK | NOTE |', 1.00, 'https://cf.shopee.com.my/file/cdff22ccc0b72a7ba3f3dbd79698bf85', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (844, 'Pentel BLN105 EnerGel-X Retractable Gel Roller Pen 0.5mm', 'Pentel BLN105 EnerGel-X Retractable Gel Roller Pen 0.5mm', 'Pentel BLN105 EnerGel-X Retractable Gel Roller Pen 0.5mm', 38.60, 'https://cf.shopee.com.my/file/e848eece98d45336bdd047f273493f2a', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (845, 'Faber Castell / Faber-Castell Ball Pen Click X5 0.5mm X7 0.7mm', 'Faber Castell / Faber-Castell Ball Pen Click X5 0.5mm X7 0.7mm', 'Faber Castell / Faber-Castell Ball Pen Click X5 0.5mm X7 0.7mm', 4.90, 'https://cf.shopee.com.my/file/c7d76cb1162e2ee90bd89628bd740647', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (846, 'Kreati Ballpoint Black Gel Ink Pen 0.5MM 8 IN 1-0311', 'Kreati Ballpoint Black Gel Ink Pen 0.5MM 8 IN 1-0311', 'Kreati Ballpoint Black Gel Ink Pen 0.5MM 8 IN 1-0311', 21.00, 'https://cf.shopee.com.my/file/42610640f10395366868164981bcafa5', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (847, '0-36month Breathable Cotton Baby Ring Sling Carrier Baby Carrier', '0-36month Breathable Cotton Baby Ring Sling Carrier Baby Carrier', '0-36month Breathable Cotton Baby Ring Sling Carrier Baby Carrier', 263.00, 'https://cf.shopee.com.my/file/c2baebfc2f7c13e1e480309145d4170a', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (848, 'BIGEYE I.Fairy Destiny 16.2MM Power 0-8.50 Korean Color Contact Lens', 'BIGEYE I.Fairy Destiny 16.2MM Power 0-8.50 Korean Color Contact Lens', 'BIGEYE I.Fairy Destiny 16.2MM Power 0-8.50 Korean Color Contact Lens', 129.00, 'https://cf.shopee.com.my/file/df3e2d6a2c391e939451934b8f689a1d', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (849, 'Gossip 14.2mm Big eyes Contact Lens/Color Lens/Korea Lens (P-0.00 till P-8.00) Free Case', 'Gossip 14.2mm Big eyes Contact Lens/Color Lens/Korea Lens (P-0.00 till P-8.00) Free Case', 'Gossip 14.2mm Big eyes Contact Lens/Color Lens/Korea Lens (P-0.00 till P-8.00) Free Case', 99.00, 'https://cf.shopee.com.my/file/a0425eaffcf0c25362e5674523a937ce', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (850, 'Ippo Store 10 Pcs Football Dribbling Training Cones 18.5cm x 4.5cm x 0.5cm', 'Ippo Store 10 Pcs Football Dribbling Training Cones 18.5cm x 4.5cm x 0.5cm', 'Ippo Store 10 Pcs Football Dribbling Training Cones 18.5cm x 4.5cm x 0.5cm', 93.20, 'https://cf.shopee.com.my/file/ca4eaa4f0055c5cdfda14f9ad8e42980', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (851, 'Part 1 Original Toyobo/German Cotton Japan (Harga utk 0.5m) bidang 60 by Ana Textile', 'Part 1 Original Toyobo/German Cotton Japan (Harga utk 0.5m) bidang 60 by Ana Textile', 'Part 1 Original Toyobo/German Cotton Japan (Harga utk 0.5m) bidang 60 by Ana Textile', 49.90, 'https://cf.shopee.com.my/file/3ad344e76b788c9b55160c1ec88b7304', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (852, 'ARTLINE DRAWING SYSTEM BLACK PEN (0.1/0.2/0.3/0.4/0.5/0.6/0.7/0.8 mm)', 'ARTLINE DRAWING SYSTEM BLACK PEN (0.1/0.2/0.3/0.4/0.5/0.6/0.7/0.8 mm)', 'ARTLINE DRAWING SYSTEM BLACK PEN (0.1/0.2/0.3/0.4/0.5/0.6/0.7/0.8 mm)', 35.80, 'https://cf.shopee.com.my/file/3e0059ee26cf46dc94ee310a69624490', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (853, 'Air Optix Plus Hydraglyde (3 Pcs) Alcon Silicone Monthly Lenses - Power -0.50 to -12.00', 'Air Optix Plus Hydraglyde (3 Pcs) Alcon Silicone Monthly Lenses - Power -0.50 to -12.00', 'Air Optix Plus Hydraglyde (3 Pcs) Alcon Silicone Monthly Lenses - Power -0.50 to -12.00', 410.00, 'https://cf.shopee.com.my/file/d33fa0caa210febb117fcf2f8f946f17', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (856, '[Grab2Go] Mechanical Pencil - STABILO Mechanical Pencil (0.7mm) Set with Hi Polymer Leads and Eraser', '[Grab2Go] Mechanical Pencil - STABILO Mechanical Pencil (0.7mm) Set with Hi Polymer Leads and Eraser', '[Grab2Go] Mechanical Pencil - STABILO Mechanical Pencil (0.7mm) Set with Hi Polymer Leads and Eraser', 22.00, 'https://cf.shopee.com.my/file/e60a51da0a3c783f7d3da5700804dbcf', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (857, 'Baju tshirt/ Blouse /Seluar/Dress Bundle baby & kids girl 0-12y+ live @ Random', 'Baju tshirt/ Blouse /Seluar/Dress Bundle baby & kids girl 0-12y+ live @ Random', 'Baju tshirt/ Blouse /Seluar/Dress Bundle baby & kids girl 0-12y+ live @ Random', 20.00, 'https://cf.shopee.com.my/file/9bdc1a4b7e0042c0fd0bd630b5d13b21', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (858, '(0.10sen/Page) Printing Service | A4 A5 Black & White | Single Sided | Photocopy Pastyear Question| Audit Report| Flyers', '(0.10sen/Page) Printing Service | A4 A5 Black & White | Single Sided | Photocopy Pastyear Question| Audit Report| Flyers', '(0.10sen/Page) Printing Service | A4 A5 Black & White | Single Sided | Photocopy Pastyear Question| Audit Report| Flyers', 1.00, 'https://cf.shopee.com.my/file/0f0451900255993649466b791f15f86e', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (861, '[xiaibeibei] Newborn Hat Baby Cute Hats Kids Boy/girl Soft Cotton Caps Knit 0-6m 1', '[xiaibeibei] Newborn Hat Baby Cute Hats Kids Boy/girl Soft Cotton Caps Knit 0-6m 1', '[xiaibeibei] Newborn Hat Baby Cute Hats Kids Boy/girl Soft Cotton Caps Knit 0-6m 1', 12.00, 'https://cf.shopee.com.my/file/4e803d62123070e8df43f8685521603f', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (863, 'Baseus USB Type C To Type C Cable Support PD 60W/100W QC3.0 3A Quick Charge Cable', 'Baseus USB Type C To Type C Cable Support PD 60W/100W QC3.0 3A Quick Charge Cable', 'Baseus USB Type C To Type C Cable Support PD 60W/100W QC3.0 3A Quick Charge Cable', 99.00, 'https://cf.shopee.com.my/file/a3f793a13f70420ae52a64fcf4315d76', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (864, 'Faber-Castell RX Gel Pen 0.5/0.7mm', 'Faber-Castell RX Gel Pen 0.5/0.7mm', 'Faber-Castell RX Gel Pen 0.5/0.7mm', 12.00, 'https://cf.shopee.com.my/file/5907eee11bb26968e393ec6bdd9b19a5', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (866, 'Abonnie auto fans eyelash extension 0.05/0.07 C/D curl 1s bloom makeup eyelash 8-17mm mink volume lashes', 'Abonnie auto fans eyelash extension 0.05/0.07 C/D curl 1s bloom makeup eyelash 8-17mm mink volume lashes', 'Abonnie auto fans eyelash extension 0.05/0.07 C/D curl 1s bloom makeup eyelash 8-17mm mink volume lashes', 109.50, 'https://cf.shopee.com.my/file/a1da4b397728a4dceccfd1bae50e0151', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (867, 'Ready Stock 0 - 4 years old Baby Kids girl underwear panties underpants Fashion cotton budak perempuan panties', 'Ready Stock 0 - 4 years old Baby Kids girl underwear panties underpants Fashion cotton budak perempuan panties', 'Ready Stock 0 - 4 years old Baby Kids girl underwear panties underpants Fashion cotton budak perempuan panties', 34.30, 'https://cf.shopee.com.my/file/21c42d47f3918dfc8581a2e94d5d16d1', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (869, 'Xbox 360 jtag + LT3.0 console - 64GB  - 24 games set', 'Xbox 360 jtag + LT3.0 console - 64GB  - 24 games set', 'Xbox 360 jtag + LT3.0 console - 64GB  - 24 games set', 6590.00, 'https://cf.shopee.com.my/file/083f4da6e5df6257e7be7b1e3da7bf6f', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (874, '3 In 1 USB OTG Card Reader High-speed USB2.0 Universal OTG TF/SD for Android', '3 In 1 USB OTG Card Reader High-speed USB2.0 Universal OTG TF/SD for Android', '3 In 1 USB OTG Card Reader High-speed USB2.0 Universal OTG TF/SD for Android', 100.00, 'https://cf.shopee.com.my/file/6b72339d7c3dd57fa97952e8ddb2477d', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (875, 'Ready Stock 0 - 5 years old Baby Kids boy and girl underwear panties underpants Fashion cotton budak lelaki panties', 'Ready Stock 0 - 5 years old Baby Kids boy and girl underwear panties underpants Fashion cotton budak lelaki panties', 'Ready Stock 0 - 5 years old Baby Kids boy and girl underwear panties underpants Fashion cotton budak lelaki panties', 37.70, 'https://cf.shopee.com.my/file/b9236aba335a8cd598b0dea0a88ca251', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (876, 'Baju Baby 0-36months/ Babyset / Baju Babygirl', 'Baju Baby 0-36months/ Babyset / Baju Babygirl', 'Baju Baby 0-36months/ Babyset / Baju Babygirl', 99.00, 'https://cf.shopee.com.my/file/acee90337cbd51ccbd1f0595512b3ca1', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (877, 'Bausch & Lomb Soflens 38 Monthly - Power -0.50 to -9.00 (6 Pcs)', 'Bausch & Lomb Soflens 38 Monthly - Power -0.50 to -9.00 (6 Pcs)', 'Bausch & Lomb Soflens 38 Monthly - Power -0.50 to -9.00 (6 Pcs)', 399.80, 'https://cf.shopee.com.my/file/493aef5ee3ce82b6544406dd944fab7d', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (878, 'Waterproof Clear A4 Holder L / U / C Shape File (0.18mm super thick)', 'Waterproof Clear A4 Holder L / U / C Shape File (0.18mm super thick)', 'Waterproof Clear A4 Holder L / U / C Shape File (0.18mm super thick)', 6.00, 'https://cf.shopee.com.my/file/81962d13ace866b2c55f36f1deecac5a', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (879, 'Kain Pasang Premium Heavy Como Crepe Bidang 60 [Harga Utk 0.5m]', 'Kain Pasang Premium Heavy Como Crepe Bidang 60 [Harga Utk 0.5m]', 'Kain Pasang Premium Heavy Como Crepe Bidang 60 [Harga Utk 0.5m]', 25.00, 'https://cf.shopee.com.my/file/9e62a74120b290ae31e275d07e07b6b4', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (880, 'EVERYSTEP 0 - 6 Bulan Set Baju + Seluar Newborn Baby Pakaian Bayi cotton baby clothes', 'EVERYSTEP 0 - 6 Bulan Set Baju + Seluar Newborn Baby Pakaian Bayi cotton baby clothes', 'EVERYSTEP 0 - 6 Bulan Set Baju + Seluar Newborn Baby Pakaian Bayi cotton baby clothes', 108.00, 'https://cf.shopee.com.my/file/29a27a8497b47d8814ff1ed5b18085e2', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (881, '* CHEAPEST IN TOWN* POPULAR * NEW *STUNNING * ANGELA SERIES 14.2MM Contact Lens Original Korea Lens ( Power 0-1000 )', '* CHEAPEST IN TOWN* POPULAR * NEW *STUNNING * ANGELA SERIES 14.2MM Contact Lens Original Korea Lens ( Power 0-1000 )', '* CHEAPEST IN TOWN* POPULAR * NEW *STUNNING * ANGELA SERIES 14.2MM Contact Lens Original Korea Lens ( Power 0-1000 )', 149.00, 'https://cf.shopee.com.my/file/dd023adf6821a22bdaba797ec0dd0eee', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (882, '0.5mm Plastic Gel Pen For Writing Material Gel-ink Pen Creative Office School Student Stationery Supplies 040172', '0.5mm Plastic Gel Pen For Writing Material Gel-ink Pen Creative Office School Student Stationery Supplies 040172', '0.5mm Plastic Gel Pen For Writing Material Gel-ink Pen Creative Office School Student Stationery Supplies 040172', 3.00, 'https://cf.shopee.com.my/file/4a609fa85dfea7259bd7f2d7f97efacb', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (884, '0.02mm to 1.00mm 17 23 32 Blades Thickness Gap Filler YAMAHA HONDA SPANNER ADJUST VALVE TOOLS (TAPPET) SIZE 8\'\' & 9\'\'', '0.02mm to 1.00mm 17 23 32 Blades Thickness Gap Filler YAMAHA HONDA SPANNER ADJUST VALVE TOOLS (TAPPET) SIZE 8\'\' & 9\'\'', '0.02mm to 1.00mm 17 23 32 Blades Thickness Gap Filler YAMAHA HONDA SPANNER ADJUST VALVE TOOLS (TAPPET) SIZE 8\'\' & 9\'\'', 95.00, 'https://cf.shopee.com.my/file/1ca361255260a5d4feae6dbe9ecfb3e7', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (886, 'Shantung Silk - Bidang 58\" RM7.00 utk 0.5mtr (setengah meter)', 'Shantung Silk - Bidang 58\" RM7.00 utk 0.5mtr (setengah meter)', 'Shantung Silk - Bidang 58\" RM7.00 utk 0.5mtr (setengah meter)', 59.50, 'https://cf.shopee.com.my/file/a5b493d2d7af9f896da21ae3ca497b66', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (887, 'Kreati Gel Ink Pen 0.5MM 6 IN 1- 0316', 'Kreati Gel Ink Pen 0.5MM 6 IN 1- 0316', 'Kreati Gel Ink Pen 0.5MM 6 IN 1- 0316', 21.00, 'https://cf.shopee.com.my/file/3d1bc4c955ffc8fc08e36ee2ffa335c3', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (888, 'Blue Colour NIEKI Ball Point Pen 0.7mm', 'Blue Colour NIEKI Ball Point Pen 0.7mm', 'Blue Colour NIEKI Ball Point Pen 0.7mm', 1.90, 'https://cf.shopee.com.my/file/085aafe5ed37c54960cd3f0c14602193', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (890, '20ml Glitter Powder 0.2mm Resin Epoxy Nail Art Slime Candles Soap Makeup Jewellery Polymer Clay DIY Craft Making', '20ml Glitter Powder 0.2mm Resin Epoxy Nail Art Slime Candles Soap Makeup Jewellery Polymer Clay DIY Craft Making', '20ml Glitter Powder 0.2mm Resin Epoxy Nail Art Slime Candles Soap Makeup Jewellery Polymer Clay DIY Craft Making', 29.90, 'https://cf.shopee.com.my/file/f90a79a82262cda7d09d3eb19f99fda6', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (891, '0.10 sen Printing Service - Double A 80gsm', '0.10 sen Printing Service - Double A 80gsm', '0.10 sen Printing Service - Double A 80gsm', 1.00, 'https://cf.shopee.com.my/file/4855fad400f4750111e51c2e3e498c77', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (892, '14.0\" - 15.6\" Universal Laptop Silicone Keyboard Skin Cover Protector for Laptop', '14.0\" - 15.6\" Universal Laptop Silicone Keyboard Skin Cover Protector for Laptop', '14.0\" - 15.6\" Universal Laptop Silicone Keyboard Skin Cover Protector for Laptop', 18.00, 'https://cf.shopee.com.my/file/8bccb03e6d03cca7f66193990b80b1ac', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (893, 'Babyku Baju Baby Berlubang Short/Long Sleeve Long Pants 0-18 Bulan/ Newborn Baby Clothing Eyelet Ready Stock', 'Babyku Baju Baby Berlubang Short/Long Sleeve Long Pants 0-18 Bulan/ Newborn Baby Clothing Eyelet Ready Stock', 'Babyku Baju Baby Berlubang Short/Long Sleeve Long Pants 0-18 Bulan/ Newborn Baby Clothing Eyelet Ready Stock', 139.00, 'https://cf.shopee.com.my/file/63ce0a12d4a0f19b16de2742e21e6898', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (894, '1 X 2 SINGLE MODE COUPLE PLC SPLITTER (0.9MM) with 2 SC/UPC ADAPTOR', '1 X 2 SINGLE MODE COUPLE PLC SPLITTER (0.9MM) with 2 SC/UPC ADAPTOR', '1 X 2 SINGLE MODE COUPLE PLC SPLITTER (0.9MM) with 2 SC/UPC ADAPTOR', 125.00, 'https://cf.shopee.com.my/file/168e10e61222cbac18ff639e7bfe0602', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (895, 'Imi Tamiya Aluminum Tube Spacer Set - 1.5/3.0/6.0/12.0mm', 'Imi Tamiya Aluminum Tube Spacer Set - 1.5/3.0/6.0/12.0mm', 'Imi Tamiya Aluminum Tube Spacer Set - 1.5/3.0/6.0/12.0mm', 80.00, 'https://cf.shopee.com.my/file/9189e2aafca0d40143848dd27eafc080', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (896, 'AtoZ- 3D Resin Printing Service - RM0.60/0.70 gram 0.75/0.90/ml LCD/DLP/SLA/Resin Printing - Vat polymerisation 3D print', 'AtoZ- 3D Resin Printing Service - RM0.60/0.70 gram 0.75/0.90/ml LCD/DLP/SLA/Resin Printing - Vat polymerisation 3D print', 'AtoZ- 3D Resin Printing Service - RM0.60/0.70 gram 0.75/0.90/ml LCD/DLP/SLA/Resin Printing - Vat polymerisation 3D print', 6.00, 'https://cf.shopee.com.my/file/c79f4a0a8ae748c7b76021c9c0ea146b', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (897, 'kurta kanak-kanak short sleeve/ kurta baby short sleeve (saiz 0-3y)', 'kurta kanak-kanak short sleeve/ kurta baby short sleeve (saiz 0-3y)', 'kurta kanak-kanak short sleeve/ kurta baby short sleeve (saiz 0-3y)', 299.00, 'https://cf.shopee.com.my/file/62132276c8934714eca07e819a983e9b', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (898, '( monthly ) Clariti Elite Monthly Cooper Vision Silicone Hydrogel - Power -0.50 to -10.00', '( monthly ) Clariti Elite Monthly Cooper Vision Silicone Hydrogel - Power -0.50 to -10.00', '( monthly ) Clariti Elite Monthly Cooper Vision Silicone Hydrogel - Power -0.50 to -10.00', 329.70, 'https://cf.shopee.com.my/file/59472b44e2210b90139e4a132051a4fb', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (899, 'Stylus Touch Pen With Student 0.7mm Black Ink Pen For Mobile Phone Android / Iphone Ipad Touch Screen Electronic Devices', 'Stylus Touch Pen With Student 0.7mm Black Ink Pen For Mobile Phone Android / Iphone Ipad Touch Screen Electronic Devices', 'Stylus Touch Pen With Student 0.7mm Black Ink Pen For Mobile Phone Android / Iphone Ipad Touch Screen Electronic Devices', 29.00, 'https://cf.shopee.com.my/file/04be3e0a51e9e37148b9b3f4ef5e90a4', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (900, 'PFT7-0-3 Years Kids Baby Girls Fashion 2-piece Outfit Set Fly Sleeve Solid Color Crop Top+Flared Pants Set', 'PFT7-0-3 Years Kids Baby Girls Fashion 2-piece Outfit Set Fly Sleeve Solid Color Crop Top+Flared Pants Set', 'PFT7-0-3 Years Kids Baby Girls Fashion 2-piece Outfit Set Fly Sleeve Solid Color Crop Top+Flared Pants Set', 256.60, 'https://cf.shopee.com.my/file/aec3657eaa5766c6073c676101e9d54c', 1627909662, 1, 1);
INSERT INTO `xy_goods_list` VALUES (902, 'Fashion Cartoon baby girls boys clothes jumpsuit 0-12month kids clothes cotton newborn Baby Raya Clothes', 'Fashion Cartoon baby girls boys clothes jumpsuit 0-12month kids clothes cotton newborn Baby Raya Clothes', 'Fashion Cartoon baby girls boys clothes jumpsuit 0-12month kids clothes cotton newborn Baby Raya Clothes', 96.90, 'https://cf.shopee.com.my/file/ab17fac0cd1d6466f002a86e14f8605b', 1627909663, 1, 1);
INSERT INTO `xy_goods_list` VALUES (903, '(0.03sen/Page) Printing Service | A4 Black & White Double Sided Paper | Print | Photocopy | Fotostat | Book, Note', '(0.03sen/Page) Printing Service | A4 Black & White Double Sided Paper | Print | Photocopy | Fotostat | Book, Note', '(0.03sen/Page) Printing Service | A4 Black & White Double Sided Paper | Print | Photocopy | Fotostat | Book, Note', 1.00, 'https://cf.shopee.com.my/file/ff4b5261422f46d6ae245c52c065bfa1', 1627909663, 1, 1);
INSERT INTO `xy_goods_list` VALUES (905, 'Zebra Sarasa Clip 0.5mm Gel Ink Pen (20 Colors Available) LIST 1/4', 'Zebra Sarasa Clip 0.5mm Gel Ink Pen (20 Colors Available) LIST 1/4', 'Zebra Sarasa Clip 0.5mm Gel Ink Pen (20 Colors Available) LIST 1/4', 39.00, 'https://cf.shopee.com.my/file/a80bcd9969f34192eaf39a96c9b8dfbe', 1627909663, 1, 1);
INSERT INTO `xy_goods_list` VALUES (906, '[JPJ Approved] Number Plate Sticker 0-9 Motorcycle White Nombor Sticker Motor Moto Motosikal 123 ABC Putih A-Z', '[JPJ Approved] Number Plate Sticker 0-9 Motorcycle White Nombor Sticker Motor Moto Motosikal 123 ABC Putih A-Z', '[JPJ Approved] Number Plate Sticker 0-9 Motorcycle White Nombor Sticker Motor Moto Motosikal 123 ABC Putih A-Z', 4.50, 'https://cf.shopee.com.my/file/bd5a05dc7c8caa1c89a00722d0513b72', 1627909663, 1, 1);
INSERT INTO `xy_goods_list` VALUES (907, '[PD Charger] 1 Year Warranty Mcdodo 20W PD + QC3.0 Power Adapter UK Wall Plug CH-7231 20W PD Fast Charging iPhone Cable', '[PD Charger] 1 Year Warranty Mcdodo 20W PD + QC3.0 Power Adapter UK Wall Plug CH-7231 20W PD Fast Charging iPhone Cable', '[PD Charger] 1 Year Warranty Mcdodo 20W PD + QC3.0 Power Adapter UK Wall Plug CH-7231 20W PD Fast Charging iPhone Cable', 524.00, 'https://cf.shopee.com.my/file/9b5c6ef8a77857de206d9f3446cd3cec', 1627909663, 1, 1);
INSERT INTO `xy_goods_list` VALUES (910, 'Pakaian kanak-kanak lelaki berusia 0-4 tahun musim panas bayi lelaki dicetak kemeja daun T-shirt + seluar pendek 2 set', 'Pakaian kanak-kanak lelaki berusia 0-4 tahun musim panas bayi lelaki dicetak kemeja daun T-shirt + seluar pendek 2 set', 'Pakaian kanak-kanak lelaki berusia 0-4 tahun musim panas bayi lelaki dicetak kemeja daun T-shirt + seluar pendek 2 set', 128.20, 'https://cf.shopee.com.my/file/1959c60679c0377e336c309014bbb2a3', 1627909663, 1, 1);
INSERT INTO `xy_goods_list` VALUES (911, 'Etude House 0.2mm Therapy Air Mask 20ml', 'Etude House 0.2mm Therapy Air Mask 20ml', 'Etude House 0.2mm Therapy Air Mask 20ml', 23.00, 'https://cf.shopee.com.my/file/84daee2733cc97cddde13081387f4eb4', 1627909663, 1, 1);
INSERT INTO `xy_goods_list` VALUES (912, 'RESTOCK 23-2-2021 (0-1month) !!! ** Baby Hat Boy Girl Cap Newborn Topi Mitten Booties', 'RESTOCK 23-2-2021 (0-1month) !!! ** Baby Hat Boy Girl Cap Newborn Topi Mitten Booties', 'RESTOCK 23-2-2021 (0-1month) !!! ** Baby Hat Boy Girl Cap Newborn Topi Mitten Booties', 18.60, 'https://cf.shopee.com.my/file/128e8dc6063e168b77be6bcfeab15e2f', 1627909663, 1, 1);
INSERT INTO `xy_goods_list` VALUES (913, 'Global Version Xiaomi Mi TV Stick / Mi Box S Android 9.0 + Chromecast + Google Assistant - Quad-Core Dolby DTA HD', 'Global Version Xiaomi Mi TV Stick / Mi Box S Android 9.0 + Chromecast + Google Assistant - Quad-Core Dolby DTA HD', 'Global Version Xiaomi Mi TV Stick / Mi Box S Android 9.0 + Chromecast + Google Assistant - Quad-Core Dolby DTA HD', 1590.00, 'https://cf.shopee.com.my/file/5cc0b9e1b85d88e17d819876b73a0f58', 1627909663, 1, 1);
INSERT INTO `xy_goods_list` VALUES (914, 'Mechanical Pencil - STABILO COM4 Blue/Pink 0.5mm or 0.7mm Blister Card', 'Mechanical Pencil - STABILO COM4 Blue/Pink 0.5mm or 0.7mm Blister Card', 'Mechanical Pencil - STABILO COM4 Blue/Pink 0.5mm or 0.7mm Blister Card', 42.80, 'https://cf.shopee.com.my/file/c7f1b29117c503574428c363e192e4b9', 1627909663, 1, 1);
INSERT INTO `xy_goods_list` VALUES (915, 'WAVE125 ALLOY BLOCK GASKET spacer 0.8mm 1mm 1.5mm 2mm 2.5mm 3mm 4mm 5mm 6mm 7mm 8m 10mm ASHUKA', 'WAVE125 ALLOY BLOCK GASKET spacer 0.8mm 1mm 1.5mm 2mm 2.5mm 3mm 4mm 5mm 6mm 7mm 8m 10mm ASHUKA', 'WAVE125 ALLOY BLOCK GASKET spacer 0.8mm 1mm 1.5mm 2mm 2.5mm 3mm 4mm 5mm 6mm 7mm 8m 10mm ASHUKA', 68.00, 'https://cf.shopee.com.my/file/152c9d51aebbd547805de94dcea93157', 1627909663, 1, 1);
INSERT INTO `xy_goods_list` VALUES (916, '3D 4K 8K HD UHD HDMI Cable v2.0/ v2.1 Gold Plate Head 1.5 /3/ 5 /10 /15 Meter', '3D 4K 8K HD UHD HDMI Cable v2.0/ v2.1 Gold Plate Head 1.5 /3/ 5 /10 /15 Meter', '3D 4K 8K HD UHD HDMI Cable v2.0/ v2.1 Gold Plate Head 1.5 /3/ 5 /10 /15 Meter', 219.00, 'https://cf.shopee.com.my/file/1c3f4703caac14658cfe5bd5a9a93878', 1627909663, 1, 1);
INSERT INTO `xy_goods_list` VALUES (917, 'Lucky Big Cat  Newborn underwear cotton animal print triangle pants baby girls bread pants shorts diapers 0-3 years', 'Lucky Big Cat  Newborn underwear cotton animal print triangle pants baby girls bread pants shorts diapers 0-3 years', 'Lucky Big Cat  Newborn underwear cotton animal print triangle pants baby girls bread pants shorts diapers 0-3 years', 45.80, 'https://cf.shopee.com.my/file/d121aac9810c24b4ed0faae79a6604b3', 1627909663, 1, 1);
INSERT INTO `xy_goods_list` VALUES (918, 'M&G G-5i GEL PEN REFILL 0.5  R3 /Changli U-8 Gel Ink Pen Refill 0.5mm (Price for 1pc)', 'M&G G-5i GEL PEN REFILL 0.5  R3 /Changli U-8 Gel Ink Pen Refill 0.5mm (Price for 1pc)', 'M&G G-5i GEL PEN REFILL 0.5  R3 /Changli U-8 Gel Ink Pen Refill 0.5mm (Price for 1pc)', 5.60, 'https://cf.shopee.com.my/file/57c9159b696f09a4c464e4d6858fdeb7', 1627909663, 1, 1);
INSERT INTO `xy_goods_list` VALUES (919, '(Ready Stock Malaysia) Baby Toddler Sneakers Shoes Boys & Girls 0-18M', '(Ready Stock Malaysia) Baby Toddler Sneakers Shoes Boys & Girls 0-18M', '(Ready Stock Malaysia) Baby Toddler Sneakers Shoes Boys & Girls 0-18M', 109.90, 'https://cf.shopee.com.my/file/faee123a7aaaa6e7c0f4b1dc59876735', 1627909663, 1, 1);
INSERT INTO `xy_goods_list` VALUES (920, 'Bead love emas 999 tulen comel (sesuai hanya utk rantai lebar 0.1cm saja', 'Bead love emas 999 tulen comel (sesuai hanya utk rantai lebar 0.1cm saja', 'Bead love emas 999 tulen comel (sesuai hanya utk rantai lebar 0.1cm saja', 590.00, 'https://cf.shopee.com.my/file/61cc2b5fb8bb0fba31614d27db201a60', 1627909663, 1, 1);
INSERT INTO `xy_goods_list` VALUES (921, 'Bubble Wrap Murah [1m x 1m]  &  [0.5m x 1m] With High Quality', 'Bubble Wrap Murah [1m x 1m]  &  [0.5m x 1m] With High Quality', 'Bubble Wrap Murah [1m x 1m]  &  [0.5m x 1m] With High Quality', 5.80, 'https://cf.shopee.com.my/file/88be24e592631a6a9c1fb0bbbff40a4c', 1627909663, 1, 1);
INSERT INTO `xy_goods_list` VALUES (922, 'Original Aspire Cloudflask OCC Coil 0.25ohm / Replacement Cartridge', 'Original Aspire Cloudflask OCC Coil 0.25ohm / Replacement Cartridge', 'Original Aspire Cloudflask OCC Coil 0.25ohm / Replacement Cartridge', 170.00, 'https://cf.shopee.com.my/file/92bdbc9b7773b25504d5de40e2ad5f10', 1627909663, 1, 1);
INSERT INTO `xy_goods_list` VALUES (923, 'Matt Satin Bidang 60 Kain Langsir  READY STOCK  | Matte Sateen Part 1 (0.5m/unit)', 'Matt Satin Bidang 60 Kain Langsir  READY STOCK  | Matte Sateen Part 1 (0.5m/unit)', 'Matt Satin Bidang 60 Kain Langsir  READY STOCK  | Matte Sateen Part 1 (0.5m/unit)', 34.60, 'https://cf.shopee.com.my/file/f03bfd8c688b39d2786755ffc0295d47', 1627909663, 1, 1);
INSERT INTO `xy_goods_list` VALUES (924, '[Office Matters] Dual Tip 0.5/1 Mm Fast Dry Permanent Sign Marker Pens for Fabric Metal Quality Fineliner', '[Office Matters] Dual Tip 0.5/1 Mm Fast Dry Permanent Sign Marker Pens for Fabric Metal Quality Fineliner', '[Office Matters] Dual Tip 0.5/1 Mm Fast Dry Permanent Sign Marker Pens for Fabric Metal Quality Fineliner', 5.50, 'https://cf.shopee.com.my/file/0698c43248f75eba3d31d5570eaf1309', 1627909663, 1, 1);
INSERT INTO `xy_goods_list` VALUES (925, '(0.05sen/Page) Double Sided - Printing Service | A4 A5 Black & White | Print | Photocopy | Fotostat | Book Printing', '(0.05sen/Page) Double Sided - Printing Service | A4 A5 Black & White | Print | Photocopy | Fotostat | Book Printing', '(0.05sen/Page) Double Sided - Printing Service | A4 A5 Black & White | Print | Photocopy | Fotostat | Book Printing', 1.00, 'https://cf.shopee.com.my/file/c5c73feb322a516410daaa76c3011799', 1627909663, 1, 1);
INSERT INTO `xy_goods_list` VALUES (926, 'DAIWA 8 Braided Fishing Line - Length:300m/330yds, Diameter:0.1-0.42mm,size:14-100lb Japan PE braided line J-Braid Line', 'DAIWA 8 Braided Fishing Line - Length:300m/330yds, Diameter:0.1-0.42mm,size:14-100lb Japan PE braided line J-Braid Line', 'DAIWA 8 Braided Fishing Line - Length:300m/330yds, Diameter:0.1-0.42mm,size:14-100lb Japan PE braided line J-Braid Line', 660.00, 'https://cf.shopee.com.my/file/e88d374e624f016b699f89a08f004c12', 1627909664, 1, 1);
INSERT INTO `xy_goods_list` VALUES (927, 'Baby Boys 2Pcs/set  Lapel Short Sleeve Top+Denim Shorts Jeans 0-5Y(Yi Pai)', 'Baby Boys 2Pcs/set  Lapel Short Sleeve Top+Denim Shorts Jeans 0-5Y(Yi Pai)', 'Baby Boys 2Pcs/set  Lapel Short Sleeve Top+Denim Shorts Jeans 0-5Y(Yi Pai)', 108.10, 'https://cf.shopee.com.my/file/d065f26535ed8c6c070c4d190c97e49f', 1627909664, 1, 1);
INSERT INTO `xy_goods_list` VALUES (928, 'Kamu Automatic Self-Priming Peripheral Water Pump | KA-370 & KAC-370 | Home Water Booster Pump | 0.5HP', 'Kamu Automatic Self-Priming Peripheral Water Pump | KA-370 & KAC-370 | Home Water Booster Pump | 0.5HP', 'Kamu Automatic Self-Priming Peripheral Water Pump | KA-370 & KAC-370 | Home Water Booster Pump | 0.5HP', 1499.00, 'https://cf.shopee.com.my/file/15d265c1fccbeb7f9ff9074be1fb775d', 1627909664, 1, 1);
INSERT INTO `xy_goods_list` VALUES (929, 'KKC ROYALE 5KAKI TEBAL 0.4MM TIKAR GETAH PVC (BUATAN MALAYSIA) BRAND FLORICA /READY STOK 1 DAY SHIP OUT/LOCAL SELLER', 'KKC ROYALE 5KAKI TEBAL 0.4MM TIKAR GETAH PVC (BUATAN MALAYSIA) BRAND FLORICA /READY STOK 1 DAY SHIP OUT/LOCAL SELLER', 'KKC ROYALE 5KAKI TEBAL 0.4MM TIKAR GETAH PVC (BUATAN MALAYSIA) BRAND FLORICA /READY STOK 1 DAY SHIP OUT/LOCAL SELLER', 34.50, 'https://cf.shopee.com.my/file/b18a594965e0998ebb25add5ed141f30', 1627909664, 1, 1);
INSERT INTO `xy_goods_list` VALUES (930, 'LOOSE CUT 40/0.16MM X 3C 100% Pure Full Copper 3 Core Flexible Wire Cable PVC Insulated Sheathed Made in Malaysia 40/016', 'LOOSE CUT 40/0.16MM X 3C 100% Pure Full Copper 3 Core Flexible Wire Cable PVC Insulated Sheathed Made in Malaysia 40/016', 'LOOSE CUT 40/0.16MM X 3C 100% Pure Full Copper 3 Core Flexible Wire Cable PVC Insulated Sheathed Made in Malaysia 40/016', 17.50, 'https://cf.shopee.com.my/file/f2b8ad2b12d97eafbbb2972432f9b6a8', 1627909664, 1, 1);
INSERT INTO `xy_goods_list` VALUES (931, 'Montessori Toys Toddler Early Learning Do-A-Dot Number 0 to 10 Sticker Activity Buku Latihan Prasekolah ABC 123', 'Montessori Toys Toddler Early Learning Do-A-Dot Number 0 to 10 Sticker Activity Buku Latihan Prasekolah ABC 123', 'Montessori Toys Toddler Early Learning Do-A-Dot Number 0 to 10 Sticker Activity Buku Latihan Prasekolah ABC 123', 213.70, 'https://cf.shopee.com.my/file/ab280d0f95b60c3adff1418860850575', 1627909664, 1, 1);
INSERT INTO `xy_goods_list` VALUES (933, '[0.04/pg] Printing services A4 B/W_Ebook_Textbook_Coursebook_books', '[0.04/pg] Printing services A4 B/W_Ebook_Textbook_Coursebook_books', '[0.04/pg] Printing services A4 B/W_Ebook_Textbook_Coursebook_books', 1.00, 'https://cf.shopee.com.my/file/89f720478279a0722ccec0397e48f5af', 1627909664, 1, 1);
INSERT INTO `xy_goods_list` VALUES (935, 'M&G Blue Gel Pen 0.5MM-0318', 'M&G Blue Gel Pen 0.5MM-0318', 'M&G Blue Gel Pen 0.5MM-0318', 21.00, 'https://cf.shopee.com.my/file/f736fffa3fc74c51bb62debdcb52de1f', 1627909664, 1, 1);
INSERT INTO `xy_goods_list` VALUES (936, 'ORIGINAL FEELIN POD KIT / OCC NEVOKS SOL 10 REPLACEMENT COIL/0.6ohm /1.0ohm', 'ORIGINAL FEELIN POD KIT / OCC NEVOKS SOL 10 REPLACEMENT COIL/0.6ohm /1.0ohm', 'ORIGINAL FEELIN POD KIT / OCC NEVOKS SOL 10 REPLACEMENT COIL/0.6ohm /1.0ohm', 95.00, 'https://cf.shopee.com.my/file/883748edb96499541483b2d7a4219540', 1627909664, 1, 1);
INSERT INTO `xy_goods_list` VALUES (938, '3M SUPER STRONG TAPE / water proof / heavy duty / outdoor / vehicle tape/ foam tape / double sided tape 0.1x1CM', '3M SUPER STRONG TAPE / water proof / heavy duty / outdoor / vehicle tape/ foam tape / double sided tape 0.1x1CM', '3M SUPER STRONG TAPE / water proof / heavy duty / outdoor / vehicle tape/ foam tape / double sided tape 0.1x1CM', 20.00, 'https://cf.shopee.com.my/file/4c4f61d63b13facada838f2d1a761993', 1627909664, 1, 1);
INSERT INTO `xy_goods_list` VALUES (939, 'Deli Retractable Ball Point Pen Dry Fast 0.7mm [Per Pen] 6546', 'Deli Retractable Ball Point Pen Dry Fast 0.7mm [Per Pen] 6546', 'Deli Retractable Ball Point Pen Dry Fast 0.7mm [Per Pen] 6546', 3.20, 'https://cf.shopee.com.my/file/19914a342d3e2b745e55a161d65cf035', 1627909664, 1, 1);
INSERT INTO `xy_goods_list` VALUES (940, 'RIK LC135/Y15 Racing piston ring 57,62,63,65,66,68mm @SIZE RING 0.8X0.8X1.5MM@', 'RIK LC135/Y15 Racing piston ring 57,62,63,65,66,68mm @SIZE RING 0.8X0.8X1.5MM@', 'RIK LC135/Y15 Racing piston ring 57,62,63,65,66,68mm @SIZE RING 0.8X0.8X1.5MM@', 180.00, 'https://cf.shopee.com.my/file/407e1bb09df18eb0c0c494b46e1fcb78', 1627909664, 1, 1);
INSERT INTO `xy_goods_list` VALUES (942, 'Artline Drawing System Pen / Technical Drawing Pen Ek  (Black) 0.05 , 0.1 , 0.2 , 0.3 , 0.4 , 0.5 , 0.6 , 0.7 , 0.8', 'Artline Drawing System Pen / Technical Drawing Pen Ek  (Black) 0.05 , 0.1 , 0.2 , 0.3 , 0.4 , 0.5 , 0.6 , 0.7 , 0.8', 'Artline Drawing System Pen / Technical Drawing Pen Ek  (Black) 0.05 , 0.1 , 0.2 , 0.3 , 0.4 , 0.5 , 0.6 , 0.7 , 0.8', 40.00, 'https://cf.shopee.com.my/file/8ce43fccee2daf1a64d255826c755acb', 1627909664, 1, 1);
INSERT INTO `xy_goods_list` VALUES (943, 'Lucky Big Cat  Fashion Cotton Girls Briefs Baby Underwear Kids Briefs Shorts Panties Children\'s Clothes 0-3Y Panty panties', 'Lucky Big Cat  Fashion Cotton Girls Briefs Baby Underwear Kids Briefs Shorts Panties Children\'s Clothes 0-3Y Panty panties', 'Lucky Big Cat  Fashion Cotton Girls Briefs Baby Underwear Kids Briefs Shorts Panties Children\'s Clothes 0-3Y Panty panties', 42.80, 'https://cf.shopee.com.my/file/498cc3c00dadc041340d96838736c3a9', 1627909664, 1, 1);
INSERT INTO `xy_goods_list` VALUES (944, 'NIKKI\'S SHOP 0.5mm Black Ink Gel Pen-1pcs', 'NIKKI\'S SHOP 0.5mm Black Ink Gel Pen-1pcs', 'NIKKI\'S SHOP 0.5mm Black Ink Gel Pen-1pcs', 4.90, 'https://cf.shopee.com.my/file/7342b0ee9561084f6dc775e3d27bfef1', 1627909664, 1, 1);
INSERT INTO `xy_goods_list` VALUES (945, 'Oxymecx - Medical Dressing Set, 3-Forceps/ 1-Forcep / 0-Forcep', 'Oxymecx - Medical Dressing Set, 3-Forceps/ 1-Forcep / 0-Forcep', 'Oxymecx - Medical Dressing Set, 3-Forceps/ 1-Forcep / 0-Forcep', 12.90, 'https://cf.shopee.com.my/file/859779501afb4cabb363d195a6d81ccf', 1627909664, 1, 1);
INSERT INTO `xy_goods_list` VALUES (946, '(50PCS)UTS SUPER HEAVY DUTY J-PIKE Jigging Hook 1#;2#;1/0;2/0;3/0;3.5/0;4/0;5/0 *FLAT Type only', '(50PCS)UTS SUPER HEAVY DUTY J-PIKE Jigging Hook 1#;2#;1/0;2/0;3/0;3.5/0;4/0;5/0 *FLAT Type only', '(50PCS)UTS SUPER HEAVY DUTY J-PIKE Jigging Hook 1#;2#;1/0;2/0;3/0;3.5/0;4/0;5/0 *FLAT Type only', 200.00, 'https://cf.shopee.com.my/file/f0101302fb29d50f6827babaff36c78d', 1627909664, 1, 1);
INSERT INTO `xy_goods_list` VALUES (947, '100% Original Smok Nfix Replacement Cartridge 0.8 Ohm Mesh / MTL', '100% Original Smok Nfix Replacement Cartridge 0.8 Ohm Mesh / MTL', '100% Original Smok Nfix Replacement Cartridge 0.8 Ohm Mesh / MTL', 220.00, 'https://cf.shopee.com.my/file/1bd126125c1c2ac036927d53b10dcca3', 1627909664, 1, 1);
INSERT INTO `xy_goods_list` VALUES (948, 'Novel: KAMPUNG GIRL | Penulis: Umi Kalsom | Penerbit: Karyaseni | ISBN: 978-967-0246-13-0', 'Novel: KAMPUNG GIRL | Penulis: Umi Kalsom | Penerbit: Karyaseni | ISBN: 978-967-0246-13-0', 'Novel: KAMPUNG GIRL | Penulis: Umi Kalsom | Penerbit: Karyaseni | ISBN: 978-967-0246-13-0', 80.00, 'https://cf.shopee.com.my/file/ae0564a451cbb91ab84f182a0622329a', 1627909664, 1, 1);
INSERT INTO `xy_goods_list` VALUES (949, '1pc Kawaii Animal Pen unicorn Cute Cartoon Gel Pen 0.38mm Black Office School Writing tools', '1pc Kawaii Animal Pen unicorn Cute Cartoon Gel Pen 0.38mm Black Office School Writing tools', '1pc Kawaii Animal Pen unicorn Cute Cartoon Gel Pen 0.38mm Black Office School Writing tools', 6.00, 'https://cf.shopee.com.my/file/e57c21764f005a4bed0d56293aa92f9b', 1627909664, 1, 1);
INSERT INTO `xy_goods_list` VALUES (950, 'DIYMORE R130 Motor Type 130 Hobby Micro Motors 3-6V DC 0.35-0.4A 8000 RPM Mini motor', 'DIYMORE R130 Motor Type 130 Hobby Micro Motors 3-6V DC 0.35-0.4A 8000 RPM Mini motor', 'DIYMORE R130 Motor Type 130 Hobby Micro Motors 3-6V DC 0.35-0.4A 8000 RPM Mini motor', 20.90, 'https://cf.shopee.com.my/file/a64fba9ecbc659ab3a79afed59a722e0', 1627909664, 1, 1);
INSERT INTO `xy_goods_list` VALUES (952, 'Faber Castell Click X Ball Pen X5 0.5mm / X7 0.7mm 1422 / Faber-Castell Click X7', 'Faber Castell Click X Ball Pen X5 0.5mm / X7 0.7mm 1422 / Faber-Castell Click X7', 'Faber Castell Click X Ball Pen X5 0.5mm / X7 0.7mm 1422 / Faber-Castell Click X7', 6.00, 'https://cf.shopee.com.my/file/6359d854738c1f9378c7fb4f693e478e', 1627909664, 1, 1);
INSERT INTO `xy_goods_list` VALUES (953, 'Curtain Tape / Tape Langsir / Pita Langsir (0.5m / 1m)', 'Curtain Tape / Tape Langsir / Pita Langsir (0.5m / 1m)', 'Curtain Tape / Tape Langsir / Pita Langsir (0.5m / 1m)', 2.80, 'https://cf.shopee.com.my/file/5b2f4782f27c57fbfe5647c59a6147f7', 1627909664, 1, 1);
INSERT INTO `xy_goods_list` VALUES (954, 'ACM Number Plate Sticker JPJ Approve Size Motor Moto Motorcycle Motosikal Nombor Plat 1 2 3 4 5 6 7 8 9 0 Putih White', 'ACM Number Plate Sticker JPJ Approve Size Motor Moto Motorcycle Motosikal Nombor Plat 1 2 3 4 5 6 7 8 9 0 Putih White', 'ACM Number Plate Sticker JPJ Approve Size Motor Moto Motorcycle Motosikal Nombor Plat 1 2 3 4 5 6 7 8 9 0 Putih White', 3.50, 'https://cf.shopee.com.my/file/0fbdff907065b2188104e6130cd72d31', 1627909664, 1, 1);
INSERT INTO `xy_goods_list` VALUES (955, 'G\'soft WX1 0.4mm Writemate Retractable Semi Gel Ink Ball Pen gsoft BP-GS-WX1', 'G\'soft WX1 0.4mm Writemate Retractable Semi Gel Ink Ball Pen gsoft BP-GS-WX1', 'G\'soft WX1 0.4mm Writemate Retractable Semi Gel Ink Ball Pen gsoft BP-GS-WX1', 7.50, 'https://cf.shopee.com.my/file/022020700082757a2552bbd1e660ad15', 1627909664, 1, 1);
INSERT INTO `xy_goods_list` VALUES (956, '50V Electrolytic Capacitors 0.1uF - 220uF', '50V Electrolytic Capacitors 0.1uF - 220uF', '50V Electrolytic Capacitors 0.1uF - 220uF', 1.90, 'https://cf.shopee.com.my/file/0ea1f88998d2eb78577a4fb1dcdd20bb', 1627909664, 1, 1);
INSERT INTO `xy_goods_list` VALUES (957, 'WHOLESALE | 3D 4K HD UHD 1.5M Male to Male HDMI Cable v2.0 High Speed 1.5 meters for TVBOX MYTV ASTRO', 'WHOLESALE | 3D 4K HD UHD 1.5M Male to Male HDMI Cable v2.0 High Speed 1.5 meters for TVBOX MYTV ASTRO', 'WHOLESALE | 3D 4K HD UHD 1.5M Male to Male HDMI Cable v2.0 High Speed 1.5 meters for TVBOX MYTV ASTRO', 21.80, 'https://cf.shopee.com.my/file/1e95e81e89eddf70dbac2916b95d3fe5', 1627909664, 1, 1);
INSERT INTO `xy_goods_list` VALUES (959, 'Mig Co2 Contact Tip 0.8mm 1.0mm 1.2mm Mig Welding Torch (1 piece)', 'Mig Co2 Contact Tip 0.8mm 1.0mm 1.2mm Mig Welding Torch (1 piece)', 'Mig Co2 Contact Tip 0.8mm 1.0mm 1.2mm Mig Welding Torch (1 piece)', 6.00, 'https://cf.shopee.com.my/file/809ee1b1e9775ef33ef13c3899d3f903', 1627909664, 1, 1);
INSERT INTO `xy_goods_list` VALUES (960, 'Zhi Xin Lovein Test Good G-2501 Gel Pen 0.5mm - (1\'s)', 'Zhi Xin Lovein Test Good G-2501 Gel Pen 0.5mm - (1\'s)', 'Zhi Xin Lovein Test Good G-2501 Gel Pen 0.5mm - (1\'s)', 12.00, 'https://cf.shopee.com.my/file/d3197e5f763645b5dddd062af8e82102', 1627909664, 1, 1);
INSERT INTO `xy_goods_list` VALUES (961, '[FAST SELLING] +-0.8g Benih DAUN SUP celery seeds (REPACKED) . boleh semai dalam pasu. guna untuk masak sup', '[FAST SELLING] +-0.8g Benih DAUN SUP celery seeds (REPACKED) . boleh semai dalam pasu. guna untuk masak sup', '[FAST SELLING] +-0.8g Benih DAUN SUP celery seeds (REPACKED) . boleh semai dalam pasu. guna untuk masak sup', 9.80, 'https://cf.shopee.com.my/file/f5707210dad8021f74bf044f5143c69e', 1627909664, 1, 1);
INSERT INTO `xy_goods_list` VALUES (962, 'NEVOKS FEELIN 0.6/0.8/1.0 MESH COIL (5PCS/BOX)', 'NEVOKS FEELIN 0.6/0.8/1.0 MESH COIL (5PCS/BOX)', 'NEVOKS FEELIN 0.6/0.8/1.0 MESH COIL (5PCS/BOX)', 450.00, 'https://cf.shopee.com.my/file/d3d26ca2718a4e7b064ecd4e10b00a83', 1627909664, 1, 1);
INSERT INTO `xy_goods_list` VALUES (963, 'Faber-Castell Click X5 / Click X7 0.5mm / 0.7mm Retractable Ball Pen', 'Faber-Castell Click X5 / Click X7 0.5mm / 0.7mm Retractable Ball Pen', 'Faber-Castell Click X5 / Click X7 0.5mm / 0.7mm Retractable Ball Pen', 6.30, 'https://cf.shopee.com.my/file/7aa8f68161db97c0361c60408760f70c', 1627909664, 1, 1);
INSERT INTO `xy_goods_list` VALUES (964, 'I.Fairy Love Maze Power 0-10.00 Korean Color Contact Lens', 'I.Fairy Love Maze Power 0-10.00 Korean Color Contact Lens', 'I.Fairy Love Maze Power 0-10.00 Korean Color Contact Lens', 98.70, 'https://cf.shopee.com.my/file/d16cfeeed3f0cc3bdf49808e6fe53b69', 1627909664, 1, 1);
INSERT INTO `xy_goods_list` VALUES (965, '0.5mm Gel Pen Refill Black Red Blue Gel Pen Students Writing Refill School Office Stationery', '0.5mm Gel Pen Refill Black Red Blue Gel Pen Students Writing Refill School Office Stationery', '0.5mm Gel Pen Refill Black Red Blue Gel Pen Students Writing Refill School Office Stationery', 1.50, 'https://cf.shopee.com.my/file/a56aaf100ac7d6135bd82ad4a9ef15b3', 1627909664, 1, 1);
INSERT INTO `xy_goods_list` VALUES (966, '(1PCS) UTS ZERO Jigging Hook/Micro Jig HOOK 10/12/14/161/0; 2/0; 3/0*Flat Type', '(1PCS) UTS ZERO Jigging Hook/Micro Jig HOOK 10/12/14/161/0; 2/0; 3/0*Flat Type', '(1PCS) UTS ZERO Jigging Hook/Micro Jig HOOK 10/12/14/161/0; 2/0; 3/0*Flat Type', 4.50, 'https://cf.shopee.com.my/file/fe447c9adaf6f2834cb648a4aa4849eb', 1627909664, 1, 1);
INSERT INTO `xy_goods_list` VALUES (967, 'Midea 1.2L Blender MBL-25 (GREEN / PINK) MBL-25PK / MBL-25GN  (0.4L Grinder Cup)', 'Midea 1.2L Blender MBL-25 (GREEN / PINK) MBL-25PK / MBL-25GN  (0.4L Grinder Cup)', 'Midea 1.2L Blender MBL-25 (GREEN / PINK) MBL-25PK / MBL-25GN  (0.4L Grinder Cup)', 650.00, 'https://cf.shopee.com.my/file/ce3db2d454065e8d1556a7622d948733', 1627909664, 1, 1);
INSERT INTO `xy_goods_list` VALUES (968, 'L Type 0.6-1.5mm Tooth Brush Orthodontic\nBrush Angled Interdental Brushes', 'L Type 0.6-1.5mm Tooth Brush Orthodontic\nBrush Angled Interdental Brushes', 'L Type 0.6-1.5mm Tooth Brush Orthodontic\nBrush Angled Interdental Brushes', 48.10, 'https://cf.shopee.com.my/file/ca6feb9e24f370e0b1738da1863b246d', 1627909664, 1, 1);
INSERT INTO `xy_goods_list` VALUES (969, 'HT Socket Cap Screw - M5 x 6mm ~ 30mm (Coarse Thread Pitch 0.8mm) (High Tensile Grade 12.9 Allen Cap Bolt)', 'HT Socket Cap Screw - M5 x 6mm ~ 30mm (Coarse Thread Pitch 0.8mm) (High Tensile Grade 12.9 Allen Cap Bolt)', 'HT Socket Cap Screw - M5 x 6mm ~ 30mm (Coarse Thread Pitch 0.8mm) (High Tensile Grade 12.9 Allen Cap Bolt)', 2.00, 'https://cf.shopee.com.my/file/24aa1b18d51e9add1f5ad5916142b3a0', 1627909664, 1, 1);
INSERT INTO `xy_goods_list` VALUES (971, 'Loose Meter - Flexible Cable 40/0.76 x 3 Core [100% Pure Copper) Flex Cord Wire 1.25mm 3C FULL Copper as FAJAR', 'Loose Meter - Flexible Cable 40/0.76 x 3 Core [100% Pure Copper) Flex Cord Wire 1.25mm 3C FULL Copper as FAJAR', 'Loose Meter - Flexible Cable 40/0.76 x 3 Core [100% Pure Copper) Flex Cord Wire 1.25mm 3C FULL Copper as FAJAR', 20.00, 'https://cf.shopee.com.my/file/7cf90fdd3ca61f32a02a9330e26dbb1d', 1627909664, 1, 1);
INSERT INTO `xy_goods_list` VALUES (973, '(0.05sen/Page) BEST PRINTING SERVICE A4 - Photocopy, Binding, Stapler Tape, notes printing, e-book, book', '(0.05sen/Page) BEST PRINTING SERVICE A4 - Photocopy, Binding, Stapler Tape, notes printing, e-book, book', '(0.05sen/Page) BEST PRINTING SERVICE A4 - Photocopy, Binding, Stapler Tape, notes printing, e-book, book', 1.00, 'https://cf.shopee.com.my/file/70fb7ff0fd7ada3dedc8c0c3976321c6', 1627909664, 1, 1);
INSERT INTO `xy_goods_list` VALUES (974, 'Cable Protector 0.5M Cable Wrapper Iphone Samsung per pc solid', 'Cable Protector 0.5M Cable Wrapper Iphone Samsung per pc solid', 'Cable Protector 0.5M Cable Wrapper Iphone Samsung per pc solid', 10.00, 'https://cf.shopee.com.my/file/91f298ed00e91c6a3e129bc4c25b5a9c', 1627909664, 1, 1);
INSERT INTO `xy_goods_list` VALUES (975, 'Faber Castell Click X Ball Pen X5 0.5mm 1425 / X7 0.7mm 1422 / Faber-Castell Click X7 (Pena Mata Bulat)', 'Faber Castell Click X Ball Pen X5 0.5mm 1425 / X7 0.7mm 1422 / Faber-Castell Click X7 (Pena Mata Bulat)', 'Faber Castell Click X Ball Pen X5 0.5mm 1425 / X7 0.7mm 1422 / Faber-Castell Click X7 (Pena Mata Bulat)', 5.90, 'https://cf.shopee.com.my/file/4ae9065a07a55a112687f4db0b78d544', 1627909664, 1, 1);
INSERT INTO `xy_goods_list` VALUES (976, 'HARRIS Copper Brazing Alloy Rod / Welding Rod 0% Silver Phos Copper Rod for Brazing Soldering Welding Mapp Gas', 'HARRIS Copper Brazing Alloy Rod / Welding Rod 0% Silver Phos Copper Rod for Brazing Soldering Welding Mapp Gas', 'HARRIS Copper Brazing Alloy Rod / Welding Rod 0% Silver Phos Copper Rod for Brazing Soldering Welding Mapp Gas', 22.00, 'https://cf.shopee.com.my/file/18fe10ba436fd83ef5c5e2e9094d146a', 1627909664, 1, 1);
INSERT INTO `xy_goods_list` VALUES (977, '0.5Kg Firebeater Auto Fire Extinguisher Portable Car Home', '0.5Kg Firebeater Auto Fire Extinguisher Portable Car Home', '0.5Kg Firebeater Auto Fire Extinguisher Portable Car Home', 101.00, 'https://cf.shopee.com.my/file/f4bdd8503b0d3995667e80f08b5c1ec0', 1627909664, 1, 1);
INSERT INTO `xy_goods_list` VALUES (978, 'Buncho Hi-Polymer Pencil Lead 0.5mm x 70mm 2B', 'Buncho Hi-Polymer Pencil Lead 0.5mm x 70mm 2B', 'Buncho Hi-Polymer Pencil Lead 0.5mm x 70mm 2B', 7.00, 'https://cf.shopee.com.my/file/2931a3ed04baf95af45b80b18c0281d2', 1627909664, 1, 1);
INSERT INTO `xy_goods_list` VALUES (980, 'Big Size (70cm*30cm*0.2cm) Pro Gaming World Map Mouse Pad Mousepad for Dota LOL', 'Big Size (70cm*30cm*0.2cm) Pro Gaming World Map Mouse Pad Mousepad for Dota LOL', 'Big Size (70cm*30cm*0.2cm) Pro Gaming World Map Mouse Pad Mousepad for Dota LOL', 70.00, 'https://cf.shopee.com.my/file/5ed399115c67d00fefa13683d9c8f519', 1627909664, 1, 1);
INSERT INTO `xy_goods_list` VALUES (981, 'Cute cartoon tail cat 0.5mm Ball Point Black For School Office Supplies', 'Cute cartoon tail cat 0.5mm Ball Point Black For School Office Supplies', 'Cute cartoon tail cat 0.5mm Ball Point Black For School Office Supplies', 4.40, 'https://cf.shopee.com.my/file/18521ba48ada171a0d3f90828b075d08', 1627909664, 1, 1);
INSERT INTO `xy_goods_list` VALUES (983, '0.2ml~10ml Disposable Pipette Plastic Pasteur Dropper For Lab', '0.2ml~10ml Disposable Pipette Plastic Pasteur Dropper For Lab', '0.2ml~10ml Disposable Pipette Plastic Pasteur Dropper For Lab', 2.20, 'https://cf.shopee.com.my/file/381f350ae07d5354f21261f579f58a1f', 1627909664, 1, 1);
INSERT INTO `xy_goods_list` VALUES (984, '(0.00 to 500)(1 piece)freshkon fusion daily color shimering grey (loose pack)', '(0.00 to 500)(1 piece)freshkon fusion daily color shimering grey (loose pack)', '(0.00 to 500)(1 piece)freshkon fusion daily color shimering grey (loose pack)', 20.50, 'https://cf.shopee.com.my/file/430dcdfe14b7065499b0290794ba071b', 1627909664, 1, 1);
INSERT INTO `xy_goods_list` VALUES (985, 'LOOSE CUT 23/0.16MM x 3C 100% Pure Full Copper 3 Core Flexible Wire Cable PVC Insulated Sheathed Made in Malaysia 23/016', 'LOOSE CUT 23/0.16MM x 3C 100% Pure Full Copper 3 Core Flexible Wire Cable PVC Insulated Sheathed Made in Malaysia 23/016', 'LOOSE CUT 23/0.16MM x 3C 100% Pure Full Copper 3 Core Flexible Wire Cable PVC Insulated Sheathed Made in Malaysia 23/016', 10.90, 'https://cf.shopee.com.my/file/8bc0252eb6853d1eb5cce9aba4f37540', 1627909664, 1, 1);
INSERT INTO `xy_goods_list` VALUES (986, 'G\'Soft Shake-shake Mechanical Pencil Sets 0.5mm - 1130', 'G\'Soft Shake-shake Mechanical Pencil Sets 0.5mm - 1130', 'G\'Soft Shake-shake Mechanical Pencil Sets 0.5mm - 1130', 21.00, 'https://cf.shopee.com.my/file/fb487313607499cf91fb82f2b9b2e2d1', 1627909664, 1, 1);
INSERT INTO `xy_goods_list` VALUES (987, 'BD 3ml Slip Tip Syringe With Needle 23G 1 1/4 TW (0.6mm x 32mm)', 'BD 3ml Slip Tip Syringe With Needle 23G 1 1/4 TW (0.6mm x 32mm)', 'BD 3ml Slip Tip Syringe With Needle 23G 1 1/4 TW (0.6mm x 32mm)', 10.00, 'https://cf.shopee.com.my/file/ceb1ef3e0b833f2f22e375dffb6166bf', 1627909664, 1, 1);
INSERT INTO `xy_goods_list` VALUES (988, 'Rm 0.19 lomo , 3r , 4r photo printing', 'Rm 0.19 lomo , 3r , 4r photo printing', 'Rm 0.19 lomo , 3r , 4r photo printing', 1.90, 'https://cf.shopee.com.my/file/ef0fae435a19a9f8c3a502a7c2800062', 1627909664, 1, 1);
INSERT INTO `xy_goods_list` VALUES (989, 'Original Smok Nord/Trinity Alpha 5pcs Occ Regular / Mesh / Ceramic / 0.6 / 0.8 / 1.4Ohm Coil', 'Original Smok Nord/Trinity Alpha 5pcs Occ Regular / Mesh / Ceramic / 0.6 / 0.8 / 1.4Ohm Coil', 'Original Smok Nord/Trinity Alpha 5pcs Occ Regular / Mesh / Ceramic / 0.6 / 0.8 / 1.4Ohm Coil', 300.00, 'https://cf.shopee.com.my/file/13e805624a41e8faa9896683011bd250', 1627909664, 1, 1);
INSERT INTO `xy_goods_list` VALUES (991, '(0-2, 2-4months) 10 Colors Baby Hat Cap Newborn Topi 0-3months Clothing', '(0-2, 2-4months) 10 Colors Baby Hat Cap Newborn Topi 0-3months Clothing', '(0-2, 2-4months) 10 Colors Baby Hat Cap Newborn Topi 0-3months Clothing', 17.90, 'https://cf.shopee.com.my/file/1307fc0b15f96af436fa7b7ece775f6f', 1627909664, 1, 1);
INSERT INTO `xy_goods_list` VALUES (992, 'LR44 SR920SW SR626SW LR1130 LR41 SR927SW SR521SW SR936SW SR621 LR1120 SR721SW LR754 AG5 AG 0 1 3 4 5 6 7 8 9 10 11 13', 'LR44 SR920SW SR626SW LR1130 LR41 SR927SW SR521SW SR936SW SR621 LR1120 SR721SW LR754 AG5 AG 0 1 3 4 5 6 7 8 9 10 11 13', 'LR44 SR920SW SR626SW LR1130 LR41 SR927SW SR521SW SR936SW SR621 LR1120 SR721SW LR754 AG5 AG 0 1 3 4 5 6 7 8 9 10 11 13', 5.00, 'https://cf.shopee.com.my/file/9a0faed99c737588a6ee49ea40391479', 1627909664, 1, 1);
INSERT INTO `xy_goods_list` VALUES (993, 'M&G R3/R5 Retractable Gel Pen 0.5 / 0.7mm Bullet Nib', 'M&G R3/R5 Retractable Gel Pen 0.5 / 0.7mm Bullet Nib', 'M&G R3/R5 Retractable Gel Pen 0.5 / 0.7mm Bullet Nib', 13.00, 'https://cf.shopee.com.my/file/587466ce4c94c0ef0d88bb7109024b5e', 1627909664, 1, 1);
INSERT INTO `xy_goods_list` VALUES (994, 'Fajar 1.0mm (32/0.2) x 3 Core Flexible Cord Cables 100% Pure Copper', 'Fajar 1.0mm (32/0.2) x 3 Core Flexible Cord Cables 100% Pure Copper', 'Fajar 1.0mm (32/0.2) x 3 Core Flexible Cord Cables 100% Pure Copper', 25.00, 'https://cf.shopee.com.my/file/1b0b24ce9101550f3d15fe64665983bf', 1627909664, 1, 1);
INSERT INTO `xy_goods_list` VALUES (996, 'Hogern Eye Lotion (Unidose Eyedrop ) 0.50ml x 10 Pcs eye drop', 'Hogern Eye Lotion (Unidose Eyedrop ) 0.50ml x 10 Pcs eye drop', 'Hogern Eye Lotion (Unidose Eyedrop ) 0.50ml x 10 Pcs eye drop', 142.80, 'https://cf.shopee.com.my/file/5427dc815bdf9745b2f1533622bbe143', 1627909664, 1, 1);
INSERT INTO `xy_goods_list` VALUES (998, 'Acrylic Photo frame 1PC Decor Protection Easy using Display Price-Tag Odorless Non-toxic Right-Angle 0.8 cm Thickness', 'Acrylic Photo frame 1PC Decor Protection Easy using Display Price-Tag Odorless Non-toxic Right-Angle 0.8 cm Thickness', 'Acrylic Photo frame 1PC Decor Protection Easy using Display Price-Tag Odorless Non-toxic Right-Angle 0.8 cm Thickness', 67.90, 'https://cf.shopee.com.my/file/1233fb1b6902f1044d9edeba8e15b71d', 1627909664, 1, 1);
INSERT INTO `xy_goods_list` VALUES (999, '3Pcs Long Sleeves New Born Baju Baby(0-6Mths)', '3Pcs Long Sleeves New Born Baju Baby(0-6Mths)', '3Pcs Long Sleeves New Born Baju Baby(0-6Mths)', 218.80, 'https://cf.shopee.com.my/file/8ccc62cce99873fafadbcfaee9e9114c', 1627909664, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1000, '3Pcs Short Sleeves New Born Baju Baby(0-6Mths)', '3Pcs Short Sleeves New Born Baju Baby(0-6Mths)', '3Pcs Short Sleeves New Born Baju Baby(0-6Mths)', 205.00, 'https://cf.shopee.com.my/file/97e5b0f11be3edde4d2c1103d96afcff', 1627909664, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1001, 'Original Smok RPM2 Occ / RPM 2 OCC Mesh 0.16 / 0.6DC For Smok RPM2 Kit / Smok IPX80 Kit x5pcs', 'Original Smok RPM2 Occ / RPM 2 OCC Mesh 0.16 / 0.6DC For Smok RPM2 Kit / Smok IPX80 Kit x5pcs', 'Original Smok RPM2 Occ / RPM 2 OCC Mesh 0.16 / 0.6DC For Smok RPM2 Kit / Smok IPX80 Kit x5pcs', 375.00, 'https://cf.shopee.com.my/file/50cff5899b1fa169f3e7a9966621c0ad', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1002, 'M&g gel pen r3/r5 0.5mm/0.7mm 1pcs', 'M&g gel pen r3/r5 0.5mm/0.7mm 1pcs', 'M&g gel pen r3/r5 0.5mm/0.7mm 1pcs', 11.20, 'https://cf.shopee.com.my/file/f1b2e293f65c884da551f6aa2c417ef6', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1003, 'Prolink 20W USB C PD 3.0 Power Delivery & QC3.0 2-Port Fast Charger for Apple iphone 12 Samsung S21 PTC21801', 'Prolink 20W USB C PD 3.0 Power Delivery & QC3.0 2-Port Fast Charger for Apple iphone 12 Samsung S21 PTC21801', 'Prolink 20W USB C PD 3.0 Power Delivery & QC3.0 2-Port Fast Charger for Apple iphone 12 Samsung S21 PTC21801', 350.00, 'https://cf.shopee.com.my/file/80964e1fefea3b1fe516a196a3c6a354', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1004, 'PLASTIC TRANSPARENT CLEAR / PP PLASTIC BAG 2KG/ Thickness 0.04, 0.06, 0.08 Size In Inch', 'PLASTIC TRANSPARENT CLEAR / PP PLASTIC BAG 2KG/ Thickness 0.04, 0.06, 0.08 Size In Inch', 'PLASTIC TRANSPARENT CLEAR / PP PLASTIC BAG 2KG/ Thickness 0.04, 0.06, 0.08 Size In Inch', 219.00, 'https://cf.shopee.com.my/file/196257cb26696434d36eb1d49df400b3', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1006, 'Ready Stock 14 colours ! 50pcs 3 layers rose soap flower (bunga sabun rose) as low as RM 0.49/pc only', 'Ready Stock 14 colours ! 50pcs 3 layers rose soap flower (bunga sabun rose) as low as RM 0.49/pc only', 'Ready Stock 14 colours ! 50pcs 3 layers rose soap flower (bunga sabun rose) as low as RM 0.49/pc only', 219.90, 'https://cf.shopee.com.my/file/ddebbf2772a5751e7bad06536be6f14a', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1007, 'TEST GOOD PEN ZHI XIN LOVEIN GEL INK PEN 0.5MM G-2501 / 1 PIECE', 'TEST GOOD PEN ZHI XIN LOVEIN GEL INK PEN 0.5MM G-2501 / 1 PIECE', 'TEST GOOD PEN ZHI XIN LOVEIN GEL INK PEN 0.5MM G-2501 / 1 PIECE', 7.00, 'https://cf.shopee.com.my/file/7c6ed2e751161ff782986e546884112a', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1008, 'GENUINE Voopoo Drag 3/ Argus GT / Argus Pro / Drag Max / Drag S/X Replacement Coil 5pcs Occ 0.15 / 0.2 / 0.3 / 0.6', 'GENUINE Voopoo Drag 3/ Argus GT / Argus Pro / Drag Max / Drag S/X Replacement Coil 5pcs Occ 0.15 / 0.2 / 0.3 / 0.6', 'GENUINE Voopoo Drag 3/ Argus GT / Argus Pro / Drag Max / Drag S/X Replacement Coil 5pcs Occ 0.15 / 0.2 / 0.3 / 0.6', 129.90, 'https://cf.shopee.com.my/file/498523beefc7ebeff74d096140dfbfa1', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1009, 'TURKEY 15MM CONATACT LENS 0-500 READY STOCK', 'TURKEY 15MM CONATACT LENS 0-500 READY STOCK', 'TURKEY 15MM CONATACT LENS 0-500 READY STOCK', 100.00, 'https://cf.shopee.com.my/file/5802e0ee214dc843eef5729889dba043', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1010, 'CAMILIA SUIT 6.0 BY ZS', 'CAMILIA SUIT 6.0 BY ZS', 'CAMILIA SUIT 6.0 BY ZS', 592.50, 'https://cf.shopee.com.my/file/3965c26d40334a712fd5f59e6ea3a2b2', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1011, 'Zebra SARASA Click Pen Colour 0.7mm', 'Zebra SARASA Click Pen Colour 0.7mm', 'Zebra SARASA Click Pen Colour 0.7mm', 28.70, 'https://cf.shopee.com.my/file/d62412a2781748564f8bd9f866785e7b', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1012, '[Ready Stock] (6824) 1Pcs Permanent marker pen/waterproof marker/oily head marker 0.5/1.0mm.', '[Ready Stock] (6824) 1Pcs Permanent marker pen/waterproof marker/oily head marker 0.5/1.0mm.', '[Ready Stock] (6824) 1Pcs Permanent marker pen/waterproof marker/oily head marker 0.5/1.0mm.', 15.00, 'https://cf.shopee.com.my/file/9b0874e3f62b31590ebbbc6fc9b77ad5', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1013, 'Xiaomi Super Durable Writing Sign Pen 0.5mm Gel Pen Signing Pens Smooth Switzerland Refill Red Black Ink Pen Ballpoint Pen 10pcs', 'Xiaomi Super Durable Writing Sign Pen 0.5mm Gel Pen Signing Pens Smooth Switzerland Refill Red Black Ink Pen Ballpoint Pen 10pcs', 'Xiaomi Super Durable Writing Sign Pen 0.5mm Gel Pen Signing Pens Smooth Switzerland Refill Red Black Ink Pen Ballpoint Pen 10pcs', 89.90, 'https://cf.shopee.com.my/file/7d1c7fd2a77542f2d3d81e67330febad', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1014, '[1.8M / 3.0M] USB2.0 EXTENSION CABLE AM-AF / USB3.0 EXTENSION CABLE AM-AF EXTENDER CONVERTER ADAPTER EXTEND CONNECTOR', '[1.8M / 3.0M] USB2.0 EXTENSION CABLE AM-AF / USB3.0 EXTENSION CABLE AM-AF EXTENDER CONVERTER ADAPTER EXTEND CONNECTOR', '[1.8M / 3.0M] USB2.0 EXTENSION CABLE AM-AF / USB3.0 EXTENSION CABLE AM-AF EXTENDER CONVERTER ADAPTER EXTEND CONNECTOR', 59.00, 'https://cf.shopee.com.my/file/3650b9a00cf630fc30fb81f2cf663a76', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1015, 'FABER CASTELL AIR GEL PEN FAST DRY INK & REFILL [0.5MM/ 0.7MM] PER PCS', 'FABER CASTELL AIR GEL PEN FAST DRY INK & REFILL [0.5MM/ 0.7MM] PER PCS', 'FABER CASTELL AIR GEL PEN FAST DRY INK & REFILL [0.5MM/ 0.7MM] PER PCS', 19.90, 'https://cf.shopee.com.my/file/4c6f933b747f99e368f9cf0f592d32a8', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1016, 'Pilot Rexgrip Mechanical Pencil + Lead 0.5/0.7', 'Pilot Rexgrip Mechanical Pencil + Lead 0.5/0.7', 'Pilot Rexgrip Mechanical Pencil + Lead 0.5/0.7', 36.00, 'https://cf.shopee.com.my/file/6ea542092b11acb6ead7f2ffcc1dd305', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1017, 'Pilot Wingel Gel Pen 0.38mm / 0.5mm / 0.7mm', 'Pilot Wingel Gel Pen 0.38mm / 0.5mm / 0.7mm', 'Pilot Wingel Gel Pen 0.38mm / 0.5mm / 0.7mm', 26.50, 'https://cf.shopee.com.my/file/24f81cd9487cad8e42744a5b8628764f', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1018, 'Deli Ball Point Pen Blue Mini Tip (0.7mm) [Per Pen] Q03330', 'Deli Ball Point Pen Blue Mini Tip (0.7mm) [Per Pen] Q03330', 'Deli Ball Point Pen Blue Mini Tip (0.7mm) [Per Pen] Q03330', 5.70, 'https://cf.shopee.com.my/file/9d86526f0249c6719be1faf21d514f89', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1020, '[[HQ]]UBAT BISUL MUJARAB WARISAN 0.02KG', '[[HQ]]UBAT BISUL MUJARAB WARISAN 0.02KG', '[[HQ]]UBAT BISUL MUJARAB WARISAN 0.02KG', 120.00, 'https://cf.shopee.com.my/file/bb11cd27d0b997d45e797022df369a06', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1021, 'Zhi Xin Gel Pen 0.5mm/ Test Good G-2501 Gel Ink Pen 0.5mm/1PC', 'Zhi Xin Gel Pen 0.5mm/ Test Good G-2501 Gel Ink Pen 0.5mm/1PC', 'Zhi Xin Gel Pen 0.5mm/ Test Good G-2501 Gel Ink Pen 0.5mm/1PC', 5.40, 'https://cf.shopee.com.my/file/b89942c3fd6d02c05f9f6fa6f91d09b5', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1022, 'Original Smok RPM 2 Replacement Occ 0.16 Ohm Replacement Coil RPM2', 'Original Smok RPM 2 Replacement Occ 0.16 Ohm Replacement Coil RPM2', 'Original Smok RPM 2 Replacement Occ 0.16 Ohm Replacement Coil RPM2', 380.00, 'https://cf.shopee.com.my/file/edc92c8f835384711480042c380b11fc', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1024, 'UR KL Seller Electronic Digital Kitchen Scale Multifunction Scale Penimbang Digital With Minimum Accuracy 0.1/0.01g', 'UR KL Seller Electronic Digital Kitchen Scale Multifunction Scale Penimbang Digital With Minimum Accuracy 0.1/0.01g', 'UR KL Seller Electronic Digital Kitchen Scale Multifunction Scale Penimbang Digital With Minimum Accuracy 0.1/0.01g', 18.80, 'https://cf.shopee.com.my/file/b43a2fbddae995dde1ac33f4885dcf30', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1025, '12 Colors/0.5mm Colorful Gel Pen Plastic Pen Ink Maker Pen Writing Supplies Student School Office Stationery', '12 Colors/0.5mm Colorful Gel Pen Plastic Pen Ink Maker Pen Writing Supplies Student School Office Stationery', '12 Colors/0.5mm Colorful Gel Pen Plastic Pen Ink Maker Pen Writing Supplies Student School Office Stationery', 6.80, 'https://cf.shopee.com.my/file/506bb98ddef889d33ed1278b8f49c045', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1027, 'Guitar Pick Thin 0.46mm/ 0.71mm /0.96mm Acoustic Electric Guitar Picks Accessories/ Gitar Pick/ Spectrum/ Petik Guitar', 'Guitar Pick Thin 0.46mm/ 0.71mm /0.96mm Acoustic Electric Guitar Picks Accessories/ Gitar Pick/ Spectrum/ Petik Guitar', 'Guitar Pick Thin 0.46mm/ 0.71mm /0.96mm Acoustic Electric Guitar Picks Accessories/ Gitar Pick/ Spectrum/ Petik Guitar', 10.00, 'https://cf.shopee.com.my/file/51d1f6e0cc06d9260894d82284802735', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1028, 'PILOT REXGRIP MECHANICAL PENCIL + LEAD 0.5MM / 0.7MM // PENSEL TEKAN // AUTOMATIC PENCIL', 'PILOT REXGRIP MECHANICAL PENCIL + LEAD 0.5MM / 0.7MM // PENSEL TEKAN // AUTOMATIC PENCIL', 'PILOT REXGRIP MECHANICAL PENCIL + LEAD 0.5MM / 0.7MM // PENSEL TEKAN // AUTOMATIC PENCIL', 39.00, 'https://cf.shopee.com.my/file/84c631f648b91b07edf8231000b0452b', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1032, 'Montessori Materials Baby Flash Cards 0 - 36 Months Early Learning', 'Montessori Materials Baby Flash Cards 0 - 36 Months Early Learning', 'Montessori Materials Baby Flash Cards 0 - 36 Months Early Learning', 45.90, 'https://cf.shopee.com.my/file/fc369c87030b825dce910c7b9169a7d2', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1033, 'Ambi Pur Car Mini Clip 2.2ml v1.0', 'Ambi Pur Car Mini Clip 2.2ml v1.0', 'Ambi Pur Car Mini Clip 2.2ml v1.0', 95.00, 'https://cf.shopee.com.my/file/ce3f6b96ee7f3498f1ade53cf7d1fe38', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1034, '2020 New Infant Boy Cotton Socks Cartoon Anti-slip Toddler Floor Socks Autumn & Winter Thick Warm 0-3 Years Newborn Baby Cute Warm Socks Fashion', '2020 New Infant Boy Cotton Socks Cartoon Anti-slip Toddler Floor Socks Autumn & Winter Thick Warm 0-3 Years Newborn Baby Cute Warm Socks Fashion', '2020 New Infant Boy Cotton Socks Cartoon Anti-slip Toddler Floor Socks Autumn & Winter Thick Warm 0-3 Years Newborn Baby Cute Warm Socks Fashion', 59.90, 'https://cf.shopee.com.my/file/ed6b664250d8e442009e10af750cf5fa', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1035, 'Pigeon Unisex Newborn Baby Clothes Eyelet Short Sleeves Short Pants Baju Berlubang 0-18 Bulan Baju Baby Baru Lahir', 'Pigeon Unisex Newborn Baby Clothes Eyelet Short Sleeves Short Pants Baju Berlubang 0-18 Bulan Baju Baby Baru Lahir', 'Pigeon Unisex Newborn Baby Clothes Eyelet Short Sleeves Short Pants Baju Berlubang 0-18 Bulan Baju Baby Baru Lahir', 119.00, 'https://cf.shopee.com.my/file/a14c6c8a270f5941b5edb14608265766', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1036, 'Pilot G2 Retractable Gel Pen 0.5mm 0.7mm 1.0mm Black Blue Red', 'Pilot G2 Retractable Gel Pen 0.5mm 0.7mm 1.0mm Black Blue Red', 'Pilot G2 Retractable Gel Pen 0.5mm 0.7mm 1.0mm Black Blue Red', 35.50, 'https://cf.shopee.com.my/file/82a9eb4553b88f74dd9f81a3a99ed39d', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1037, 'Japan Version Pentel Graph Gear 500 Drafting Mech Pencil 0.3 0.4 0.5 0.7 0.9mm PG513 PG514 PG515 PG517 PG519', 'Japan Version Pentel Graph Gear 500 Drafting Mech Pencil 0.3 0.4 0.5 0.7 0.9mm PG513 PG514 PG515 PG517 PG519', 'Japan Version Pentel Graph Gear 500 Drafting Mech Pencil 0.3 0.4 0.5 0.7 0.9mm PG513 PG514 PG515 PG517 PG519', 257.00, 'https://cf.shopee.com.my/file/e3a7362596ae081067b0490eb6eb6297', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1038, 'Artline 210 0.6mm Writing, Drawing, Sign Pen', 'Artline 210 0.6mm Writing, Drawing, Sign Pen', 'Artline 210 0.6mm Writing, Drawing, Sign Pen', 20.00, 'https://cf.shopee.com.my/file/e5a4389ab2f05e587c44a52f5bbf5661', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1041, '12/24/36Pcs Fineliner Color Pen Set 0.38mm Colored Sketch Drawing Pen Fine Point Marker Perfect for Journal Note Taking', '12/24/36Pcs Fineliner Color Pen Set 0.38mm Colored Sketch Drawing Pen Fine Point Marker Perfect for Journal Note Taking', '12/24/36Pcs Fineliner Color Pen Set 0.38mm Colored Sketch Drawing Pen Fine Point Marker Perfect for Journal Note Taking', 59.70, 'https://cf.shopee.com.my/file/349b11e3174e4517bf375c78ab36a089', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1042, 'Newborn Baby Girl Summer Clothes Set Cotton Knitting Solid Stripes Sleeveless Fly Sleeve Romper and Bowknot Headband 2pcs Outfit 0-2T Comfortable and Soft', 'Newborn Baby Girl Summer Clothes Set Cotton Knitting Solid Stripes Sleeveless Fly Sleeve Romper and Bowknot Headband 2pcs Outfit 0-2T Comfortable and Soft', 'Newborn Baby Girl Summer Clothes Set Cotton Knitting Solid Stripes Sleeveless Fly Sleeve Romper and Bowknot Headband 2pcs Outfit 0-2T Comfortable and Soft', 126.30, 'https://cf.shopee.com.my/file/a1bd8afe739722d9e3c5a74e632fd101', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1043, 'Lahoot Saffron Original (0.5gr/ 1gr / 3gr)', 'Lahoot Saffron Original (0.5gr/ 1gr / 3gr)', 'Lahoot Saffron Original (0.5gr/ 1gr / 3gr)', 123.50, 'https://cf.shopee.com.my/file/39e4055f8c1c1f82bfd7c28901875f8a', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1044, 'Bubble Wrap 100m x 0.5m (Only Can Buy 1 roll)', 'Bubble Wrap 100m x 0.5m (Only Can Buy 1 roll)', 'Bubble Wrap 100m x 0.5m (Only Can Buy 1 roll)', 365.00, 'https://cf.shopee.com.my/file/6d207295d93e3f6c18ccb300882d29c0', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1045, 'Deli Ballpoint Pen Mini Tip - Blue (0.7mm) EQ13-BL', 'Deli Ballpoint Pen Mini Tip - Blue (0.7mm) EQ13-BL', 'Deli Ballpoint Pen Mini Tip - Blue (0.7mm) EQ13-BL', 10.00, 'https://cf.shopee.com.my/file/ec4d6d592c2bb9cb0fed3aff7caa5e7e', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1047, '0-6Years Infant Baby Girls Tights Newborn Stockings Pantyhose Kids Babygirls Leggings Pants', '0-6Years Infant Baby Girls Tights Newborn Stockings Pantyhose Kids Babygirls Leggings Pants', '0-6Years Infant Baby Girls Tights Newborn Stockings Pantyhose Kids Babygirls Leggings Pants', 117.60, 'https://cf.shopee.com.my/file/29fc30007561d9d2795dda2bc0e3bc42', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1049, 'Winzige 18Colors Retro Gel Pen 0.5mm Journal Vintage Gel Pen', 'Winzige 18Colors Retro Gel Pen 0.5mm Journal Vintage Gel Pen', 'Winzige 18Colors Retro Gel Pen 0.5mm Journal Vintage Gel Pen', 17.40, 'https://cf.shopee.com.my/file/90d32c435eed40fe5b0ad35f8bc5f4d6', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1050, 'Faber-Castell RX Gel (0.5mm - RX5 / 0.7mm - RX7 / Black / Blue / Red)', 'Faber-Castell RX Gel (0.5mm - RX5 / 0.7mm - RX7 / Black / Blue / Red)', 'Faber-Castell RX Gel (0.5mm - RX5 / 0.7mm - RX7 / Black / Blue / Red)', 12.50, 'https://cf.shopee.com.my/file/d384df8d4f2807ec22936f8d01cbd84b', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1051, 'Pilot Color Eno Erasable Mechanical Pencils Lead 0.7MM', 'Pilot Color Eno Erasable Mechanical Pencils Lead 0.7MM', 'Pilot Color Eno Erasable Mechanical Pencils Lead 0.7MM', 39.00, 'https://cf.shopee.com.my/file/d5bc3d7dc25147e16e6f260e99b5be8b', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1054, 'OOREE UH401 4 PORTS HIGH SPEED USB2.0 USB HUB ON/OFF PORTABLE SWITCH, BLACK', 'OOREE UH401 4 PORTS HIGH SPEED USB2.0 USB HUB ON/OFF PORTABLE SWITCH, BLACK', 'OOREE UH401 4 PORTS HIGH SPEED USB2.0 USB HUB ON/OFF PORTABLE SWITCH, BLACK', 119.00, 'https://cf.shopee.com.my/file/541d74a14c50854920af275ea1794339', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1056, '0.3M Stereo Audio Aux 3.5mm Female to 2 RCA L/R Male Cable Converter*', '0.3M Stereo Audio Aux 3.5mm Female to 2 RCA L/R Male Cable Converter*', '0.3M Stereo Audio Aux 3.5mm Female to 2 RCA L/R Male Cable Converter*', 62.80, 'https://cf.shopee.com.my/file/b99c5274a12861b58ab696a019fef419', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1058, 'pH Paper | 100 Strips | Wide Range 0 - 14 | Litmus | Universal Indicator Strips', 'pH Paper | 100 Strips | Wide Range 0 - 14 | Litmus | Universal Indicator Strips', 'pH Paper | 100 Strips | Wide Range 0 - 14 | Litmus | Universal Indicator Strips', 130.00, 'https://cf.shopee.com.my/file/8670537b32ee3cee0f3934ef66a8eeaf', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1059, 'Ready Stock 0-24 Months Baby Girl Dress Summer Princess Clothing Baju Newborn Sleeveless skirt Cotton Top', 'Ready Stock 0-24 Months Baby Girl Dress Summer Princess Clothing Baju Newborn Sleeveless skirt Cotton Top', 'Ready Stock 0-24 Months Baby Girl Dress Summer Princess Clothing Baju Newborn Sleeveless skirt Cotton Top', 46.00, 'https://cf.shopee.com.my/file/e40d62a0bf0ac1741716fee9d2d1e409', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1060, 'Baseus Super Si Mini USB C Charger Support QC3.0 PD Fast Charging For Phone 12 (20W)', 'Baseus Super Si Mini USB C Charger Support QC3.0 PD Fast Charging For Phone 12 (20W)', 'Baseus Super Si Mini USB C Charger Support QC3.0 PD Fast Charging For Phone 12 (20W)', 60.00, 'https://cf.shopee.com.my/file/9aadbfa459b991912de808529960e561', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1061, 'PMBOOKS Faber Castell Click X5 / X7 - 0.5mm/0.07mm (Ready Stock)', 'PMBOOKS Faber Castell Click X5 / X7 - 0.5mm/0.07mm (Ready Stock)', 'PMBOOKS Faber Castell Click X5 / X7 - 0.5mm/0.07mm (Ready Stock)', 5.20, 'https://cf.shopee.com.my/file/18273fd537259109b6e1a4cd8b2e6d3e', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1063, 'Pilot Progrex Mechanical Pencil 0.3mm / 0.5mm / 0.7mm / 0.9mm', 'Pilot Progrex Mechanical Pencil 0.3mm / 0.5mm / 0.7mm / 0.9mm', 'Pilot Progrex Mechanical Pencil 0.3mm / 0.5mm / 0.7mm / 0.9mm', 26.00, 'https://cf.shopee.com.my/file/0cb77ce2226463fc7124e8a4022ea0e2', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1064, 'U-HOME 3 Bar/4 Bar 0.8M-2M Retractable Cloth Hanger Stainless Steel Ampaian Baju Wall Mounted Clothes Drying Rack', 'U-HOME 3 Bar/4 Bar 0.8M-2M Retractable Cloth Hanger Stainless Steel Ampaian Baju Wall Mounted Clothes Drying Rack', 'U-HOME 3 Bar/4 Bar 0.8M-2M Retractable Cloth Hanger Stainless Steel Ampaian Baju Wall Mounted Clothes Drying Rack', 669.00, 'https://cf.shopee.com.my/file/11cb512052dc415f0e41b44210574902', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1065, '[Ready stock] Etude House Drawing Eye Brow 0.25g', '[Ready stock] Etude House Drawing Eye Brow 0.25g', '[Ready stock] Etude House Drawing Eye Brow 0.25g', 75.00, 'https://cf.shopee.com.my/file/18500a4a2d60c7f2744f955a1063e0cc', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1066, 'The Ordinary Retinol 0.2% in Squalane 30ml / 0.5% In Squalane 30ml', 'The Ordinary Retinol 0.2% in Squalane 30ml / 0.5% In Squalane 30ml', 'The Ordinary Retinol 0.2% in Squalane 30ml / 0.5% In Squalane 30ml', 378.00, 'https://cf.shopee.com.my/file/88d0eaa8217ce8ee61f4b48b3d6fe9d7', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1067, '0.2MM-1MM Jewelry Silver Plated Copper Wire Does Not Fade Prevent Allergies For Jewelry Making Copper Wir', '0.2MM-1MM Jewelry Silver Plated Copper Wire Does Not Fade Prevent Allergies For Jewelry Making Copper Wir', '0.2MM-1MM Jewelry Silver Plated Copper Wire Does Not Fade Prevent Allergies For Jewelry Making Copper Wir', 31.40, 'https://cf.shopee.com.my/file/baae5b76bb4e8fbeb0325cacdfa15466', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1068, '0-5Y Casual Pants Kids Baby Girls Boys Pant Cotton Trousers Sports Bloomers', '0-5Y Casual Pants Kids Baby Girls Boys Pant Cotton Trousers Sports Bloomers', '0-5Y Casual Pants Kids Baby Girls Boys Pant Cotton Trousers Sports Bloomers', 89.90, 'https://cf.shopee.com.my/file/d1705b594df34bc1b9244f1d0f2b3105', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1069, '(0-6M) BAJU BABY GIRL MURAH / BABY GIRL SUIT / BABY CLOTHING / BAJU LUBANG BABY GIRL / EYELET BABY SUIT / DRESS', '(0-6M) BAJU BABY GIRL MURAH / BABY GIRL SUIT / BABY CLOTHING / BAJU LUBANG BABY GIRL / EYELET BABY SUIT / DRESS', '(0-6M) BAJU BABY GIRL MURAH / BABY GIRL SUIT / BABY CLOTHING / BAJU LUBANG BABY GIRL / EYELET BABY SUIT / DRESS', 87.00, 'https://cf.shopee.com.my/file/91b274bcae4a7f948773ec03b2645269', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1070, '[Grab2Go] Mechanical Pencil - STABILO Mechanical Pencil Set (0.5MM) with Hi Polymer Leads and Eraser', '[Grab2Go] Mechanical Pencil - STABILO Mechanical Pencil Set (0.5MM) with Hi Polymer Leads and Eraser', '[Grab2Go] Mechanical Pencil - STABILO Mechanical Pencil Set (0.5MM) with Hi Polymer Leads and Eraser', 22.00, 'https://cf.shopee.com.my/file/80633cea29f5fe08adfc0a40af7a9127', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1071, 'Anker A8452 PowerLine+ II Lightning Cable - Black (0.9m) with MFI', 'Anker A8452 PowerLine+ II Lightning Cable - Black (0.9m) with MFI', 'Anker A8452 PowerLine+ II Lightning Cable - Black (0.9m) with MFI', 730.00, 'https://cf.shopee.com.my/file/eb02ac4536ddb5a61acb5edc55ed0dad', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1072, 'Boy fashion suit 0-5 years old boys with beach coconut leaf pattern shirt + pants 2 pieces', 'Boy fashion suit 0-5 years old boys with beach coconut leaf pattern shirt + pants 2 pieces', 'Boy fashion suit 0-5 years old boys with beach coconut leaf pattern shirt + pants 2 pieces', 109.80, 'https://cf.shopee.com.my/file/04f1423d2c860c5a06af87b18e569718', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1073, 'Samsung Galaxy Tab A 8.0 2019 T290 295 Tab S6 T860 865 Tab A 8 2019 P200 P205 Tab A 10.1 2019 T510 T515 Tab A8.0 T385 360 Degree Rotating Base Tablet Case protective cover', 'Samsung Galaxy Tab A 8.0 2019 T290 295 Tab S6 T860 865 Tab A 8 2019 P200 P205 Tab A 10.1 2019 T510 T515 Tab A8.0 T385 360 Degree Rotating Base Tablet Case protective cover', 'Samsung Galaxy Tab A 8.0 2019 T290 295 Tab S6 T860 865 Tab A 8 2019 P200 P205 Tab A 10.1 2019 T510 T515 Tab A8.0 T385 360 Degree Rotating Base Tablet Case protective cover', 117.90, 'https://cf.shopee.com.my/file/df2df26092e708870c83ada1fd805b17', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1074, 'Newborn 0-3-6 month baby cotton underwear infant child suit', 'Newborn 0-3-6 month baby cotton underwear infant child suit', 'Newborn 0-3-6 month baby cotton underwear infant child suit', 89.90, 'https://cf.shopee.com.my/file/de847567aeb0e8f1a8be704e870baab3', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1075, 'Anmum Infacare Step 1 Milk Powder 0-12 Months 650g Ready stock (EXP:04/2022)', 'Anmum Infacare Step 1 Milk Powder 0-12 Months 650g Ready stock (EXP:04/2022)', 'Anmum Infacare Step 1 Milk Powder 0-12 Months 650g Ready stock (EXP:04/2022)', 658.80, 'https://cf.shopee.com.my/file/49dcd8f7e58616a1e4ca84cbfcb53c2d', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1076, '3Pcs Mom\'s Care Baby Breathable Elastic Hat Cotton 100%, Topi Bayi baru lahir 0-6month', '3Pcs Mom\'s Care Baby Breathable Elastic Hat Cotton 100%, Topi Bayi baru lahir 0-6month', '3Pcs Mom\'s Care Baby Breathable Elastic Hat Cotton 100%, Topi Bayi baru lahir 0-6month', 155.00, 'https://cf.shopee.com.my/file/d35b987e272fe6477050d247ceac68ad', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1077, 'Numbers 0-9 Happy Birthday Wedding Party Decoration Foil Balloon Gold 16\'\' Belon Selamat Hari Jadi Balloons', 'Numbers 0-9 Happy Birthday Wedding Party Decoration Foil Balloon Gold 16\'\' Belon Selamat Hari Jadi Balloons', 'Numbers 0-9 Happy Birthday Wedding Party Decoration Foil Balloon Gold 16\'\' Belon Selamat Hari Jadi Balloons', 12.10, 'https://cf.shopee.com.my/file/e9c06d64f619bfa2896ef2f8f3f7b3d9', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1079, 'Runni Rice Cooker (0.6L, 1L)', 'Runni Rice Cooker (0.6L, 1L)', 'Runni Rice Cooker (0.6L, 1L)', 399.00, 'https://cf.shopee.com.my/file/31860ddad9ef03bb4a843e43e7dbefc8', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1080, 'ORICO W5P-U3 W5P-U2 FL01 TWU3-4A TWU3-7A 3AST MH4PU MH4U-U3 W8PH4-U3 SHC-U3 TWC3-4A 4/7port Type C USB2.0 USB3.0 Hub', 'ORICO W5P-U3 W5P-U2 FL01 TWU3-4A TWU3-7A 3AST MH4PU MH4U-U3 W8PH4-U3 SHC-U3 TWC3-4A 4/7port Type C USB2.0 USB3.0 Hub', 'ORICO W5P-U3 W5P-U2 FL01 TWU3-4A TWU3-7A 3AST MH4PU MH4U-U3 W8PH4-U3 SHC-U3 TWC3-4A 4/7port Type C USB2.0 USB3.0 Hub', 119.00, 'https://cf.shopee.com.my/file/107243d1f532d3168808c44e1ae96f5b', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1081, 'Harga Borong Baju Bayi Nightwear Lubang Jaring Butang Eyelet Newborn Baby Long Sleeve Pants 0-12 Sleep', 'Harga Borong Baju Bayi Nightwear Lubang Jaring Butang Eyelet Newborn Baby Long Sleeve Pants 0-12 Sleep', 'Harga Borong Baju Bayi Nightwear Lubang Jaring Butang Eyelet Newborn Baby Long Sleeve Pants 0-12 Sleep', 94.90, 'https://cf.shopee.com.my/file/86e67e9e304546d0883ce58688be6580', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1083, '5 PCS baby romper newborn baby clothing clothes Baby One Piece baju bayi newborn clothes Baby Boy Girl Short sleeve kids clothes 0-12M', '5 PCS baby romper newborn baby clothing clothes Baby One Piece baju bayi newborn clothes Baby Boy Girl Short sleeve kids clothes 0-12M', '5 PCS baby romper newborn baby clothing clothes Baby One Piece baju bayi newborn clothes Baby Boy Girl Short sleeve kids clothes 0-12M', 399.50, 'https://cf.shopee.com.my/file/b57857733f6856780cda0e79614781d4', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1084, 'Faster Pencil Lead 0.5MM 4IN1 - 0388', 'Faster Pencil Lead 0.5MM 4IN1 - 0388', 'Faster Pencil Lead 0.5MM 4IN1 - 0388', 21.00, 'https://cf.shopee.com.my/file/8458fd3965c5e48d853e0cdea3150b68', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1086, 'MIDEA 0.6L Mini Conventional Rice Cooker Periuk Nasi (MG-GP06B, MGGP06B)', 'MIDEA 0.6L Mini Conventional Rice Cooker Periuk Nasi (MG-GP06B, MGGP06B)', 'MIDEA 0.6L Mini Conventional Rice Cooker Periuk Nasi (MG-GP06B, MGGP06B)', 458.00, 'https://cf.shopee.com.my/file/c1fd72359384ac765e4616ed44032c8b', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1087, 'Lace Patch /Border Lace/Chemical Lace 0.5m', 'Lace Patch /Border Lace/Chemical Lace 0.5m', 'Lace Patch /Border Lace/Chemical Lace 0.5m', 55.00, 'https://cf.shopee.com.my/file/ec7c3f754da20c03f9e6d5614af4816d', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1088, 'Clinbon Newborn baby wear ~ infant suit,set baju bayi baru lahir 0-9months', 'Clinbon Newborn baby wear ~ infant suit,set baju bayi baru lahir 0-9months', 'Clinbon Newborn baby wear ~ infant suit,set baju bayi baru lahir 0-9months', 39.00, 'https://cf.shopee.com.my/file/68fac81ccb5c804e9e664bc55890b241', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1090, 'Wire suasa 0. 45mm,0.5mm. 6mm,0.7mm,0.8mm', 'Wire suasa 0. 45mm,0.5mm. 6mm,0.7mm,0.8mm', 'Wire suasa 0. 45mm,0.5mm. 6mm,0.7mm,0.8mm', 380.00, 'https://cf.shopee.com.my/file/b6441e7092bb4d2911e143496ddeaf5a', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1092, 'M&G Expert Gel Pen 0.7mm 1.0mm Black Blue Red R3 R5 13671 13672', 'M&G Expert Gel Pen 0.7mm 1.0mm Black Blue Red R3 R5 13671 13672', 'M&G Expert Gel Pen 0.7mm 1.0mm Black Blue Red R3 R5 13671 13672', 10.80, 'https://cf.shopee.com.my/file/95e778873433a25d71ac239a08eb28b5', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1094, '46\'\' Kain Cotton TR Corak 0.6cm Medium Polka Dot (46\'\' Medium Polka Dot Designed Cotton TR Textile)', '46\'\' Kain Cotton TR Corak 0.6cm Medium Polka Dot (46\'\' Medium Polka Dot Designed Cotton TR Textile)', '46\'\' Kain Cotton TR Corak 0.6cm Medium Polka Dot (46\'\' Medium Polka Dot Designed Cotton TR Textile)', 24.10, 'https://cf.shopee.com.my/file/c75129b29c47274749439b2af0f1a14b', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1096, '1000 lumen Flashlight Outdoor Use High Light Mulfunction Flashlight Samsung LH351D LED Torch Phone USB charging 5 Modes, Zoomable, Water Resistant, Handheld Light Sofirn S11 v2.0 New version', '1000 lumen Flashlight Outdoor Use High Light Mulfunction Flashlight Samsung LH351D LED Torch Phone USB charging 5 Modes, Zoomable, Water Resistant, Handheld Light Sofirn S11 v2.0 New version', '1000 lumen Flashlight Outdoor Use High Light Mulfunction Flashlight Samsung LH351D LED Torch Phone USB charging 5 Modes, Zoomable, Water Resistant, Handheld Light Sofirn S11 v2.0 New version', 279.90, 'https://cf.shopee.com.my/file/a57c6d3edbb55ca6350f485d0ca62e67', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1097, 'Ready Stock 0-4Y Summer baby girl dress mesh design Stitching Bottoming Short Sleeve Sweet Princess Dress new born skirt', 'Ready Stock 0-4Y Summer baby girl dress mesh design Stitching Bottoming Short Sleeve Sweet Princess Dress new born skirt', 'Ready Stock 0-4Y Summer baby girl dress mesh design Stitching Bottoming Short Sleeve Sweet Princess Dress new born skirt', 158.80, 'https://cf.shopee.com.my/file/1e774abe523f87fe929ba5ebe55fac8b', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1098, 'Torikumu Ebi Ultra-Light Action Light Power 2-Piece Spinning Fishing Rod 5\'6\" 6\'0\" (Joran Udang Ikan)', 'Torikumu Ebi Ultra-Light Action Light Power 2-Piece Spinning Fishing Rod 5\'6\" 6\'0\" (Joran Udang Ikan)', 'Torikumu Ebi Ultra-Light Action Light Power 2-Piece Spinning Fishing Rod 5\'6\" 6\'0\" (Joran Udang Ikan)', 340.00, 'https://cf.shopee.com.my/file/a5246b44f907a25cfb6e19210d9ae5fb', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1100, '0 - 18 Months Baby Girl Clothing | Baby Dress | Baby Sleepwear | Baby Suit | Baju Baby | Baju Bayi Perempuan', '0 - 18 Months Baby Girl Clothing | Baby Dress | Baby Sleepwear | Baby Suit | Baju Baby | Baju Bayi Perempuan', '0 - 18 Months Baby Girl Clothing | Baby Dress | Baby Sleepwear | Baby Suit | Baju Baby | Baju Bayi Perempuan', 119.90, 'https://cf.shopee.com.my/file/e49e9a1970618c79d2f58affb71ce4f2', 1627909665, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1101, 'MUJI Style 3 Colors 0.5mm Water-based Pen Gel Pen Black/Red/Blue Ink Pen Maker Pen Stationery for Students', 'MUJI Style 3 Colors 0.5mm Water-based Pen Gel Pen Black/Red/Blue Ink Pen Maker Pen Stationery for Students', 'MUJI Style 3 Colors 0.5mm Water-based Pen Gel Pen Black/Red/Blue Ink Pen Maker Pen Stationery for Students', 1.00, 'https://cf.shopee.com.my/file/ad18ab852563acc9c6af1830a6bbed46', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1102, '<Ready stock!> 12 Colors Gel Pen 0.5mm Tip Cute Pen for journal, drawing, graffiti School office stationery', '<Ready stock!> 12 Colors Gel Pen 0.5mm Tip Cute Pen for journal, drawing, graffiti School office stationery', '<Ready stock!> 12 Colors Gel Pen 0.5mm Tip Cute Pen for journal, drawing, graffiti School office stationery', 7.80, 'https://cf.shopee.com.my/file/69c3094436476c4fcf09c938fe3e2b8c', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1103, 'Original Nevoks Feelin Occ 0.6 Ohm / 1.0 Ohm Mesh Coil', 'Original Nevoks Feelin Occ 0.6 Ohm / 1.0 Ohm Mesh Coil', 'Original Nevoks Feelin Occ 0.6 Ohm / 1.0 Ohm Mesh Coil', 340.00, 'https://cf.shopee.com.my/file/bbafcca58e88e3d51a2b8b4175498028', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1104, '0.5mm Zebra Sarasa Clip Pen (JJ15), Gel Pen', '0.5mm Zebra Sarasa Clip Pen (JJ15), Gel Pen', '0.5mm Zebra Sarasa Clip Pen (JJ15), Gel Pen', 28.90, 'https://cf.shopee.com.my/file/f732c99d07636d9b0a295899970654e4', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1105, 'MUJI Gel Ballpoint Pen Black/Blue/Red Ink Color Pens 0.5mm 0.38mm Japan Original Stationary', 'MUJI Gel Ballpoint Pen Black/Blue/Red Ink Color Pens 0.5mm 0.38mm Japan Original Stationary', 'MUJI Gel Ballpoint Pen Black/Blue/Red Ink Color Pens 0.5mm 0.38mm Japan Original Stationary', 25.00, 'https://cf.shopee.com.my/file/a4d65026f9ddcb9e1d2245f4111a9af2', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1106, 'Original Snowwolf Taze Coil Snowwolf Taze/ P40/ P50 Occ 0.3 Ohm Coil / 0.6 new', 'Original Snowwolf Taze Coil Snowwolf Taze/ P40/ P50 Occ 0.3 Ohm Coil / 0.6 new', 'Original Snowwolf Taze Coil Snowwolf Taze/ P40/ P50 Occ 0.3 Ohm Coil / 0.6 new', 150.00, 'https://cf.shopee.com.my/file/b30016290fda9d9221cea80b5a6588ea', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1107, 'King Black Lens 16mm 0-800 Degree/Power Contact Lens Ready Stock', 'King Black Lens 16mm 0-800 Degree/Power Contact Lens Ready Stock', 'King Black Lens 16mm 0-800 Degree/Power Contact Lens Ready Stock', 85.00, 'https://cf.shopee.com.my/file/b5445b3ff43e9418b2f502973112556f', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1108, 'Pendrive USB2.0/Compatible With USB  (8GB/16GB/32GB/64GB/128GB)', 'Pendrive USB2.0/Compatible With USB  (8GB/16GB/32GB/64GB/128GB)', 'Pendrive USB2.0/Compatible With USB  (8GB/16GB/32GB/64GB/128GB)', 129.00, 'https://cf.shopee.com.my/file/d86eafbabeceaf079e2e7d5b2f67d8ca', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1111, '-1.0 to -4.0 Cermin Mata Rabun Jauh Fashion Accessories Korean Ins Polygon Frame Anti Blue Light Eyeglasses', '-1.0 to -4.0 Cermin Mata Rabun Jauh Fashion Accessories Korean Ins Polygon Frame Anti Blue Light Eyeglasses', '-1.0 to -4.0 Cermin Mata Rabun Jauh Fashion Accessories Korean Ins Polygon Frame Anti Blue Light Eyeglasses', 95.90, 'https://cf.shopee.com.my/file/789169559f9773c5e85b908c413ae2d5', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1112, '5in1 Newborn baby hat set ,Mitten and Booties Combo set ,set sarung tangan kaki dan topi bay baru lahir 0-6months', '5in1 Newborn baby hat set ,Mitten and Booties Combo set ,set sarung tangan kaki dan topi bay baru lahir 0-6months', '5in1 Newborn baby hat set ,Mitten and Booties Combo set ,set sarung tangan kaki dan topi bay baru lahir 0-6months', 89.00, 'https://cf.shopee.com.my/file/d58a9ae27b1f7e61f47205baf5346e4c', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1113, 'Pilot Wingel Gel Ink Pen-0.5mm / 0.7mm', 'Pilot Wingel Gel Ink Pen-0.5mm / 0.7mm', 'Pilot Wingel Gel Ink Pen-0.5mm / 0.7mm', 16.00, 'https://cf.shopee.com.my/file/a969e2a3f2bf59ef7fa75da061489cf3', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1114, '9 Colour Morandi~0.5mm Gel Pens Art Markers Writing Set', '9 Colour Morandi~0.5mm Gel Pens Art Markers Writing Set', '9 Colour Morandi~0.5mm Gel Pens Art Markers Writing Set', 159.00, 'https://cf.shopee.com.my/file/bc511d9e3b5e1afe01e644ef71e9a7d4', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1115, 'Oringinal F9-V5.0 Bluetooth 5.0 Earphone TWS Fingerprint Touch Earphone HiFI Stereo In-Ear Earbud Sports Wireless Earphone', 'Oringinal F9-V5.0 Bluetooth 5.0 Earphone TWS Fingerprint Touch Earphone HiFI Stereo In-Ear Earbud Sports Wireless Earphone', 'Oringinal F9-V5.0 Bluetooth 5.0 Earphone TWS Fingerprint Touch Earphone HiFI Stereo In-Ear Earbud Sports Wireless Earphone', 234.90, 'https://cf.shopee.com.my/file/863dea85e73eec259b5780743eed9a09', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1116, 'Faster CX-1076 0.7mm Ball Pen', 'Faster CX-1076 0.7mm Ball Pen', 'Faster CX-1076 0.7mm Ball Pen', 8.90, 'https://cf.shopee.com.my/file/3e65824a1d3812139a0daf8e3d1f7e22', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1117, 'KastKing Kovert 100% Carbon Sinking Fishing Line Strong Full Fluorocarbon - 46m 183m/4-50LB/0.16-0.7mm', 'KastKing Kovert 100% Carbon Sinking Fishing Line Strong Full Fluorocarbon - 46m 183m/4-50LB/0.16-0.7mm', 'KastKing Kovert 100% Carbon Sinking Fishing Line Strong Full Fluorocarbon - 46m 183m/4-50LB/0.16-0.7mm', 99.90, 'https://cf.shopee.com.my/file/9eef9d0227ca57bdccb37202ee7de633', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1118, 'BIGEYE 20MM EFFECT I.FAIRY ASH KOREAN SOFT COLOR CONTACT LENS [POWER 0 to 850]', 'BIGEYE 20MM EFFECT I.FAIRY ASH KOREAN SOFT COLOR CONTACT LENS [POWER 0 to 850]', 'BIGEYE 20MM EFFECT I.FAIRY ASH KOREAN SOFT COLOR CONTACT LENS [POWER 0 to 850]', 129.80, 'https://cf.shopee.com.my/file/4d0a1845cfd1d37ba074b3370efe8e33', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1119, '[READY STOCK] Xtreme Dirt Cleaner 0.5L - Pencuci Rantai, Enjin, Sportrim dan Lain-lain lagi', '[READY STOCK] Xtreme Dirt Cleaner 0.5L - Pencuci Rantai, Enjin, Sportrim dan Lain-lain lagi', '[READY STOCK] Xtreme Dirt Cleaner 0.5L - Pencuci Rantai, Enjin, Sportrim dan Lain-lain lagi', 99.00, 'https://cf.shopee.com.my/file/ef577a460f9f2eaa529b987b200ccb5c', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1120, 'Artline Drawing System Graphic design Illustrator Document Pen School Office Art Draft Pen 0.8 0.7 0.6 0.5 0.3 EK-2303N', 'Artline Drawing System Graphic design Illustrator Document Pen School Office Art Draft Pen 0.8 0.7 0.6 0.5 0.3 EK-2303N', 'Artline Drawing System Graphic design Illustrator Document Pen School Office Art Draft Pen 0.8 0.7 0.6 0.5 0.3 EK-2303N', 36.00, 'https://cf.shopee.com.my/file/fc570aca1ce1740f5c5e09cd03452b92', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1121, 'Baju Baby Boy Girl Baju Budak Lelaki Perempuan Baju Baby Newborn 0-36m Baby Clothing Baby Romper Baby Clothes Baby Shirt', 'Baju Baby Boy Girl Baju Budak Lelaki Perempuan Baju Baby Newborn 0-36m Baby Clothing Baby Romper Baby Clothes Baby Shirt', 'Baju Baby Boy Girl Baju Budak Lelaki Perempuan Baju Baby Newborn 0-36m Baby Clothing Baby Romper Baby Clothes Baby Shirt', 79.70, 'https://cf.shopee.com.my/file/f28204dbd056ab743c8bbdabd3573a74', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1122, 'KINGSTON PENDRIVE 128gb/16GB / 32GB / 64GB (DT100G3) USB3.0', 'KINGSTON PENDRIVE 128gb/16GB / 32GB / 64GB (DT100G3) USB3.0', 'KINGSTON PENDRIVE 128gb/16GB / 32GB / 64GB (DT100G3) USB3.0', 90.00, 'https://cf.shopee.com.my/file/1e1e12f9544bf8a7f23a12ba7bba2af1', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1123, 'M&G GEL PEN REFILL 0.5mm & 0.7mm', 'M&G GEL PEN REFILL 0.5mm & 0.7mm', 'M&G GEL PEN REFILL 0.5mm & 0.7mm', 5.50, 'https://cf.shopee.com.my/file/139e154f9de04d2b4bb2735b9a362211', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1124, 'ORIGINAL Fajar Cables 14/0.26MM 28/0.26MM Pure Copper Auto Wire Car Lori Automotive Cable 14 28 (30M)', 'ORIGINAL Fajar Cables 14/0.26MM 28/0.26MM Pure Copper Auto Wire Car Lori Automotive Cable 14 28 (30M)', 'ORIGINAL Fajar Cables 14/0.26MM 28/0.26MM Pure Copper Auto Wire Car Lori Automotive Cable 14 28 (30M)', 155.00, 'https://cf.shopee.com.my/file/8dc1943f90791d7c57e4645e12ca2e83', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1125, '*ORIGINAL* FABER CASTLE RX GEL PEN 0.5MM / 0.7MM / BRIGHT COLOUR 0.7mm PRICE IN PCS', '*ORIGINAL* FABER CASTLE RX GEL PEN 0.5MM / 0.7MM / BRIGHT COLOUR 0.7mm PRICE IN PCS', '*ORIGINAL* FABER CASTLE RX GEL PEN 0.5MM / 0.7MM / BRIGHT COLOUR 0.7mm PRICE IN PCS', 13.80, 'https://cf.shopee.com.my/file/53ce773180d8bd109a00b60727eab0e2', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1128, 'Artelac Splash Eye Drops 30 X 0.5ml ( Exp : 11/22 )', 'Artelac Splash Eye Drops 30 X 0.5ml ( Exp : 11/22 )', 'Artelac Splash Eye Drops 30 X 0.5ml ( Exp : 11/22 )', 291.50, 'https://cf.shopee.com.my/file/5d8ba2face276179fdc4d628de252714', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1129, 'Vicks Inhaler 0.5ml / VapoRub 10g & 25g', 'Vicks Inhaler 0.5ml / VapoRub 10g & 25g', 'Vicks Inhaler 0.5ml / VapoRub 10g & 25g', 36.20, 'https://cf.shopee.com.my/file/271d8128c0c47f9a1996065c218ccd90', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1130, 'Original DOT AIO DOTMOD COIL HEAD OCC 0.3 OHM /0.7 OHM / 1.6 OHM / 1.2 ohm GOLD PLATED DOTMOD', 'Original DOT AIO DOTMOD COIL HEAD OCC 0.3 OHM /0.7 OHM / 1.6 OHM / 1.2 ohm GOLD PLATED DOTMOD', 'Original DOT AIO DOTMOD COIL HEAD OCC 0.3 OHM /0.7 OHM / 1.6 OHM / 1.2 ohm GOLD PLATED DOTMOD', 650.00, 'https://cf.shopee.com.my/file/4cf8e6e4d62193fc0eb0e7cc9a4537e5', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1131, 'Organic Succulent Potting Mix (2L / 0.8KG) (Cactus, Haworthia, Echeveria, Aloe, Agave)', 'Organic Succulent Potting Mix (2L / 0.8KG) (Cactus, Haworthia, Echeveria, Aloe, Agave)', 'Organic Succulent Potting Mix (2L / 0.8KG) (Cactus, Haworthia, Echeveria, Aloe, Agave)', 80.00, 'https://cf.shopee.com.my/file/9250b11a410ae227d8a5ab32dc1256b7', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1132, 'Millusion Premium Food Art Pen- Dual Nibs Soft Brush and 0.5mm Nib Edible Pen Cake Writing Muslim Friendly', 'Millusion Premium Food Art Pen- Dual Nibs Soft Brush and 0.5mm Nib Edible Pen Cake Writing Muslim Friendly', 'Millusion Premium Food Art Pen- Dual Nibs Soft Brush and 0.5mm Nib Edible Pen Cake Writing Muslim Friendly', 60.00, 'https://cf.shopee.com.my/file/4fcb60e2b1929736974c5219be88708e', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1134, '1 Pcs 32 inch  0-9 Numbers Foil Balloon Wedding Anniversary Birthday Decor ROSE GOLD/ RAINBOW/ GOLD/ SILVER', '1 Pcs 32 inch  0-9 Numbers Foil Balloon Wedding Anniversary Birthday Decor ROSE GOLD/ RAINBOW/ GOLD/ SILVER', '1 Pcs 32 inch  0-9 Numbers Foil Balloon Wedding Anniversary Birthday Decor ROSE GOLD/ RAINBOW/ GOLD/ SILVER', 42.70, 'https://cf.shopee.com.my/file/e644a864353efb186e91025e297f967f', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1135, 'HDMI Extension Extender Cable 1.4V Male to Female HDTV PC 30CM 50cm 100cm 0.3m 0.5m 1m 1.5m 2m 3m', 'HDMI Extension Extender Cable 1.4V Male to Female HDTV PC 30CM 50cm 100cm 0.3m 0.5m 1m 1.5m 2m 3m', 'HDMI Extension Extender Cable 1.4V Male to Female HDTV PC 30CM 50cm 100cm 0.3m 0.5m 1m 1.5m 2m 3m', 120.00, 'https://cf.shopee.com.my/file/a2e0a6a8327bada7d26ee8a97f7336c7', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1136, '0.2mm Glitter Powder Ultra Fine Dust 15g Snow Glitter in 17 Colors Gold Dust Rainbow Powder for Crafts Slime DIY Nails', '0.2mm Glitter Powder Ultra Fine Dust 15g Snow Glitter in 17 Colors Gold Dust Rainbow Powder for Crafts Slime DIY Nails', '0.2mm Glitter Powder Ultra Fine Dust 15g Snow Glitter in 17 Colors Gold Dust Rainbow Powder for Crafts Slime DIY Nails', 30.00, 'https://cf.shopee.com.my/file/7584dbece1b1e2caa8700d7f9c81d083', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1137, 'Frontline Combo Spot - On Cat 1.5ml (0.5ml x 3 pipet)-1 box', 'Frontline Combo Spot - On Cat 1.5ml (0.5ml x 3 pipet)-1 box', 'Frontline Combo Spot - On Cat 1.5ml (0.5ml x 3 pipet)-1 box', 550.00, 'https://cf.shopee.com.my/file/9d78670d2a839aeddfdc1f3743fa9882', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1140, 'Astar MP-X5 / X7 (0.5mm / 0.7mm) Shaker Mechanical Pencil / Pencil Picit Shaker / Pencil Tekan Shaker', 'Astar MP-X5 / X7 (0.5mm / 0.7mm) Shaker Mechanical Pencil / Pencil Picit Shaker / Pencil Tekan Shaker', 'Astar MP-X5 / X7 (0.5mm / 0.7mm) Shaker Mechanical Pencil / Pencil Picit Shaker / Pencil Tekan Shaker', 11.90, 'https://cf.shopee.com.my/file/80cb865d7ae5b165890115487c29ba3d', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1141, 'Winzige 10 Colors 0.5mm Gel Pens Office School Supplies Student Gel Pen', 'Winzige 10 Colors 0.5mm Gel Pens Office School Supplies Student Gel Pen', 'Winzige 10 Colors 0.5mm Gel Pens Office School Supplies Student Gel Pen', 9.80, 'https://cf.shopee.com.my/file/e4f2543eccb0c819c2413dfb065ca606', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1142, 'Jim Dunlop HETFIELD\'S WHITE FANG GUITAR PICK (0.73mm , 1.00mm, 1.14mm)', 'Jim Dunlop HETFIELD\'S WHITE FANG GUITAR PICK (0.73mm , 1.00mm, 1.14mm)', 'Jim Dunlop HETFIELD\'S WHITE FANG GUITAR PICK (0.73mm , 1.00mm, 1.14mm)', 55.00, 'https://cf.shopee.com.my/file/0864190e42cbb49c1d61470e1e85933f', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1143, 'TOPK I1006P 18W QC3.0 10000mAh Powerbank Quick Charge Digital Display Power Bank Backup Battery for iPhone HUAWEI Samsung Xiaomi OPPO Vivo Realme', 'TOPK I1006P 18W QC3.0 10000mAh Powerbank Quick Charge Digital Display Power Bank Backup Battery for iPhone HUAWEI Samsung Xiaomi OPPO Vivo Realme', 'TOPK I1006P 18W QC3.0 10000mAh Powerbank Quick Charge Digital Display Power Bank Backup Battery for iPhone HUAWEI Samsung Xiaomi OPPO Vivo Realme', 419.80, 'https://cf.shopee.com.my/file/a1f61845ed999a221fc36de30755f092', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1144, 'Mcdodo Auto Disconnect 2.4A QC3.0 For mcdodo iPhone cable CA 390 / mcdodo Type-C cable CA 288 / mcdodo Micro cable CA289', 'Mcdodo Auto Disconnect 2.4A QC3.0 For mcdodo iPhone cable CA 390 / mcdodo Type-C cable CA 288 / mcdodo Micro cable CA289', 'Mcdodo Auto Disconnect 2.4A QC3.0 For mcdodo iPhone cable CA 390 / mcdodo Type-C cable CA 288 / mcdodo Micro cable CA289', 185.00, 'https://cf.shopee.com.my/file/7f9455d730c0383b92f5e19aa8850635', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1145, 'NEW OCC NEVOKS 0.8 / 1.0 / 0.6 - CATRIDGE 1PCS / 2PCS', 'NEW OCC NEVOKS 0.8 / 1.0 / 0.6 - CATRIDGE 1PCS / 2PCS', 'NEW OCC NEVOKS 0.8 / 1.0 / 0.6 - CATRIDGE 1PCS / 2PCS', 140.00, 'https://cf.shopee.com.my/file/7aef67597cd183c61b42109ee04d261d', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1147, '[READY STOCK] Adidas Performance 0.75L Water Bottle', '[READY STOCK] Adidas Performance 0.75L Water Bottle', '[READY STOCK] Adidas Performance 0.75L Water Bottle', 290.00, 'https://cf.shopee.com.my/file/02087246e93bd372d67856dd39d7727d', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1148, 'KTH Putty Filler Filling Cracks and Holes (0.5KG) - White', 'KTH Putty Filler Filling Cracks and Holes (0.5KG) - White', 'KTH Putty Filler Filling Cracks and Holes (0.5KG) - White', 37.90, 'https://cf.shopee.com.my/file/0ccea72fd0cc8c421fdd4ec27b939897', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1149, 'POWER 0-950degree  ORIGINAL Maki Gray Grey Brown Blue lens by Dreamcolor + FREE CASE & mini Lens viral TikTok', 'POWER 0-950degree  ORIGINAL Maki Gray Grey Brown Blue lens by Dreamcolor + FREE CASE & mini Lens viral TikTok', 'POWER 0-950degree  ORIGINAL Maki Gray Grey Brown Blue lens by Dreamcolor + FREE CASE & mini Lens viral TikTok', 200.00, 'https://cf.shopee.com.my/file/f3c969c851b7d22b389a8295bb5af95e', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1150, 'Pilot Pop Lol 0.7mm Gel Pen (Part 1)', 'Pilot Pop Lol 0.7mm Gel Pen (Part 1)', 'Pilot Pop Lol 0.7mm Gel Pen (Part 1)', 29.90, 'https://cf.shopee.com.my/file/539af2141d5276d48d8fa255440134a7', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1151, 'G\'soft BP-GS-GM7 Color Ball Pen 0.7mm (7 Colors Available)', 'G\'soft BP-GS-GM7 Color Ball Pen 0.7mm (7 Colors Available)', 'G\'soft BP-GS-GM7 Color Ball Pen 0.7mm (7 Colors Available)', 5.50, 'https://cf.shopee.com.my/file/c79abbdd6691fc19082a6a97e7d85024', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1152, 'Faber Castell Click X Ball Pen / 1425 Click X5 0.5mm / 1422 Click X7 0.7mm', 'Faber Castell Click X Ball Pen / 1425 Click X5 0.5mm / 1422 Click X7 0.7mm', 'Faber Castell Click X Ball Pen / 1425 Click X5 0.5mm / 1422 Click X7 0.7mm', 6.00, 'https://cf.shopee.com.my/file/0b3b3c4d2189deabc23115a3c31222aa', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1153, 'ZMI Apple MFi Certified Premium Lightning to USB Cable PP Braided Sleeve (0.3M/1M/2M)', 'ZMI Apple MFi Certified Premium Lightning to USB Cable PP Braided Sleeve (0.3M/1M/2M)', 'ZMI Apple MFi Certified Premium Lightning to USB Cable PP Braided Sleeve (0.3M/1M/2M)', 345.00, 'https://cf.shopee.com.my/file/fe45f170c7d292738e254dbd81131228', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1154, 'Baby Socks Baby Non-slip Socks Baby 0-12M', 'Baby Socks Baby Non-slip Socks Baby 0-12M', 'Baby Socks Baby Non-slip Socks Baby 0-12M', 27.80, 'https://cf.shopee.com.my/file/1052d470c256d857030917249401e053', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1155, 'Fixguru. Bubble Wrap Rolls Single & Double Layer AAA High Quality/Clear & Black 1m x 10m / 0.5m x 10m', 'Fixguru. Bubble Wrap Rolls Single & Double Layer AAA High Quality/Clear & Black 1m x 10m / 0.5m x 10m', 'Fixguru. Bubble Wrap Rolls Single & Double Layer AAA High Quality/Clear & Black 1m x 10m / 0.5m x 10m', 65.00, 'https://cf.shopee.com.my/file/d52f9117f3c419c3e95982c965af1a45', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1156, 'Set Alloy Open Jump Rings Mixed  0.7x5mm, 12mmLobster Clasps,Jewelry Pliers,For DIY Jewelry Making Supplies Necklace Repair', 'Set Alloy Open Jump Rings Mixed  0.7x5mm, 12mmLobster Clasps,Jewelry Pliers,For DIY Jewelry Making Supplies Necklace Repair', 'Set Alloy Open Jump Rings Mixed  0.7x5mm, 12mmLobster Clasps,Jewelry Pliers,For DIY Jewelry Making Supplies Necklace Repair', 97.90, 'https://cf.shopee.com.my/file/dbb57c511f0c0d76308832e01ec372e9', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1157, 'Faber Castell Gel Pen RX5 RX7 GelPen 0.5mm 0.7mm', 'Faber Castell Gel Pen RX5 RX7 GelPen 0.5mm 0.7mm', 'Faber Castell Gel Pen RX5 RX7 GelPen 0.5mm 0.7mm', 13.90, 'https://cf.shopee.com.my/file/d00ac4572f4c7b235665c231b1b46248', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1159, 'Milux Personal Rice Cooker - Random Colour (0.3L) MRC-703', 'Milux Personal Rice Cooker - Random Colour (0.3L) MRC-703', 'Milux Personal Rice Cooker - Random Colour (0.3L) MRC-703', 520.00, 'https://cf.shopee.com.my/file/3a30f1a3931fe58afa8cc0cd892bb327', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1160, 'Amalagrosir - Hijab Children Anisa Renda Age 0-3 Years Old Non Pet / K2-C2-3 Years', 'Amalagrosir - Hijab Children Anisa Renda Age 0-3 Years Old Non Pet / K2-C2-3 Years', 'Amalagrosir - Hijab Children Anisa Renda Age 0-3 Years Old Non Pet / K2-C2-3 Years', 53.10, 'https://cf.shopee.com.my/file/b97de5b9064766e7af6e1e79e2b86ea6', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1161, '(LOCK LIVE ONLY) Baju Bundle Baby 0-24 Bulan', '(LOCK LIVE ONLY) Baju Bundle Baby 0-24 Bulan', '(LOCK LIVE ONLY) Baju Bundle Baby 0-24 Bulan', 10.00, 'https://cf.shopee.com.my/file/f42e01624dcd6ea2ad6b02cbf3db1b3f', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1164, 'BUNCHO 2B PENCIL LEAD 0.5MM ( 4PCS )', 'BUNCHO 2B PENCIL LEAD 0.5MM ( 4PCS )', 'BUNCHO 2B PENCIL LEAD 0.5MM ( 4PCS )', 23.70, 'https://cf.shopee.com.my/file/e3185f0fd110c3b01bad71b8a8aa635c', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1166, 'ORICO TWU3 Series 4/7 Port USB2.0/USB3.0 Hub with Type C Power Input', 'ORICO TWU3 Series 4/7 Port USB2.0/USB3.0 Hub with Type C Power Input', 'ORICO TWU3 Series 4/7 Port USB2.0/USB3.0 Hub with Type C Power Input', 199.00, 'https://cf.shopee.com.my/file/68dd2d5e5e39c789c4b079410480b38f', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1167, 'PILOT REXGRIP Ball Point PEN / REFILL 0.5/0.7/1.0mm (BLACK/ BLUE/ RED)', 'PILOT REXGRIP Ball Point PEN / REFILL 0.5/0.7/1.0mm (BLACK/ BLUE/ RED)', 'PILOT REXGRIP Ball Point PEN / REFILL 0.5/0.7/1.0mm (BLACK/ BLUE/ RED)', 16.90, 'https://cf.shopee.com.my/file/736de2525fccb96f2202358792418a78', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1168, 'Tikar Getah 20m x 1.83m (6 kaki) Tebal 0.4mm PVC Vinyl Carpet Flooring Rug Mat Canopy Karpet Velvet Toto Khemah Kanopi', 'Tikar Getah 20m x 1.83m (6 kaki) Tebal 0.4mm PVC Vinyl Carpet Flooring Rug Mat Canopy Karpet Velvet Toto Khemah Kanopi', 'Tikar Getah 20m x 1.83m (6 kaki) Tebal 0.4mm PVC Vinyl Carpet Flooring Rug Mat Canopy Karpet Velvet Toto Khemah Kanopi', 1155.00, 'https://cf.shopee.com.my/file/8468eb05cd51de2fc783a3d2dec3b335', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1169, 'LOGITECH C270 HD Video 720P Webcam Built-in Micphone USB2.0 Mini Computer Camera for PC Laptop Video Conference Camera ', 'LOGITECH C270 HD Video 720P Webcam Built-in Micphone USB2.0 Mini Computer Camera for PC Laptop Video Conference Camera ', 'LOGITECH C270 HD Video 720P Webcam Built-in Micphone USB2.0 Mini Computer Camera for PC Laptop Video Conference Camera ', 1290.00, 'https://cf.shopee.com.my/file/b5e1d9603eb1925efe02d081a5c0febb', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1170, 'Anakku Disney Baby Girl Newborn Romper Snap-on Button Rompers Baju Bayi Perempuan [0-12 Months] EDS238-2', 'Anakku Disney Baby Girl Newborn Romper Snap-on Button Rompers Baju Bayi Perempuan [0-12 Months] EDS238-2', 'Anakku Disney Baby Girl Newborn Romper Snap-on Button Rompers Baju Bayi Perempuan [0-12 Months] EDS238-2', 180.00, 'https://cf.shopee.com.my/file/b68a1e66097021ec357ca3f77821dae3', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1171, 'Ready Stock Cute Cartoon Short Sleeves Rompers Newborn Cloths Baby Jumpsuits Baby Clothing Coveralls Infant Boy Girl Clothe Newborn Pajamas Cotton 0-18months', 'Ready Stock Cute Cartoon Short Sleeves Rompers Newborn Cloths Baby Jumpsuits Baby Clothing Coveralls Infant Boy Girl Clothe Newborn Pajamas Cotton 0-18months', 'Ready Stock Cute Cartoon Short Sleeves Rompers Newborn Cloths Baby Jumpsuits Baby Clothing Coveralls Infant Boy Girl Clothe Newborn Pajamas Cotton 0-18months', 58.80, 'https://cf.shopee.com.my/file/34845497d222d17f4bb6f58860a1ecaf', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1172, 'Premium Heavy Como Crepe 60\' / Kain Pasang (0.5M)', 'Premium Heavy Como Crepe 60\' / Kain Pasang (0.5M)', 'Premium Heavy Como Crepe 60\' / Kain Pasang (0.5M)', 27.50, 'https://cf.shopee.com.my/file/5b2b663fc399a5c825d94e2e16829152', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1173, '0-6.5mm Flexible Shaft Flex Shaft For Electric Drill Die Grinder 6mm Rotary Tool Mesin Korek Porting Polishing', '0-6.5mm Flexible Shaft Flex Shaft For Electric Drill Die Grinder 6mm Rotary Tool Mesin Korek Porting Polishing', '0-6.5mm Flexible Shaft Flex Shaft For Electric Drill Die Grinder 6mm Rotary Tool Mesin Korek Porting Polishing', 69.00, 'https://cf.shopee.com.my/file/795bc34bb66f939acf24fe4c59b9551e', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1174, '[2020]Pilot Rexgrip Mechanical Pencil 0.5mm 0.7mm', '[2020]Pilot Rexgrip Mechanical Pencil 0.5mm 0.7mm', '[2020]Pilot Rexgrip Mechanical Pencil 0.5mm 0.7mm', 37.50, 'https://cf.shopee.com.my/file/ec685f650a88c4e4c24b1f18fd61fb2e', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1175, '6ft Tikar Getah Quality,buatan Thailand,Tebal 0.60mm', '6ft Tikar Getah Quality,buatan Thailand,Tebal 0.60mm', '6ft Tikar Getah Quality,buatan Thailand,Tebal 0.60mm', 67.50, 'https://cf.shopee.com.my/file/4f759bc38da4f56303009f3da7cf02c3', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1176, '(Promo) Loket Emas 916 0.04g', '(Promo) Loket Emas 916 0.04g', '(Promo) Loket Emas 916 0.04g', 20.00, 'https://cf.shopee.com.my/file/87a926ebf1aa4f68f08fc2b07a2a395f', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1178, 'Artline Stamp Pad No. 00 EHJ-1, No. 0 EHJ-2, No. 1 EHJ-3, No. 2 EHJ-4 Stamppad', 'Artline Stamp Pad No. 00 EHJ-1, No. 0 EHJ-2, No. 1 EHJ-3, No. 2 EHJ-4 Stamppad', 'Artline Stamp Pad No. 00 EHJ-1, No. 0 EHJ-2, No. 1 EHJ-3, No. 2 EHJ-4 Stamppad', 57.00, 'https://cf.shopee.com.my/file/49ea1ce510a7d07bb08e2ef056c4eb49', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1179, 'Kids Tales Newborn Infat Toddler Sleepsuit Pajama Baby Boys Girls Cotton Graphic Zipper Romper Long Sleeve 0-3 Years', 'Kids Tales Newborn Infat Toddler Sleepsuit Pajama Baby Boys Girls Cotton Graphic Zipper Romper Long Sleeve 0-3 Years', 'Kids Tales Newborn Infat Toddler Sleepsuit Pajama Baby Boys Girls Cotton Graphic Zipper Romper Long Sleeve 0-3 Years', 279.00, 'https://cf.shopee.com.my/file/4ade269f998bb55c2ffcb4c114028b66', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1180, '2020 Newborn hat cute kid girl soft baby hat wool hat knit crochet 0-6M spot', '2020 Newborn hat cute kid girl soft baby hat wool hat knit crochet 0-6M spot', '2020 Newborn hat cute kid girl soft baby hat wool hat knit crochet 0-6M spot', 129.90, 'https://cf.shopee.com.my/file/8fd48ebc716f57ee8f80164df484a067', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1182, 'Ready Stock 0-4Y baby dress Summer kids cotton rabbit dress Princess dress children sleeveless set', 'Ready Stock 0-4Y baby dress Summer kids cotton rabbit dress Princess dress children sleeveless set', 'Ready Stock 0-4Y baby dress Summer kids cotton rabbit dress Princess dress children sleeveless set', 184.00, 'https://cf.shopee.com.my/file/54124f93d7e74bd4230f60dff0201c26', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1183, 'Local Seller Ready stock 0-12M baby rompers Newborn Infant Baby Boy Girl Short sleeve kids clothes', 'Local Seller Ready stock 0-12M baby rompers Newborn Infant Baby Boy Girl Short sleeve kids clothes', 'Local Seller Ready stock 0-12M baby rompers Newborn Infant Baby Boy Girl Short sleeve kids clothes', 99.90, 'https://cf.shopee.com.my/file/5066571d6e793971d2cc29bde5b02243', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1184, 'READY STOCK!!! BARUT BABY BERTALI PUTIH 100% COTTON , PLAIN WHITE BABY BINDER NEWBORN 0-4 MONTHS', 'READY STOCK!!! BARUT BABY BERTALI PUTIH 100% COTTON , PLAIN WHITE BABY BINDER NEWBORN 0-4 MONTHS', 'READY STOCK!!! BARUT BABY BERTALI PUTIH 100% COTTON , PLAIN WHITE BABY BINDER NEWBORN 0-4 MONTHS', 29.90, 'https://cf.shopee.com.my/file/3d84a15e06b49283b2459e3e9f36adbe', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1186, 'Watch Winder Single Double 1+0 2+0 4+6 Automatic Watch Automatic Rotating Meter Watch Box [Ready Stock] [Ship from KL]', 'Watch Winder Single Double 1+0 2+0 4+6 Automatic Watch Automatic Rotating Meter Watch Box [Ready Stock] [Ship from KL]', 'Watch Winder Single Double 1+0 2+0 4+6 Automatic Watch Automatic Rotating Meter Watch Box [Ready Stock] [Ship from KL]', 870.00, 'https://cf.shopee.com.my/file/3b006b08f8bc6f83e29dc11b15e31227', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1187, 'Cranflex Kertas Gasket Paper 0.4mm Petrol Oil Fuel Resistance (made in England)', 'Cranflex Kertas Gasket Paper 0.4mm Petrol Oil Fuel Resistance (made in England)', 'Cranflex Kertas Gasket Paper 0.4mm Petrol Oil Fuel Resistance (made in England)', 85.00, 'https://cf.shopee.com.my/file/0ba15a74aff2b19516d1c3d4f985b456', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1189, '[1TB/2TB/4TB] TOSHIBA CANVIO BASIC 2.5\" EXT EXTERNAL HARDDISK HARD DRIVE SUPERSPEED USB3.0 PORTABLE HARD DISK FREE POUCH', '[1TB/2TB/4TB] TOSHIBA CANVIO BASIC 2.5\" EXT EXTERNAL HARDDISK HARD DRIVE SUPERSPEED USB3.0 PORTABLE HARD DISK FREE POUCH', '[1TB/2TB/4TB] TOSHIBA CANVIO BASIC 2.5\" EXT EXTERNAL HARDDISK HARD DRIVE SUPERSPEED USB3.0 PORTABLE HARD DISK FREE POUCH', 1680.00, 'https://cf.shopee.com.my/file/ac0009d8325f4232f7f97d84545d09d7', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1190, '0-12M Baby Boys Girls Cartoon Shoes Infant Toddler Newborn Anti Slip Footwear', '0-12M Baby Boys Girls Cartoon Shoes Infant Toddler Newborn Anti Slip Footwear', '0-12M Baby Boys Girls Cartoon Shoes Infant Toddler Newborn Anti Slip Footwear', 53.80, 'https://cf.shopee.com.my/file/062f2cf88dc9da9d5ac11b285540ae14', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1191, '[ORIGINAL] Philips Avent BPA Free Mini Pacifier 0-2 Month Newborn Puting with Snap-on cap (Loose Or Twin Pack)', '[ORIGINAL] Philips Avent BPA Free Mini Pacifier 0-2 Month Newborn Puting with Snap-on cap (Loose Or Twin Pack)', '[ORIGINAL] Philips Avent BPA Free Mini Pacifier 0-2 Month Newborn Puting with Snap-on cap (Loose Or Twin Pack)', 140.00, 'https://cf.shopee.com.my/file/43fab4b989203de2ec621bdf6ffbdb08', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1193, 'Philips Avent Classic Baby Pacifier Soother 0-6m (2pcs)', 'Philips Avent Classic Baby Pacifier Soother 0-6m (2pcs)', 'Philips Avent Classic Baby Pacifier Soother 0-6m (2pcs)', 318.80, 'https://cf.shopee.com.my/file/a591aaef450039a6735d9c3f4e3a25c3', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1196, 'Susu dutch baby 0-12,6-18,1-3', 'Susu dutch baby 0-12,6-18,1-3', 'Susu dutch baby 0-12,6-18,1-3', 98.00, 'https://cf.shopee.com.my/file/ef251b430b2868387e20209d839cf640', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1198, 'Sofirn SP33 V3.0 Powerful LED Flashlight Cree XHP50.2 3500lm Type-C USB Rechargeable Torch Ramping Mode', 'Sofirn SP33 V3.0 Powerful LED Flashlight Cree XHP50.2 3500lm Type-C USB Rechargeable Torch Ramping Mode', 'Sofirn SP33 V3.0 Powerful LED Flashlight Cree XHP50.2 3500lm Type-C USB Rechargeable Torch Ramping Mode', 1160.00, 'https://cf.shopee.com.my/file/803f83c2d7303b6f6d731c302a2bfa6b', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1199, '( BJ 0263 ) 0.5\"-3.0\" getah pinggang hitam jual meter', '( BJ 0263 ) 0.5\"-3.0\" getah pinggang hitam jual meter', '( BJ 0263 ) 0.5\"-3.0\" getah pinggang hitam jual meter', 13.00, 'https://cf.shopee.com.my/file/1fa745731b175459491f3657d48db59e', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1200, '3Pcs Short Sleeves New Born Baju Baby(0-6Mths)', '3Pcs Short Sleeves New Born Baju Baby(0-6Mths)', '3Pcs Short Sleeves New Born Baju Baby(0-6Mths)', 205.00, 'https://cf.shopee.com.my/file/7fe1c6525370323a715dbc558514e29b', 1627909667, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1201, 'Tudung Kanak-Kanak dan Newborn Baby Girl Budak 0-3tahun Infant Children Headscarf Kid\'s', 'Tudung Kanak-Kanak dan Newborn Baby Girl Budak 0-3tahun Infant Children Headscarf Kid\'s', 'Tudung Kanak-Kanak dan Newborn Baby Girl Budak 0-3tahun Infant Children Headscarf Kid\'s', 90.50, 'https://cf.shopee.com.my/file/2356087202e71d54c3f21f14256402c5', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1203, 'Mcdodo 0.5m 1.2m 1.8m 3m Gaming Cable 90 Degree Fast Charging Cable for Apple iPhone Android Micro Usb / Type-C phone', 'Mcdodo 0.5m 1.2m 1.8m 3m Gaming Cable 90 Degree Fast Charging Cable for Apple iPhone Android Micro Usb / Type-C phone', 'Mcdodo 0.5m 1.2m 1.8m 3m Gaming Cable 90 Degree Fast Charging Cable for Apple iPhone Android Micro Usb / Type-C phone', 100.00, 'https://cf.shopee.com.my/file/1798466946e193873e7c8033a2e492f1', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1204, '[CHEAPEST AND FAST] WinRAR 6.0 | Lifetime | Full Version', '[CHEAPEST AND FAST] WinRAR 6.0 | Lifetime | Full Version', '[CHEAPEST AND FAST] WinRAR 6.0 | Lifetime | Full Version', 10.00, 'https://cf.shopee.com.my/file/b5a71e1bfa3593f98fdf7525b79e3e06', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1205, 'LOWEST PRICE* Roze 14mm Natural Size Contact Lens/Color Lens Original Korea Lens ( Power 0-600 )', 'LOWEST PRICE* Roze 14mm Natural Size Contact Lens/Color Lens Original Korea Lens ( Power 0-600 )', 'LOWEST PRICE* Roze 14mm Natural Size Contact Lens/Color Lens Original Korea Lens ( Power 0-600 )', 59.00, 'https://cf.shopee.com.my/file/32fd28e3f43e0bfae0b1c9faa119cf5d', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1206, 'Ready Stock Original Uwell Caliburn G OCC Cartridge 0.8 OCC 1.0 OCC Caliburn G Driptip', 'Ready Stock Original Uwell Caliburn G OCC Cartridge 0.8 OCC 1.0 OCC Caliburn G Driptip', 'Ready Stock Original Uwell Caliburn G OCC Cartridge 0.8 OCC 1.0 OCC Caliburn G Driptip', 68.00, 'https://cf.shopee.com.my/file/643d246f553a9989c13357e40656f5e6', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1207, '[SAMEDAY] Original SMOK NFIX Cartridge DC 0.8 MTL & Mesh 0.8', '[SAMEDAY] Original SMOK NFIX Cartridge DC 0.8 MTL & Mesh 0.8', '[SAMEDAY] Original SMOK NFIX Cartridge DC 0.8 MTL & Mesh 0.8', 249.00, 'https://cf.shopee.com.my/file/063661f99ad67eddf566b1a7f23adf53', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1208, 'GENUINE SMOK RPM Occ RPM 2 Coils Occ RBA Mesh Coil 0.3 0.4 0.6 0.8 1.0 1.2 Ohm COMPATIBLE RPM 2/SCAR P3/SCAR P5 / IPX80', 'GENUINE SMOK RPM Occ RPM 2 Coils Occ RBA Mesh Coil 0.3 0.4 0.6 0.8 1.0 1.2 Ohm COMPATIBLE RPM 2/SCAR P3/SCAR P5 / IPX80', 'GENUINE SMOK RPM Occ RPM 2 Coils Occ RBA Mesh Coil 0.3 0.4 0.6 0.8 1.0 1.2 Ohm COMPATIBLE RPM 2/SCAR P3/SCAR P5 / IPX80', 119.90, 'https://cf.shopee.com.my/file/9b010bfb9c1934a513c5b3178fad7ec1', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1209, '[READY STOCK] Bubblewrap Bubble Wrap Single/Double 1mX100m /0.5mX100m (FOR URGENT ORDER, 1-3 Days - J & T Ship)', '[READY STOCK] Bubblewrap Bubble Wrap Single/Double 1mX100m /0.5mX100m (FOR URGENT ORDER, 1-3 Days - J & T Ship)', '[READY STOCK] Bubblewrap Bubble Wrap Single/Double 1mX100m /0.5mX100m (FOR URGENT ORDER, 1-3 Days - J & T Ship)', 320.00, 'https://cf.shopee.com.my/file/2a49ee03b7c108101940d98deb6fb7dc', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1210, 'Muji Style Gel Pen 12 Pcs/Box Simple Gel Pen Quick-Drying Writing Pen 0.5mm Signature Pen Black Red Blue Ink For School Office Stationery', 'Muji Style Gel Pen 12 Pcs/Box Simple Gel Pen Quick-Drying Writing Pen 0.5mm Signature Pen Black Red Blue Ink For School Office Stationery', 'Muji Style Gel Pen 12 Pcs/Box Simple Gel Pen Quick-Drying Writing Pen 0.5mm Signature Pen Black Red Blue Ink For School Office Stationery', 54.00, 'https://cf.shopee.com.my/file/ddef41f2d99f86b0820dac19342bddd4', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1211, 'RESTOCK Nudy Grey/Brown 16mm 0-800 Power contact lens (big eyes effect) BEST SELLER!', 'RESTOCK Nudy Grey/Brown 16mm 0-800 Power contact lens (big eyes effect) BEST SELLER!', 'RESTOCK Nudy Grey/Brown 16mm 0-800 Power contact lens (big eyes effect) BEST SELLER!', 96.00, 'https://cf.shopee.com.my/file/2ecd5ef6175dec6c23c4914d0819eb98', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1212, 'Aluminum Crochet Hook Weave Knit Hand Woven Tool(2.0-10mm)', 'Aluminum Crochet Hook Weave Knit Hand Woven Tool(2.0-10mm)', 'Aluminum Crochet Hook Weave Knit Hand Woven Tool(2.0-10mm)', 23.00, 'https://cf.shopee.com.my/file/f085e07dea076ef40be192b75a11d7ab', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1213, 'Bayer Advantage Cat Spot On - S (0.4ml x 4 pipet) / M (0.8ml x 4 pipet) Flea Treament / Ubat Kutu Kucing', 'Bayer Advantage Cat Spot On - S (0.4ml x 4 pipet) / M (0.8ml x 4 pipet) Flea Treament / Ubat Kutu Kucing', 'Bayer Advantage Cat Spot On - S (0.4ml x 4 pipet) / M (0.8ml x 4 pipet) Flea Treament / Ubat Kutu Kucing', 409.90, 'https://cf.shopee.com.my/file/cb00f768726ca67e7d1a55002c4a9e0e', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1214, 'NEW IDOL MADE SERIES 14mm Natural Size Contact Lens/Color Lens Original Korea Lens ( Power 0-700 )', 'NEW IDOL MADE SERIES 14mm Natural Size Contact Lens/Color Lens Original Korea Lens ( Power 0-700 )', 'NEW IDOL MADE SERIES 14mm Natural Size Contact Lens/Color Lens Original Korea Lens ( Power 0-700 )', 99.00, 'https://cf.shopee.com.my/file/f6e711f559d4742babc6e534289299f5', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1215, 'Polarizer TV Tinted Film Polarizing LCD LTC Led Repair Tv Replacement Film 15in to 24in 45/0/90/135 degree', 'Polarizer TV Tinted Film Polarizing LCD LTC Led Repair Tv Replacement Film 15in to 24in 45/0/90/135 degree', 'Polarizer TV Tinted Film Polarizing LCD LTC Led Repair Tv Replacement Film 15in to 24in 45/0/90/135 degree', 179.00, 'https://cf.shopee.com.my/file/1fc2ecccc9e3f99776db905ca8c7e62b', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1216, '10Meters/lot 0.8/1.0mm Nylon Cord Thread Chinese Knot Macrame Cord Bracelet Braided String DIY Tassels Beading String Thread', '10Meters/lot 0.8/1.0mm Nylon Cord Thread Chinese Knot Macrame Cord Bracelet Braided String DIY Tassels Beading String Thread', '10Meters/lot 0.8/1.0mm Nylon Cord Thread Chinese Knot Macrame Cord Bracelet Braided String DIY Tassels Beading String Thread', 20.50, 'https://cf.shopee.com.my/file/15b60612a8d2f07559832d38d050e60b', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1217, 'Sakura Pen-Touch Extra Fine Marker 0.7mm | Gold Silver White Copper | Pentouch', 'Sakura Pen-Touch Extra Fine Marker 0.7mm | Gold Silver White Copper | Pentouch', 'Sakura Pen-Touch Extra Fine Marker 0.7mm | Gold Silver White Copper | Pentouch', 79.00, 'https://cf.shopee.com.my/file/dfe936e225143c9c970de9aa8250d375', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1218, 'Getah Lastik Presice (3 unit) Saiz 0.7mm', 'Getah Lastik Presice (3 unit) Saiz 0.7mm', 'Getah Lastik Presice (3 unit) Saiz 0.7mm', 120.00, 'https://cf.shopee.com.my/file/b5ff5616324da300ab126287b5337a9a', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1219, 'Assist Hook Micro light jig. by SCjigger. saiz  2# 1# 1/0 2/0 3/0 double Hook.HARGA 1 PC', 'Assist Hook Micro light jig. by SCjigger. saiz  2# 1# 1/0 2/0 3/0 double Hook.HARGA 1 PC', 'Assist Hook Micro light jig. by SCjigger. saiz  2# 1# 1/0 2/0 3/0 double Hook.HARGA 1 PC', 35.00, 'https://cf.shopee.com.my/file/876cfce9280223f1ed82a778b9c3cdf5', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1220, '1pc  Cartoon Gel Pen Owl Bear Cat Kitten Gel Pen 0.5mm Stationery Black Ink Office School Door Gift', '1pc  Cartoon Gel Pen Owl Bear Cat Kitten Gel Pen 0.5mm Stationery Black Ink Office School Door Gift', '1pc  Cartoon Gel Pen Owl Bear Cat Kitten Gel Pen 0.5mm Stationery Black Ink Office School Door Gift', 5.90, 'https://cf.shopee.com.my/file/a19b3452226b36e60b6081c1f4d4d7f9', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1221, 'Ready Stock Original Nevoks OCC Coil 0.6 Ohm Mesh', 'Ready Stock Original Nevoks OCC Coil 0.6 Ohm Mesh', 'Ready Stock Original Nevoks OCC Coil 0.6 Ohm Mesh', 340.00, 'https://cf.shopee.com.my/file/acbf73c00a0e01b6b386c5ad8f7fd720', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1222, 'Blink Vision 0 to -6.00 New Anti Blue Light Square Rabun Jauh Cermin Mata Finished Myopia Power Lens Meter Nail Eyeglasses Frame Korean Style Student Spek Mata Custom Lens', 'Blink Vision 0 to -6.00 New Anti Blue Light Square Rabun Jauh Cermin Mata Finished Myopia Power Lens Meter Nail Eyeglasses Frame Korean Style Student Spek Mata Custom Lens', 'Blink Vision 0 to -6.00 New Anti Blue Light Square Rabun Jauh Cermin Mata Finished Myopia Power Lens Meter Nail Eyeglasses Frame Korean Style Student Spek Mata Custom Lens', 78.40, 'https://cf.shopee.com.my/file/d43a42d0db4acdd8404b944a27611979', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1223, 'CLEANN Kitchen Wipes 80 sheet/Pack (Disinfect, Anti-Bacterial, Remove Oil & Grease, 0% Alcohol) Tissue Basah Dapur', 'CLEANN Kitchen Wipes 80 sheet/Pack (Disinfect, Anti-Bacterial, Remove Oil & Grease, 0% Alcohol) Tissue Basah Dapur', 'CLEANN Kitchen Wipes 80 sheet/Pack (Disinfect, Anti-Bacterial, Remove Oil & Grease, 0% Alcohol) Tissue Basah Dapur', 136.50, 'https://cf.shopee.com.my/file/59c6e0d932deffcdce1fbf7ab850eef3', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1224, 'Pilot Wingel Refill 0.38 / 0.5 / 0.7mm', 'Pilot Wingel Refill 0.38 / 0.5 / 0.7mm', 'Pilot Wingel Refill 0.38 / 0.5 / 0.7mm', 16.20, 'https://cf.shopee.com.my/file/460e8ab5cedeafe6c2e0b347ecbd14c4', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1225, 'Zebra Sarasa Clip Gel Pen 0.5mm / 0.7mm', 'Zebra Sarasa Clip Gel Pen 0.5mm / 0.7mm', 'Zebra Sarasa Clip Gel Pen 0.5mm / 0.7mm', 32.30, 'https://cf.shopee.com.my/file/3e6c60d418d9d7e8b0710d4904137fc2', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1226, 'HIgh Speed USB3.0 USB Male to USB 3.0 Male Extension Cable Type 5M 3M 1.5M 1M 0.6M 0.3M', 'HIgh Speed USB3.0 USB Male to USB 3.0 Male Extension Cable Type 5M 3M 1.5M 1M 0.6M 0.3M', 'HIgh Speed USB3.0 USB Male to USB 3.0 Male Extension Cable Type 5M 3M 1.5M 1M 0.6M 0.3M', 115.00, 'https://cf.shopee.com.my/file/3a02db22e42c1e7538fe7bf23fc94c89', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1227, 'Pentel Energel-X Retractable Gel Roller Pen-0.7mm / 1.0mm', 'Pentel Energel-X Retractable Gel Roller Pen-0.7mm / 1.0mm', 'Pentel Energel-X Retractable Gel Roller Pen-0.7mm / 1.0mm', 32.20, 'https://cf.shopee.com.my/file/890270811f35e3ddb5a74550d6d37bfb', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1228, '(0-1Years) Baby Girls Boys Kids Doll Sock Tiny Knitted Cotton Blend Ankle Socks Anti Slip Infant Toddler Footwear', '(0-1Years) Baby Girls Boys Kids Doll Sock Tiny Knitted Cotton Blend Ankle Socks Anti Slip Infant Toddler Footwear', '(0-1Years) Baby Girls Boys Kids Doll Sock Tiny Knitted Cotton Blend Ankle Socks Anti Slip Infant Toddler Footwear', 34.80, 'https://cf.shopee.com.my/file/3fa50528c59b84572d7d688ab67480be', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1229, 'OOREE UH701 7 PORTS HIGH SPEED USB2.0 USB HUB USB PORTS ON/OFF PORTABLE SWITCH, BLACK', 'OOREE UH701 7 PORTS HIGH SPEED USB2.0 USB HUB USB PORTS ON/OFF PORTABLE SWITCH, BLACK', 'OOREE UH701 7 PORTS HIGH SPEED USB2.0 USB HUB USB PORTS ON/OFF PORTABLE SWITCH, BLACK', 149.00, 'https://cf.shopee.com.my/file/013a5391399161a16bac454e43dbc2ec', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1230, 'Hijab / Child / Baby / hijab / allsize 0-3 Years Old / NAURA', 'Hijab / Child / Baby / hijab / allsize 0-3 Years Old / NAURA', 'Hijab / Child / Baby / hijab / allsize 0-3 Years Old / NAURA', 54.80, 'https://cf.shopee.com.my/file/19f6d8fcd81fcf3ae071bc81a160a46c', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1231, 'Magene MOVER Bluetooth4.0 ANT + Heart Rate Sensor Compatible GARMIN Bryton IGPSPORT Computer Bike Heart Rate Monitor', 'Magene MOVER Bluetooth4.0 ANT + Heart Rate Sensor Compatible GARMIN Bryton IGPSPORT Computer Bike Heart Rate Monitor', 'Magene MOVER Bluetooth4.0 ANT + Heart Rate Sensor Compatible GARMIN Bryton IGPSPORT Computer Bike Heart Rate Monitor', 690.00, 'https://cf.shopee.com.my/file/47d4572747797a42e7d1d5954b6c1494', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1232, 'Faber-Castell Apollo Mechanical Pencil 0.5mm / 0.7mm', 'Faber-Castell Apollo Mechanical Pencil 0.5mm / 0.7mm', 'Faber-Castell Apollo Mechanical Pencil 0.5mm / 0.7mm', 75.00, 'https://cf.shopee.com.my/file/6e8171e363b8a41cc5f9fcb7353a8841', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1233, 'Faber-Castell Ball Pen NX23 0.5mm / 0.7mm Ball Pen Black Blue Red', 'Faber-Castell Ball Pen NX23 0.5mm / 0.7mm Ball Pen Black Blue Red', 'Faber-Castell Ball Pen NX23 0.5mm / 0.7mm Ball Pen Black Blue Red', 9.00, 'https://cf.shopee.com.my/file/14a6df438e0de2d8149ceb9d18dc42f0', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1234, 'Nearsighted Glasses 0.0 to -6.0 diopters Super slighet Frame Cermin Mata Rabun Jauh  with power anti-blue Ray', 'Nearsighted Glasses 0.0 to -6.0 diopters Super slighet Frame Cermin Mata Rabun Jauh  with power anti-blue Ray', 'Nearsighted Glasses 0.0 to -6.0 diopters Super slighet Frame Cermin Mata Rabun Jauh  with power anti-blue Ray', 92.70, 'https://cf.shopee.com.my/file/44a48d13ec392888cb50614523d4bc16', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1235, '[1pc] M&G R3 / R5 Retractable Refillable Gel Pen 0.5mm / 0.7mm 1pc', '[1pc] M&G R3 / R5 Retractable Refillable Gel Pen 0.5mm / 0.7mm 1pc', '[1pc] M&G R3 / R5 Retractable Refillable Gel Pen 0.5mm / 0.7mm 1pc', 9.00, 'https://cf.shopee.com.my/file/5a97f7df51e8007137e2e801d6c430f2', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1236, 'Aukey CB-CL3 MFI Braided Nylon USB C To Lightning Cable Fast Charge iPhone 12/11/XR/X/8/8 Plus - 0.9m', 'Aukey CB-CL3 MFI Braided Nylon USB C To Lightning Cable Fast Charge iPhone 12/11/XR/X/8/8 Plus - 0.9m', 'Aukey CB-CL3 MFI Braided Nylon USB C To Lightning Cable Fast Charge iPhone 12/11/XR/X/8/8 Plus - 0.9m', 359.00, 'https://cf.shopee.com.my/file/895f05906abdca8338cc94704ed00991', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1237, 'FABER-CASTELL RX GEL PEN 0.38/0.5/0.7', 'FABER-CASTELL RX GEL PEN 0.38/0.5/0.7', 'FABER-CASTELL RX GEL PEN 0.38/0.5/0.7', 10.30, 'https://cf.shopee.com.my/file/c3a8802b7e7e086bc4240b54203edf75', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1238, 'M&G R3 0.5mm Retractable Gel Pen', 'M&G R3 0.5mm Retractable Gel Pen', 'M&G R3 0.5mm Retractable Gel Pen', 10.50, 'https://cf.shopee.com.my/file/d40f7f7450c1ab7e8ad76ac2af1fe224', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1240, 'Apacer AH334 / AH335 16/32/64 USB2.0 Flash Drive Pendrive. LIKE DTIG4 DT100 G3 SWIVL CRUSER BLADE', 'Apacer AH334 / AH335 16/32/64 USB2.0 Flash Drive Pendrive. LIKE DTIG4 DT100 G3 SWIVL CRUSER BLADE', 'Apacer AH334 / AH335 16/32/64 USB2.0 Flash Drive Pendrive. LIKE DTIG4 DT100 G3 SWIVL CRUSER BLADE', 133.30, 'https://cf.shopee.com.my/file/1b43bef8a791a362aab05454102cddfb', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1241, 'Acoustic Picks Plectrum Matte ABS picks Electric Smooth Guitar Pick Accessories 0.5mm 0.75mm 1.0mm', 'Acoustic Picks Plectrum Matte ABS picks Electric Smooth Guitar Pick Accessories 0.5mm 0.75mm 1.0mm', 'Acoustic Picks Plectrum Matte ABS picks Electric Smooth Guitar Pick Accessories 0.5mm 0.75mm 1.0mm', 1.00, 'https://cf.shopee.com.my/file/ff03ec44f5f50ee34d5108f28dd69e87', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1244, '8\" 10\" 12\" RING TERMINAL 0.5mm THICK BRASS COPPER WIRE CONNECTOR AUTOMOTIVE CABLE LUG WAYAR CLIP KERETA WAYERING TEMBAGA', '8\" 10\" 12\" RING TERMINAL 0.5mm THICK BRASS COPPER WIRE CONNECTOR AUTOMOTIVE CABLE LUG WAYAR CLIP KERETA WAYERING TEMBAGA', '8\" 10\" 12\" RING TERMINAL 0.5mm THICK BRASS COPPER WIRE CONNECTOR AUTOMOTIVE CABLE LUG WAYAR CLIP KERETA WAYERING TEMBAGA', 30.00, 'https://cf.shopee.com.my/file/d77be56f99c720163b613fd7b5c21c7b', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1245, '1pcs Ink Gel Pen 0.5mm Blue Black Red Ink Writing Tool Stationery Neutral Pen For Office School Signature 0.38mm Gel Pen', '1pcs Ink Gel Pen 0.5mm Blue Black Red Ink Writing Tool Stationery Neutral Pen For Office School Signature 0.38mm Gel Pen', '1pcs Ink Gel Pen 0.5mm Blue Black Red Ink Writing Tool Stationery Neutral Pen For Office School Signature 0.38mm Gel Pen', 4.10, 'https://cf.shopee.com.my/file/74271402e6e12d5d05be7bf36717dcd9', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1246, 'Faber-Castell Water Resistant Ink True Gel Colour Pen 0.5 / 0.7MM', 'Faber-Castell Water Resistant Ink True Gel Colour Pen 0.5 / 0.7MM', 'Faber-Castell Water Resistant Ink True Gel Colour Pen 0.5 / 0.7MM', 17.50, 'https://cf.shopee.com.my/file/1e3781dbd3c84813317dd16c66d72745', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1247, '[Grab2Go] Pencil Leads - STABILO Mechanical Pencil Lead Refill (0.7mm) Pack of 4', '[Grab2Go] Pencil Leads - STABILO Mechanical Pencil Lead Refill (0.7mm) Pack of 4', '[Grab2Go] Pencil Leads - STABILO Mechanical Pencil Lead Refill (0.7mm) Pack of 4', 22.00, 'https://cf.shopee.com.my/file/610e8b2cfaa726cc331365ab6f6a5215', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1248, '1 Roll Dia 0.2-1mm Thread Metal String Wire Brass Copper Wires Beading Wire For DIY Beads Jewelry Making Accessories', '1 Roll Dia 0.2-1mm Thread Metal String Wire Brass Copper Wires Beading Wire For DIY Beads Jewelry Making Accessories', '1 Roll Dia 0.2-1mm Thread Metal String Wire Brass Copper Wires Beading Wire For DIY Beads Jewelry Making Accessories', 16.60, 'https://cf.shopee.com.my/file/49ba2a54ea56ad3cffe6782b7ee67cd0', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1249, 'MEREDITH 50pcs/lot Fishing Soft Worm Hooks High Carbon Steel Wide Super Lock Fishhooks Lure Softjerk Hooks 8#-5/0 Fishing Tackle', 'MEREDITH 50pcs/lot Fishing Soft Worm Hooks High Carbon Steel Wide Super Lock Fishhooks Lure Softjerk Hooks 8#-5/0 Fishing Tackle', 'MEREDITH 50pcs/lot Fishing Soft Worm Hooks High Carbon Steel Wide Super Lock Fishhooks Lure Softjerk Hooks 8#-5/0 Fishing Tackle', 38.80, 'https://cf.shopee.com.my/file/3bc78fce917d45f8642544b583a7729c', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1250, 'OOREE UH402 4 PORTS HIGH SPEED USB2.0 USB HUB ON/OFF PORTABLE SWITCH, BLACK', 'OOREE UH402 4 PORTS HIGH SPEED USB2.0 USB HUB ON/OFF PORTABLE SWITCH, BLACK', 'OOREE UH402 4 PORTS HIGH SPEED USB2.0 USB HUB ON/OFF PORTABLE SWITCH, BLACK', 119.00, 'https://cf.shopee.com.my/file/344eb3c383afaac417d0a1cc98d0f84b', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1251, 'ADATA PowerBank 22.5W/18W Fast Quick Charge PD Type C Triple USB Output LED 10000/20000mah P10000QC P20000QC QC3.0 PD3.0', 'ADATA PowerBank 22.5W/18W Fast Quick Charge PD Type C Triple USB Output LED 10000/20000mah P10000QC P20000QC QC3.0 PD3.0', 'ADATA PowerBank 22.5W/18W Fast Quick Charge PD Type C Triple USB Output LED 10000/20000mah P10000QC P20000QC QC3.0 PD3.0', 490.00, 'https://cf.shopee.com.my/file/8316fc2351fa4554b7bb2a05c226e93b', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1252, 'Jump Force 3.0.0 + Giorno Giovanna [LATEST DLC] [PC DIGITAL DOWNLOAD] [OFFLINE] [GOOGLE-DRIVE]', 'Jump Force 3.0.0 + Giorno Giovanna [LATEST DLC] [PC DIGITAL DOWNLOAD] [OFFLINE] [GOOGLE-DRIVE]', 'Jump Force 3.0.0 + Giorno Giovanna [LATEST DLC] [PC DIGITAL DOWNLOAD] [OFFLINE] [GOOGLE-DRIVE]', 30.00, 'https://cf.shopee.com.my/file/acfb1a788adbd58d9ab1fa6b9db8053f', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1253, 'Uni Pigment Ink Pin Fine Line Drawing Pen 0.05-1.2mm PIN-200 1pc [NEW Tip Size & Brush]', 'Uni Pigment Ink Pin Fine Line Drawing Pen 0.05-1.2mm PIN-200 1pc [NEW Tip Size & Brush]', 'Uni Pigment Ink Pin Fine Line Drawing Pen 0.05-1.2mm PIN-200 1pc [NEW Tip Size & Brush]', 50.00, 'https://cf.shopee.com.my/file/9721f0aba60644630420210dce458709', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1254, '4 PORTS USB 3.0 USB3.0 Internal PCIe PCI-E Express Expansion Card', '4 PORTS USB 3.0 USB3.0 Internal PCIe PCI-E Express Expansion Card', '4 PORTS USB 3.0 USB3.0 Internal PCIe PCI-E Express Expansion Card', 338.90, 'https://cf.shopee.com.my/file/deb2cb30e8492396834df0c7adad70a7', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1255, 'Staedtler Noris 2B Exam Pencils 120-0 A50 (Box of 12 pcs)', 'Staedtler Noris 2B Exam Pencils 120-0 A50 (Box of 12 pcs)', 'Staedtler Noris 2B Exam Pencils 120-0 A50 (Box of 12 pcs)', 80.00, 'https://cf.shopee.com.my/file/189cf88389fd2b2c98eb7e1cd891e61a', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1257, 'APACER 16GB / 32GB /64GB USB2.0 Pendrive Pen Drive  /Flash Drive /  Thumb Drive AH334 / AH335 16GB 32GB', 'APACER 16GB / 32GB /64GB USB2.0 Pendrive Pen Drive  /Flash Drive /  Thumb Drive AH334 / AH335 16GB 32GB', 'APACER 16GB / 32GB /64GB USB2.0 Pendrive Pen Drive  /Flash Drive /  Thumb Drive AH334 / AH335 16GB 32GB', 129.00, 'https://cf.shopee.com.my/file/d2b100a8aa7bd7cd97b5ac7bb5e2f40f', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1259, 'Faber Castell Econ Mechanical Pencil 0.5mm/0.7mm', 'Faber Castell Econ Mechanical Pencil 0.5mm/0.7mm', 'Faber Castell Econ Mechanical Pencil 0.5mm/0.7mm', 32.00, 'https://cf.shopee.com.my/file/5d042afaab6dcc9fb3a1945ece20f725', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1260, 'Autumnz Orthodontic Baby Silicone Soother With Hygiene Cover (0-6 months , 6-18 months , 18-36 months) Baby Pacifier', 'Autumnz Orthodontic Baby Silicone Soother With Hygiene Cover (0-6 months , 6-18 months , 18-36 months) Baby Pacifier', 'Autumnz Orthodontic Baby Silicone Soother With Hygiene Cover (0-6 months , 6-18 months , 18-36 months) Baby Pacifier', 87.00, 'https://cf.shopee.com.my/file/aa30351c5db0ea5d720aa3b98ae50c6a', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1261, 'Pilot WINGEL Gel Ink Pen 0.5mm / 0.7mm', 'Pilot WINGEL Gel Ink Pen 0.5mm / 0.7mm', 'Pilot WINGEL Gel Ink Pen 0.5mm / 0.7mm', 26.40, 'https://cf.shopee.com.my/file/b0cc124a3344ab09e3b974f4783527f2', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1262, '5ft Tikar Getah Quality,Buatan Thailand,Tebal Penuh 0.40mm', '5ft Tikar Getah Quality,Buatan Thailand,Tebal Penuh 0.40mm', '5ft Tikar Getah Quality,Buatan Thailand,Tebal Penuh 0.40mm', 39.80, 'https://cf.shopee.com.my/file/e2b4aa924becb8867cf892d2b8694781', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1264, 'Resistor 0.25W 5% (10K) [10pcs]', 'Resistor 0.25W 5% (10K) [10pcs]', 'Resistor 0.25W 5% (10K) [10pcs]', 10.00, 'https://cf.shopee.com.my/file/142f5669468f26e32253cd4db753be11', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1265, 'Baby Raya Baju 0-12month baby rompers Long sleeve kids clothes baby boys girls clothes jumpsuit', 'Baby Raya Baju 0-12month baby rompers Long sleeve kids clothes baby boys girls clothes jumpsuit', 'Baby Raya Baju 0-12month baby rompers Long sleeve kids clothes baby boys girls clothes jumpsuit', 96.90, 'https://cf.shopee.com.my/file/2db44781f6d874270651a75232418fa5', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1269, 'Budding Premium Quality Newborn Baby Comfort Clothing set 0-12M Shirts Short Sleeve Long Pants Singlet Baju Baby Quality', 'Budding Premium Quality Newborn Baby Comfort Clothing set 0-12M Shirts Short Sleeve Long Pants Singlet Baju Baby Quality', 'Budding Premium Quality Newborn Baby Comfort Clothing set 0-12M Shirts Short Sleeve Long Pants Singlet Baju Baby Quality', 129.00, 'https://cf.shopee.com.my/file/6e3462bcf8991b3ab21a1cd798ea2bb8', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1270, 'Artpac Artist Nylon Brush 818 - Round [Muslim Friendly] (Per PCS, No. 000/00/0/1/2/3/4/5) [List 1/2]', 'Artpac Artist Nylon Brush 818 - Round [Muslim Friendly] (Per PCS, No. 000/00/0/1/2/3/4/5) [List 1/2]', 'Artpac Artist Nylon Brush 818 - Round [Muslim Friendly] (Per PCS, No. 000/00/0/1/2/3/4/5) [List 1/2]', 26.50, 'https://cf.shopee.com.my/file/1a4d5c3b152b762ef4607766824e941d', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1271, 'Bubble Wrap [ 50cm x 100m ] Premium Quality Single / Double Layer roll film - 0.5m x 100m Wrapping - clear / black', 'Bubble Wrap [ 50cm x 100m ] Premium Quality Single / Double Layer roll film - 0.5m x 100m Wrapping - clear / black', 'Bubble Wrap [ 50cm x 100m ] Premium Quality Single / Double Layer roll film - 0.5m x 100m Wrapping - clear / black', 420.00, 'https://cf.shopee.com.my/file/a932382902d67258c3d5c6b296faca27', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1272, 'Baby boy clothes boy set 0-4 years old boys\' clothes boys\' color contrast handsome short sleeve polo shirt', 'Baby boy clothes boy set 0-4 years old boys\' clothes boys\' color contrast handsome short sleeve polo shirt', 'Baby boy clothes boy set 0-4 years old boys\' clothes boys\' color contrast handsome short sleeve polo shirt', 169.80, 'https://cf.shopee.com.my/file/dd879d6ca185e02c06a540eb09e1bc63', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1273, '[Ready Stock] Kids Baby Girls Knitted Leggings Children Solid Pants Girl Stretch Tights Long Pant Baby Toddler Casual Ankle Luster Trousers 0-5 Years Old', '[Ready Stock] Kids Baby Girls Knitted Leggings Children Solid Pants Girl Stretch Tights Long Pant Baby Toddler Casual Ankle Luster Trousers 0-5 Years Old', '[Ready Stock] Kids Baby Girls Knitted Leggings Children Solid Pants Girl Stretch Tights Long Pant Baby Toddler Casual Ankle Luster Trousers 0-5 Years Old', 33.70, 'https://cf.shopee.com.my/file/a6f260627eb81d18f3e9fa028ea66aeb', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1274, 'Ready Stok Local Seller Qqbaby Newborn Baby 0-3month Cute Pyjamas Pajamas Infant Cotton Tops+ Pants Jammies Clothing Set', 'Ready Stok Local Seller Qqbaby Newborn Baby 0-3month Cute Pyjamas Pajamas Infant Cotton Tops+ Pants Jammies Clothing Set', 'Ready Stok Local Seller Qqbaby Newborn Baby 0-3month Cute Pyjamas Pajamas Infant Cotton Tops+ Pants Jammies Clothing Set', 49.80, 'https://cf.shopee.com.my/file/e467516c3fe7668efb3e610c69bcfff3', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1275, '4\" / 4.5\" / 5\" STEEL PLASTERING TROWEL (0.6MM)/ sudu plaster simen', '4\" / 4.5\" / 5\" STEEL PLASTERING TROWEL (0.6MM)/ sudu plaster simen', '4\" / 4.5\" / 5\" STEEL PLASTERING TROWEL (0.6MM)/ sudu plaster simen', 45.00, 'https://cf.shopee.com.my/file/e338bfbe3f7447b531f69ab6a31e3602', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1276, 'summer baby jumpsuit romper clothes newborn boy jumpsuit comfortable 100% cotton boy gift set 0-12M', 'summer baby jumpsuit romper clothes newborn boy jumpsuit comfortable 100% cotton boy gift set 0-12M', 'summer baby jumpsuit romper clothes newborn boy jumpsuit comfortable 100% cotton boy gift set 0-12M', 388.80, 'https://cf.shopee.com.my/file/940ce547b0e864cf99b5b0ee97d7d839', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1278, 'Newborn Baby Soft Soles Sneakers Polka Dot Crib Shoes 0-18M', 'Newborn Baby Soft Soles Sneakers Polka Dot Crib Shoes 0-18M', 'Newborn Baby Soft Soles Sneakers Polka Dot Crib Shoes 0-18M', 84.40, 'https://cf.shopee.com.my/file/fe3f83feec351a85097395e37ab1bd93', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1279, '0-6Years Baby Girls Butterfly Tights Mesh Cotton Stockings Pantyhose Leggings Pants', '0-6Years Baby Girls Butterfly Tights Mesh Cotton Stockings Pantyhose Leggings Pants', '0-6Years Baby Girls Butterfly Tights Mesh Cotton Stockings Pantyhose Leggings Pants', 109.30, 'https://cf.shopee.com.my/file/f6e196441bf94e91e820d5f4efe9f0a0', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1280, 'Honda Wave 125 Alloy Block Gasket 0.2/0.3/0.4/0.5/0.8/1/1.5/2/2.5/3/4/5/6/7/8/10/12MM Ashuka', 'Honda Wave 125 Alloy Block Gasket 0.2/0.3/0.4/0.5/0.8/1/1.5/2/2.5/3/4/5/6/7/8/10/12MM Ashuka', 'Honda Wave 125 Alloy Block Gasket 0.2/0.3/0.4/0.5/0.8/1/1.5/2/2.5/3/4/5/6/7/8/10/12MM Ashuka', 58.00, 'https://cf.shopee.com.my/file/ae85c60a9d0bd8803132393e74d8569c', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1282, 'Ready Stock Baby Kids Canvas Sneakers Toddler Boy Girl Soft Sole Shoe Anti slip shoes Baby Shoe First Walkers 0-18Monthes', 'Ready Stock Baby Kids Canvas Sneakers Toddler Boy Girl Soft Sole Shoe Anti slip shoes Baby Shoe First Walkers 0-18Monthes', 'Ready Stock Baby Kids Canvas Sneakers Toddler Boy Girl Soft Sole Shoe Anti slip shoes Baby Shoe First Walkers 0-18Monthes', 59.30, 'https://cf.shopee.com.my/file/f9f0af4a8121bc788f405d91907c52d5', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1283, '[RM 0.68 AFTER SHOPEE COIN REBATE] [5 in 1] Stationery Kids Set Cartoon 5 IN 1', '[RM 0.68 AFTER SHOPEE COIN REBATE] [5 in 1] Stationery Kids Set Cartoon 5 IN 1', '[RM 0.68 AFTER SHOPEE COIN REBATE] [5 in 1] Stationery Kids Set Cartoon 5 IN 1', 7.50, 'https://cf.shopee.com.my/file/1d4439ce77280e42ecf2bc12212cd1c2', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1284, 'PFT7-0-4 Years Kids Baby 2-piece Outfit Set Short Sleeve Pocket Top+Shorts Set for Children Boys Girls', 'PFT7-0-4 Years Kids Baby 2-piece Outfit Set Short Sleeve Pocket Top+Shorts Set for Children Boys Girls', 'PFT7-0-4 Years Kids Baby 2-piece Outfit Set Short Sleeve Pocket Top+Shorts Set for Children Boys Girls', 204.00, 'https://cf.shopee.com.my/file/bdfd17a48a97210994570d68432ecd92', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1285, 'ORICO 2580U3 (2.5\") USB3.0 Hard Disk Enclosure', 'ORICO 2580U3 (2.5\") USB3.0 Hard Disk Enclosure', 'ORICO 2580U3 (2.5\") USB3.0 Hard Disk Enclosure', 260.00, 'https://cf.shopee.com.my/file/bac0b73a37337a1223bf4494b17a427d', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1286, 'Boys Fashion Baju Budak Lelaki Shirt Baby Boys Clothing 0-4 Years Old Children\'s Suit Shark Cartoon T-shirt', 'Boys Fashion Baju Budak Lelaki Shirt Baby Boys Clothing 0-4 Years Old Children\'s Suit Shark Cartoon T-shirt', 'Boys Fashion Baju Budak Lelaki Shirt Baby Boys Clothing 0-4 Years Old Children\'s Suit Shark Cartoon T-shirt', 149.60, 'https://cf.shopee.com.my/file/9b422b5fee6ea46ef49a3e67794e15df', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1287, 'RinsCap NS Sodium Chloride 0.9% Irrigation Solution BP 1000ml (Normal Saline)', 'RinsCap NS Sodium Chloride 0.9% Irrigation Solution BP 1000ml (Normal Saline)', 'RinsCap NS Sodium Chloride 0.9% Irrigation Solution BP 1000ml (Normal Saline)', 59.00, 'https://cf.shopee.com.my/file/3fa2e4d770692412028ff8ecdcab7d0e', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1288, 'TKTT 18mm 0.75 Inch Night Market Foldable Table Rack Market Folding Table Stand Plywood Kaki Meja Besi Lipat Pasar Malam', 'TKTT 18mm 0.75 Inch Night Market Foldable Table Rack Market Folding Table Stand Plywood Kaki Meja Besi Lipat Pasar Malam', 'TKTT 18mm 0.75 Inch Night Market Foldable Table Rack Market Folding Table Stand Plywood Kaki Meja Besi Lipat Pasar Malam', 360.00, 'https://cf.shopee.com.my/file/e502986816676beef71523a2ea76a64b', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1289, '(0.00 To 500 )1 Piece Freshkon Fusion Daily Color Blushing Violet (Loose Pack)', '(0.00 To 500 )1 Piece Freshkon Fusion Daily Color Blushing Violet (Loose Pack)', '(0.00 To 500 )1 Piece Freshkon Fusion Daily Color Blushing Violet (Loose Pack)', 20.50, 'https://cf.shopee.com.my/file/840380fb508d3000f3032b4460daab6e', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1290, 'RAYA Children Kids Short-sleeve Suit Cotton (BT005) 0~4years old Baby Boy Girl T-Shirt Pant Short Sleeve Set Baju Budak', 'RAYA Children Kids Short-sleeve Suit Cotton (BT005) 0~4years old Baby Boy Girl T-Shirt Pant Short Sleeve Set Baju Budak', 'RAYA Children Kids Short-sleeve Suit Cotton (BT005) 0~4years old Baby Boy Girl T-Shirt Pant Short Sleeve Set Baju Budak', 62.80, 'https://cf.shopee.com.my/file/c01caca7c0ee5f7b1efd88be0c3e773f', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1292, '[Ready Stock] summer newborn babies 0-5 years old line Mickey short sleeve with loose shorts', '[Ready Stock] summer newborn babies 0-5 years old line Mickey short sleeve with loose shorts', '[Ready Stock] summer newborn babies 0-5 years old line Mickey short sleeve with loose shorts', 178.80, 'https://cf.shopee.com.my/file/aacaaa103fac9efc82db5d68cd775fe4', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1294, '[Ready Stock] 2021 new 0-6 year old boys and girls trendy western style cotton short sleeves with casual wild denim shorts two-piece suit', '[Ready Stock] 2021 new 0-6 year old boys and girls trendy western style cotton short sleeves with casual wild denim shorts two-piece suit', '[Ready Stock] 2021 new 0-6 year old boys and girls trendy western style cotton short sleeves with casual wild denim shorts two-piece suit', 185.80, 'https://cf.shopee.com.my/file/6824549c45fb1d06ab4c806a122f83a8', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1296, '*BUBBLE WRAP* Khind/Isonic Electric Rice Cooker RC806N(0.6L)/RC810(1.0L)/RC818N(1.8L)/RC828N(2.8L)/IRC1009/1809/2809', '*BUBBLE WRAP* Khind/Isonic Electric Rice Cooker RC806N(0.6L)/RC810(1.0L)/RC818N(1.8L)/RC828N(2.8L)/IRC1009/1809/2809', '*BUBBLE WRAP* Khind/Isonic Electric Rice Cooker RC806N(0.6L)/RC810(1.0L)/RC818N(1.8L)/RC828N(2.8L)/IRC1009/1809/2809', 539.00, 'https://cf.shopee.com.my/file/5b21ac4b6dcbe7d98175602452fa551e', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1297, '[READY STOCK] OKAZAWA P150B2.C 0.5HP House Use Automatic Water Pump (Pump Air)', '[READY STOCK] OKAZAWA P150B2.C 0.5HP House Use Automatic Water Pump (Pump Air)', '[READY STOCK] OKAZAWA P150B2.C 0.5HP House Use Automatic Water Pump (Pump Air)', 1690.00, 'https://cf.shopee.com.my/file/062a0a9522e5d42731ae8d5b568e5ee6', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1298, 'Tikar Getah Super Berat 20m x 1.83m (6 kaki) Tebal 0.40mm PVC Vinyl Carpet Flooring Canopy Karpet Velvet Khemah Kanopi', 'Tikar Getah Super Berat 20m x 1.83m (6 kaki) Tebal 0.40mm PVC Vinyl Carpet Flooring Canopy Karpet Velvet Khemah Kanopi', 'Tikar Getah Super Berat 20m x 1.83m (6 kaki) Tebal 0.40mm PVC Vinyl Carpet Flooring Canopy Karpet Velvet Khemah Kanopi', 1199.00, 'https://cf.shopee.com.my/file/dda8765dae0bb1e8d72ee44c48700493', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1299, 'Ready Stock 0-18M Premium Quality Newborn Baby Clothing Romper Boy Girl', 'Ready Stock 0-18M Premium Quality Newborn Baby Clothing Romper Boy Girl', 'Ready Stock 0-18M Premium Quality Newborn Baby Clothing Romper Boy Girl', 110.00, 'https://cf.shopee.com.my/file/17460000bfa98e7dcd63c934f9c746c8', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1300, '0-5Y Baby Kid Set Pajamas Shirt+Pant Boy Girl Sleepwear Pyjamas', '0-5Y Baby Kid Set Pajamas Shirt+Pant Boy Girl Sleepwear Pyjamas', '0-5Y Baby Kid Set Pajamas Shirt+Pant Boy Girl Sleepwear Pyjamas', 63.00, 'https://cf.shopee.com.my/file/11c79d751b313ed2250ad54f3a8adf2f', 1627909668, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1301, 'Original NEVOKS PAGEE Cartridge 2.2 ML  New arrive nevoks pagee 0.6 Occ nevoks pagee 1.0 Occ (Ready Stock)', 'Original NEVOKS PAGEE Cartridge 2.2 ML  New arrive nevoks pagee 0.6 Occ nevoks pagee 1.0 Occ (Ready Stock)', 'Original NEVOKS PAGEE Cartridge 2.2 ML  New arrive nevoks pagee 0.6 Occ nevoks pagee 1.0 Occ (Ready Stock)', 100.00, 'https://cf.shopee.com.my/file/15bd80a49e98f8ad45c3582c7a458cd3', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1302, 'PUFFY 3 TONES GREY/BROWN 16mm 0-800 Power Original contact lens BEST SELLER!', 'PUFFY 3 TONES GREY/BROWN 16mm 0-800 Power Original contact lens BEST SELLER!', 'PUFFY 3 TONES GREY/BROWN 16mm 0-800 Power Original contact lens BEST SELLER!', 98.30, 'https://cf.shopee.com.my/file/c1a096ab7c80d272a0776ba306c41c2c', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1303, 'Anakku Newborn Baby Girl Hamper Gift Set / Set Hadiah Hamper Bayi Perempuan 0-3 Months (5 pcs) EAK313-1', 'Anakku Newborn Baby Girl Hamper Gift Set / Set Hadiah Hamper Bayi Perempuan 0-3 Months (5 pcs) EAK313-1', 'Anakku Newborn Baby Girl Hamper Gift Set / Set Hadiah Hamper Bayi Perempuan 0-3 Months (5 pcs) EAK313-1', 475.00, 'https://cf.shopee.com.my/file/81930499a1184c44c0ecd20c989f9a0b', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1304, 'Pilot Mechanical Pencil 0.5/0.7 Progrex H-125', 'Pilot Mechanical Pencil 0.5/0.7 Progrex H-125', 'Pilot Mechanical Pencil 0.5/0.7 Progrex H-125', 26.00, 'https://cf.shopee.com.my/file/18e26d0d8b0bc5c744343fbcf35a6c78', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1305, 'Getah Ketapel Jenama Precise Saiz 0.9/1.0mm (3 unit)', 'Getah Ketapel Jenama Precise Saiz 0.9/1.0mm (3 unit)', 'Getah Ketapel Jenama Precise Saiz 0.9/1.0mm (3 unit)', 150.00, 'https://cf.shopee.com.my/file/3b4543f58dc9b6df8328558ff10af457', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1306, 'Faber-Castell K-One Gel Pen 0.5mm', 'Faber-Castell K-One Gel Pen 0.5mm', 'Faber-Castell K-One Gel Pen 0.5mm', 15.00, 'https://cf.shopee.com.my/file/9d231aa065e2abe7d932a27930350ae3', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1307, 'Ready Stock 100% Original Uwell Caliburn G OCC Empty Cartridge 0.8 OCC 1.0 OCC', 'Ready Stock 100% Original Uwell Caliburn G OCC Empty Cartridge 0.8 OCC 1.0 OCC', 'Ready Stock 100% Original Uwell Caliburn G OCC Empty Cartridge 0.8 OCC 1.0 OCC', 80.00, 'https://cf.shopee.com.my/file/94155b03f444adbdae4997d8a476e460', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1308, 'Faber-Castell NX23 Ball Pen 0.5mm/0.7mm - (1\'pc) NX 23', 'Faber-Castell NX23 Ball Pen 0.5mm/0.7mm - (1\'pc) NX 23', 'Faber-Castell NX23 Ball Pen 0.5mm/0.7mm - (1\'pc) NX 23', 7.40, 'https://cf.shopee.com.my/file/e81a47f258fdff004b6294920cce2c66', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1309, 'abodos 5A Micro USB Cable Super Quick Charge 5A Micro USB Data USB Cable Andriod 0.3M 1M 2M for Samsung Huawei Oppo vivo', 'abodos 5A Micro USB Cable Super Quick Charge 5A Micro USB Data USB Cable Andriod 0.3M 1M 2M for Samsung Huawei Oppo vivo', 'abodos 5A Micro USB Cable Super Quick Charge 5A Micro USB Data USB Cable Andriod 0.3M 1M 2M for Samsung Huawei Oppo vivo', 18.80, 'https://cf.shopee.com.my/file/91108130c1c59530b97a9a7ffd63d556', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1310, 'Thailand Latex 4.0 Bra Women Seamless Bra Wireless Gathered Vest Type Bra Adjustable Sport Bra Push Up Underwear RJ4.0', 'Thailand Latex 4.0 Bra Women Seamless Bra Wireless Gathered Vest Type Bra Adjustable Sport Bra Push Up Underwear RJ4.0', 'Thailand Latex 4.0 Bra Women Seamless Bra Wireless Gathered Vest Type Bra Adjustable Sport Bra Push Up Underwear RJ4.0', 65.00, 'https://cf.shopee.com.my/file/c80d546f0b4ed85777488fa0cf537647', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1314, 'Car Audio Stereo Amplifier 2 TO 2 RCA Cable |  RCA Cable | RCA 0.5M | RCA 1.2M | RCA 2.0M | RCA 4.5M | Car Wire', 'Car Audio Stereo Amplifier 2 TO 2 RCA Cable |  RCA Cable | RCA 0.5M | RCA 1.2M | RCA 2.0M | RCA 4.5M | Car Wire', 'Car Audio Stereo Amplifier 2 TO 2 RCA Cable |  RCA Cable | RCA 0.5M | RCA 1.2M | RCA 2.0M | RCA 4.5M | Car Wire', 82.00, 'https://cf.shopee.com.my/file/b0c2f9a84223116e500a20da0dc041e2', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1316, 'Zhi Xin G-2501 Test Good 0.5mm Gel Ink Pen (12 Pcs)', 'Zhi Xin G-2501 Test Good 0.5mm Gel Ink Pen (12 Pcs)', 'Zhi Xin G-2501 Test Good 0.5mm Gel Ink Pen (12 Pcs)', 59.00, 'https://cf.shopee.com.my/file/1e243d6052af90ba990942bdd7d1dd48', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1317, 'Full Cotton Front Closure Bra Big Size 38-46 0.3cm Thin Cup Seamless Wireless Push Up Bras Breathable Innerwear Bralette', 'Full Cotton Front Closure Bra Big Size 38-46 0.3cm Thin Cup Seamless Wireless Push Up Bras Breathable Innerwear Bralette', 'Full Cotton Front Closure Bra Big Size 38-46 0.3cm Thin Cup Seamless Wireless Push Up Bras Breathable Innerwear Bralette', 129.60, 'https://cf.shopee.com.my/file/abef27477a6d092ce3f96e739fe91e8a', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1318, 'INS birthday cake topper mirror acrylic Number 0-9 plug-in baking props dessert decoration materials', 'INS birthday cake topper mirror acrylic Number 0-9 plug-in baking props dessert decoration materials', 'INS birthday cake topper mirror acrylic Number 0-9 plug-in baking props dessert decoration materials', 8.40, 'https://cf.shopee.com.my/file/017b825a4c3b141eb6b3353298b9c0a3', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1320, '-1.0 to -6.0 Power Cermin Mata Rabun Jauh Southeast Asia Fashion Polygon Transparent Frame Student Unisex Anti Blue Ray Glasses', '-1.0 to -6.0 Power Cermin Mata Rabun Jauh Southeast Asia Fashion Polygon Transparent Frame Student Unisex Anti Blue Ray Glasses', '-1.0 to -6.0 Power Cermin Mata Rabun Jauh Southeast Asia Fashion Polygon Transparent Frame Student Unisex Anti Blue Ray Glasses', 70.80, 'https://cf.shopee.com.my/file/c26baa2d5a2712abf7a2895d01e74a7b', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1321, 'M&G R5 GEL INK PEN 0.7mm (AGP12371)1PCS', 'M&G R5 GEL INK PEN 0.7mm (AGP12371)1PCS', 'M&G R5 GEL INK PEN 0.7mm (AGP12371)1PCS', 9.60, 'https://cf.shopee.com.my/file/5b9dd6bad6d57c9886f1b0928f3c9d8d', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1322, 'PalingKeras. Bubble Wrap 0.5M X 10M & 1M X 10M Single & Double Layer AAA High Quality. Clear & Black. 6MM Thickness', 'PalingKeras. Bubble Wrap 0.5M X 10M & 1M X 10M Single & Double Layer AAA High Quality. Clear & Black. 6MM Thickness', 'PalingKeras. Bubble Wrap 0.5M X 10M & 1M X 10M Single & Double Layer AAA High Quality. Clear & Black. 6MM Thickness', 65.00, 'https://cf.shopee.com.my/file/78b3ccae44c38a5b2e0db9796b3a1fc3', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1323, 'Gold/White/Silver 0.6 Line Premium White Gel Pen Set Fine Tip Sketching Pens Artists Black Papers Drawing', 'Gold/White/Silver 0.6 Line Premium White Gel Pen Set Fine Tip Sketching Pens Artists Black Papers Drawing', 'Gold/White/Silver 0.6 Line Premium White Gel Pen Set Fine Tip Sketching Pens Artists Black Papers Drawing', 6.00, 'https://cf.shopee.com.my/file/73395d51afe903b12f7641cb6d425596', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1325, 'Anakku 5pcs Baby Boy Combo Set Newborn Clothing Set Baju Bayi Lelaki [0-9 Months] 220512-1', 'Anakku 5pcs Baby Boy Combo Set Newborn Clothing Set Baju Bayi Lelaki [0-9 Months] 220512-1', 'Anakku 5pcs Baby Boy Combo Set Newborn Clothing Set Baju Bayi Lelaki [0-9 Months] 220512-1', 599.00, 'https://cf.shopee.com.my/file/35f75c5f604698f97b643ad20616a188', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1326, 'Rabun Jauh Cermin Mata Fashion eyeglasses -1.0 to -6.0 Women\'s Myopia Glasses Finished Frame Nearsighted lenses', 'Rabun Jauh Cermin Mata Fashion eyeglasses -1.0 to -6.0 Women\'s Myopia Glasses Finished Frame Nearsighted lenses', 'Rabun Jauh Cermin Mata Fashion eyeglasses -1.0 to -6.0 Women\'s Myopia Glasses Finished Frame Nearsighted lenses', 75.00, 'https://cf.shopee.com.my/file/9e93196726e23d6c2435b31128514a10', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1327, 'Faber Castell Grip X5 0.5mm Ball Point Pen', 'Faber Castell Grip X5 0.5mm Ball Point Pen', 'Faber Castell Grip X5 0.5mm Ball Point Pen', 13.00, 'https://cf.shopee.com.my/file/0ca6ea251ecc933cc6964310d337bfa1', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1328, 'Faber Castell Apollo Mechanical Pencil 0.5mm free eraser MP( 9555684690081 )', 'Faber Castell Apollo Mechanical Pencil 0.5mm free eraser MP( 9555684690081 )', 'Faber Castell Apollo Mechanical Pencil 0.5mm free eraser MP( 9555684690081 )', 69.90, 'https://cf.shopee.com.my/file/7f8ead2aa157df0ee26b791d273c8df3', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1329, 'Uni JETSTREAM 101 Rollerball Retractable Pen  0.5mm 0.7mm SXN 101', 'Uni JETSTREAM 101 Rollerball Retractable Pen  0.5mm 0.7mm SXN 101', 'Uni JETSTREAM 101 Rollerball Retractable Pen  0.5mm 0.7mm SXN 101', 29.00, 'https://cf.shopee.com.my/file/778469bf59da832a39e962ea65820659', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1330, '1KG X 0.8mm CO2 Wire MIG Wire for Welding', '1KG X 0.8mm CO2 Wire MIG Wire for Welding', '1KG X 0.8mm CO2 Wire MIG Wire for Welding', 157.00, 'https://cf.shopee.com.my/file/db2663182c40e22d3ba3819ded70725b', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1331, '1 Roll 0.3/0.38/0.45/0.5/0.6/0.7/0.8/1mm Resistant Strong Line Stainless Steel Wire Tiger Tail Beading Wire For Jewelry Making Finding', '1 Roll 0.3/0.38/0.45/0.5/0.6/0.7/0.8/1mm Resistant Strong Line Stainless Steel Wire Tiger Tail Beading Wire For Jewelry Making Finding', '1 Roll 0.3/0.38/0.45/0.5/0.6/0.7/0.8/1mm Resistant Strong Line Stainless Steel Wire Tiger Tail Beading Wire For Jewelry Making Finding', 20.10, 'https://cf.shopee.com.my/file/0a301617d102c32e452b0cd5548af88e', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1332, 'Hijab / Child / Baby / hijab / allsize 0-3 Years Old / CARLA', 'Hijab / Child / Baby / hijab / allsize 0-3 Years Old / CARLA', 'Hijab / Child / Baby / hijab / allsize 0-3 Years Old / CARLA', 56.50, 'https://cf.shopee.com.my/file/24c1965c857844eed636205f4ec3aca9', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1334, 'FAJAR 14/0.26MM & 28/0.26MM Car Lori Automotive Wire Auto Cables 100% Copper - 30M', 'FAJAR 14/0.26MM & 28/0.26MM Car Lori Automotive Wire Auto Cables 100% Copper - 30M', 'FAJAR 14/0.26MM & 28/0.26MM Car Lori Automotive Wire Auto Cables 100% Copper - 30M', 140.00, 'https://cf.shopee.com.my/file/442f1ebe68186043af61aa98509e362f', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1335, 'imoda 1PC STA Waterproof Sketch Art Marker Pen Pigment Liner Micron 0.05mm-0.8mm', 'imoda 1PC STA Waterproof Sketch Art Marker Pen Pigment Liner Micron 0.05mm-0.8mm', 'imoda 1PC STA Waterproof Sketch Art Marker Pen Pigment Liner Micron 0.05mm-0.8mm', 17.90, 'https://cf.shopee.com.my/file/6d0a942d9a1b55b1c29db5b053b08ca2', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1337, 'Faber-Castell True Gel Pen (0.5mm / 0.7mm / Blue / Black / Red)', 'Faber-Castell True Gel Pen (0.5mm / 0.7mm / Blue / Black / Red)', 'Faber-Castell True Gel Pen (0.5mm / 0.7mm / Blue / Black / Red)', 14.50, 'https://cf.shopee.com.my/file/e9969fc68bcca53ca5805c50e458787a', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1338, 'GETMORE Pure Copper Gold Plated High Speed HDMI Cable V2.0 (1m/1.5m/2m/3m/5m) Support 4K', 'GETMORE Pure Copper Gold Plated High Speed HDMI Cable V2.0 (1m/1.5m/2m/3m/5m) Support 4K', 'GETMORE Pure Copper Gold Plated High Speed HDMI Cable V2.0 (1m/1.5m/2m/3m/5m) Support 4K', 89.00, 'https://cf.shopee.com.my/file/b36eb817556579e4e258c58437943010', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1339, 'Tali guni tali jut hemp rope hem cordage 0.1cm ~ 1.2cm x 1 meter', 'Tali guni tali jut hemp rope hem cordage 0.1cm ~ 1.2cm x 1 meter', 'Tali guni tali jut hemp rope hem cordage 0.1cm ~ 1.2cm x 1 meter', 1.90, 'https://cf.shopee.com.my/file/19e8c57184477267ebd4875a16f2f6c1', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1342, 'Pair Ankle Sand Weight Wrist Arm Leg (0.5kg - 6kg)', 'Pair Ankle Sand Weight Wrist Arm Leg (0.5kg - 6kg)', 'Pair Ankle Sand Weight Wrist Arm Leg (0.5kg - 6kg)', 125.00, 'https://cf.shopee.com.my/file/88b4a9a277ff0a4278732a9696bd0a63', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1345, 'Stridex Salicylic Acid 0.5% With Acne Medication 55 Soft Touch Pads', 'Stridex Salicylic Acid 0.5% With Acne Medication 55 Soft Touch Pads', 'Stridex Salicylic Acid 0.5% With Acne Medication 55 Soft Touch Pads', 356.00, 'https://cf.shopee.com.my/file/9e754a8b9d1e75e95608c93a7f50184d', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1346, 'MAM Silk Teat (Size 0, 1, 2, 3, X & Spill Free)', 'MAM Silk Teat (Size 0, 1, 2, 3, X & Spill Free)', 'MAM Silk Teat (Size 0, 1, 2, 3, X & Spill Free)', 267.00, 'https://cf.shopee.com.my/file/e8313e6cbd109f600ae061c4f8db6987', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1347, '2 GANG 40/0.16 X 3C SIRIM EXTENTION BOX ROUND EXTENSION CABLE BOX SOCKET (7//10 Meter) 2GANG', '2 GANG 40/0.16 X 3C SIRIM EXTENTION BOX ROUND EXTENSION CABLE BOX SOCKET (7//10 Meter) 2GANG', '2 GANG 40/0.16 X 3C SIRIM EXTENTION BOX ROUND EXTENSION CABLE BOX SOCKET (7//10 Meter) 2GANG', 242.60, 'https://cf.shopee.com.my/file/b9b934650fef7f074289f0cfefd1bcf3', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1348, '0-5Years Baby Boys Kids Cute Vest T shirt + Pants Cartoon Clothes Suit 2Pcs/Set', '0-5Years Baby Boys Kids Cute Vest T shirt + Pants Cartoon Clothes Suit 2Pcs/Set', '0-5Years Baby Boys Kids Cute Vest T shirt + Pants Cartoon Clothes Suit 2Pcs/Set', 65.40, 'https://cf.shopee.com.my/file/56ea080f3b8bde4a76853767f3c52c0f', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1349, 'Frisolac AR [Frisolac Comfort]  (0 - 12 Months) 400g Special Formula Anti Regurgitation EXP: 8/4/2023', 'Frisolac AR [Frisolac Comfort]  (0 - 12 Months) 400g Special Formula Anti Regurgitation EXP: 8/4/2023', 'Frisolac AR [Frisolac Comfort]  (0 - 12 Months) 400g Special Formula Anti Regurgitation EXP: 8/4/2023', 478.90, 'https://cf.shopee.com.my/file/2bf40146aa66339618ccfcff5c399daf', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1350, 'Zebra Sarasa Clip Gel Pen JJ15 0.5mm', 'Zebra Sarasa Clip Gel Pen JJ15 0.5mm', 'Zebra Sarasa Clip Gel Pen JJ15 0.5mm', 27.80, 'https://cf.shopee.com.my/file/72fe60798075c16dffd94ad453929e13', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1351, '[MALAYSIA STOCK] 0-12months Baby Romper Plain 100% cotton Short Sleeve Onesie for Babies Premium Soft Cotton Bodysuit', '[MALAYSIA STOCK] 0-12months Baby Romper Plain 100% cotton Short Sleeve Onesie for Babies Premium Soft Cotton Bodysuit', '[MALAYSIA STOCK] 0-12months Baby Romper Plain 100% cotton Short Sleeve Onesie for Babies Premium Soft Cotton Bodysuit', 79.90, 'https://cf.shopee.com.my/file/c30466fa89af6fa68151a63a3f940de2', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1352, '<0.5mm Thick PVC Rigid Sheet> Size A3/A2 Thick Transparent PVC Sheet for DIY art craft architectural modelling material', '<0.5mm Thick PVC Rigid Sheet> Size A3/A2 Thick Transparent PVC Sheet for DIY art craft architectural modelling material', '<0.5mm Thick PVC Rigid Sheet> Size A3/A2 Thick Transparent PVC Sheet for DIY art craft architectural modelling material', 51.00, 'https://cf.shopee.com.my/file/901a84d4c89962e6a172cac69c270f5e', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1353, 'DUTCH BABY 0-12 MONTHS  350g DUTCH BABY 6-18 MONTHS 300g', 'DUTCH BABY 0-12 MONTHS  350g DUTCH BABY 6-18 MONTHS 300g', 'DUTCH BABY 0-12 MONTHS  350g DUTCH BABY 6-18 MONTHS 300g', 98.00, 'https://cf.shopee.com.my/file/7a5ea874ac68154de35e9f80ac382408', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1354, '(1kg) Seamaster F00 Fish Food Pellet 0.3mm size /Makanan ikan laga/guppy', '(1kg) Seamaster F00 Fish Food Pellet 0.3mm size /Makanan ikan laga/guppy', '(1kg) Seamaster F00 Fish Food Pellet 0.3mm size /Makanan ikan laga/guppy', 188.00, 'https://cf.shopee.com.my/file/39ac4c6eb79265589185950ce3d80762', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1355, 'SHANTUNG SILK EXLCUSIVE - Bidang 58 [RM5.99/0.5M SHJ] OPEN METER', 'SHANTUNG SILK EXLCUSIVE - Bidang 58 [RM5.99/0.5M SHJ] OPEN METER', 'SHANTUNG SILK EXLCUSIVE - Bidang 58 [RM5.99/0.5M SHJ] OPEN METER', 59.80, 'https://cf.shopee.com.my/file/f91ee75b6294796403f29eeb01faa142', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1356, 'Baby Romper Jumpsuit Girl Boy Short Sleeves Baju Raya Clothe Newborn Carter 0-24 Months 100% Cotton One Piece Cute Cartoon', 'Baby Romper Jumpsuit Girl Boy Short Sleeves Baju Raya Clothe Newborn Carter 0-24 Months 100% Cotton One Piece Cute Cartoon', 'Baby Romper Jumpsuit Girl Boy Short Sleeves Baju Raya Clothe Newborn Carter 0-24 Months 100% Cotton One Piece Cute Cartoon', 59.80, 'https://cf.shopee.com.my/file/b67fc6e2abb7f61037164c7199b489f0', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1357, '[Ribbon & Lace Series] spring and summer new butterfly non-slip baby flooring socks girl baby socks 0-1-3 years old sock', '[Ribbon & Lace Series] spring and summer new butterfly non-slip baby flooring socks girl baby socks 0-1-3 years old sock', '[Ribbon & Lace Series] spring and summer new butterfly non-slip baby flooring socks girl baby socks 0-1-3 years old sock', 59.00, 'https://cf.shopee.com.my/file/71511b05c8d90cc86f3ee7f81ab37e0e', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1358, 'Universal Travel Adapter Plug Socket With 2 USB Port 1.0/2.1 Amp & Power Indicator Light - Support US / UK / AU /EU Plug', 'Universal Travel Adapter Plug Socket With 2 USB Port 1.0/2.1 Amp & Power Indicator Light - Support US / UK / AU /EU Plug', 'Universal Travel Adapter Plug Socket With 2 USB Port 1.0/2.1 Amp & Power Indicator Light - Support US / UK / AU /EU Plug', 139.00, 'https://cf.shopee.com.my/file/1bf07e01226bb495c12f56a496cf27f4', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1359, 'CYBER COLORS : 24Hr Eyebrow Pencil (0.2G)', 'CYBER COLORS : 24Hr Eyebrow Pencil (0.2G)', 'CYBER COLORS : 24Hr Eyebrow Pencil (0.2G)', 167.70, 'https://cf.shopee.com.my/file/5a00b6f70c98c167eecdfce17a847e05', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1360, '0-5 years old new handsome children\'s suit baby boy fashion striped shirt canvas shorts two-piece suit', '0-5 years old new handsome children\'s suit baby boy fashion striped shirt canvas shorts two-piece suit', '0-5 years old new handsome children\'s suit baby boy fashion striped shirt canvas shorts two-piece suit', 159.80, 'https://cf.shopee.com.my/file/d9ad0cfde937643a8678a8311d965cd8', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1361, 'M&G 4 Colours Pen 0.7mm ABP80371 Color Ballpoint Pen BallPen (Blue, Black, Red Green)', 'M&G 4 Colours Pen 0.7mm ABP80371 Color Ballpoint Pen BallPen (Blue, Black, Red Green)', 'M&G 4 Colours Pen 0.7mm ABP80371 Color Ballpoint Pen BallPen (Blue, Black, Red Green)', 18.50, 'https://cf.shopee.com.my/file/06fe381e13b1f7c3a9854eacb2004ed5', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1362, '[MD Keto] [2-6 packs] 200g Lakanto monk fruit sweetener  keto friendly, 0% sugar low carb monkfruit Non-GMO Erythritol', '[MD Keto] [2-6 packs] 200g Lakanto monk fruit sweetener  keto friendly, 0% sugar low carb monkfruit Non-GMO Erythritol', '[MD Keto] [2-6 packs] 200g Lakanto monk fruit sweetener  keto friendly, 0% sugar low carb monkfruit Non-GMO Erythritol', 287.00, 'https://cf.shopee.com.my/file/dccd9d68f732034b73cb8a757effc3a0', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1363, '3 Set Bundle Wholesale !! Newborn Eyelet Baby Set Bundles clothing suit 0-3m baby baju lubang- JK Kids Mykids Anakku Fi', '3 Set Bundle Wholesale !! Newborn Eyelet Baby Set Bundles clothing suit 0-3m baby baju lubang- JK Kids Mykids Anakku Fi', '3 Set Bundle Wholesale !! Newborn Eyelet Baby Set Bundles clothing suit 0-3m baby baju lubang- JK Kids Mykids Anakku Fi', 49.90, 'https://cf.shopee.com.my/file/4abae9d60dd904abb23ccf8571bae559', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1364, '0-2 Years Baby Girl Clothing/ Short Sleeve Shirt & Pants / Playset Baby Girl/ Kids blouse', '0-2 Years Baby Girl Clothing/ Short Sleeve Shirt & Pants / Playset Baby Girl/ Kids blouse', '0-2 Years Baby Girl Clothing/ Short Sleeve Shirt & Pants / Playset Baby Girl/ Kids blouse', 99.00, 'https://cf.shopee.com.my/file/ff51348f6cf8115918c32fb148025149', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1366, 'FFC FPC Flexible Flat Cable Ribbon Pitch 0.5mm 1.0mm Laptop Spare Part', 'FFC FPC Flexible Flat Cable Ribbon Pitch 0.5mm 1.0mm Laptop Spare Part', 'FFC FPC Flexible Flat Cable Ribbon Pitch 0.5mm 1.0mm Laptop Spare Part', 93.00, 'https://cf.shopee.com.my/file/f21e88d3cad107082c7d79d2f93ad9de', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1367, 'SKM T2 Black Red Blue Ink Pen 0.5mm For Office and School use', 'SKM T2 Black Red Blue Ink Pen 0.5mm For Office and School use', 'SKM T2 Black Red Blue Ink Pen 0.5mm For Office and School use', 7.50, 'https://cf.shopee.com.my/file/b16b8418575cb42432b5a6fff506ea0f', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1368, 'G\'Soft Writemate WX1 | Gsoft Semi Gel Ink Ball Pen | Nano Tip 0.4mm', 'G\'Soft Writemate WX1 | Gsoft Semi Gel Ink Ball Pen | Nano Tip 0.4mm', 'G\'Soft Writemate WX1 | Gsoft Semi Gel Ink Ball Pen | Nano Tip 0.4mm', 9.90, 'https://cf.shopee.com.my/file/22fb90ff272d6c8f0116fb715a69111f', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1370, '6 in 1 OTG Card Reader Type-C Micro USB Flash Drive 480Mpbs High-speed USB2.0 Universal OTG TF/SD Card Reader for Android Mobile Phone Computer Smartphone MacBook and PC Laptop', '6 in 1 OTG Card Reader Type-C Micro USB Flash Drive 480Mpbs High-speed USB2.0 Universal OTG TF/SD Card Reader for Android Mobile Phone Computer Smartphone MacBook and PC Laptop', '6 in 1 OTG Card Reader Type-C Micro USB Flash Drive 480Mpbs High-speed USB2.0 Universal OTG TF/SD Card Reader for Android Mobile Phone Computer Smartphone MacBook and PC Laptop', 199.00, 'https://cf.shopee.com.my/file/9a87cb0d32b1c6654857ac9ad66c7288', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1371, 'Android 10.0 OS X96Q ALLWINNER UK TV BOX Quad Core WIFI 4K 3D Media Streamer USB', 'Android 10.0 OS X96Q ALLWINNER UK TV BOX Quad Core WIFI 4K 3D Media Streamer USB', 'Android 10.0 OS X96Q ALLWINNER UK TV BOX Quad Core WIFI 4K 3D Media Streamer USB', 910.80, 'https://cf.shopee.com.my/file/ed9c2f5b48732c6a193948cfcb6a6387', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1372, 'RVB2 Multicore Wire 0.5mm2 AWG 20 (1 meter) Red and Black', 'RVB2 Multicore Wire 0.5mm2 AWG 20 (1 meter) Red and Black', 'RVB2 Multicore Wire 0.5mm2 AWG 20 (1 meter) Red and Black', 30.00, 'https://cf.shopee.com.my/file/1cd35524e553c50244362598274ea194', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1373, '2.5 inch USB3.0 to SATA 3 Box HDD External SSD HDD Case HDD Enclosure Case Hard disk case ssd case usb3 hard disk', '2.5 inch USB3.0 to SATA 3 Box HDD External SSD HDD Case HDD Enclosure Case Hard disk case ssd case usb3 hard disk', '2.5 inch USB3.0 to SATA 3 Box HDD External SSD HDD Case HDD Enclosure Case Hard disk case ssd case usb3 hard disk', 25.00, 'https://cf.shopee.com.my/file/486541f6e33974a338a8a55394716328', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1375, 'Newborn Baby Clothing Singlet Set Sleeveless 0-6 months Boy Girl Blue Pink Green Yellow Baju Bayi Bear Friends Budak', 'Newborn Baby Clothing Singlet Set Sleeveless 0-6 months Boy Girl Blue Pink Green Yellow Baju Bayi Bear Friends Budak', 'Newborn Baby Clothing Singlet Set Sleeveless 0-6 months Boy Girl Blue Pink Green Yellow Baju Bayi Bear Friends Budak', 89.00, 'https://cf.shopee.com.my/file/27524cb4e4f243bd258b85fd918cace9', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1376, '(0-1, 1-2, 2-3months) NEW ARRIVAL 31-03-2021 !!! Newborn Baby Turban Flower Hat Cap Headband', '(0-1, 1-2, 2-3months) NEW ARRIVAL 31-03-2021 !!! Newborn Baby Turban Flower Hat Cap Headband', '(0-1, 1-2, 2-3months) NEW ARRIVAL 31-03-2021 !!! Newborn Baby Turban Flower Hat Cap Headband', 39.80, 'https://cf.shopee.com.my/file/32189b98fb334b54afe09243e8770e7b', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1377, '[ 100% ORIGINAL  ] REMAX 20000mAh 5A Super Fast Charge PD Qualcomm 3.0 Powerbank QC4+ QC3.0 FCP VOOC AFC SCP FSCP PE PPS', '[ 100% ORIGINAL  ] REMAX 20000mAh 5A Super Fast Charge PD Qualcomm 3.0 Powerbank QC4+ QC3.0 FCP VOOC AFC SCP FSCP PE PPS', '[ 100% ORIGINAL  ] REMAX 20000mAh 5A Super Fast Charge PD Qualcomm 3.0 Powerbank QC4+ QC3.0 FCP VOOC AFC SCP FSCP PE PPS', 499.00, 'https://cf.shopee.com.my/file/a6cc45592be15ce9d1aafc96c9072c7a', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1378, '[Malaysia Stock] TUTUYA 0-3 Years Old antivirus Baby Kids Children Waterproof Dustproof Face Shield Protective Cover Cap', '[Malaysia Stock] TUTUYA 0-3 Years Old antivirus Baby Kids Children Waterproof Dustproof Face Shield Protective Cover Cap', '[Malaysia Stock] TUTUYA 0-3 Years Old antivirus Baby Kids Children Waterproof Dustproof Face Shield Protective Cover Cap', 277.00, 'https://cf.shopee.com.my/file/f6efcca553b72a841da9199628751bc7', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1381, 'Zebra Prima II Vacuum Flask (0.35L/0.45L/0.8L/1.0L)', 'Zebra Prima II Vacuum Flask (0.35L/0.45L/0.8L/1.0L)', 'Zebra Prima II Vacuum Flask (0.35L/0.45L/0.8L/1.0L)', 580.00, 'https://cf.shopee.com.my/file/d83f3f6fa0794fe634317e1a7c5e1149', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1382, 'Ready Stock Summer Infant Baby Boy Cartoon Clothes Sets Boy Clothing Suit 0-5 Yrs', 'Ready Stock Summer Infant Baby Boy Cartoon Clothes Sets Boy Clothing Suit 0-5 Yrs', 'Ready Stock Summer Infant Baby Boy Cartoon Clothes Sets Boy Clothing Suit 0-5 Yrs', 159.80, 'https://cf.shopee.com.my/file/e6c90c50a0742261d830d845cd2218e7', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1383, 'Wire Suasa, Dawai Suasa (Gold Filled), Round Wire, 0.45mm, 0.50mm, 0.60mm, 0.70mm', 'Wire Suasa, Dawai Suasa (Gold Filled), Round Wire, 0.45mm, 0.50mm, 0.60mm, 0.70mm', 'Wire Suasa, Dawai Suasa (Gold Filled), Round Wire, 0.45mm, 0.50mm, 0.60mm, 0.70mm', 450.00, 'https://cf.shopee.com.my/file/1ea480c169720c297fba0229ce13a046', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1384, 'LED 24W T8 TUBE 4FT(1.2M)+Casing /2FT(0.6M) 15W+ T8 CASING(SET)', 'LED 24W T8 TUBE 4FT(1.2M)+Casing /2FT(0.6M) 15W+ T8 CASING(SET)', 'LED 24W T8 TUBE 4FT(1.2M)+Casing /2FT(0.6M) 15W+ T8 CASING(SET)', 56.00, 'https://cf.shopee.com.my/file/9dc4f244eba7780924c0dccffe154b12', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1385, '0-3Yrs Newborn Baby Socks Kids Knee High Socks Infant Toddler Cartoon Anti Mosquito Stockings', '0-3Yrs Newborn Baby Socks Kids Knee High Socks Infant Toddler Cartoon Anti Mosquito Stockings', '0-3Yrs Newborn Baby Socks Kids Knee High Socks Infant Toddler Cartoon Anti Mosquito Stockings', 19.80, 'https://cf.shopee.com.my/file/ceb21c5a1f3a0c2adbf9b5e6fb9ca38b', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1386, 'Off cut pine wood used  P 25cm x L 3in x 0.5in (max25 batang satu shipping)', 'Off cut pine wood used  P 25cm x L 3in x 0.5in (max25 batang satu shipping)', 'Off cut pine wood used  P 25cm x L 3in x 0.5in (max25 batang satu shipping)', 15.00, 'https://cf.shopee.com.my/file/d3efbbc5f9e43b741b7732122d70a824', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1388, 'Vicks Inhaler (0.5ml)', 'Vicks Inhaler (0.5ml)', 'Vicks Inhaler (0.5ml)', 67.70, 'https://cf.shopee.com.my/file/402336a1bd558147c1a62702c9812dfa', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1389, 'Pentel Fiesta Mechanical Pencil 0.5mm / 0.7mm AX105 AX107', 'Pentel Fiesta Mechanical Pencil 0.5mm / 0.7mm AX105 AX107', 'Pentel Fiesta Mechanical Pencil 0.5mm / 0.7mm AX105 AX107', 19.40, 'https://cf.shopee.com.my/file/1a5b7e0b0ebe244a1d9374531803c63d', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1390, 'Boy fashion suit 0-5 year old boy polo shirt suit T-shirt katun lengan pendek kanak-kanak + seluar 2pcs pakaian bayi', 'Boy fashion suit 0-5 year old boy polo shirt suit T-shirt katun lengan pendek kanak-kanak + seluar 2pcs pakaian bayi', 'Boy fashion suit 0-5 year old boy polo shirt suit T-shirt katun lengan pendek kanak-kanak + seluar 2pcs pakaian bayi', 165.00, 'https://cf.shopee.com.my/file/29ee374bfb6ac2dfdf747fb550f1dbe4', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1391, 'TWILL SPANDEX - Bidang 57\" - 60\" : RM6 untuk 0.5mtr', 'TWILL SPANDEX - Bidang 57\" - 60\" : RM6 untuk 0.5mtr', 'TWILL SPANDEX - Bidang 57\" - 60\" : RM6 untuk 0.5mtr', 54.00, 'https://cf.shopee.com.my/file/fb05c6cac11998e909015bec1afc38f5', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1392, '5 PCS baby romper newborn baby clothing clothes baju bayi newborn Baby One Piece bodysuits rompers O-neck 0-12M baby Jumpsuit Cotton  baby clothes sets', '5 PCS baby romper newborn baby clothing clothes baju bayi newborn Baby One Piece bodysuits rompers O-neck 0-12M baby Jumpsuit Cotton  baby clothes sets', '5 PCS baby romper newborn baby clothing clothes baju bayi newborn Baby One Piece bodysuits rompers O-neck 0-12M baby Jumpsuit Cotton  baby clothes sets', 379.90, 'https://cf.shopee.com.my/file/c851df2ab27a970e7500e4a006a85df9', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1393, '(50PCS)UTS SUPER HEAVY DUTY PIKE JIGGING HOOK 1/0;2/0;3/0;4/0 50PCS PER PKT', '(50PCS)UTS SUPER HEAVY DUTY PIKE JIGGING HOOK 1/0;2/0;3/0;4/0 50PCS PER PKT', '(50PCS)UTS SUPER HEAVY DUTY PIKE JIGGING HOOK 1/0;2/0;3/0;4/0 50PCS PER PKT', 250.00, 'https://cf.shopee.com.my/file/e7e76c7d9245ca87ea5fb416737fe1f7', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1394, 'Tikar Getah Quality,Buatan Thailand,Tebal 0.30mm,1.37M X 1M', 'Tikar Getah Quality,Buatan Thailand,Tebal 0.30mm,1.37M X 1M', 'Tikar Getah Quality,Buatan Thailand,Tebal 0.30mm,1.37M X 1M', 34.50, 'https://cf.shopee.com.my/file/bec2197327d7ff1871a77379b545844e', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1395, 'MIDEA Rice Cooker (0.6L) MG-GP06B with Glass Lid', 'MIDEA Rice Cooker (0.6L) MG-GP06B with Glass Lid', 'MIDEA Rice Cooker (0.6L) MG-GP06B with Glass Lid', 468.00, 'https://cf.shopee.com.my/file/3af76c59155461948b4948d7a5aaecfa', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1396, 'Anker PowerCore Select PIQ2.0 Fast Charge Input & Output Power Bank (20000mAh/18W) A1363', 'Anker PowerCore Select PIQ2.0 Fast Charge Input & Output Power Bank (20000mAh/18W) A1363', 'Anker PowerCore Select PIQ2.0 Fast Charge Input & Output Power Bank (20000mAh/18W) A1363', 1390.00, 'https://cf.shopee.com.my/file/4878cadb200bd1b52c3ae36c74598d1f', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1397, 'UTS 3X Power Double Hook/Mata Dua 2/0; 3/0 (PER PCS)', 'UTS 3X Power Double Hook/Mata Dua 2/0; 3/0 (PER PCS)', 'UTS 3X Power Double Hook/Mata Dua 2/0; 3/0 (PER PCS)', 15.00, 'https://cf.shopee.com.my/file/a32d2f1ccd2762e7c66cb6802cb575a1', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1400, '8SET COMBO New Born Baby Suit Long/short Sleeve+Long /short Pant / Baju Baby Baru Lahir 0-6m', '8SET COMBO New Born Baby Suit Long/short Sleeve+Long /short Pant / Baju Baby Baru Lahir 0-6m', '8SET COMBO New Born Baby Suit Long/short Sleeve+Long /short Pant / Baju Baby Baru Lahir 0-6m', 990.00, 'https://cf.shopee.com.my/file/7b5f9dbce9b8d5bd5250bf54c8cc18e7', 1627909670, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1401, 'Replacement Nozzles 0.2mm / 0.3mm / 0.4mm / 0.6mm / 0.8mm / 1.0mm  for Creality Ender 3 / Ender 5 / CR-10 3D Printer MK8', 'Replacement Nozzles 0.2mm / 0.3mm / 0.4mm / 0.6mm / 0.8mm / 1.0mm  for Creality Ender 3 / Ender 5 / CR-10 3D Printer MK8', 'Replacement Nozzles 0.2mm / 0.3mm / 0.4mm / 0.6mm / 0.8mm / 1.0mm  for Creality Ender 3 / Ender 5 / CR-10 3D Printer MK8', 29.00, 'https://cf.shopee.com.my/file/60db78c41ad04533001268d6df55bdd7', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1402, 'R3 Pod Kit & 0.6 Mesh Occ can use in Artery Pal 2 pro', 'R3 Pod Kit & 0.6 Mesh Occ can use in Artery Pal 2 pro', 'R3 Pod Kit & 0.6 Mesh Occ can use in Artery Pal 2 pro', 155.00, 'https://cf.shopee.com.my/file/209a5a14dc9283e5b607806dbfacfc32', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1404, 'Faber Castell / Faber-Castell RX Gel 0.5/0.7mm', 'Faber Castell / Faber-Castell RX Gel 0.5/0.7mm', 'Faber Castell / Faber-Castell RX Gel 0.5/0.7mm', 15.00, 'https://cf.shopee.com.my/file/90fd5642825584d661a7923ca35ec228', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1406, 'HT Socket Cap Screw - M4 x 6mm ~ 30mm (Coarse Thread Pitch 0.7mm) (High Tensile Grade 12.9 Allen Cap Bolt)', 'HT Socket Cap Screw - M4 x 6mm ~ 30mm (Coarse Thread Pitch 0.7mm) (High Tensile Grade 12.9 Allen Cap Bolt)', 'HT Socket Cap Screw - M4 x 6mm ~ 30mm (Coarse Thread Pitch 0.7mm) (High Tensile Grade 12.9 Allen Cap Bolt)', 1.50, 'https://cf.shopee.com.my/file/5d7d025895a61370ea184e640f8e20e0', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1407, 'Anakku Newborn Baby Boy Gift Set / Set Hadiah Bayi Lelaki 0-3 Months (5 pcs) EAK312-1', 'Anakku Newborn Baby Boy Gift Set / Set Hadiah Bayi Lelaki 0-3 Months (5 pcs) EAK312-1', 'Anakku Newborn Baby Boy Gift Set / Set Hadiah Bayi Lelaki 0-3 Months (5 pcs) EAK312-1', 475.00, 'https://cf.shopee.com.my/file/46f3b51fbc7973bb2fe837c79121b11f', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1408, 'g.hut 5A 66W LED TYPE C ZINC ALLOY QC4.0 OPPO SUPER VOOC ONE PLUS WARP REALME SUPER DART HUAWEI SUPERCHARGE 65W Fast', 'g.hut 5A 66W LED TYPE C ZINC ALLOY QC4.0 OPPO SUPER VOOC ONE PLUS WARP REALME SUPER DART HUAWEI SUPERCHARGE 65W Fast', 'g.hut 5A 66W LED TYPE C ZINC ALLOY QC4.0 OPPO SUPER VOOC ONE PLUS WARP REALME SUPER DART HUAWEI SUPERCHARGE 65W Fast', 88.00, 'https://cf.shopee.com.my/file/2a35d1c6dccd017c0724ed2d42cb54e2', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1411, 'GSOFT W2 0.5MM & 0.7MM BALL PEN - 25PCS / DRUM', 'GSOFT W2 0.5MM & 0.7MM BALL PEN - 25PCS / DRUM', 'GSOFT W2 0.5MM & 0.7MM BALL PEN - 25PCS / DRUM', 158.00, 'https://cf.shopee.com.my/file/3e891f21ff3d3915e8e6ee4cfba1f0b7', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1412, '*OCC* NEVOKS FEELIN SPL 10 0.6ohm / 1.0ohm REPLACEMENT COIL (ORIGINAL)', '*OCC* NEVOKS FEELIN SPL 10 0.6ohm / 1.0ohm REPLACEMENT COIL (ORIGINAL)', '*OCC* NEVOKS FEELIN SPL 10 0.6ohm / 1.0ohm REPLACEMENT COIL (ORIGINAL)', 99.90, 'https://cf.shopee.com.my/file/3cfb6f5753a7055dc870549b90c15510', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1413, 'FLEXOFFICE Smooth Ink Pen Flexstick - Black/Blue/Red (0.7x 1/3 Pcs/pack) FO-GELB08', 'FLEXOFFICE Smooth Ink Pen Flexstick - Black/Blue/Red (0.7x 1/3 Pcs/pack) FO-GELB08', 'FLEXOFFICE Smooth Ink Pen Flexstick - Black/Blue/Red (0.7x 1/3 Pcs/pack) FO-GELB08', 8.50, 'https://cf.shopee.com.my/file/629f1fc436b2a476d59c62b400f34855', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1419, 'Faber-Castell Air Gel Ball Pen / Refill [0.5mm/0.7mm]', 'Faber-Castell Air Gel Ball Pen / Refill [0.5mm/0.7mm]', 'Faber-Castell Air Gel Ball Pen / Refill [0.5mm/0.7mm]', 19.00, 'https://cf.shopee.com.my/file/06398c9e61440146837d6f71d46af070', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1420, 'ARTLINE STAMP no. 00/no.0/no.1/no.2', 'ARTLINE STAMP no. 00/no.0/no.1/no.2', 'ARTLINE STAMP no. 00/no.0/no.1/no.2', 66.00, 'https://cf.shopee.com.my/file/a7c108da004e15edbf478945c653db40', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1421, 'Resistor 10k ohm (Carbon - 0.25W)', 'Resistor 10k ohm (Carbon - 0.25W)', 'Resistor 10k ohm (Carbon - 0.25W)', 1.00, 'https://cf.shopee.com.my/file/c2049fa7a9122bf8e5d429dd0279451c', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1422, 'HIGHSpeed USB3.0 / USB2.0 4 PORT HUB (30cm) Usb 3.0 4 Port Usb Hub', 'HIGHSpeed USB3.0 / USB2.0 4 PORT HUB (30cm) Usb 3.0 4 Port Usb Hub', 'HIGHSpeed USB3.0 / USB2.0 4 PORT HUB (30cm) Usb 3.0 4 Port Usb Hub', 58.80, 'https://cf.shopee.com.my/file/f3723c200d35fdebdb7606ddd0cf4813', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1423, '[ Malaysia readystock] Micro USB 2.0/3.0 hub 4/7 port high-speed USB hub with on/off switch for laptops', '[ Malaysia readystock] Micro USB 2.0/3.0 hub 4/7 port high-speed USB hub with on/off switch for laptops', '[ Malaysia readystock] Micro USB 2.0/3.0 hub 4/7 port high-speed USB hub with on/off switch for laptops', 39.90, 'https://cf.shopee.com.my/file/294cd7289f4e9d24a98f62cac5cff2e1', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1424, '[1m X 0.5m=1unit Jointed Roll] Grass Carpet/ Rumput Tiruan/ Grass Carpet Indoor/ Grass Mat/ Grass Carpet Roll', '[1m X 0.5m=1unit Jointed Roll] Grass Carpet/ Rumput Tiruan/ Grass Carpet Indoor/ Grass Mat/ Grass Carpet Roll', '[1m X 0.5m=1unit Jointed Roll] Grass Carpet/ Rumput Tiruan/ Grass Carpet Indoor/ Grass Mat/ Grass Carpet Roll', 54.40, 'https://cf.shopee.com.my/file/3b694eff44d3bc2dc0765254de2fed0d', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1425, 'Workout Weight Training Sand Bag Pair Ankle Weight (2 Pcs x 0.5kg/1.5kg/2.5kg )', 'Workout Weight Training Sand Bag Pair Ankle Weight (2 Pcs x 0.5kg/1.5kg/2.5kg )', 'Workout Weight Training Sand Bag Pair Ankle Weight (2 Pcs x 0.5kg/1.5kg/2.5kg )', 99.90, 'https://cf.shopee.com.my/file/b183a347b353031e5fea4c1862a81196', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1427, 'Gel Pen 0.35mm Black /Red/Blue Ink Pen', 'Gel Pen 0.35mm Black /Red/Blue Ink Pen', 'Gel Pen 0.35mm Black /Red/Blue Ink Pen', 8.50, 'https://cf.shopee.com.my/file/918fcfcb6486682d44d3a6174e20e71c', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1428, 'Euro Truck Simulator 2 v1.41.1.0 Unlock All Truck [LATEST DLC] [PC DIGITAL DOWNLOAD] [OFFLINE] [GOOGLE-DRIVE]', 'Euro Truck Simulator 2 v1.41.1.0 Unlock All Truck [LATEST DLC] [PC DIGITAL DOWNLOAD] [OFFLINE] [GOOGLE-DRIVE]', 'Euro Truck Simulator 2 v1.41.1.0 Unlock All Truck [LATEST DLC] [PC DIGITAL DOWNLOAD] [OFFLINE] [GOOGLE-DRIVE]', 30.00, 'https://cf.shopee.com.my/file/b951c1188dbfd726fa327fdbb45b6340', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1429, 'Rapoo M160G Silent Multi-Mode Wireless Bluetooth 3.0/ 4.0/ wireless 2.4GHz Mouse', 'Rapoo M160G Silent Multi-Mode Wireless Bluetooth 3.0/ 4.0/ wireless 2.4GHz Mouse', 'Rapoo M160G Silent Multi-Mode Wireless Bluetooth 3.0/ 4.0/ wireless 2.4GHz Mouse', 280.00, 'https://cf.shopee.com.my/file/fae2a56a13870221d666425ee479de8c', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1430, '500g/0.01g Professional Digital Jewelry Pocket Scale High Accuracy Portable Mini Scale Skala Penimbang Emas Batu Permata', '500g/0.01g Professional Digital Jewelry Pocket Scale High Accuracy Portable Mini Scale Skala Penimbang Emas Batu Permata', '500g/0.01g Professional Digital Jewelry Pocket Scale High Accuracy Portable Mini Scale Skala Penimbang Emas Batu Permata', 189.90, 'https://cf.shopee.com.my/file/dd0ec4ea8a03d9fe187bce091b9124ee', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1432, 'PNY Turbo Attache 4 USB3.0 High Speed Pendrive 16GB / 32GB / 64GB / 128GB / 256GB 5 Years Warranty 1 to 1 Exchange', 'PNY Turbo Attache 4 USB3.0 High Speed Pendrive 16GB / 32GB / 64GB / 128GB / 256GB 5 Years Warranty 1 to 1 Exchange', 'PNY Turbo Attache 4 USB3.0 High Speed Pendrive 16GB / 32GB / 64GB / 128GB / 256GB 5 Years Warranty 1 to 1 Exchange', 250.00, 'https://cf.shopee.com.my/file/289630f001ac3d95298bb62fc1392e87', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1433, 'Zebra Sarasa Clip Gel Pen JJB15 0.7mm', 'Zebra Sarasa Clip Gel Pen JJB15 0.7mm', 'Zebra Sarasa Clip Gel Pen JJB15 0.7mm', 27.80, 'https://cf.shopee.com.my/file/91c648abdf8dd460e6d2e137802f10f7', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1437, 'BREMBO GP4/UNIVESAL CALIPER AIR SCREW (1.0/1.2)', 'BREMBO GP4/UNIVESAL CALIPER AIR SCREW (1.0/1.2)', 'BREMBO GP4/UNIVESAL CALIPER AIR SCREW (1.0/1.2)', 120.00, 'https://cf.shopee.com.my/file/72f30e59b523239a13a3263f7e3bc12f', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1439, 'Kain Pasang Lining & Tudung Chiffon Georgette Soft Bidang 60 [Harga utk 0.5M]', 'Kain Pasang Lining & Tudung Chiffon Georgette Soft Bidang 60 [Harga utk 0.5M]', 'Kain Pasang Lining & Tudung Chiffon Georgette Soft Bidang 60 [Harga utk 0.5M]', 37.50, 'https://cf.shopee.com.my/file/47ee2885a5fdb577e64c2888b32def22', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1440, 'Sunlu TPU Flexible 3d printer Filament 1.75mm 0.5KG - tpu flex pla abs', 'Sunlu TPU Flexible 3d printer Filament 1.75mm 0.5KG - tpu flex pla abs', 'Sunlu TPU Flexible 3d printer Filament 1.75mm 0.5KG - tpu flex pla abs', 419.00, 'https://cf.shopee.com.my/file/6006edd26659dac5b4fc9023d45ea80c', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1441, 'External Case HDD USB 3.0 Enclosure hard disk SATA 2.5 inch HDD USB3.0 External Hard Drive Metal Cover Case ', 'External Case HDD USB 3.0 Enclosure hard disk SATA 2.5 inch HDD USB3.0 External Hard Drive Metal Cover Case ', 'External Case HDD USB 3.0 Enclosure hard disk SATA 2.5 inch HDD USB3.0 External Hard Drive Metal Cover Case ', 189.00, 'https://cf.shopee.com.my/file/b9d1c65b76bd444b30805f21f7263fd5', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1442, '1pcs Acrylic Cake Crown Bowler Hat 0-9 Golden Number Cake Inserted Flag Wedding Baby Shower Cake Birthday Decration', '1pcs Acrylic Cake Crown Bowler Hat 0-9 Golden Number Cake Inserted Flag Wedding Baby Shower Cake Birthday Decration', '1pcs Acrylic Cake Crown Bowler Hat 0-9 Golden Number Cake Inserted Flag Wedding Baby Shower Cake Birthday Decration', 12.20, 'https://cf.shopee.com.my/file/328bc24dbc9d17b56efbd74a34d26999', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1443, 'Winzige 1 Piece BTS BT21 Gel Pen Bangtan Boys Cute Stationery Supplies Black 0.38mm', 'Winzige 1 Piece BTS BT21 Gel Pen Bangtan Boys Cute Stationery Supplies Black 0.38mm', 'Winzige 1 Piece BTS BT21 Gel Pen Bangtan Boys Cute Stationery Supplies Black 0.38mm', 8.00, 'https://cf.shopee.com.my/file/195dcc7852efffe1f6c5876f7a895327', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1444, 'DOTMOD DOTSTICK 0.4 OHM/0.7 OHM/1.0 OHM (5 PCS)', 'DOTMOD DOTSTICK 0.4 OHM/0.7 OHM/1.0 OHM (5 PCS)', 'DOTMOD DOTSTICK 0.4 OHM/0.7 OHM/1.0 OHM (5 PCS)', 650.00, 'https://cf.shopee.com.my/file/731f7a294461024962c9f509dec7a8e8', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1445, 'Kids clothes (0-5 year old) baby girls boys 100% cotton cartoon casual pants', 'Kids clothes (0-5 year old) baby girls boys 100% cotton cartoon casual pants', 'Kids clothes (0-5 year old) baby girls boys 100% cotton cartoon casual pants', 66.00, 'https://cf.shopee.com.my/file/6027901e70e425220fc165dad254d3b8', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1446, 'Ready Stock 5 Pair Cotton Baby Socks Animal Design Soft Newborn Infant Kids Socks d Stokin Bayi Stoking Kanak-kanak 0-6Y', 'Ready Stock 5 Pair Cotton Baby Socks Animal Design Soft Newborn Infant Kids Socks d Stokin Bayi Stoking Kanak-kanak 0-6Y', 'Ready Stock 5 Pair Cotton Baby Socks Animal Design Soft Newborn Infant Kids Socks d Stokin Bayi Stoking Kanak-kanak 0-6Y', 127.20, 'https://cf.shopee.com.my/file/2e5e3f77493c0393139e861c413a0bf4', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1447, 'KUULAA Quick Charge 3.0 USB Charger 30W QC3.0 QC Fast Charging Multi Plug Mobile Phone Charger For iPhone Samsung Xiaomi Huawei', 'KUULAA Quick Charge 3.0 USB Charger 30W QC3.0 QC Fast Charging Multi Plug Mobile Phone Charger For iPhone Samsung Xiaomi Huawei', 'KUULAA Quick Charge 3.0 USB Charger 30W QC3.0 QC Fast Charging Multi Plug Mobile Phone Charger For iPhone Samsung Xiaomi Huawei', 196.00, 'https://cf.shopee.com.my/file/ca334760fea760cc2709a7c81ee7e870', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1448, 'Wallpaper Cartoon Ready Stock Hello Kitty Toyo the Car Disney Self Adhesive Dimension: 0.26mm * 45cm * 10m', 'Wallpaper Cartoon Ready Stock Hello Kitty Toyo the Car Disney Self Adhesive Dimension: 0.26mm * 45cm * 10m', 'Wallpaper Cartoon Ready Stock Hello Kitty Toyo the Car Disney Self Adhesive Dimension: 0.26mm * 45cm * 10m', 130.00, 'https://cf.shopee.com.my/file/8d9d4682585dc5117ac2294a91ee6990', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1449, '5m 10m 50m 100m enamelled Copper wire magnet wire coil winding wire SWG 17,19,20,  1.422mm,1.016mm,0.914mm', '5m 10m 50m 100m enamelled Copper wire magnet wire coil winding wire SWG 17,19,20,  1.422mm,1.016mm,0.914mm', '5m 10m 50m 100m enamelled Copper wire magnet wire coil winding wire SWG 17,19,20,  1.422mm,1.016mm,0.914mm', 60.00, 'https://cf.shopee.com.my/file/dcc5a0b84a87620e04eb35bb9059c4f2', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1451, 'Ready Stock Malaysia Toddler Cotton Baby Socks Unisex Long Stockings 0-3 year boys girls cute', 'Ready Stock Malaysia Toddler Cotton Baby Socks Unisex Long Stockings 0-3 year boys girls cute', 'Ready Stock Malaysia Toddler Cotton Baby Socks Unisex Long Stockings 0-3 year boys girls cute', 25.00, 'https://cf.shopee.com.my/file/415f9fcabecd226d6e7cf4ec07dda67f', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1452, 'HDY Kids Camera Children Digital Camera Toys 8.0/13.0M.P Send SD Card HD Video Recording Selfie Kid Portable SLR Educational Toy Photography Boys Girls Early Learning Best Birthday Gifts Manian Bayi Chinese New Year Present Kidstoy Babytoy', 'HDY Kids Camera Children Digital Camera Toys 8.0/13.0M.P Send SD Card HD Video Recording Selfie Kid Portable SLR Educational Toy Photography Boys Girls Early Learning Best Birthday Gifts Manian Bayi Chinese New Year Present Kidstoy Babytoy', 'HDY Kids Camera Children Digital Camera Toys 8.0/13.0M.P Send SD Card HD Video Recording Selfie Kid Portable SLR Educational Toy Photography Boys Girls Early Learning Best Birthday Gifts Manian Bayi Chinese New Year Present Kidstoy Babytoy', 198.80, 'https://cf.shopee.com.my/file/92617c68f63610d7acbc85f84cc6323b', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1453, 'READY STOCK 12 Style Baby Mitten and Sock 4 pcs Gift Set (0-12 M, below 80cm) Sarang Kaki Tangan Hadiah Set AC-108', 'READY STOCK 12 Style Baby Mitten and Sock 4 pcs Gift Set (0-12 M, below 80cm) Sarang Kaki Tangan Hadiah Set AC-108', 'READY STOCK 12 Style Baby Mitten and Sock 4 pcs Gift Set (0-12 M, below 80cm) Sarang Kaki Tangan Hadiah Set AC-108', 69.00, 'https://cf.shopee.com.my/file/7984e1ac3c2f77e19f8cb75f4ddbb2c9', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1455, '0.25m/0.5m/1m/2m Micro USB Cable 3A Fast charging & data transfer For Xiaomi Samsung ASUS Huawei Oppo Vivo HTC Nokia', '0.25m/0.5m/1m/2m Micro USB Cable 3A Fast charging & data transfer For Xiaomi Samsung ASUS Huawei Oppo Vivo HTC Nokia', '0.25m/0.5m/1m/2m Micro USB Cable 3A Fast charging & data transfer For Xiaomi Samsung ASUS Huawei Oppo Vivo HTC Nokia', 12.00, 'https://cf.shopee.com.my/file/47ca51a32c0146fb628d122166f09388', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1456, '4T / 2T SS LUBE MINYAK 2 STROKE OIL 0.946L LITERS MOTORCYCLES S2 SERIES ENGINE OIL MOTORCYCLE', '4T / 2T SS LUBE MINYAK 2 STROKE OIL 0.946L LITERS MOTORCYCLES S2 SERIES ENGINE OIL MOTORCYCLE', '4T / 2T SS LUBE MINYAK 2 STROKE OIL 0.946L LITERS MOTORCYCLES S2 SERIES ENGINE OIL MOTORCYCLE', 60.00, 'https://cf.shopee.com.my/file/5fc37a143661110fbec6fb7f8315a12a', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1457, 'Flexoffice Startup Ball Pen Retractable Ball Pen  0.5mm / 0.7mm 12pcs/Drum', 'Flexoffice Startup Ball Pen Retractable Ball Pen  0.5mm / 0.7mm 12pcs/Drum', 'Flexoffice Startup Ball Pen Retractable Ball Pen  0.5mm / 0.7mm 12pcs/Drum', 59.50, 'https://cf.shopee.com.my/file/8c064241d493ebee8e8190c7ce97e4d1', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1458, 'HP v222w USB2.0 Flash Drives Pendrive ( 32GB / 64GB )', 'HP v222w USB2.0 Flash Drives Pendrive ( 32GB / 64GB )', 'HP v222w USB2.0 Flash Drives Pendrive ( 32GB / 64GB )', 159.00, 'https://cf.shopee.com.my/file/0f0c4c6aa998fa88a6670d12d645364f', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1459, '100% Original Remax RPP108 5A Super Fast Charge 20000mAh Power Bank RPP-108 PD3.0 Riji Series Power Bank QC3.0 Fast', '100% Original Remax RPP108 5A Super Fast Charge 20000mAh Power Bank RPP-108 PD3.0 Riji Series Power Bank QC3.0 Fast', '100% Original Remax RPP108 5A Super Fast Charge 20000mAh Power Bank RPP-108 PD3.0 Riji Series Power Bank QC3.0 Fast', 499.00, 'https://cf.shopee.com.my/file/23c3655aed27a0b4d8bcc59d2e62864c', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1461, 'New NUK Orthodontic Pacifier Soother 0-6m Unisex Single Loose (Polka Dots/White Stars/Lines/ Blue Elephant))', 'New NUK Orthodontic Pacifier Soother 0-6m Unisex Single Loose (Polka Dots/White Stars/Lines/ Blue Elephant))', 'New NUK Orthodontic Pacifier Soother 0-6m Unisex Single Loose (Polka Dots/White Stars/Lines/ Blue Elephant))', 129.00, 'https://cf.shopee.com.my/file/b92904e92d89c659f5972301a6d6cac9', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1462, 'Seamiart_1PC Highlight 0.6mm Needle Tip Pen/12 Colors is optional_DIY Tool for Cartoon/Pocket Diary', 'Seamiart_1PC Highlight 0.6mm Needle Tip Pen/12 Colors is optional_DIY Tool for Cartoon/Pocket Diary', 'Seamiart_1PC Highlight 0.6mm Needle Tip Pen/12 Colors is optional_DIY Tool for Cartoon/Pocket Diary', 7.60, 'https://cf.shopee.com.my/file/12521ef3551e0fcd3097f038119b823c', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1464, 'Air Optix Plus Hydraglyde Alcon Silicone - Power -0.50 to -12.00 (3 Pcs)', 'Air Optix Plus Hydraglyde Alcon Silicone - Power -0.50 to -12.00 (3 Pcs)', 'Air Optix Plus Hydraglyde Alcon Silicone - Power -0.50 to -12.00 (3 Pcs)', 419.60, 'https://cf.shopee.com.my/file/c7431912c1a8b98ed3f6c09a62ae91f4', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1465, 'Kreati Blue Gel Pen 4 IN 1 0.7MM - 0518', 'Kreati Blue Gel Pen 4 IN 1 0.7MM - 0518', 'Kreati Blue Gel Pen 4 IN 1 0.7MM - 0518', 21.00, 'https://cf.shopee.com.my/file/9742ef07d163193b6cdae24f45ec85d2', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1468, '0.5Mm Black Blue Red Gel Pen', '0.5Mm Black Blue Red Gel Pen', '0.5Mm Black Blue Red Gel Pen', 16.70, 'https://cf.shopee.com.my/file/0a628cc50105f26a1d17846b648c2d76', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1469, 'Bubble Wrap Single Layer/Double Layer (Size:0.5m or 1m x 100m)', 'Bubble Wrap Single Layer/Double Layer (Size:0.5m or 1m x 100m)', 'Bubble Wrap Single Layer/Double Layer (Size:0.5m or 1m x 100m)', 610.00, 'https://cf.shopee.com.my/file/e6e6128db9afab1e6fb4e42b268dcd15', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1470, 'PILOT WINGEL PEN 0.38MM / 0.5MM / 0.7MM / PILOT WINGEL GEL PEN (READY STOCK / 100% ORIGINAL)', 'PILOT WINGEL PEN 0.38MM / 0.5MM / 0.7MM / PILOT WINGEL GEL PEN (READY STOCK / 100% ORIGINAL)', 'PILOT WINGEL PEN 0.38MM / 0.5MM / 0.7MM / PILOT WINGEL GEL PEN (READY STOCK / 100% ORIGINAL)', 19.00, 'https://cf.shopee.com.my/file/58e4ff5c282cd2c83cafe8daac00b12d', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1471, '10.0/14.0/15.6inch Universal Silicone Keyboard Protector', '10.0/14.0/15.6inch Universal Silicone Keyboard Protector', '10.0/14.0/15.6inch Universal Silicone Keyboard Protector', 14.80, 'https://cf.shopee.com.my/file/148115728632a1ee65cea008968126f7', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1473, 'Transparent Mechanical Pencil 0.5mm 0.7mm Pencils For Writing Gift School Supplies Stationery Pencil Lead', 'Transparent Mechanical Pencil 0.5mm 0.7mm Pencils For Writing Gift School Supplies Stationery Pencil Lead', 'Transparent Mechanical Pencil 0.5mm 0.7mm Pencils For Writing Gift School Supplies Stationery Pencil Lead', 10.50, 'https://cf.shopee.com.my/file/45cf0253379fb1f12a56e18009c97c23', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1474, '1kg 0.8mm / 1.0mm Flux Cored Gasless Mig Welding Wire', '1kg 0.8mm / 1.0mm Flux Cored Gasless Mig Welding Wire', '1kg 0.8mm / 1.0mm Flux Cored Gasless Mig Welding Wire', 48.40, 'https://cf.shopee.com.my/file/22897e9304b82671f98bf9a65417552d', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1477, 'COTTON GERMAN MIX OSAKA LINEN - TOYOBO - BIDANG 58\" RM7.00 utk 0.5mtr', 'COTTON GERMAN MIX OSAKA LINEN - TOYOBO - BIDANG 58\" RM7.00 utk 0.5mtr', 'COTTON GERMAN MIX OSAKA LINEN - TOYOBO - BIDANG 58\" RM7.00 utk 0.5mtr', 56.00, 'https://cf.shopee.com.my/file/53fc1dffe9d45a3a7425fc145aa55d05', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1478, 'Flyman 0-5 Years Ready Stock 2Pcs Infant Newborn Baby Boy Cotton Clothes Sets Boy T shirt Tops Shorts Clothing Set Suit', 'Flyman 0-5 Years Ready Stock 2Pcs Infant Newborn Baby Boy Cotton Clothes Sets Boy T shirt Tops Shorts Clothing Set Suit', 'Flyman 0-5 Years Ready Stock 2Pcs Infant Newborn Baby Boy Cotton Clothes Sets Boy T shirt Tops Shorts Clothing Set Suit', 188.80, 'https://cf.shopee.com.my/file/7975f22a41e4cb5b7da993855b8d9d60', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1481, 'Newborn Baby wear, baju bayi 0-9months', 'Newborn Baby wear, baju bayi 0-9months', 'Newborn Baby wear, baju bayi 0-9months', 39.00, 'https://cf.shopee.com.my/file/66d94f667355574ccb3b336a10fbf9cf', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1483, 'Sut lengan pendek kartun kapas kanak-kanak berumur 0-5 tahun baby boy clothes set baju budak lelaki tshirt kanak kanak lelaki', 'Sut lengan pendek kartun kapas kanak-kanak berumur 0-5 tahun baby boy clothes set baju budak lelaki tshirt kanak kanak lelaki', 'Sut lengan pendek kartun kapas kanak-kanak berumur 0-5 tahun baby boy clothes set baju budak lelaki tshirt kanak kanak lelaki', 166.50, 'https://cf.shopee.com.my/file/08f08cbc5d723b8b6bc4690c415cf359', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1485, 'Tikar Getah 20m x 1.83m (6 kaki) Tebal 0.4mm PVC Vinyl Carpet Flooring Rug Mat Canopy Karpet Velvet Toto Khemah Kanopi', 'Tikar Getah 20m x 1.83m (6 kaki) Tebal 0.4mm PVC Vinyl Carpet Flooring Rug Mat Canopy Karpet Velvet Toto Khemah Kanopi', 'Tikar Getah 20m x 1.83m (6 kaki) Tebal 0.4mm PVC Vinyl Carpet Flooring Rug Mat Canopy Karpet Velvet Toto Khemah Kanopi', 1154.00, 'https://cf.shopee.com.my/file/a1ee42603e9e802ed1ef17d9b7abc483', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1487, '0-24months 100% Cotton Baju Bayi Perempuan Baju Girl Baby Dress Sleeveless Infant Newborn Pakaian Kanak-Kanak Cloths Girls Dress Skirts Dresses Girl Pakaian Cartoon Flower Cartoon Dress 1-2Years Old Fashion Ready Stock', '0-24months 100% Cotton Baju Bayi Perempuan Baju Girl Baby Dress Sleeveless Infant Newborn Pakaian Kanak-Kanak Cloths Girls Dress Skirts Dresses Girl Pakaian Cartoon Flower Cartoon Dress 1-2Years Old Fashion Ready Stock', '0-24months 100% Cotton Baju Bayi Perempuan Baju Girl Baby Dress Sleeveless Infant Newborn Pakaian Kanak-Kanak Cloths Girls Dress Skirts Dresses Girl Pakaian Cartoon Flower Cartoon Dress 1-2Years Old Fashion Ready Stock', 43.80, 'https://cf.shopee.com.my/file/9d8188095fb79a0a8e6d4610126b8b4d', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1488, 'Fire Ball AFO Auto Fire Off Fire Extinguisher Ball 0.5KG / 1.3KG', 'Fire Ball AFO Auto Fire Off Fire Extinguisher Ball 0.5KG / 1.3KG', 'Fire Ball AFO Auto Fire Off Fire Extinguisher Ball 0.5KG / 1.3KG', 168.80, 'https://cf.shopee.com.my/file/ea8b92f013492333d3c9ee94437c39cc', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1490, 'Sweet Cherry Convertible Infant Baby Car Seat Newborn to 4 years old LB303 Dean Car Seat Group 0+,1', 'Sweet Cherry Convertible Infant Baby Car Seat Newborn to 4 years old LB303 Dean Car Seat Group 0+,1', 'Sweet Cherry Convertible Infant Baby Car Seat Newborn to 4 years old LB303 Dean Car Seat Group 0+,1', 2590.00, 'https://cf.shopee.com.my/file/1a40e30bf1605eb619f237ba9b1d32fe', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1491, 'Tenda ADSL Modem Router (300Mbps) D301 V2.0 - Gateway Modem Works With TM Streamyx Unifi Lite', 'Tenda ADSL Modem Router (300Mbps) D301 V2.0 - Gateway Modem Works With TM Streamyx Unifi Lite', 'Tenda ADSL Modem Router (300Mbps) D301 V2.0 - Gateway Modem Works With TM Streamyx Unifi Lite', 690.00, 'https://cf.shopee.com.my/file/95038f41ab3c1ff0bff017a7101c9f3d', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1495, '0-1 Year Summer Kids Infant Sandals Baby Girls Boys Pre-walker Shoes Unisex Soft Sandals', '0-1 Year Summer Kids Infant Sandals Baby Girls Boys Pre-walker Shoes Unisex Soft Sandals', '0-1 Year Summer Kids Infant Sandals Baby Girls Boys Pre-walker Shoes Unisex Soft Sandals', 118.90, 'https://cf.shopee.com.my/file/a994632fd9eb381835e86dc65064187e', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1496, 'Anakku Baby Boys Newborn Clothing Set Baju Bayi Lelaki [Short-Slv+Shorts][0-12 Months][Green] EAK214-2', 'Anakku Baby Boys Newborn Clothing Set Baju Bayi Lelaki [Short-Slv+Shorts][0-12 Months][Green] EAK214-2', 'Anakku Baby Boys Newborn Clothing Set Baju Bayi Lelaki [Short-Slv+Shorts][0-12 Months][Green] EAK214-2', 219.00, 'https://cf.shopee.com.my/file/26f7370e7abf465e5d291d9f3751a386', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1498, 'Pakaian kanak-kanak 0-4 tahun baju kemeja lelaki musim panas bayi lelaki kartun corak dinosaurus lengan pendek + seluar pendek denim 2 helai baju bayi lelaki', 'Pakaian kanak-kanak 0-4 tahun baju kemeja lelaki musim panas bayi lelaki kartun corak dinosaurus lengan pendek + seluar pendek denim 2 helai baju bayi lelaki', 'Pakaian kanak-kanak 0-4 tahun baju kemeja lelaki musim panas bayi lelaki kartun corak dinosaurus lengan pendek + seluar pendek denim 2 helai baju bayi lelaki', 152.00, 'https://cf.shopee.com.my/file/b9ed0a724607bee35816d56437bf4720', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1499, '3 PASANG LOWEST PRICE NEW BORN BABY INFANT SUIT SET 0-6 M SLEEPSUIT BABY PYJAMAS BAJU TIDUR BABY NEW BORN MURAH BORONG', '3 PASANG LOWEST PRICE NEW BORN BABY INFANT SUIT SET 0-6 M SLEEPSUIT BABY PYJAMAS BAJU TIDUR BABY NEW BORN MURAH BORONG', '3 PASANG LOWEST PRICE NEW BORN BABY INFANT SUIT SET 0-6 M SLEEPSUIT BABY PYJAMAS BAJU TIDUR BABY NEW BORN MURAH BORONG', 195.00, 'https://cf.shopee.com.my/file/48b75f17a6c109ea81931a9ac84a80b8', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1500, 'Coby UV Mini Sterilizer V2/2.0 [Free Gift]', 'Coby UV Mini Sterilizer V2/2.0 [Free Gift]', 'Coby UV Mini Sterilizer V2/2.0 [Free Gift]', 2580.00, 'https://cf.shopee.com.my/file/abd2decea9c94068dfc178233e49590e', 1627909671, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1502, 'M&G R3/R5 Retractable Gel Pen 0.5 / 0.7mm Bullet Nib (Box of 12pcs)', 'M&G R3/R5 Retractable Gel Pen 0.5 / 0.7mm Bullet Nib (Box of 12pcs)', 'M&G R3/R5 Retractable Gel Pen 0.5 / 0.7mm Bullet Nib (Box of 12pcs)', 11.00, 'https://cf.shopee.com.my/file/8c94c776cf658fd9116ac77112f160c5', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1503, 'ORIGINAL Business Sender Pro V10.0 Latest Whatsapp Blaster Lifetime For Windows', 'ORIGINAL Business Sender Pro V10.0 Latest Whatsapp Blaster Lifetime For Windows', 'ORIGINAL Business Sender Pro V10.0 Latest Whatsapp Blaster Lifetime For Windows', 119.00, 'https://cf.shopee.com.my/file/f4843ea6f83fdac546826eb405742033', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1504, '*RESTOCK*LOWEST PRICE* Desire 14mm Natural Size Contact Lens/Color Lens Original Korea Lens ( Power 0-1000 )', '*RESTOCK*LOWEST PRICE* Desire 14mm Natural Size Contact Lens/Color Lens Original Korea Lens ( Power 0-1000 )', '*RESTOCK*LOWEST PRICE* Desire 14mm Natural Size Contact Lens/Color Lens Original Korea Lens ( Power 0-1000 )', 98.00, 'https://cf.shopee.com.my/file/fe39c846220dc998935d614c49186542', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1505, 'Dolly 16.5mm(eff 17.5mm) Big eyes Contact Lens/Color Lens/Korea Lens (P-0.00 till P-8.00) Free Case', 'Dolly 16.5mm(eff 17.5mm) Big eyes Contact Lens/Color Lens/Korea Lens (P-0.00 till P-8.00) Free Case', 'Dolly 16.5mm(eff 17.5mm) Big eyes Contact Lens/Color Lens/Korea Lens (P-0.00 till P-8.00) Free Case', 99.00, 'https://cf.shopee.com.my/file/c9f1b221afdaaa1b792be55ac644e254', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1506, 'Joran Udang / Joran Pancing Udang 120 (4\'-0\") / 135 (4\'-6\")', 'Joran Udang / Joran Pancing Udang 120 (4\'-0\") / 135 (4\'-6\")', 'Joran Udang / Joran Pancing Udang 120 (4\'-0\") / 135 (4\'-6\")', 120.00, 'https://cf.shopee.com.my/file/12984686f0e4aa8f226bfed22df2f096', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1507, 'Winzige 9 Colors Gel Pen 0.5mm Tip Cute Pen for journal, drawing, graffiti School office stationery', 'Winzige 9 Colors Gel Pen 0.5mm Tip Cute Pen for journal, drawing, graffiti School office stationery', 'Winzige 9 Colors Gel Pen 0.5mm Tip Cute Pen for journal, drawing, graffiti School office stationery', 6.50, 'https://cf.shopee.com.my/file/d905998e9c2806be1f7beba19e561137', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1508, 'High Quality USB OTG to Type-C Adapter USB3.0 for Computer & Mobile Phone Android', 'High Quality USB OTG to Type-C Adapter USB3.0 for Computer & Mobile Phone Android', 'High Quality USB OTG to Type-C Adapter USB3.0 for Computer & Mobile Phone Android', 59.70, 'https://cf.shopee.com.my/file/a006890e556f35d85f92e7657687b263', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1509, 'Original Nevoks Feelin Pod Kit 22W 100mAh 2.8ML Pod Capacity Nevoks Occ 0.6ohm / 1.0ohm', 'Original Nevoks Feelin Pod Kit 22W 100mAh 2.8ML Pod Capacity Nevoks Occ 0.6ohm / 1.0ohm', 'Original Nevoks Feelin Pod Kit 22W 100mAh 2.8ML Pod Capacity Nevoks Occ 0.6ohm / 1.0ohm', 255.00, 'https://cf.shopee.com.my/file/8cc260b877061eea13e0c7381b5593af', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1510, 'Ready stock TASBIH MINI GLASS PEARL 33BIJI(MANIK) SIZE 0.8MM DOORGIFT', 'Ready stock TASBIH MINI GLASS PEARL 33BIJI(MANIK) SIZE 0.8MM DOORGIFT', 'Ready stock TASBIH MINI GLASS PEARL 33BIJI(MANIK) SIZE 0.8MM DOORGIFT', 10.00, 'https://cf.shopee.com.my/file/0c6c96aba59264b5cc96f5e582f71a1e', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1511, 'Metallic Marker 0.7mm Extra Fine Point Paint Marker Non-toxic Permanent Marker Pen 8 Colors', 'Metallic Marker 0.7mm Extra Fine Point Paint Marker Non-toxic Permanent Marker Pen 8 Colors', 'Metallic Marker 0.7mm Extra Fine Point Paint Marker Non-toxic Permanent Marker Pen 8 Colors', 35.40, 'https://cf.shopee.com.my/file/60b2020b143477dcb92d2337f233b033', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1512, 'Voopoo vinci occ PnP-VM1 0.3 PnP-VM4 0.6 PnP-R1 0.8', 'Voopoo vinci occ PnP-VM1 0.3 PnP-VM4 0.6 PnP-R1 0.8', 'Voopoo vinci occ PnP-VM1 0.3 PnP-VM4 0.6 PnP-R1 0.8', 380.00, 'https://cf.shopee.com.my/file/2af14d0c83b20e210bf18c7b5b7b2137', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1513, '[SS Wire] Pure Stainless Steel 304 Wire/ Dawai Stainless Steel [0.8mm, 1.0mm, 1.2mm, 1.5mm, 2.0mm]', '[SS Wire] Pure Stainless Steel 304 Wire/ Dawai Stainless Steel [0.8mm, 1.0mm, 1.2mm, 1.5mm, 2.0mm]', '[SS Wire] Pure Stainless Steel 304 Wire/ Dawai Stainless Steel [0.8mm, 1.0mm, 1.2mm, 1.5mm, 2.0mm]', 60.00, 'https://cf.shopee.com.my/file/3fcb19316e1b413203b708c7bb681350', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1514, 'Pilot Pen G2 Gel Pen 0.5mm', 'Pilot Pen G2 Gel Pen 0.5mm', 'Pilot Pen G2 Gel Pen 0.5mm', 53.00, 'https://cf.shopee.com.my/file/1d51d6f4254550e98e4361bb0fec6e77', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1515, 'Gsoft WM5 WM7 Ball Pen 0.5mm 0.7mm', 'Gsoft WM5 WM7 Ball Pen 0.5mm 0.7mm', 'Gsoft WM5 WM7 Ball Pen 0.5mm 0.7mm', 5.90, 'https://cf.shopee.com.my/file/4f79baa9f46f0d1abff085ad285a12fc', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1516, 'Craft Wire, Copper-Based Wire, 0.2mm-1.0mm  Jewelry Special Copper Wire', 'Craft Wire, Copper-Based Wire, 0.2mm-1.0mm  Jewelry Special Copper Wire', 'Craft Wire, Copper-Based Wire, 0.2mm-1.0mm  Jewelry Special Copper Wire', 39.00, 'https://cf.shopee.com.my/file/0ff5e2e868719fa8b8fac4581fcc4ed0', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1518, '0.20mm-0.40mm Strong No Elasticity Fishing Beading Crystal String Cord Thread for Jewelry Making Necklace Bracelet DIY', '0.20mm-0.40mm Strong No Elasticity Fishing Beading Crystal String Cord Thread for Jewelry Making Necklace Bracelet DIY', '0.20mm-0.40mm Strong No Elasticity Fishing Beading Crystal String Cord Thread for Jewelry Making Necklace Bracelet DIY', 20.00, 'https://cf.shopee.com.my/file/2b8a4cf8cabf407a984a09d66cfd3c4c', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1519, 'Pilot Mechanical Pencil REXGRIP  0.5mm & 0.7mm *Free Pencil Lead* -Made In Japan.', 'Pilot Mechanical Pencil REXGRIP  0.5mm & 0.7mm *Free Pencil Lead* -Made In Japan.', 'Pilot Mechanical Pencil REXGRIP  0.5mm & 0.7mm *Free Pencil Lead* -Made In Japan.', 27.00, 'https://cf.shopee.com.my/file/efbb2fca169bb627ee34aa6c781fd493', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1520, '0.8mm White Gel Ink Marking Pen TOUCHNEW Artist Painting highlight brush Pen', '0.8mm White Gel Ink Marking Pen TOUCHNEW Artist Painting highlight brush Pen', '0.8mm White Gel Ink Marking Pen TOUCHNEW Artist Painting highlight brush Pen', 5.90, 'https://cf.shopee.com.my/file/650096f18fee7da95a2f72931ca1fb6a', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1521, '(0-12mth) Wizkid Jumper Eyelet', '(0-12mth) Wizkid Jumper Eyelet', '(0-12mth) Wizkid Jumper Eyelet', 100.00, 'https://cf.shopee.com.my/file/074cfc6fe2478c605c63be8e22997646', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1522, 'PUBG GM-002 Gaming 3.5mm wired Headphones DTS GAMING HEADPHONE : X V2.0 surround super bass Game Headset with Mic', 'PUBG GM-002 Gaming 3.5mm wired Headphones DTS GAMING HEADPHONE : X V2.0 surround super bass Game Headset with Mic', 'PUBG GM-002 Gaming 3.5mm wired Headphones DTS GAMING HEADPHONE : X V2.0 surround super bass Game Headset with Mic', 84.60, 'https://cf.shopee.com.my/file/d9a1551566be8ef85715fc3dabfafd48', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1523, '1Pc 0.5mm/0.7mm Transparent Simple Automatic Pencil Creative Modeling Student Stationery', '1Pc 0.5mm/0.7mm Transparent Simple Automatic Pencil Creative Modeling Student Stationery', '1Pc 0.5mm/0.7mm Transparent Simple Automatic Pencil Creative Modeling Student Stationery', 6.90, 'https://cf.shopee.com.my/file/0f2fdcaff878033ce7658a0e46cafdbf', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1526, 'Faber Castell Rx Colour Gel Pen 0.7mm Gold / Turquoise / Green / Lilac / Pink', 'Faber Castell Rx Colour Gel Pen 0.7mm Gold / Turquoise / Green / Lilac / Pink', 'Faber Castell Rx Colour Gel Pen 0.7mm Gold / Turquoise / Green / Lilac / Pink', 15.00, 'https://cf.shopee.com.my/file/ac013b882f111bcac33d2d10165f23b8', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1527, 'GSoft writemate WX1 semi Gel Ink Ball Pen 0.4mm 1pcs', 'GSoft writemate WX1 semi Gel Ink Ball Pen 0.4mm 1pcs', 'GSoft writemate WX1 semi Gel Ink Ball Pen 0.4mm 1pcs', 7.90, 'https://cf.shopee.com.my/file/0d661953f06b38acc2579519de0a2191', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1528, 'October Baby Stacking Toys Early Learning Toys More than 6 Months Puzzle Early Education Stacked Shooting Track Ball Turn Le Baobao 0-1 Year Old Toys', 'October Baby Stacking Toys Early Learning Toys More than 6 Months Puzzle Early Education Stacked Shooting Track Ball Turn Le Baobao 0-1 Year Old Toys', 'October Baby Stacking Toys Early Learning Toys More than 6 Months Puzzle Early Education Stacked Shooting Track Ball Turn Le Baobao 0-1 Year Old Toys', 143.20, 'https://cf.shopee.com.my/file/7120ebe47ba5fd523b3dfb43d1ac6663', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1529, '[READY STOCK] AUTHENTIC DOTMOD DOT AIO COIL (5PCS/PACK) 0.3 SS/0.7 SS/1.2 CLAPTON/1.6 CERAMIC', '[READY STOCK] AUTHENTIC DOTMOD DOT AIO COIL (5PCS/PACK) 0.3 SS/0.7 SS/1.2 CLAPTON/1.6 CERAMIC', '[READY STOCK] AUTHENTIC DOTMOD DOT AIO COIL (5PCS/PACK) 0.3 SS/0.7 SS/1.2 CLAPTON/1.6 CERAMIC', 650.00, 'https://cf.shopee.com.my/file/101d8646d89001eaf2def26268fae26e', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1530, 'Yt 0.80sen 5 sub (Sub masuk satu per satu slow)', 'Yt 0.80sen 5 sub (Sub masuk satu per satu slow)', 'Yt 0.80sen 5 sub (Sub masuk satu per satu slow)', 8.00, 'https://cf.shopee.com.my/file/18ac145d3d145bb12256a3fab745b06c', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1531, 'Faber-Castell Retractable RX Colour Gel Pen (0.7mm) [Per Pcs / Wallet Set of 5, Green, Gold, Lilac, Pink, Turquoise]', 'Faber-Castell Retractable RX Colour Gel Pen (0.7mm) [Per Pcs / Wallet Set of 5, Green, Gold, Lilac, Pink, Turquoise]', 'Faber-Castell Retractable RX Colour Gel Pen (0.7mm) [Per Pcs / Wallet Set of 5, Green, Gold, Lilac, Pink, Turquoise]', 14.70, 'https://cf.shopee.com.my/file/f1e2e092f5dbab9e0dd8ebc7f239a93b', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1532, 'TOHO OPAQUE 11/0 Seed Beads - 450GM', 'TOHO OPAQUE 11/0 Seed Beads - 450GM', 'TOHO OPAQUE 11/0 Seed Beads - 450GM', 790.00, 'https://cf.shopee.com.my/file/35786bfe879e372fb470063fd183f0ea', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1533, 'Disney Baby Girl Boy Unisex Newborn Fullmoon Gift Set 0-6 months Didi & Friends', 'Disney Baby Girl Boy Unisex Newborn Fullmoon Gift Set 0-6 months Didi & Friends', 'Disney Baby Girl Boy Unisex Newborn Fullmoon Gift Set 0-6 months Didi & Friends', 438.00, 'https://cf.shopee.com.my/file/1be4be701b6bbde454d04bc57e295d02', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1538, 'Kain pasang bubble cotton High Quality 0.5m bidang 60| kain blouseq', 'Kain pasang bubble cotton High Quality 0.5m bidang 60| kain blouseq', 'Kain pasang bubble cotton High Quality 0.5m bidang 60| kain blouseq', 54.80, 'https://cf.shopee.com.my/file/9842c831aba1132d1f7d1a6c04cda079', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1539, 'Personality Black Pen 0.38mm Gel Pen Office Stationary Student Pen', 'Personality Black Pen 0.38mm Gel Pen Office Stationary Student Pen', 'Personality Black Pen 0.38mm Gel Pen Office Stationary Student Pen', 3.10, 'https://cf.shopee.com.my/file/635b1681ab03b1bce658a5039983088c', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1541, '30 METER FAJAR Automotive Wire Auto Cable 100% Pure Copper (Made in Malaysia) 14/0.26mm 28/0.26mm 65/0.26mm Available', '30 METER FAJAR Automotive Wire Auto Cable 100% Pure Copper (Made in Malaysia) 14/0.26mm 28/0.26mm 65/0.26mm Available', '30 METER FAJAR Automotive Wire Auto Cable 100% Pure Copper (Made in Malaysia) 14/0.26mm 28/0.26mm 65/0.26mm Available', 169.00, 'https://cf.shopee.com.my/file/bc5520d07bcfa6f1c900611637611bcf', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1542, '[KL STOCK] USB2.0 External DVD Drive Combo CD-RW  CD-RW DVD ROM CD Driver for for PC/Laptop', '[KL STOCK] USB2.0 External DVD Drive Combo CD-RW  CD-RW DVD ROM CD Driver for for PC/Laptop', '[KL STOCK] USB2.0 External DVD Drive Combo CD-RW  CD-RW DVD ROM CD Driver for for PC/Laptop', 428.00, 'https://cf.shopee.com.my/file/5bfb4f1c7ba1ea1968eba76272e686ef', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1543, 'Essager USB Type C 0.3M Cable For Samsung S20 Note 10 Plus Xiaomi 10 Pro Fast Charge Type-C USB-C Charger TypeC USBC Data Wire Cord', 'Essager USB Type C 0.3M Cable For Samsung S20 Note 10 Plus Xiaomi 10 Pro Fast Charge Type-C USB-C Charger TypeC USBC Data Wire Cord', 'Essager USB Type C 0.3M Cable For Samsung S20 Note 10 Plus Xiaomi 10 Pro Fast Charge Type-C USB-C Charger TypeC USBC Data Wire Cord', 49.90, 'https://cf.shopee.com.my/file/a705b617f0d6715db972e097e4d428d6', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1546, 'BUNCHO 0.5 Mechanical Pencil Lead 0.5mm', 'BUNCHO 0.5 Mechanical Pencil Lead 0.5mm', 'BUNCHO 0.5 Mechanical Pencil Lead 0.5mm', 27.00, 'https://cf.shopee.com.my/file/34890cbf655e310c6e36360ea79a589c', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1547, 'Gsoft WM5 WM7 Ball Pen 0.5mm 0.7mm Blue Black Red ballpen 1pcs', 'Gsoft WM5 WM7 Ball Pen 0.5mm 0.7mm Blue Black Red ballpen 1pcs', 'Gsoft WM5 WM7 Ball Pen 0.5mm 0.7mm Blue Black Red ballpen 1pcs', 5.90, 'https://cf.shopee.com.my/file/e42852f7045ed5ef402224a48f7be85f', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1548, '*2021 New Lens* Cat Series Natural.Color.Korea.Lens (P-0.00 till P-8.00) Free Case', '*2021 New Lens* Cat Series Natural.Color.Korea.Lens (P-0.00 till P-8.00) Free Case', '*2021 New Lens* Cat Series Natural.Color.Korea.Lens (P-0.00 till P-8.00) Free Case', 99.00, 'https://cf.shopee.com.my/file/7d4ea41e73725c2e7eecdacff6c444f5', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1551, 'CAT5e Solid CCA 24AWG Network Cable | 0.5m-15m', 'CAT5e Solid CCA 24AWG Network Cable | 0.5m-15m', 'CAT5e Solid CCA 24AWG Network Cable | 0.5m-15m', 57.00, 'https://cf.shopee.com.my/file/514d99230115d58006650353a390295d', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1552, 'DK -Pilot Juice Up Gel Ink Ballpoint Pen 0.4mm-Basic Color/Metallic Color', 'DK -Pilot Juice Up Gel Ink Ballpoint Pen 0.4mm-Basic Color/Metallic Color', 'DK -Pilot Juice Up Gel Ink Ballpoint Pen 0.4mm-Basic Color/Metallic Color', 59.00, 'https://cf.shopee.com.my/file/6dffb0bbe2193afa04d585feb9ec402f', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1553, '1pc 32inch Number 0-9 Rose Gold Silver Gold Rainbow Balloons Foil Balloons Decoration', '1pc 32inch Number 0-9 Rose Gold Silver Gold Rainbow Balloons Foil Balloons Decoration', '1pc 32inch Number 0-9 Rose Gold Silver Gold Rainbow Balloons Foil Balloons Decoration', 15.00, 'https://cf.shopee.com.my/file/d4a4b40528e6294b0dba938eae0121ac', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1554, '(Malaysia Ready Stock) Faber-Castell Econ Mechanical Pencil Set with Leads / Faber Castell 0.5mm  0.7mm 134205 134202', '(Malaysia Ready Stock) Faber-Castell Econ Mechanical Pencil Set with Leads / Faber Castell 0.5mm  0.7mm 134205 134202', '(Malaysia Ready Stock) Faber-Castell Econ Mechanical Pencil Set with Leads / Faber Castell 0.5mm  0.7mm 134205 134202', 33.90, 'https://cf.shopee.com.my/file/18b0080f794ca78ffb905813ae235c70', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1555, 'FASTER 4IN1 CX5N 0.5MM BALL PEN (BLACK,BLUE,MIX)', 'FASTER 4IN1 CX5N 0.5MM BALL PEN (BLACK,BLUE,MIX)', 'FASTER 4IN1 CX5N 0.5MM BALL PEN (BLACK,BLUE,MIX)', 19.80, 'https://cf.shopee.com.my/file/436b1690c772328be218eef9e72f752a', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1556, 'Faber-Castell Click Ball Pen X5/X7/0.5mm/0.7mm/1PC', 'Faber-Castell Click Ball Pen X5/X7/0.5mm/0.7mm/1PC', 'Faber-Castell Click Ball Pen X5/X7/0.5mm/0.7mm/1PC', 6.70, 'https://cf.shopee.com.my/file/9e59c6cfbadc8ab8439ec0771645b064', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1559, 'Supergamer 600Mbps 1200M 150M Wireless PC WiFi Adapter Network Card Wifi Receiver 2.4/5G Dual Band Antennas USB2.0 3.0', 'Supergamer 600Mbps 1200M 150M Wireless PC WiFi Adapter Network Card Wifi Receiver 2.4/5G Dual Band Antennas USB2.0 3.0', 'Supergamer 600Mbps 1200M 150M Wireless PC WiFi Adapter Network Card Wifi Receiver 2.4/5G Dual Band Antennas USB2.0 3.0', 82.50, 'https://cf.shopee.com.my/file/d58acff975e96650c6d0740f8396f343', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1560, '19+1 HDMI CABLE V2.0 HIGH SPEED HIGH QUALITY 3D FULL HD 1080P SUPPORT 4K & 3D COPPER HDMI V2.0 - 1.5M / 3.0M / 5.0M', '19+1 HDMI CABLE V2.0 HIGH SPEED HIGH QUALITY 3D FULL HD 1080P SUPPORT 4K & 3D COPPER HDMI V2.0 - 1.5M / 3.0M / 5.0M', '19+1 HDMI CABLE V2.0 HIGH SPEED HIGH QUALITY 3D FULL HD 1080P SUPPORT 4K & 3D COPPER HDMI V2.0 - 1.5M / 3.0M / 5.0M', 49.00, 'https://cf.shopee.com.my/file/2260cdd32c9e0fb466faa428059ef3d1', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1561, '0-24M Newborns Baby Girl Cotton Flower Dresses Baby Dress Summer Dress Skirt Anak Budak Perempuan Multi Pattern Clothes', '0-24M Newborns Baby Girl Cotton Flower Dresses Baby Dress Summer Dress Skirt Anak Budak Perempuan Multi Pattern Clothes', '0-24M Newborns Baby Girl Cotton Flower Dresses Baby Dress Summer Dress Skirt Anak Budak Perempuan Multi Pattern Clothes', 48.00, 'https://cf.shopee.com.my/file/4e1632cb2d4b56005de40d945514a3f2', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1563, '5 Colours 32 Inch Foil Number Balloons 0-9 Digit Helium Globos Happy New Year Wedding Birthday Party Number Balaos Decoration', '5 Colours 32 Inch Foil Number Balloons 0-9 Digit Helium Globos Happy New Year Wedding Birthday Party Number Balaos Decoration', '5 Colours 32 Inch Foil Number Balloons 0-9 Digit Helium Globos Happy New Year Wedding Birthday Party Number Balaos Decoration', 16.00, 'https://cf.shopee.com.my/file/b5cd45b526ebee1c4300012b784052e2', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1564, 'Matte Transparent Mechanical Pencil Automatic Pencil 0.5mm Primary School Pencil', 'Matte Transparent Mechanical Pencil Automatic Pencil 0.5mm Primary School Pencil', 'Matte Transparent Mechanical Pencil Automatic Pencil 0.5mm Primary School Pencil', 6.70, 'https://cf.shopee.com.my/file/e642c37be6cc6c7d5e7f93fd0ad50103', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1565, 'Newborn Baby Hats 100% Cotton Infant Cartoon Elephant Hat Caps Soft Baby Accessories 0-3 Month', 'Newborn Baby Hats 100% Cotton Infant Cartoon Elephant Hat Caps Soft Baby Accessories 0-3 Month', 'Newborn Baby Hats 100% Cotton Infant Cartoon Elephant Hat Caps Soft Baby Accessories 0-3 Month', 89.90, 'https://cf.shopee.com.my/file/802fa147a1162d8bd17c0e90f311c519', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1566, 'Ready Stock 7pcs Newborn Hamper 0-6 Months Set Gift Cotton', 'Ready Stock 7pcs Newborn Hamper 0-6 Months Set Gift Cotton', 'Ready Stock 7pcs Newborn Hamper 0-6 Months Set Gift Cotton', 450.00, 'https://cf.shopee.com.my/file/d2785934f1d2142eadba4026a03caa98', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1568, 'OFFER ORIGINAL Maki Brown 0-950degree By Dreamcolor Lens + Free Case (similar Burberry & Maki)', 'OFFER ORIGINAL Maki Brown 0-950degree By Dreamcolor Lens + Free Case (similar Burberry & Maki)', 'OFFER ORIGINAL Maki Brown 0-950degree By Dreamcolor Lens + Free Case (similar Burberry & Maki)', 200.00, 'https://cf.shopee.com.my/file/725009a985acc5500f6a11c7a253d7dd', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1569, 'TEAMON Scar Roller Skincare Derma Roller Microneedle Microneedling 0.5mm - READY STOCK', 'TEAMON Scar Roller Skincare Derma Roller Microneedle Microneedling 0.5mm - READY STOCK', 'TEAMON Scar Roller Skincare Derma Roller Microneedle Microneedling 0.5mm - READY STOCK', 250.00, 'https://cf.shopee.com.my/file/ca58f4a78c3b39f6e9bc7a5ca8507cce', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1570, 'MAM Silk Teat Twin Pack (Size 0, 1, 2, 3, X, Spill Free & Soft Spout)', 'MAM Silk Teat Twin Pack (Size 0, 1, 2, 3, X, Spill Free & Soft Spout)', 'MAM Silk Teat Twin Pack (Size 0, 1, 2, 3, X, Spill Free & Soft Spout)', 250.00, 'https://cf.shopee.com.my/file/d92067747a65d393bfde9bc59a248fca', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1571, 'Hot Sale Baby Bodysuits Boy Cute Cotton New Romper Baby Girls Clothes Infant Toddler Newborn Outfits 0-24M', 'Hot Sale Baby Bodysuits Boy Cute Cotton New Romper Baby Girls Clothes Infant Toddler Newborn Outfits 0-24M', 'Hot Sale Baby Bodysuits Boy Cute Cotton New Romper Baby Girls Clothes Infant Toddler Newborn Outfits 0-24M', 39.90, 'https://cf.shopee.com.my/file/6c8b64b45a0b1515b6cc973949a2df23', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1572, 'G\'Soft WG5 / WG7 Retractable Ball Pen (0.5mm / 0.7mm)', 'G\'Soft WG5 / WG7 Retractable Ball Pen (0.5mm / 0.7mm)', 'G\'Soft WG5 / WG7 Retractable Ball Pen (0.5mm / 0.7mm)', 5.00, 'https://cf.shopee.com.my/file/2abf314803e4a7f293ca6ee51399446a', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1573, '*Original* Pilot Wingel Gel Pen 0.5mm 0.7mm Black Blue Red G1', '*Original* Pilot Wingel Gel Pen 0.5mm 0.7mm Black Blue Red G1', '*Original* Pilot Wingel Gel Pen 0.5mm 0.7mm Black Blue Red G1', 22.80, 'https://cf.shopee.com.my/file/1759b06b882061bac8f603db6ed68449', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1574, 'Bosch Oil Filter - Perodua Myvi / Viva / Alza / Kelisa / Kenari / Kancil ( 0 986 AF0 348 )', 'Bosch Oil Filter - Perodua Myvi / Viva / Alza / Kelisa / Kenari / Kancil ( 0 986 AF0 348 )', 'Bosch Oil Filter - Perodua Myvi / Viva / Alza / Kelisa / Kenari / Kancil ( 0 986 AF0 348 )', 51.00, 'https://cf.shopee.com.my/file/42de8a233708410a5e9082e9c758166b', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1576, '0-18 Months Autumn Baby Girl Tight Cotton Legging Cartoon Print Skinny Stretchy Bottom Pants 5 Colors', '0-18 Months Autumn Baby Girl Tight Cotton Legging Cartoon Print Skinny Stretchy Bottom Pants 5 Colors', '0-18 Months Autumn Baby Girl Tight Cotton Legging Cartoon Print Skinny Stretchy Bottom Pants 5 Colors', 99.80, 'https://cf.shopee.com.my/file/fe985f354e2c73b327e514ddc868d8b4', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1578, 'LDNIO 2 USB/4 USB/6 USB/8 USB Port QC3.0 USB Fast Charger & UK 3-Pin Plug', 'LDNIO 2 USB/4 USB/6 USB/8 USB Port QC3.0 USB Fast Charger & UK 3-Pin Plug', 'LDNIO 2 USB/4 USB/6 USB/8 USB Port QC3.0 USB Fast Charger & UK 3-Pin Plug', 147.60, 'https://cf.shopee.com.my/file/9b53b7731662fa884f95a16e7625f763', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1579, '1.5/3.0/5.0 METER HIGH SPEED USB 2.0 USB PRINTER CABLE SCANNER CABLE DATA TRANSFER POWER CORD ADAPTER AM/BM', '1.5/3.0/5.0 METER HIGH SPEED USB 2.0 USB PRINTER CABLE SCANNER CABLE DATA TRANSFER POWER CORD ADAPTER AM/BM', '1.5/3.0/5.0 METER HIGH SPEED USB 2.0 USB PRINTER CABLE SCANNER CABLE DATA TRANSFER POWER CORD ADAPTER AM/BM', 29.00, 'https://cf.shopee.com.my/file/1629716978e13c0aa5ac9ee80c2d0b70', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1581, 'NUK Sensitive Orthodontic Pacifiers Baby Soother BPA Free 0-6m/ 6-18m LOOSE PACK 1pcs', 'NUK Sensitive Orthodontic Pacifiers Baby Soother BPA Free 0-6m/ 6-18m LOOSE PACK 1pcs', 'NUK Sensitive Orthodontic Pacifiers Baby Soother BPA Free 0-6m/ 6-18m LOOSE PACK 1pcs', 159.00, 'https://cf.shopee.com.my/file/4e7f8437b2befcf9424b746ba2551c30', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1582, 'AUKEY PA-B6S Omnia 90W 3-Port MacBook Pro Charger with GaNTech PD Charger USB C Fast Charger Laptop Charger QC 4.0+ PPS', 'AUKEY PA-B6S Omnia 90W 3-Port MacBook Pro Charger with GaNTech PD Charger USB C Fast Charger Laptop Charger QC 4.0+ PPS', 'AUKEY PA-B6S Omnia 90W 3-Port MacBook Pro Charger with GaNTech PD Charger USB C Fast Charger Laptop Charger QC 4.0+ PPS', 1990.00, 'https://cf.shopee.com.my/file/8771498e29d2907e8de1ec6652f3bffa', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1583, '[Stok] Pakaian kasual kanak-kanak 0-5 tahun T-shirt dandelion kapas dengan dua seluar pendek liar', '[Stok] Pakaian kasual kanak-kanak 0-5 tahun T-shirt dandelion kapas dengan dua seluar pendek liar', '[Stok] Pakaian kasual kanak-kanak 0-5 tahun T-shirt dandelion kapas dengan dua seluar pendek liar', 144.90, 'https://cf.shopee.com.my/file/154e79ea2ca19f83f56f197ca98f4391', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1584, 'W18 Mini HD LCD Portable Android 6.0 Projector 1280x720 Pixels Resolution 2800 Lumens Support AirPlay DLNA Miracast', 'W18 Mini HD LCD Portable Android 6.0 Projector 1280x720 Pixels Resolution 2800 Lumens Support AirPlay DLNA Miracast', 'W18 Mini HD LCD Portable Android 6.0 Projector 1280x720 Pixels Resolution 2800 Lumens Support AirPlay DLNA Miracast', 2389.00, 'https://cf.shopee.com.my/file/c93eb551f1282bc3b55c7c8b43a19090', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1585, 'ALPHABET A-Z 0-9 LETTER NUMBER NOMBOR PUNCH PUNCHES PLATE BOARD STAMP CHOP  . STANLEY SATAGOOD SATA REMAX TOPTUL SENSUI', 'ALPHABET A-Z 0-9 LETTER NUMBER NOMBOR PUNCH PUNCHES PLATE BOARD STAMP CHOP  . STANLEY SATAGOOD SATA REMAX TOPTUL SENSUI', 'ALPHABET A-Z 0-9 LETTER NUMBER NOMBOR PUNCH PUNCHES PLATE BOARD STAMP CHOP  . STANLEY SATAGOOD SATA REMAX TOPTUL SENSUI', 160.00, 'https://cf.shopee.com.my/file/ceeb41ca1da0d77ce3c3703edf705e70', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1586, 'JinFuChang(0.7L/1.5L/2L) Manual Hand Press Food Processor Multifunction Gourmet Cuisine Hand Pat Chopper Meat Blender Grinder Press Cutter/ Manual Food Processor Multifunction Gourmet Cuisine Hand Pat Chopper Meat Blender Grinder Press Cutter', 'JinFuChang(0.7L/1.5L/2L) Manual Hand Press Food Processor Multifunction Gourmet Cuisine Hand Pat Chopper Meat Blender Grinder Press Cutter/ Manual Food Processor Multifunction Gourmet Cuisine Hand Pat Chopper Meat Blender Grinder Press Cutter', 'JinFuChang(0.7L/1.5L/2L) Manual Hand Press Food Processor Multifunction Gourmet Cuisine Hand Pat Chopper Meat Blender Grinder Press Cutter/ Manual Food Processor Multifunction Gourmet Cuisine Hand Pat Chopper Meat Blender Grinder Press Cutter', 159.00, 'https://cf.shopee.com.my/file/566a8ec00c7d5f7210bacd9c60b336e1', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1587, 'Ready Stock - Silver Color Numbering 0~9 16 Inches (35cm) Balloon Happy Birthday Balloon Party For Girls and Boys', 'Ready Stock - Silver Color Numbering 0~9 16 Inches (35cm) Balloon Happy Birthday Balloon Party For Girls and Boys', 'Ready Stock - Silver Color Numbering 0~9 16 Inches (35cm) Balloon Happy Birthday Balloon Party For Girls and Boys', 10.40, 'https://cf.shopee.com.my/file/d47a51b2bf6d7fa345ab3c979c578197', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1588, 'Kids Tales Newborn Infant Toddler Baby Girl Baby Boy Cartoon Printed Long Sleeve Sleepsuit Jumpsuit 0-3 Years Bonds Bodysuit Baju Melayu Bayi Sampin Baby Baju Kurung Cotton Budak Baju Raya Budak Lelaki', 'Kids Tales Newborn Infant Toddler Baby Girl Baby Boy Cartoon Printed Long Sleeve Sleepsuit Jumpsuit 0-3 Years Bonds Bodysuit Baju Melayu Bayi Sampin Baby Baju Kurung Cotton Budak Baju Raya Budak Lelaki', 'Kids Tales Newborn Infant Toddler Baby Girl Baby Boy Cartoon Printed Long Sleeve Sleepsuit Jumpsuit 0-3 Years Bonds Bodysuit Baju Melayu Bayi Sampin Baby Baju Kurung Cotton Budak Baju Raya Budak Lelaki', 279.00, 'https://cf.shopee.com.my/file/14e69806822af88f54ef49bf3460d428', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1589, '0-12 Months Old Baby dress Girl dress Cartoon Dress Cute Baju kanak-kanak Baju baby girl Pakaian Budak Perempuan Comel', '0-12 Months Old Baby dress Girl dress Cartoon Dress Cute Baju kanak-kanak Baju baby girl Pakaian Budak Perempuan Comel', '0-12 Months Old Baby dress Girl dress Cartoon Dress Cute Baju kanak-kanak Baju baby girl Pakaian Budak Perempuan Comel', 48.00, 'https://cf.shopee.com.my/file/387c17dce4b603ec41b32d675871996d', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1590, 'HS-202B Wire Crimper Multi Function Tools Crimping Stripper Cutting Tools Range 0.25-2.5mm2 7\'\' Pliers HS-202D', 'HS-202B Wire Crimper Multi Function Tools Crimping Stripper Cutting Tools Range 0.25-2.5mm2 7\'\' Pliers HS-202D', 'HS-202B Wire Crimper Multi Function Tools Crimping Stripper Cutting Tools Range 0.25-2.5mm2 7\'\' Pliers HS-202D', 112.20, 'https://cf.shopee.com.my/file/a089e18119878cd405950ac66ce8e73e', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1591, 'Heavy Chiffon Bidang 60 Untuk Shawl Bawal Niqab Purdah (0.5m/unit min order 2 unit/colour)', 'Heavy Chiffon Bidang 60 Untuk Shawl Bawal Niqab Purdah (0.5m/unit min order 2 unit/colour)', 'Heavy Chiffon Bidang 60 Untuk Shawl Bawal Niqab Purdah (0.5m/unit min order 2 unit/colour)', 40.00, 'https://cf.shopee.com.my/file/a01f45be1f0d3969f7d844c16429aea8', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1594, 'Midea Rice Cooker Mini 0.6L small capacity MD-MGGP06B [One year Warranty]', 'Midea Rice Cooker Mini 0.6L small capacity MD-MGGP06B [One year Warranty]', 'Midea Rice Cooker Mini 0.6L small capacity MD-MGGP06B [One year Warranty]', 469.00, 'https://cf.shopee.com.my/file/f29ae2905b63564fbe2a8d8734398b34', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1595, '[1set Baju+Seluar] New Born Baby Clothing Eyelet Baju Lubang Baju Bayi Baru Lahir 0-6m+', '[1set Baju+Seluar] New Born Baby Clothing Eyelet Baju Lubang Baju Bayi Baru Lahir 0-6m+', '[1set Baju+Seluar] New Born Baby Clothing Eyelet Baju Lubang Baju Bayi Baru Lahir 0-6m+', 49.00, 'https://cf.shopee.com.my/file/0542485f419bb510ce52a256fc1f793d', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1596, 'Baju Baby Newborn Sleeveless Unisex Baby Rompers Cartoon Baju Bayi 0-18M *Local Seller ReadyStock*', 'Baju Baby Newborn Sleeveless Unisex Baby Rompers Cartoon Baju Bayi 0-18M *Local Seller ReadyStock*', 'Baju Baby Newborn Sleeveless Unisex Baby Rompers Cartoon Baju Bayi 0-18M *Local Seller ReadyStock*', 19.90, 'https://cf.shopee.com.my/file/647ee7507cf30c7b7348d62e5f839a94', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1597, 'CLEVAMAMA BABY PILLOW (BABY 0-12M) & CLEVAMAMA BABY PILLOW OR PILLOWCASE ( CORAL, BLUE, YELLOW) ONLY SIZE: 40X23X3CM', 'CLEVAMAMA BABY PILLOW (BABY 0-12M) & CLEVAMAMA BABY PILLOW OR PILLOWCASE ( CORAL, BLUE, YELLOW) ONLY SIZE: 40X23X3CM', 'CLEVAMAMA BABY PILLOW (BABY 0-12M) & CLEVAMAMA BABY PILLOW OR PILLOWCASE ( CORAL, BLUE, YELLOW) ONLY SIZE: 40X23X3CM', 289.00, 'https://cf.shopee.com.my/file/45b4157d3d01672e93162890dceb5e93', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1598, 'Philips Avent ULTRA AIR Soother/ Pacifier [ 0-6m/ 6-18m ] Berry Ultraair Puting Kosong', 'Philips Avent ULTRA AIR Soother/ Pacifier [ 0-6m/ 6-18m ] Berry Ultraair Puting Kosong', 'Philips Avent ULTRA AIR Soother/ Pacifier [ 0-6m/ 6-18m ] Berry Ultraair Puting Kosong', 325.00, 'https://cf.shopee.com.my/file/f3eb32202730922ef813192f78763589', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1599, 'Frixion ball refill (per pc) 0.5mm / 0.7mm', 'Frixion ball refill (per pc) 0.5mm / 0.7mm', 'Frixion ball refill (per pc) 0.5mm / 0.7mm', 34.00, 'https://cf.shopee.com.my/file/bde2de98cb0f76302a903501439590ef', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1600, 'MOJO Carbon Fishing Spinning Rod 2 Section 1.98m 6\'6\'\' 2.13m 7\'0\" 2.28m 7\'6\" L/ML /M/MH Fast Baitcasting Sea Fishing Rod', 'MOJO Carbon Fishing Spinning Rod 2 Section 1.98m 6\'6\'\' 2.13m 7\'0\" 2.28m 7\'6\" L/ML /M/MH Fast Baitcasting Sea Fishing Rod', 'MOJO Carbon Fishing Spinning Rod 2 Section 1.98m 6\'6\'\' 2.13m 7\'0\" 2.28m 7\'6\" L/ML /M/MH Fast Baitcasting Sea Fishing Rod', 1243.20, 'https://cf.shopee.com.my/file/e7575ed12603a2c153a5ea0f16be0e6c', 1627909673, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1601, 'Uni-ball Uniball One Gel Pen 0.38mm UMN-S-38 [New 2021]', 'Uni-ball Uniball One Gel Pen 0.38mm UMN-S-38 [New 2021]', 'Uni-ball Uniball One Gel Pen 0.38mm UMN-S-38 [New 2021]', 49.00, 'https://cf.shopee.com.my/file/0a09b238a37ed613fb41903a6ef1de3a', 1627909674, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1603, 'FABER-CASTELL K-One Kone Gel Pen Ball Pen 0.5mm 0.7mm / Click Pen', 'FABER-CASTELL K-One Kone Gel Pen Ball Pen 0.5mm 0.7mm / Click Pen', 'FABER-CASTELL K-One Kone Gel Pen Ball Pen 0.5mm 0.7mm / Click Pen', 18.00, 'https://cf.shopee.com.my/file/b9ec842b21b8879fe3caba98ab02ee49', 1627909674, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1604, 'Deli Gel Pen Bullet Tip - Black (0.5mm) A566', 'Deli Gel Pen Bullet Tip - Black (0.5mm) A566', 'Deli Gel Pen Bullet Tip - Black (0.5mm) A566', 9.20, 'https://cf.shopee.com.my/file/290b4eee92da83bb8a42ca8f09f40476', 1627909674, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1605, 'Etude House Drawing Eye Brow (0.2g)', 'Etude House Drawing Eye Brow (0.2g)', 'Etude House Drawing Eye Brow (0.2g)', 190.00, 'https://cf.shopee.com.my/file/59bf756e983e16376682bd137039b2f5', 1627909674, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1606, 'Original Aegis G OCC READY STOCK  Aegis g coin 0.6 mesh', 'Original Aegis G OCC READY STOCK  Aegis g coin 0.6 mesh', 'Original Aegis G OCC READY STOCK  Aegis g coin 0.6 mesh', 109.00, 'https://cf.shopee.com.my/file/b14cf5cd185e6cb4d345b3707e75028b', 1627909674, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1607, 'Benang Kait Lace Cotton 0.8mm 50gm. Lace cotton crochet knitting yarn', 'Benang Kait Lace Cotton 0.8mm 50gm. Lace cotton crochet knitting yarn', 'Benang Kait Lace Cotton 0.8mm 50gm. Lace cotton crochet knitting yarn', 45.00, 'https://cf.shopee.com.my/file/a6ff47c9daa40e619700b3d6d1a26c5c', 1627909674, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1608, '0-9 Number Symbol Star Love Heart Sparkling Candle Firework Cake Topper Lilin Hari Jadi Bunga Api Kek Topper Kek Nombor', '0-9 Number Symbol Star Love Heart Sparkling Candle Firework Cake Topper Lilin Hari Jadi Bunga Api Kek Topper Kek Nombor', '0-9 Number Symbol Star Love Heart Sparkling Candle Firework Cake Topper Lilin Hari Jadi Bunga Api Kek Topper Kek Nombor', 27.00, 'https://cf.shopee.com.my/file/809aee313e696ce77ad6c5ef9f87594c', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1609, 'Blink Vision 0 to -6.0 Anti Blue Light Myopia Cermin Mata Wanita Rabun Jauh Korean Fashion Style Polygon Round Transparent Student Unisex Eyeglasses Frame Custom Lens', 'Blink Vision 0 to -6.0 Anti Blue Light Myopia Cermin Mata Wanita Rabun Jauh Korean Fashion Style Polygon Round Transparent Student Unisex Eyeglasses Frame Custom Lens', 'Blink Vision 0 to -6.0 Anti Blue Light Myopia Cermin Mata Wanita Rabun Jauh Korean Fashion Style Polygon Round Transparent Student Unisex Eyeglasses Frame Custom Lens', 70.50, 'https://cf.shopee.com.my/file/6655c5407ab50191ea029f9c1b6d83b2', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1610, 'UYAAI Hidrocor 14mm Colored Contacts Circle Lenses Natural 0 power 2pcs Yearly - ICE', 'UYAAI Hidrocor 14mm Colored Contacts Circle Lenses Natural 0 power 2pcs Yearly - ICE', 'UYAAI Hidrocor 14mm Colored Contacts Circle Lenses Natural 0 power 2pcs Yearly - ICE', 65.00, 'https://cf.shopee.com.my/file/665d2ada765482af47a4119130ba08c3', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1611, 'Uni-ball Signo 307 Gel Ink Pen 0.7mm/0.5mm/0.38mm 1pc', 'Uni-ball Signo 307 Gel Ink Pen 0.7mm/0.5mm/0.38mm 1pc', 'Uni-ball Signo 307 Gel Ink Pen 0.7mm/0.5mm/0.38mm 1pc', 49.00, 'https://cf.shopee.com.my/file/416f5f1d177a716caf4c9f9729451ca5', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1612, 'PD QC3.0 Fast Charger 20W Dual Port USB Type-C Wall Adapter Cable for iPhone12 UK Plug Universal Power Charge Adapter', 'PD QC3.0 Fast Charger 20W Dual Port USB Type-C Wall Adapter Cable for iPhone12 UK Plug Universal Power Charge Adapter', 'PD QC3.0 Fast Charger 20W Dual Port USB Type-C Wall Adapter Cable for iPhone12 UK Plug Universal Power Charge Adapter', 56.80, 'https://cf.shopee.com.my/file/9fee594001b86bda16da1a80d8d7a2c0', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1613, '3Pcs Premium White Gel Pen Set 0.6mm Fine Tip Sketching Pens for Artists Black Papers Drawing Design Illustration Art Supplies', '3Pcs Premium White Gel Pen Set 0.6mm Fine Tip Sketching Pens for Artists Black Papers Drawing Design Illustration Art Supplies', '3Pcs Premium White Gel Pen Set 0.6mm Fine Tip Sketching Pens for Artists Black Papers Drawing Design Illustration Art Supplies', 14.40, 'https://cf.shopee.com.my/file/6ff5450b295cb37c62eaf4c27c314e8b', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1614, 'GETMORE 36W Portable 4 Ports Smart USB Wall Charger QC3.0 Fast Charging Travel Phone Charger UK Plug Adapter Universal', 'GETMORE 36W Portable 4 Ports Smart USB Wall Charger QC3.0 Fast Charging Travel Phone Charger UK Plug Adapter Universal', 'GETMORE 36W Portable 4 Ports Smart USB Wall Charger QC3.0 Fast Charging Travel Phone Charger UK Plug Adapter Universal', 169.00, 'https://cf.shopee.com.my/file/cd211d0f086be87eda27f97c91d7e3ac', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1615, 'New Original Voopoo Find S Trio / Vinci / Vinci X / Vinci Air Replacement Coil 5pcs Occ 0.3 / 0.45 / 0.6 / 0.8 / 1.2Ohm', 'New Original Voopoo Find S Trio / Vinci / Vinci X / Vinci Air Replacement Coil 5pcs Occ 0.3 / 0.45 / 0.6 / 0.8 / 1.2Ohm', 'New Original Voopoo Find S Trio / Vinci / Vinci X / Vinci Air Replacement Coil 5pcs Occ 0.3 / 0.45 / 0.6 / 0.8 / 1.2Ohm', 387.00, 'https://cf.shopee.com.my/file/95096fbd605f8bb6520aa3a03348fb1b', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1616, '0.0 to -6.0 Cermin Mata Rabun Jauh Ringkas Frame Fashion Nearsighted Glasses', '0.0 to -6.0 Cermin Mata Rabun Jauh Ringkas Frame Fashion Nearsighted Glasses', '0.0 to -6.0 Cermin Mata Rabun Jauh Ringkas Frame Fashion Nearsighted Glasses', 65.00, 'https://cf.shopee.com.my/file/cbe69ab79583ecc27f9384a365ae2171', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1617, 'KAIN PASANG LP FABRICS 100% PREMIUM COMO CREPE (0.5M/ BIDANG 60\')', 'KAIN PASANG LP FABRICS 100% PREMIUM COMO CREPE (0.5M/ BIDANG 60\')', 'KAIN PASANG LP FABRICS 100% PREMIUM COMO CREPE (0.5M/ BIDANG 60\')', 28.60, 'https://cf.shopee.com.my/file/2601ce76101621bdbe2928ddb7856942', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1618, 'Hot i7S TWS Twins Wireless Earbuds Mini Bluetooth V5.0 Stereo Earphone TWS Earbuds', 'Hot i7S TWS Twins Wireless Earbuds Mini Bluetooth V5.0 Stereo Earphone TWS Earbuds', 'Hot i7S TWS Twins Wireless Earbuds Mini Bluetooth V5.0 Stereo Earphone TWS Earbuds', 99.00, 'https://cf.shopee.com.my/file/2a1b3f791246ed143a3036898bf6b15e', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1619, 'Pilot G2 Gel Pen Refill 0.38/0.5/0.7mm - (1\'pc)', 'Pilot G2 Gel Pen Refill 0.38/0.5/0.7mm - (1\'pc)', 'Pilot G2 Gel Pen Refill 0.38/0.5/0.7mm - (1\'pc)', 37.00, 'https://cf.shopee.com.my/file/a973d8abb885b9d6eb9ae8ce5998f9f8', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1620, '0-9 16inch Number Balloon Rose Gold Silver Blue Pink Color Weddings Birthday Party DIY Balloon', '0-9 16inch Number Balloon Rose Gold Silver Blue Pink Color Weddings Birthday Party DIY Balloon', '0-9 16inch Number Balloon Rose Gold Silver Blue Pink Color Weddings Birthday Party DIY Balloon', 5.80, 'https://cf.shopee.com.my/file/c855a98902f5b641f774767db60af8c5', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1622, 'Winzige 5Colors Retro Gel Pen Set Color Press Gel Pen 0.5mm Ball Pen Set', 'Winzige 5Colors Retro Gel Pen Set Color Press Gel Pen 0.5mm Ball Pen Set', 'Winzige 5Colors Retro Gel Pen Set Color Press Gel Pen 0.5mm Ball Pen Set', 119.90, 'https://cf.shopee.com.my/file/4b7acf618dcddaebe9723b9ca8e8970b', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1624, 'Mechanical Pencil - STABILO COM4 Blue/Pink in 0.5mm or 0.7mm', 'Mechanical Pencil - STABILO COM4 Blue/Pink in 0.5mm or 0.7mm', 'Mechanical Pencil - STABILO COM4 Blue/Pink in 0.5mm or 0.7mm', 31.50, 'https://cf.shopee.com.my/file/fc31da2e4805798d150a52b6c8e4211d', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1625, 'DELI PERMANENT SIGN MARKER PEN DUAL TIP 0.5/1 MM (1PCS)', 'DELI PERMANENT SIGN MARKER PEN DUAL TIP 0.5/1 MM (1PCS)', 'DELI PERMANENT SIGN MARKER PEN DUAL TIP 0.5/1 MM (1PCS)', 17.00, 'https://cf.shopee.com.my/file/e7f035c096a49997f022c2e11fe8c9f8', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1627, 'Sniper Condom Ultra Thin 0.01mm - 9 Type Fire & Ice Feel & Delay Jelly Condom For Men | Kondom Lelaki Tahan Lama', 'Sniper Condom Ultra Thin 0.01mm - 9 Type Fire & Ice Feel & Delay Jelly Condom For Men | Kondom Lelaki Tahan Lama', 'Sniper Condom Ultra Thin 0.01mm - 9 Type Fire & Ice Feel & Delay Jelly Condom For Men | Kondom Lelaki Tahan Lama', 108.00, 'https://cf.shopee.com.my/file/b85b80057dd40609c5f6390baf69bed3', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1628, 'Original SMOK RPM 40 / Fetch 5Pcs Occ / Rba / 0.17 RGC Coil / 0.4 Mesh / 1.0 SC / 0.6 Triple / 1.2 Quartz Ohm Coil', 'Original SMOK RPM 40 / Fetch 5Pcs Occ / Rba / 0.17 RGC Coil / 0.4 Mesh / 1.0 SC / 0.6 Triple / 1.2 Quartz Ohm Coil', 'Original SMOK RPM 40 / Fetch 5Pcs Occ / Rba / 0.17 RGC Coil / 0.4 Mesh / 1.0 SC / 0.6 Triple / 1.2 Quartz Ohm Coil', 300.00, 'https://cf.shopee.com.my/file/29640991da75460acdda81a085841791', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1629, 'Japan Toho Round Seed Beads Opaque 11/0 (100G) 16 warna', 'Japan Toho Round Seed Beads Opaque 11/0 (100G) 16 warna', 'Japan Toho Round Seed Beads Opaque 11/0 (100G) 16 warna', 235.00, 'https://cf.shopee.com.my/file/5930713a7d06cc49d974815c69a34366', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1631, 'Uni JETSTREAM 101 Roller 0.5 mm 0.7mm 1.0mm', 'Uni JETSTREAM 101 Roller 0.5 mm 0.7mm 1.0mm', 'Uni JETSTREAM 101 Roller 0.5 mm 0.7mm 1.0mm', 29.00, 'https://cf.shopee.com.my/file/e8202e2282e51dadd06cc868234d0346', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1632, 'HdoorLink Micro USB OTG Adapter USB3.0 to Type C Data Sync To Flash Drive Mouse Connector for Android Phone', 'HdoorLink Micro USB OTG Adapter USB3.0 to Type C Data Sync To Flash Drive Mouse Connector for Android Phone', 'HdoorLink Micro USB OTG Adapter USB3.0 to Type C Data Sync To Flash Drive Mouse Connector for Android Phone', 30.00, 'https://cf.shopee.com.my/file/b7cd35c969deffeb92f249640b80c37b', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1633, 'M&G R1 &R3 0.5mm GEL INK PEN 1PCS', 'M&G R1 &R3 0.5mm GEL INK PEN 1PCS', 'M&G R1 &R3 0.5mm GEL INK PEN 1PCS', 9.60, 'https://cf.shopee.com.my/file/ce564d1e712d20a0cf67749a2a0e6c2f', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1634, 'Long Lip Minnow Freshwater Sea Fishing Lure Deep Suspend 0-2m 6g/60mm Artificial Bass Sea Fishing Plastic Hard Bait', 'Long Lip Minnow Freshwater Sea Fishing Lure Deep Suspend 0-2m 6g/60mm Artificial Bass Sea Fishing Plastic Hard Bait', 'Long Lip Minnow Freshwater Sea Fishing Lure Deep Suspend 0-2m 6g/60mm Artificial Bass Sea Fishing Plastic Hard Bait', 35.80, 'https://cf.shopee.com.my/file/7c042fb4ea2284e5e08818b64f708390', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1635, 'Craft Wire, Copper-Based Wire, 0.2mm-1.00mm  Jewelry Special Copper Wire', 'Craft Wire, Copper-Based Wire, 0.2mm-1.00mm  Jewelry Special Copper Wire', 'Craft Wire, Copper-Based Wire, 0.2mm-1.00mm  Jewelry Special Copper Wire', 35.00, 'https://cf.shopee.com.my/file/c00539624ad1fd68da0d4be2ed41bdc2', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1637, '(RM 0.28/pcs) 100PCS Ferrero Rocher Casing/ Plastic Ferrero Clear/ FERRERO Rocher CASING /Ferrero Cup', '(RM 0.28/pcs) 100PCS Ferrero Rocher Casing/ Plastic Ferrero Clear/ FERRERO Rocher CASING /Ferrero Cup', '(RM 0.28/pcs) 100PCS Ferrero Rocher Casing/ Plastic Ferrero Clear/ FERRERO Rocher CASING /Ferrero Cup', 280.00, 'https://cf.shopee.com.my/file/099b75f95dd9f3b7df5e548812a93c8b', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1638, 'PUPEE Newborn Baby Singlet Romper Jumpsuit Sleeveless 100% Cotton 0-24 Months', 'PUPEE Newborn Baby Singlet Romper Jumpsuit Sleeveless 100% Cotton 0-24 Months', 'PUPEE Newborn Baby Singlet Romper Jumpsuit Sleeveless 100% Cotton 0-24 Months', 59.00, 'https://cf.shopee.com.my/file/7cd101a87d75f600f6212da503e4abd2', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1640, '500g x 0.1g Digital LCD Scale High Precision Electronic Kitchen Scale Food Mini Scale pocket scale Portable Scale Mini Pocket Penimbang Emas Mini Scale Timbang Digital Pocket Portable LCD Backlight Display Weight Jewellery Gold', '500g x 0.1g Digital LCD Scale High Precision Electronic Kitchen Scale Food Mini Scale pocket scale Portable Scale Mini Pocket Penimbang Emas Mini Scale Timbang Digital Pocket Portable LCD Backlight Display Weight Jewellery Gold', '500g x 0.1g Digital LCD Scale High Precision Electronic Kitchen Scale Food Mini Scale pocket scale Portable Scale Mini Pocket Penimbang Emas Mini Scale Timbang Digital Pocket Portable LCD Backlight Display Weight Jewellery Gold', 118.80, 'https://cf.shopee.com.my/file/3e5145e4a975d9b53590037df6a261a9', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1641, '[READY STOCK]M-XXL Thailand Latex Bra 3D Back Button Breathable High Quality Bras Without Wire 6.0', '[READY STOCK]M-XXL Thailand Latex Bra 3D Back Button Breathable High Quality Bras Without Wire 6.0', '[READY STOCK]M-XXL Thailand Latex Bra 3D Back Button Breathable High Quality Bras Without Wire 6.0', 129.00, 'https://cf.shopee.com.my/file/70396f0051feecc941c2f58281e4f0cf', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1642, 'FABER-CASTELL RX GEL PEN (0.5/0.7) / Faber Castell Gel Pen / RX Gel Pen / Click Gel Pen', 'FABER-CASTELL RX GEL PEN (0.5/0.7) / Faber Castell Gel Pen / RX Gel Pen / Click Gel Pen', 'FABER-CASTELL RX GEL PEN (0.5/0.7) / Faber Castell Gel Pen / RX Gel Pen / Click Gel Pen', 16.00, 'https://cf.shopee.com.my/file/6611c69d9f09f94f7b4603c3f7ae3afa', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1643, 'SS Socket Cap Screw M2 (Coarse Thread Pitch 0.4mm) (Stainless Steel 304 Allen Cap Bolt)', 'SS Socket Cap Screw M2 (Coarse Thread Pitch 0.4mm) (Stainless Steel 304 Allen Cap Bolt)', 'SS Socket Cap Screw M2 (Coarse Thread Pitch 0.4mm) (Stainless Steel 304 Allen Cap Bolt)', 2.00, 'https://cf.shopee.com.my/file/b2f2a78df40a3f86b52d9eff59a0925f', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1644, 'HT CSK Allen Screw - M3 x 6mm ~ 30mm (Coarse Thread Pitch 0.5mm) (High Tensile Countersunk Socket Cap Bolt)', 'HT CSK Allen Screw - M3 x 6mm ~ 30mm (Coarse Thread Pitch 0.5mm) (High Tensile Countersunk Socket Cap Bolt)', 'HT CSK Allen Screw - M3 x 6mm ~ 30mm (Coarse Thread Pitch 0.5mm) (High Tensile Countersunk Socket Cap Bolt)', 2.00, 'https://cf.shopee.com.my/file/e99bfc3a18e37a41392a08ff8144659e', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1645, 'GSoft writemate WX1 semi Gel Ink Ball Pen 0.4mm 1pcs', 'GSoft writemate WX1 semi Gel Ink Ball Pen 0.4mm 1pcs', 'GSoft writemate WX1 semi Gel Ink Ball Pen 0.4mm 1pcs', 7.80, 'https://cf.shopee.com.my/file/3a5cee4a6f0b1f4b77e2305623dc3324', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1647, 'Getah Kain 1\", 0.75\" & 0.5\" (Jual Meter)', 'Getah Kain 1\", 0.75\" & 0.5\" (Jual Meter)', 'Getah Kain 1\", 0.75\" & 0.5\" (Jual Meter)', 9.00, 'https://cf.shopee.com.my/file/49049eea9a61cbbdc41c051a5c1fc2e7', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1648, 'Pilot Ball Pen Fine BP-1RT 0.7mm', 'Pilot Ball Pen Fine BP-1RT 0.7mm', 'Pilot Ball Pen Fine BP-1RT 0.7mm', 10.50, 'https://cf.shopee.com.my/file/e45a5b5488ea7c6215085a21e3559272', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1649, 'HemoHIM Immune system 0.67mz x 60ea / 1200g', 'HemoHIM Immune system 0.67mz x 60ea / 1200g', 'HemoHIM Immune system 0.67mz x 60ea / 1200g', 2732.20, 'https://cf.shopee.com.my/file/bc6a9970690a1fd379b68118809b97d3', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1650, 'Lead Mechanical Pencil Leads 0.5mm 0.7mm Buncho Stabilo Faster (Ubat Pensil Mekanik)', 'Lead Mechanical Pencil Leads 0.5mm 0.7mm Buncho Stabilo Faster (Ubat Pensil Mekanik)', 'Lead Mechanical Pencil Leads 0.5mm 0.7mm Buncho Stabilo Faster (Ubat Pensil Mekanik)', 5.90, 'https://cf.shopee.com.my/file/5ac926c16abd6d25c5541858557c10f2', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1651, 'FIFFY Baby Soother 0-3 Months++ -cherry / orthodontic soother(ready stock)(1893, 1895)', 'FIFFY Baby Soother 0-3 Months++ -cherry / orthodontic soother(ready stock)(1893, 1895)', 'FIFFY Baby Soother 0-3 Months++ -cherry / orthodontic soother(ready stock)(1893, 1895)', 59.00, 'https://cf.shopee.com.my/file/a881331dcd965f9bcc8d02053bb9cc2f', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1652, 'ORGINAL Hydrocor Jade Brown 14.2mm Contact Lens Lenses Degree 0-800 , Degree Eyes Lens B272-1 Kanta Lekap', 'ORGINAL Hydrocor Jade Brown 14.2mm Contact Lens Lenses Degree 0-800 , Degree Eyes Lens B272-1 Kanta Lekap', 'ORGINAL Hydrocor Jade Brown 14.2mm Contact Lens Lenses Degree 0-800 , Degree Eyes Lens B272-1 Kanta Lekap', 83.00, 'https://cf.shopee.com.my/file/41598765e20018b874efd9746576d700', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1653, 'Novel: POLAROID CINTA ZENIA | Penulis: Dila Dyna | Penerbit: Karyaseni | ISBN: 978-967-469-070-0', 'Novel: POLAROID CINTA ZENIA | Penulis: Dila Dyna | Penerbit: Karyaseni | ISBN: 978-967-469-070-0', 'Novel: POLAROID CINTA ZENIA | Penulis: Dila Dyna | Penerbit: Karyaseni | ISBN: 978-967-469-070-0', 180.00, 'https://cf.shopee.com.my/file/7f97fb0d0d0469d0d5b62847ca774c86', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1654, 'Wholesale Price! 14/0.26MM / 28/0.26MMCar Lori Automotive Wire Auto Cables 100% Copper - 30M', 'Wholesale Price! 14/0.26MM / 28/0.26MMCar Lori Automotive Wire Auto Cables 100% Copper - 30M', 'Wholesale Price! 14/0.26MM / 28/0.26MMCar Lori Automotive Wire Auto Cables 100% Copper - 30M', 94.90, 'https://cf.shopee.com.my/file/c4adbe9045a4d762be1242f26847ee3d', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1655, 'HemoHIM Immune system 0.67mz x 60ea/1200g', 'HemoHIM Immune system 0.67mz x 60ea/1200g', 'HemoHIM Immune system 0.67mz x 60ea/1200g', 2750.00, 'https://cf.shopee.com.my/file/05af5bdc7cf0d654bc5b53b3d268e821', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1656, 'LDNIO XS073 Micro/iPhone/Type-C 2.4A Fast Charging & Data Short Cable (0.3m)', 'LDNIO XS073 Micro/iPhone/Type-C 2.4A Fast Charging & Data Short Cable (0.3m)', 'LDNIO XS073 Micro/iPhone/Type-C 2.4A Fast Charging & Data Short Cable (0.3m)', 36.00, 'https://cf.shopee.com.my/file/ca72aebcc526dcba739d7ee125ab9cff', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1657, 'YOHESO 3KG 0.1G Mini Scale LCD Display Digital Kitchen Weight Cake Baking Scale With Tray Penimbang Kek [FREE BATTERIES]', 'YOHESO 3KG 0.1G Mini Scale LCD Display Digital Kitchen Weight Cake Baking Scale With Tray Penimbang Kek [FREE BATTERIES]', 'YOHESO 3KG 0.1G Mini Scale LCD Display Digital Kitchen Weight Cake Baking Scale With Tray Penimbang Kek [FREE BATTERIES]', 69.00, 'https://cf.shopee.com.my/file/1b2b970d1a81bb203133d0ecf3287474', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1658, 'M&G AGP13271 OFFICE-G GEL PEN  0.5MM', 'M&G AGP13271 OFFICE-G GEL PEN  0.5MM', 'M&G AGP13271 OFFICE-G GEL PEN  0.5MM', 7.80, 'https://cf.shopee.com.my/file/f0a7ee5ac995b54f24648b990abe6274', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1660, 'Seamiart_1pc 0.8mm White Highlight Pen Suitable for Hook Line/Sketch/Anime/Black Card', 'Seamiart_1pc 0.8mm White Highlight Pen Suitable for Hook Line/Sketch/Anime/Black Card', 'Seamiart_1pc 0.8mm White Highlight Pen Suitable for Hook Line/Sketch/Anime/Black Card', 9.70, 'https://cf.shopee.com.my/file/e85e6143b30690b93f71e8945406cb04', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1661, '**Ready Stock** 8 Colors Kids Clothing Short Sleeve  Fashion Roblox Cartoon Cotton T shirt Kids TEE 0-10 Years', '**Ready Stock** 8 Colors Kids Clothing Short Sleeve  Fashion Roblox Cartoon Cotton T shirt Kids TEE 0-10 Years', '**Ready Stock** 8 Colors Kids Clothing Short Sleeve  Fashion Roblox Cartoon Cotton T shirt Kids TEE 0-10 Years', 111.50, 'https://cf.shopee.com.my/file/4ebd57e9ade13c59cbd72a66a55171fa', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1662, 'Anakku 3pcs Baby Girl Newborn Suit Set Combo Clothing Set Baju Bayi Perempuan [0-12 Months] 220532-1', 'Anakku 3pcs Baby Girl Newborn Suit Set Combo Clothing Set Baju Bayi Perempuan [0-12 Months] 220532-1', 'Anakku 3pcs Baby Girl Newborn Suit Set Combo Clothing Set Baju Bayi Perempuan [0-12 Months] 220532-1', 380.00, 'https://cf.shopee.com.my/file/619a370f8636c55d49368d6a38ca18f1', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1663, 'Ready Stock Newborn  0-24M Baby Romper One-Piece Clothing Simple  Summer Sleeveless Cotton Boys Girls Clothes', 'Ready Stock Newborn  0-24M Baby Romper One-Piece Clothing Simple  Summer Sleeveless Cotton Boys Girls Clothes', 'Ready Stock Newborn  0-24M Baby Romper One-Piece Clothing Simple  Summer Sleeveless Cotton Boys Girls Clothes', 275.70, 'https://cf.shopee.com.my/file/08c5971152a5347d91fa3229c3d4ef26', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1665, '0.3MM iPhone 5se 5 5s 6 6s 7 8 plus x xs max xr SE 2020 6PLUS Case Matte Plastic Cover Casing', '0.3MM iPhone 5se 5 5s 6 6s 7 8 plus x xs max xr SE 2020 6PLUS Case Matte Plastic Cover Casing', '0.3MM iPhone 5se 5 5s 6 6s 7 8 plus x xs max xr SE 2020 6PLUS Case Matte Plastic Cover Casing', 16.00, 'https://cf.shopee.com.my/file/6dca9c1a6e6c7d20a5fed4a62fa6bda6', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1666, 'Resistor 0.25W 5% (1K) [10pcs]', 'Resistor 0.25W 5% (1K) [10pcs]', 'Resistor 0.25W 5% (1K) [10pcs]', 10.00, 'https://cf.shopee.com.my/file/3c0dc749fadbf17f356ccaba3fec37ff', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1668, 'Girl fashion suit 0-4 years girl skirt cute baby girl lattice group + pants 2-piece T-shirt', 'Girl fashion suit 0-4 years girl skirt cute baby girl lattice group + pants 2-piece T-shirt', 'Girl fashion suit 0-4 years girl skirt cute baby girl lattice group + pants 2-piece T-shirt', 164.40, 'https://cf.shopee.com.my/file/6263d33b37da823019d32d442d94d511', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1669, 'Tikar Getah 6 kaki lebar Tebal 0.40mm SAGA EMBOSES BERKUALITI', 'Tikar Getah 6 kaki lebar Tebal 0.40mm SAGA EMBOSES BERKUALITI', 'Tikar Getah 6 kaki lebar Tebal 0.40mm SAGA EMBOSES BERKUALITI', 39.00, 'https://cf.shopee.com.my/file/9f9583d3ac4e0df62ef2b17061e9ab4d', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1670, 'Neffos X9 TP913A C7 Y7 TP910A NBL- 35B3000 N1 TP908A X1 Max Tp903a c9s 40A2950 C9A 40A2920 Battery TP910A24MY TP91/0/3/C', 'Neffos X9 TP913A C7 Y7 TP910A NBL- 35B3000 N1 TP908A X1 Max Tp903a c9s 40A2950 C9A 40A2920 Battery TP910A24MY TP91/0/3/C', 'Neffos X9 TP913A C7 Y7 TP910A NBL- 35B3000 N1 TP908A X1 Max Tp903a c9s 40A2950 C9A 40A2920 Battery TP910A24MY TP91/0/3/C', 266.90, 'https://cf.shopee.com.my/file/978f50e9497b8d0192b2f42979b5f089', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1672, '[Ready Stock] Cute Cartoon Kids Sleeping Pillows 0-10 Years Cotton Infant Baby Prevent Flat Head Pillow Kids', '[Ready Stock] Cute Cartoon Kids Sleeping Pillows 0-10 Years Cotton Infant Baby Prevent Flat Head Pillow Kids', '[Ready Stock] Cute Cartoon Kids Sleeping Pillows 0-10 Years Cotton Infant Baby Prevent Flat Head Pillow Kids', 96.30, 'https://cf.shopee.com.my/file/d031ad3d1dcd83c6d89f17b7644d66dc', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1673, 'BORONG PLAIN SHAWL CHIFFON (HARGA PER PC) (ORDER LEBIH 10PCS LAGI MURAH) - 1.8m x 0.7m', 'BORONG PLAIN SHAWL CHIFFON (HARGA PER PC) (ORDER LEBIH 10PCS LAGI MURAH) - 1.8m x 0.7m', 'BORONG PLAIN SHAWL CHIFFON (HARGA PER PC) (ORDER LEBIH 10PCS LAGI MURAH) - 1.8m x 0.7m', 58.00, 'https://cf.shopee.com.my/file/6cc0fb753b3df76eff84b007cd80b28b', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1674, '0-3 Year Baby Socks Cotton Toddler Socks Cute Cartoon  Anti-slip Socks Baby Girl Baby Boy Soft Socks Cute Cartoon Colorful', '0-3 Year Baby Socks Cotton Toddler Socks Cute Cartoon  Anti-slip Socks Baby Girl Baby Boy Soft Socks Cute Cartoon Colorful', '0-3 Year Baby Socks Cotton Toddler Socks Cute Cartoon  Anti-slip Socks Baby Girl Baby Boy Soft Socks Cute Cartoon Colorful', 29.70, 'https://cf.shopee.com.my/file/787892fe2cddfd530fbff0a4d6ae522b', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1675, 'Baja NPK (16:16:16) 0.5KG / Repack / Baja Buah / Baja Bunga / Baja Subur', 'Baja NPK (16:16:16) 0.5KG / Repack / Baja Buah / Baja Bunga / Baja Subur', 'Baja NPK (16:16:16) 0.5KG / Repack / Baja Buah / Baja Bunga / Baja Subur', 40.00, 'https://cf.shopee.com.my/file/c5f749201f8cf1a81144206f840883ca', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1677, 'OPPO Reno5 5G Smartphone | 8GB RAM + 128GB ROM | 65W Super VOOC2.0 | Picture Life Together', 'OPPO Reno5 5G Smartphone | 8GB RAM + 128GB ROM | 65W Super VOOC2.0 | Picture Life Together', 'OPPO Reno5 5G Smartphone | 8GB RAM + 128GB ROM | 65W Super VOOC2.0 | Picture Life Together', 16990.00, 'https://cf.shopee.com.my/file/06ab2a302db089b5c6e7bb761f4171f9', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1678, '50pcs/lot 8299 fishing hook Octopus Beak Bait Fishhooks Offset High Carbon Steel Barbed size 9/0-1/0 1 2 4 6', '50pcs/lot 8299 fishing hook Octopus Beak Bait Fishhooks Offset High Carbon Steel Barbed size 9/0-1/0 1 2 4 6', '50pcs/lot 8299 fishing hook Octopus Beak Bait Fishhooks Offset High Carbon Steel Barbed size 9/0-1/0 1 2 4 6', 38.90, 'https://cf.shopee.com.my/file/ef263093458bfb19add85f3f02ee0aa5', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1680, 'Baby boys\' clothes 0-4 years old boys\' clothing kids short sleeve set Stripe Polo short sleeve suit', 'Baby boys\' clothes 0-4 years old boys\' clothing kids short sleeve set Stripe Polo short sleeve suit', 'Baby boys\' clothes 0-4 years old boys\' clothing kids short sleeve set Stripe Polo short sleeve suit', 166.90, 'https://cf.shopee.com.my/file/a4c5df066ebaf44f18213b07361ed856', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1681, 'Part 1 Premium Diamond Satin 0.5m Bidang 58/60', 'Part 1 Premium Diamond Satin 0.5m Bidang 58/60', 'Part 1 Premium Diamond Satin 0.5m Bidang 58/60', 61.50, 'https://cf.shopee.com.my/file/69b4bf51674c96e6fe466d0401d0a411', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1682, 'Baseus 65W Car Charger Quick Charge 4.0 3.0 Type C PD Fast Charger QC4.0 QC3.0 USB Phone Charger in Car For iPhone 12 Xiaomi', 'Baseus 65W Car Charger Quick Charge 4.0 3.0 Type C PD Fast Charger QC4.0 QC3.0 USB Phone Charger in Car For iPhone 12 Xiaomi', 'Baseus 65W Car Charger Quick Charge 4.0 3.0 Type C PD Fast Charger QC4.0 QC3.0 USB Phone Charger in Car For iPhone 12 Xiaomi', 470.70, 'https://cf.shopee.com.my/file/f1b07899d619eac4546f3792a312e3a5', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1683, 'The Face Shop Designing Eyebrow Pencil (0.3g)', 'The Face Shop Designing Eyebrow Pencil (0.3g)', 'The Face Shop Designing Eyebrow Pencil (0.3g)', 89.00, 'https://cf.shopee.com.my/file/d6d3db55db5bcae6c54af433f90ca9c9', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1685, 'Olaplex No.3 , No.4 , No.5 , No.6 , No.7 , No.0 (Free Postage)', 'Olaplex No.3 , No.4 , No.5 , No.6 , No.7 , No.0 (Free Postage)', 'Olaplex No.3 , No.4 , No.5 , No.6 , No.7 , No.0 (Free Postage)', 950.00, 'https://cf.shopee.com.my/file/24f2c12b8197e14ffd99c88dcc87b76d', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1686, 'Pilot Frixion Clicker Roller Pen Refill 0.5/0.7mm - Per Piece', 'Pilot Frixion Clicker Roller Pen Refill 0.5/0.7mm - Per Piece', 'Pilot Frixion Clicker Roller Pen Refill 0.5/0.7mm - Per Piece', 35.00, 'https://cf.shopee.com.my/file/66ba33b34eadcb42162d9f883264bbbc', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1687, '( DAILY 30PCS) Dailies Aqua Comfort Plus Alcon Daily Lenses One Day - -0.50 to -10.00 (30 Pcs)', '( DAILY 30PCS) Dailies Aqua Comfort Plus Alcon Daily Lenses One Day - -0.50 to -10.00 (30 Pcs)', '( DAILY 30PCS) Dailies Aqua Comfort Plus Alcon Daily Lenses One Day - -0.50 to -10.00 (30 Pcs)', 539.90, 'https://cf.shopee.com.my/file/a89cd980a4ea24704ad18c48fbb2194b', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1688, '25yrd /ROLL 0.95cm (3/8\') POLYESTER RIBBON / REBEN POLIESTER / SATIN RIBBON / REBEN SATIN  / RIBBON HADIAH / RB167', '25yrd /ROLL 0.95cm (3/8\') POLYESTER RIBBON / REBEN POLIESTER / SATIN RIBBON / REBEN SATIN  / RIBBON HADIAH / RB167', '25yrd /ROLL 0.95cm (3/8\') POLYESTER RIBBON / REBEN POLIESTER / SATIN RIBBON / REBEN SATIN  / RIBBON HADIAH / RB167', 29.00, 'https://cf.shopee.com.my/file/d4d37f0e2c9387a8291c47c7875a0566', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1690, '(LOCK LIVE) BAJU BUNDLE BABY 0-24m', '(LOCK LIVE) BAJU BUNDLE BABY 0-24m', '(LOCK LIVE) BAJU BUNDLE BABY 0-24m', 10.00, 'https://cf.shopee.com.my/file/98554ccd8429447cd73d0440d13b2d7d', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1691, '0-4 Years Baby Girls Lace Embroidery Party Tutu Gown With Headband Petal Hem Floral Princess Dresses', '0-4 Years Baby Girls Lace Embroidery Party Tutu Gown With Headband Petal Hem Floral Princess Dresses', '0-4 Years Baby Girls Lace Embroidery Party Tutu Gown With Headband Petal Hem Floral Princess Dresses', 21.00, 'https://cf.shopee.com.my/file/babe177133081dc5b6fb515cb91ad539', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1692, '0-15Y Kid Set Pajamas Shirt+Pants Boy Girl Sleepwear 2', '0-15Y Kid Set Pajamas Shirt+Pants Boy Girl Sleepwear 2', '0-15Y Kid Set Pajamas Shirt+Pants Boy Girl Sleepwear 2', 85.00, 'https://cf.shopee.com.my/file/a16a3d3d6affc6275a2386e19adb34be', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1693, 'Newborn Baby wear, baju bayi 0-3months', 'Newborn Baby wear, baju bayi 0-3months', 'Newborn Baby wear, baju bayi 0-3months', 49.00, 'https://cf.shopee.com.my/file/bbce7b2689c816e0c2f2c0c0e5f027bf', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1694, 'Eyelet NEWBORN T-SHIRT EYELET SUIT / BAJU BABY LUBANG 0-3months', 'Eyelet NEWBORN T-SHIRT EYELET SUIT / BAJU BABY LUBANG 0-3months', 'Eyelet NEWBORN T-SHIRT EYELET SUIT / BAJU BABY LUBANG 0-3months', 85.00, 'https://cf.shopee.com.my/file/5f00e289f9446738d2387d90f8fbdc46', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1695, 'Newborn Baby suit 0-3months,baju set bayi,baby wear', 'Newborn Baby suit 0-3months,baju set bayi,baby wear', 'Newborn Baby suit 0-3months,baju set bayi,baby wear', 39.00, 'https://cf.shopee.com.my/file/da712b084d2b6a7365f77a16adde07a6', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1697, '1pcs Freshkon Alluring Daily Color Mystical Black - 0.00 to -5.00 (1 Pc)', '1pcs Freshkon Alluring Daily Color Mystical Black - 0.00 to -5.00 (1 Pc)', '1pcs Freshkon Alluring Daily Color Mystical Black - 0.00 to -5.00 (1 Pc)', 20.50, 'https://cf.shopee.com.my/file/473262918ced493cf9983cc1bca7e57c', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1698, '[Ready Stock]Summer 2020 0-5 year old boys and girls new striped letter cotton short sleeves with Korean version of casual denim pocket shoulder strap suit', '[Ready Stock]Summer 2020 0-5 year old boys and girls new striped letter cotton short sleeves with Korean version of casual denim pocket shoulder strap suit', '[Ready Stock]Summer 2020 0-5 year old boys and girls new striped letter cotton short sleeves with Korean version of casual denim pocket shoulder strap suit', 189.70, 'https://cf.shopee.com.my/file/6a6ae390682101e54cf86154f28758af', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1699, 'Sweet Cherry Convertible Infant Baby Car Seat Newborn to 6 years old AY373A Miya Car Seat Group 0+,1,2', 'Sweet Cherry Convertible Infant Baby Car Seat Newborn to 6 years old AY373A Miya Car Seat Group 0+,1,2', 'Sweet Cherry Convertible Infant Baby Car Seat Newborn to 6 years old AY373A Miya Car Seat Group 0+,1,2', 3290.00, 'https://cf.shopee.com.my/file/726a3750a2d228baa023ee83fd1e24e0', 1627909675, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1703, 'Faber Castell K-One Kone Gel Pen Ball Pen 0.5mm', 'Faber Castell K-One Kone Gel Pen Ball Pen 0.5mm', 'Faber Castell K-One Kone Gel Pen Ball Pen 0.5mm', 11.60, 'https://cf.shopee.com.my/file/5be5a2cda69e1597e1e5fed1c949088a', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1704, 'USB Type C to USB2.0 Type B Printer Connector Adaptor Cable Data Sync for Midi Keyboard scanner Macbook Pro Phone tablet', 'USB Type C to USB2.0 Type B Printer Connector Adaptor Cable Data Sync for Midi Keyboard scanner Macbook Pro Phone tablet', 'USB Type C to USB2.0 Type B Printer Connector Adaptor Cable Data Sync for Midi Keyboard scanner Macbook Pro Phone tablet', 129.00, 'https://cf.shopee.com.my/file/bea6ec14a57dd77741425ee9b0f93d66', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1705, 'Pilot G2 Gel Pen Refill BLS-G2 0.5mm/0.7mm/1.0mm', 'Pilot G2 Gel Pen Refill BLS-G2 0.5mm/0.7mm/1.0mm', 'Pilot G2 Gel Pen Refill BLS-G2 0.5mm/0.7mm/1.0mm', 37.00, 'https://cf.shopee.com.my/file/386094e2c1e70a9331a1301f9b5a012b', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1707, 'Malay Comic Offered Rm 0.99', 'Malay Comic Offered Rm 0.99', 'Malay Comic Offered Rm 0.99', 9.90, 'https://cf.shopee.com.my/file/41bae9a69e72cafdb2f25aee42742b33', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1710, 'Vinnfier Hyperbar 200 BTR Wireless Soundbar with Bluetooth V5.0 USB Drive MicroSD Aux line in', 'Vinnfier Hyperbar 200 BTR Wireless Soundbar with Bluetooth V5.0 USB Drive MicroSD Aux line in', 'Vinnfier Hyperbar 200 BTR Wireless Soundbar with Bluetooth V5.0 USB Drive MicroSD Aux line in', 999.00, 'https://cf.shopee.com.my/file/4cb7a1d685c00daf536d316dcd58637d', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1711, '10 Pcs Japanese manga brush Pen 0.05 0.1 0.2 0.3 0.4 0.5 0.6 0.8 1Different Tip Black Fineliner Sketching Pens', '10 Pcs Japanese manga brush Pen 0.05 0.1 0.2 0.3 0.4 0.5 0.6 0.8 1Different Tip Black Fineliner Sketching Pens', '10 Pcs Japanese manga brush Pen 0.05 0.1 0.2 0.3 0.4 0.5 0.6 0.8 1Different Tip Black Fineliner Sketching Pens', 161.90, 'https://cf.shopee.com.my/file/3e0a0b2ca7509e3d80513d1b3201bb40', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1712, 'Buncho 0.5 2B Pencil Lead Hi-Polymer 0.5mm x 70mm', 'Buncho 0.5 2B Pencil Lead Hi-Polymer 0.5mm x 70mm', 'Buncho 0.5 2B Pencil Lead Hi-Polymer 0.5mm x 70mm', 9.00, 'https://cf.shopee.com.my/file/a2825fefa3bec2a7653345c1ba8084a1', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1713, 'M&G Office G Gel Pen 0.5mm AG13271', 'M&G Office G Gel Pen 0.5mm AG13271', 'M&G Office G Gel Pen 0.5mm AG13271', 8.00, 'https://cf.shopee.com.my/file/39f6951cb9a2e08aeb50aefc93288613', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1714, 'Ready stock in KL Geek Vape Aegis Boost Replacement Coil / Occ 0.4 Mesh & 0.6 Mesh 5Pcs/Pack', 'Ready stock in KL Geek Vape Aegis Boost Replacement Coil / Occ 0.4 Mesh & 0.6 Mesh 5Pcs/Pack', 'Ready stock in KL Geek Vape Aegis Boost Replacement Coil / Occ 0.4 Mesh & 0.6 Mesh 5Pcs/Pack', 225.00, 'https://cf.shopee.com.my/file/00f639d668f0263bbbe62a9a14b8091a', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1715, 'Jelly Color Gel Pen 0.5mm Writing Student Pen Office Supplies', 'Jelly Color Gel Pen 0.5mm Writing Student Pen Office Supplies', 'Jelly Color Gel Pen 0.5mm Writing Student Pen Office Supplies', 8.50, 'https://cf.shopee.com.my/file/d975179324a37515e41e217652550d54', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1716, 'Ready Stock 100% Original Uwell Caliburn G OCC Empty Cartridge 0.8 OCC 1.0 OCC', 'Ready Stock 100% Original Uwell Caliburn G OCC Empty Cartridge 0.8 OCC 1.0 OCC', 'Ready Stock 100% Original Uwell Caliburn G OCC Empty Cartridge 0.8 OCC 1.0 OCC', 75.00, 'https://cf.shopee.com.my/file/94155b03f444adbdae4997d8a476e460', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1717, 'Kavkas Baby Girls Rompers Winter Christmas Jumpsuit 0-24M Newborn Baby Boy Halloween Clothes', 'Kavkas Baby Girls Rompers Winter Christmas Jumpsuit 0-24M Newborn Baby Boy Halloween Clothes', 'Kavkas Baby Girls Rompers Winter Christmas Jumpsuit 0-24M Newborn Baby Boy Halloween Clothes', 215.80, 'https://cf.shopee.com.my/file/f5dda6b0f36437c919eff1dbff146dfd', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1718, '[PROMOTION] Capasitor fan /kondenser/ kapasitor fan Kipas Kdk/panasonic 2.4uf 5 uf 1.8uf , 1uf , 0.82uf', '[PROMOTION] Capasitor fan /kondenser/ kapasitor fan Kipas Kdk/panasonic 2.4uf 5 uf 1.8uf , 1uf , 0.82uf', '[PROMOTION] Capasitor fan /kondenser/ kapasitor fan Kipas Kdk/panasonic 2.4uf 5 uf 1.8uf , 1uf , 0.82uf', 119.90, 'https://cf.shopee.com.my/file/556e998c3f957fd094d36bf0872afd2e', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1719, 'MUJI Style 0.35/0.5mm Black/Blue/Red Gel pen/Ink Pen Office & School Simple Style Kawaii Fineliner Pen Ready Stock', 'MUJI Style 0.35/0.5mm Black/Blue/Red Gel pen/Ink Pen Office & School Simple Style Kawaii Fineliner Pen Ready Stock', 'MUJI Style 0.35/0.5mm Black/Blue/Red Gel pen/Ink Pen Office & School Simple Style Kawaii Fineliner Pen Ready Stock', 16.50, 'https://cf.shopee.com.my/file/0d460ba954d86b2b50378c413ef54b88', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1720, 'Faster  Retractable Ball Pen 0.5mm (BP-CX5N)  Price for 1pcs', 'Faster  Retractable Ball Pen 0.5mm (BP-CX5N)  Price for 1pcs', 'Faster  Retractable Ball Pen 0.5mm (BP-CX5N)  Price for 1pcs', 6.50, 'https://cf.shopee.com.my/file/d25cb659a851bb3c4d7be262ba7a5422', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1721, 'VAPJOY DIY Rebuild Kit VINCI-VM1 Ni80 Mesh 0.3ohm /1.0ohm for VINCI / VINCI X / vinci R', 'VAPJOY DIY Rebuild Kit VINCI-VM1 Ni80 Mesh 0.3ohm /1.0ohm for VINCI / VINCI X / vinci R', 'VAPJOY DIY Rebuild Kit VINCI-VM1 Ni80 Mesh 0.3ohm /1.0ohm for VINCI / VINCI X / vinci R', 129.90, 'https://cf.shopee.com.my/file/793cbdd4c1d916968b5d7cee381ce574', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1722, 'PILOT HRG-10R BG 0.5MM REXGRIP PENCIL', 'PILOT HRG-10R BG 0.5MM REXGRIP PENCIL', 'PILOT HRG-10R BG 0.5MM REXGRIP PENCIL', 29.00, 'https://cf.shopee.com.my/file/49b3258036f1b29282cddad6345a26d8', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1723, '0.45x Super Wide Angle Lens + 12.5x Macro Lens for mobile (Random Pick)', '0.45x Super Wide Angle Lens + 12.5x Macro Lens for mobile (Random Pick)', '0.45x Super Wide Angle Lens + 12.5x Macro Lens for mobile (Random Pick)', 90.00, 'https://cf.shopee.com.my/file/efea556361d9e31cd9569589199b900e', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1724, 'USB 3.0/Type C to 1000 Gigabit Network RJ45 LAN Wired Adapter Compatible for PC & Laptop', 'USB 3.0/Type C to 1000 Gigabit Network RJ45 LAN Wired Adapter Compatible for PC & Laptop', 'USB 3.0/Type C to 1000 Gigabit Network RJ45 LAN Wired Adapter Compatible for PC & Laptop', 250.00, 'https://cf.shopee.com.my/file/6e7cbb4e308d2e190e978e5e1de2a8fd', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1727, 'Engine Air Filter Perodua Axia 1.0/Bezza 1.0 (2016-2021) 17801-BZ140', 'Engine Air Filter Perodua Axia 1.0/Bezza 1.0 (2016-2021) 17801-BZ140', 'Engine Air Filter Perodua Axia 1.0/Bezza 1.0 (2016-2021) 17801-BZ140', 98.00, 'https://cf.shopee.com.my/file/f58b6b2a2b91cd1270a705c5282955ff', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1728, 'Japan Pilot Hi-Tec-C Coleto Multi Color Gel Pen Refill 0.5mm', 'Japan Pilot Hi-Tec-C Coleto Multi Color Gel Pen Refill 0.5mm', 'Japan Pilot Hi-Tec-C Coleto Multi Color Gel Pen Refill 0.5mm', 35.00, 'https://cf.shopee.com.my/file/1b69f79d44a1b13704a8f107aacd2f3c', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1729, 'Invasion Aurora LED 120mm RGB Case Fan | MB2.0 ARGB 4in1 Sets (NEW)', 'Invasion Aurora LED 120mm RGB Case Fan | MB2.0 ARGB 4in1 Sets (NEW)', 'Invasion Aurora LED 120mm RGB Case Fan | MB2.0 ARGB 4in1 Sets (NEW)', 150.00, 'https://cf.shopee.com.my/file/32161cdcaa46143c70dd7b86b4607221', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1730, '1pcs - 0.5mm / 1mm / 2mm A4 magnetic sheet with self adhesive / A4 magnet sheet', '1pcs - 0.5mm / 1mm / 2mm A4 magnetic sheet with self adhesive / A4 magnet sheet', '1pcs - 0.5mm / 1mm / 2mm A4 magnetic sheet with self adhesive / A4 magnet sheet', 35.00, 'https://cf.shopee.com.my/file/116b16dbb2b47642605c3c71f7dae2db', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1732, 'HT Socket Cap Screw - M3 x 4mm ~ 20mm (Coarse Thread Pitch 0.5mm) (High Tensile Grade 12.9 Allen Cap Bolt)', 'HT Socket Cap Screw - M3 x 4mm ~ 20mm (Coarse Thread Pitch 0.5mm) (High Tensile Grade 12.9 Allen Cap Bolt)', 'HT Socket Cap Screw - M3 x 4mm ~ 20mm (Coarse Thread Pitch 0.5mm) (High Tensile Grade 12.9 Allen Cap Bolt)', 2.00, 'https://cf.shopee.com.my/file/bf520e1021831bfd43eab6b9bf96a18e', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1733, '1080P/4K USB 2.0/3.0 HDMI Audio Video Capture Card Game Recording Box for Computer Youtube OBS Live Streaming', '1080P/4K USB 2.0/3.0 HDMI Audio Video Capture Card Game Recording Box for Computer Youtube OBS Live Streaming', '1080P/4K USB 2.0/3.0 HDMI Audio Video Capture Card Game Recording Box for Computer Youtube OBS Live Streaming', 238.80, 'https://cf.shopee.com.my/file/6d0a15d4c5aac2c482c5cc84ca0daeee', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1735, 'Laser Luminous Minnow Hard Bait 7.3g/90mm Suspend Sea Fishing Bait With 8# Hook Depth 0.8-1.5m For Lake River With Box', 'Laser Luminous Minnow Hard Bait 7.3g/90mm Suspend Sea Fishing Bait With 8# Hook Depth 0.8-1.5m For Lake River With Box', 'Laser Luminous Minnow Hard Bait 7.3g/90mm Suspend Sea Fishing Bait With 8# Hook Depth 0.8-1.5m For Lake River With Box', 26.00, 'https://cf.shopee.com.my/file/24186a3e2e07d77e6678e44a31c31afa', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1738, 'Jujutsu Kaisen Manga Chapter 0-150 (Ongoing)', 'Jujutsu Kaisen Manga Chapter 0-150 (Ongoing)', 'Jujutsu Kaisen Manga Chapter 0-150 (Ongoing)', 19.00, 'https://cf.shopee.com.my/file/e74b85ded4cc1e995d331c5c0cc429b2', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1739, 'Artline 700 Permanent Marker 0.7mm (Per Piece) -Black/ Blue/ Red', 'Artline 700 Permanent Marker 0.7mm (Per Piece) -Black/ Blue/ Red', 'Artline 700 Permanent Marker 0.7mm (Per Piece) -Black/ Blue/ Red', 22.50, 'https://cf.shopee.com.my/file/bb72521988ad10400ec0f929ff087843', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1740, 'Vention IBJ CAT6 Ethernet Cable 0.5m/1m/1.5m/2m/3m/5m/8m/10m/15m RJ45 CAT 6 Flat Internet Network LAN Patch Cord', 'Vention IBJ CAT6 Ethernet Cable 0.5m/1m/1.5m/2m/3m/5m/8m/10m/15m RJ45 CAT 6 Flat Internet Network LAN Patch Cord', 'Vention IBJ CAT6 Ethernet Cable 0.5m/1m/1.5m/2m/3m/5m/8m/10m/15m RJ45 CAT 6 Flat Internet Network LAN Patch Cord', 54.00, 'https://cf.shopee.com.my/file/36b4a97af8efa67f6934f5060966879d', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1741, '4 Colors Gel Pens 0.5mm fine point Black,red,deep blue,crystal blue ink color Refillable daily writing pens with clip', '4 Colors Gel Pens 0.5mm fine point Black,red,deep blue,crystal blue ink color Refillable daily writing pens with clip', '4 Colors Gel Pens 0.5mm fine point Black,red,deep blue,crystal blue ink color Refillable daily writing pens with clip', 6.50, 'https://cf.shopee.com.my/file/12a8f2ed729c20544cade8fd95cdabac', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1742, '0.3M High Speed HDMI Male to 2 x Y Splitter Female Cable', '0.3M High Speed HDMI Male to 2 x Y Splitter Female Cable', '0.3M High Speed HDMI Male to 2 x Y Splitter Female Cable', 58.80, 'https://cf.shopee.com.my/file/5d7751772dcd28f5c4a204247de9765f', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1743, '1pc Cactus Gel Pen 0.5mm Cute Rainbow Creative Gel Pen Black Ink Office School Door Gift', '1pc Cactus Gel Pen 0.5mm Cute Rainbow Creative Gel Pen Black Ink Office School Door Gift', '1pc Cactus Gel Pen 0.5mm Cute Rainbow Creative Gel Pen Black Ink Office School Door Gift', 5.90, 'https://cf.shopee.com.my/file/2f410163c74bfb0ba8b1a397069be9ce', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1744, 'Y125Z BLOCK GASKET KERTAS 0.3MM 0.5MM 0.8MM 1MM HARGA (1PCS) ASHUKA', 'Y125Z BLOCK GASKET KERTAS 0.3MM 0.5MM 0.8MM 1MM HARGA (1PCS) ASHUKA', 'Y125Z BLOCK GASKET KERTAS 0.3MM 0.5MM 0.8MM 1MM HARGA (1PCS) ASHUKA', 15.00, 'https://cf.shopee.com.my/file/fc0d9074b26f2d3b1faf625646bc2772', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1745, '1.0/1.5/2.0/2.5mm Multicolor Aluminum Wire 18 Gauge Beading Craft Wire about 3-10meter', '1.0/1.5/2.0/2.5mm Multicolor Aluminum Wire 18 Gauge Beading Craft Wire about 3-10meter', '1.0/1.5/2.0/2.5mm Multicolor Aluminum Wire 18 Gauge Beading Craft Wire about 3-10meter', 19.60, 'https://cf.shopee.com.my/file/3e0a521b39092a5b2ed4c90006855bde', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1746, 'Vention USB3.0 Extension Cable Male to Female USB2.0 Extension Wire Super Speed 3.0 USB Extender Data Sync Cable for Computer PCSmart TV PS4 Xbox One SSD', 'Vention USB3.0 Extension Cable Male to Female USB2.0 Extension Wire Super Speed 3.0 USB Extender Data Sync Cable for Computer PCSmart TV PS4 Xbox One SSD', 'Vention USB3.0 Extension Cable Male to Female USB2.0 Extension Wire Super Speed 3.0 USB Extender Data Sync Cable for Computer PCSmart TV PS4 Xbox One SSD', 29.50, 'https://cf.shopee.com.my/file/27d4353f354344f23a1546bd656b5a59', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1748, '1.6m High 0.4mm thickness kids Boxing Sandbag Inflatable Punching Bag Fitness Sport Kick Martial Training Inflatable Column Tumbler with air pump', '1.6m High 0.4mm thickness kids Boxing Sandbag Inflatable Punching Bag Fitness Sport Kick Martial Training Inflatable Column Tumbler with air pump', '1.6m High 0.4mm thickness kids Boxing Sandbag Inflatable Punching Bag Fitness Sport Kick Martial Training Inflatable Column Tumbler with air pump', 498.00, 'https://cf.shopee.com.my/file/91d1fbb7f1dddcbb2cc4f962db81b5d2', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1749, 'Cermin Mata Rabun Jauh -1.0 to -6.0 Korea Fashion Transparent Finished Frame near-sighted Eyeglasses', 'Cermin Mata Rabun Jauh -1.0 to -6.0 Korea Fashion Transparent Finished Frame near-sighted Eyeglasses', 'Cermin Mata Rabun Jauh -1.0 to -6.0 Korea Fashion Transparent Finished Frame near-sighted Eyeglasses', 32.50, 'https://cf.shopee.com.my/file/74bfac7500185b9fe4240d7447fc3846', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1750, '0.5KG NISSAN HITARY 228 FILLING PUTTY (GREY) / SIMEN HALUS KERETA / MERCURY', '0.5KG NISSAN HITARY 228 FILLING PUTTY (GREY) / SIMEN HALUS KERETA / MERCURY', '0.5KG NISSAN HITARY 228 FILLING PUTTY (GREY) / SIMEN HALUS KERETA / MERCURY', 110.00, 'https://cf.shopee.com.my/file/7c4501c7fbdbed716d504be8cd171966', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1751, '16inch Number Balloon Gold Silver Blue Pink Party Decoration Number Aluminum Foil Balloon 0-9 Party Needs', '16inch Number Balloon Gold Silver Blue Pink Party Decoration Number Aluminum Foil Balloon 0-9 Party Needs', '16inch Number Balloon Gold Silver Blue Pink Party Decoration Number Aluminum Foil Balloon 0-9 Party Needs', 4.90, 'https://cf.shopee.com.my/file/26945417e8baff3696bc39ec693e3f77', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1752, '16INCH NUMBER BALLOON 0 TO 9 GOLD & SILVER COLOR (READY STOCK)', '16INCH NUMBER BALLOON 0 TO 9 GOLD & SILVER COLOR (READY STOCK)', '16INCH NUMBER BALLOON 0 TO 9 GOLD & SILVER COLOR (READY STOCK)', 6.90, 'https://cf.shopee.com.my/file/f758c7209a3a5cda8f27958eb0bcdc64', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1753, 'Faber-Castell Grip X Ball Pen 0.5 /0.7 (Buy 3 Free 1) Faber Castell Grip X5 X7 0.5mm 0.7mm Value Sets', 'Faber-Castell Grip X Ball Pen 0.5 /0.7 (Buy 3 Free 1) Faber Castell Grip X5 X7 0.5mm 0.7mm Value Sets', 'Faber-Castell Grip X Ball Pen 0.5 /0.7 (Buy 3 Free 1) Faber Castell Grip X5 X7 0.5mm 0.7mm Value Sets', 49.90, 'https://cf.shopee.com.my/file/8c232c5884733ec481fc062cfc1856a6', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1754, 'Myflavor PASTEL GEL FOOD COLOURING 0.88oz (25G)', 'Myflavor PASTEL GEL FOOD COLOURING 0.88oz (25G)', 'Myflavor PASTEL GEL FOOD COLOURING 0.88oz (25G)', 73.00, 'https://cf.shopee.com.my/file/790319f573010b034ce80e967e8b4c8d', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1755, '(EXP 08.2022) ALCON SYSTANE HYDRATION UD LUBRICANT EYE DROPS 0.7ML X 30 VIALS', '(EXP 08.2022) ALCON SYSTANE HYDRATION UD LUBRICANT EYE DROPS 0.7ML X 30 VIALS', '(EXP 08.2022) ALCON SYSTANE HYDRATION UD LUBRICANT EYE DROPS 0.7ML X 30 VIALS', 436.00, 'https://cf.shopee.com.my/file/7fdf6448589d1ee8dab93e646643d4ec', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1757, 'Faber-Castell RX Gel Pen - 0.5mm / 0.7mm', 'Faber-Castell RX Gel Pen - 0.5mm / 0.7mm', 'Faber-Castell RX Gel Pen - 0.5mm / 0.7mm', 16.00, 'https://cf.shopee.com.my/file/0c487f1b31bffb766537d10afa405a50', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1758, 'Pilot PLCR 0.7mm Color Eno Pencil Leads', 'Pilot PLCR 0.7mm Color Eno Pencil Leads', 'Pilot PLCR 0.7mm Color Eno Pencil Leads', 32.00, 'https://cf.shopee.com.my/file/ee884797bd554b6e590de2f1ec203cb9', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1759, 'Pilot Wingel 0.5mm Color Gel Pen', 'Pilot Wingel 0.5mm Color Gel Pen', 'Pilot Wingel 0.5mm Color Gel Pen', 24.00, 'https://cf.shopee.com.my/file/88bf9d74ea8f6ed580d9d9bb9f69928f', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1760, 'QC3.0 Dual USB Car Charger Quickly Charger 12-24V Socket Power Outlet with Touch Switch for Vehicle Marine Boat Motorcycle Truck', 'QC3.0 Dual USB Car Charger Quickly Charger 12-24V Socket Power Outlet with Touch Switch for Vehicle Marine Boat Motorcycle Truck', 'QC3.0 Dual USB Car Charger Quickly Charger 12-24V Socket Power Outlet with Touch Switch for Vehicle Marine Boat Motorcycle Truck', 209.90, 'https://cf.shopee.com.my/file/d49b136c4ffe07655df743f7c4dec859', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1761, 'Pressure Sprayer Pressure Spray Bottle (0.8/2/3 Liters)/ Botol Penyembur Tekanan Botol Spray', 'Pressure Sprayer Pressure Spray Bottle (0.8/2/3 Liters)/ Botol Penyembur Tekanan Botol Spray', 'Pressure Sprayer Pressure Spray Bottle (0.8/2/3 Liters)/ Botol Penyembur Tekanan Botol Spray', 89.90, 'https://cf.shopee.com.my/file/5cc90f82aef825a8aefa4355573c3238', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1762, '(Loose Pack) Philips Avent Peach Ultra Soft Air Orthodontic Silicone Soother / Pacifier (0-6M)- 1 Pcs', '(Loose Pack) Philips Avent Peach Ultra Soft Air Orthodontic Silicone Soother / Pacifier (0-6M)- 1 Pcs', '(Loose Pack) Philips Avent Peach Ultra Soft Air Orthodontic Silicone Soother / Pacifier (0-6M)- 1 Pcs', 129.00, 'https://cf.shopee.com.my/file/28eb1c60b62fbb546644583a6f086498', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1763, '0-9Crown Acrylic Number Cake Decoration Happy Birthday Number Top Hat Decoration', '0-9Crown Acrylic Number Cake Decoration Happy Birthday Number Top Hat Decoration', '0-9Crown Acrylic Number Cake Decoration Happy Birthday Number Top Hat Decoration', 8.40, 'https://cf.shopee.com.my/file/328bc24dbc9d17b56efbd74a34d26999', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1764, '1 Piece 0.1-0.8mm Low Pressure Garden Sprayer Misting Nozzle Slip Lock Fog Cooling Nozzles', '1 Piece 0.1-0.8mm Low Pressure Garden Sprayer Misting Nozzle Slip Lock Fog Cooling Nozzles', '1 Piece 0.1-0.8mm Low Pressure Garden Sprayer Misting Nozzle Slip Lock Fog Cooling Nozzles', 17.90, 'https://cf.shopee.com.my/file/793bf63744e03fedc7b1befed840bca5', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1766, 'Polyester Elastic (1roll) | Getah Pinggang | 0.5inch, 0.75inch, 1inch', 'Polyester Elastic (1roll) | Getah Pinggang | 0.5inch, 0.75inch, 1inch', 'Polyester Elastic (1roll) | Getah Pinggang | 0.5inch, 0.75inch, 1inch', 75.00, 'https://cf.shopee.com.my/file/cdb70741639c49260aa9716dc20f9a5b', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1767, '[NANO MIST GUN SPRAYER] CHEMIZ 5L Benzalkonium Chloride (BKC) 0.1% v/v Solution  Water-based Disinfectant Sanitizer', '[NANO MIST GUN SPRAYER] CHEMIZ 5L Benzalkonium Chloride (BKC) 0.1% v/v Solution  Water-based Disinfectant Sanitizer', '[NANO MIST GUN SPRAYER] CHEMIZ 5L Benzalkonium Chloride (BKC) 0.1% v/v Solution  Water-based Disinfectant Sanitizer', 290.00, 'https://cf.shopee.com.my/file/2770b526a5688182a70ea10db14f4207', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1768, 'Kavkas Cartoon Fashion Infant One Piece Clothes Winter Romper 0-12M', 'Kavkas Cartoon Fashion Infant One Piece Clothes Winter Romper 0-12M', 'Kavkas Cartoon Fashion Infant One Piece Clothes Winter Romper 0-12M', 197.10, 'https://cf.shopee.com.my/file/e9201dadc2324329080eb771548ed25b', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1771, 'Dull Satin Valentino Soluna Bidang 45 (0.5m/unit) Part 1/4', 'Dull Satin Valentino Soluna Bidang 45 (0.5m/unit) Part 1/4', 'Dull Satin Valentino Soluna Bidang 45 (0.5m/unit) Part 1/4', 39.40, 'https://cf.shopee.com.my/file/aad715329f2e61b151db8dccad8d4700', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1772, 'Baby Leggings Infant Newborn Girls Boys Long Solid Trousers Tiny Cotton Soft Casual Leggings PP Pant 0-30 Months', 'Baby Leggings Infant Newborn Girls Boys Long Solid Trousers Tiny Cotton Soft Casual Leggings PP Pant 0-30 Months', 'Baby Leggings Infant Newborn Girls Boys Long Solid Trousers Tiny Cotton Soft Casual Leggings PP Pant 0-30 Months', 95.00, 'https://cf.shopee.com.my/file/5b7fbae8356ebff836f2df740feb6404', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1773, '0-1 Years Newborn Flower Shoes Footwear  Baby Girls Anti-skid Prewalker', '0-1 Years Newborn Flower Shoes Footwear  Baby Girls Anti-skid Prewalker', '0-1 Years Newborn Flower Shoes Footwear  Baby Girls Anti-skid Prewalker', 88.80, 'https://cf.shopee.com.my/file/a705fb9589b9d156a4e9f8ffaea2cb54', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1774, '[EXP8/0/2022]MAGGI Cream of Mushroom Soup - 1kg', '[EXP8/0/2022]MAGGI Cream of Mushroom Soup - 1kg', '[EXP8/0/2022]MAGGI Cream of Mushroom Soup - 1kg', 49.80, 'https://cf.shopee.com.my/file/8b1ca95fec9d944b5c738ba92bb269ec', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1775, '4 Pairs Baby New Born Anti Scratching Gloves Newborn Face Protection Cotton Scratch Mittens 0-6 Months', '4 Pairs Baby New Born Anti Scratching Gloves Newborn Face Protection Cotton Scratch Mittens 0-6 Months', '4 Pairs Baby New Born Anti Scratching Gloves Newborn Face Protection Cotton Scratch Mittens 0-6 Months', 79.90, 'https://cf.shopee.com.my/file/ae34aa71a9fba28830caac42356226d9', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1776, 'LOOSE CUT Speaker Wire 30/0.18 / Speaker Cable 30/0.18 / 2 Core Speaker Wire 30/0.18 / 30/0.18 x 2Core Speaker Wire', 'LOOSE CUT Speaker Wire 30/0.18 / Speaker Cable 30/0.18 / 2 Core Speaker Wire 30/0.18 / 30/0.18 x 2Core Speaker Wire', 'LOOSE CUT Speaker Wire 30/0.18 / Speaker Cable 30/0.18 / 2 Core Speaker Wire 30/0.18 / 30/0.18 x 2Core Speaker Wire', 15.90, 'https://cf.shopee.com.my/file/8a128aba47318dc79713930c39f4a962', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1778, 'Pilot Super Grip Mechanical Pencil 0.5mm / 0.7mm ***READY STOCK***', 'Pilot Super Grip Mechanical Pencil 0.5mm / 0.7mm ***READY STOCK***', 'Pilot Super Grip Mechanical Pencil 0.5mm / 0.7mm ***READY STOCK***', 35.90, 'https://cf.shopee.com.my/file/d8a1b2ff11a272e04d7e2f7662ab72b4', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1780, 'Occ DotAIO Dotmod 0.3ohm , 0.7ohm(v2) & 1.2ohm 1box(5pcs) Original !!', 'Occ DotAIO Dotmod 0.3ohm , 0.7ohm(v2) & 1.2ohm 1box(5pcs) Original !!', 'Occ DotAIO Dotmod 0.3ohm , 0.7ohm(v2) & 1.2ohm 1box(5pcs) Original !!', 539.90, 'https://cf.shopee.com.my/file/9ad851b8d44781f3d78369cf0dab37d6', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1781, '[Ready Stock] Cute Cartoon Kids Sleeping Pillows 0-10 Years Cotton Infant Baby Prevent Flat Head Pillow Kids', '[Ready Stock] Cute Cartoon Kids Sleeping Pillows 0-10 Years Cotton Infant Baby Prevent Flat Head Pillow Kids', '[Ready Stock] Cute Cartoon Kids Sleeping Pillows 0-10 Years Cotton Infant Baby Prevent Flat Head Pillow Kids', 96.30, 'https://cf.shopee.com.my/file/b09784b643b9fdc18b3b0b3fe12abe4c', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1782, 'ORICO 2139U3  2577U3 2520U3 TRANSPARENT EXTERNAL HARDDISK CASE 2.5\" USB3.0 HDD Enclosure. APACER AS340 AS350 A400 SSD', 'ORICO 2139U3  2577U3 2520U3 TRANSPARENT EXTERNAL HARDDISK CASE 2.5\" USB3.0 HDD Enclosure. APACER AS340 AS350 A400 SSD', 'ORICO 2139U3  2577U3 2520U3 TRANSPARENT EXTERNAL HARDDISK CASE 2.5\" USB3.0 HDD Enclosure. APACER AS340 AS350 A400 SSD', 239.90, 'https://cf.shopee.com.my/file/86ed2fb6e5c81426ee756d1eaa8df7bd', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1783, 'Ready Stock 0-5 years old Kids Baby Pyjamas Sleepsuit Baju Tidur Nightwear Boy Girl Children Cartoon', 'Ready Stock 0-5 years old Kids Baby Pyjamas Sleepsuit Baju Tidur Nightwear Boy Girl Children Cartoon', 'Ready Stock 0-5 years old Kids Baby Pyjamas Sleepsuit Baju Tidur Nightwear Boy Girl Children Cartoon', 85.50, 'https://cf.shopee.com.my/file/2379a37a0e2f642808b7b3abef574162', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1784, 'Girl fashion suit Pakaian bayi perempuan berumur 0-4 tahun skirt gadis corak cinta T-shirt + skirt kotak-kotak 2pcs pakaian bayi', 'Girl fashion suit Pakaian bayi perempuan berumur 0-4 tahun skirt gadis corak cinta T-shirt + skirt kotak-kotak 2pcs pakaian bayi', 'Girl fashion suit Pakaian bayi perempuan berumur 0-4 tahun skirt gadis corak cinta T-shirt + skirt kotak-kotak 2pcs pakaian bayi', 138.00, 'https://cf.shopee.com.my/file/18fb43fd468e79d5286d5df5cdf1bc45', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1785, 'Fishing Swivel Big Cat Swivel 4410B #1 #2 #4 #6 #8 #10 #1/0 #2/0 Fishing', 'Fishing Swivel Big Cat Swivel 4410B #1 #2 #4 #6 #8 #10 #1/0 #2/0 Fishing', 'Fishing Swivel Big Cat Swivel 4410B #1 #2 #4 #6 #8 #10 #1/0 #2/0 Fishing', 18.00, 'https://cf.shopee.com.my/file/fcc4439fcf95600c385dd194de616243', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1786, '(Pre-install 10k Channels/Movies) NEW Tanix TX6 TX6S Android 10.0 TV Box 4GB RAM 64GB ROM Allwinner H616 Unroot Device', '(Pre-install 10k Channels/Movies) NEW Tanix TX6 TX6S Android 10.0 TV Box 4GB RAM 64GB ROM Allwinner H616 Unroot Device', '(Pre-install 10k Channels/Movies) NEW Tanix TX6 TX6S Android 10.0 TV Box 4GB RAM 64GB ROM Allwinner H616 Unroot Device', 1150.00, 'https://cf.shopee.com.my/file/332947315d5d3dbbc3cd77f20c04daea', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1790, 'Pilot Progrex Mechanical Pencil  0.9mm / 0.5mm / 0.7mm H125/127/129', 'Pilot Progrex Mechanical Pencil  0.9mm / 0.5mm / 0.7mm H125/127/129', 'Pilot Progrex Mechanical Pencil  0.9mm / 0.5mm / 0.7mm H125/127/129', 22.50, 'https://cf.shopee.com.my/file/073684bba800e0dc96902adf017c0d52', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1791, 'Panasonic KDK Ceiling Fan Condenser Capacitor Kipas Siling Kapasitor ( 0.82uf / 0.1uf / 1.8uf / 2.4uf / 5uf ) Capasitor', 'Panasonic KDK Ceiling Fan Condenser Capacitor Kipas Siling Kapasitor ( 0.82uf / 0.1uf / 1.8uf / 2.4uf / 5uf ) Capasitor', 'Panasonic KDK Ceiling Fan Condenser Capacitor Kipas Siling Kapasitor ( 0.82uf / 0.1uf / 1.8uf / 2.4uf / 5uf ) Capasitor', 17.50, 'https://cf.shopee.com.my/file/1ee127c4a212a346ddac10b3a202ee2a', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1792, 'NUK Premium Choice Wide Neck SILICONE Teat S1 0-6m / S2 6-18M S / M / L size  - 2PCS', 'NUK Premium Choice Wide Neck SILICONE Teat S1 0-6m / S2 6-18M S / M / L size  - 2PCS', 'NUK Premium Choice Wide Neck SILICONE Teat S1 0-6m / S2 6-18M S / M / L size  - 2PCS', 227.70, 'https://cf.shopee.com.my/file/54d718e712a51bd137992254a8f29719', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1794, 'Cute Newborn Baby Girls Leopard Romper+ Headband Outfit Sets Clothes 2Pcs 0-24M', 'Cute Newborn Baby Girls Leopard Romper+ Headband Outfit Sets Clothes 2Pcs 0-24M', 'Cute Newborn Baby Girls Leopard Romper+ Headband Outfit Sets Clothes 2Pcs 0-24M', 127.50, 'https://cf.shopee.com.my/file/661ccef35909d659862a802ec4fbfb27', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1795, 'MYDIYHOMEDEPOT - Maimegn Electric Jig Saw Machine 550w Cutter Machine Bevel Cut 0-45 Degree FOC 10pcs Jigsaw Blade', 'MYDIYHOMEDEPOT - Maimegn Electric Jig Saw Machine 550w Cutter Machine Bevel Cut 0-45 Degree FOC 10pcs Jigsaw Blade', 'MYDIYHOMEDEPOT - Maimegn Electric Jig Saw Machine 550w Cutter Machine Bevel Cut 0-45 Degree FOC 10pcs Jigsaw Blade', 598.80, 'https://cf.shopee.com.my/file/243b97b172fce28afb95fdc1a2024160', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1796, 'Uts Super HeavyDuty J-Pike/Zero Assist Hook 1/0;2/0 *Custom HandMade Jigging Hook', 'Uts Super HeavyDuty J-Pike/Zero Assist Hook 1/0;2/0 *Custom HandMade Jigging Hook', 'Uts Super HeavyDuty J-Pike/Zero Assist Hook 1/0;2/0 *Custom HandMade Jigging Hook', 150.00, 'https://cf.shopee.com.my/file/13bd4ef905537b5e1092ee6bf7664bb4', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1797, '0-4y Baby boy summer new Lapel fashion tie short sleeve T-shirt Polo + handsome shorts 2-piece set', '0-4y Baby boy summer new Lapel fashion tie short sleeve T-shirt Polo + handsome shorts 2-piece set', '0-4y Baby boy summer new Lapel fashion tie short sleeve T-shirt Polo + handsome shorts 2-piece set', 159.80, 'https://cf.shopee.com.my/file/556739bdccaaad3cbff0d6dbeede10c7', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1799, 'PROMOSI Jaring 0.20mm x 1.5\" ~> 5\" (40mm-127mm) x 50md x 100y (PUKAT SAHAJA)', 'PROMOSI Jaring 0.20mm x 1.5\" ~> 5\" (40mm-127mm) x 50md x 100y (PUKAT SAHAJA)', 'PROMOSI Jaring 0.20mm x 1.5\" ~> 5\" (40mm-127mm) x 50md x 100y (PUKAT SAHAJA)', 229.00, 'https://cf.shopee.com.my/file/e56fa0808d5f0a15afc5e5fc6e1c51e0', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1800, '2888VF 1680N.M 1/2 Torque Impact Wrench Brushless Cordless Electric Wrench Drill Tool 0-4000 RPM 12.5MM', '2888VF 1680N.M 1/2 Torque Impact Wrench Brushless Cordless Electric Wrench Drill Tool 0-4000 RPM 12.5MM', '2888VF 1680N.M 1/2 Torque Impact Wrench Brushless Cordless Electric Wrench Drill Tool 0-4000 RPM 12.5MM', 1800.00, 'https://cf.shopee.com.my/file/e77add94b46c09d1aa3d4ca0a8df2c7f', 1627909676, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1801, 'KAXOE 3A Fast Charging Charger Cable Liquid Silicone Cable with Led Light Android Micro USB / Type-C Charging Cord iPhone Cable(0.25M)', 'KAXOE 3A Fast Charging Charger Cable Liquid Silicone Cable with Led Light Android Micro USB / Type-C Charging Cord iPhone Cable(0.25M)', 'KAXOE 3A Fast Charging Charger Cable Liquid Silicone Cable with Led Light Android Micro USB / Type-C Charging Cord iPhone Cable(0.25M)', 42.00, 'https://cf.shopee.com.my/file/be3443e516c245b2c7b09f79448c5242', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1802, 'Zebra Sarasa Clip Gel Pen 0.5MM JJ15', 'Zebra Sarasa Clip Gel Pen 0.5MM JJ15', 'Zebra Sarasa Clip Gel Pen 0.5MM JJ15', 10.00, 'https://cf.shopee.com.my/file/258055838f7807a4fb5ab95e40763a9d', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1803, 'MUJI Style 0.5mm Gel Ball Point Pen Black Ink Press Knock Type Water Based Student School Office Supplies Stationery', 'MUJI Style 0.5mm Gel Ball Point Pen Black Ink Press Knock Type Water Based Student School Office Supplies Stationery', 'MUJI Style 0.5mm Gel Ball Point Pen Black Ink Press Knock Type Water Based Student School Office Supplies Stationery', 9.90, 'https://cf.shopee.com.my/file/9ee2fdb39451201927751a9fd71773a7', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1805, 'ReadyStock - Android Cable 1Meter Mirco Usb Faster charging [ A2.4 - A3.0 ]', 'ReadyStock - Android Cable 1Meter Mirco Usb Faster charging [ A2.4 - A3.0 ]', 'ReadyStock - Android Cable 1Meter Mirco Usb Faster charging [ A2.4 - A3.0 ]', 10.00, 'https://cf.shopee.com.my/file/89f9bd2f0ee1ca60c7aef68446114e7e', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1806, 'MINI USB ADAPTER WIRELESS BLUETOOTH 4.0 DONGLE CSR 4.0. PLUS & PLAY ONLY.READY STOCK', 'MINI USB ADAPTER WIRELESS BLUETOOTH 4.0 DONGLE CSR 4.0. PLUS & PLAY ONLY.READY STOCK', 'MINI USB ADAPTER WIRELESS BLUETOOTH 4.0 DONGLE CSR 4.0. PLUS & PLAY ONLY.READY STOCK', 99.00, 'https://cf.shopee.com.my/file/16c11878d2a04ccccac93f8f224f4f63', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1807, 'Faber Castell K-One Gel Pen Retractable 0.5mm - (10s/BOX)', 'Faber Castell K-One Gel Pen Retractable 0.5mm - (10s/BOX)', 'Faber Castell K-One Gel Pen Retractable 0.5mm - (10s/BOX)', 144.00, 'https://cf.shopee.com.my/file/48a8afe1926cd3c17931d88c920b6ac7', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1808, 'NEVOKS FEELIN KIT 100% AUTHENTIC  and Occ NEVOKS FEELIN 0.6/1.0 NEVOKS FEELIN EMPTY CARTRIDGE NEON COLOUR LIMITED', 'NEVOKS FEELIN KIT 100% AUTHENTIC  and Occ NEVOKS FEELIN 0.6/1.0 NEVOKS FEELIN EMPTY CARTRIDGE NEON COLOUR LIMITED', 'NEVOKS FEELIN KIT 100% AUTHENTIC  and Occ NEVOKS FEELIN 0.6/1.0 NEVOKS FEELIN EMPTY CARTRIDGE NEON COLOUR LIMITED', 80.00, 'https://cf.shopee.com.my/file/8443adc0b872f3028a6cd147339bb6b4', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1809, 'CALIBURNG OCC KOKO PRIME OCC ORIGINAL UWELL CALIBURN G PRIME KOKO CARTRIDGE 0.8ohm 1.0ohm 4pcs/ pack', 'CALIBURNG OCC KOKO PRIME OCC ORIGINAL UWELL CALIBURN G PRIME KOKO CARTRIDGE 0.8ohm 1.0ohm 4pcs/ pack', 'CALIBURNG OCC KOKO PRIME OCC ORIGINAL UWELL CALIBURN G PRIME KOKO CARTRIDGE 0.8ohm 1.0ohm 4pcs/ pack', 155.00, 'https://cf.shopee.com.my/file/6b620821e572582b29b34b74758e5006', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1810, 'Plastik UV Greenhouse Film 24FT WIDTH LEBAR 0.15MM (150 MICRON) & 0.20MM (200 MICRON) Rumah Pelindung Hujan (RPH)', 'Plastik UV Greenhouse Film 24FT WIDTH LEBAR 0.15MM (150 MICRON) & 0.20MM (200 MICRON) Rumah Pelindung Hujan (RPH)', 'Plastik UV Greenhouse Film 24FT WIDTH LEBAR 0.15MM (150 MICRON) & 0.20MM (200 MICRON) Rumah Pelindung Hujan (RPH)', 150.00, 'https://cf.shopee.com.my/file/d7e273aa8cf988fd6a21461180c1fc0e', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1813, 'BKWAHLE QC3.0 Quick Charge 3A LED Display 3 Ports USB Phone Charger Fast Charging Adapter For Android Micro For iPhone US Plug use', 'BKWAHLE QC3.0 Quick Charge 3A LED Display 3 Ports USB Phone Charger Fast Charging Adapter For Android Micro For iPhone US Plug use', 'BKWAHLE QC3.0 Quick Charge 3A LED Display 3 Ports USB Phone Charger Fast Charging Adapter For Android Micro For iPhone US Plug use', 84.50, 'https://cf.shopee.com.my/file/f78d4a01d00aa36d1ff38e7294dd16a4', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1815, '[PC][Google Drive] Forza Horizon 4 Ultimate Edition (1.465.282.0 + All DLCs) ShayRepack', '[PC][Google Drive] Forza Horizon 4 Ultimate Edition (1.465.282.0 + All DLCs) ShayRepack', '[PC][Google Drive] Forza Horizon 4 Ultimate Edition (1.465.282.0 + All DLCs) ShayRepack', 24.90, 'https://cf.shopee.com.my/file/e75b8ab26176b280379e1964e744d9a6', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1816, 'ACER NITRO XV270 P / XV270P 27\" FHD IPS 165HZ 0.5MS FREESYNC HDR10 GAMING MONITOR', 'ACER NITRO XV270 P / XV270P 27\" FHD IPS 165HZ 0.5MS FREESYNC HDR10 GAMING MONITOR', 'ACER NITRO XV270 P / XV270P 27\" FHD IPS 165HZ 0.5MS FREESYNC HDR10 GAMING MONITOR', 8790.00, 'https://cf.shopee.com.my/file/dbdc1143b534ef5b37c4c24c0e949c81', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1817, 'Benang Kait Lace Cotton 0.8mm 50gm. Lace cotton crochet knitting yarn.', 'Benang Kait Lace Cotton 0.8mm 50gm. Lace cotton crochet knitting yarn.', 'Benang Kait Lace Cotton 0.8mm 50gm. Lace cotton crochet knitting yarn.', 45.00, 'https://cf.shopee.com.my/file/2cb6693050405b042bcc1f11c8349b91', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1819, 'SMOK RPM REPLACEMENT OCC COIL  0.4 MESH/ 0.6 TRIPLE/ 0.3 MESH', 'SMOK RPM REPLACEMENT OCC COIL  0.4 MESH/ 0.6 TRIPLE/ 0.3 MESH', 'SMOK RPM REPLACEMENT OCC COIL  0.4 MESH/ 0.6 TRIPLE/ 0.3 MESH', 90.00, 'https://cf.shopee.com.my/file/5ff875c31bbaa90e833e206e7d882d19', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1820, 'Ready Stock Baju Bayi Newborn New Butterfly Clothes Romper Kids One Piece 0-3 Months Pure Cotton Baby Clothing', 'Ready Stock Baju Bayi Newborn New Butterfly Clothes Romper Kids One Piece 0-3 Months Pure Cotton Baby Clothing', 'Ready Stock Baju Bayi Newborn New Butterfly Clothes Romper Kids One Piece 0-3 Months Pure Cotton Baby Clothing', 119.80, 'https://cf.shopee.com.my/file/697415104eb8d72772cec2b9688593aa', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1822, '0.0 to -6.0 Cermin Mata Abun Jauh Korea Style Polygonal Frame Anti-blue light Nearsighted Glasses', '0.0 to -6.0 Cermin Mata Abun Jauh Korea Style Polygonal Frame Anti-blue light Nearsighted Glasses', '0.0 to -6.0 Cermin Mata Abun Jauh Korea Style Polygonal Frame Anti-blue light Nearsighted Glasses', 82.70, 'https://cf.shopee.com.my/file/1c63aa713ce373892f7f198229416be8', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1823, 'PREMIUM QUALITY USB2.0 HUB. 1 TO 4 USB HUB', 'PREMIUM QUALITY USB2.0 HUB. 1 TO 4 USB HUB', 'PREMIUM QUALITY USB2.0 HUB. 1 TO 4 USB HUB', 49.90, 'https://cf.shopee.com.my/file/2704d5791686322ce75aeb0605f1e835', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1824, '0.3M/1M/1.8M USB 2.0 A Male To 5pin Mini USB Cable', '0.3M/1M/1.8M USB 2.0 A Male To 5pin Mini USB Cable', '0.3M/1M/1.8M USB 2.0 A Male To 5pin Mini USB Cable', 60.00, 'https://cf.shopee.com.my/file/523f458d4938c96bc9f67f6df7368609', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1825, '{READY STOCK} Cute rabbit Baby Girl Romper Clothes 0-24M newborn baby boys girls clothes', '{READY STOCK} Cute rabbit Baby Girl Romper Clothes 0-24M newborn baby boys girls clothes', '{READY STOCK} Cute rabbit Baby Girl Romper Clothes 0-24M newborn baby boys girls clothes', 80.00, 'https://cf.shopee.com.my/file/cfae1df8298e9c6566df3ac9de3b9d42', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1826, 'Baby Visual Stimulus Card, Sensory development, Early Years, 0 to 36 months  | Kids Learning Flash Cards | Kad Imbasan', 'Baby Visual Stimulus Card, Sensory development, Early Years, 0 to 36 months  | Kids Learning Flash Cards | Kad Imbasan', 'Baby Visual Stimulus Card, Sensory development, Early Years, 0 to 36 months  | Kids Learning Flash Cards | Kad Imbasan', 59.90, 'https://cf.shopee.com.my/file/ee21f9b7b13a0ed472c5f8e4c182f1b8', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1827, 'Faber Castell 0.5mm True Gel Pen', 'Faber Castell 0.5mm True Gel Pen', 'Faber Castell 0.5mm True Gel Pen', 17.90, 'https://cf.shopee.com.my/file/5da8b8d833d195472255e472fa8ee449', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1828, '50pcs Resistor 0.25W 5% 4.7 - 4.7M Ohm', '50pcs Resistor 0.25W 5% 4.7 - 4.7M Ohm', '50pcs Resistor 0.25W 5% 4.7 - 4.7M Ohm', 10.00, 'https://cf.shopee.com.my/file/9ae63a6c85b099dd69e950d4e142b537', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1829, 'USB3.0 Transparent sata casing 2.5\'\' harddisk and solid state drive SSD similar with ORICO 2139U3 design kingston apacer', 'USB3.0 Transparent sata casing 2.5\'\' harddisk and solid state drive SSD similar with ORICO 2139U3 design kingston apacer', 'USB3.0 Transparent sata casing 2.5\'\' harddisk and solid state drive SSD similar with ORICO 2139U3 design kingston apacer', 299.00, 'https://cf.shopee.com.my/file/5218afc3c170e3f4155fa27947e8d828', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1830, '1pcs 0.5mm Erasable Pen Blue Black Magic Gel Pen Cute Pink Gel Pen Writing School Office Stationery Supplies', '1pcs 0.5mm Erasable Pen Blue Black Magic Gel Pen Cute Pink Gel Pen Writing School Office Stationery Supplies', '1pcs 0.5mm Erasable Pen Blue Black Magic Gel Pen Cute Pink Gel Pen Writing School Office Stationery Supplies', 7.70, 'https://cf.shopee.com.my/file/75d8bd7c68676b77ffe3d94c3b38372f', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1831, 'Faber-Castell RX Gel PEN 0.5/0.7MM 1pcs', 'Faber-Castell RX Gel PEN 0.5/0.7MM 1pcs', 'Faber-Castell RX Gel PEN 0.5/0.7MM 1pcs', 11.50, 'https://cf.shopee.com.my/file/4e0b585ce4dcd9bc1cfc4ca7b7a51167', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1832, 'TWS 12 i7S Inpot Inpots Twin Wireless Stereo Bluetooth V5.0 Handsfree Earphone Earbud Headset Macaron Earbuds', 'TWS 12 i7S Inpot Inpots Twin Wireless Stereo Bluetooth V5.0 Handsfree Earphone Earbud Headset Macaron Earbuds', 'TWS 12 i7S Inpot Inpots Twin Wireless Stereo Bluetooth V5.0 Handsfree Earphone Earbud Headset Macaron Earbuds', 22.90, 'https://cf.shopee.com.my/file/a739b1ef1c4fab0492988743a0b95925', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1833, '1PC Metal Mechanical Pencil 2B Cute Cartoon Simple 0.5/0.7 Automatic Pen Press Pen School Supplies Stationery', '1PC Metal Mechanical Pencil 2B Cute Cartoon Simple 0.5/0.7 Automatic Pen Press Pen School Supplies Stationery', '1PC Metal Mechanical Pencil 2B Cute Cartoon Simple 0.5/0.7 Automatic Pen Press Pen School Supplies Stationery', 9.90, 'https://cf.shopee.com.my/file/1ec4fcf65a75368c7204b62d81aecf36', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1834, 'MIG Welding Wire (0.8mm&1.0mm)1kg Gasless Flux Cored Gas-Less', 'MIG Welding Wire (0.8mm&1.0mm)1kg Gasless Flux Cored Gas-Less', 'MIG Welding Wire (0.8mm&1.0mm)1kg Gasless Flux Cored Gas-Less', 95.00, 'https://cf.shopee.com.my/file/55e4883b68e6f52a7378cca22f38161a', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1835, '1 METER - MEGA 1.5mm (7/0.53mm) PVC Insulated Power Cable Wire /Electrical Kabel PVC Bersalut (SIRIM APPROVED)', '1 METER - MEGA 1.5mm (7/0.53mm) PVC Insulated Power Cable Wire /Electrical Kabel PVC Bersalut (SIRIM APPROVED)', '1 METER - MEGA 1.5mm (7/0.53mm) PVC Insulated Power Cable Wire /Electrical Kabel PVC Bersalut (SIRIM APPROVED)', 11.90, 'https://cf.shopee.com.my/file/2f20fd3a4f8bb9f0e25acb18023a582f', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1837, 'Faster Colourful Ball Pen CX-1076 0.7mm', 'Faster Colourful Ball Pen CX-1076 0.7mm', 'Faster Colourful Ball Pen CX-1076 0.7mm', 5.90, 'https://cf.shopee.com.my/file/3f0cca1c7262be5cf35c396da00e305d', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1839, '(READYSTOCK) 0-3m Baby Gloves Mittens with Velcro Straps', '(READYSTOCK) 0-3m Baby Gloves Mittens with Velcro Straps', '(READYSTOCK) 0-3m Baby Gloves Mittens with Velcro Straps', 69.00, 'https://cf.shopee.com.my/file/25fe45635080e43d5bdedc01be0ad227', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1840, 'Gel Pen Ballpoint Pen Refill Black Red Blue Gel Pen 0.5mm Students Writing Refill School Office Stationery', 'Gel Pen Ballpoint Pen Refill Black Red Blue Gel Pen 0.5mm Students Writing Refill School Office Stationery', 'Gel Pen Ballpoint Pen Refill Black Red Blue Gel Pen 0.5mm Students Writing Refill School Office Stationery', 1.80, 'https://cf.shopee.com.my/file/fa2eb50d4af756c5ff92068cc2b9ce33', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1841, 'Artline 250 0.4mm Writing, Drawing, Sign Pen', 'Artline 250 0.4mm Writing, Drawing, Sign Pen', 'Artline 250 0.4mm Writing, Drawing, Sign Pen', 20.00, 'https://cf.shopee.com.my/file/4fc5ee6be9c6df7cd84e98b5cf0058d3', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1842, 'FABER-CASTELL WINBALL PEN 0.5 -0.7 -ALL COLOUR/ Ball Point Pen (Black / Blue / Red)', 'FABER-CASTELL WINBALL PEN 0.5 -0.7 -ALL COLOUR/ Ball Point Pen (Black / Blue / Red)', 'FABER-CASTELL WINBALL PEN 0.5 -0.7 -ALL COLOUR/ Ball Point Pen (Black / Blue / Red)', 9.60, 'https://cf.shopee.com.my/file/e32147c48ad0f2d70a4b3870eb80b492', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1843, 'Ready Stock ~ Gradient Rainbow Color 16 Inches (35cm) Numbering Number 0-9 Balloon Foil Balloon Belon Nombor', 'Ready Stock ~ Gradient Rainbow Color 16 Inches (35cm) Numbering Number 0-9 Balloon Foil Balloon Belon Nombor', 'Ready Stock ~ Gradient Rainbow Color 16 Inches (35cm) Numbering Number 0-9 Balloon Foil Balloon Belon Nombor', 10.80, 'https://cf.shopee.com.my/file/f340d31d556e912db0d576727208e777', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1844, '100% Original NEVOKS FEELIN 0.6/1.0 MESH COIL (5PCS/BOX) FEELIN OCC NEVOKS COIL', '100% Original NEVOKS FEELIN 0.6/1.0 MESH COIL (5PCS/BOX) FEELIN OCC NEVOKS COIL', '100% Original NEVOKS FEELIN 0.6/1.0 MESH COIL (5PCS/BOX) FEELIN OCC NEVOKS COIL', 357.00, 'https://cf.shopee.com.my/file/61647084145afa80796f0ff785a57dfe', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1845, 'Boy fashion suit 0-6 years old boy summer shirt suit, kid clothes, baby boy flower pattern shirt + pants 2pcs boy clothes', 'Boy fashion suit 0-6 years old boy summer shirt suit, kid clothes, baby boy flower pattern shirt + pants 2pcs boy clothes', 'Boy fashion suit 0-6 years old boy summer shirt suit, kid clothes, baby boy flower pattern shirt + pants 2pcs boy clothes', 144.00, 'https://cf.shopee.com.my/file/5ecd17d15678665c1b41694c57a49d91', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1846, '[Ready Stock]10x10cm Silicone Thermal Pad Sheet Thickness 1mm Thermal conductivity 0.8~6w/mk for Computer CPU', '[Ready Stock]10x10cm Silicone Thermal Pad Sheet Thickness 1mm Thermal conductivity 0.8~6w/mk for Computer CPU', '[Ready Stock]10x10cm Silicone Thermal Pad Sheet Thickness 1mm Thermal conductivity 0.8~6w/mk for Computer CPU', 34.50, 'https://cf.shopee.com.my/file/8124dcc57ced76d69f9ebe5cdc809e84', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1848, '4T YAMALUBE HONG LEONG YAMAHA HLY 20W-50 API SJ MA 100% ORIGINAL MINYAK HITAM 0.85L 850ML', '4T YAMALUBE HONG LEONG YAMAHA HLY 20W-50 API SJ MA 100% ORIGINAL MINYAK HITAM 0.85L 850ML', '4T YAMALUBE HONG LEONG YAMAHA HLY 20W-50 API SJ MA 100% ORIGINAL MINYAK HITAM 0.85L 850ML', 98.00, 'https://cf.shopee.com.my/file/72b2e749f2a5e31e37626b7f147c1f7d', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1849, 'Allinone 5M x 0.5M Hydrodipping Film Carbon Fiber Texture Water Transfer Hydro Dip Print', 'Allinone 5M x 0.5M Hydrodipping Film Carbon Fiber Texture Water Transfer Hydro Dip Print', 'Allinone 5M x 0.5M Hydrodipping Film Carbon Fiber Texture Water Transfer Hydro Dip Print', 266.60, 'https://cf.shopee.com.my/file/8d140fac8d03f87812ad6ab02302fdfd', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1850, 'Ready Stock 0-24M Newborn Baby Girls Boys Romper Toddler Bodysuits Short Sleeve Cute Print Jumpsuit Baby Unisex Clothes', 'Ready Stock 0-24M Newborn Baby Girls Boys Romper Toddler Bodysuits Short Sleeve Cute Print Jumpsuit Baby Unisex Clothes', 'Ready Stock 0-24M Newborn Baby Girls Boys Romper Toddler Bodysuits Short Sleeve Cute Print Jumpsuit Baby Unisex Clothes', 39.90, 'https://cf.shopee.com.my/file/edb50f2ced0140549a6404143bad19d3', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1851, 'Micro HDMI to HDMI Male Video Cable Cord TV Connected 50cm 100cm 0.5m 1m 1.5m 3m 5m 10m', 'Micro HDMI to HDMI Male Video Cable Cord TV Connected 50cm 100cm 0.5m 1m 1.5m 3m 5m 10m', 'Micro HDMI to HDMI Male Video Cable Cord TV Connected 50cm 100cm 0.5m 1m 1.5m 3m 5m 10m', 145.00, 'https://cf.shopee.com.my/file/db58249b7132ccde6c7ab14f0c7ca279', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1852, '0.91\" / 0.96\" inch 128x32 128x64 I2C IIC OLED LCD LED White / Blue Graphic Display Module for Arduino /Raspberry Pi 3b 4', '0.91\" / 0.96\" inch 128x32 128x64 I2C IIC OLED LCD LED White / Blue Graphic Display Module for Arduino /Raspberry Pi 3b 4', '0.91\" / 0.96\" inch 128x32 128x64 I2C IIC OLED LCD LED White / Blue Graphic Display Module for Arduino /Raspberry Pi 3b 4', 139.00, 'https://cf.shopee.com.my/file/ee0aca69ce1b553bfb15843f7b9188da', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1853, 'Kreati Black Pen 4IN1 0.5MM - 0605', 'Kreati Black Pen 4IN1 0.5MM - 0605', 'Kreati Black Pen 4IN1 0.5MM - 0605', 21.00, 'https://cf.shopee.com.my/file/e64bd1ce8a6ee465321023fd225e4416', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1854, '0.7MM Thickness A3 / A4 / A5 Size Magnet Sheet /Fridge Magnet)', '0.7MM Thickness A3 / A4 / A5 Size Magnet Sheet /Fridge Magnet)', '0.7MM Thickness A3 / A4 / A5 Size Magnet Sheet /Fridge Magnet)', 20.00, 'https://cf.shopee.com.my/file/3e584677dd5e4756309ecb047865ca43', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1855, 'Aluminum Crochet Hook Weave Knit Hand Woven Tool Needles Knitted Craft Knitting Tool (2.0-6.0mm) Jarum Kait Aluminum', 'Aluminum Crochet Hook Weave Knit Hand Woven Tool Needles Knitted Craft Knitting Tool (2.0-6.0mm) Jarum Kait Aluminum', 'Aluminum Crochet Hook Weave Knit Hand Woven Tool Needles Knitted Craft Knitting Tool (2.0-6.0mm) Jarum Kait Aluminum', 10.70, 'https://cf.shopee.com.my/file/eb69d68ee7e47964f80cb854eb663259', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1856, 'SanDisk OTG Pendrive 128GB / 64GB / 32GB / 16GB Ultra Dual Drive M3.0 Pen Drive Flash Drive Micro USBFor Andro', 'SanDisk OTG Pendrive 128GB / 64GB / 32GB / 16GB Ultra Dual Drive M3.0 Pen Drive Flash Drive Micro USBFor Andro', 'SanDisk OTG Pendrive 128GB / 64GB / 32GB / 16GB Ultra Dual Drive M3.0 Pen Drive Flash Drive Micro USBFor Andro', 176.60, 'https://cf.shopee.com.my/file/61e962851b76787429fb63eadefafc68', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1858, 'Buncho 2pcs pencil lead 0.5mm', 'Buncho 2pcs pencil lead 0.5mm', 'Buncho 2pcs pencil lead 0.5mm', 11.60, 'https://cf.shopee.com.my/file/908f8b7effa33472882db3806b86b944', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1860, 'SAMSUNG TAB A7LITE/A8.0/A8PEN/TAB A7 10.4/TAB S6 LITE/TAB S6/TAB A 10.1/TAB S5E/TAB S7/TAB S7+ Hydrogel Screen Protecter', 'SAMSUNG TAB A7LITE/A8.0/A8PEN/TAB A7 10.4/TAB S6 LITE/TAB S6/TAB A 10.1/TAB S5E/TAB S7/TAB S7+ Hydrogel Screen Protecter', 'SAMSUNG TAB A7LITE/A8.0/A8PEN/TAB A7 10.4/TAB S6 LITE/TAB S6/TAB A 10.1/TAB S5E/TAB S7/TAB S7+ Hydrogel Screen Protecter', 199.50, 'https://cf.shopee.com.my/file/f8d4b2dbd1950624223bcbcc7abe2bec', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1863, 'RAYA 0~4years old Baby Boy Girl T-Shirt Pant Short Sleeve Set (BT005) Children Kids Short-sleeve Suit Cotton Baju Budak', 'RAYA 0~4years old Baby Boy Girl T-Shirt Pant Short Sleeve Set (BT005) Children Kids Short-sleeve Suit Cotton Baju Budak', 'RAYA 0~4years old Baby Boy Girl T-Shirt Pant Short Sleeve Set (BT005) Children Kids Short-sleeve Suit Cotton Baju Budak', 62.80, 'https://cf.shopee.com.my/file/2ca8c08cede77273fa905ff95cdbba7b', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1864, 'The Ordinary / New&BEST 20 Products /Niacinamide 10% + zinc, 100% Niacinamide powder, Retinol 0.5%, Buffet, Squalane Cleaner, Hyaluronic Acid B5,glycolic acid,alpha arbutin,rose hip seed oil, lactic acid 5%,matrixyl,caffeine solution', 'The Ordinary / New&BEST 20 Products /Niacinamide 10% + zinc, 100% Niacinamide powder, Retinol 0.5%, Buffet, Squalane Cleaner, Hyaluronic Acid B5,glycolic acid,alpha arbutin,rose hip seed oil, lactic acid 5%,matrixyl,caffeine solution', 'The Ordinary / New&BEST 20 Products /Niacinamide 10% + zinc, 100% Niacinamide powder, Retinol 0.5%, Buffet, Squalane Cleaner, Hyaluronic Acid B5,glycolic acid,alpha arbutin,rose hip seed oil, lactic acid 5%,matrixyl,caffeine solution', 300.30, 'https://cf.shopee.com.my/file/93bc9e364e0e8f5e02c6d2a8bd3d599a', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1866, 'Freshly Ground [AUSTRALIA] 100% Whole Wheat Flour (FINE) 0.5kg Low-Gluten Tepung Gandum Chapati Atta Chakki Roti Aata', 'Freshly Ground [AUSTRALIA] 100% Whole Wheat Flour (FINE) 0.5kg Low-Gluten Tepung Gandum Chapati Atta Chakki Roti Aata', 'Freshly Ground [AUSTRALIA] 100% Whole Wheat Flour (FINE) 0.5kg Low-Gluten Tepung Gandum Chapati Atta Chakki Roti Aata', 29.90, 'https://cf.shopee.com.my/file/791bc839368b31b25055b1bec7320158', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1868, '0-5y Kids Short Sleeve Tshirt Summer Shirt Baby Boys Cartoon Cotton Short Sleeve Top Cute Shirt COD', '0-5y Kids Short Sleeve Tshirt Summer Shirt Baby Boys Cartoon Cotton Short Sleeve Top Cute Shirt COD', '0-5y Kids Short Sleeve Tshirt Summer Shirt Baby Boys Cartoon Cotton Short Sleeve Top Cute Shirt COD', 59.80, 'https://cf.shopee.com.my/file/9f1a3a3779b4f6a98e7322f28d83ef28', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1869, 'Baby Romper/Jumper/Jumpsuit/ Sleepsuit 0-24 bulan', 'Baby Romper/Jumper/Jumpsuit/ Sleepsuit 0-24 bulan', 'Baby Romper/Jumper/Jumpsuit/ Sleepsuit 0-24 bulan', 10.00, 'https://cf.shopee.com.my/file/7ae15af300ff1617f941e4fbfc829eb5', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1870, 'Newborn Baby Clothing Summer Infant Toddler Girl Romper Short Sleeve Cartoon Pattern Cotton Baby Jumpsuit 0-2yrs Baby Costume', 'Newborn Baby Clothing Summer Infant Toddler Girl Romper Short Sleeve Cartoon Pattern Cotton Baby Jumpsuit 0-2yrs Baby Costume', 'Newborn Baby Clothing Summer Infant Toddler Girl Romper Short Sleeve Cartoon Pattern Cotton Baby Jumpsuit 0-2yrs Baby Costume', 130.00, 'https://cf.shopee.com.my/file/550e03856a504bebb65af3db732e0ed2', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1871, 'Microwave Oven Fuse 6x40mm 0.65A 0.7A 0.75A 0.8A 0.9A', 'Microwave Oven Fuse 6x40mm 0.65A 0.7A 0.75A 0.8A 0.9A', 'Microwave Oven Fuse 6x40mm 0.65A 0.7A 0.75A 0.8A 0.9A', 15.00, 'https://cf.shopee.com.my/file/d3a302330c18937e6140926a13471ff6', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1872, 'RCA Cable 1to2 , 2to1 , 0.5M , 1.2M , 2.0M , 4.5M', 'RCA Cable 1to2 , 2to1 , 0.5M , 1.2M , 2.0M , 4.5M', 'RCA Cable 1to2 , 2to1 , 0.5M , 1.2M , 2.0M , 4.5M', 90.00, 'https://cf.shopee.com.my/file/1c3a728196ec5a0a73263e6cbb1e7ebb', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1873, 'Boy fashion suit 0-6 years old boys POLO shirt T-shirt berjalur kanak-kanak + seluar pakaian bayi 2pcs', 'Boy fashion suit 0-6 years old boys POLO shirt T-shirt berjalur kanak-kanak + seluar pakaian bayi 2pcs', 'Boy fashion suit 0-6 years old boys POLO shirt T-shirt berjalur kanak-kanak + seluar pakaian bayi 2pcs', 128.60, 'https://cf.shopee.com.my/file/54a9d33ccb7d9a87613005c667f83e04', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1874, '(POWER -0.50 TO -9.00) Bausch & Lomb soflens 38 monthly (6pcs) contact lenses', '(POWER -0.50 TO -9.00) Bausch & Lomb soflens 38 monthly (6pcs) contact lenses', '(POWER -0.50 TO -9.00) Bausch & Lomb soflens 38 monthly (6pcs) contact lenses', 399.80, 'https://cf.shopee.com.my/file/f777265771afb8241c02c695de50b8ae', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1877, '(READY STOK) MASTA ASSIST DOUBLE HOOK FAST JIG 40G-80G SIZE HOOK 3/0', '(READY STOK) MASTA ASSIST DOUBLE HOOK FAST JIG 40G-80G SIZE HOOK 3/0', '(READY STOK) MASTA ASSIST DOUBLE HOOK FAST JIG 40G-80G SIZE HOOK 3/0', 39.00, 'https://cf.shopee.com.my/file/52bf415e267f9fe5a04438e013770374', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1878, '(0.00 to -5.00 )1 piece freshkon alluring daily color magnetic grey (loose pack)', '(0.00 to -5.00 )1 piece freshkon alluring daily color magnetic grey (loose pack)', '(0.00 to -5.00 )1 piece freshkon alluring daily color magnetic grey (loose pack)', 20.50, 'https://cf.shopee.com.my/file/750f2b2bf592f07f670259f5d2726526', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1879, '0-4YKid S Children\'s Baby Turtle Whack Mole Music Knock Knock Toys Parent-child Interactive Game Boy', '0-4YKid S Children\'s Baby Turtle Whack Mole Music Knock Knock Toys Parent-child Interactive Game Boy', '0-4YKid S Children\'s Baby Turtle Whack Mole Music Knock Knock Toys Parent-child Interactive Game Boy', 231.50, 'https://cf.shopee.com.my/file/01e4838442c98ca0c65b0b530c7f4351', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1880, 'Pilot 2B Polymer Mechanical Pencil Leads Mata Pensil Begreen 0.3mm / 0.5mm / 0.7mm / 0.9mm', 'Pilot 2B Polymer Mechanical Pencil Leads Mata Pensil Begreen 0.3mm / 0.5mm / 0.7mm / 0.9mm', 'Pilot 2B Polymer Mechanical Pencil Leads Mata Pensil Begreen 0.3mm / 0.5mm / 0.7mm / 0.9mm', 10.00, 'https://cf.shopee.com.my/file/c0cb1d4b48323f1dcd68da42da9c9a8a', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1881, 'Novel: PERCATURAN HATI | Penulis: Freezia | Penerbit: Penulisan2u | ISBN: 978-967-0992-31-0', 'Novel: PERCATURAN HATI | Penulis: Freezia | Penerbit: Penulisan2u | ISBN: 978-967-0992-31-0', 'Novel: PERCATURAN HATI | Penulis: Freezia | Penerbit: Penulisan2u | ISBN: 978-967-0992-31-0', 90.00, 'https://cf.shopee.com.my/file/43f8c8763389622a26feac39476bcb9f', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1882, 'PILOT PROGREX MECHANICAL PENCIL 0.3MM / 0.5MM / 0.7MM / 0.9MM (READY STOCK / 100% ORIGINAL)', 'PILOT PROGREX MECHANICAL PENCIL 0.3MM / 0.5MM / 0.7MM / 0.9MM (READY STOCK / 100% ORIGINAL)', 'PILOT PROGREX MECHANICAL PENCIL 0.3MM / 0.5MM / 0.7MM / 0.9MM (READY STOCK / 100% ORIGINAL)', 24.50, 'https://cf.shopee.com.my/file/b50adee4a7f940e096f8d8e65e4a9a0c', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1883, 'Staedtler Noris 2B Pencil / Pensil 2B 120-0 A50', 'Staedtler Noris 2B Pencil / Pensil 2B 120-0 A50', 'Staedtler Noris 2B Pencil / Pensil 2B 120-0 A50', 68.00, 'https://cf.shopee.com.my/file/6341eacb790ae26268babe04d5d8db62', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1884, 'Autumn Newborn Baby Cute Romper Long Sleeves Cotton Baby Pajamas 0-3M', 'Autumn Newborn Baby Cute Romper Long Sleeves Cotton Baby Pajamas 0-3M', 'Autumn Newborn Baby Cute Romper Long Sleeves Cotton Baby Pajamas 0-3M', 118.00, 'https://cf.shopee.com.my/file/e3a3bfd95890e41d45277f254adebe54', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1886, '[JPJ Approved] Nombor Plate Sticker Motorcycle White Number Sticker Motor Moto Motosikal ABC 123 Putih White A-Z Or 0-9', '[JPJ Approved] Nombor Plate Sticker Motorcycle White Number Sticker Motor Moto Motosikal ABC 123 Putih White A-Z Or 0-9', '[JPJ Approved] Nombor Plate Sticker Motorcycle White Number Sticker Motor Moto Motosikal ABC 123 Putih White A-Z Or 0-9', 4.50, 'https://cf.shopee.com.my/file/ccf0fbdcb20880f55e76a5cd39d3ee5a', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1887, 'Premium Heavy Como Crepe 60\' / Kain Pasang (0.5M)', 'Premium Heavy Como Crepe 60\' / Kain Pasang (0.5M)', 'Premium Heavy Como Crepe 60\' / Kain Pasang (0.5M)', 27.50, 'https://cf.shopee.com.my/file/967a0cf04c237558d7bccfb3714fe601', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1888, 'Wool Peach (Ironless) - Bidang 57-60\" : RM7.00 untuk 0.5mtr (setengah meter)', 'Wool Peach (Ironless) - Bidang 57-60\" : RM7.00 untuk 0.5mtr (setengah meter)', 'Wool Peach (Ironless) - Bidang 57-60\" : RM7.00 untuk 0.5mtr (setengah meter)', 52.50, 'https://cf.shopee.com.my/file/b721b8d0e9997ffcd3a26bd1b8596ca6', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1889, '0-5Y Baby Kid Set Pajamas Pyjamas Long Sleeve with Long Pants Boy Girl Kids Sleepwear Baju Bayi QY090', '0-5Y Baby Kid Set Pajamas Pyjamas Long Sleeve with Long Pants Boy Girl Kids Sleepwear Baju Bayi QY090', '0-5Y Baby Kid Set Pajamas Pyjamas Long Sleeve with Long Pants Boy Girl Kids Sleepwear Baju Bayi QY090', 62.80, 'https://cf.shopee.com.my/file/456db8daee1340bc0a164401f3c8086b', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1890, 'Puffy 3Tone Gray/Grey 14.5mm Contact Lens Lenses (0 Power/Degree / 100-700 Power/Dgree) C21-5 By Chao Run.', 'Puffy 3Tone Gray/Grey 14.5mm Contact Lens Lenses (0 Power/Degree / 100-700 Power/Dgree) C21-5 By Chao Run.', 'Puffy 3Tone Gray/Grey 14.5mm Contact Lens Lenses (0 Power/Degree / 100-700 Power/Dgree) C21-5 By Chao Run.', 89.00, 'https://cf.shopee.com.my/file/cf15fbd6f44ec07804afe57454b34233', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1891, 'SUN KL Read Stock Electronic Digital Kitchen Scale Multifunction Scale Penimbang Digital With Minimum Accuracy 0.1/0.01g', 'SUN KL Read Stock Electronic Digital Kitchen Scale Multifunction Scale Penimbang Digital With Minimum Accuracy 0.1/0.01g', 'SUN KL Read Stock Electronic Digital Kitchen Scale Multifunction Scale Penimbang Digital With Minimum Accuracy 0.1/0.01g', 18.90, 'https://cf.shopee.com.my/file/4d5e2f7b20d5c6a0ac14051d8a766013', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1892, 'USB 5V To 9V (0.7A) Converter Booster Eliminator for Smart Tag / Electronic Device Option LED Voltage Display', 'USB 5V To 9V (0.7A) Converter Booster Eliminator for Smart Tag / Electronic Device Option LED Voltage Display', 'USB 5V To 9V (0.7A) Converter Booster Eliminator for Smart Tag / Electronic Device Option LED Voltage Display', 79.50, 'https://cf.shopee.com.my/file/0044942bad8c965cec3d7bd3fda46256', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1894, 'Biofinity Monthly Silicone 3 pcs Hydrogel Cooper Vision Lenses  - Power -0.50-12.00', 'Biofinity Monthly Silicone 3 pcs Hydrogel Cooper Vision Lenses  - Power -0.50-12.00', 'Biofinity Monthly Silicone 3 pcs Hydrogel Cooper Vision Lenses  - Power -0.50-12.00', 550.00, 'https://cf.shopee.com.my/file/b473b6143de804d947be3e31676179d2', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1895, 'Mitutoyo  Caliper Digital Caliper Vernier Caliper High-Precision Stainless Steel Electronic 0-150/200/300mm', 'Mitutoyo  Caliper Digital Caliper Vernier Caliper High-Precision Stainless Steel Electronic 0-150/200/300mm', 'Mitutoyo  Caliper Digital Caliper Vernier Caliper High-Precision Stainless Steel Electronic 0-150/200/300mm', 1080.00, 'https://cf.shopee.com.my/file/b1f7d9b5dcfd9146b0a3a5849a792745', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1896, 'SamView Smart Android 9.0 Digital LED TV 55 Inch With 4K Ultra HD and MYTV DVB T2', 'SamView Smart Android 9.0 Digital LED TV 55 Inch With 4K Ultra HD and MYTV DVB T2', 'SamView Smart Android 9.0 Digital LED TV 55 Inch With 4K Ultra HD and MYTV DVB T2', 16150.00, 'https://cf.shopee.com.my/file/d35fc29a8efe39b00e34cb5040fc72d4', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1897, 'Clinbon Newborn Baby wear Singlet/Shirt/long Suit-Eyelet 0-9 months,set baju bayi', 'Clinbon Newborn Baby wear Singlet/Shirt/long Suit-Eyelet 0-9 months,set baju bayi', 'Clinbon Newborn Baby wear Singlet/Shirt/long Suit-Eyelet 0-9 months,set baju bayi', 85.00, 'https://cf.shopee.com.my/file/0a511bcb8077016c4fd72578d3254ea7', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1899, 'MILUX Classy Cute Mini Rice Cooker MRC-703 @ MRC-7103/PANALUX RICE COOKER PRC-066 0.6 L', 'MILUX Classy Cute Mini Rice Cooker MRC-703 @ MRC-7103/PANALUX RICE COOKER PRC-066 0.6 L', 'MILUX Classy Cute Mini Rice Cooker MRC-703 @ MRC-7103/PANALUX RICE COOKER PRC-066 0.6 L', 520.00, 'https://cf.shopee.com.my/file/08a522974c1a6d2b7e0c322e0706bff0', 1627909678, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1902, 'Non-stretch Thread Transparent Beading Crystal Rope (8-90m/Roll 0.2 x 0.4 x 0.6 x 0.8mm)', 'Non-stretch Thread Transparent Beading Crystal Rope (8-90m/Roll 0.2 x 0.4 x 0.6 x 0.8mm)', 'Non-stretch Thread Transparent Beading Crystal Rope (8-90m/Roll 0.2 x 0.4 x 0.6 x 0.8mm)', 12.20, 'https://cf.shopee.com.my/file/b540f89acfcddbf9927663bd80c5786d', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1903, 'Anakku Disney Mickey Newborn Baby Boy Gift Set / Set Hadiah Bayi Lelaki 0-3 Months (5 pcs) EDS306-1', 'Anakku Disney Mickey Newborn Baby Boy Gift Set / Set Hadiah Bayi Lelaki 0-3 Months (5 pcs) EDS306-1', 'Anakku Disney Mickey Newborn Baby Boy Gift Set / Set Hadiah Bayi Lelaki 0-3 Months (5 pcs) EDS306-1', 509.00, 'https://cf.shopee.com.my/file/757a6ee425c3bb1ecf1194ddf87d1947', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1904, '(10Meters) AUTO WIRE 100% PURE COOPER WIRE MALAYSIA 14/0.26 28/0.26 CAR TRUCKS', '(10Meters) AUTO WIRE 100% PURE COOPER WIRE MALAYSIA 14/0.26 28/0.26 CAR TRUCKS', '(10Meters) AUTO WIRE 100% PURE COOPER WIRE MALAYSIA 14/0.26 28/0.26 CAR TRUCKS', 79.00, 'https://cf.shopee.com.my/file/64868f9e41a8f32d5fd6552754109511', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1905, 'FSU 0.5m 1m 2m 3m 5m Coaxial Digital Audio RCA Cable RCA To RCA Cable Audio Video Cable for DVD Projector TV Speaker Amplifier', 'FSU 0.5m 1m 2m 3m 5m Coaxial Digital Audio RCA Cable RCA To RCA Cable Audio Video Cable for DVD Projector TV Speaker Amplifier', 'FSU 0.5m 1m 2m 3m 5m Coaxial Digital Audio RCA Cable RCA To RCA Cable Audio Video Cable for DVD Projector TV Speaker Amplifier', 95.60, 'https://cf.shopee.com.my/file/fc1bbb3a26b6205a4c58177f722a13f3', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1906, 'Sakura Pigma Micron Pen / Sakura Drawing Pen Needle Soft Brush 003/004/05/08/Brush BR/Graphic PH2.0', 'Sakura Pigma Micron Pen / Sakura Drawing Pen Needle Soft Brush 003/004/05/08/Brush BR/Graphic PH2.0', 'Sakura Pigma Micron Pen / Sakura Drawing Pen Needle Soft Brush 003/004/05/08/Brush BR/Graphic PH2.0', 28.50, 'https://cf.shopee.com.my/file/e8d8a8394705c644c8c6b9d533ea01cb', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1908, '0.5mm Colorful Highlight Drawing pen - 9 Colors,Fine Tip White Gel Pens', '0.5mm Colorful Highlight Drawing pen - 9 Colors,Fine Tip White Gel Pens', '0.5mm Colorful Highlight Drawing pen - 9 Colors,Fine Tip White Gel Pens', 8.00, 'https://cf.shopee.com.my/file/987ec91b5deb6db63a1f0fa3ce9eb96f', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1910, 'EaseUS Data Recovery Wizard 14.0 Lifetime Latest 2021 For Windows', 'EaseUS Data Recovery Wizard 14.0 Lifetime Latest 2021 For Windows', 'EaseUS Data Recovery Wizard 14.0 Lifetime Latest 2021 For Windows', 49.90, 'https://cf.shopee.com.my/file/cbcb8209e598c3e95f93ad4d0a870930', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1911, '100% ORIGINAL i7s TWS Bluetooth V5.0 Earphone For Ios & Android Earphone Headphone', '100% ORIGINAL i7s TWS Bluetooth V5.0 Earphone For Ios & Android Earphone Headphone', '100% ORIGINAL i7s TWS Bluetooth V5.0 Earphone For Ios & Android Earphone Headphone', 25.00, 'https://cf.shopee.com.my/file/26bee80ab7190324d40d2ae93c4fd143', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1912, 'Faber Castell / Faber-Castell Click X5 0.5mm 1425 / Click X7 0.7mm 1422 Ball Pen', 'Faber Castell / Faber-Castell Click X5 0.5mm 1425 / Click X7 0.7mm 1422 Ball Pen', 'Faber Castell / Faber-Castell Click X5 0.5mm 1425 / Click X7 0.7mm 1422 Ball Pen', 7.50, 'https://cf.shopee.com.my/file/880daf9cd2561aee1cdc08b46e9fa29b', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1913, '1/4 inch (0.63cm) & 1/2 inch (15mm)Satin Ribbons * 22 meter', '1/4 inch (0.63cm) & 1/2 inch (15mm)Satin Ribbons * 22 meter', '1/4 inch (0.63cm) & 1/2 inch (15mm)Satin Ribbons * 22 meter', 9.00, 'https://cf.shopee.com.my/file/091784918bc27911b88528bb9996a3ad', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1914, '500g x 0.01g Mini Digital Jewellery Pocket Scale / Penimbang digital / Penimbang Emas / Penimbang Batu Permata / Timbang', '500g x 0.01g Mini Digital Jewellery Pocket Scale / Penimbang digital / Penimbang Emas / Penimbang Batu Permata / Timbang', '500g x 0.01g Mini Digital Jewellery Pocket Scale / Penimbang digital / Penimbang Emas / Penimbang Batu Permata / Timbang', 169.00, 'https://cf.shopee.com.my/file/2b729b3445688f410aaef2bb5bf3fabe', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1915, 'Original NEVOKS FEELIN OCC SP10 MESH COIL Feelin  Occ Feelin Coil Feelin Cartridge Nevoks Coil Occ/0.6', 'Original NEVOKS FEELIN OCC SP10 MESH COIL Feelin  Occ Feelin Coil Feelin Cartridge Nevoks Coil Occ/0.6', 'Original NEVOKS FEELIN OCC SP10 MESH COIL Feelin  Occ Feelin Coil Feelin Cartridge Nevoks Coil Occ/0.6', 80.00, 'https://cf.shopee.com.my/file/ec1d0c2dcd36066ad046c10184e89286', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1916, 'USB3.0 high speed USB Flash Drive 16GB 32GB 64GB  128GB 256GB Memory Pendrive Stick OTG USB Flash Drive', 'USB3.0 high speed USB Flash Drive 16GB 32GB 64GB  128GB 256GB Memory Pendrive Stick OTG USB Flash Drive', 'USB3.0 high speed USB Flash Drive 16GB 32GB 64GB  128GB 256GB Memory Pendrive Stick OTG USB Flash Drive', 172.00, 'https://cf.shopee.com.my/file/6aa41e4cb3912c64e4e62e08ae8d1619', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1917, 'HIgh Speed USB3.0 USB Male to USB 3.0 Male Extension Cable Type 1.5M (Blue)', 'HIgh Speed USB3.0 USB Male to USB 3.0 Male Extension Cable Type 1.5M (Blue)', 'HIgh Speed USB3.0 USB Male to USB 3.0 Male Extension Cable Type 1.5M (Blue)', 138.00, 'https://cf.shopee.com.my/file/11d333cb8ffac11d8161ff383008e32e', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1918, 'Faber-Castell RX Gel Bright Colour Set of 5 (0.7mm) / RX Gel / Gel Pen / Bright Colour Set / 5 IN 1', 'Faber-Castell RX Gel Bright Colour Set of 5 (0.7mm) / RX Gel / Gel Pen / Bright Colour Set / 5 IN 1', 'Faber-Castell RX Gel Bright Colour Set of 5 (0.7mm) / RX Gel / Gel Pen / Bright Colour Set / 5 IN 1', 16.00, 'https://cf.shopee.com.my/file/e66a1566dc573851f61688ad6086a2f7', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1920, 'Colourful Up To500G / 0.1G Measuring Spoon with Lcd Display for Digital Measuring Spoon Weight Kitchen Weighing Scale', 'Colourful Up To500G / 0.1G Measuring Spoon with Lcd Display for Digital Measuring Spoon Weight Kitchen Weighing Scale', 'Colourful Up To500G / 0.1G Measuring Spoon with Lcd Display for Digital Measuring Spoon Weight Kitchen Weighing Scale', 106.00, 'https://cf.shopee.com.my/file/1ce3d0058e6943d058d770e3115b604f', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1921, 'Apple lightning OTG Converter to USB3.0 for iPhone Ipad IOS13', 'Apple lightning OTG Converter to USB3.0 for iPhone Ipad IOS13', 'Apple lightning OTG Converter to USB3.0 for iPhone Ipad IOS13', 138.80, 'https://cf.shopee.com.my/file/d67f391d411a6704273ebc2f88835ab0', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1922, 'OEM Geekvape Aegis Boost Replacement Coil Occ 0.4 Ohm / 0.6 Ohm For Aegis Boost Cool Gadget Ship from KL within 24 hours', 'OEM Geekvape Aegis Boost Replacement Coil Occ 0.4 Ohm / 0.6 Ohm For Aegis Boost Cool Gadget Ship from KL within 24 hours', 'OEM Geekvape Aegis Boost Replacement Coil Occ 0.4 Ohm / 0.6 Ohm For Aegis Boost Cool Gadget Ship from KL within 24 hours', 225.00, 'https://cf.shopee.com.my/file/589b68fc585d226586f614db8021b216', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1923, '0.0 to -6.0 diopters Cermin Mata Rabun Jauh Memory Metal Frame Nearsighted Glasses with power', '0.0 to -6.0 diopters Cermin Mata Rabun Jauh Memory Metal Frame Nearsighted Glasses with power', '0.0 to -6.0 diopters Cermin Mata Rabun Jauh Memory Metal Frame Nearsighted Glasses with power', 86.50, 'https://cf.shopee.com.my/file/52c1d2c535cbdfeb81f06757778b8da0', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1924, 'Faster CX444 Jawi Ball Pen  0.7mm (pcs)', 'Faster CX444 Jawi Ball Pen  0.7mm (pcs)', 'Faster CX444 Jawi Ball Pen  0.7mm (pcs)', 7.40, 'https://cf.shopee.com.my/file/6d542c398a34ba2ef77ec270165db873', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1925, '1TB Crystal USB Flash drive 128MB 64GB 32GB 16GB pendrive 8GB Custom USB Flash Drive usb2.0 Pen Drive memory Stick', '1TB Crystal USB Flash drive 128MB 64GB 32GB 16GB pendrive 8GB Custom USB Flash Drive usb2.0 Pen Drive memory Stick', '1TB Crystal USB Flash drive 128MB 64GB 32GB 16GB pendrive 8GB Custom USB Flash Drive usb2.0 Pen Drive memory Stick', 117.40, 'https://cf.shopee.com.my/file/91ae9b9f3ee6c47066b3dc457299911b', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1926, 'P47 5.0+EDR Wireless Headphone Bluetooth Stereo Music MP3 Player FM Radio Button Control SmartPhone Tablet Phone', 'P47 5.0+EDR Wireless Headphone Bluetooth Stereo Music MP3 Player FM Radio Button Control SmartPhone Tablet Phone', 'P47 5.0+EDR Wireless Headphone Bluetooth Stereo Music MP3 Player FM Radio Button Control SmartPhone Tablet Phone', 138.60, 'https://cf.shopee.com.my/file/80c628bd78f0efab534e6f94e9639e3c', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1927, 'YAMAHA YAMALUBE 20W50 4T High Performance MOTOR OIL 0.85L /  MINYAK HITAM 100% ORIGINAL ENGINE OILS', 'YAMAHA YAMALUBE 20W50 4T High Performance MOTOR OIL 0.85L /  MINYAK HITAM 100% ORIGINAL ENGINE OILS', 'YAMAHA YAMALUBE 20W50 4T High Performance MOTOR OIL 0.85L /  MINYAK HITAM 100% ORIGINAL ENGINE OILS', 97.60, 'https://cf.shopee.com.my/file/cbd0d34f0f24213c70120306d124536b', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1928, 'Adobe Illustrator 2021 v25.0.1.66 Full Version No Crack [LIFETIME] for Windows 7/8/10 & Mac', 'Adobe Illustrator 2021 v25.0.1.66 Full Version No Crack [LIFETIME] for Windows 7/8/10 & Mac', 'Adobe Illustrator 2021 v25.0.1.66 Full Version No Crack [LIFETIME] for Windows 7/8/10 & Mac', 20.00, 'https://cf.shopee.com.my/file/786af829f941c475912f32c507ffbd8f', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1929, 'SAMVIEW 40 Inch Android 9.0 Smart Digital LED TV WITH  FREEVIEW MYTV READY FHD 1920x1080p Ready', 'SAMVIEW 40 Inch Android 9.0 Smart Digital LED TV WITH  FREEVIEW MYTV READY FHD 1920x1080p Ready', 'SAMVIEW 40 Inch Android 9.0 Smart Digital LED TV WITH  FREEVIEW MYTV READY FHD 1920x1080p Ready', 9000.00, 'https://cf.shopee.com.my/file/62957661eb4e245f9b306cc2d4a44ca4', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1930, 'Cationorm Eye drops emulsion 0.4ml x30s', 'Cationorm Eye drops emulsion 0.4ml x30s', 'Cationorm Eye drops emulsion 0.4ml x30s', 435.00, 'https://cf.shopee.com.my/file/47757156a324b257d709f137d130eba8', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1932, 'Original Baseus Cafule Apple USB Cable Fast Charging Data[0.5m / 1m / 2m] Cable for All Apple iPhone 7 8 X Xs 11 Pro Max', 'Original Baseus Cafule Apple USB Cable Fast Charging Data[0.5m / 1m / 2m] Cable for All Apple iPhone 7 8 X Xs 11 Pro Max', 'Original Baseus Cafule Apple USB Cable Fast Charging Data[0.5m / 1m / 2m] Cable for All Apple iPhone 7 8 X Xs 11 Pro Max', 108.80, 'https://cf.shopee.com.my/file/3df4dfef16e1b0185b6582fcc033501d', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1933, 'Enamelled Copper Wire (Single Core) | 0.6mm, 0.8mm, 1.0mm, 1.2mm diameter (1 meter)', 'Enamelled Copper Wire (Single Core) | 0.6mm, 0.8mm, 1.0mm, 1.2mm diameter (1 meter)', 'Enamelled Copper Wire (Single Core) | 0.6mm, 0.8mm, 1.0mm, 1.2mm diameter (1 meter)', 40.00, 'https://cf.shopee.com.my/file/fc91fcd4cbb719326812885cb63169f6', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1934, 'Artline 041T Twin / Dual Tip Permanent Marker Pen 0.4mm & 1mm (Red/Blue/Black)', 'Artline 041T Twin / Dual Tip Permanent Marker Pen 0.4mm & 1mm (Red/Blue/Black)', 'Artline 041T Twin / Dual Tip Permanent Marker Pen 0.4mm & 1mm (Red/Blue/Black)', 33.00, 'https://cf.shopee.com.my/file/a06d10f6b4feae1f0200aa400e7d96f5', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1935, 'Baby Girls Suit (0-6 months) Ready Stock', 'Baby Girls Suit (0-6 months) Ready Stock', 'Baby Girls Suit (0-6 months) Ready Stock', 59.00, 'https://cf.shopee.com.my/file/20cc71c01cbfa9c27c85948e6dbedf5d', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1937, 'Y125Z / RXZ BLOCK ALLOY GASKET 0.3MM 0.5MM 0.8MM 1MM 1.5MM 2MM ASHUKA', 'Y125Z / RXZ BLOCK ALLOY GASKET 0.3MM 0.5MM 0.8MM 1MM 1.5MM 2MM ASHUKA', 'Y125Z / RXZ BLOCK ALLOY GASKET 0.3MM 0.5MM 0.8MM 1MM 1.5MM 2MM ASHUKA', 60.00, 'https://cf.shopee.com.my/file/e50fa54426e27fc9cb8aad2874add3ac', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1938, 'MUJI Gel Pen Black/Blue/Red Ink Color Pens 0.5mm/0.38mm Pens School Stationary', 'MUJI Gel Pen Black/Blue/Red Ink Color Pens 0.5mm/0.38mm Pens School Stationary', 'MUJI Gel Pen Black/Blue/Red Ink Color Pens 0.5mm/0.38mm Pens School Stationary', 14.00, 'https://cf.shopee.com.my/file/f64c8b346c3dad19b4ebeaedb42f91b7', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1939, '50pcs Resistor 0.25W 5% 2.2 - 2.2M Ohm', '50pcs Resistor 0.25W 5% 2.2 - 2.2M Ohm', '50pcs Resistor 0.25W 5% 2.2 - 2.2M Ohm', 10.00, 'https://cf.shopee.com.my/file/317af3582a743d3d7c90ede1f112f119', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1941, 'Ippo Store 10 Pcs Football Dribbling Training Cones 19.5cm x 5cm x 0.5cm', 'Ippo Store 10 Pcs Football Dribbling Training Cones 19.5cm x 5cm x 0.5cm', 'Ippo Store 10 Pcs Football Dribbling Training Cones 19.5cm x 5cm x 0.5cm', 99.00, 'https://cf.shopee.com.my/file/ca4eaa4f0055c5cdfda14f9ad8e42980', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1943, 'ROCK 2.5D 0.3mm 9H Full Coverage HD / Matte / Blueray Tempered Glass Screen Protector for iPhone 6 6 Plus 6P 6S 6sP 7 8', 'ROCK 2.5D 0.3mm 9H Full Coverage HD / Matte / Blueray Tempered Glass Screen Protector for iPhone 6 6 Plus 6P 6S 6sP 7 8', 'ROCK 2.5D 0.3mm 9H Full Coverage HD / Matte / Blueray Tempered Glass Screen Protector for iPhone 6 6 Plus 6P 6S 6sP 7 8', 9.90, 'https://cf.shopee.com.my/file/9aeabd575fe12ed9558d341e31f4c346', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1944, 'Faber-Castell Semi Gel Pen Grip X5 0.5mm / Grip X7 0.7mm / Grip X10 1.0mm - Blue / Black / Red', 'Faber-Castell Semi Gel Pen Grip X5 0.5mm / Grip X7 0.7mm / Grip X10 1.0mm - Blue / Black / Red', 'Faber-Castell Semi Gel Pen Grip X5 0.5mm / Grip X7 0.7mm / Grip X10 1.0mm - Blue / Black / Red', 12.00, 'https://cf.shopee.com.my/file/b0f29018799086a5bfd9331b745bb692', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1945, 'MINYAK PELINCIR ENGINE OIL YAMALUBE 4AT SCOOTER THAILAND SAE 40 0.8L / GEAR OIL VARIO EGO NOUVO AVANTIZ SOLARIZ NVX', 'MINYAK PELINCIR ENGINE OIL YAMALUBE 4AT SCOOTER THAILAND SAE 40 0.8L / GEAR OIL VARIO EGO NOUVO AVANTIZ SOLARIZ NVX', 'MINYAK PELINCIR ENGINE OIL YAMALUBE 4AT SCOOTER THAILAND SAE 40 0.8L / GEAR OIL VARIO EGO NOUVO AVANTIZ SOLARIZ NVX', 125.00, 'https://cf.shopee.com.my/file/7946194d42fb87de57c383e2b8a7dcb1', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1946, '1PC 12MM X 0.075MM PTFE Tape Hose Tape Pipe Tape Plumbing Pipe Repair Thread Sealing Tape', '1PC 12MM X 0.075MM PTFE Tape Hose Tape Pipe Tape Plumbing Pipe Repair Thread Sealing Tape', '1PC 12MM X 0.075MM PTFE Tape Hose Tape Pipe Tape Plumbing Pipe Repair Thread Sealing Tape', 8.00, 'https://cf.shopee.com.my/file/8739a0e4dac0fd301ae2cf0138c8c0b1', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1947, 'Pilot Rexgrip Ball Pen (0.5mm/0.7mm/1.0mm) #Red / Black / Blue / Rexgrip Ball Pen / Refillable Pen', 'Pilot Rexgrip Ball Pen (0.5mm/0.7mm/1.0mm) #Red / Black / Blue / Rexgrip Ball Pen / Refillable Pen', 'Pilot Rexgrip Ball Pen (0.5mm/0.7mm/1.0mm) #Red / Black / Blue / Rexgrip Ball Pen / Refillable Pen', 32.00, 'https://cf.shopee.com.my/file/9e4a41a8f8ff3b13160e7a4e27fe612e', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1948, 'Pear Lens 15mm 0-550 Power Ready Stock', 'Pear Lens 15mm 0-550 Power Ready Stock', 'Pear Lens 15mm 0-550 Power Ready Stock', 100.00, 'https://cf.shopee.com.my/file/f8111c2f7bfdbd311570c019893ce34d', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1949, 'High Performance Unicorn Dual Tib Black Permanent Marker Pen (1.0mm+0.5mm)', 'High Performance Unicorn Dual Tib Black Permanent Marker Pen (1.0mm+0.5mm)', 'High Performance Unicorn Dual Tib Black Permanent Marker Pen (1.0mm+0.5mm)', 15.20, 'https://cf.shopee.com.my/file/d50c305104bf93bd49ca4a3e2ad59243', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1950, 'Faber-Castell True Gel Pen 0.5/0.7', 'Faber-Castell True Gel Pen 0.5/0.7', 'Faber-Castell True Gel Pen 0.5/0.7', 16.00, 'https://cf.shopee.com.my/file/22be465008b9dcb2041d0f9e92abaf6b', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1951, 'Faber-Castell Grip X5 Ball Pen 0.5mm 1pcs', 'Faber-Castell Grip X5 Ball Pen 0.5mm 1pcs', 'Faber-Castell Grip X5 Ball Pen 0.5mm 1pcs', 9.90, 'https://cf.shopee.com.my/file/26623a34e340c77437d63d8db0498480', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1952, '[EXP: 08/23] HIALID 0.1% OPHTHALMIC SOLUTION 5ML', '[EXP: 08/23] HIALID 0.1% OPHTHALMIC SOLUTION 5ML', '[EXP: 08/23] HIALID 0.1% OPHTHALMIC SOLUTION 5ML', 119.80, 'https://cf.shopee.com.my/file/26c041151d1962f50c28e521d3812741', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1953, 'Faster Brilliant CX-446 Ball Pen 0.5mm', 'Faster Brilliant CX-446 Ball Pen 0.5mm', 'Faster Brilliant CX-446 Ball Pen 0.5mm', 6.50, 'https://cf.shopee.com.my/file/7b7f5c88fad0042bec95726bc6d67995', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1955, 'WHOLESALE FAJAR 14/0.26mm AUTO CABLES KERETA LORI AUTOMOTIVE WIRE 100% COPPER 30meter ~ RED/YELLOW/BLUE/GREEN/BLACK AUTO', 'WHOLESALE FAJAR 14/0.26mm AUTO CABLES KERETA LORI AUTOMOTIVE WIRE 100% COPPER 30meter ~ RED/YELLOW/BLUE/GREEN/BLACK AUTO', 'WHOLESALE FAJAR 14/0.26mm AUTO CABLES KERETA LORI AUTOMOTIVE WIRE 100% COPPER 30meter ~ RED/YELLOW/BLUE/GREEN/BLACK AUTO', 139.90, 'https://cf.shopee.com.my/file/e292b8369059c31997341f9c3276ec95', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1956, '0.3/0.5/0.8/1/1.5/1.8/3M - Mini USB 5 Pin Cable Charger Cord for PS3 Controller/PDA /MP3 /PSP', '0.3/0.5/0.8/1/1.5/1.8/3M - Mini USB 5 Pin Cable Charger Cord for PS3 Controller/PDA /MP3 /PSP', '0.3/0.5/0.8/1/1.5/1.8/3M - Mini USB 5 Pin Cable Charger Cord for PS3 Controller/PDA /MP3 /PSP', 29.00, 'https://cf.shopee.com.my/file/18f771b57cb18022b883eb08ba82cd27', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1957, 'Faster 70/90 Permanent Marker Pen Bullet Tip 0.8-2.2MM - (1\'pc)', 'Faster 70/90 Permanent Marker Pen Bullet Tip 0.8-2.2MM - (1\'pc)', 'Faster 70/90 Permanent Marker Pen Bullet Tip 0.8-2.2MM - (1\'pc)', 14.00, 'https://cf.shopee.com.my/file/d2641275abf283e26563c8f6fb1e22da', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1958, 'Faber Castell Grip X5 0.5mm/X7 0.7mm Ball Pen 1pcs', 'Faber Castell Grip X5 0.5mm/X7 0.7mm Ball Pen 1pcs', 'Faber Castell Grip X5 0.5mm/X7 0.7mm Ball Pen 1pcs', 9.00, 'https://cf.shopee.com.my/file/381a00f726cad271d8fcf0bd91ffc3d1', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1959, 'Spot baby children\'s shorts 0-4years olds summer student shorts Boys Girls Kids casual sports pants breathable style', 'Spot baby children\'s shorts 0-4years olds summer student shorts Boys Girls Kids casual sports pants breathable style', 'Spot baby children\'s shorts 0-4years olds summer student shorts Boys Girls Kids casual sports pants breathable style', 29.90, 'https://cf.shopee.com.my/file/ed4124eb64d73ab0832e066d09388834', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1961, 'Orico FL01 F4U-U3 TWU3-4A TWU3-7A USB2.0 / USB3.0 4 Port / 7 port USB Hub', 'Orico FL01 F4U-U3 TWU3-4A TWU3-7A USB2.0 / USB3.0 4 Port / 7 port USB Hub', 'Orico FL01 F4U-U3 TWU3-4A TWU3-7A USB2.0 / USB3.0 4 Port / 7 port USB Hub', 105.00, 'https://cf.shopee.com.my/file/9339d8e2ca423a3c6c9c67bc1d607762', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1962, 'KACANG SOYA CANADA SOYA BEAN 0.8KG PREMIUM GRADE MUSLIM SELLER [ READY STOCK NOW ] HIGH GRED A+ SUPPORT BMF', 'KACANG SOYA CANADA SOYA BEAN 0.8KG PREMIUM GRADE MUSLIM SELLER [ READY STOCK NOW ] HIGH GRED A+ SUPPORT BMF', 'KACANG SOYA CANADA SOYA BEAN 0.8KG PREMIUM GRADE MUSLIM SELLER [ READY STOCK NOW ] HIGH GRED A+ SUPPORT BMF', 45.60, 'https://cf.shopee.com.my/file/ce7561bea537702356fd10f3170ee47f', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1963, 'Fitness Concept: Reebok Astroride Runner  A2.0 Treadmill Running Machine (10 Years Warranty)', 'Fitness Concept: Reebok Astroride Runner  A2.0 Treadmill Running Machine (10 Years Warranty)', 'Fitness Concept: Reebok Astroride Runner  A2.0 Treadmill Running Machine (10 Years Warranty)', 23880.00, 'https://cf.shopee.com.my/file/2d941bf82ae495fde96a3692cfee9a0d', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1965, 'Pilot Progrex Mechanical Pencil 0.5mm / 0.7mm', 'Pilot Progrex Mechanical Pencil 0.5mm / 0.7mm', 'Pilot Progrex Mechanical Pencil 0.5mm / 0.7mm', 25.00, 'https://cf.shopee.com.my/file/356d80621cfcf1bbd125b4691a99d975', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1966, '1kg 0.8mm / 1.0mm Flux Cored Gasless Mig Welding Wire', '1kg 0.8mm / 1.0mm Flux Cored Gasless Mig Welding Wire', '1kg 0.8mm / 1.0mm Flux Cored Gasless Mig Welding Wire', 48.80, 'https://cf.shopee.com.my/file/b8ad818c92b5352502d5bbc6abe96d09', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1967, '2020 Number Candle Cake Happy Birthday 0-9 Nombor Lilin Kek Hari Jadi Baking Dessert Table Sparkling Numbering Candles', '2020 Number Candle Cake Happy Birthday 0-9 Nombor Lilin Kek Hari Jadi Baking Dessert Table Sparkling Numbering Candles', '2020 Number Candle Cake Happy Birthday 0-9 Nombor Lilin Kek Hari Jadi Baking Dessert Table Sparkling Numbering Candles', 24.70, 'https://cf.shopee.com.my/file/696e36113698261961d3a9e4593f1c59', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1968, 'Digital Scale 0.01g 500g 3000g High Accuracy Electronic Kitchen Cooking Food Weight Baking Jewelry Penimbang Timbang', 'Digital Scale 0.01g 500g 3000g High Accuracy Electronic Kitchen Cooking Food Weight Baking Jewelry Penimbang Timbang', 'Digital Scale 0.01g 500g 3000g High Accuracy Electronic Kitchen Cooking Food Weight Baking Jewelry Penimbang Timbang', 165.00, 'https://cf.shopee.com.my/file/baed5b9c0f0771b3112ea0f8540b8168', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1970, 'Cute Newborn 0-12 Months Baby Hat Boy Girl Beanies Cute Ears Bonnet Infant Cotton Hats Warm Hospital Cap', 'Cute Newborn 0-12 Months Baby Hat Boy Girl Beanies Cute Ears Bonnet Infant Cotton Hats Warm Hospital Cap', 'Cute Newborn 0-12 Months Baby Hat Boy Girl Beanies Cute Ears Bonnet Infant Cotton Hats Warm Hospital Cap', 58.00, 'https://cf.shopee.com.my/file/e3a9da90b5cdbeebf2eddaef8f765514', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1972, 'Boy fashion suit 0-4 tahun baju bunga budak lelaki musim panas bayi lelaki lengan pendek + seluar 2pcs pakaian kanak-kanak', 'Boy fashion suit 0-4 tahun baju bunga budak lelaki musim panas bayi lelaki lengan pendek + seluar 2pcs pakaian kanak-kanak', 'Boy fashion suit 0-4 tahun baju bunga budak lelaki musim panas bayi lelaki lengan pendek + seluar 2pcs pakaian kanak-kanak', 132.00, 'https://cf.shopee.com.my/file/93235f19fc71d1c0a9b8779f13019de5', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1973, 'YAMAHA YAMALUBE 20W50 4T High Performance MOTOR OIL 0.85L / 1L LITERS MINYAK HITAM 100% ORIGINAL ENGINE OILS', 'YAMAHA YAMALUBE 20W50 4T High Performance MOTOR OIL 0.85L / 1L LITERS MINYAK HITAM 100% ORIGINAL ENGINE OILS', 'YAMAHA YAMALUBE 20W50 4T High Performance MOTOR OIL 0.85L / 1L LITERS MINYAK HITAM 100% ORIGINAL ENGINE OILS', 132.00, 'https://cf.shopee.com.my/file/cd8ec6be72be686b59d5945390053d54', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1974, 'Children 0-3YRS Baby Beads Around Children 6-12 Month Initiation Toys 1-2-3 Year Old Educational Toys for Boys and Girls Early Building Blocks', 'Children 0-3YRS Baby Beads Around Children 6-12 Month Initiation Toys 1-2-3 Year Old Educational Toys for Boys and Girls Early Building Blocks', 'Children 0-3YRS Baby Beads Around Children 6-12 Month Initiation Toys 1-2-3 Year Old Educational Toys for Boys and Girls Early Building Blocks', 133.70, 'https://cf.shopee.com.my/file/67113fd3475ed6305e7481d6b700ab92', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1975, 'ORGINAL Twinzy Gray 14.5mm Contact Lens soft Lenses 0.Power-Power 100-800 Eyes Lens C61-5 Kanta Lekap', 'ORGINAL Twinzy Gray 14.5mm Contact Lens soft Lenses 0.Power-Power 100-800 Eyes Lens C61-5 Kanta Lekap', 'ORGINAL Twinzy Gray 14.5mm Contact Lens soft Lenses 0.Power-Power 100-800 Eyes Lens C61-5 Kanta Lekap', 89.00, 'https://cf.shopee.com.my/file/84f8944020ce7488d496a714dd53c07b', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1976, '0-2 Years Old Baby Clothing Short Sleeve Cartoon Printed Zipper Baby Boys Girls Rompers Jumpsuit', '0-2 Years Old Baby Clothing Short Sleeve Cartoon Printed Zipper Baby Boys Girls Rompers Jumpsuit', '0-2 Years Old Baby Clothing Short Sleeve Cartoon Printed Zipper Baby Boys Girls Rompers Jumpsuit', 259.80, 'https://cf.shopee.com.my/file/760561c152091c61769e296c0e715b7a', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1977, 'VFORCE 4 /3 V FORCE REED VALVE PLATE (1pc) 0.3mm 0.5mm Y125z / RXZ', 'VFORCE 4 /3 V FORCE REED VALVE PLATE (1pc) 0.3mm 0.5mm Y125z / RXZ', 'VFORCE 4 /3 V FORCE REED VALVE PLATE (1pc) 0.3mm 0.5mm Y125z / RXZ', 84.00, 'https://cf.shopee.com.my/file/a80ebdbd2906bfc06684070efcdd1b7e', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1978, '4pcs (0-1Y) Baby Legging Tight CR Comfort Stretchable Legging Pants (Random Colour) Baby Socks Seluar Tight', '4pcs (0-1Y) Baby Legging Tight CR Comfort Stretchable Legging Pants (Random Colour) Baby Socks Seluar Tight', '4pcs (0-1Y) Baby Legging Tight CR Comfort Stretchable Legging Pants (Random Colour) Baby Socks Seluar Tight', 249.80, 'https://cf.shopee.com.my/file/0b677d47c0cac5d2e967422900f3eca5', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1980, 'Beetopcom baby girl legging floral design soft cotton 0-18month baby ready stock', 'Beetopcom baby girl legging floral design soft cotton 0-18month baby ready stock', 'Beetopcom baby girl legging floral design soft cotton 0-18month baby ready stock', 69.00, 'https://cf.shopee.com.my/file/455bac0f398f792e30fd348a10c60115', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1981, 'Tommee Tippee Ultra Light Silicone Baby Soother Pacifier Puting 0-6m / 6-18m / 18-36m (Single Pack/ Twin Pack) Blue Pink', 'Tommee Tippee Ultra Light Silicone Baby Soother Pacifier Puting 0-6m / 6-18m / 18-36m (Single Pack/ Twin Pack) Blue Pink', 'Tommee Tippee Ultra Light Silicone Baby Soother Pacifier Puting 0-6m / 6-18m / 18-36m (Single Pack/ Twin Pack) Blue Pink', 179.00, 'https://cf.shopee.com.my/file/80caae5c97b37831124a79f3894c7063', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1982, 'EX5 DREAM WAVE 100 CLASS BLOCK ALLOY GASKET 0.3MM 0.5MM 0.8MM 1MM 1.5MM 2MM 3MM 4MM 5MM 6MM 59MM', 'EX5 DREAM WAVE 100 CLASS BLOCK ALLOY GASKET 0.3MM 0.5MM 0.8MM 1MM 1.5MM 2MM 3MM 4MM 5MM 6MM 59MM', 'EX5 DREAM WAVE 100 CLASS BLOCK ALLOY GASKET 0.3MM 0.5MM 0.8MM 1MM 1.5MM 2MM 3MM 4MM 5MM 6MM 59MM', 45.00, 'https://cf.shopee.com.my/file/1d2b4f60cd49154e549a876e232ecb30', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1984, 'Pilot Frixion Clicker 0.7mm Fine Erasable Roller Ball Gel Pen Refill', 'Pilot Frixion Clicker 0.7mm Fine Erasable Roller Ball Gel Pen Refill', 'Pilot Frixion Clicker 0.7mm Fine Erasable Roller Ball Gel Pen Refill', 29.00, 'https://cf.shopee.com.my/file/e2b3c9daad84749b55e98e2d3db7b7ca', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1986, 'NTN Japan # FRONT WHEEL BEARING # PERODUA KELISA 850/1.0,KENARI,MYVI 1.0/1.3 (2005-2011\"),VIVA 660/850/1.0/ELITE # G100', 'NTN Japan # FRONT WHEEL BEARING # PERODUA KELISA 850/1.0,KENARI,MYVI 1.0/1.3 (2005-2011\"),VIVA 660/850/1.0/ELITE # G100', 'NTN Japan # FRONT WHEEL BEARING # PERODUA KELISA 850/1.0,KENARI,MYVI 1.0/1.3 (2005-2011\"),VIVA 660/850/1.0/ELITE # G100', 343.30, 'https://cf.shopee.com.my/file/73fde74505e337d2b805b7aeafa2a323', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1987, 'Vtech Official Store Soothing Hippo Light Projector Crying Sensor New Born Baby Soothing Crib Toys 0/3/6/9 Months', 'Vtech Official Store Soothing Hippo Light Projector Crying Sensor New Born Baby Soothing Crib Toys 0/3/6/9 Months', 'Vtech Official Store Soothing Hippo Light Projector Crying Sensor New Born Baby Soothing Crib Toys 0/3/6/9 Months', 1039.00, 'https://cf.shopee.com.my/file/936d04ee8db6ed703f2dd42e41c00ece', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1988, 'Occ Dotstick 0.4ohm & 1.0ohm 1box(5pcs) Original !!', 'Occ Dotstick 0.4ohm & 1.0ohm 1box(5pcs) Original !!', 'Occ Dotstick 0.4ohm & 1.0ohm 1box(5pcs) Original !!', 539.90, 'https://cf.shopee.com.my/file/5b909e2b305a06532f57c844601f00c6', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1992, 'WD Western Digital My Passport Portable External Hard Disk USB 3.0/Slim Style/Social Friendly (1TB/2TB/4TB/5TB)', 'WD Western Digital My Passport Portable External Hard Disk USB 3.0/Slim Style/Social Friendly (1TB/2TB/4TB/5TB)', 'WD Western Digital My Passport Portable External Hard Disk USB 3.0/Slim Style/Social Friendly (1TB/2TB/4TB/5TB)', 1820.00, 'https://cf.shopee.com.my/file/10bfbdd0d5149c52fe6bc2485aaff051', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1993, 'Part Manwah Pla Plate 0.3mm 0.5mm 0.8mm 1.0mm 1.2mm 1.5mm Gundam Tools ABS Plastic Man wah Plastic Plate OMG Plaplate', 'Part Manwah Pla Plate 0.3mm 0.5mm 0.8mm 1.0mm 1.2mm 1.5mm Gundam Tools ABS Plastic Man wah Plastic Plate OMG Plaplate', 'Part Manwah Pla Plate 0.3mm 0.5mm 0.8mm 1.0mm 1.2mm 1.5mm Gundam Tools ABS Plastic Man wah Plastic Plate OMG Plaplate', 142.50, 'https://cf.shopee.com.my/file/32e483fd979d96a4432e3a29079d51ea', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1994, 'Sweet Cherry LB303 Dean Car Seat (0-18KG) *Ready Stock *', 'Sweet Cherry LB303 Dean Car Seat (0-18KG) *Ready Stock *', 'Sweet Cherry LB303 Dean Car Seat (0-18KG) *Ready Stock *', 2100.00, 'https://cf.shopee.com.my/file/7ae8fdbfdead270c7d288da7a9d2e225', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1995, 'SKMY 3.75\'\' Universal Car Tachometer Tacho Gauge Meter LED Shift Light 0-8000 RPM ShaKang', 'SKMY 3.75\'\' Universal Car Tachometer Tacho Gauge Meter LED Shift Light 0-8000 RPM ShaKang', 'SKMY 3.75\'\' Universal Car Tachometer Tacho Gauge Meter LED Shift Light 0-8000 RPM ShaKang', 397.80, 'https://cf.shopee.com.my/file/26c1f3a78cf22a9fef1aa0f53ed34a67', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1996, '0-5Y Baby Kid Set Pajamas Pyjamas Long Sleeve Long Pants Boy Girl Kids Sleepwear Baju Bayi QY007', '0-5Y Baby Kid Set Pajamas Pyjamas Long Sleeve Long Pants Boy Girl Kids Sleepwear Baju Bayi QY007', '0-5Y Baby Kid Set Pajamas Pyjamas Long Sleeve Long Pants Boy Girl Kids Sleepwear Baju Bayi QY007', 62.80, 'https://cf.shopee.com.my/file/4a92a0668304ca34d1676f2581922f13', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1997, '[Gundam Gang] UStar Chisel 0.1mm 0.2mm 0.3mm 0.5mm 0.8mm Panel Line Crafting Modification', '[Gundam Gang] UStar Chisel 0.1mm 0.2mm 0.3mm 0.5mm 0.8mm Panel Line Crafting Modification', '[Gundam Gang] UStar Chisel 0.1mm 0.2mm 0.3mm 0.5mm 0.8mm Panel Line Crafting Modification', 180.00, 'https://cf.shopee.com.my/file/9586d5d4ccbe07c9da0a5ebb30ab633e', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (1999, '3 PSG HELAI BAJU BABY INFANT SUIT 3 IN 1 SET 0 - 6 BULAN SUMMER FASHION SUIT', '3 PSG HELAI BAJU BABY INFANT SUIT 3 IN 1 SET 0 - 6 BULAN SUMMER FASHION SUIT', '3 PSG HELAI BAJU BABY INFANT SUIT 3 IN 1 SET 0 - 6 BULAN SUMMER FASHION SUIT', 190.00, 'https://cf.shopee.com.my/file/fa5e67ca90bce3b790b241cac73b362d', 1627909681, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2001, '[PALING MURAH!] Bubble Wrap Roll Single layer / Clear - AAA High Quality (0.5MX0.5M / 0.5MX1M / 1MX1M)', '[PALING MURAH!] Bubble Wrap Roll Single layer / Clear - AAA High Quality (0.5MX0.5M / 0.5MX1M / 1MX1M)', '[PALING MURAH!] Bubble Wrap Roll Single layer / Clear - AAA High Quality (0.5MX0.5M / 0.5MX1M / 1MX1M)', 4.70, 'https://cf.shopee.com.my/file/d4a0cd93af51fde888a0695d57bc0804', 1627909682, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2002, 'ORIGINAL SMOK ACRO KIT POD CARTRIDGE MESH 0.8', 'ORIGINAL SMOK ACRO KIT POD CARTRIDGE MESH 0.8', 'ORIGINAL SMOK ACRO KIT POD CARTRIDGE MESH 0.8', 270.00, 'https://cf.shopee.com.my/file/23c7ab630615d17059092448723e56dd', 1627909682, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2004, 'XIAOMI KACO PURE GEL PEN 0.5mm SMOOTH INK 5PCS/PACK', 'XIAOMI KACO PURE GEL PEN 0.5mm SMOOTH INK 5PCS/PACK', 'XIAOMI KACO PURE GEL PEN 0.5mm SMOOTH INK 5PCS/PACK', 69.90, 'https://cf.shopee.com.my/file/e9ac7f8c9784a2cd17edd4a9d80c304a', 1627909682, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2007, 'HT Button Cap Screw - M3 x 6mm ~ 30mm (Coarse Thread Pitch 0.5mm) (High Tensile Socket Button Allen Bolt)', 'HT Button Cap Screw - M3 x 6mm ~ 30mm (Coarse Thread Pitch 0.5mm) (High Tensile Socket Button Allen Bolt)', 'HT Button Cap Screw - M3 x 6mm ~ 30mm (Coarse Thread Pitch 0.5mm) (High Tensile Socket Button Allen Bolt)', 2.00, 'https://cf.shopee.com.my/file/07ea470cdc632ffc6f7b5d6e145dd1c3', 1627909682, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2008, '(REFILL) 0.5mm/0.7mm Zebra Sarasa Clip Gel Pen Refill, Zebra JF Refill', '(REFILL) 0.5mm/0.7mm Zebra Sarasa Clip Gel Pen Refill, Zebra JF Refill', '(REFILL) 0.5mm/0.7mm Zebra Sarasa Clip Gel Pen Refill, Zebra JF Refill', 27.80, 'https://cf.shopee.com.my/file/12876eb5b49aee543bfcb6c36e1d2ef7', 1627909682, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2009, '1pc Pink Unicorn Gel Pen Cute Cartoon Gel Pen 0.5mm Office School Stationery Door Gift', '1pc Pink Unicorn Gel Pen Cute Cartoon Gel Pen 0.5mm Office School Stationery Door Gift', '1pc Pink Unicorn Gel Pen Cute Cartoon Gel Pen 0.5mm Office School Stationery Door Gift', 5.90, 'https://cf.shopee.com.my/file/dea1a089f65062d4faf5e95db64d1d55', 1627909682, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2010, 'Test good gel pen 0.5mm 1pcs', 'Test good gel pen 0.5mm 1pcs', 'Test good gel pen 0.5mm 1pcs', 6.20, 'https://cf.shopee.com.my/file/9a16bf668dfdcbd1288c089aa7ca68a3', 1627909682, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2011, 'Pilot G2 Gel Ink color Pen 0.7mm 1pcs', 'Pilot G2 Gel Ink color Pen 0.7mm 1pcs', 'Pilot G2 Gel Ink color Pen 0.7mm 1pcs', 43.50, 'https://cf.shopee.com.my/file/0e9546b2380896f3d39060b38fdad954', 1627909682, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2012, 'Apple Ipad Pro 11.0 12.9 Air Mini 2 3 4 5 7 8 2017 2018 2019 2020 2021 Soft Camera Tempered Glass Protector', 'Apple Ipad Pro 11.0 12.9 Air Mini 2 3 4 5 7 8 2017 2018 2019 2020 2021 Soft Camera Tempered Glass Protector', 'Apple Ipad Pro 11.0 12.9 Air Mini 2 3 4 5 7 8 2017 2018 2019 2020 2021 Soft Camera Tempered Glass Protector', 69.00, 'https://cf.shopee.com.my/file/eeca02733a1d315e7945f40e342400e7', 1627909682, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2013, 'Faber Castell RX Gel 0.38/0.5/0.7mm 1pc', 'Faber Castell RX Gel 0.38/0.5/0.7mm 1pc', 'Faber Castell RX Gel 0.38/0.5/0.7mm 1pc', 13.00, 'https://cf.shopee.com.my/file/f00a038cd56fe62b2aa255f5700e1e9b', 1627909682, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2014, 'Angel 16.5mm(eff 17.5mm) Big eyes Contact Lens/Color Lens/Korea Lens (P-0.00 till P-10.00) Free Case', 'Angel 16.5mm(eff 17.5mm) Big eyes Contact Lens/Color Lens/Korea Lens (P-0.00 till P-10.00) Free Case', 'Angel 16.5mm(eff 17.5mm) Big eyes Contact Lens/Color Lens/Korea Lens (P-0.00 till P-10.00) Free Case', 99.00, 'https://cf.shopee.com.my/file/2fca8e520307bd77a89f467ecfa25a7a', 1627909682, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2015, 'Kapsul Kosong HALAL Size 0 (1000pcs) / Nashmir Empty Gelatin Capsule / Empty Capsule', 'Kapsul Kosong HALAL Size 0 (1000pcs) / Nashmir Empty Gelatin Capsule / Empty Capsule', 'Kapsul Kosong HALAL Size 0 (1000pcs) / Nashmir Empty Gelatin Capsule / Empty Capsule', 119.50, 'https://cf.shopee.com.my/file/3c939726686e0617240e9c97f630c9d5', 1627909682, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2016, '(New Vession) GSOFT WX2 0.4MM RETRACTABLE BALL PEN', '(New Vession) GSOFT WX2 0.4MM RETRACTABLE BALL PEN', '(New Vession) GSOFT WX2 0.4MM RETRACTABLE BALL PEN', 8.00, 'https://cf.shopee.com.my/file/601b5df4b5131d4e97aa9a1993f48000', 1627909682, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2017, 'Pilot Color Eno Erasable Mechanical Pencils 0.7MM (Per Pcs, Free 2 pcs Colour Leads)', 'Pilot Color Eno Erasable Mechanical Pencils 0.7MM (Per Pcs, Free 2 pcs Colour Leads)', 'Pilot Color Eno Erasable Mechanical Pencils 0.7MM (Per Pcs, Free 2 pcs Colour Leads)', 53.00, 'https://cf.shopee.com.my/file/29f4c9f67a1058bd4ff2017ac7bb4dc5', 1627909682, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2018, 'Original Smok Rpm 40 Replacements Coils Occ 0.4 Mesh / Occ 0.6 Triple / Occ 0.3 Mesh', 'Original Smok Rpm 40 Replacements Coils Occ 0.4 Mesh / Occ 0.6 Triple / Occ 0.3 Mesh', 'Original Smok Rpm 40 Replacements Coils Occ 0.4 Mesh / Occ 0.6 Triple / Occ 0.3 Mesh', 90.00, 'https://cf.shopee.com.my/file/d5a51e990a47d7a96eef37d950f14d4e', 1627909682, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2021, 'llano 2.5 inch Transparent HDD Case SATA to USB3.0 Hard Disk Case 5Gbps 6TB SSD HDD Enclosure with Auto Sleep', 'llano 2.5 inch Transparent HDD Case SATA to USB3.0 Hard Disk Case 5Gbps 6TB SSD HDD Enclosure with Auto Sleep', 'llano 2.5 inch Transparent HDD Case SATA to USB3.0 Hard Disk Case 5Gbps 6TB SSD HDD Enclosure with Auto Sleep', 238.80, 'https://cf.shopee.com.my/file/b907574b9ed6ceb82a3ab6621862f000', 1627909682, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2022, 'Pilot Pop Lol 0.7mm Gel Pen (Part 2)', 'Pilot Pop Lol 0.7mm Gel Pen (Part 2)', 'Pilot Pop Lol 0.7mm Gel Pen (Part 2)', 29.90, 'https://cf.shopee.com.my/file/3bbc90b5b062687fb67e6b8af7af4bee', 1627909682, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2023, '100% Original Artery Pal II Replacement 5pcs Occ 0.6Ohm Mesh/ Occ 1.2Ohm Regular Coil Vape', '100% Original Artery Pal II Replacement 5pcs Occ 0.6Ohm Mesh/ Occ 1.2Ohm Regular Coil Vape', '100% Original Artery Pal II Replacement 5pcs Occ 0.6Ohm Mesh/ Occ 1.2Ohm Regular Coil Vape', 230.00, 'https://cf.shopee.com.my/file/096bf097e52121746a089623b317a31e', 1627909682, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2024, 'Bayer Advantage Cat Spot On S (0.4ML x 4 pipet) | M (0.8ML x 4 pipet) (UBAT KUTU)', 'Bayer Advantage Cat Spot On S (0.4ML x 4 pipet) | M (0.8ML x 4 pipet) (UBAT KUTU)', 'Bayer Advantage Cat Spot On S (0.4ML x 4 pipet) | M (0.8ML x 4 pipet) (UBAT KUTU)', 120.00, 'https://cf.shopee.com.my/file/6af1af42bde00a70d1dcd5890899cad7', 1627909682, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2025, 'Pilot G2 Gel Ink Pen 0.5mm', 'Pilot G2 Gel Ink Pen 0.5mm', 'Pilot G2 Gel Ink Pen 0.5mm', 35.40, 'https://cf.shopee.com.my/file/b78209801b1c208ebae89d7e215ebfc8', 1627909682, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2026, 'DUTCHBABY 0-12M/6-18M 850g Exp:06/2022', 'DUTCHBABY 0-12M/6-18M 850g Exp:06/2022', 'DUTCHBABY 0-12M/6-18M 850g Exp:06/2022', 271.00, 'https://cf.shopee.com.my/file/b66fa513fac5b54b0e1deb2d7d044db1', 1627909682, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2028, 'Mig welding MB15 NOZZLE / TIP HOLDER / CONTACT TIP 0.8MM / CONTACT TIP 1.0MM', 'Mig welding MB15 NOZZLE / TIP HOLDER / CONTACT TIP 0.8MM / CONTACT TIP 1.0MM', 'Mig welding MB15 NOZZLE / TIP HOLDER / CONTACT TIP 0.8MM / CONTACT TIP 1.0MM', 6.00, 'https://cf.shopee.com.my/file/3fb4f8eab82d7497837b5cd58bb564f2', 1627909682, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2029, '[READY STOCK] Original Voopoo PnP Coil Vinci/Vinci X/Navi/Drag X/Drag S OCC 0.3/0.45/0.6/0.8/1.2 5pcs Per Pack', '[READY STOCK] Original Voopoo PnP Coil Vinci/Vinci X/Navi/Drag X/Drag S OCC 0.3/0.45/0.6/0.8/1.2 5pcs Per Pack', '[READY STOCK] Original Voopoo PnP Coil Vinci/Vinci X/Navi/Drag X/Drag S OCC 0.3/0.45/0.6/0.8/1.2 5pcs Per Pack', 380.00, 'https://cf.shopee.com.my/file/69f787ac849aabe9f2d1cdbcf8d76375', 1627909682, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2030, '6mm BB Mainan Manik 6mm 0.12g (2000pcs)', '6mm BB Mainan Manik 6mm 0.12g (2000pcs)', '6mm BB Mainan Manik 6mm 0.12g (2000pcs)', 88.00, 'https://cf.shopee.com.my/file/dab33c260015af5acdbb4ff9913c01dd', 1627909682, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2031, '1pc Cute Crystal Bunny Rabbit Gel Pen 0.5mm Black Ink Office School Stationery', '1pc Cute Crystal Bunny Rabbit Gel Pen 0.5mm Black Ink Office School Stationery', '1pc Cute Crystal Bunny Rabbit Gel Pen 0.5mm Black Ink Office School Stationery', 5.00, 'https://cf.shopee.com.my/file/e8e2e57865bdae374680e3e8baf1f362', 1627909682, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2032, 'Original Nevoks Feelin Occ. Nevoks Pagee Coil. 0.6ohm 1.0ohm', 'Original Nevoks Feelin Occ. Nevoks Pagee Coil. 0.6ohm 1.0ohm', 'Original Nevoks Feelin Occ. Nevoks Pagee Coil. 0.6ohm 1.0ohm', 430.00, 'https://cf.shopee.com.my/file/e7080675fb388ec3d67829ad7d6ffd2a', 1627909682, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2034, 'Pilot Wingel 0.5MM Gel Pen', 'Pilot Wingel 0.5MM Gel Pen', 'Pilot Wingel 0.5MM Gel Pen', 24.00, 'https://cf.shopee.com.my/file/616885626ef41fc9ec4035ad78867634', 1627909682, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2035, '(0.04sen/Page) Printing Service | A4 A5 Black & White Double Sided Paper | Print | Photocopy | Photostat | Book Printing', '(0.04sen/Page) Printing Service | A4 A5 Black & White Double Sided Paper | Print | Photocopy | Photostat | Book Printing', '(0.04sen/Page) Printing Service | A4 A5 Black & White Double Sided Paper | Print | Photocopy | Photostat | Book Printing', 1.00, 'https://cf.shopee.com.my/file/e0049f4dae09081fef87bd3d2a3e8427', 1627909682, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2036, '5-seater (full set) seat cover-WIRA/ISWARA/SAGA OLD/ SAGA BLM/FLX car 9PCS front + rear full surround 5-seater seat cover cushion 4/5 headrest cover universal seat cover waterproof, dirt-resistant and durable 0', '5-seater (full set) seat cover-WIRA/ISWARA/SAGA OLD/ SAGA BLM/FLX car 9PCS front + rear full surround 5-seater seat cover cushion 4/5 headrest cover universal seat cover waterproof, dirt-resistant and durable 0', '5-seater (full set) seat cover-WIRA/ISWARA/SAGA OLD/ SAGA BLM/FLX car 9PCS front + rear full surround 5-seater seat cover cushion 4/5 headrest cover universal seat cover waterproof, dirt-resistant and durable 0', 399.00, 'https://cf.shopee.com.my/file/0d04a879eeac88cff49d857478cd4be7', 1627909682, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2037, 'Leo 205 0.5UK-9.5UK(31-44)/ Nanyang Style/ Shoes Kasut Sekolah School Takraw', 'Leo 205 0.5UK-9.5UK(31-44)/ Nanyang Style/ Shoes Kasut Sekolah School Takraw', 'Leo 205 0.5UK-9.5UK(31-44)/ Nanyang Style/ Shoes Kasut Sekolah School Takraw', 259.00, 'https://cf.shopee.com.my/file/2bfdbae2802883082e981424667d6f38', 1627909682, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2038, 'Pilot Polymer Pencil Leads / Begreen Leads 12Leads 0.3/0.5/0.7/0.9mm Mechanical Pencil Lead', 'Pilot Polymer Pencil Leads / Begreen Leads 12Leads 0.3/0.5/0.7/0.9mm Mechanical Pencil Lead', 'Pilot Polymer Pencil Leads / Begreen Leads 12Leads 0.3/0.5/0.7/0.9mm Mechanical Pencil Lead', 10.00, 'https://cf.shopee.com.my/file/8cc2eb34c9fd2524e7b0bc71869ff854', 1627909682, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2039, '20PCS 0.8MM / 1.0MM CONTACT TIP CONDUCTIVE NOZZLE FOR 15AK MIG/MAG WELDING TORCH CONSUMABLES', '20PCS 0.8MM / 1.0MM CONTACT TIP CONDUCTIVE NOZZLE FOR 15AK MIG/MAG WELDING TORCH CONSUMABLES', '20PCS 0.8MM / 1.0MM CONTACT TIP CONDUCTIVE NOZZLE FOR 15AK MIG/MAG WELDING TORCH CONSUMABLES', 93.50, 'https://cf.shopee.com.my/file/77de02d2d1d091eac9d637ce3772c846', 1627909682, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2040, 'PENTEL ENERGEL X RETRACTABLE GEL ROLLER PEN 0.5/0.7/1.0mm', 'PENTEL ENERGEL X RETRACTABLE GEL ROLLER PEN 0.5/0.7/1.0mm', 'PENTEL ENERGEL X RETRACTABLE GEL ROLLER PEN 0.5/0.7/1.0mm', 33.00, 'https://cf.shopee.com.my/file/dafbda523c68f8e0b017b7e90b8c733d', 1627909683, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2041, 'ORICO HDD Case Type-C USB3.1 to SATA3.0 2.5\" USB 3.1 Gen1 SSD HDD Enclosure 5Gbps 4TB HDD Enclosure Box Support UASP Auto Sleep (2526C3)', 'ORICO HDD Case Type-C USB3.1 to SATA3.0 2.5\" USB 3.1 Gen1 SSD HDD Enclosure 5Gbps 4TB HDD Enclosure Box Support UASP Auto Sleep (2526C3)', 'ORICO HDD Case Type-C USB3.1 to SATA3.0 2.5\" USB 3.1 Gen1 SSD HDD Enclosure 5Gbps 4TB HDD Enclosure Box Support UASP Auto Sleep (2526C3)', 259.90, 'https://cf.shopee.com.my/file/74d1d08589812ffe18b7b54dcc1004ec', 1627909683, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2043, '0.3mm Ultra Thin Hard Soft Case For iPhone 12 mini 11 Pro X Xr Xs Max Matte PP Plastic Back Cover For iPhone SE 2 6 6S 7 8 Plus Case', '0.3mm Ultra Thin Hard Soft Case For iPhone 12 mini 11 Pro X Xr Xs Max Matte PP Plastic Back Cover For iPhone SE 2 6 6S 7 8 Plus Case', '0.3mm Ultra Thin Hard Soft Case For iPhone 12 mini 11 Pro X Xr Xs Max Matte PP Plastic Back Cover For iPhone SE 2 6 6S 7 8 Plus Case', 19.60, 'https://cf.shopee.com.my/file/059f4a0d16a7aa699851ae0dc52546d4', 1627909683, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2044, '0.25m/0.5m/1m/2m/3m Type C 5A Super Fast Charging Data Cable For Android Huawei Samsung Xiaomi', '0.25m/0.5m/1m/2m/3m Type C 5A Super Fast Charging Data Cable For Android Huawei Samsung Xiaomi', '0.25m/0.5m/1m/2m/3m Type C 5A Super Fast Charging Data Cable For Android Huawei Samsung Xiaomi', 20.00, 'https://cf.shopee.com.my/file/f6fecc0c304f1d9082090d354812b4f8', 1627909683, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2046, 'COPPER PIPE ( COPPER TUBE ) THICKNESS 0.61mm UR / ACSON / METTUBE FOR AIR COND (WITH SIRIM) PER COIL', 'COPPER PIPE ( COPPER TUBE ) THICKNESS 0.61mm UR / ACSON / METTUBE FOR AIR COND (WITH SIRIM) PER COIL', 'COPPER PIPE ( COPPER TUBE ) THICKNESS 0.61mm UR / ACSON / METTUBE FOR AIR COND (WITH SIRIM) PER COIL', 799.00, 'https://cf.shopee.com.my/file/d0e7330b9393d867e3a6933bc0966d02', 1627909683, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2047, 'Bausch & Lomb Soflens 59 Monthly Contact Lenses - Power -0.50 to -9.00 (6 Pcs)', 'Bausch & Lomb Soflens 59 Monthly Contact Lenses - Power -0.50 to -9.00 (6 Pcs)', 'Bausch & Lomb Soflens 59 Monthly Contact Lenses - Power -0.50 to -9.00 (6 Pcs)', 354.90, 'https://cf.shopee.com.my/file/4aa2df884ede55b572631a4d956ce59c', 1627909683, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2048, 'Baby boy clothes boy suit 0-5 tahun kanak-kanak kartun spiderman lengan pendek T-shirt + seluar pendek  2-piece set', 'Baby boy clothes boy suit 0-5 tahun kanak-kanak kartun spiderman lengan pendek T-shirt + seluar pendek  2-piece set', 'Baby boy clothes boy suit 0-5 tahun kanak-kanak kartun spiderman lengan pendek T-shirt + seluar pendek  2-piece set', 139.00, 'https://cf.shopee.com.my/file/69ab8ae9a417aa01180133d8a7396436', 1627909683, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2049, 'Pentel Energel-X Roller Pen Refill 0.5/0.7/1.0mm', 'Pentel Energel-X Roller Pen Refill 0.5/0.7/1.0mm', 'Pentel Energel-X Roller Pen Refill 0.5/0.7/1.0mm', 26.00, 'https://cf.shopee.com.my/file/6ca81733a9e87fb3bb8b6a1bde252f1b', 1627909683, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2050, 'ORGINAL Sugar Candy 14.5MM brown Contact Lens Lenses 0.Degree (Big Eyes Lens)B30 kanta lekap', 'ORGINAL Sugar Candy 14.5MM brown Contact Lens Lenses 0.Degree (Big Eyes Lens)B30 kanta lekap', 'ORGINAL Sugar Candy 14.5MM brown Contact Lens Lenses 0.Degree (Big Eyes Lens)B30 kanta lekap', 88.50, 'https://cf.shopee.com.my/file/1131d4c69d6d3b7a7ad396f2b8bca07b', 1627909683, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2051, 'Pilot G2 Gel Pen Refill - 0.38mm/0.5mm/0.7mm/1.0mm', 'Pilot G2 Gel Pen Refill - 0.38mm/0.5mm/0.7mm/1.0mm', 'Pilot G2 Gel Pen Refill - 0.38mm/0.5mm/0.7mm/1.0mm', 29.00, 'https://cf.shopee.com.my/file/fff18852f72e0e8045048d6977138750', 1627909683, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2052, 'Baju Baby Girl Clothes Kids Short Sleeve Tshirt Summer Baby Girls Cartoon Cotton Top Cute Shirt 0-5Y', 'Baju Baby Girl Clothes Kids Short Sleeve Tshirt Summer Baby Girls Cartoon Cotton Top Cute Shirt 0-5Y', 'Baju Baby Girl Clothes Kids Short Sleeve Tshirt Summer Baby Girls Cartoon Cotton Top Cute Shirt 0-5Y', 59.80, 'https://cf.shopee.com.my/file/b7fa1bb09937d856a8586d5dd5ed098f', 1627909683, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2054, 'Baby Romper Boy Girl Romper Baby Boy Girl Baju Baby Boy Girl ( 0 - 24 months ) Baju Baby Lelaki Perempuan Baby Jumpsuit', 'Baby Romper Boy Girl Romper Baby Boy Girl Baju Baby Boy Girl ( 0 - 24 months ) Baju Baby Lelaki Perempuan Baby Jumpsuit', 'Baby Romper Boy Girl Romper Baby Boy Girl Baju Baby Boy Girl ( 0 - 24 months ) Baju Baby Lelaki Perempuan Baby Jumpsuit', 84.50, 'https://cf.shopee.com.my/file/38d0074b65fbce521133860d16b508f5', 1627909683, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2055, 'Innisfree Auto Eyebrow Pencil 0.3g (7 Colors To Choose)', 'Innisfree Auto Eyebrow Pencil 0.3g (7 Colors To Choose)', 'Innisfree Auto Eyebrow Pencil 0.3g (7 Colors To Choose)', 119.00, 'https://cf.shopee.com.my/file/649710211109db90755b987b516ba78d', 1627909683, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2056, 'Pilot G-Tec 0.25mm / 0.3mm / 0.4mm Roller Ball pen / Hi-Tec 0.5mm', 'Pilot G-Tec 0.25mm / 0.3mm / 0.4mm Roller Ball pen / Hi-Tec 0.5mm', 'Pilot G-Tec 0.25mm / 0.3mm / 0.4mm Roller Ball pen / Hi-Tec 0.5mm', 58.50, 'https://cf.shopee.com.my/file/0967c70861793174cef84a505a4b940f', 1627909683, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2057, 'Original Smok RPM 40 Built-in 1500mAh battery 4.3ml Cartridge / Rba / 0.4ohm Mesh Coil / 1.0ohm SC Coil Rpm40', 'Original Smok RPM 40 Built-in 1500mAh battery 4.3ml Cartridge / Rba / 0.4ohm Mesh Coil / 1.0ohm SC Coil Rpm40', 'Original Smok RPM 40 Built-in 1500mAh battery 4.3ml Cartridge / Rba / 0.4ohm Mesh Coil / 1.0ohm SC Coil Rpm40', 350.00, 'https://cf.shopee.com.my/file/59249a2c2fd1b3da7343f4936c587f79', 1627909683, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2058, '1 X 100M Single / Double Layer Bubble Wrap Roll 1M / 0.5M (2) / 0.33M(3) / 0.25 x 100M (4)', '1 X 100M Single / Double Layer Bubble Wrap Roll 1M / 0.5M (2) / 0.33M(3) / 0.25 x 100M (4)', '1 X 100M Single / Double Layer Bubble Wrap Roll 1M / 0.5M (2) / 0.33M(3) / 0.25 x 100M (4)', 700.00, 'https://cf.shopee.com.my/file/c59b67676792f377f6917cf6081e793c', 1627909683, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2059, 'Faber-Castell True Gel Pen Water-Proof 0.5MM/0.7MM - (1\'s)', 'Faber-Castell True Gel Pen Water-Proof 0.5MM/0.7MM - (1\'s)', 'Faber-Castell True Gel Pen Water-Proof 0.5MM/0.7MM - (1\'s)', 19.00, 'https://cf.shopee.com.my/file/188c228f28308a0ab5602be66ddbb39e', 1627909683, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2060, 'Pilot Mechanical Pencil Rexgrip Supergrip Progrex Shaker 2020 0.5mm 0.7mm (Pensil Mekanik)', 'Pilot Mechanical Pencil Rexgrip Supergrip Progrex Shaker 2020 0.5mm 0.7mm (Pensil Mekanik)', 'Pilot Mechanical Pencil Rexgrip Supergrip Progrex Shaker 2020 0.5mm 0.7mm (Pensil Mekanik)', 88.80, 'https://cf.shopee.com.my/file/11fdc2292fae4db9d11923f51744d0fa', 1627909683, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2061, '1 Meter  Plastik SILVERSHINE UV 0.03MM Penutup Batas Tanah Tanaman Konvensional & Fertigasi', '1 Meter  Plastik SILVERSHINE UV 0.03MM Penutup Batas Tanah Tanaman Konvensional & Fertigasi', '1 Meter  Plastik SILVERSHINE UV 0.03MM Penutup Batas Tanah Tanaman Konvensional & Fertigasi', 5.50, 'https://cf.shopee.com.my/file/b69a56c0ee0004c597eb36db5e3a1497', 1627909683, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2062, 'USB3.0 2.5\" Laptop Notebook Hard Disk Case External Plastic Casing Box ( Internal HDD SSD to External )', 'USB3.0 2.5\" Laptop Notebook Hard Disk Case External Plastic Casing Box ( Internal HDD SSD to External )', 'USB3.0 2.5\" Laptop Notebook Hard Disk Case External Plastic Casing Box ( Internal HDD SSD to External )', 220.00, 'https://cf.shopee.com.my/file/32943d865e774c11309cfef48157a1aa', 1627909683, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2063, 'Kids clothes (0-5 year old) baby girls boys 100% cotton cartoon cute casual pants', 'Kids clothes (0-5 year old) baby girls boys 100% cotton cartoon cute casual pants', 'Kids clothes (0-5 year old) baby girls boys 100% cotton cartoon cute casual pants', 75.70, 'https://cf.shopee.com.my/file/77276f4a6506c3bf0bff558892687c23', 1627909683, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2065, 'OPTIBEST Thermos Cup Thermos Mug Thermal Cup 304 Stainless Steel Cup Mug Insulation Cup Vacuum Cup Termos 0.45L', 'OPTIBEST Thermos Cup Thermos Mug Thermal Cup 304 Stainless Steel Cup Mug Insulation Cup Vacuum Cup Termos 0.45L', 'OPTIBEST Thermos Cup Thermos Mug Thermal Cup 304 Stainless Steel Cup Mug Insulation Cup Vacuum Cup Termos 0.45L', 368.00, 'https://cf.shopee.com.my/file/48c981aa99f4b71b9c9ee590fc63428e', 1627909683, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2068, 'Staedtler Ball Pen Fine Tip 4273F 0.7MM - (1\'pc)', 'Staedtler Ball Pen Fine Tip 4273F 0.7MM - (1\'pc)', 'Staedtler Ball Pen Fine Tip 4273F 0.7MM - (1\'pc)', 4.90, 'https://cf.shopee.com.my/file/a47d6e4f858027005cf846fbb598f773', 1627909683, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2069, 'VR Glasses Shinecon6.0 Bluetooth Headset Helmet 3D Box With Bluetooth Controller', 'VR Glasses Shinecon6.0 Bluetooth Headset Helmet 3D Box With Bluetooth Controller', 'VR Glasses Shinecon6.0 Bluetooth Headset Helmet 3D Box With Bluetooth Controller', 764.90, 'https://cf.shopee.com.my/file/30489eb81fa22225f4507f8688965d70', 1627909683, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2070, 'MAM Silk Teat (Size 0, Size 1, Size 2, Size 3, Spill Free, Size X)', 'MAM Silk Teat (Size 0, Size 1, Size 2, Size 3, Spill Free, Size X)', 'MAM Silk Teat (Size 0, Size 1, Size 2, Size 3, Spill Free, Size X)', 250.00, 'https://cf.shopee.com.my/file/1b705eae9190bd07385056dc52b5a6f9', 1627909683, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2071, '[ READY STOCK ] Rigid Sheet A2, A3 - 0.5mm Thick Plastic Binding Cover Clear PVC Craft Materials DIY Drawing Picture', '[ READY STOCK ] Rigid Sheet A2, A3 - 0.5mm Thick Plastic Binding Cover Clear PVC Craft Materials DIY Drawing Picture', '[ READY STOCK ] Rigid Sheet A2, A3 - 0.5mm Thick Plastic Binding Cover Clear PVC Craft Materials DIY Drawing Picture', 69.00, 'https://cf.shopee.com.my/file/3c5e96b6c52412425a5f73ccea1422c8', 1627909683, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2072, '(1PCS) BLACK Insulating Tape 0.12mm x 18mm /tape elektrik', '(1PCS) BLACK Insulating Tape 0.12mm x 18mm /tape elektrik', '(1PCS) BLACK Insulating Tape 0.12mm x 18mm /tape elektrik', 4.00, 'https://cf.shopee.com.my/file/78fadefb1596b8ceb4a3eb7b13a9b19b', 1627909683, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2073, 'PILOT WINGEL GEL PEN / PILOT WINGEL GEL PEN REFILL / PILOT WINGEL REFILL (0.38MM/ 0.5MM/ 0.7MM) (READY STOCK)', 'PILOT WINGEL GEL PEN / PILOT WINGEL GEL PEN REFILL / PILOT WINGEL REFILL (0.38MM/ 0.5MM/ 0.7MM) (READY STOCK)', 'PILOT WINGEL GEL PEN / PILOT WINGEL GEL PEN REFILL / PILOT WINGEL REFILL (0.38MM/ 0.5MM/ 0.7MM) (READY STOCK)', 18.00, 'https://cf.shopee.com.my/file/ce17eb0c3fd80e9e0a4da2d6836a4a9d', 1627909683, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2075, 'Faber-Castell ECO Gel Pen 0.5mm / 0.7mm Faber Castell', 'Faber-Castell ECO Gel Pen 0.5mm / 0.7mm Faber Castell', 'Faber-Castell ECO Gel Pen 0.5mm / 0.7mm Faber Castell', 11.00, 'https://cf.shopee.com.my/file/0727f34f2a7c076aa67e2d9d066a2789', 1627909683, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2076, 'Faster CX445N Jawi Ball Pen 0.5mm', 'Faster CX445N Jawi Ball Pen 0.5mm', 'Faster CX445N Jawi Ball Pen 0.5mm', 5.00, 'https://cf.shopee.com.my/file/8d693ca1d2798a85b62632bf020a2997', 1627909683, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2077, 'Johnson Fitness Horizon TR3.0 Treadmill', 'Johnson Fitness Horizon TR3.0 Treadmill', 'Johnson Fitness Horizon TR3.0 Treadmill', 17880.00, 'https://cf.shopee.com.my/file/e138deff936d95e906fec3dc1222a623', 1627909683, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2078, '[RM 0.99 AFTER SHOPEE COIN REBATE] Baby Teat Soft Sponge Cleaning Brush', '[RM 0.99 AFTER SHOPEE COIN REBATE] Baby Teat Soft Sponge Cleaning Brush', '[RM 0.99 AFTER SHOPEE COIN REBATE] Baby Teat Soft Sponge Cleaning Brush', 11.00, 'https://cf.shopee.com.my/file/dbbc1170d85069d291d64d73cacbe014', 1627909683, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2079, '0.3M/1.5M/3M/5M/10M High Speed USB 2.0 Extension Cable AM to AF', '0.3M/1.5M/3M/5M/10M High Speed USB 2.0 Extension Cable AM to AF', '0.3M/1.5M/3M/5M/10M High Speed USB 2.0 Extension Cable AM to AF', 28.50, 'https://cf.shopee.com.my/file/9215794e3cfaffcb20e8edb6d3b80514', 1627909683, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2080, 'Have Stock 0-24M Newborn Cloth Cotton Bodysuit Baby Infant Romper Summer Short Clothes Babies Jumpsuit Cloth', 'Have Stock 0-24M Newborn Cloth Cotton Bodysuit Baby Infant Romper Summer Short Clothes Babies Jumpsuit Cloth', 'Have Stock 0-24M Newborn Cloth Cotton Bodysuit Baby Infant Romper Summer Short Clothes Babies Jumpsuit Cloth', 39.90, 'https://cf.shopee.com.my/file/900800f94b230d258e08f5e05f3861eb', 1627909683, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2082, '[KAIN PASANG PRINTED] SONGKET MATCHING - SB Line Printed Bidang 45\" (0.5M)', '[KAIN PASANG PRINTED] SONGKET MATCHING - SB Line Printed Bidang 45\" (0.5M)', '[KAIN PASANG PRINTED] SONGKET MATCHING - SB Line Printed Bidang 45\" (0.5M)', 37.50, 'https://cf.shopee.com.my/file/2503642bd85a168e13393ccef8b32491', 1627909683, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2083, 'RESTOCK 16-07-2021 !!! Baby Toys Plush Stuff Newborn (0-12months)', 'RESTOCK 16-07-2021 !!! Baby Toys Plush Stuff Newborn (0-12months)', 'RESTOCK 16-07-2021 !!! Baby Toys Plush Stuff Newborn (0-12months)', 69.90, 'https://cf.shopee.com.my/file/ac874fa49db3d275463b2d21f2d46124', 1627909683, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2084, 'I.Fairy Athena Power 0-8.50 Korean Color Contact Lens', 'I.Fairy Athena Power 0-8.50 Korean Color Contact Lens', 'I.Fairy Athena Power 0-8.50 Korean Color Contact Lens', 119.00, 'https://cf.shopee.com.my/file/e6982febb199435616eef60987aa8fd2', 1627909683, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2087, 'Novel: BYLINE CINTA WARDAH| Penulis: Umi Kalsom | Penerbit: Penulisan2u | ISBN: 978-967-2102-25-0', 'Novel: BYLINE CINTA WARDAH| Penulis: Umi Kalsom | Penerbit: Penulisan2u | ISBN: 978-967-2102-25-0', 'Novel: BYLINE CINTA WARDAH| Penulis: Umi Kalsom | Penerbit: Penulisan2u | ISBN: 978-967-2102-25-0', 90.00, 'https://cf.shopee.com.my/file/11266e05bedc3c5fb607cf1a4771e82b', 1627909683, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2088, 'REFILL PILOT G2 Gel Pen Refill 0.5/0.7/1.0mm Black/Blue/Red', 'REFILL PILOT G2 Gel Pen Refill 0.5/0.7/1.0mm Black/Blue/Red', 'REFILL PILOT G2 Gel Pen Refill 0.5/0.7/1.0mm Black/Blue/Red', 25.50, 'https://cf.shopee.com.my/file/02422e0ced8ec412a76d60b6078fd8fa', 1627909683, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2089, 'Water Colour Brush Nylon Painting 577 Art Brush Flat Size No.0/2/4/6/8/10/12/14/16/18', 'Water Colour Brush Nylon Painting 577 Art Brush Flat Size No.0/2/4/6/8/10/12/14/16/18', 'Water Colour Brush Nylon Painting 577 Art Brush Flat Size No.0/2/4/6/8/10/12/14/16/18', 5.00, 'https://cf.shopee.com.my/file/2f3c45e83e8292058842a2b4ff8af413', 1627909683, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2090, 'Newborn T-SHIRT EYELET SUIT / BAJU BABY LUBANG Newborn 0-3months', 'Newborn T-SHIRT EYELET SUIT / BAJU BABY LUBANG Newborn 0-3months', 'Newborn T-SHIRT EYELET SUIT / BAJU BABY LUBANG Newborn 0-3months', 239.00, 'https://cf.shopee.com.my/file/5f00e289f9446738d2387d90f8fbdc46', 1627909683, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2091, 'Faber Castell Pro Gel Refill 0.38/0.5/0.7- (1s/ PKT)', 'Faber Castell Pro Gel Refill 0.38/0.5/0.7- (1s/ PKT)', 'Faber Castell Pro Gel Refill 0.38/0.5/0.7- (1s/ PKT)', 17.00, 'https://cf.shopee.com.my/file/f4e2c5c8bef4f52906efc9ba1352f656', 1627909683, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2092, 'Single Core Multi Strand Wire 7/0.2  Red (1meter)', 'Single Core Multi Strand Wire 7/0.2  Red (1meter)', 'Single Core Multi Strand Wire 7/0.2  Red (1meter)', 8.00, 'https://cf.shopee.com.my/file/7703aded4f5a86ac5b7122a1c59306b5', 1627909683, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2094, 'Sleeveless Cute Baby Infant Romper Newborn Baby Girl and Boy Sleepsuit (0-18 Months)', 'Sleeveless Cute Baby Infant Romper Newborn Baby Girl and Boy Sleepsuit (0-18 Months)', 'Sleeveless Cute Baby Infant Romper Newborn Baby Girl and Boy Sleepsuit (0-18 Months)', 78.00, 'https://cf.shopee.com.my/file/f6764712e8dde103f6db8d9d01a7e034', 1627909683, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2095, 'BAKSE 6.0 & 9.0 BAWAL ANTI KEDUT FAREHA BOSTON BRUCE SAIRA SABINA', 'BAKSE 6.0 & 9.0 BAWAL ANTI KEDUT FAREHA BOSTON BRUCE SAIRA SABINA', 'BAKSE 6.0 & 9.0 BAWAL ANTI KEDUT FAREHA BOSTON BRUCE SAIRA SABINA', 220.00, 'https://cf.shopee.com.my/file/40ab62d3abcacd015e297e41f9b6948f', 1627909683, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2096, 'Aluminum Plastic Sata3.0 To Sata Caddy 9.0mm / 9.5mm / 12.7mm 2.5\" SDD HDD Case Enclosure', 'Aluminum Plastic Sata3.0 To Sata Caddy 9.0mm / 9.5mm / 12.7mm 2.5\" SDD HDD Case Enclosure', 'Aluminum Plastic Sata3.0 To Sata Caddy 9.0mm / 9.5mm / 12.7mm 2.5\" SDD HDD Case Enclosure', 98.00, 'https://cf.shopee.com.my/file/7188b3e5900e8d5abbdf5f954a56ddc3', 1627909683, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2097, 'Twinzy Brown 14.2mm Contact Lens Lenses ( 0 Power/Degree /100-700 Power/Degree )  C61-1 By Chao Run', 'Twinzy Brown 14.2mm Contact Lens Lenses ( 0 Power/Degree /100-700 Power/Degree )  C61-1 By Chao Run', 'Twinzy Brown 14.2mm Contact Lens Lenses ( 0 Power/Degree /100-700 Power/Degree )  C61-1 By Chao Run', 89.00, 'https://cf.shopee.com.my/file/8ce2246fadb2e3743b8ecfccff44bcf3', 1627909683, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2099, 'Soft Fabric Cloth Book Baby Toddler 0-2 years Early Learning Book', 'Soft Fabric Cloth Book Baby Toddler 0-2 years Early Learning Book', 'Soft Fabric Cloth Book Baby Toddler 0-2 years Early Learning Book', 7.00, 'https://cf.shopee.com.my/file/7b1fc07f222490b77559ece9e08a3693', 1627909683, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2100, 'LIPGLOSS EMPTY TUBE / LIPMATTE / LIPTINT / 0.8ML', 'LIPGLOSS EMPTY TUBE / LIPMATTE / LIPTINT / 0.8ML', 'LIPGLOSS EMPTY TUBE / LIPMATTE / LIPTINT / 0.8ML', 10.00, 'https://cf.shopee.com.my/file/9a410a9ffbc6dddfed0e5e4f745bc47c', 1627909683, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2102, 'Pilot G2 Gel Ink color Pen 0.7mm 1pcs', 'Pilot G2 Gel Ink color Pen 0.7mm 1pcs', 'Pilot G2 Gel Ink color Pen 0.7mm 1pcs', 42.50, 'https://cf.shopee.com.my/file/5dbf8a23c6d24b80a4a5148d494e4d4d', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2103, 'JEDI BROWN 16mm Big Eye Contact Lens/Color Lens Original Korea Lens ( Power 0-1000 )', 'JEDI BROWN 16mm Big Eye Contact Lens/Color Lens Original Korea Lens ( Power 0-1000 )', 'JEDI BROWN 16mm Big Eye Contact Lens/Color Lens Original Korea Lens ( Power 0-1000 )', 100.00, 'https://cf.shopee.com.my/file/aeac2f52ea6aed50ed34846f70509a78', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2104, '100% AUTHENTIC NEVOKS FEELIN (Empty 2.8ml Cartridge + 1x 0.6 Mesh Coil   + 1x 1.0 Mesh Coil) Nevoks Feelin(Ready Stock)', '100% AUTHENTIC NEVOKS FEELIN (Empty 2.8ml Cartridge + 1x 0.6 Mesh Coil   + 1x 1.0 Mesh Coil) Nevoks Feelin(Ready Stock)', '100% AUTHENTIC NEVOKS FEELIN (Empty 2.8ml Cartridge + 1x 0.6 Mesh Coil   + 1x 1.0 Mesh Coil) Nevoks Feelin(Ready Stock)', 280.00, 'https://cf.shopee.com.my/file/18fa0d40dfe0fefe9f47f0e61dc5f0ff', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2105, 'New Original Smok RPM 2 Occ Coil 0.16 Ohm Mesh 1 Box 5pcs RPM Occ RPM RBA RPM Cartridge Thallo Occ', 'New Original Smok RPM 2 Occ Coil 0.16 Ohm Mesh 1 Box 5pcs RPM Occ RPM RBA RPM Cartridge Thallo Occ', 'New Original Smok RPM 2 Occ Coil 0.16 Ohm Mesh 1 Box 5pcs RPM Occ RPM RBA RPM Cartridge Thallo Occ', 100.00, 'https://cf.shopee.com.my/file/6ae93a30ee6c87a73594c303825ee0d7', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2106, 'Perodua Brake Fluid Dot 3 (0.5L) 9004C-41000 Brake Oil 500ml', 'Perodua Brake Fluid Dot 3 (0.5L) 9004C-41000 Brake Oil 500ml', 'Perodua Brake Fluid Dot 3 (0.5L) 9004C-41000 Brake Oil 500ml', 105.50, 'https://cf.shopee.com.my/file/cd8252862c27ecd04a3b1a1a3d3013fb', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2107, 'Ready Stock 9pcs Gel pens set color Ink Glitter Morandi Kawaii Retro Macaron Marker Liner Highlighter 0.5mm Student School Office Stationery', 'Ready Stock 9pcs Gel pens set color Ink Glitter Morandi Kawaii Retro Macaron Marker Liner Highlighter 0.5mm Student School Office Stationery', 'Ready Stock 9pcs Gel pens set color Ink Glitter Morandi Kawaii Retro Macaron Marker Liner Highlighter 0.5mm Student School Office Stationery', 56.00, 'https://cf.shopee.com.my/file/ae4f8faacb136080539c531b6e56c5ed', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2108, 'Wild Cat 14.5mm 0-800 power Contact Lens Ready Stock', 'Wild Cat 14.5mm 0-800 power Contact Lens Ready Stock', 'Wild Cat 14.5mm 0-800 power Contact Lens Ready Stock', 86.30, 'https://cf.shopee.com.my/file/0183863d5a735d5aaaa0f2e699887598', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2109, 'Stabilo Liner 308F Ballpoint Pen | Fine 0.38mm | School Office Home Stationery', 'Stabilo Liner 308F Ballpoint Pen | Fine 0.38mm | School Office Home Stationery', 'Stabilo Liner 308F Ballpoint Pen | Fine 0.38mm | School Office Home Stationery', 9.50, 'https://cf.shopee.com.my/file/e8a8465f163d33c8db954858e9f8d5d6', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2110, 'PILOT WINGEL GEL PEN 0.38/0.5/0.7', 'PILOT WINGEL GEL PEN 0.38/0.5/0.7', 'PILOT WINGEL GEL PEN 0.38/0.5/0.7', 26.90, 'https://cf.shopee.com.my/file/4e3fead9b9429b433b988c5ef938709e', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2111, 'Anker Powerline+ II Nylon Braided MFI USB C to Lightning Cable Supports Power Delivery (3ft/0.9m) A8652', 'Anker Powerline+ II Nylon Braided MFI USB C to Lightning Cable Supports Power Delivery (3ft/0.9m) A8652', 'Anker Powerline+ II Nylon Braided MFI USB C to Lightning Cable Supports Power Delivery (3ft/0.9m) A8652', 790.00, 'https://cf.shopee.com.my/file/5148e920578d58ed5dbf23e1ff14a219', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2112, 'NEWBORN BABY EYELET SUIT | BAJU BABY BERLUBANG | BABY CLOTHING 0 - 3 months', 'NEWBORN BABY EYELET SUIT | BAJU BABY BERLUBANG | BABY CLOTHING 0 - 3 months', 'NEWBORN BABY EYELET SUIT | BAJU BABY BERLUBANG | BABY CLOTHING 0 - 3 months', 88.90, 'https://cf.shopee.com.my/file/8c0f1ac10b544d9331c9f48d54d3b23d', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2113, 'Cartoon Animals Erasable Pen 0.35mm Cute Panda Cat Magic Pens Kawaii Gel Pens For School Writing Novelty Stationery Girls Gifts', 'Cartoon Animals Erasable Pen 0.35mm Cute Panda Cat Magic Pens Kawaii Gel Pens For School Writing Novelty Stationery Girls Gifts', 'Cartoon Animals Erasable Pen 0.35mm Cute Panda Cat Magic Pens Kawaii Gel Pens For School Writing Novelty Stationery Girls Gifts', 11.00, 'https://cf.shopee.com.my/file/2f05b9471327bf8c9fb84612ef7fc3b6', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2114, 'Faber Castell / Faber-Castell Grip (X5/X7) (0.5/0.7mm)', 'Faber Castell / Faber-Castell Grip (X5/X7) (0.5/0.7mm)', 'Faber Castell / Faber-Castell Grip (X5/X7) (0.5/0.7mm)', 14.00, 'https://cf.shopee.com.my/file/3795de6a3539c5fa70219da2925a4a45', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2115, 'Zebra Sarasa Clip Gel Pen Refill 0.5MM (1pc)', 'Zebra Sarasa Clip Gel Pen Refill 0.5MM (1pc)', 'Zebra Sarasa Clip Gel Pen Refill 0.5MM (1pc)', 26.80, 'https://cf.shopee.com.my/file/9c740fa15e12f0fba55f3f5e40570c80', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2116, 'OCC SMOANT 0.3 / 0.4 / 0.6 K1-K2-K3', 'OCC SMOANT 0.3 / 0.4 / 0.6 K1-K2-K3', 'OCC SMOANT 0.3 / 0.4 / 0.6 K1-K2-K3', 220.00, 'https://cf.shopee.com.my/file/1683d10f62aaa03c4f1ed6d01318b43f', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2117, '10pcs Soccer Disc Bucket Marker Fitness Training Flat Cone Dribbling Training Cone 19cm x 4.5cm x 0.5mm Triangle Cone', '10pcs Soccer Disc Bucket Marker Fitness Training Flat Cone Dribbling Training Cone 19cm x 4.5cm x 0.5mm Triangle Cone', '10pcs Soccer Disc Bucket Marker Fitness Training Flat Cone Dribbling Training Cone 19cm x 4.5cm x 0.5mm Triangle Cone', 43.90, 'https://cf.shopee.com.my/file/d247258c5ca765707724ba4d52881afd', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2118, '0-150mm LCD Digital Caliper Electronic Carbon Fiber Vernier Caliper 6 inch Gauge Micrometer Ruler Measuring Tool', '0-150mm LCD Digital Caliper Electronic Carbon Fiber Vernier Caliper 6 inch Gauge Micrometer Ruler Measuring Tool', '0-150mm LCD Digital Caliper Electronic Carbon Fiber Vernier Caliper 6 inch Gauge Micrometer Ruler Measuring Tool', 129.00, 'https://cf.shopee.com.my/file/66ab40f199d098fc3efc6bc739b85346', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2119, 'Ubat Kurap Haiwan Titis Biru/I Dectin 0.5% Pour-On (10ml)', 'Ubat Kurap Haiwan Titis Biru/I Dectin 0.5% Pour-On (10ml)', 'Ubat Kurap Haiwan Titis Biru/I Dectin 0.5% Pour-On (10ml)', 45.00, 'https://cf.shopee.com.my/file/6bbeca0059a675296e102e8dce32eace', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2120, 'Newborn Baby Girl Summer Clothes Set Cotton Solid Letters Print Fly Sleeve Short Sleeve Romper Camouflage Skirt and Camouflage Bowknot Headband 3pcs Outfits Cool Breath 0-2T', 'Newborn Baby Girl Summer Clothes Set Cotton Solid Letters Print Fly Sleeve Short Sleeve Romper Camouflage Skirt and Camouflage Bowknot Headband 3pcs Outfits Cool Breath 0-2T', 'Newborn Baby Girl Summer Clothes Set Cotton Solid Letters Print Fly Sleeve Short Sleeve Romper Camouflage Skirt and Camouflage Bowknot Headband 3pcs Outfits Cool Breath 0-2T', 194.40, 'https://cf.shopee.com.my/file/ed3980c47d695fbd7adb8a1bbca9a9a6', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2121, 'Gsoft W2 Ball Pen 0.5mm 0.7mm 1.0mm Blue Black Red', 'Gsoft W2 Ball Pen 0.5mm 0.7mm 1.0mm Blue Black Red', 'Gsoft W2 Ball Pen 0.5mm 0.7mm 1.0mm Blue Black Red', 5.50, 'https://cf.shopee.com.my/file/1833f68ff2f22c5928a6a29ca116d374', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2122, 'Artline 041T Twin / Dual Tip Permanent Marker Pen 0.4mm & 1mm Black Blue Red', 'Artline 041T Twin / Dual Tip Permanent Marker Pen 0.4mm & 1mm Black Blue Red', 'Artline 041T Twin / Dual Tip Permanent Marker Pen 0.4mm & 1mm Black Blue Red', 29.90, 'https://cf.shopee.com.my/file/309d1aa299396d375fa77d2fc3ace122', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2124, 'Faster Colourful Ball Pen CX-1076 0.7mm', 'Faster Colourful Ball Pen CX-1076 0.7mm', 'Faster Colourful Ball Pen CX-1076 0.7mm', 8.00, 'https://cf.shopee.com.my/file/169f2a6158951c7be40242ceef8b25c7', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2125, 'Tudung BAYI & KANAK-KANAK / NEWBORN BABY Girl Budak 0-3tahun Cute Infant Children Headscarf Kid\'s Readystock', 'Tudung BAYI & KANAK-KANAK / NEWBORN BABY Girl Budak 0-3tahun Cute Infant Children Headscarf Kid\'s Readystock', 'Tudung BAYI & KANAK-KANAK / NEWBORN BABY Girl Budak 0-3tahun Cute Infant Children Headscarf Kid\'s Readystock', 90.00, 'https://cf.shopee.com.my/file/4ec63707031d676540784b5027052111', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2126, 'Pilot Rexgrip Mechanical Pencil + Lead ( 0.5/0.7)', 'Pilot Rexgrip Mechanical Pencil + Lead ( 0.5/0.7)', 'Pilot Rexgrip Mechanical Pencil + Lead ( 0.5/0.7)', 45.00, 'https://cf.shopee.com.my/file/4648eb7cd552d8779a308e92dcd73d87', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2127, 'Faber Castell Grip X7 0.7mm Ball Point Pen', 'Faber Castell Grip X7 0.7mm Ball Point Pen', 'Faber Castell Grip X7 0.7mm Ball Point Pen', 13.00, 'https://cf.shopee.com.my/file/23db5c35a918b852fba526eb63d11e89', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2128, 'LiGeek 48W Fast Charger 4 Ports PD 3.0 QC 3.0/2.0 Typec 5V 3A Output USB Charger Adapter for Apple iphone 12', 'LiGeek 48W Fast Charger 4 Ports PD 3.0 QC 3.0/2.0 Typec 5V 3A Output USB Charger Adapter for Apple iphone 12', 'LiGeek 48W Fast Charger 4 Ports PD 3.0 QC 3.0/2.0 Typec 5V 3A Output USB Charger Adapter for Apple iphone 12', 199.00, 'https://cf.shopee.com.my/file/8ec7315448407d67b60db65f3149132b', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2129, 'M&G R3 0.5mm Retractable Gel Pen (Black,Blue,Red)/ Pen Basah 0.5mm /pen hitam/pen biru/pen merah', 'M&G R3 0.5mm Retractable Gel Pen (Black,Blue,Red)/ Pen Basah 0.5mm /pen hitam/pen biru/pen merah', 'M&G R3 0.5mm Retractable Gel Pen (Black,Blue,Red)/ Pen Basah 0.5mm /pen hitam/pen biru/pen merah', 12.00, 'https://cf.shopee.com.my/file/8b07cbe02ec6a1d65f1e23b49e938a14', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2130, 'G\'soft W2 0.5mm / 0.7mm / 1.0mm Retractable Ball pen', 'G\'soft W2 0.5mm / 0.7mm / 1.0mm Retractable Ball pen', 'G\'soft W2 0.5mm / 0.7mm / 1.0mm Retractable Ball pen', 8.40, 'https://cf.shopee.com.my/file/6721628e763fb8ef9db105a4c6261842', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2131, 'Width 0.6-5cm 5Yards White Black Elastic Bands Spandex Ribbon Belt Trim for Sewing Short Skirt Trouse Garment Accessories', 'Width 0.6-5cm 5Yards White Black Elastic Bands Spandex Ribbon Belt Trim for Sewing Short Skirt Trouse Garment Accessories', 'Width 0.6-5cm 5Yards White Black Elastic Bands Spandex Ribbon Belt Trim for Sewing Short Skirt Trouse Garment Accessories', 14.00, 'https://cf.shopee.com.my/file/b6bcee5618a9d8a8ec242470e600fdc0', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2132, 'Original Vaporesso XROS Pod Cartridge 2ml XROS MESH Pod 0.8ohm & XROS MESH Pod 1.2ohm', 'Original Vaporesso XROS Pod Cartridge 2ml XROS MESH Pod 0.8ohm & XROS MESH Pod 1.2ohm', 'Original Vaporesso XROS Pod Cartridge 2ml XROS MESH Pod 0.8ohm & XROS MESH Pod 1.2ohm', 180.00, 'https://cf.shopee.com.my/file/f683c3cc305e7a90d22307fc59c690c5', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2133, 'Durock Switch Films (0.15mm) 20/60/90/120Pcs per pack HTV and Polycarbonate', 'Durock Switch Films (0.15mm) 20/60/90/120Pcs per pack HTV and Polycarbonate', 'Durock Switch Films (0.15mm) 20/60/90/120Pcs per pack HTV and Polycarbonate', 57.50, 'https://cf.shopee.com.my/file/909dee61a5f20d7de9f445d2ef8f6381', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2134, 'Resistor 2.2k ohm (Carbon - 0.25W)', 'Resistor 2.2k ohm (Carbon - 0.25W)', 'Resistor 2.2k ohm (Carbon - 0.25W)', 1.00, 'https://cf.shopee.com.my/file/566229dcdfc4a6921c268b2438b49dd3', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2135, '[RM17.53 after cashback] Dugro Dupro Soy 0 - 12 Months 400g (EXP 05/22)', '[RM17.53 after cashback] Dugro Dupro Soy 0 - 12 Months 400g (EXP 05/22)', '[RM17.53 after cashback] Dugro Dupro Soy 0 - 12 Months 400g (EXP 05/22)', 194.80, 'https://cf.shopee.com.my/file/10f44dd090e822a8a9c859d022c79710', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2136, 'Faber Castell Click X Ball Pen Click X5 0.5mm 1425/Click X7 0.7mm 1422', 'Faber Castell Click X Ball Pen Click X5 0.5mm 1425/Click X7 0.7mm 1422', 'Faber Castell Click X Ball Pen Click X5 0.5mm 1425/Click X7 0.7mm 1422', 7.00, 'https://cf.shopee.com.my/file/e8e7e6419a1026cfe97cdffecdd004d4', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2137, 'REMAX RP-U37 Jane Series UK Version PD 18W Quick Charging QC3.0 Charger Set For iPhone USB + Type C Output', 'REMAX RP-U37 Jane Series UK Version PD 18W Quick Charging QC3.0 Charger Set For iPhone USB + Type C Output', 'REMAX RP-U37 Jane Series UK Version PD 18W Quick Charging QC3.0 Charger Set For iPhone USB + Type C Output', 249.00, 'https://cf.shopee.com.my/file/c5ef9587ebbffb3495f0c9b5edbb0687', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2138, 'Mcdodo CH8401 20W PD + Quick Charge Dual USB Wall Charger (UK plug) (PD3.0/QC3.0/FCP/SCP/AFC)', 'Mcdodo CH8401 20W PD + Quick Charge Dual USB Wall Charger (UK plug) (PD3.0/QC3.0/FCP/SCP/AFC)', 'Mcdodo CH8401 20W PD + Quick Charge Dual USB Wall Charger (UK plug) (PD3.0/QC3.0/FCP/SCP/AFC)', 290.00, 'https://cf.shopee.com.my/file/2e26f80ad447562bcb5de20ab0d44702', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2139, 'ARCTIC P12 PWM (Pressure-optimised 120mm/PWM/FDB/0.3 Sone & 1800rpm)', 'ARCTIC P12 PWM (Pressure-optimised 120mm/PWM/FDB/0.3 Sone & 1800rpm)', 'ARCTIC P12 PWM (Pressure-optimised 120mm/PWM/FDB/0.3 Sone & 1800rpm)', 470.00, 'https://cf.shopee.com.my/file/6c370ef6c04778286eda6e2798190869', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2140, 'Minigold Black Series Metal Noble Mini Gold Coins 24 Carat 0.025 Grams', 'Minigold Black Series Metal Noble Mini Gold Coins 24 Carat 0.025 Grams', 'Minigold Black Series Metal Noble Mini Gold Coins 24 Carat 0.025 Grams', 132.40, 'https://cf.shopee.com.my/file/66d42a8d24ca3284574d871804a9d6c7', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2141, 'Faber Castell Z Pencil 0.5mm / 0.7mm New', 'Faber Castell Z Pencil 0.5mm / 0.7mm New', 'Faber Castell Z Pencil 0.5mm / 0.7mm New', 26.10, 'https://cf.shopee.com.my/file/e7afb0a1d0dc5a35145321cd0475be15', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2143, 'Deli Retractable Ballpoint Pen - Black (0.7mm) EQ00320', 'Deli Retractable Ballpoint Pen - Black (0.7mm) EQ00320', 'Deli Retractable Ballpoint Pen - Black (0.7mm) EQ00320', 4.80, 'https://cf.shopee.com.my/file/0c035a122403f51075e15ac351059b7c', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2144, 'Midea 0.6L Rice Cooker MG-GP06B', 'Midea 0.6L Rice Cooker MG-GP06B', 'Midea 0.6L Rice Cooker MG-GP06B', 377.70, 'https://cf.shopee.com.my/file/2e6c8a5fe3d36ec6e3cc9efa32a9614e', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2145, 'Live payment baju & seluar kids bundle (0-12y)', 'Live payment baju & seluar kids bundle (0-12y)', 'Live payment baju & seluar kids bundle (0-12y)', 20.00, 'https://cf.shopee.com.my/file/2190f38755d869a3d0d17f87f7c1f8aa', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2146, 'D1 Spec Water Gauge Meter Radiator Cap+ Water Temp gauge 0.9bar/1.1bar/1.3bar', 'D1 Spec Water Gauge Meter Radiator Cap+ Water Temp gauge 0.9bar/1.1bar/1.3bar', 'D1 Spec Water Gauge Meter Radiator Cap+ Water Temp gauge 0.9bar/1.1bar/1.3bar', 135.00, 'https://cf.shopee.com.my/file/a7c0bfc1ca7873dcdc4fc4f9182c54e6', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2148, 'Durable Hose Out board Fuel Bulb Gas Petrol Rubber aluminum Engine Car Motorcycle Boats 0.2bar-6bar Hand primer pump', 'Durable Hose Out board Fuel Bulb Gas Petrol Rubber aluminum Engine Car Motorcycle Boats 0.2bar-6bar Hand primer pump', 'Durable Hose Out board Fuel Bulb Gas Petrol Rubber aluminum Engine Car Motorcycle Boats 0.2bar-6bar Hand primer pump', 88.50, 'https://cf.shopee.com.my/file/ab48af44ced0015ded6541195eae47dc', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2149, 'Variation of Resistor 0.25W 1% 220Ohm 1kOhm 10kOhm', 'Variation of Resistor 0.25W 1% 220Ohm 1kOhm 10kOhm', 'Variation of Resistor 0.25W 1% 220Ohm 1kOhm 10kOhm', 1.50, 'https://cf.shopee.com.my/file/2077664cd6af4ead8921f3056d2876b2', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2150, 'Ikea Clear Glass Bottle with Stopper Size 0.5L/1L for Home, Cafe, Party, Event', 'Ikea Clear Glass Bottle with Stopper Size 0.5L/1L for Home, Cafe, Party, Event', 'Ikea Clear Glass Bottle with Stopper Size 0.5L/1L for Home, Cafe, Party, Event', 109.90, 'https://cf.shopee.com.my/file/603be66ba0bd1ef3303a75d88bf293d2', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2151, 'Faber-Castell Grip Ball Pen / Grip X5 0.5mm / Grip X7 0.7mm - Blue/Black/Red', 'Faber-Castell Grip Ball Pen / Grip X5 0.5mm / Grip X7 0.7mm - Blue/Black/Red', 'Faber-Castell Grip Ball Pen / Grip X5 0.5mm / Grip X7 0.7mm - Blue/Black/Red', 11.20, 'https://cf.shopee.com.my/file/6345538de2f0719870cae8bdd806a14b', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2152, 'Metal silver USB flash drive 4GB 8GB 16GB 32GB 64GB128GB actual capacity flash drive 2.0/3.0 flash drive', 'Metal silver USB flash drive 4GB 8GB 16GB 32GB 64GB128GB actual capacity flash drive 2.0/3.0 flash drive', 'Metal silver USB flash drive 4GB 8GB 16GB 32GB 64GB128GB actual capacity flash drive 2.0/3.0 flash drive', 50.00, 'https://cf.shopee.com.my/file/627d644d67976887e17d76ee0236aa8a', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2153, 'BASEUS USB Ports USB Hub Type-C to USB3.0 x 3 + USB2.0 x 2 Hub Adapter Converter (Ready Stock)', 'BASEUS USB Ports USB Hub Type-C to USB3.0 x 3 + USB2.0 x 2 Hub Adapter Converter (Ready Stock)', 'BASEUS USB Ports USB Hub Type-C to USB3.0 x 3 + USB2.0 x 2 Hub Adapter Converter (Ready Stock)', 490.00, 'https://cf.shopee.com.my/file/6ec3f51ca2571c18e807643a914e3a37', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2155, 'PILOT SHAKER 2020 Mechanical Pencil (0.5mm / 0.7mm) with 1 Free Pilot 2B Pencil Lead', 'PILOT SHAKER 2020 Mechanical Pencil (0.5mm / 0.7mm) with 1 Free Pilot 2B Pencil Lead', 'PILOT SHAKER 2020 Mechanical Pencil (0.5mm / 0.7mm) with 1 Free Pilot 2B Pencil Lead', 78.00, 'https://cf.shopee.com.my/file/2825121807c4169711677640aa6db4a9', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2158, 'Cotton Linen - RM6.00 untuk Setengah meter(0.5mtr)- Bidang 58-60', 'Cotton Linen - RM6.00 untuk Setengah meter(0.5mtr)- Bidang 58-60', 'Cotton Linen - RM6.00 untuk Setengah meter(0.5mtr)- Bidang 58-60', 55.80, 'https://cf.shopee.com.my/file/522470710e6ab2df3497d2ae30ce8f87', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2160, '[RM 0.90 AFTER SHOPEE COIN REBATE] Baby Silicone Heat Sensor Feeding Spoon / Fork', '[RM 0.90 AFTER SHOPEE COIN REBATE] Baby Silicone Heat Sensor Feeding Spoon / Fork', '[RM 0.90 AFTER SHOPEE COIN REBATE] Baby Silicone Heat Sensor Feeding Spoon / Fork', 10.00, 'https://cf.shopee.com.my/file/8e89c6261df2db7c8ed1c9d3627b5d09', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2162, 'Single Core Multi Strand Wire  7/0.2  Black (1meter)', 'Single Core Multi Strand Wire  7/0.2  Black (1meter)', 'Single Core Multi Strand Wire  7/0.2  Black (1meter)', 8.00, 'https://cf.shopee.com.my/file/b8da5e42cc6f4800688e18c86c5f2a04', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2163, '0.3M Serial ATA SATA Data Cable for SATA Hard Disk DVD DVD-RW', '0.3M Serial ATA SATA Data Cable for SATA Hard Disk DVD DVD-RW', '0.3M Serial ATA SATA Data Cable for SATA Hard Disk DVD DVD-RW', 14.50, 'https://cf.shopee.com.my/file/39e037ca0b14f02dfa1aed89184d6b29', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2164, '1st Player DK PS-600AX DK6.0 Full Modular Power Supply PSU (600W, 80 Plus Bronze, 3 Years Warranty)', '1st Player DK PS-600AX DK6.0 Full Modular Power Supply PSU (600W, 80 Plus Bronze, 3 Years Warranty)', '1st Player DK PS-600AX DK6.0 Full Modular Power Supply PSU (600W, 80 Plus Bronze, 3 Years Warranty)', 1940.00, 'https://cf.shopee.com.my/file/2d108d59959bc13266b2055c3d4cded5', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2165, 'RXZ BLOCK GASKET KERTAS 0.3MM 0.5MM 0.8MM 1MM ASHUKA (HARGA 1 PCS)', 'RXZ BLOCK GASKET KERTAS 0.3MM 0.5MM 0.8MM 1MM ASHUKA (HARGA 1 PCS)', 'RXZ BLOCK GASKET KERTAS 0.3MM 0.5MM 0.8MM 1MM ASHUKA (HARGA 1 PCS)', 18.00, 'https://cf.shopee.com.my/file/f12942434be8fdd52f392623b8f2bf6d', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2166, 'Boy\'s baju polo shirt set baby boy clothes 2-piece set boy fashion stripe T-shirt lengan pendek + seluar pendek 0-5 tahun pakaian bayi', 'Boy\'s baju polo shirt set baby boy clothes 2-piece set boy fashion stripe T-shirt lengan pendek + seluar pendek 0-5 tahun pakaian bayi', 'Boy\'s baju polo shirt set baby boy clothes 2-piece set boy fashion stripe T-shirt lengan pendek + seluar pendek 0-5 tahun pakaian bayi', 129.00, 'https://cf.shopee.com.my/file/3c2cf2c5c1b8a92758d4c8830d9feeea', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2167, 'QBrand 4-in-1 Type-C hub USB3.0 USB2.0 HDMI USB-C power adapter for mobile phones/PC/TV/laptops, etc.', 'QBrand 4-in-1 Type-C hub USB3.0 USB2.0 HDMI USB-C power adapter for mobile phones/PC/TV/laptops, etc.', 'QBrand 4-in-1 Type-C hub USB3.0 USB2.0 HDMI USB-C power adapter for mobile phones/PC/TV/laptops, etc.', 599.00, 'https://cf.shopee.com.my/file/35300e6bdc8f31be9e3bcaaba6de3daf', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2168, '0.5mm Gel Pens Black/Red/Blue Ink Pen Japanese stationery Office Supply Stationery for Student', '0.5mm Gel Pens Black/Red/Blue Ink Pen Japanese stationery Office Supply Stationery for Student', '0.5mm Gel Pens Black/Red/Blue Ink Pen Japanese stationery Office Supply Stationery for Student', 6.00, 'https://cf.shopee.com.my/file/549b69e2c9ba50d84e7fcf8ebfbf2246', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2169, 'ARTRIINK CARP! SQ-703 Gel Ink Pen 0.5mm (M&G R3/R5)', 'ARTRIINK CARP! SQ-703 Gel Ink Pen 0.5mm (M&G R3/R5)', 'ARTRIINK CARP! SQ-703 Gel Ink Pen 0.5mm (M&G R3/R5)', 8.00, 'https://cf.shopee.com.my/file/ccfd6cd3c143fc54a910a3782fcf5299', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2170, 'ISAKURA MONTHLY BIG EYE COLOR LENS POWER (-0.00 to -10.00)', 'ISAKURA MONTHLY BIG EYE COLOR LENS POWER (-0.00 to -10.00)', 'ISAKURA MONTHLY BIG EYE COLOR LENS POWER (-0.00 to -10.00)', 59.90, 'https://cf.shopee.com.my/file/9ee988d1e278f78c431af3c6ff10f90b', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2171, '6-Color Transparent Ballpoint Pen Office Learning Tool 0.5mm', '6-Color Transparent Ballpoint Pen Office Learning Tool 0.5mm', '6-Color Transparent Ballpoint Pen Office Learning Tool 0.5mm', 7.20, 'https://cf.shopee.com.my/file/160efa9626cb535be01e217a679276d9', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2172, 'Pilot Mechanical Pencil 2B Progrex 0.5/0.7mm - 1Pcs', 'Pilot Mechanical Pencil 2B Progrex 0.5/0.7mm - 1Pcs', 'Pilot Mechanical Pencil 2B Progrex 0.5/0.7mm - 1Pcs', 33.00, 'https://cf.shopee.com.my/file/66be227fc1f4ea689bfab24b0743acec', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2173, '0.5m x 1m Bubble Wrap Sheet Protective packaging layer waterproof Bubble Pack Bubble Air Protection', '0.5m x 1m Bubble Wrap Sheet Protective packaging layer waterproof Bubble Pack Bubble Air Protection', '0.5m x 1m Bubble Wrap Sheet Protective packaging layer waterproof Bubble Pack Bubble Air Protection', 8.00, 'https://cf.shopee.com.my/file/2a728cd8bf890fa7c1f2106c39e67217', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2174, 'PU PVC LEATHER MURAH!! (Bidang besar 55 inci) (tebal 0.7mm) JUALAN PER METER', 'PU PVC LEATHER MURAH!! (Bidang besar 55 inci) (tebal 0.7mm) JUALAN PER METER', 'PU PVC LEATHER MURAH!! (Bidang besar 55 inci) (tebal 0.7mm) JUALAN PER METER', 80.00, 'https://cf.shopee.com.my/file/0f1ee358f9a238a02dc90503ef1fc174', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2175, 'Huawei Quick Charge 18W QC3.0 Charger for Nova 5T, 4E, Honor, Xiaomi Redmi, Mi, Vivo V, Samsung Note, S Andriod Adapter', 'Huawei Quick Charge 18W QC3.0 Charger for Nova 5T, 4E, Honor, Xiaomi Redmi, Mi, Vivo V, Samsung Note, S Andriod Adapter', 'Huawei Quick Charge 18W QC3.0 Charger for Nova 5T, 4E, Honor, Xiaomi Redmi, Mi, Vivo V, Samsung Note, S Andriod Adapter', 30.00, 'https://cf.shopee.com.my/file/a93f6e4ec9ff8a27dc3d771e6c4c9a93', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2176, '0.5mm 0.7mm Colorful Mechanical Pencil Lead Art Sketch Drawing Color Lead School Office Supplies', '0.5mm 0.7mm Colorful Mechanical Pencil Lead Art Sketch Drawing Color Lead School Office Supplies', '0.5mm 0.7mm Colorful Mechanical Pencil Lead Art Sketch Drawing Color Lead School Office Supplies', 6.70, 'https://cf.shopee.com.my/file/eaa593feb5ba0c3e11db0175d76a4911', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2177, 'Original Nevoks Feeling Pod Kit Occ Coil 0.6Ohm Duit Raya Give Away / Silicone Case', 'Original Nevoks Feeling Pod Kit Occ Coil 0.6Ohm Duit Raya Give Away / Silicone Case', 'Original Nevoks Feeling Pod Kit Occ Coil 0.6Ohm Duit Raya Give Away / Silicone Case', 65.00, 'https://cf.shopee.com.my/file/aa3a175c8c2889fe7c44123a13232c46', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2178, 'Original Disney Baby Winnie the Pooh Tigger Gift Set Clothing Clothes Suit Suits (0-6m)', 'Original Disney Baby Winnie the Pooh Tigger Gift Set Clothing Clothes Suit Suits (0-6m)', 'Original Disney Baby Winnie the Pooh Tigger Gift Set Clothing Clothes Suit Suits (0-6m)', 280.00, 'https://cf.shopee.com.my/file/2b7e752feb7c018aa800f9b4061056f0', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2179, 'Dutch Baby 0-12 months (850g x 3) Exp: 09/2022 (Newest Packing)', 'Dutch Baby 0-12 months (850g x 3) Exp: 09/2022 (Newest Packing)', 'Dutch Baby 0-12 months (850g x 3) Exp: 09/2022 (Newest Packing)', 785.00, 'https://cf.shopee.com.my/file/f7044590c91b7671ec23f574a742a078', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2180, 'EVIN I TYPE INTERDENTAL BRUSHES (SIZE S 1.0MM/SIZE SSSS 0.6MM) (8PCS)', 'EVIN I TYPE INTERDENTAL BRUSHES (SIZE S 1.0MM/SIZE SSSS 0.6MM) (8PCS)', 'EVIN I TYPE INTERDENTAL BRUSHES (SIZE S 1.0MM/SIZE SSSS 0.6MM) (8PCS)', 59.00, 'https://cf.shopee.com.my/file/34f478eda43ce9e3c4d51f2dc11914d0', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2181, '0.8MM 1KG GASLESS OPEN ARC FLUX CORED MIG WELDING SET WIRE 1KG MIG WIRE', '0.8MM 1KG GASLESS OPEN ARC FLUX CORED MIG WELDING SET WIRE 1KG MIG WIRE', '0.8MM 1KG GASLESS OPEN ARC FLUX CORED MIG WELDING SET WIRE 1KG MIG WIRE', 189.90, 'https://cf.shopee.com.my/file/4433676c995840dd8ea5116f9ef555db', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2182, '0.5/1mm Waxed Cotton Cord Beading Cord Waxed String Wax Cording Cord for Jewelry Making', '0.5/1mm Waxed Cotton Cord Beading Cord Waxed String Wax Cording Cord for Jewelry Making', '0.5/1mm Waxed Cotton Cord Beading Cord Waxed String Wax Cording Cord for Jewelry Making', 1.00, 'https://cf.shopee.com.my/file/4e944b47c45bb5b829f7828ae02f4ff9', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2183, 'Newborn Romper Cotton Long Sleeve Baby Infant Jumpsuit Boy Girl Clothing Toddler Pajamas Thin Soft 0-9month', 'Newborn Romper Cotton Long Sleeve Baby Infant Jumpsuit Boy Girl Clothing Toddler Pajamas Thin Soft 0-9month', 'Newborn Romper Cotton Long Sleeve Baby Infant Jumpsuit Boy Girl Clothing Toddler Pajamas Thin Soft 0-9month', 149.00, 'https://cf.shopee.com.my/file/4f953073e864d4cdf996bfe755727b53', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2185, '5pcs RM8.30 HARRIS Copper Brazing Alloy Rod / Welding Rod 0% Silver Copper Rod for Brazing Soldering Welding Mapp Gas', '5pcs RM8.30 HARRIS Copper Brazing Alloy Rod / Welding Rod 0% Silver Copper Rod for Brazing Soldering Welding Mapp Gas', '5pcs RM8.30 HARRIS Copper Brazing Alloy Rod / Welding Rod 0% Silver Copper Rod for Brazing Soldering Welding Mapp Gas', 87.00, 'https://cf.shopee.com.my/file/72ccc347f806869ca6e84003a7bb5792', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2186, 'Samsung Galaxy Tab A 8.0\'\' T290 T295 New Design Soft Tpu Slim Flip Pouch Bag Cover Case', 'Samsung Galaxy Tab A 8.0\'\' T290 T295 New Design Soft Tpu Slim Flip Pouch Bag Cover Case', 'Samsung Galaxy Tab A 8.0\'\' T290 T295 New Design Soft Tpu Slim Flip Pouch Bag Cover Case', 99.90, 'https://cf.shopee.com.my/file/fcffa8f24e8e561a152fea0c654ae678', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2187, 'Stock 0-4 year old baby Summer baby and kids clothing Cotton Rabbit dress Princess Baby Girls Sleeveless set', 'Stock 0-4 year old baby Summer baby and kids clothing Cotton Rabbit dress Princess Baby Girls Sleeveless set', 'Stock 0-4 year old baby Summer baby and kids clothing Cotton Rabbit dress Princess Baby Girls Sleeveless set', 175.80, 'https://cf.shopee.com.my/file/dc367da19edb515d5f459c890d53ba17', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2188, 'Novel: TAK SEMPURNA MENCINTAIMU | Penulis: Rehan Makhtar | Penerbit: Karyaseni | ISBN: 978-967-469-083-0', 'Novel: TAK SEMPURNA MENCINTAIMU | Penulis: Rehan Makhtar | Penerbit: Karyaseni | ISBN: 978-967-469-083-0', 'Novel: TAK SEMPURNA MENCINTAIMU | Penulis: Rehan Makhtar | Penerbit: Karyaseni | ISBN: 978-967-469-083-0', 180.00, 'https://cf.shopee.com.my/file/111790c3fa4700289a4bf73687c206b7', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2189, 'Funkopop Casing 0.5mm hard type / 4 inch Funko Pop Protector / - buy more get discount', 'Funkopop Casing 0.5mm hard type / 4 inch Funko Pop Protector / - buy more get discount', 'Funkopop Casing 0.5mm hard type / 4 inch Funko Pop Protector / - buy more get discount', 45.60, 'https://cf.shopee.com.my/file/8a64b3e145cb0cc447d2965529e51b31', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2190, 'M&G Black Gel Pen 0.7MM-0319', 'M&G Black Gel Pen 0.7MM-0319', 'M&G Black Gel Pen 0.7MM-0319', 21.00, 'https://cf.shopee.com.my/file/9141080fa73e8374c69b995aa880f49d', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2192, 'Newborn Baby suit 0-3months,baju set bayi,baby wear', 'Newborn Baby suit 0-3months,baju set bayi,baby wear', 'Newborn Baby suit 0-3months,baju set bayi,baby wear', 59.00, 'https://cf.shopee.com.my/file/0314af20e1859cbbf6a19957ce67f12a', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2197, 'Classic Black 17mm 0-800 power', 'Classic Black 17mm 0-800 power', 'Classic Black 17mm 0-800 power', 100.00, 'https://cf.shopee.com.my/file/dd55327d4c85e53dcd27bf5388231600', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2198, 'MASCARA EMPTY TUBE / BOTOL MASKARA 0.8ML', 'MASCARA EMPTY TUBE / BOTOL MASKARA 0.8ML', 'MASCARA EMPTY TUBE / BOTOL MASKARA 0.8ML', 10.00, 'https://cf.shopee.com.my/file/048f510df9494ba19b50d201eb55439e', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2199, 'Big Discount Kain Pasang Paloma Twill Cotton Silk (Harga utk 0.5m) Sgt Lembut Cotton Soffy Cotton Bidang 58', 'Big Discount Kain Pasang Paloma Twill Cotton Silk (Harga utk 0.5m) Sgt Lembut Cotton Soffy Cotton Bidang 58', 'Big Discount Kain Pasang Paloma Twill Cotton Silk (Harga utk 0.5m) Sgt Lembut Cotton Soffy Cotton Bidang 58', 42.90, 'https://cf.shopee.com.my/file/7abd34cabeb4951edfce60987a20cba6', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2200, '[1Meter 0.8mm] Copper Wire Chain Lobster Clasp Necklace Charm Chains For Jewelry Findings DIY Accessories', '[1Meter 0.8mm] Copper Wire Chain Lobster Clasp Necklace Charm Chains For Jewelry Findings DIY Accessories', '[1Meter 0.8mm] Copper Wire Chain Lobster Clasp Necklace Charm Chains For Jewelry Findings DIY Accessories', 9.80, 'https://cf.shopee.com.my/file/2875889c7d4c4caf3ec2c2f98a73b9d8', 1627909684, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2201, 'Original inPods i12 TWS Touch Airpods Style BT5.0 Wireless Bluetooth Earbuds For Android & iPhone', 'Original inPods i12 TWS Touch Airpods Style BT5.0 Wireless Bluetooth Earbuds For Android & iPhone', 'Original inPods i12 TWS Touch Airpods Style BT5.0 Wireless Bluetooth Earbuds For Android & iPhone', 169.00, 'https://cf.shopee.com.my/file/26a9477c5f5ef5b2d1499c124c5c5a09', 1627909686, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2202, 'M&G R3(0.5mm)/R5(0.7mm) Retractable Gel Pen', 'M&G R3(0.5mm)/R5(0.7mm) Retractable Gel Pen', 'M&G R3(0.5mm)/R5(0.7mm) Retractable Gel Pen', 12.00, 'https://cf.shopee.com.my/file/b4f5b7d103a48b4da263739208376087', 1627909686, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2203, 'imoda 12pcs/Pack 0.5mm Gel Pen Multi-color Pen For School Office Supplies Stationery', 'imoda 12pcs/Pack 0.5mm Gel Pen Multi-color Pen For School Office Supplies Stationery', 'imoda 12pcs/Pack 0.5mm Gel Pen Multi-color Pen For School Office Supplies Stationery', 69.00, 'https://cf.shopee.com.my/file/f9f8b6e3faab5c694d5ba744cdb0ea63', 1627909686, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2204, 'Car QC3.0 Quick Charge Dual USB Ports LCD Display Mobile Phone Charger Adapter', 'Car QC3.0 Quick Charge Dual USB Ports LCD Display Mobile Phone Charger Adapter', 'Car QC3.0 Quick Charge Dual USB Ports LCD Display Mobile Phone Charger Adapter', 87.10, 'https://cf.shopee.com.my/file/72e86271bd6290b1524c7fc2445276ee', 1627909686, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2205, 'Original Voopoo Drag S / Vinci /  Vinci X / Vinci Air / Find S / Drag X Replacement Coil 5pcs Occ 0.15 / 0.2 / 0.3 / 0.6', 'Original Voopoo Drag S / Vinci /  Vinci X / Vinci Air / Find S / Drag X Replacement Coil 5pcs Occ 0.15 / 0.2 / 0.3 / 0.6', 'Original Voopoo Drag S / Vinci /  Vinci X / Vinci Air / Find S / Drag X Replacement Coil 5pcs Occ 0.15 / 0.2 / 0.3 / 0.6', 380.00, 'https://cf.shopee.com.my/file/c904b5a9f558b230fe386918e5180475', 1627909686, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2206, 'M&G R3/R5 Retractable Gel Pen 0.5 / 0.7mm Bullet Nib', 'M&G R3/R5 Retractable Gel Pen 0.5 / 0.7mm Bullet Nib', 'M&G R3/R5 Retractable Gel Pen 0.5 / 0.7mm Bullet Nib', 13.50, 'https://cf.shopee.com.my/file/fda388bedcc1005a7988a1d8f4eb35df', 1627909686, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2207, 'Faber-Castell RX Gel Pen 0.5/0.7mm (2499)', 'Faber-Castell RX Gel Pen 0.5/0.7mm (2499)', 'Faber-Castell RX Gel Pen 0.5/0.7mm (2499)', 12.00, 'https://cf.shopee.com.my/file/b9be2943c4cb2b1c1285465ea7e3c2e3', 1627909686, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2208, 'Nieki Ball Point Pen 0.7mm 1PCS', 'Nieki Ball Point Pen 0.7mm 1PCS', 'Nieki Ball Point Pen 0.7mm 1PCS', 2.00, 'https://cf.shopee.com.my/file/8c4b57d25906a5bcdc9d66a80b5fe669', 1627909686, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2209, 'USB3.0 2.5\" Laptop / Notebook Hard Disk Case / External Transparent Clear Casing / Box ( Internal HDD SSD to External )', 'USB3.0 2.5\" Laptop / Notebook Hard Disk Case / External Transparent Clear Casing / Box ( Internal HDD SSD to External )', 'USB3.0 2.5\" Laptop / Notebook Hard Disk Case / External Transparent Clear Casing / Box ( Internal HDD SSD to External )', 200.00, 'https://cf.shopee.com.my/file/632fe111092a084b7602b47c96c2abdb', 1627909686, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2210, 'Gsoft Retractable Ball Pen ( 0.5mm / 0.7mm) P901', 'Gsoft Retractable Ball Pen ( 0.5mm / 0.7mm) P901', 'Gsoft Retractable Ball Pen ( 0.5mm / 0.7mm) P901', 5.50, 'https://cf.shopee.com.my/file/af19bb950cb965aebc2089cbd5c9f8dc', 1627909686, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2211, 'Faster CX-445 Ball Point Pen (0.5mm / Black / Blue / Red)', 'Faster CX-445 Ball Point Pen (0.5mm / Black / Blue / Red)', 'Faster CX-445 Ball Point Pen (0.5mm / Black / Blue / Red)', 5.80, 'https://cf.shopee.com.my/file/4ce395aad3e2a7ef7d11dc8554908bf8', 1627909686, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2212, '40W Powerbank 100000mAh Super Fast Charge  Vooc Flash Charging HUAWEI Qc3.0 PD22.5W Mobile Power Charger', '40W Powerbank 100000mAh Super Fast Charge  Vooc Flash Charging HUAWEI Qc3.0 PD22.5W Mobile Power Charger', '40W Powerbank 100000mAh Super Fast Charge  Vooc Flash Charging HUAWEI Qc3.0 PD22.5W Mobile Power Charger', 990.00, 'https://cf.shopee.com.my/file/f1b7d18b95dc3ff363465dc9639e6881', 1627909686, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2213, 'TeamGroup C171 Pendrive 16GB/32GB USB2.0 Flash Drive', 'TeamGroup C171 Pendrive 16GB/32GB USB2.0 Flash Drive', 'TeamGroup C171 Pendrive 16GB/32GB USB2.0 Flash Drive', 145.00, 'https://cf.shopee.com.my/file/2834b052d88e69fe74c74568bb532abc', 1627909686, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2215, 'Neutral pen large capacity giant can write neutral pen full needle tube one-in-one signature pen students with pen 0.5m gel pen school office', 'Neutral pen large capacity giant can write neutral pen full needle tube one-in-one signature pen students with pen 0.5m gel pen school office', 'Neutral pen large capacity giant can write neutral pen full needle tube one-in-one signature pen students with pen 0.5m gel pen school office', 3.20, 'https://cf.shopee.com.my/file/2fc174a12ea67374ad20ac2cdd067ac3', 1627909686, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2216, 'PENTEL Energel-X Retractable Gel Roller Pen (0.5mm / 0.7mm / 1.0mm)', 'PENTEL Energel-X Retractable Gel Roller Pen (0.5mm / 0.7mm / 1.0mm)', 'PENTEL Energel-X Retractable Gel Roller Pen (0.5mm / 0.7mm / 1.0mm)', 32.00, 'https://cf.shopee.com.my/file/e7d5466efdb170b491d8f1d964836820', 1627909686, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2217, 'cute carrot ball pen / Cute Gift / 0.5mm ball pen / pen mata bulat / ball pen cute / stationary / pen sekolah office', 'cute carrot ball pen / Cute Gift / 0.5mm ball pen / pen mata bulat / ball pen cute / stationary / pen sekolah office', 'cute carrot ball pen / Cute Gift / 0.5mm ball pen / pen mata bulat / ball pen cute / stationary / pen sekolah office', 1.90, 'https://cf.shopee.com.my/file/a63fa7a174c20277b8837a7e3ca12e34', 1627909686, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2219, 'inPods Littlefun Portable Colour Mini Tws Bluetooth5.0 Wireless Speaker Rechargeable superBass For Pc Laptop MobilePhone', 'inPods Littlefun Portable Colour Mini Tws Bluetooth5.0 Wireless Speaker Rechargeable superBass For Pc Laptop MobilePhone', 'inPods Littlefun Portable Colour Mini Tws Bluetooth5.0 Wireless Speaker Rechargeable superBass For Pc Laptop MobilePhone', 178.00, 'https://cf.shopee.com.my/file/ff661097bc098871db35c4acef940eee', 1627909686, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2220, 'HT Button Cap Screw - M5 x 6mm ~ 50mm (Coarse Thread Pitch 0.8mm) (High Tensile Socket Button Allen Bolt)', 'HT Button Cap Screw - M5 x 6mm ~ 50mm (Coarse Thread Pitch 0.8mm) (High Tensile Socket Button Allen Bolt)', 'HT Button Cap Screw - M5 x 6mm ~ 50mm (Coarse Thread Pitch 0.8mm) (High Tensile Socket Button Allen Bolt)', 2.00, 'https://cf.shopee.com.my/file/33a1fe2afa2faf29b76c989d7a29dd69', 1627909686, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2221, 'Adobe Photoshop 2021 v22.0.0.35 Full Version No Crack [LIFETIME] for Windows & Mac', 'Adobe Photoshop 2021 v22.0.0.35 Full Version No Crack [LIFETIME] for Windows & Mac', 'Adobe Photoshop 2021 v22.0.0.35 Full Version No Crack [LIFETIME] for Windows & Mac', 20.00, 'https://cf.shopee.com.my/file/74939345e096f676d5d3c74572e2c8d0', 1627909686, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2222, '0-9 Numbers Cake Toppers Happy Birthday Cute Crown Number Cake Flag Acrylic Cupcake Topper Birthday Party Cake', '0-9 Numbers Cake Toppers Happy Birthday Cute Crown Number Cake Flag Acrylic Cupcake Topper Birthday Party Cake', '0-9 Numbers Cake Toppers Happy Birthday Cute Crown Number Cake Flag Acrylic Cupcake Topper Birthday Party Cake', 8.40, 'https://cf.shopee.com.my/file/979157ae910a89ebd3352a1c9a53d0cc', 1627909686, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2224, '[ETUDE HOUSE] Etude House Color My Brows 0.7g', '[ETUDE HOUSE] Etude House Color My Brows 0.7g', '[ETUDE HOUSE] Etude House Color My Brows 0.7g', 120.00, 'https://cf.shopee.com.my/file/61338f31416e832f4b521f21536b3905', 1627909686, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2225, 'Resistor 100 ohm (Carbon - 0.25W)', 'Resistor 100 ohm (Carbon - 0.25W)', 'Resistor 100 ohm (Carbon - 0.25W)', 1.00, 'https://cf.shopee.com.my/file/ffcdbb4517a98a76536c502a037bdd35', 1627909686, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2226, 'Baju Baby Robocar Poli Newborn Baby Comfort Clothing set 0-12M Shirts Short Sleeve Long Pants Singlet Baju Baby Selesa', 'Baju Baby Robocar Poli Newborn Baby Comfort Clothing set 0-12M Shirts Short Sleeve Long Pants Singlet Baju Baby Selesa', 'Baju Baby Robocar Poli Newborn Baby Comfort Clothing set 0-12M Shirts Short Sleeve Long Pants Singlet Baju Baby Selesa', 139.30, 'https://cf.shopee.com.my/file/df28f4a49e1dcdd792dbce0c102dc3d2', 1627909686, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2227, 'Faber-Castell Grip X Ball Pen Metallic (0.5mm/0.7mm/1.0mm)', 'Faber-Castell Grip X Ball Pen Metallic (0.5mm/0.7mm/1.0mm)', 'Faber-Castell Grip X Ball Pen Metallic (0.5mm/0.7mm/1.0mm)', 11.00, 'https://cf.shopee.com.my/file/e8ec90cfd6bbff71a17e09d7e158f799', 1627909686, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2228, '-1.0 to -6.0 Power Cermin Mata Rabun Jauh Southeast Asia Fashion Polygon Transparent Frame Student Unisex Anti Blue Ray Glasses', '-1.0 to -6.0 Power Cermin Mata Rabun Jauh Southeast Asia Fashion Polygon Transparent Frame Student Unisex Anti Blue Ray Glasses', '-1.0 to -6.0 Power Cermin Mata Rabun Jauh Southeast Asia Fashion Polygon Transparent Frame Student Unisex Anti Blue Ray Glasses', 35.90, 'https://cf.shopee.com.my/file/c26baa2d5a2712abf7a2895d01e74a7b', 1627909686, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2229, '0.5Lt Tiger Brand Paint Remover Penanggal Cat Buang cat Remove Paint', '0.5Lt Tiger Brand Paint Remover Penanggal Cat Buang cat Remove Paint', '0.5Lt Tiger Brand Paint Remover Penanggal Cat Buang cat Remove Paint', 109.90, 'https://cf.shopee.com.my/file/1663676cae24152bafeec92730fcffee', 1627909686, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2230, '3pin Charger 5.7V 0.8A Nokia Small Pin Big Pin Micro USB Mini USB E1200 N70 3310', '3pin Charger 5.7V 0.8A Nokia Small Pin Big Pin Micro USB Mini USB E1200 N70 3310', '3pin Charger 5.7V 0.8A Nokia Small Pin Big Pin Micro USB Mini USB E1200 N70 3310', 47.50, 'https://cf.shopee.com.my/file/ff94d9110a6ebafa243fddb668331f24', 1627909686, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2231, 'ROBOCAR POLI Newborn Baby Clothes Eyelet Singlet Short Sleeve Long Sleeve Sleeveless Baju Berlubang 0-18 Bulan Baju Baby', 'ROBOCAR POLI Newborn Baby Clothes Eyelet Singlet Short Sleeve Long Sleeve Sleeveless Baju Berlubang 0-18 Bulan Baju Baby', 'ROBOCAR POLI Newborn Baby Clothes Eyelet Singlet Short Sleeve Long Sleeve Sleeveless Baju Berlubang 0-18 Bulan Baju Baby', 149.00, 'https://cf.shopee.com.my/file/4bb3c49057349955ebe2b1c7b86d8128', 1627909686, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2232, '[Malaysia STOCK] TUTUYA 0-3 Years SPECIAL Breathable Hole Antivirus Baby Kids Waterproof Dustproof Face Shield Cover Cap', '[Malaysia STOCK] TUTUYA 0-3 Years SPECIAL Breathable Hole Antivirus Baby Kids Waterproof Dustproof Face Shield Cover Cap', '[Malaysia STOCK] TUTUYA 0-3 Years SPECIAL Breathable Hole Antivirus Baby Kids Waterproof Dustproof Face Shield Cover Cap', 250.00, 'https://cf.shopee.com.my/file/9beb18da4e1b4e1c0415e00bb39b8b58', 1627909686, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2234, 'Enameled copper soldering wire 0.1mm 10m', 'Enameled copper soldering wire 0.1mm 10m', 'Enameled copper soldering wire 0.1mm 10m', 12.00, 'https://cf.shopee.com.my/file/568d79bc18b56c4e29d84fadaeb6e4dc', 1627909686, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2238, 'Buncho Mechanical lead 0.5 / 0.7mm', 'Buncho Mechanical lead 0.5 / 0.7mm', 'Buncho Mechanical lead 0.5 / 0.7mm', 10.00, 'https://cf.shopee.com.my/file/ca74597bee4a4f6202040b95087f388e', 1627909686, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2239, 'Activated EM Ready to Use 0.5L ~ 20L', 'Activated EM Ready to Use 0.5L ~ 20L', 'Activated EM Ready to Use 0.5L ~ 20L', 97.90, 'https://cf.shopee.com.my/file/498284c15b019549003e11da413d7a92', 1627909686, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2240, 'Boy fashion suit 0-6 tahun baju kemeja budak lelaki baju musim panas pantai corak daun + seluar 2pcs pakaian budak lelaki', 'Boy fashion suit 0-6 tahun baju kemeja budak lelaki baju musim panas pantai corak daun + seluar 2pcs pakaian budak lelaki', 'Boy fashion suit 0-6 tahun baju kemeja budak lelaki baju musim panas pantai corak daun + seluar 2pcs pakaian budak lelaki', 144.00, 'https://cf.shopee.com.my/file/58456f29ab7a99272751acfc96013687', 1627909686, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2241, 'Buncho Mechanical lead 0.5 / 0.7mm', 'Buncho Mechanical lead 0.5 / 0.7mm', 'Buncho Mechanical lead 0.5 / 0.7mm', 8.00, 'https://cf.shopee.com.my/file/d291b666e4767b2ab120be1815d267cd', 1627909686, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2242, 'LEXAR V40 USA 16GB / 32GB / 64GB USB2.0 USB PENDRIVE. SIMILAR TO DT100G3 DT100G4 CZ50 DTSWIVL BLADE HAYABUSA DTIG4 AH334', 'LEXAR V40 USA 16GB / 32GB / 64GB USB2.0 USB PENDRIVE. SIMILAR TO DT100G3 DT100G4 CZ50 DTSWIVL BLADE HAYABUSA DTIG4 AH334', 'LEXAR V40 USA 16GB / 32GB / 64GB USB2.0 USB PENDRIVE. SIMILAR TO DT100G3 DT100G4 CZ50 DTSWIVL BLADE HAYABUSA DTIG4 AH334', 119.50, 'https://cf.shopee.com.my/file/01a4de6e746395807f647dc3e867eb96', 1627909686, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2243, 'G\'Soft Lucky Clover | Retractable Needle Tip 0.5mm  BallPen | Black Red Blue Pen', 'G\'Soft Lucky Clover | Retractable Needle Tip 0.5mm  BallPen | Black Red Blue Pen', 'G\'Soft Lucky Clover | Retractable Needle Tip 0.5mm  BallPen | Black Red Blue Pen', 9.90, 'https://cf.shopee.com.my/file/e8c49e0d668cba264a29f18f5f0d87ca', 1627909686, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2245, 'LM. Creative Gel Pen Text Personality Black 0.5mm Student Dedicated Pen Exam Pen Office Sign Pen Ready Stock', 'LM. Creative Gel Pen Text Personality Black 0.5mm Student Dedicated Pen Exam Pen Office Sign Pen Ready Stock', 'LM. Creative Gel Pen Text Personality Black 0.5mm Student Dedicated Pen Exam Pen Office Sign Pen Ready Stock', 3.90, 'https://cf.shopee.com.my/file/89b4072eac8c0be8972e03c0566211f0', 1627909686, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2247, 'Hijab / Child / Baby / hijab / 0-3 Years Old / Sun Flower', 'Hijab / Child / Baby / hijab / 0-3 Years Old / Sun Flower', 'Hijab / Child / Baby / hijab / 0-3 Years Old / Sun Flower', 54.50, 'https://cf.shopee.com.my/file/55840a54dd12f1f8d6cee33a4c01959a', 1627909686, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2248, 'Faster Fantasy Colour Gel Pen 0.38mm Pen Tip - (1s/PCS)', 'Faster Fantasy Colour Gel Pen 0.38mm Pen Tip - (1s/PCS)', 'Faster Fantasy Colour Gel Pen 0.38mm Pen Tip - (1s/PCS)', 13.00, 'https://cf.shopee.com.my/file/50e8c50a1fec19fffba388bb7cbcdf1e', 1627909686, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2249, '[SmartHouse] Bunny Rabbit Cute Gel Pen Black Ink 0.5mm', '[SmartHouse] Bunny Rabbit Cute Gel Pen Black Ink 0.5mm', '[SmartHouse] Bunny Rabbit Cute Gel Pen Black Ink 0.5mm', 3.90, 'https://cf.shopee.com.my/file/ae4ebcb630b17960a31046f47e79fdef', 1627909686, 1, 1);
INSERT INTO `xy_goods_list` VALUES (2250, 'PHILIPS AVENT mini pacifier  0-2 month - newborn', 'PHILIPS AVENT mini pacifier  0-2 month - newbo